<?php
use \HIK\Framework\AjaxResponse;

function sms_login_send_mobile_ajax_handler() {
	$response = new AjaxResponse();

	// get mboile field
	$mobile = '';
	if ( isset( $_POST['mobile'] ) ) {
		$mobile = sanitize_text_field( $_POST['mobile'] );
	}

	// convert persian and arabic characters to english
	$mobile = convert_persian_number_to_english( $mobile );

	// validate mobile field value
	if ( ! is_mobile_number( $mobile ) ) {
		$response->send( false, 'شماره موبایل نامعتبر است', 1 );
	}

    /* Send sms */
    global $wpdb;
    $tbl = $wpdb->prefix . 'amlak_verify_code';
    $length = absint( op_am['tedadarghamcode'] );
    if ( ! $length ) {
        $length = 4;
    }
    $code_min = absint( str_repeat( '1', $length) );
    $code_max = absint( str_repeat( '9', $length) );
    $code = rand( $code_min, $code_max);
    $send = sendEmailOrSMSAmlak( $code, $mobile, 'register' );
    // wp_die( $ );
    if ( $send ) {
        $time = 60 * op_am['expire_time_auth'];
        $wpdb->insert($tbl, [
            'code' => $code,
            'user' => $mobile,
            'time_create' => current_time("Y-m-d H:i:s"),
            'expire_time' => wp_date("Y-m-d H:i:s", time() + $time),
        ]);

        if ($wpdb->last_error) {
            $response->send( false, 'در هنگام ذخیره کد خطایی رخ داده است لطفا مجدد تلاش بفرمایید' );
        }
    } else {
        $response->send( false, 'خطا در ارسال پیام' );
    }

	$response->send( true );
}
add_action( 'wp_ajax_nopriv_sms_login_send_mobile', 'sms_login_send_mobile_ajax_handler' );