<?php
function zarinpal_pay($price, $method, $callback, $post_id)
{
    session_start();
    require_once("zarinpal_function.php");

    $MerchantID = op_am['merchent_id_zarin'];
    $Amount = $price;
    $Description = op_am['desc_zarin'];
    $Email = "";
    $Mobile = "";
    $CallbackURL = add_query_arg(['method' => $method, 'iranamlak_post' => $post_id, 'c_page' => $callback], $callback);
    $ZarinGate = false;
    $SandBox = op_am['test_zarinpal'] ?? false;

    $zp = new zarinpal();
    $result = $zp->request($MerchantID, $Amount, $Description, $Email, $Mobile, $CallbackURL, $SandBox, $ZarinGate);

    if (isset($result["Status"]) && $result["Status"] == 100) {
        global $wpdb;
        if ($method == 'packages') {
            global $wpdb;
            $table_name = $wpdb->prefix . 'iranamlak_orders_packages';
            $wpdb->insert($table_name,[
                'user_id'=>wp_get_current_user()->ID,
                'price'=>$_POST['price'],
                'number_adv'=>$_POST['number_adv'],
                'number_forosh'=>$_POST['number_forosh'],
                'number_rahnejare'=>$_POST['number_rahnejare'],
                'number_ejarerozane'=>$_POST['number_ejarerozane'],
                'pack_name'=>$_POST['pack_name'],
                'dargah'=>'زرین پال',
                'status' => 'pending',
                'token' => $result['Authority'],
                'time_create' => current_time('Y-m-d H:i:s'),
                'time_update' => current_time('Y-m-d H:i:s'),

            ]);
        } else {
            if ($method == 'moshaver'){
                $post_id = 0;
                $_SESSION['name_moshaver_amlak'] = $_POST['name_moshaver_amlak'];
            }
            $table_name = $wpdb->prefix . 'iranamlak_orders';
            $wpdb->insert($table_name, [
                'user_id' => wp_get_current_user()->ID,
                'post_id' => $post_id,
                'price' => $Amount,
                'method' => $method,
                'dargah' => 'زرین پال',
                'status' => 'pending',
                'token' => $result['Authority'],
                'time_create' => current_time('Y-m-d H:i:s'),
                'time_update' => current_time('Y-m-d H:i:s'),

            ]);
        }

        // Success and redirect to pay
        $zp->redirect($result["StartPay"]);
    } else {
        session_start();
        $_SESSION['payment'] = ['status' => 'error', 'msg' => [
            "خطا در ایجاد تراکنش",
            "کد خطا :" . $result["Status"],
            "تفسیر و علت خطا : " . $result["Message"],
        ]];
        wp_redirect($callback);
    }


}

function zarinpal_verify($id, $auth, $calback)
{
    session_start();
    require_once("zarinpal_function.php");


    global $wpdb;
    if($_GET['method'] == 'packages'){
        $table_name = $wpdb->prefix . 'iranamlak_orders_packages';
    }else{
        $table_name = $wpdb->prefix . 'iranamlak_orders';
    }

    $order = $wpdb->get_row("SELECT * FROM $table_name WHERE token='$auth'");

    $MerchantID = op_am['merchent_id_zarin'];
    $Amount = $order->price;
    $ZarinGate = false;
    $SandBox = op_am['test_zarinpal'] ?? false;;


    $zp = new zarinpal();
    $result = $zp->verify($MerchantID, $Amount, $SandBox, $ZarinGate);

    if (isset($result["Status"]) && $result["Status"] == 100) {

        session_start();
        $_SESSION['payment'] = ['status' => 'success', 'msg' => [
            "تراکنش با موفقیت انجام شد",
            "مبلغ پرداختی : " . number_format($result["Amount"]) . ' تومان',
            "کد پیگیری : " . $result["RefID"],
        ]];

        if($_GET['method'] == 'packages'){
            $wpdb->update($table_name, [
                'status' => 'paid',
                'traking_code' => $result["RefID"],
                'time_update' => current_time('Y-m-d H:i:s'),],
                ['token' => $result["Authority"]]
            );
            if(!$wpdb->last_error){
                $user_id = wp_get_current_user()->ID;


                $pack_num = get_user_meta($user_id,'iranamlak_package',true) ? get_user_meta($user_id,'iranamlak_package',true) : 0;
                $new_num = $pack_num + intval($order->number_adv);

                $pack_num_forosh = get_user_meta($user_id,'iranamlak_package_forosh',true) ? get_user_meta($user_id,'iranamlak_package_forosh',true) : 0;
                $new_num_forosh = $pack_num_forosh + intval($order->number_forosh);

                $pack_num_rahnejare = get_user_meta($user_id,'iranamlak_package_rahnejare',true) ? get_user_meta($user_id,'iranamlak_package_rahnejare',true) : 0;
                $new_num_rahnejare = $pack_num_rahnejare + intval($order->number_rahnejare);

                $pack_num_ejarerozane = get_user_meta($user_id,'iranamlak_package_ejarerozane',true) ? get_user_meta($user_id,'iranamlak_package_ejarerozane',true) : 0;
                $new_num_ejarerozane = $pack_num_ejarerozane + intval($order->number_ejarerozane);


                update_user_meta($user_id,'iranamlak_package',$new_num);
                update_user_meta($user_id,'iranamlak_package_forosh',$new_num_forosh);
                update_user_meta($user_id,'iranamlak_package_rahnejare',$new_num_rahnejare);
                update_user_meta($user_id,'iranamlak_package_ejarerozane',$new_num_ejarerozane);
                
                do_action('amlak_notification_packages',[$order->pack_name,$order->price]);
            }

        }else{
            $wpdb->update($table_name, [
                'status' => 'paid',
                'traking_code' => $result["RefID"],
                'time_update' => current_time('Y-m-d H:i:s'),],
                ['token' => $result["Authority"]]
            );
            if ($order->method == 'tamdid') {
                $my_post = array(
                    'ID' => $id,
                    'post_status' => 'publish',
                    'post_date' => date('Y-m-d H:i:s'),
                    'post_date_gmt' => gmdate('Y-m-d H:i:s'),
                    'post_modified' => date('Y-m-d H:i:s'),
                );
                wp_update_post($my_post);
            } elseif ($order->method == 'feature') {
                update_post_meta($order->post_id, 'special', 1);
            } elseif ($order->method == 'fast') {
                update_post_meta($order->post_id, 'fast', 1);
            } elseif ($order->method == 'send_agahi') {
                $data = array(
                    'ID' => $order->post_id,
                    'post_status' => op_am['enteshar'],
                );
                wp_update_post( $data );
            } elseif ($order->method == 'moshaver') {
                update_user_meta(wp_get_current_user()->ID,'name_moshaver_amlak', $_SESSION['name_moshaver_amlak']);
                $user = new WP_User(wp_get_current_user()->ID);
                if(!current_user_can('administrator')){
                    update_user_meta(wp_get_current_user()->ID,'verify__moshaver_iranamlak',current_time('Y-m-d H:i:s'));
                    //$user->set_role('moshaver');
                }
                unset($_SESSION['name_moshaver_amlak']);
            }
            do_action('amlak_notification_'.$_GET['method'],$order->post_id);
        }



    } else {
        session_start();
        $_SESSION['payment'] = ['status' => 'error', 'msg' => [
            "خطا در ایجاد تراکنش",
            "کد خطا :" . $result["Status"],
            "تفسیر و علت خطا : " . $result["Message"],
        ]];
    }

    wp_redirect($calback);
    exit();

}