const defaultMapZoom=iranamlak_js_object.map_defult_zoom
var previousLat=iranamlak_js_object.map_defult_lat
var previousLng=iranamlak_js_object.map_defult_lng
var lastSearchRegion=''
var postIds=[]
var timerId=null
// var openedPopupId=''

var myMap = new L.Map('map', {
    key: iranamlak_js_object.map_api_key_web,
    maptype: iranamlak_js_object.map_theme ,
    poi: true,
    traffic: false,
    center: [previousLat, previousLng],
    zoom: defaultMapZoom,
    zoomSnap: 0.5,
    zoomDelta:0.5
});
var markersGroup=L.layerGroup().addTo(myMap)

myMap.on('moveend', function (){
    let center=myMap.getCenter()
    let centerLat=center.lat
    let centerLng=center.lng
    if (Math.abs(previousLat-centerLat)>=0.5 || Math.abs(previousLng-centerLng)>=0.5 || postIds.length===0) {
        previousLat=centerLat
        previousLng=centerLng
        fetchPlaces()
    }
})

myMap.on('popupclose', function (e){
    e.popup._source.setIcon(getBlueMarker())
})

function fetchPlaces(){
    jQuery('.loading').fadeIn();
    fetch(script_data.ajax_url, {
        method:'post',
        body:getRequestBody()
    })
        .then(res=>{
            if (res.ok)
                return res.json()
        })
        .then(json=>{
            for (let jsonElement of json) {
                if (postIds.includes(jsonElement['post_id']))
                    continue;
                postIds.push(jsonElement['post_id'])
                createMarker(jsonElement)
            }
            // disablePopupMouseHover()
        })
    jQuery('.loading').fadeOut();
}

function getRequestBody(){
    let fd=new FormData()

    let north=myMap.getBounds().getNorth()
    let south=myMap.getBounds().getSouth()
    let east=myMap.getBounds().getEast()
    let west=myMap.getBounds().getWest()

    fd.set('action', 'get_iranamlak_map_data')
    fd.set('north', north)
    fd.set('south', south)
    fd.set('east', east)
    fd.set('west', west)
    fd.set('transaction-type', document.getElementById('transaction-type').value)
    fd.set('estate-type', document.getElementById('estate-type').value)
    fd.set('min-price', document.getElementById('min-price').value)
    fd.set('max-price', document.getElementById('max-price').value)
    fd.set('min-rent', document.getElementById('min-rent').value)
    fd.set('max-rent', document.getElementById('max-rent').value)
    fd.set('min-deposit', document.getElementById('min-deposit').value)
    fd.set('max-deposit', document.getElementById('max-deposit').value)

    return fd
}

function createMarker(data) {
    let marker=L.marker([data['lat'], data['lng']]).addTo(markersGroup)

    let content=`
<a href="${data['post_link']}" >
<div id="${data['post_link']}" class="map_popup_div">
<img src="${data['image_url']}">
<span>
<h2>${data['title']}</h2>
<li><ul>متراژ  </ul> <ol> ${data['metrazh']}</ol></li>
`;
    if (data['transaction_type']==='خرید و فروش')
        content+=`<li><ul>قیمت  </ul> <ol> ${priceWithCommas(data['price'])} </ol></li>`;
    else if (data['transaction_type']==='رهن و اجاره')
        content+=`<li><ul>اجاره </ul> <ol>  ${priceWithCommas(data['rant'])}</ol></li><li><ul>ودیعه </ul> <ol> ${priceWithCommas(data['deposit'])}</ol></li>`;
    else if (data['transaction_type']==='اجاره روزانه')
        content+=`<li><ul>اجاره </ul> <ol>  ${priceWithCommas(data['price'])}</ol></li>`;
    content+='</span></div></a>'

    marker.bindPopup(content)


if (iranamlak_js_object.map_fileshowmap=='2') {

    marker.on('mouseover', ()=>{marker.openPopup()})
    marker.on('mouseout', ()=>{
        setTimeout(()=>{
            if (data['post_link']===openedPopupId)
                return
            marker.closePopup()
         }, 300)
    })

} else {
    marker.on('click', function () {
        if(marker.getPopup().isOpen())
            marker.setIcon(getRedMarker())
    })
} 


}

function priceWithCommas(price) {
    if(price===null)
        return '';
        
    return price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

function clearMap() {
    markersGroup.clearLayers()
    postIds=[]
    document.querySelector('.leaflet-pane.leaflet-marker-pane').innerHTML=''
    document.querySelector('.leaflet-pane.leaflet-shadow-pane').innerHTML=''
}

function searchRegion(){
    let place=document.getElementById('region').value;
    if (place===lastSearchRegion){
        clearMap()
        fetchPlaces()
        return
    }
    let lat=myMap.getCenter().lat
    let lng=myMap.getCenter().lng
    fetch(`https://api.neshan.org/v1/search?term=${place}&lat=${lat}&lng=${lng}`, {
        headers:{
            'Api-Key':iranamlak_js_object.map_api_key_services
        }
    })
        .then(res=>{
            if (res.ok)
                return res.json()
        })
        .then(json=>{
            if (json['count']<1) {
                alert('منظقه موردنظر یافت نشد')
                return
            }
            clearMap()
            lastSearchRegion=place
            let firstPlace=json['items'][0]
            myMap.setView([firstPlace['location']['y'], firstPlace['location']['x']], defaultMapZoom)
        })
}
document.getElementById('search-btn').addEventListener('click', searchRegion)

fetchPlaces()

function getRedMarker()
{
    var CustomIcon = L.Icon.extend({});
    return new CustomIcon({ iconUrl: iranamlak_js_object.map_marker_hover });
}

function getBlueMarker()
{
    var CustomIcon = L.Icon.extend({
        options:{
            iconSize:L.Icon.Default.prototype.options.iconSize,
            iconAnchor:L.Icon.Default.prototype.options.iconAnchor,
            popupAnchor:L.Icon.Default.prototype.options.popupAnchor
        }
    });
    return new CustomIcon({ iconUrl: iranamlak_js_object.map_marker });
}

// function disablePopupMouseHover()
// {
//     let popupContainer=document.querySelectorAll('div.leaflet-pane.leaflet-popup-pane')
//     for (let popupDiv of popupContainer) {
//         popupDiv.addEventListener('mouseover', function (e) {
//             e.stopPropagation()
//             let div=this.getElementsByClassName('map_popup_div')[0]
//             openedPopupId=div.getAttribute('id')
//         })
//         popupDiv.addEventListener('mouseleave', function (e) {
//             e.stopPropagation()
//             openedPopupId='';
//             myMap.closePopup()
//         })
//     }
// }

document.getElementById('transaction-type').addEventListener('change', function (e) {
    let value=this.value
    switch (value) {
        case "":{
            document.getElementById('min-price-container').style.display='block'
            document.getElementById('min-rent-container').style.display='none'
            document.getElementById('min-deposit-container').style.display='none'
            document.getElementById('max-price-container').style.display='block'
            document.getElementById('max-rent-container').style.display='none'
            document.getElementById('max-deposit-container').style.display='none'
        }break
        case "خرید و فروش":{
            document.getElementById('min-price-container').style.display='block'
            document.getElementById('min-rent-container').style.display='none'
            document.getElementById('min-deposit-container').style.display='none'
            document.getElementById('max-price-container').style.display='block'
            document.getElementById('max-rent-container').style.display='none'
            document.getElementById('max-deposit-container').style.display='none'
        }break
        case "رهن و اجاره":{
            document.getElementById('min-price-container').style.display='none'
            document.getElementById('min-rent-container').style.display='block'
            document.getElementById('min-deposit-container').style.display='block'
            document.getElementById('max-price-container').style.display='none'
            document.getElementById('max-rent-container').style.display='block'
            document.getElementById('max-deposit-container').style.display='block'
        }break
        case "اجاره روزانه":{
            document.getElementById('min-price-container').style.display='none'
            document.getElementById('min-rent-container').style.display='block'
            document.getElementById('min-deposit-container').style.display='none'
            document.getElementById('max-price-container').style.display='none'
            document.getElementById('max-rent-container').style.display='block'
            document.getElementById('max-deposit-container').style.display='none'
        }break
    }
})


if (iranamlak_js_object.map_type==2){
// با تغییر مقادیر
document.getElementById('transaction-type').addEventListener('change', autoFetch)
document.getElementById('estate-type').addEventListener('change', autoFetch)
document.getElementById('min-price').addEventListener('keyup', autoFetch)
document.getElementById('max-price').addEventListener('keyup', autoFetch)
document.getElementById('min-rent').addEventListener('keyup', autoFetch)
document.getElementById('max-rent').addEventListener('keyup', autoFetch)
document.getElementById('min-deposit').addEventListener('keyup', autoFetch)
document.getElementById('max-deposit').addEventListener('keyup', autoFetch)

}
if (iranamlak_js_object.map_type==1){
// با دکمه
document.getElementById('search-btn').addEventListener('click', autoFetch)


}





function autoFetch() {
    if (timerId!==null)
        clearTimeout(timerId)

    timerId=setTimeout(function (){
        clearMap()
        fetchPlaces()
        timerId=null
    }, 1000)
}

document.getElementById('mantaghe_select').addEventListener('change', moveMap)
function moveMap(e) {
    let value=document.getElementById('mantaghe_select').value
    let lat=value.split('_')[0]
    let lng=value.split('_')[1]
    let zoom=value.split('_')[2]
    clearMap()
    myMap.setView([lat, lng], zoom)
}