jQuery(document).ready(function ($) {
    $('body').append(`<div class="modal" id="modal" tabindex="-1" style="z-index:9999999999;">
  <div class="modal-dialog modal-dialog-scrollable modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">پیشنهادات</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="margin: unset;"></button>
      </div>
      <div class="modal-body" style="text-align: center">
        <div class="spinner-grow text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
      </div>
      <div class="modal-footer">
      </div>
    </div>
  </div>
</div>`)
    var modal = new bootstrap.Modal(document.getElementById("modal"));

    $('.show-auction-popup').on('click', function (e){
        e.preventDefault()
        let id=$(this).attr('id')
        id=id.replace('auction-', '');

        $.ajax({
            url:script_data.ajax_url+'?action=get_auction_bids&post_id='+id,
            type:'GET',
            dataType:'json',
            success:function (res) {
                $('.modal-body').html('')
                let table=$('<table></table>')
                $(table).addClass('table')
                $(table).addClass('table-striped')
                let thead=$('<thead></thead>')
                let tbody=$('<tbody></tbody>')
                let tr=$('<tr></tr>')
                let rowTd=$('<td>ردیف</td>')
                let nameTd=$('<td>نام و نام خانوادگی</td>')
                let usernameTd=$('<td>نام کاربری</td>')
                let priceTd=$('<td>قیمت پیشنهادی</td>')
                let detailsTd=$('<td>توضیحات</td>')
                $(tr).append(rowTd)
                $(tr).append(nameTd)
                $(tr).append(usernameTd)
                $(tr).append(priceTd)
                $(tr).append(detailsTd)
                $(thead).append(tr)
                $(table).append(thead)
                let i=0
                for (let row of res) {
                    let tr=$('<tr></tr>')
                    let rowTd=$(`<td>${++i}</td>`)
                    let nameTd=$(`<td><a href="${row['profile_link']}">${row['name']}</a></td>`)
                    let usernameTd=$(`<td>${row['user_name']}</td>`)
                    let priceTd=$(`<td>${row['price'].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")} تومان</td>`)
                    let detailsTd=$(`<td style="width: 40%;">${row['details']}</td>`)
                    $(tr).append(rowTd)
                    $(tr).append(nameTd)
                    $(tr).append(usernameTd)
                    $(tr).append(priceTd)
                    $(tr).append(detailsTd)
                    $(tbody).append(tr)
                }
                $(table).append(tbody)
                $('.modal-body').append(table)
            }
        })

        $('.modal-body').html('<div class="spinner-grow text-primary" role="status">\n            <span class="visually-hidden">Loading...</span>\n        </div>')
        modal.show()
    })

})