<div id="comments-wrap">
<?php
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

	if ( post_password_required() ) { ?>
		<p class="nocomments">برای مشاهده‌ی دیدگاه‌ها باید رمز نوشته را وارد کنید.</p>
	<?php
		return;
	}
?>

<?php if ( have_comments() ) : ?>

<ol class="commentlist">
	<?php wp_list_comments(); ?>
</ol>

	<div class="comments-navigation">
		<div class="alignleft"><?php previous_comments_link() ?></div>
					<div class="alignright"><?php next_comments_link() ?></div>
	</div>

<?php // End Comments ?>

 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ('open' == $post->comment_status) : ?>
		<!-- If comments are open, but there are no comments. -->
 
	 <?php else : ?>
		<p>موقتا امکان ارسال دیدگاه وجود ندارد</p>
	<?php endif; ?>
<?php endif; ?>


<!-- You can start editing here. -->
<?php // Begin Comments & Trackbacks ?>


<?php if ('open' == $post->comment_status) : ?>

<div id="respond">

<div class="cancel-comment-reply">
	<small><?php cancel_comment_reply_link(); ?></small>
</div>

<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
<p>ابتدا <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>">وارد شوید</a> تا بتوانید دیدگاهی ارسال کنید</p>

<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
<?php if (op_am['state_rating'] & get_post_type($post->ID) == 'state'): ?>
	<label class="ratingcenter" for="rating">امتیازدهی</label>
	<fieldset class="comments-rating">
		<span class="rating-container">
			<?php for ( $i = 5; $i >= 1; $i-- ) : ?>
				<input type="radio" id="rating-<?php echo esc_attr( $i ); ?>" name="rating" value="<?php echo esc_attr( $i ); ?>" /><label for="rating-<?php echo esc_attr( $i ); ?>"><?php echo esc_html( $i ); ?></label>
			<?php endfor; ?>
			<input type="radio" id="rating-0" class="star-cb-clear" name="rating" value="0" /><label for="rating-0">0</label>
		</span>
	</fieldset>
<?php endif; ?>

<?php if (op_am['blog_rating'] & get_post_type($post->ID) == 'post'): ?>
	<label class="ratingcenter" for="rating">امتیازدهی</label>
	<fieldset class="comments-rating">
		<span class="rating-container">
			<?php for ( $i = 5; $i >= 1; $i-- ) : ?>
				<input type="radio" id="rating-<?php echo esc_attr( $i ); ?>" name="rating" value="<?php echo esc_attr( $i ); ?>" /><label for="rating-<?php echo esc_attr( $i ); ?>"><?php echo esc_html( $i ); ?></label>
			<?php endfor; ?>
			<input type="radio" id="rating-0" class="star-cb-clear" name="rating" value="0" /><label for="rating-0">0</label>
		</span>
	</fieldset>
<?php endif; ?>

	<?php if (is_user_logged_in())  : ?>
    <?php echo $user_identity; ?> عزیز . دیدگاه خود را درباره این  نوشته برای ما ارسال کنید .
	<?php else : ?>
	<div style="width:100%;margin-bottom:10px">لطفا دیدگاه خود را درباره این نوشته برای ما ارسال کنید</div>
	<input type="text" placeholder="نام و نام خانوادگی" name="author" id="author" class="textarea" size="28" tabindex="1" />
	<input type="text" name="email" id="email" placeholder="ایمیل" size="28" tabindex="2" class="textarea" />
	<?php endif; ?>
	<textarea placeholder="ما عاشق خواندن نظرات شما هستیم" name="comment" id="comment" cols="60" rows="10" tabindex="4" class="textarea"></textarea>
	<?php comment_id_fields(); ?>
	<?php do_action('comment_form', $post->ID); ?>
	<input name="submit" id="submit" type="submit" tabindex="5" value="ارسال" class="Cbutton" />
</form>
<?php endif; ?>
</div>
<?php else : ?>
<p>موقتا امکان ارسال دیدگاه وجود ندارد</p>
<?php endif; ?>
</div>


