<?php
CSF::createSection($prefix, array(
    'id' => 'set_auth',
    'title' => 'ورود / ثبت نام',
    'icon' => 'fas fa-angle-left',
    'fields' => array(

        array(
            'id' => 'active_auth_all',
            'type' => 'switcher',
            'default'   => 'true',
            'title' => 'ورود و ثبت نام',
            'desc' =>  'مشخص نمائید بطور کلی امکان ثبت نام در وب سایت شما امکان پذیر باشد یا خیر',
            'text_width' => 80
        ),


        array(
            'id' => 'active_mobile_auth',
            'type' => 'switcher',
            'title' => 'فعال سازی ثبت نام و ورود با شماره همراه',
            'desc' => 'در حالت عادی ثبت نام با ایمیل صورت میگیرد .اگر میخواهید ورود و ثبت نام در سایت با شماره همراه صورت بگیرد این گذینه را فعال و سپس تنظیمات مربوطه را انجام دهید . ',
            'text_width' => 80,
            'dependency' => array('active_auth_all', '==', 'true', 'visible'),
        ),

        array(
            'type'    => 'notice',
            'id'      => 'noting',
            'style'   => 'warning',
            'content' => '<strong>لطفا با مراجعه به تب تنظیمات پیامک > تنظیمات درگاه ، تنظیمات مربوطه را اعمال نمایید .</strong>',
            'dependency' =>
                array('active_auth_all|active_mobile_auth|panel_sms', '==|==|==', 'true|true|' , 'set_auth|set_auth|set_sms_dargah'),
        ),

        array(
            'id' => 'reglogin_fast',
            'type' => 'switcher',
            'title' => 'ورود / ثبت نام سریع',
            'desc'  => 'با فعال سازی ثبت نام سریع ، تنها با وارد کردن شماره تلفن میتوان ورود یا ثبت نام کرد',
            'text_width' => 80,
            'dependency' =>
                array('active_auth_all|active_mobile_auth', '==|==', 'true|true' , '' , 'visible'),
        ),

        array(
            'id' => 'active_auth_with_popop',
            'type' => 'switcher',
            'title' => 'لینک ثبت نام پاپ',
            'desc'  => 'در صورت فعال سازی "ورود و ثبت نام سریع" این گذینه قابل فعال شدن خواهد بود و در صورت فعالسازی کاربر با کلیک بر روی ورود / ثبت نام ، پنجره ورود و ثبت نام بصورت پاپ اپ برایش نمایش داده خواهد شد',
            'text_width' => 80,
            'dependency' =>
                array('active_auth_all|active_mobile_auth|reglogin_fast', '==', 'true|true|true' ,'', 'visible'),
        ),

        array(
            'id' => 'active_reg_for_all',
            'type' => 'switcher',
            'text_width' => 80 ,
            'title' => 'فعالسازی انتخاب نوع کاربر در ثبت نام',
            'dependency' =>
                array('reglogin_fast|active_auth_all', '==|==', 'false|true'),
        ),

        array(
            'id' => 'active_disposable_auth',
            'type' => 'switcher',
            'title' => 'فعال سازی بخش ورود با رمز یک بار مصرف',
            'text_width' => 80 ,
            'dependency' =>
                array('active_auth_all|reglogin_fast', '==', 'true|false', '', 'visible'),
        ),


        array(
          'type'    => 'subheading',
          'content' => 'قوانین و مقرارات',
        ),

        array(
            'id' => 'active_terms_auth',
            'type' => 'switcher',
            'title' => 'فعال سازی قوانین و مقررات در ثبت نام',
            'text_width' => 80,
            'dependency' =>
                array('active_auth_all|reglogin_fast', '==', 'true|false', '', 'visible'),
        ),

        array(
            'id' => 'active_terms_auth_descriptioan',
            'type' => 'wp_editor',
            'title' => 'متن قوانین و مقررات ',
            'default'       => 'قوانین و مقررات را خوانده ام و قبول دارم ',
            'dependency' =>
                array('active_auth_all|reglogin_fast|active_terms_auth', '==|==|==', 'true|false|true' , '', 'visible'),
        ),
        
        

        array(
          'type'    => 'subheading',
          'content' => 'تنظیمات تایید ایمیل در ثبت نام',
        ),
        
        
        array(
            'id' => 'active_valid_email_auth',
            'type' => 'switcher',
            'title' => 'فعال سازی تایید ایمیل در فرم ثبت نام',
            'text_width' => 80,
            'dependency' =>
                array('active_auth_all|active_mobile_auth', '==|==', 'true|false', '', 'visible'),
        ),
        array(
            'id' => 'subject_verify_mail_reg',
            'type' => 'text',
            'title' => 'عنوان ایمیل تایید عضویت',
            'desc' => 'ک متن مانند تایید ایمیل در وب سایت ایران املاک وارد نمایید',
            'dependency' =>
                array('active_auth_all|active_valid_email_auth|active_mobile_auth', '==|==|==', 'true|true|false' ,'', 'visible'),
        ),

        array(
            'id' => 'text_valid_email_auth',
            'type' => 'wp_editor',
            'title' => 'متن ایمیل تایید عضویت',
            'desc' => 'در متن به جای کد تایید عبارت {code} را وارد نمایید',
            'dependency' =>
                array('active_auth_all|active_valid_email_auth|active_mobile_auth', '==|==|==', 'true|true|false', '', 'visible'),
        ),


        array(
          'type'    => 'subheading',
          'content' => 'تنظیمات ایمیل فراموشی رمز عبور',
        ),

        array(
            'id' => 'subject_verify_mail_lost',
            'type' => 'text',
            'title' => 'متن ایمیل بازیابی رمز عبور',
            'desc' => 'یک متنمانند تایید ایمیل در وب سایت ایران املاک وارد نمایید',
            'dependency' =>
                array('active_auth_all|active_mobile_auth', '==|==', 'true|false', '', 'visible'),
        ),

        array(
            'id' => 'text_valid_email_auth_lost',
            'type' => 'wp_editor',
            'title' => 'متن تایید ایمیل  در بازایابی رمز عبور',
            'desc' => 'در متن به جای کد تایید عبارت {code} را وارد نمایید',
            'dependency' =>
                array('active_auth_all|active_mobile_auth', '==|==', 'true|false', '', 'visible'),
        ),


        array(
          'type'    => 'subheading',
          'content' => 'تنظیمات ایمیل رمز یکبار مصرف',
        ),

        array(
            'id' => 'subject_verify_mail_disposable',
            'type' => 'text',
            'title' => 'موضوع تایید ایمیل در ورود یک بار مصرف',
            'desc' => 'یک متن مانند تایید ایمیل در وب سایت ایران املاک وارد نمایید',
            'dependency' =>
                array('active_auth_all|active_mobile_auth', '==|==', 'true|false', '', 'visible'),
        ),

        array(
            'id' => 'text_valid_email_auth_disposable',
            'type' => 'wp_editor',
            'title' => 'متن تایید ایمیل  ورود یک بار مصرف',
            'desc' => 'در متن به جای کد تایید عبارت {code} را وارد نمایید',
            'dependency' =>
                array('active_auth_all|active_mobile_auth', '==|==', 'true|false', '', 'visible'),
        ),



)));
