<?php



//
// Create page options
////////////////////////////////////////////////////////////

$createquerystate = 'createquerystate';
CSF::createMetabox($createquerystate, array(
      'title'          => 'تنظیمات صفحه',
      'post_type' => array( 'post', 'page' ),
      'context'   => 'side',
      'id'             => 'querycreatorpage',
      'data_type'      => 'serialize',
));
CSF::createSection( $createquerystate, array(
  'fields' => array(
        array(
            'id' => 'header',
            'type' => 'select',
            'title' => 'نوع سربرگ',
            'default' => 'header2',
            'options' => array(
                'header2' => 'هدر بدون فیلتر جستجو',
                'header' => 'هدر دارای فیلتر جستجو',
                'header3' => 'هدر دارای نقشه',
            ),
        ),
        array(
            'id' => 'kadr',
            'type' => 'select',
            'title' => 'کادر صفحه',
            'default' => 'havekadr',
            'options' => array(
                'havekadr' => 'صفحه دارای کادر',
                'nokadr' => 'صفحه بدون کادر',
                'elementor' => 'صفحه مخصوص المنتور',
            ),
        ),
        array(
            'id' => 'breadcrumb-me',
            'type' => 'select',
            'title' => 'نمایش عنوان صفحه',
            'default' => '' ,
            'options' => array(
                '' => 'پیشفرض',
                'false' => 'نمایش داده نشود',
                'title' => 'فقط نمایش عنوان',
                'small' => 'خطی - کوچک',
                'big' => 'تمام صفحه - بزرگ',
            ),
        ),
    array(
      'type'    => 'submessage',
      'style'   => 'info',
      'content' => 'این تنظیمات فقط برای صفحات دلخواه اعمال میگردد و در صفحاتی که در تنظیمات عمومی انتخاب کردید تاثیر ندارد ! ', 
    ),

)));






//
// Create state taxonomy options
////////////////////////////////////////////////////////////

$maptax = '_maptax';

CSF::createTaxonomyOptions( $maptax, array(
  'taxonomy' => 'state_category',
      'id'             => 'mapfortax',
      'data_type'      => 'serialize',
));

CSF::createSection( $maptax, array(
  'fields' => array(

    array(
            'id' => 'picture',
            'type' => 'media',
            'title' => 'تصویر',
    ),

    array(
      'id'            => 'map_tax_default',
      'type'          => 'map',
      'title'         => 'موقعیت روی نقشه',
      'default'       => array(
        'latitude'    => '32.220237415852715',
        'longitude'   => '53.36527569099229',
        'zoom'        => '4',
      )
    ),

)));





//
// Create taxonomy pic options
////////////////////////////////////////////////////////////

$pictax = '_pictax';
CSF::createTaxonomyOptions( $pictax, array(
      'taxonomy' => 'category',
      'id'             => 'pictax',
      'data_type'      => 'serialize',
));
CSF::createSection( $pictax, array(
  'fields' => array(
    array(
            'id' => 'picture',
            'type' => 'media',
            'title' => 'تصویر',
    ),
)));







//
// Shortcodes
////////////////////////////////////////////////////////////

$iranamlakshortcodes = 'iranamlakshortcodes';
CSF::createShortcoder( $iranamlakshortcodes, array(
  'button_title'   => 'ایران املاک',
  'select_title'   => '--انتخاب کد کوتاه--',
  'insert_title'   => 'قرار دادن کد کوتاه',
  'show_in_editor' => true,
));



//
// Create shortcode buttom
////////////////////////////////////////////////////////////

CSF::createSection( $iranamlakshortcodes, array(
  'title'     => 'کد کوتاه ساخت دکمه',
  'view'      => 'normal',
  'shortcode' => 'iranamlak_buttom',
  'fields' => array(

    array(
        'id' => 'title',
        'type' => 'text',
        'title' => 'عنوان',
    ),
    array(
        'id' => 'description',
        'type' => 'textarea',
        'title' => 'توضیحات',
    ),
    array(
        'id' => 'link',
        'type' => 'link',
        'title' => 'لینک',
    ),

    array(
        'id' => 'color1',
        'type' => 'color',
        'title' => 'رنگ پیش زمینه',
    ),

    array(
        'id' => 'color2',
        'type' => 'color',
        'title' => 'رنگ متن',
    ),

    array(
        'id' => 'myclass',
        'type' => 'text',
        'title' => 'کلاس دلخاه',
    ),

)));






//
// Create shortcode states sade
////////////////////////////////////////////////////////////

CSF::createSection( $iranamlakshortcodes, array(
  'title'     => 'نمایش آگهی ها ( ساده )',
  'view'      => 'normal',
  'shortcode' => 'iranamlak',
  'fields'    => array(


                array(
                    'id'    => 'kadr',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'کادر',
                ),

                array(
                    'id'    => 'chaharchoob',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'چهارچوب',
                ),
                
                array(
                    'id' => 'onvan',
                    'type' => 'text',
                    'title' => 'عنوان',
                ),

                array(
                    'id' => 'onvantype',
                    'type' => 'select',
                    'title' => 'استایل نمایش عنوان',
                    'options' => array(
                        '0' => 'عدم نمایش عنوان',
                        '1' => 'استایل وسط',
                        '2' => 'استایل چپ',
                    ),
                ),

                array(
                    'id' => 'numstates',
                    'type' => 'number',
                    'desc' => 'برای نمایش نامحدود خالی بگذارید' ,
                    'title' => 'تعداد آگهی ها',
                ),

                array(
                  'id' => 'style_query_shortcode',
                  'type' => 'select',
                  'title' => 'نوع نمایش',
                  'default' => 'style1',
                  'options' => array(
                        'style1' => 'حاالت با تصویر یک',
                        'style2' => 'حالت با تصویر دو',
                        'style3' => 'حالت لیست با تصویر',
                        'style4' => 'حالت لیست بدون تصویر',
                    ),
                ),
        
                array(
                  'id'      => 'mantaghe',
                  'type'    => 'select',
                  'chosen' => true,
                  'title'   => 'انتخاب منطقه',
                  'options'   => 'get_tax_state_iranamlak_ops',
                ),
    
                array(
                    'id' => 'moamele',
                    'type' => 'select',
                    'title' => 'نوع معامله',
                    'options' => array(
                        '' => '--همه--',
                        'خرید و فروش' => 'خرید و فروش',
                        'رهن و اجاره' => 'رهن و اجاره',
                        'اجاره روزانه' => 'اجاره روزانه',
                    ),
                ),

                array(
                    'id' => 'melk',
                    'type' => 'select',
                    'title' => 'نوع ملک',
                    'options' => array(
                        '' => '--همه--',
                        'آپارتمان' => 'آپارتمان',
                        'خانه و ویلا' => 'خانه و ویلا',
                        'زمین' => 'زمین و کلنگی',
                        'اداری و تجاری' => 'اداری و تجاری',
                    ),
                ),

                array(
                    'id' => 'vijhe',
                    'type' => 'select',
                    'title' => 'ویژه',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما ویژه ها را نمایش بده',
                        '0' => 'حنما ویژه ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'fast',
                    'type' => 'select',
                    'title' => 'فوری',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما فوری ها را نمایش بده',
                        '0' => 'حنما فوری ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'mosharekat',
                    'type' => 'select',
                    'title' => 'مشارکت در ساخت',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما مشارکت در ساخت ها را نمایش بده',
                        '0' => 'حتما مشارکت در ساخت ها را نمایش نده',
                    ),
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'moaveze',
                    'type' => 'select',
                    'title' => 'معاوضه',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما معاوضه ها را نمایش بده',
                        '0' => 'حتما معاوضه ها را نمایش نده',
                    ),
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'pishforosh',
                    'type' => 'select',
                    'title' => 'پیش فروش',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما پیش فروش ها را نمایش بده',
                        '0' => 'حتما پیش فروش ها را نمایش نده',
                    ),
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'kohpaye',
                    'type' => 'select',
                    'title' => 'کوهپایه',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما کوهپایه ها را نمایش بده',
                        '0' => 'حتما کوهپایه ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'saheli',
                    'type' => 'select',
                    'title' => 'ساحلی',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما ساحلی ها را نمایش بده',
                        '0' => 'حتما ساحلی ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'shahraki',
                    'type' => 'select',
                    'title' => 'شهرکی',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما شهرکی ها را نمایش بده',
                        '0' => 'حتما شهرکی ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'pricefrom',
                    'type' => 'number',
                    'title' => 'قیمت از',
                    'unit'  => 'تومان'
                ),

                array(
                    'id' => 'priceto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'قیمت تا',
                    'unit'  => 'تومان'
                ),


                array(
                    'id' => 'ejarefrom',
                    'type' => 'number',
                    'title' => 'قیمت اجاره از',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'رهن و اجاره') ,
                    ),
                ),

                array(
                    'id' => 'ejareto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'قیمت اجاره تا',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'رهن و اجاره') ,
                    ),
                ),

                array(
                    'id' => 'ejarerozanefrom',
                    'type' => 'number',
                    'title' => 'قیمت اجاره روزانه از',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'اجاره روزانه') ,
                    ),
                ),

                array(
                    'id' => 'ejarerozaneto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'قیمت اجاره روزانه تا',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'اجاره روزانه') ,
                    ),
                ),

                array(
                    'id' => 'rahnfrom',
                    'type' => 'number',
                    'title' => 'قیمت رهن از',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'رهن و اجاره') ,
                    ),
                ),

                array(
                    'id' => 'rahnto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'قیمت رهن تا',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'رهن و اجاره') ,
                    ),
                ),

                array(
                    'id' => 'metrazhfrom',
                    'type' => 'number',
                    'title' => 'متراژ از',
                    'unit'  => 'متر',
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'metrazhto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'متراژ تا',
                    'unit'  => 'متر',
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'salsakht',
                    'type'  => 'checkbox',
                    'title' => 'سال ساخت',
                    'options'   => 'get_senbana_iranamlak_ops',
                ),

                array(
                    'id' => 'emkanat',
                    'type'  => 'checkbox',
                    'title' => 'امکانات',
                    'options'   => 'get_emkanat_iranamlak_ops',
                ),



)));







//
// Create shortcode states slide
////////////////////////////////////////////////////////////

CSF::createSection( $iranamlakshortcodes, array(
  'title'     => 'نمایش آگهی ها ( اسلایدشو )',
  'view'      => 'normal',
  'shortcode' => 'iranamlak_state_slide',
  'fields'    => array(


                array(
                    'id'    => 'kadr',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'کادر',
                ),

                array(
                    'id'    => 'chaharchoob',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'چهارچوب',
                ),
                
                array(
                    'id' => 'onvan',
                    'type' => 'text',
                    'title' => 'عنوان',
                ),

                array(
                    'id' => 'onvantype',
                    'type' => 'select',
                    'title' => 'استایل نمایش عنوان',
                    'options' => array(
                        '0' => 'عدم نمایش عنوان',
                        '1' => 'استایل وسط',
                        '2' => 'استایل چپ',
                    ),
                ),


                array(
                    'id' => 'numstates',
                    'type' => 'number',
                    'desc' => 'برای نمایش نامحدود خالی بگذارید' ,
                    'title' => 'تعداد آگهی ها',
                ),

        
                array(
                  'id'      => 'mantaghe',
                  'type'    => 'select',
                  'chosen' => true,
                  'title'   => 'انتخاب منطقه',
                  'options'   => 'get_tax_state_iranamlak_ops',
                ),
    
                array(
                    'id' => 'moamele',
                    'type' => 'select',
                    'title' => 'نوع معامله',
                    'options' => array(
                        '' => '--همه--',
                        'خرید و فروش' => 'خرید و فروش',
                        'رهن و اجاره' => 'رهن و اجاره',
                        'اجاره روزانه' => 'اجاره روزانه',
                    ),
                ),

                array(
                    'id' => 'melk',
                    'type' => 'select',
                    'title' => 'نوع ملک',
                    'options' => array(
                        '' => '--همه--',
                        'آپارتمان' => 'آپارتمان',
                        'خانه و ویلا' => 'خانه و ویلا',
                        'زمین' => 'زمین و کلنگی',
                        'اداری و تجاری' => 'اداری و تجاری',
                    ),
                ),

                array(
                    'id' => 'vijhe',
                    'type' => 'select',
                    'title' => 'ویژه',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما ویژه ها را نمایش بده',
                        '0' => 'حنما ویژه ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'fast',
                    'type' => 'select',
                    'title' => 'فوری',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما فوری ها را نمایش بده',
                        '0' => 'حنما فوری ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'mosharekat',
                    'type' => 'select',
                    'title' => 'مشارکت در ساخت',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما مشارکت در ساخت ها را نمایش بده',
                        '0' => 'حتما مشارکت در ساخت ها را نمایش نده',
                    ),
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'moaveze',
                    'type' => 'select',
                    'title' => 'معاوضه',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما معاوضه ها را نمایش بده',
                        '0' => 'حتما معاوضه ها را نمایش نده',
                    ),
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'pishforosh',
                    'type' => 'select',
                    'title' => 'پیش فروش',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما پیش فروش ها را نمایش بده',
                        '0' => 'حتما پیش فروش ها را نمایش نده',
                    ),
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'kohpaye',
                    'type' => 'select',
                    'title' => 'کوهپایه',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما کوهپایه ها را نمایش بده',
                        '0' => 'حتما کوهپایه ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'saheli',
                    'type' => 'select',
                    'title' => 'ساحلی',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما ساحلی ها را نمایش بده',
                        '0' => 'حتما ساحلی ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'shahraki',
                    'type' => 'select',
                    'title' => 'شهرکی',
                    'options' => array(
                        '' => '--همه--',
                        '1' => 'حتما شهرکی ها را نمایش بده',
                        '0' => 'حتما شهرکی ها را نمایش نده',
                    ),
                ),

                array(
                    'id' => 'pricefrom',
                    'type' => 'number',
                    'title' => 'قیمت از',
                    'unit'  => 'تومان'
                ),

                array(
                    'id' => 'priceto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'قیمت تا',
                    'unit'  => 'تومان'
                ),


                array(
                    'id' => 'ejarefrom',
                    'type' => 'number',
                    'title' => 'قیمت اجاره از',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'رهن و اجاره') ,
                    ),
                ),

                array(
                    'id' => 'ejareto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'قیمت اجاره تا',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'رهن و اجاره') ,
                    ),
                ),

                array(
                    'id' => 'ejarerozanefrom',
                    'type' => 'number',
                    'title' => 'قیمت اجاره روزانه از',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'اجاره روزانه') ,
                    ),
                ),

                array(
                    'id' => 'ejarerozaneto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'قیمت اجاره روزانه تا',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'اجاره روزانه') ,
                    ),
                ),

                array(
                    'id' => 'rahnfrom',
                    'type' => 'number',
                    'title' => 'قیمت رهن از',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'رهن و اجاره') ,
                    ),
                ),

                array(
                    'id' => 'rahnto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'قیمت رهن تا',
                    'unit'  => 'تومان',
                    'dependency' =>array(
                        array('moamele', 'any', 'رهن و اجاره') ,
                    ),
                ),

                array(
                    'id' => 'metrazhfrom',
                    'type' => 'number',
                    'title' => 'متراژ از',
                    'unit'  => 'متر',
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'metrazhto',
                    'type' => 'number',
                    'desc' => 'برای نا محدود لطفا خالی بگذارید' ,
                    'title' => 'متراژ تا',
                    'unit'  => 'متر',
                    'dependency' =>array(
                        array('moamele', 'any', 'خرید و فروش') ,
                    ),
                ),

                array(
                    'id' => 'salsakht',
                    'type'  => 'checkbox',
                    'title' => 'سال ساخت',
                    'options'   => 'get_senbana_iranamlak_ops',
                ),

                array(
                    'id' => 'emkanat',
                    'type'  => 'checkbox',
                    'title' => 'امکانات',
                    'options'   => 'get_emkanat_iranamlak_ops',
                ),



)));



//
// Create shortcode moshaverin
////////////////////////////////////////////////////////////

CSF::createSection( $iranamlakshortcodes, array(
  'title'     => 'نمایش مشاورین',
  'view'      => 'normal',
  'shortcode' => 'iranamlakmoshaverin',
  'fields'    => array(

                array(
                    'id'    => 'kadr',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'کادر',
                ),

                array(
                    'id'    => 'chaharchoob',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'چهارچوب',
                ),
                
                
                array(
                    'id' => 'onvan',
                    'type' => 'text',
                    'title' => 'عنوان',
                ),

                array(
                    'id' => 'onvantype',
                    'type' => 'select',
                    'title' => 'استایل نمایش عنوان',
                    'options' => array(
                        '0' => 'عدم نمایش عنوان',
                        '1' => 'استایل وسط',
                        '2' => 'استایل چپ',
                    ),
                ),
    
                array(
                    'id' => 'tartib',
                    'type' => 'select',
                    'title' => 'ترتیب',
                    'options' => array(
                        'display_name' => 'نام',
                        'registered' => 'تاریخ ثبت نام',
                    ),
                ),

                array(
                    'id' => 'halat',
                    'type' => 'select',
                    'title' => 'حالت',
                    'options' => array(
                        'sade' => 'ساده',
                        'slide' => 'اسلاید',
                    ),
                ),
                
                array(
                    'id' => 'chinesh',
                    'type' => 'select',
                    'title' => 'ترتیب',
                    'options' => array(
                        'ASC' => 'از اخر به اول',
                        'DESC' => 'از اول به اخر',
                    ),
                ),

                array(
                    'id' => 'tedad',
                    'type' => 'number',
                    'desc' => 'برای نمایش نامحدود خالی بگذارید' ,
                    'title' => 'تعداد',
                ),

                array(
                    'id' => 'tedadslide',
                    'type' => 'number',
                    'title' => 'تعداد در هر اسلاید',
                    'dependency' =>array(
                        array('halat', 'any', 'slide') ,
                    ),
                ),

                array(
                    'id' => 'style',
                    'type' => 'select',
                    'title' => 'استایل',
                    'options' => array(
                        'style1-moshaverin' => 'یک ردیف',
                        'style2-moshaverin' => 'دو ردیف',
                        'style3-moshaverin' => 'سه ردیف',
                    ),
                ),
                
                array(
                    'id' => 'morebuttom',
                    'type' => 'select',
                    'title' => 'موارد بیشتر',
                    'options' => array(
                        '' => 'عدم نمایش موارد بیشتر',
                        'pagenumber' => 'صفحه بندی',
                        'morebuttom' => 'دکمه موارد بیشتر',
                    ),
                ),

)));


//
// create shortcode karmandan
////////////////////////////////////////////////////////////

CSF::createSection( $iranamlakshortcodes, array(
  'title'     => 'نمایش کارمندان',
  'view'      => 'normal',
  'shortcode' => 'iranamlakkarmandan',
  'fields'    => array(


                array(
                    'id'    => 'kadr',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'کادر',
                ),

                array(
                    'id'    => 'chaharchoob',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'چهارچوب',
                ),
                
                array(
                    'id' => 'onvan',
                    'type' => 'text',
                    'title' => 'عنوان',
                ),

                array(
                    'id' => 'onvantype',
                    'type' => 'select',
                    'title' => 'استایل نمایش عنوان',
                    'options' => array(
                        '0' => 'عدم نمایش عنوان',
                        '1' => 'استایل وسط',
                        '2' => 'استایل چپ',
                    ),
                ),

                array(
                    'id' => 'tartib',
                    'type' => 'select',
                    'title' => 'ترتیب',
                    'options' => array(
                        'display_name' => 'نام',
                        'registered' => 'تاریخ ثبت نام',
                    ),
                ),

                array(
                    'id' => 'halat',
                    'type' => 'select',
                    'title' => 'حالت',
                    'options' => array(
                        'sade' => 'ساده',
                        'slide' => 'اسلاید',
                    ),
                ),
                
                array(
                    'id' => 'chinesh',
                    'type' => 'select',
                    'title' => 'ترتیب',
                    'options' => array(
                        'ASC' => 'از اخر به اول',
                        'DESC' => 'از اول به اخر',
                    ),
                ),

                array(
                    'id' => 'tedad',
                    'type' => 'number',
                    'desc' => 'برای نمایش نامحدود خالی بگذارید' ,
                    'title' => 'تعداد',
                ),

                array(
                    'id' => 'tedadslide',
                    'type' => 'number',
                    'title' => 'تعداد در هر اسلاید',
                    'dependency' =>array(
                        array('halat', 'any', 'slide') ,
                    ),
                ),

                array(
                    'id' => 'style',
                    'type' => 'select',
                    'title' => 'استایل',
                    'options' => array(
                        'style1-moshaverin' => 'یک ردیف',
                        'style2-moshaverin' => 'دو ردیف',
                        'style3-moshaverin' => 'سه ردیف',
                    ),
                ),
                
                array(
                    'id' => 'showall',
                    'title' => 'دکمه نمایش همه',
                    'type'  => 'switcher',
                    'text_width' => 80,
                ),


)));





//
// Create shortcode blog
////////////////////////////////////////////////////////////

CSF::createSection( $iranamlakshortcodes, array(
  'title'     => 'اخبار و مقالات',
  'view'      => 'normal',
  'shortcode' => 'iranamlakblog',
  'fields'    => array(

                array(
                    'id'    => 'kadr',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'کادر',
                ),

                array(
                    'id'    => 'chaharchoob',
                    'type'  => 'switcher',
                    'text_width' => 80,
                    'title' => 'چهارچوب',
                ),

                array(
                    'id' => 'onvan',
                    'type' => 'text',
                    'title' => 'عنوان',
                ),

                array(
                    'id' => 'onvantype',
                    'type' => 'select',
                    'title' => 'استایل نمایش عنوان',
                    'options' => array(
                        '0' => 'عدم نمایش عنوان',
                        '1' => 'استایل وسط',
                        '2' => 'استایل چپ',
                    ),
                ),

                array(
                    'id' => 'halat',
                    'type' => 'select',
                    'title' => 'حالت',
                    'options' => array(
                        'sade' => 'ساده',
                        'slide' => 'اسلاید',
                    ),
                ),
            

                array(
                    'id' => 'tedad',
                    'type' => 'number',
                    'desc' => 'برای نمایش نامحدود خالی بگذارید' ,
                    'title' => 'تعداد',
                ),

                array(
                    'id' => 'tedadslide',
                    'type' => 'number',
                    'title' => 'تعداد در هر اسلاید',
                    'dependency' =>array(
                        array('halat', 'any', 'slide') ,
                    ),
                ),

                array(
                    'id' => 'style',
                    'type' => 'select',
                    'title' => 'استایل',
                    'options' => array(
                        'style1moshaverin' => 'یک ردیف',
                        'style2moshaverin' => 'دو ردیف',
                        'style3moshaverin' => 'سه ردیف',
                    ),
                ),
                
                array(
                    'id' => 'showall',
                    'title' => 'دکمه نمایش همه',
                    'type'  => 'switcher',
                    'text_width' => 80,
                ),


)));



//
// Create profile options
////////////////////////////////////////////////////////////

$profileaccess = 'profileaccess';
CSF::createProfileOptions( $profileaccess, array(
  'data_type' => 'serialize'
) );

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
if ($user_id) {
$user = get_user_by('id', $user_id);
if (  current_user_can('administrator') && $user && in_array( 'karmand',  $user->roles ) )  {


CSF::createSection( $profileaccess, array(
  'title'  => 'دسترسی ها',
  'id'     => 'access',
  'fields' => array(

    array(
      'id'    => 'page-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به برگه ها',
    ),
    
    array(
      'id'    => 'post-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به نوشته ها',
    ),
    
    array(
      'id'    => 'ads-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به آگهی ها',
    ),

    array(
      'id'    => 'user-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به کاربران',
    ),
    
    array(
      'id'    => 'payam-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به پیام ها',
    ),
    
    array(
      'id'    => 'mpm-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به پیام های مدیریت',
    ),

    array(
      'id'    => 'taghaaza-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به تقاضا ها',
    ),
    
    array(
      'id'    => 'pardakht-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به پرداخت ها',
    ),
    
    array(
      'id'    => 'comments-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به نظرات',
    ),

    array(
      'id'    => 'plugins-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به افزونه ها',
    ),
    
    array(
      'id'    => 'user-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به کاربران',
    ),

    array(
      'id'    => 'options-access',
      'type'  => 'switcher',
      'text_width' => 80,
      'title' => 'دسترسی به تنظیمات سایت',
    ),



)));

}}