<?php
/**
 * Plugin Name:       Ultimate Wordpress Chat (uwacmz)
 * Plugin URI:        https://www.zhaket.com/web/ultimate-whatsapp-chat
 * Description:       The most powerful Wordpress chat and support plugin to create an excellent chat and support and sales system
 * Version:           5.6
 * Author:            Maghzewp
 * Author URI:        https://www.zhaket.com/web/ultimate-whatsapp-chat
 * Text Domain:       uwacmz
 * Domain Path:       /languages
 */
if (!defined('ABSPATH')) exit;
define('UWACMZ_URL', plugin_dir_url(__FILE__));
define('UWACMZ_PATH', plugin_dir_path(__FILE__));
global $uwacmz_version;
global $uwacmz_handler;
$uwacmz_version = '5.6';
function uwacmz_load_admin_style() {
    wp_register_style('uwacmz-style', plugin_dir_url(__FILE__) . 'admin/css/admin-style.css' , array(), '5.6');
    wp_enqueue_style('uwacmz-style');
    
    wp_enqueue_script('tabs', plugin_dir_url(__FILE__) . 'assets/js/tab.js' , array('jquery'), '5.6');

}
add_action('admin_enqueue_scripts', 'uwacmz_load_admin_style');


function uwacmz_load_front_style() {
    if (!is_rtl()) { // if LTR
        wp_register_style('uwacmz-ltr-public-style', plugin_dir_url(__FILE__) . 'assets/css/ltr-public.css' , array(), '5.6');
        wp_enqueue_style('uwacmz-ltr-public-style');
    } else { // if RTL
        wp_register_style('uwacmz-rtl-public-style', plugin_dir_url(__FILE__) . 'assets/css/rtl-public.css' , array(), '5.6');
        wp_enqueue_style('uwacmz-rtl-public-style');
    }
    
    wp_register_style('uwacmz-icons', plugin_dir_url(__FILE__) . 'assets/css/all.css');
    wp_enqueue_style('uwacmz-icons');
    
    wp_enqueue_script('front-ajax', plugin_dir_url(__FILE__) . 'assets/js/front-ajax.js' , array('jquery'), '5.6');

    wp_localize_script('front-ajax','uwacmz',[
        'ajaxurl'=>admin_url('admin-ajax.php'),
        '_nonce'=>wp_create_nonce()
        ]);
        
    wp_register_script('uwac-widget', plugin_dir_url(__FILE__) . 'assets/js/widget.js' , array('jquery'), '5.6');
    wp_enqueue_script('uwac-widget');


}

add_action('wp_enqueue_scripts', 'uwacmz_load_front_style');


function uwacmz_icon_admin() {
    wp_register_style('uwacmz-icons-admin', plugin_dir_url(__FILE__) . 'assets/css/all.css');
    wp_enqueue_style('uwacmz-icons-admin');
}
add_action('admin_enqueue_scripts', 'uwacmz_icon_admin');
function register_uwacmz_widget($widgets_manager) {
    require_once (__DIR__ . '/elementor-widgets/uwacmz-widget.php');

    $widgets_manager->register(new \Elementor_Uwacmz_Widget());
}
add_action('elementor/widgets/register', 'register_uwacmz_widget');
function add_widget_categories($elements_manager) {
    $elements_manager->add_category('mzwp-elements', ['title' => esc_html__('Support Chat Elements', 'uwacmz'), 'icon' => 'fas fa-brain', ]);
}
add_action('elementor/elements/categories_registered', 'add_widget_categories');
function uwacmz_activate_plugin() {
    require_once plugin_dir_path(__FILE__) . 'inc/uwacmz-activator.php';

}
register_activation_hook(__FILE__, 'uwacmz_activate_plugin');
register_deactivation_hook(__FILE__, 'uwacmz_deactivate_plugin');
require plugin_dir_path(__FILE__) . 'inc/functions.php';

require plugin_dir_path(__FILE__) . 'inc/account/uwacmz-shortcode-handler.php';
require plugin_dir_path(__FILE__) . 'inc/account/uwacmz-shortcode-pic-handler.php';
require plugin_dir_path(__FILE__) . 'inc/faq/uwacmz-shortcode-faq-handler.php';

function uwacmz_lang() {
    load_plugin_textdomain('uwacmz', false, basename(dirname(__FILE__)) . '/languages/');
}
add_action('plugins_loaded', 'uwacmz_lang');

function myplugin_update_db_check() {
    global $uwacmz_version;
    if ( get_site_option( 'uwacmz_version' ) != $uwacmz_version ) {
        uwacmz_activate_plugin();
    }
}
add_action( 'plugins_loaded', 'myplugin_update_db_check' );