<?php
/**
 * convert farsi and arabic numbers to english
 *
 * @param  string $str
 *
 * @return string
 */
function convert_persian_number_to_english( $str ) {
	$persian_numbers = array( '۰','۹','۸','۷','۶','۵','۴','۳','۲','۱' );
	$english_numbers = array( '0','9','8','7','6','5','4','3','2','1' );

	return str_replace( $persian_numbers, $english_numbers, $str);
}

/**
 * Check String be a mobile number
 *
 * @param string $mobile_number string must be checked
 * @return mixed|boolean false for failed and array of matched for success
 */
function is_mobile_number( $mobile_number ) {
	$matches = null;
	return preg_match( '/^\b09(\d{9})\b$/', $mobile_number, $matches );
}


function send_verification_code_sms( $mobile, $code ) {
    $curl = curl_init();

    curl_setopt_array( $curl, [
        CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "mobile": "' . $mobile . '",
            "parameters": [
                {
                    "name":"code",
                    "value":"' . $code . '"
                }
            ]
        }',
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Accept: text/plain',
            'x-api-key: '
        ],
    ] );

    $response = curl_exec($curl);

    curl_close($curl);
    wp_die( var_dump( $response ));
}

// add_action( 'init', function(){
//     send_verification_code_sms( '09053343831', '24256' );
// });