<?php
use \HIK\Framework\AjaxResponse;

function sms_login_send_code_ajax_handler() {
	$response = new AjaxResponse();

    // get mboile field
	$mobile = '';
	if ( isset( $_POST['mobile'] ) ) {
		$mobile = sanitize_text_field( $_POST['mobile'] );
	}

	// convert persian and arabic characters to english
	$mobile = convert_persian_number_to_english( $mobile );

	// validate mobile field value
	if ( ! is_mobile_number( $mobile ) ) {
		$response->send( false, 'شماره موبایل نامعتبر است', 1 );
	}

    // get code field
	$code = '';
	if ( isset( $_POST['code'] ) ) {
		$code = sanitize_text_field( $_POST['code'] );
	}

	// convert persian and arabic characters to english
	$code = convert_persian_number_to_english( $code );

    if ( ! $code ) {
        $response->send( false, 'کدی ارسال نشده است' );
    }

    $check  = checkActiveCodeIranamlak( $mobile, $code );
    if( ! $check ) {
        $response->send( false, "کد نا معتبر است" );
    }

    // delete code
    global $wpdb;
    $tbl = $wpdb->prefix . 'amlak_verify_code';
    $wpdb->delete( $tbl, ['id' => $check->id ] );

    $user = get_user_by( 'login', $mobile );
    if ( ! $user ) {
    	$user_id = wp_create_user( $mobile, wp_generate_password() );
		if ( is_wp_error( $user_id ) ) {
			$response->send( false, "خطا در ثبت کاربر" );
		}

		update_user_meta( $user_id, 'phone', $mobile );
    } else {
    	$user_id = $user->ID;
    }

    wp_clear_auth_cookie();
	wp_set_current_user ( $user_id );
	wp_set_auth_cookie  ( $user_id );
    

    // wp_redirect(get_page_link(op_am['select-page-login']));

    $response->send( true );
}
add_action( 'wp_ajax_nopriv_sms_login_send_code', 'sms_login_send_code_ajax_handler' );