<?php
if (! class_exists('SmsIR_VerificationCode')) {
    class SmsIR_VerificationCode
    {

        protected function getAPIVerificationCodeUrl()
        {
            return "api/VerificationCode";
        }

        protected function getApiTokenUrl()
        {
            return "api/Token";
        }

        public function __construct($APIKey, $SecretKey, $APIURL)
        {
            $this->APIKey = $APIKey;
            $this->SecretKey = $SecretKey;
            $this->APIURL = $APIURL;
        }

        public function verificationCode($Code, $MobileNumber)
        {
            $token = $this->_getToken($this->APIKey, $this->SecretKey);
            if ($token != false) {
                $postData = array(
                    'Code' => $Code,
                    'MobileNumber' => $MobileNumber,
                );

                $url = $this->APIURL.$this->getAPIVerificationCodeUrl();
                $VerificationCode = $this->_execute($postData, $url, $token);
                $object = json_decode($VerificationCode);

                $result = false;
                if (is_object($object)) {
                    $result = $object->Message;
                } else {
                    $result = false;
                }

            } else {
                $result = false;
            }
            return $result;
        }

        private function _getToken()

        {
            $postData = array(
                'UserApiKey' => $this->APIKey,
                'SecretKey' => $this->SecretKey,
                'System' => 'php_rest_v_2_0'
            );
            $postString = json_encode($postData);

            $ch = curl_init($this->APIURL.$this->getApiTokenUrl());
            curl_setopt(
                $ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json'
                )
            );
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);

            $result = curl_exec($ch);
            curl_close($ch);

            $response = json_decode($result);

            $resp = false;
            $IsSuccessful = '';
            $TokenKey = '';
            if (is_object($response)) {
                $IsSuccessful = $response->IsSuccessful;
                if ($IsSuccessful == true) {
                    $TokenKey = $response->TokenKey;
                    $resp = $TokenKey;
                } else {
                    $resp = false;
                }
            }
            return $resp;
        }

        private function _execute($postData, $url, $token)
        {
            $postString = json_encode($postData);

            $ch = curl_init($url);

            curl_setopt(
                $ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'x-sms-ir-secure-token: '.$token
                )
            );
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);

            $result = curl_exec($ch);
            curl_close($ch);

            return $result;
        }
    }
}

//-------------------------------------------------------------------------
//----------------------------- By template ----------------------------
//-------------------------------------------------------------------------

if (! class_exists('SmsIR_UltraFastSend')) {
    class SmsIR_UltraFastSend
    {

        protected function getAPIUltraFastSendUrl()
        {
            return "api/UltraFastSend";
        }

        protected function getApiTokenUrl()
        {
            return "api/Token";
        }

        public function __construct($APIKey, $SecretKey, $APIURL)
        {
            $this->APIKey = $APIKey;
            $this->SecretKey = $SecretKey;
            $this->APIURL = $APIURL;
        }

        public function ultraFastSend($data)
        {
            $token = $this->_getToken($this->APIKey, $this->SecretKey);
            if ($token != false) {
                $postData = $data;

                $url = $this->APIURL.$this->getAPIUltraFastSendUrl();
                $UltraFastSend = $this->_execute($postData, $url, $token);

                $object = json_decode($UltraFastSend);

                $result = false;
                if (is_object($object)) {
                    $result = $object->Message;
                } else {
                    $result = false;
                }
            } else {
                $result = false;
            }
            return $result;
        }

        private function _getToken()

        {
            $postData = array(
                'UserApiKey' => $this->APIKey,
                'SecretKey' => $this->SecretKey,
                'System' => 'php_rest_v_2_0'
            );
            $postString = json_encode($postData);

            $ch = curl_init($this->APIURL.$this->getApiTokenUrl());
            curl_setopt(
                $ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json'
                )
            );
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);

            $result = curl_exec($ch);
            curl_close($ch);

            $response = json_decode($result);

            $resp = false;
            $IsSuccessful = '';

            $TokenKey = '';

            if (is_object($response)) {
                $IsSuccessful = $response->IsSuccessful;
                if ($IsSuccessful == true) {

                    $TokenKey = $response->TokenKey;
                    $resp = $TokenKey;
                } else {
                    $resp = false;
                }
            }
            return $resp;
        }

        private function _execute($postData, $url, $token)
        {
            $postString = json_encode($postData);

            $ch = curl_init($url);
            curl_setopt(
                $ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'x-sms-ir-secure-token: '.$token
                )
            );
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);

            $result = curl_exec($ch);
            curl_close($ch);

            return $result;
        }
    }
}


if($method == 'register'){
    $temp =trim(op_am['code_reg_sms_ir']);
    $param =  [
        ["Parameter" =>'code',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'lost_pass'){
    $temp =trim(op_am['code_lost_sms_ir']);
    $param =  [
        ["Parameter" =>'code',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'disposable'){
    $temp =trim(op_am['code_disposable_sms_ir']);
    $param =  [
        ["Parameter" =>'code',
            "ParameterValue" => $code,
        ]
    ];
}


if($method == 'after_send_adv_user'){
    $temp =trim(op_am['code_after_send_adv_user_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'after_send_adv_admin'){
    $temp =trim(op_am['code_after_send_adv_admin_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'after_publish_adv_user'){
    $temp =trim(op_am['code_after_verify_adv_user_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'active_notif_after_reject_adv_user'){
    $temp =trim(op_am['code_after_reject_adv_user_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'after_fast_adv_user'){
    $temp =trim(op_am['code_after_fast_adv_user_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'after_fast_adv_admin'){
    $temp =trim(op_am['code_after_fast_adv_admin_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}


if($method == 'after_feature_adv_user'){
    $temp =trim(op_am['code_after_feature_adv_user_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'after_feature_adv_admin'){
    $temp =trim(op_am['code_after_feature_adv_admin_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'after_tamdid_adv_user'){
    $temp =trim(op_am['code_after_tamdid_adv_user_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'after_tamdid_adv_admin'){
    $temp =trim(op_am['code_after_tamdid_adv_admin_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'after_expired_adv_user'){
    $temp =trim(op_am['code_after_expired_adv_user_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method == 'before_expired_adv_user'){
    $temp =trim(op_am['code_before_expired_adv_user_sms_ir']);
    $param =  [
        ["Parameter" =>'title',
            "ParameterValue" => $code,
        ]
    ];
}

if($method=='after_package_user'){
    $param =  [
        ["Parameter" =>'name',
            "ParameterValue" => $name],
        ["Parameter" =>'price',
            "ParameterValue" => $price],
    ];

    $temp =trim(op_am['code_notif_pack_user_sms_ir']);
}

if($method=='after_package_admin'){
    $param =  [
        ["Parameter" =>'name',
            "ParameterValue" => $name],
        ["Parameter" =>'price',
            "ParameterValue" => $price],
    ];

    $temp =trim(op_am['code_notif_pack_admin_sms_ir']);
}








if($method=='after_moshaver_user'){
    $param =  [
        ["Parameter" =>'name',
            "ParameterValue" => $name],
        ["Parameter" =>'family',
            "ParameterValue" => $family],
        ["Parameter" =>'moshaver',
            "ParameterValue" => $moshaver],
    ];

    $temp =trim(op_am['code_notif_moshaver_user_sms_ir']);
}

if($method=='after_moshaver_admin'){
    $param =  [
        ["Parameter" =>'name',
            "ParameterValue" => $name],
        ["Parameter" =>'family',
            "ParameterValue" => $family],
        ["Parameter" =>'moshaver',
            "ParameterValue" => $moshaver],
    ];
    $temp =trim(op_am['code_notif_moshaver_admin_sms_ir']);
}





try {
    date_default_timezone_set("Asia/Tehran");

    // your sms.ir panel configuration
    $APIKey = html_entity_decode(trim(op_am['api_key_sms_ir']));
    $SecretKey = html_entity_decode(trim(op_am['secret_key_sms_ir']));
    $APIURL = "https://ws.sms.ir/";
    // message data
    $data = array(
        "ParameterArray" => $param,
        "Mobile" =>  $To,
        "TemplateId" => $temp,
    );

    $SmsIR_UltraFastSend = new SmsIR_UltraFastSend($APIKey, $SecretKey, $APIURL);
    $UltraFastSend = $SmsIR_UltraFastSend->ultraFastSend($data);
    if($UltraFastSend != 'your verification code is sent'){
        return false;
    }else{
        return true;
    }

} catch (Exeption $e) {
    return false;
}