<?php
//
// این بخش سبز رنگ راهنمایی شما برای بانک صادرات میباشد . 
//  اگر op_am['dargahbank'] = 'saderat'تنظیمات زیر اعمال میشود .

// دو مورد زیر کنترل پنل دارند . 
// ترمینال آیدی ( TID ) = op_am['terminal_saderatat'];
// کد پذیرنده ( MID ) = op_am['mid_saderatat'];   
//

// کد های زیر کپی بانک ملت میباشد

// مستندرات بانک صادرات در لینک زیر هستند 
// https://www.sepehrpay.com/wp-content/uploads/2021/02/SepehrPay-Gateway-Manual-3.0.0-Token.pdf

function saderat_pay($price, $method, $callback, $post_id) {
    session_start();
    global $wpdb;

    $Amount             = $price; // Rial
    $terminal           = op_am['terminal_saderatat'];   // شماره ترمینال (TID)
    $redirectAddress    = $callback; // آدرس بازگشت به سایت برای تایید تراکنش

    if ($method == 'packages') {
        $table_name = $wpdb->prefix . 'iranamlak_orders_packages';
        $wpdb->insert($table_name, [
            'user_id' => wp_get_current_user()->ID,
            'price' => $_POST['price'],
            'number_adv' => $_POST['number_adv'],
            'number_forosh' => $_POST['number_forosh'],
            'number_rahnejare' => $_POST['number_rahnejare'],
            'number_ejarerozane' => $_POST['number_ejarerozane'],
            'pack_name' => $_POST['pack_name'],
            'dargah' => 'صادرات',
            'status' => 'pending',
            'token' => '-',
            'time_create' => current_time('Y-m-d H:i:s'),
            'time_update' => current_time('Y-m-d H:i:s'),
        ]);
    } else {
        if ($method == 'moshaver') {
            $post_id = 0;
            $_SESSION['name_moshaver_amlak'] = $_POST['name_moshaver_amlak'];
        }

        $table_name = $wpdb->prefix . 'iranamlak_orders';
        $wpdb->insert($table_name, [
            'user_id' => wp_get_current_user()->ID,
            'post_id' => $post_id,
            'price' => $Amount,
            'method' => $method,
            'dargah' => 'صادرات',
            'status' => 'pending',
            'token' => '-',
            'time_create' => current_time('Y-m-d H:i:s'),
            'time_update' => current_time('Y-m-d H:i:s'),
        ]);
    }

    $orderId = $wpdb->insert_id;
     
    // Post Data 
    $data= array(
        'Amount'=>$Amount,
        'callbackURL'=> $redirectAddress,
        'invoiceID'=> $orderId,
        'terminalID'=> $terminal,
        'payload'=> ''
    );   
     
    $dataQuery=http_build_query($data);
    $AddressServiceToken="https://sepehr.shaparak.ir:8081/V1/PeymentApi/GetToken";
     
    // Get Token
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $AddressServiceToken);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataQuery);
    curl_setopt($cu, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $TokenArray = curl_exec($ch);
    curl_close($ch);
    $decode_TokenArray=json_decode($TokenArray);
    // wp_die( var_dump( $TokenArray ) );
    $Status =$decode_TokenArray->Status;
    $AccessToken=$decode_TokenArray->AccessToken;

    if ( empty($AccessToken) || $Status != 0 ) {
        $is_error = 'yes';
        $error_code = $err;

        $_SESSION['payment'] = ['status' => 'error', 'msg' => [
            "خطا در ایجاد تراکنش",
            $err,
        ]];

        wp_redirect($callback);
        exit();
    }

    $AddressIpgPay="https://sepehr.shaparak.ir:8080/pay";
        
    echo '<form id="paymentUTLfrm" action="'.$AddressIpgPay.'" method="POST">
        <input type="hidden" id="TerminalID" name="TerminalID" value="'.$terminal.'">
        <input type="hidden" id="Amount" name="Amount" value="'.$Amount.'">
        <input type="hidden" id="callbackURL" name="callbackURL" value="'.$redirectAddress.'">
        <input type="hidden" id="InvoiceID" name="InvoiceID" value="'.$invoiceNumber.'">
        <input type="hidden" id="Payload" name="Payload" value="">
        <script>document.forms["paymentUTLfrm"].submit()</script>
    </form>';
}


function verify_saderat_ir($method, $calback, $post_id){
    session_start();
     
    if ( ! isset( $_POST['respcode'] ) || $_POST['respcode'] != '0' ) {
        $resultCode = ( isset( $_POST['respcode'] ) ) ? $_POST['respcode'] :  'برگشت ناموفق از درگاه';
        $resultMessage = ( isset( $_POST['respmsg'] ) ) ? $_POST['respmsg'] : 'خطا';
        $_SESSION['payment'] = ['status' => 'error', 'msg' => [
            $resultMessage,
            $resultCode,
        ]];

        wp_redirect($calback);
        exit();
    }

    $terminal = op_am['terminal_saderatat']; // شماره ترمینال (TID)
    $orderId = ( isset( $_POST['invoiceid'] ) ) ? $_POST['invoiceid'] : "";
    $digitalreceipt = ( isset( $_POST['digitalreceipt'] ) ) ? $_POST['digitalreceipt']  : "";

    $params = "digitalreceipt={$digitalreceipt}&Tid={$terminal}";
     
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://sepehr.shaparak.ir:8081/V1/PeymentApi/Advice');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $result = json_decode($res,true);
    
    $status = strtoupper($result['Status']);
    if ( $status != 'OK') {
        $message = ( isset( $result['Message'] ) ) ? $result['Message'] : 'خطا در اعتبار سنجی';
        $_SESSION['payment'] = ['status' => 'error', 'msg' => [
            $message,
            $status,
        ]];

        wp_redirect($calback);
        exit();
    }

    $order = $wpdb->get_row("SELECT * FROM $table_name WHERE id='$orderId'");
    $Amount = $order->price; // Rial

    if( floatval( $result['ReturnId'] ) != floatval( $Amount ) ) {
        $_SESSION['payment'] = ['status' => 'error', 'msg' => [
            "خطا",
            $result['ReturnId'],
        ]];

        wp_redirect($calback);
        exit();
    }

    if ($_GET['method'] == 'packages') {
        $wpdb->update(
            $table_name,
            [
                'status' => 'paid',
                'traking_code' => $_POST['tracenumber'],
                'time_update' => current_time('Y-m-d H:i:s'),
            ],
            ['id' => $orderId]
        );

        if (!$wpdb->last_error) {
            $user_id = wp_get_current_user()->ID;

            $pack_num = get_user_meta($user_id, 'iranamlak_package', true) ? get_user_meta($user_id, 'iranamlak_package', true) : 0;
            $new_num = $pack_num + intval($order->number_adv);

            $pack_num_forosh = get_user_meta($user_id, 'iranamlak_package_forosh', true) ? get_user_meta($user_id, 'iranamlak_package_forosh', true) : 0;
            $new_num_forosh = $pack_num_forosh + intval($order->number_forosh);

            $pack_num_rahnejare = get_user_meta($user_id, 'iranamlak_package_rahnejare', true) ? get_user_meta($user_id, 'iranamlak_package_rahnejare', true) : 0;
            $new_num_rahnejare = $pack_num_rahnejare + intval($order->number_rahnejare);

            $pack_num_ejarerozane = get_user_meta($user_id, 'iranamlak_package_ejarerozane', true) ? get_user_meta($user_id, 'iranamlak_package_ejarerozane', true) : 0;
            $new_num_ejarerozane = $pack_num_ejarerozane + intval($order->number_ejarerozane);

            update_user_meta($user_id, 'iranamlak_package', $new_num);
            update_user_meta($user_id, 'iranamlak_package_forosh', $new_num_forosh);
            update_user_meta($user_id, 'iranamlak_package_rahnejare', $new_num_rahnejare);
            update_user_meta($user_id, 'iranamlak_package_ejarerozane', $new_num_ejarerozane);

            do_action('amlak_notification_packages', [$order->pack_name, $order->price]);
        }
    } else {
        $wpdb->update(
            $table_name,
            [
                'status' => 'paid',
                'traking_code' => $_POST['tracenumber'],
                'time_update' => current_time('Y-m-d H:i:s'),
            ],
            ['id' => $orderId]
        );

        if ($order->method == 'tamdid') {
            $my_post = array(
                'ID' => $order->post_id,
                'post_status' => 'publish',
                'post_date' => date('Y-m-d H:i:s'),
                'post_date_gmt' => gmdate('Y-m-d H:i:s'),
                'post_modified' => date('Y-m-d H:i:s'),
            );
            wp_update_post($my_post);
        } elseif ($order->method == 'feature') {
            update_post_meta($order->post_id, 'special', 1);
        } elseif ($order->method == 'fast') {
            update_post_meta($order->post_id, 'fast', 1);
        } elseif ($order->method == 'send_agahi') {
            $data = array(
                'ID' => $order->post_id,
                'post_status' => op_am['enteshar'],
            );

            wp_update_post($data);
        } elseif ($order->method == 'moshaver') {
            update_user_meta(wp_get_current_user()->ID, 'name_moshaver_amlak', $_SESSION['name_moshaver_amlak']);
            $user = new WP_User(wp_get_current_user()->ID);
            if (!current_user_can('administrator')) {
                update_user_meta(wp_get_current_user()->ID, 'verify__moshaver_iranamlak', current_time('Y-m-d H:i:s'));
            }

            unset($_SESSION['name_moshaver_amlak']);
        }
        do_action('amlak_notification_' . $_GET['method'], $order->post_id);
    }

    //-- تمام مراحل پرداخت به درستی انجام شد.
    //-- آماده کردن خروجی
    $_SESSION['payment'] = ['status' => 'success', 'msg' => [
        "تراکنش با موفقیت انجام شد",
        "مبلغ پرداختی : " . number_format($order->price) . ' تومان',
        "کد پیگیری : " . $_POST['tracenumber'],
    ]];

}