<?php
function mellat_pay($price, $method, $callback, $post_id)
{
    session_start();
    if (!class_exists('nusoap_client')) {
        include_once("nusoap.php");
    }

    $Amount = $price;
    $client = new nusoap_client('https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl');
    $namespace = 'http://interfaces.core.sw.bps.com/';

    $err = $client->getError();
    if ($err) {
        $is_error = 'yes';
        $error_code = $err;
        session_start();

        $_SESSION['payment'] = ['status' => 'error', 'msg' => [
            "خطا در ایجاد تراکنش",
            $err,
        ]];

        wp_redirect($callback);
    } else {
        global $wpdb;
        if ($method == 'packages') {
            global $wpdb;
            $table_name = $wpdb->prefix . 'iranamlak_orders_packages';
            $wpdb->insert($table_name, [
                'user_id' => wp_get_current_user()->ID,
                'price' => $_POST['price'],
                'number_adv' => $_POST['number_adv'],
                'number_forosh' => $_POST['number_forosh'],
                'number_rahnejare' => $_POST['number_rahnejare'],
                'number_ejarerozane' => $_POST['number_ejarerozane'],
                'pack_name' => $_POST['pack_name'],
                'dargah' => 'ملت',
                'status' => 'pending',
                'token' => '-',
                'time_create' => current_time('Y-m-d H:i:s'),
                'time_update' => current_time('Y-m-d H:i:s'),
            ]);
        } else {
            if ($method == 'moshaver') {
                $post_id = 0;
                $_SESSION['name_moshaver_amlak'] = $_POST['name_moshaver_amlak'];
            }

            $table_name = $wpdb->prefix . 'iranamlak_orders';
            $wpdb->insert($table_name, [
                'user_id' => wp_get_current_user()->ID,
                'post_id' => $post_id,
                'price' => $Amount,
                'method' => $method,
                'dargah' => 'ملت',
                'status' => 'pending',
                'token' => '-',
                'time_create' => current_time('Y-m-d H:i:s'),
                'time_update' => current_time('Y-m-d H:i:s'),
            ]);
        }

        $terminalId = op_am['terminal_mellat'];
        $userName = op_am['name_mellat'];
        $userPassword = op_am['pass_mellat'];

        $orderId = $wpdb->insert_id;
        $additionalData = 'Order_Number : ' . $wpdb->insert_id;
        $callBackUrl = $callback;
        $localDate = date("Ymd");
        $localTime = date("His");
        $payerId = '0';
        $is_error = 'no';
        $parameters = array(
            'terminalId' => $terminalId,
            'userName' => $userName,
            'userPassword' => $userPassword,
            'orderId' => $orderId,
            'amount' => $Amount * 10,
            'localDate' => $localDate,
            'localTime' => $localTime,
            'additionalData' => $additionalData,
            'callBackUrl' => add_query_arg(['method' => $method, 'iranamlak_post' => $post_id, 'c_page' => $callback], $callback),
            'payerId' => $payerId
        );

        $result = $client->call('bpPayRequest', $parameters, $namespace);

        if ($client->fault) {
            session_start();
            $_SESSION['payment'] = ['status' => 'error', 'msg' => [
                "خطا در اتصال به بانک",
            ]];

            wp_redirect($callback);
            exit();
        } else {
            $res = explode(',', $result);
            $ResCode = $res[0];

            if ($ResCode == "0") {
                global $wpdb;
                if ($method == 'packages') {
                    $table_name = $wpdb->prefix . 'iranamlak_orders_packages';
                } else {
                    $table_name = $wpdb->prefix . 'iranamlak_orders';
                }
                $wpdb->update($table_name, [
                    'token' => $res[1],
                    'time_update' => current_time('Y-m-d H:i:s'),
                ], ['id' => $orderId]);


                //-- انتقال به درگاه پرداخت
                echo '<form id="redirect_to_mellat" method="post" action="https://bpm.shaparak.ir/pgwchannel/startpay.mellat" style="display:none !important;"  >
                            <input type="hidden"  name="RefId" value="' . $res[1] . '" />
                            <input type="submit" value="Pay"/>
                        </form>
                        <script language="JavaScript" type="text/javascript">
                            document.getElementById("redirect_to_mellat").submit();
                        </script>';
                exit;
            } else {
                session_start();
                $_SESSION['payment'] = ['status' => 'error', 'msg' => [
                    $result
                ]];

                wp_redirect($callback);
                exit();
            }
        }
    }
}

function verify_mellat_ir($method, $calback, $post_id)
{
    if ($_POST['ResCode'] == '0') {
        session_start();
        if (!class_exists('nusoap_client')) {
            include_once("nusoap.php");
        }

        global $wpdb;
        if ($method == 'packages') {
            $table_name = $wpdb->prefix . 'iranamlak_orders_packages';
        } else {
            $table_name = $wpdb->prefix . 'iranamlak_orders';
        }

        $client = new nusoap_client('https://bpm.shaparak.ir/pgwchannel/services/pgw?wsdl');
        $namespace = 'http://interfaces.core.sw.bps.com/';

        $terminalId = op_am['terminal_mellat'];
        $userName = op_am['name_mellat'];
        $userPassword = op_am['pass_mellat'];                    // Password
        $orderId = $_POST['SaleOrderId'];        // Order ID
        $verifySaleOrderId = $_POST['SaleOrderId'];
        $verifySaleReferenceId = $_POST['SaleReferenceId'];
        $parameters = array(
            'terminalId' => $terminalId,
            'userName' => $userName,
            'userPassword' => $userPassword,
            'orderId' => $orderId,
            'saleOrderId' => $verifySaleOrderId,
            'saleReferenceId' => $verifySaleReferenceId
        );

        // Call the SOAP method
        $result = $client->call('bpVerifyRequest', $parameters, $namespace);

        if ($result == '0') {
            //-- وریفای به درستی انجام شد٬ درخواست واریز وجه
            // Call the SOAP method
            $result = $client->call('bpSettleRequest', $parameters, $namespace);

            if ($result == '0') {
                $order = $wpdb->get_row("SELECT * FROM $table_name WHERE id='$orderId'");

                if ($_GET['method'] == 'packages') {
                    $wpdb->update(
                        $table_name,
                        [
                            'status' => 'paid',
                            'traking_code' => $_POST['SaleReferenceId'],
                            'time_update' => current_time('Y-m-d H:i:s'),
                        ],
                        ['id' => $orderId]
                    );

                    if (!$wpdb->last_error) {
                        $user_id = wp_get_current_user()->ID;

                        $pack_num = get_user_meta($user_id, 'iranamlak_package', true) ? get_user_meta($user_id, 'iranamlak_package', true) : 0;
                        $new_num = $pack_num + intval($order->number_adv);

                        $pack_num_forosh = get_user_meta($user_id, 'iranamlak_package_forosh', true) ? get_user_meta($user_id, 'iranamlak_package_forosh', true) : 0;
                        $new_num_forosh = $pack_num_forosh + intval($order->number_forosh);

                        $pack_num_rahnejare = get_user_meta($user_id, 'iranamlak_package_rahnejare', true) ? get_user_meta($user_id, 'iranamlak_package_rahnejare', true) : 0;
                        $new_num_rahnejare = $pack_num_rahnejare + intval($order->number_rahnejare);

                        $pack_num_ejarerozane = get_user_meta($user_id, 'iranamlak_package_ejarerozane', true) ? get_user_meta($user_id, 'iranamlak_package_ejarerozane', true) : 0;
                        $new_num_ejarerozane = $pack_num_ejarerozane + intval($order->number_ejarerozane);

                        update_user_meta($user_id, 'iranamlak_package', $new_num);
                        update_user_meta($user_id, 'iranamlak_package_forosh', $new_num_forosh);
                        update_user_meta($user_id, 'iranamlak_package_rahnejare', $new_num_rahnejare);
                        update_user_meta($user_id, 'iranamlak_package_ejarerozane', $new_num_ejarerozane);

                        do_action('amlak_notification_packages', [$order->pack_name, $order->price]);
                    }
                } else {
                    $wpdb->update(
                        $table_name,
                        [
                            'status' => 'paid',
                            'traking_code' => $_POST['SaleReferenceId'],
                            'time_update' => current_time('Y-m-d H:i:s'),
                        ],
                        ['id' => $orderId]
                    );

                    if ($order->method == 'tamdid') {
                        $my_post = array(
                            'ID' => $order->post_id,
                            'post_status' => 'publish',
                            'post_date' => date('Y-m-d H:i:s'),
                            'post_date_gmt' => gmdate('Y-m-d H:i:s'),
                            'post_modified' => date('Y-m-d H:i:s'),
                        );
                        wp_update_post($my_post);
                    } elseif ($order->method == 'feature') {
                        update_post_meta($order->post_id, 'special', 1);
                    } elseif ($order->method == 'fast') {
                        update_post_meta($order->post_id, 'fast', 1);
                    } elseif ($order->method == 'send_agahi') {
                        $data = array(
                            'ID' => $order->post_id,
                            'post_status' => op_am['enteshar'],
                        );

                        wp_update_post($data);
                    } elseif ($order->method == 'moshaver') {
                        update_user_meta(wp_get_current_user()->ID, 'name_moshaver_amlak', $_SESSION['name_moshaver_amlak']);
                        $user = new WP_User(wp_get_current_user()->ID);
                        if (!current_user_can('administrator')) {
                            update_user_meta(wp_get_current_user()->ID, 'verify__moshaver_iranamlak', current_time('Y-m-d H:i:s'));
                        }

                        unset($_SESSION['name_moshaver_amlak']);
                    }
                    do_action('amlak_notification_' . $_GET['method'], $order->post_id);
                }

                //-- تمام مراحل پرداخت به درستی انجام شد.
                //-- آماده کردن خروجی
                session_start();
                $_SESSION['payment'] = ['status' => 'success', 'msg' => [
                    "تراکنش با موفقیت انجام شد",
                    "مبلغ پرداختی : " . number_format($order->price) . ' تومان',
                    "کد پیگیری : " . $order->traking_code,
                ]];
            } else {
                //-- در درخواست واریز وجه مشکل به وجود آمد. درخواست بازگشت وجه داده شود.
                $client->call('bpReversalRequest', $parameters, $namespace);

                session_start();
                $_SESSION['payment'] = ['status' => 'error', 'msg' => [
                    "خطا",
                    $result,
                ]];

                wp_redirect($calback);
                exit();
            }
        } else {
            //-- وریفای به مشکل خورد٬ نمایش پیغام خطا و بازگشت زدن مبلغ
            $client->call('bpReversalRequest', $parameters, $namespace);
            session_start();
            $_SESSION['payment'] = ['status' => 'error', 'msg' => [
                "خطا",
                $result,
            ]];

            wp_redirect($calback);
            exit();
        }
    } else {
        //-- پرداخت با خطا همراه بوده
        session_start();
        $_SESSION['payment'] = ['status' => 'error', 'msg' => [
            "خطا",
            $_POST['ResCode'],
        ]];

        wp_redirect($calback);
        exit();
    }
}
