<?php

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_60d5fc2a3ab5f',
	'title' => 'توضیحات تایید / عدم تایید آگهی',
	'fields' => array(
		array(
			'key' => 'field_60d5fc3512771',
			'label' => 'دلیل رد',
			'name' => 'why-rejected',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'maxlength' => '',
			'rows' => 3,
			'new_lines' => 'br',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'state',
			),
			array(
				'param' => 'current_user_role',
				'operator' => '==',
				'value' => 'administrator',
			),
			array(
				'param' => 'post_status',
				'operator' => '==',
				'value' => 'rejected',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
));

acf_add_local_field_group(array(
	'key' => 'group_5bbda7f01fccf',
	'title' => 'توضیحات متا',
	'fields' => array(
		array(
			'key' => 'field_5bbda7f9fe590',
			'label' => 'شرح کوتاه راجب ملک وارد نمایید',
			'name' => 'description',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'این متن در نتایج یک الی دو خطی گوگل نشان داده خواهد شد . حد اکثر در 160 کارکتر توضیحات خود را وارد نمایید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'state',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => false,
));

acf_add_local_field_group(array(
	'key' => 'group_5ae851bf87212',
	'title' => 'مشخصات ملک',
	'fields' => array(
		array(
			'key' => 'field_5bbb3d3033cd6',
			'label' => 'آدرس',
			'name' => 'address',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => op_am['address_sendestate'],
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5bbb3d5833cd8',
			'label' => 'نام و نام خانوادگی',
			'name' => 'name',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => op_am['name_sendestate'],
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => 'wid50',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5bbb3d4733cd7',
			'label' => 'تلفن',
			'name' => 'mobile',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => op_am['phone_sendestate'],
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => 'wid50',
				'id' => '',
			),
			'default_value' => $phoneplaceholder,
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5bbb3d6d33cd9',
			'label' => 'ایمیل',
			'name' => 'email',
			'aria-label' => '',
			'type' => 'email',
			'instructions' => '',
			'required' => op_am['email_sendestate'],
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => 'wid50',
				'id' => '',
			),
			'default_value' => $emailplaceholder,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5ae851eab6a30',
			'label' => 'نوع معامله',
			'name' => 'moamele',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'خرید و فروش' => 'خرید و فروش',
				'رهن و اجاره' => 'رهن و اجاره',
				'اجاره روزانه' => 'اجاره روزانه',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ae856a6e6375',
			'label' => 'نوع ملک',
			'name' => 'melk',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'آپارتمان' => 'آپارتمان',
				'خانه و ویلا' => 'خانه و ویلا',
				'زمین' => 'زمین و کلنگی',
				'اداری و تجاری' => 'اداری و تجاری',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5f86aeb2fb14c',
			'label' => 'نوع نمایش قیمت',
			'name' => 'price-form',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'نمایش قیمت' => 'نمایش قیمت',
				'توافقی' => 'توافقی',
				'تماس بگیرید' => 'تماس بگیرید',
				'حراجی' => 'حراجی',
				'بالاترین پیشنهاد' => 'بالاترین پیشنهاد',
			),
			'default_value' => false,
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ae855c7e6371',
			'label' => 'قیمت کل',
			'name' => 'price-kol',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0// |',
		),
		array(
			'key' => 'field_5ae855dee6372',
			'label' => 'قیمت متری',
			'name' => 'price-metri',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0// |',
		),
		array(
			'key' => 'field_5ae8561fe6373',
			'label' => 'ودیعه',
			'name' => 'price-rahn',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'رهن و اجاره',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0// |',
		),
		array(
			'key' => 'field_5ae85638e6374',
			'label' => 'اجاره',
			'name' => 'price-ejare',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'رهن و اجاره',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0// |',
		),
		array(
			'key' => 'field_5ee4c65aef420',
			'label' => 'اجاره شبی ( روز های عادی )',
			'name' => 'price-shabi',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'اجاره روزانه',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0// |',
		),
		array(
			'key' => 'field_5ee4c67aef421',
			'label' => 'اجاره شبی آخر هفته و تعطیلات',
			'name' => 'price-tatilat',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'اجاره روزانه',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0// |',
		),
		array(
			'key' => 'field_5ae8575ee637d',
			'label' => 'متراژ',
			'name' => 'metrazh',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0//|',
		),
		array(
			'key' => 'field_5b62b857b72c4',
			'label' => 'مساحت زمین',
			'name' => 'masahat-zamin',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0//|',
		),
		array(
			'key' => 'field_5f1826676acef',
			'label' => 'کاربری',
			'name' => 'karbari',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
				),
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'رهن و اجاره',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => $karbariresult,
			'default_value' => false,
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5aea8b19e4f02',
			'label' => 'نوع سند',
			'name' => 'sanad',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => $sanadresult,
			'default_value' => false,
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5ee4c5caef41f',
			'label' => 'قابلیت تبدیل',
			'name' => 'tabdil',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'رهن و اجاره',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'دارد' => 'دارد',
				'ندارد' => 'ندارد',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5eeef989e2bc3',
			'label' => 'قابلیت اجاره به',
			'name' => 'tahol',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'رهن و اجاره',
					),
				),
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'اجاره روزانه',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'خانواده و مجرد' => 'خانواده و مجرد',
				'خانواده' => 'خانواده',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5eeefcb7e2bcc',
			'label' => 'دربست',
			'name' => 'darbast',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'رهن و اجاره',
					),
				),
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'اجاره روزانه',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'هست' => 'هست',
				'نیست' => 'نیست',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_61fffcd8f9002',
			'label' => 'برگذاری مراسمات',
			'name' => 'celebrations',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'اجاره روزانه',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'مجاز است' => 'مجاز است',
				'مجاز نیست' => 'مجاز نیست',
			),
			'default_value' => false,
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_61fffd76f9003',
			'label' => 'حیوانات خانگی',
			'name' => 'Pets',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'اجاره روزانه',
					),
				),
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'رهن و اجاره',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'مجاز است' => 'مجاز است',
				'مجاز نیست' => 'مجاز نیست',
			),
			'default_value' => false,
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5eeefce1e2bcd',
			'label' => 'حداکثر نفرات',
			'name' => 'nafarat',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'رهن و اجاره',
					),
				),
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'اجاره روزانه',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0//|',
		),
		array(
			'key' => 'field_5b0ff93753c4e',
			'label' => 'طبقه چندم',
			'name' => 'tabaghe',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0//|',
		),
		array(
			'key' => 'field_5aea8bb9e4f07',
			'label' => 'تعداد طبقات کل',
			'name' => 'tedad-tabaghat',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0//|',
		),
		array(
			'key' => 'field_5aea8bdfe4f08',
			'label' => 'تعداد واحد در هر طبقه',
			'name' => 'tedad-vahed-har-tabaghe',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0//|',
		),
		array(
			'key' => 'field_5aea8bfde4f09',
			'label' => 'تعداد واحد کل',
			'name' => 'tedad-vahed-kol',
			'aria-label' => '',
			'type' => 'price',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'format' => '|0//|',
		),
		array(
			'key' => 'field_5ae8581be6380',
			'label' => 'تعداد اتاق',
			'name' => 'otagh',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				0 => '0',
				1 => '1',
				2 => '2',
				3 => '3',
				4 => '4',
				5 => '5',
				6 => '6',
				7 => '7',
				8 => '8',
				9 => '9',
				10 => '10',
				11 => '11',
				12 => '12',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5eeefc64e2bca',
			'label' => 'تعداد حمام',
			'name' => 'num-hamam',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				1 => '1',
				2 => '2',
				3 => '3',
				4 => '4',
				5 => '5',
				6 => '6',
				7 => '7',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5eeefc8ce2bcb',
			'label' => 'تعداد دستشوئی',
			'name' => 'num-wc',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				1 => '1',
				2 => '2',
				3 => '3',
				4 => '4',
				5 => '5',
				6 => '6',
				7 => '7',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5bcb08e30cb9c',
			'label' => 'سن بنا',
			'name' => 'senbana',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => $senbanaresult,
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5aea8c30e4f0a',
			'label' => 'وضعیت سکونت',
			'name' => 'sokonat',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => array(
				'تخلیه' => 'تخلیه',
				'مستاجر ساکن' => 'مستاجر ساکن',
				'مالک ساکن' => 'مالک ساکن',
			),
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5aea8c53e4f0c',
			'label' => 'نما',
			'name' => 'nama',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => $namaresult,
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5aea8c60e4f0d',
			'label' => 'نوع کابینت',
			'name' => 'kabinet',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => $kabinetresult,
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5aea8d32e4f13',
			'label' => 'کف پوش',
			'name' => 'kafposh',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'choices' => $kafpooshresult,
			'default_value' => false,
			'allow_null' => 1,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5eef0522461be',
			'label' => 'پیش فروش',
			'name' => 'pishforosh',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'خانه و ویلا',
					),
				),
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5eef05ad461c0',
			'label' => 'تحویل',
			'name' => 'tahvil',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
					array(
						'field' => 'field_5eef0522461be',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5eef0579461bf',
			'label' => 'امکان معاوضه',
			'name' => 'moaveze',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
				),
			),
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5eef05d1461c2',
			'label' => 'با چه مواردی',
			'name' => 'moaveze-for',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
					array(
						'field' => 'field_5eef0579461bf',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5aea8b49e4f04',
			'label' => 'جهت ملک',
			'name' => 'mg',
			'aria-label' => '',
			'type' => 'checkbox',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'choices' => array(
				'شمالی' => 'شمالی',
				'شرقی' => 'شرقی',
				'جنوبی' => 'جنوبی',
				'غربی' => 'غربی',
			),
			'allow_custom' => 0,
			'default_value' => array(
			),
			'layout' => 'horizontal',
			'toggle' => 0,
			'return_format' => 'value',
			'save_custom' => 0,
		),
		array(
			'key' => 'field_6276dd820a3e9',
			'label' => 'جهت واحد',
			'name' => 'mg-vahed',
			'aria-label' => '',
			'type' => 'checkbox',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'آپارتمان',
					),
				),
				array(
					array(
						'field' => 'field_5ae856a6e6375',
						'operator' => '==',
						'value' => 'اداری و تجاری',
					),
				),
			),
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'choices' => array(
				'شمالی' => 'شمالی',
				'شرقی' => 'شرقی',
				'جنوبی' => 'جنوبی',
				'غربی' => 'غربی',
			),
			'allow_custom' => 0,
			'default_value' => array(
			),
			'layout' => 'horizontal',
			'toggle' => 0,
			'return_format' => 'value',
			'save_custom' => 0,
		),
		array(
			'key' => 'field_5fbe4dc572edd',
			'label' => 'مشارکت در ساخت',
			'name' => 'mosharekat',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ae851eab6a30',
						'operator' => '==',
						'value' => 'خرید و فروش',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5eef0b41f73b6',
			'label' => 'ساحلی',
			'name' => 'saheli',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5eef0b52f73b7',
			'label' => 'شهرکی',
			'name' => 'shahraki',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5eef0b5cf73b8',
			'label' => 'کوهپایه',
			'name' => 'kohpaye',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '25',
				'class' => 'wid25',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5aea8d6fe4f14',
			'label' => 'امکانات',
			'name' => 'sayer-emkanat',
			'aria-label' => '',
			'type' => 'checkbox',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'choices' => $emkanatresult,
			'allow_custom' => 0,
			'default_value' => array(
			),
			'layout' => 'horizontal',
			'toggle' => 1,
			'return_format' => 'value',
			'save_custom' => 0,
		),
		array(
			'key' => 'field_5bdd406aef1f8',
			'label' => 'افزودن تصاویر',
			'name' => 'gallery',
			'aria-label' => '',
			'type' => 'gallery',
			'instructions' => 'یک تصویر بهتر از هزار کلمه .با قرار دادن عکس شانس دیده شدن آگهی تان را 5 برابر کنید .',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '100',
				'class' => 'wid100',
				'id' => '',
			),
			'return_format' => 'array',
			'preview_size' => 'thumbnail',
			'insert' => 'append',
			'library' => 'all',
			'min' => '',
			'max' => '',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5fba5c83dbf63',
			'label' => 'ویدئو ملک',
			'name' => 'video',
			'aria-label' => '',
			'type' => 'file',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'library' => 'all',
			'min_size' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_64c0ce2180f3c',
			'label' => 'ویدئو ملک (آپارات)',
			'name' => 'video_aparat',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'rows' => '',
			'placeholder' => '',
			'new_lines' => '',
		),
		array(
			'center_lat' => op_am['map_send_default']['latitude'],
			'center_lng' => op_am['map_send_default']['longitude'],
            'zoom'=> op_am['map_send_default']['zoom'],
			'key' => 'field_5ec38ed14694f',
			'label' => 'موقعیت ملک روی نقشه',
			'name' => 'streetmap',
			'aria-label' => '',
			'type' => 'open_street_map',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'leaflet',
			'layers' => array(
				0 => 'OpenStreetMap.Mapnik',
			),
			'allow_map_layers' => 0,
			'height' => 400,
			'max_markers' => 1,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'state',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'the_content',
		1 => 'excerpt',
		2 => 'discussion',
		3 => 'comments',
		4 => 'revisions',
		5 => 'featured_image',
		6 => 'send-trackbacks',
	),
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
));

acf_add_local_field_group(array(
	'key' => 'group_5bdd6738d6f4c',
	'title' => 'مدیریت',
	'fields' => array(
		array(
			'key' => 'field_5bdd6738da86e',
			'label' => 'ویژه',
			'name' => 'special',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5bdd6738da8f0',
			'label' => 'فوری',
			'name' => 'fast',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => 'فروش فوری است',
			'ui_off_text' => 'فروش فوری نیست',
		),
		array(
			'key' => 'field_64c30462148cb',
			'label' => 'مشاور مربوطه',
			'name' => 'moshaver',
			'aria-label' => '',
			'type' => 'user',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'role' => array(
				0 => 'karmand',
			),
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 0,
		),
		array(
			'key' => 'field_64c81e43ba4c0',
			'label' => 'لینک تصویر سه بعدی',
			'name' => 'pic3d',
			'aria-label' => '',
			'type' => 'url',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
		),
		array(
			'key' => 'field_64b68fcb5a74a',
			'label' => 'توضیحات خصوصی',
			'name' => 'contentforme',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'rows' => '',
			'placeholder' => '',
			'new_lines' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'state',
			),
			array(
				'param' => 'current_user_role',
				'operator' => '==',
				'value' => 'administrator',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'side',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'featured_image',
	),
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
));

endif;		