<?php

function login_user_iranamlak($username, $pass)
{

    $creds = array();
    $creds['user_login'] = $username;
    $creds['user_password'] = $pass;
    $creds['remember'] = true;
    if (!force_ssl_admin()) {
        $user = is_email($creds['user_login']) ? get_user_by('email', $creds['user_login']) : get_user_by('login', sanitize_user($creds['user_login']));
        if ($user && get_user_option('use_ssl', $user->ID)) {
            $secure_cookie = true;
            force_ssl_admin(true);
        }
    }
    if (force_ssl_admin()) {
        $secure_cookie = true;
    }
    if (is_null($secure_cookie) && force_ssl_admin()) {
        $secure_cookie = false;
    }
    $user = wp_signon($creds, $secure_cookie);
}

function register_user_iranamlak($username, $email, $password, $first_name, $last_name)
{

    $username = sanitize_text_field($username);
    $password = sanitize_text_field($password);
    $first_name = sanitize_text_field($first_name);
    $last_name = sanitize_text_field($last_name);
    $email = $email ? sanitize_email($email) : ' ';

    $userdata = array(
        'user_login' => $username,
        'user_pass' => $password,
        'user_email' => $email,
        'first_name' => $first_name,
        'last_name' => $last_name,
    );

    $user_id = wp_insert_user(wp_slash($userdata));
    if (!is_wp_error($user_id)) {
        if (op_am['active_mobile_auth']){
            update_user_meta($user_id,'phone',$username);
        }
        return $user_id;
    } else {
        return $user_id->get_error_message();
    }
}

function send_code_amlak_lost_pass($username)
{
    global $wpdb;
    $tbl = $wpdb->prefix . 'amlak_verify_code';
    $check = $wpdb->get_row("SELECT * FROM $tbl WHERE user='$username'");
    if ($check && strtotime($check->expire_time) > current_time('timestamp')) {
        session_start();
        $_SESSION['code_exp'] = $check->expire_time;
        $_SESSION['lost_pass_user_amlak'] = $username;
        $_SESSION['suc'] = ['کد ارسالی معتبر می باشد'];
        wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password-change');
        exit();
    }
    $wpdb->delete($tbl, ['id' => $check->id]);
    $code = rand(111111, 999999);

        $send = sendEmailOrSMSAmlak($code, $username,'lost_pass');
        if ($send) {
            $time = 60 * op_am['expire_time_auth'];
            $wpdb->insert($tbl, [
                'code' => $code,
                'user' => $username,
                'time_create' => current_time("Y-m-d H:i:s"),
                'expire_time' => wp_date("Y-m-d H:i:s", time() + $time),
            ]);
            if (!$wpdb->last_error) {
                session_start();
                $_SESSION['code_exp'] = wp_date("Y-m-d H:i:s", time() + $time);
                $_SESSION['lost_pass_user_amlak'] = $username;
                wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password-change');
                exit();
            } else {
                $_SESSION['error'] = 'در هنگام ذخیره کد خطایی رخ داده است لطفا مجدد تلاش بفرمایید';
                wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password');
                exit();
            }
        } else {
            $_SESSION['error'] = 'خطایی در هنگام ارسال ایمیل رخ داده است لطفا مجدد تلاش بفرمایید';
            wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password');
            exit();
        }

}

/**
 * @param int $code
 * @param $username
 * @return bool|mixed|void
 */
function sendEmailOrSMSAmlak($code, $username,$method)
{

    if(op_am['active_mobile_auth'] && !is_email($username)){
            $To = $username;
           return require_once 'sms/'.op_am['panel_sms'].'.php';
    }else{
        if (!is_email($username)){
            $username = get_user_by('login',$username)->user_email;
        }
       ;
       if ($method == 'register') {
           $search = ['{code}'];
           $replace = [$code];
           $subject = op_am['subject_verify_mail_reg'];
           $message = str_replace($search, $replace, wpautop(op_am['text_valid_email_auth']));
       }elseif ($method =='lost_pass'){
           $search = ['{code}'];
           $replace = [$code];
           $subject = op_am['subject_verify_mail_lost'];
           $message = str_replace($search, $replace, wpautop(op_am['text_valid_email_auth_lost']));
       }elseif ($method =='disposable'){
           $search = ['{code}'];
           $replace = [$code];
           $subject = op_am['subject_verify_mail_disposable'];
           $message = str_replace($search, $replace, wpautop(op_am['text_valid_email_auth_disposable']));
       }
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=utf-8 \r\n";
        $headers .= 'From: Wordpress<wordpress@mysite.com>';
        $mail = wp_mail($username, $subject, html_entity_decode($message, ENT_COMPAT, 'UTF-8'), $headers);
        return $mail;
    }


}

//-------------------- Check User in Auth --------------------
add_action('wp_ajax_check_user_auth', 'check_user_auth');
add_action('wp_ajax_nopriv_check_user_auth', 'check_user_auth');
function check_user_auth()
{
    session_start();
    if (isset($_POST['login_iranamlak']) && wp_verify_nonce($_POST['login_iranamlak'], 'login_iranamlak_act')) {
        $username = $_POST['username'];
        //-- Check User
        if (is_email($username) && email_exists($username)) {
            $_SESSION['amlak_user'] = get_user_by('email', $username)->user_login;
            wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=login');
            exit();
        } else {
            if (username_exists($username)) {
                $_SESSION['amlak_user'] = $username;
                wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=login');
                exit();
            }
            if (is_email($username)) {
                $_SESSION['amlak_email'] = $username;
            } else {
                $_SESSION['amlak_username'] = $username;
            }
            wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=register');
            exit();
        }
    } else {
        $_SESSION['error'] = ['بخش امنیت سایت ، شما را تایید نکرده است لطفا مجدد فرم را ارسال بفرمایید'];
        wp_redirect(get_page_link(op_am['select-page-login']));
        exit();

    }
}

//-------------------- Check PassWord --------------------
add_action('wp_ajax_check_password_auth', 'check_password_auth');
add_action('wp_ajax_nopriv_check_password_auth', 'check_password_auth');
function check_password_auth()
{
    session_start();
    if (isset($_POST['login_pass_iranamlak']) && wp_verify_nonce($_POST['login_pass_iranamlak'], 'login_pass_iranamlak_act')) {
        $username = $_SESSION['amlak_user'];
        $pass = $_POST['password'];
        $user = get_user_by('login', $username);
        if ($user && wp_check_password($pass, $user->data->user_pass, $user->ID)) {
            $user = login_user_iranamlak($username, $pass);
            if (is_wp_error($user)) {
                $_SESSION['error'] = [$user->get_error_message()];
                wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=login');
                exit();
            } else {
                wp_redirect(get_page_link(op_am['select-page-login']));
                exit();
            }

        } else {
            $_SESSION['error'] = ['رمز عبور را اشتباه می باشد'];
            wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=login');
            exit();
        }

    } else {
        unset($_SESSION['amlak_user']);
        $_SESSION['error'] = ['بخش امنیت سایت ، شما را تایید نکرده است لطفا مجدد فرم را ارسال بفرمایید'];
        wp_redirect(get_page_link(op_am['select-page-login']));
        exit();
    }
}

//-------------------- Register User --------------------
add_action('wp_ajax_register_iranamlak', 'register_iranamlak');
add_action('wp_ajax_nopriv_register_iranamlak', 'register_iranamlak');
function register_iranamlak()
{
    if (isset($_POST['reg_iranamlak']) && wp_verify_nonce($_POST['reg_iranamlak'], 'reg_iranamlak_act')) {
        session_start();
        $_SESSION['error'] = [];
        if (username_exists($_POST['username'])) {
            $_SESSION['error'][] = 'نام کاربری وجود دارد';
        }
        if (email_exists($_POST['email'])) {
            $_SESSION['error'][] = 'ایمیل وجود دارد';
        }
        if (strlen($_POST['username']) < 1) {
            if (!op_am['active_mobile_auth']) {
                $_SESSION['error'][] = 'نام کاربری الزامی است';
            } else {
                $_SESSION['error'][] = 'شماره همراه الزامی است';
            }

        }
        if (!op_am['active_mobile_auth']) {
            if (strlen($_POST['email']) < 1) {
                $_SESSION['error'][] = 'آدرس ایمیل الزامی است';
            }
        }
        if (strlen($_POST['first_name']) < 1) {
            $_SESSION['error'][] = 'نام الزامی است';
        }
        if (strlen($_POST['last_name']) < 1) {
            $_SESSION['error'][] = 'نام خانوادگی الزامی است';
        }
        if (strlen($_POST['password']) < 1) {
            $_SESSION['error'][] = 'رمز عبور الزامی است';
        }
        if ($_POST['password'] != $_POST['cpassword']) {
            $_SESSION['error'][] = 'عدم تطابق رمز عبور و تایید آن';
        }
        if (op_am['active_valid_email_auth']) {
            if (strlen($_POST['code']) < 1) {
                $_SESSION['error'][] = 'کد تایید الزامی می باشد';
            }
        }

        if (count($_SESSION['error']) > 0) {
            wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=register');
            exit();
        } else {
             
            if (op_am['active_valid_email_auth']) {
                $check_active_code = checkActiveCodeIranamlak($_POST['email'], $_POST['code']);
                if (!$check_active_code) {
                    $_SESSION['error'][] = 'کد تایید نامعتبر می باشد';
                    wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=register');
                    exit();
                }
            }
            
               if (op_am['active_mobile_auth']) {
                $check_active_code = checkActiveCodeIranamlak($_POST['username'], $_POST['code']);
                if (!$check_active_code) {
                    $_SESSION['error'][] = 'کد تایید نامعتبر می باشد';
                    wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=register');
                    exit();
                }
            }
            
            
            
            $user_id = register_user_iranamlak($_POST['username'], $_POST['email'], $_POST['password'], $_POST['first_name'], $_POST['last_name']);
            if (!is_numeric($user_id)) {
                $_SESSION['error'] = [$user_id];
                wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=register');
                exit();
            } else {
                $user = new WP_User($user_id);
                $user->set_role($_POST['pippin_user_role']);
                login_user_iranamlak($_POST['username'], $_POST['password']);
                wp_redirect(get_page_link(op_am['select-page-login']));
                exit();
            }
        }
    } else {
        $_SESSION['error'] = ['بخش امنیت سایت ، شما را تایید نکرده است لطفا مجدد فرم را ارسال بفرمایید'];
        wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=register');
        exit();
    }
}

function checkActiveCodeIranamlak($username, $code)
{

    global $wpdb;
    $tbl = $wpdb->prefix . 'amlak_verify_code';
    $check = $wpdb->get_row("SELECT * FROM $tbl WHERE user='$username' AND code='$code' ");
    if ($check) {
        if (strtotime($check->expire_time) < current_time('timestamp')) {
            return false;
        }
        $wpdb->delete($tbl, ['id' => $check->id]);
        return true;
    } else {
        return false;
    }
}

//-------------------- Function Send Code Register --------------------
add_action('wp_ajax_send_code_amlak', 'send_code_amlak');
add_action('wp_ajax_nopriv_send_code_amlak', 'send_code_amlak');
function send_code_amlak()
{
    if (isset($_POST['reg_iranamlak']) && wp_verify_nonce($_POST['reg_iranamlak'], 'reg_iranamlak_act')) {
        $username = $_POST['to'];
       
        if (is_email($username)) {
           if (!email_exists($username)){
               global $wpdb;
               $tbl = $wpdb->prefix . 'amlak_verify_code';
               $check = $wpdb->get_row("SELECT * FROM $tbl WHERE user='$username'");
               if ($check) {
                   if (strtotime($check->expire_time) > current_time('timestamp')) {
                       echo json_encode(['status' => 'has', 'message' => 'کد ارسالی معتبر می باشد', 'expired' => $check->expire_time]);
                       exit();
                   }
                   $wpdb->delete($tbl, ['id' => $check->id]);
               }
               $code = rand(111111, 999999);
               $send = sendEmailOrSMSAmlak($code, $username,'register');
               if ($send) {
                   $time = 60 * op_am['expire_time_auth'];
                   $wpdb->insert($tbl, [
                       'code' => $code,
                       'user' => $username,
                       'time_create' => current_time("Y-m-d H:i:s"),
                       'expire_time' => wp_date("Y-m-d H:i:s", time() + $time),
                   ]);
                   if (!$wpdb->last_error) {
                       echo json_encode(['status' => 'suc', 'expired' => wp_date("Y-m-d H:i:s", time() + $time)]);
                   } else {
                       echo json_encode(['status' => 'error', 'message' => 'در هنگام ذخیره کد خطایی رخ داده است لطفا مجدد تلاش بفرمایید']);
                   }
               } else {
                   echo json_encode(['status' => 'error', 'message' => 'خطایی در هنگام ارسال ایمیل رخ داده است لطفا مجدد تلاش بفرمایید']);
               }
           }else{
               echo json_encode(['status' => 'error', 'message' => 'ایمیل ارسالی وجود دارد']);
           }     
        }else{
            if(!username_exists($username)){
                global $wpdb;
                $tbl = $wpdb->prefix . 'amlak_verify_code';
                $check = $wpdb->get_row("SELECT * FROM $tbl WHERE user='$username'");
                if ($check) {
                    if (strtotime($check->expire_time) > current_time('timestamp')) {
                        echo json_encode(['status' => 'has', 'message' => 'کد ارسالی معتبر می باشد', 'expired' => $check->expire_time]);
                        exit();
                    }
                    $wpdb->delete($tbl, ['id' => $check->id]);
                }
                $code = rand(111111, 999999);
                $send = sendEmailOrSMSAmlak($code, $username,'register');
                if ($send) {
                    $time = 60 * op_am['expire_time_auth'];
                    $wpdb->insert($tbl, [
                        'code' => $code,
                        'user' => $username,
                        'time_create' => current_time("Y-m-d H:i:s"),
                        'expire_time' => wp_date("Y-m-d H:i:s", time() + $time),
                    ]);
                    if (!$wpdb->last_error) {
                        echo json_encode(['status' => 'suc', 'expired' => wp_date("Y-m-d H:i:s", time() + $time)]);
                    } else {
                        echo json_encode(['status' => 'error', 'message' => 'در هنگام ذخیره کد خطایی رخ داده است لطفا مجدد تلاش بفرمایید']);
                    }
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'خطایی در هنگام ارسال ایمیل رخ داده است لطفا مجدد تلاش بفرمایید']);
                }
            }else{
                echo json_encode(['status' => 'error', 'message' => 'کاربر از قبل وجود دارد']);
            }
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'بخش امنیت سایت ، شما را تایید نکرده است لطفا مجدد تلاش بفرمایید']);
    }
    exit();
}
//-------------------- Function Send Code Reset Password --------------------
add_action('wp_ajax_reset_pass_auth', 'reset_pass_auth');
add_action('wp_ajax_nopriv_reset_pass_auth', 'reset_pass_auth');
function reset_pass_auth()
{
    session_start();

    if (isset($_POST['reset_pass_iranamlak']) && wp_verify_nonce($_POST['reset_pass_iranamlak'], 'reset_pass_iranamlak_act')) {

        $username = $_POST['username'];

        if ((is_email($username) && !email_exists($username)) || !username_exists($username)) {
            $_SESSION['error'] = ['کاربر ارسالی یافت نشد'];
            wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password');
            exit();
        } else {
            if (is_email($username)) {
                $to = $username;
            } else {
                if(op_am['active_mobile_auth']){
                    $to =  $username;
                }else{
                    $to = get_user_by('login', $username)->user_email;
                }

            }

            send_code_amlak_lost_pass($to);
        }
    } else {
        $_SESSION['error'] = ['بخش امنیت سایت ، شما را تایید نکرده است لطفا مجدد فرم را ارسال بفرمایید'];
        wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password');

    }

    exit();
}
//-------------------- Check Code And Reset password --------------------
add_action('wp_ajax_reset_password_change', 'reset_password_change');
add_action('wp_ajax_nopriv_reset_password_change', 'reset_password_change');
function reset_password_change()
{
    session_start();
    if (isset($_POST['reset_pass_iranamlak']) && wp_verify_nonce($_POST['reset_pass_iranamlak'], 'reset_pass_iranamlak_act')) {
        $username = $_POST['user'];
        $code = $_POST['code'];
        $check = checkActiveCodeIranamlak($username, $code);
        if ($check) {
            if (is_email($username)) {
                $user_id = get_user_by('email', $username)->ID;
            } else {
                $user_id = get_user_by('login', $username)->ID;
            }
            $password = sanitize_text_field($_POST['password']);
            $userdata = array(
                'ID' => $user_id,
                'user_pass' => $password
            );
            $user = wp_update_user($userdata);
            if (!is_wp_error($user)) {
                $_SESSION['suc'] = ['رمز عبور شما با موفقیت تغییر یافت'];
                wp_redirect(get_page_link(op_am['select-page-login']));
            } else {
                $_SESSION['error'] = ['در تغییر رمز عبور خطایی رخ داده است'];
                wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password-change');
            }

        } else {
            $_SESSION['error'] = ['کد اسالی نامتعبر می باشد'];
            wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password-change');
        }
    } else {
        $_SESSION['error'] = ['بخش امنیت سایت ، شما را تایید نکرده است لطفا مجدد فرم را ارسال بفرمایید'];
        wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=reset-password');
    }
    exit();
}
//---------------- send Code Login No Password ------
add_action('wp_ajax_send_code_amlak_login_no_pass','send_code_amlak_login_no_pass');
add_action('wp_ajax_nopriv_send_code_amlak_login_no_pass','send_code_amlak_login_no_pass');
function send_code_amlak_login_no_pass(){
    if (isset($_POST['reg_iranamlak']) && wp_verify_nonce($_POST['reg_iranamlak'], 'reg_iranamlak_act')) {
        $username = $_POST['to'];

        if (is_email($username)) {
            if (email_exists($username)){
                global $wpdb;
                $tbl = $wpdb->prefix . 'amlak_verify_code';
                $check = $wpdb->get_row("SELECT * FROM $tbl WHERE user='$username'");
                if ($check) {
                    if (strtotime($check->expire_time) > current_time('timestamp')) {
                        echo json_encode(['status' => 'has', 'message' => 'کد ارسالی معتبر می باشد', 'expired' => $check->expire_time]);
                        exit();
                    }
                    $wpdb->delete($tbl, ['id' => $check->id]);
                }
                $code = rand(111111, 999999);
                $send = sendEmailOrSMSAmlak($code, $username,'disposable');
                if ($send) {
                    $time = 60 * op_am['expire_time_auth'];
                    $wpdb->insert($tbl, [
                        'code' => $code,
                        'user' => $username,
                        'time_create' => current_time("Y-m-d H:i:s"),
                        'expire_time' => wp_date("Y-m-d H:i:s", time() + $time),
                    ]);
                    if (!$wpdb->last_error) {
                        echo json_encode(['status' => 'suc', 'expired' => wp_date("Y-m-d H:i:s", time() + $time)]);
                    } else {
                        echo json_encode(['status' => 'error', 'message' => 'در هنگام ذخیره کد خطایی رخ داده است لطفا مجدد تلاش بفرمایید']);
                    }
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'خطایی در هنگام ارسال ایمیل رخ داده است لطفا مجدد تلاش بفرمایید']);
                }
            }else{
                echo json_encode(['status' => 'error', 'message' => 'ایمیل ارسالی وجود ندارد']);
            }
        }else{
            if(username_exists($username)){
                global $wpdb;
                $tbl = $wpdb->prefix . 'amlak_verify_code';
                $check = $wpdb->get_row("SELECT * FROM $tbl WHERE user='$username'");
                if ($check) {
                    if (strtotime($check->expire_time) > current_time('timestamp')) {
                        echo json_encode(['status' => 'has', 'message' => 'کد ارسالی معتبر می باشد', 'expired' => $check->expire_time]);
                        exit();
                    }
                    $wpdb->delete($tbl, ['id' => $check->id]);
                }
                $code = rand(111111, 999999);
                $send = sendEmailOrSMSAmlak($code, $username,'disposable');
                if ($send) {
                    $time = 60 * op_am['expire_time_auth'];
                    $wpdb->insert($tbl, [
                        'code' => $code,
                        'user' => $username,
                        'time_create' => current_time("Y-m-d H:i:s"),
                        'expire_time' => wp_date("Y-m-d H:i:s", time() + $time),
                    ]);
                    if (!$wpdb->last_error) {
                        echo json_encode(['status' => 'suc', 'expired' => wp_date("Y-m-d H:i:s", time() + $time)]);
                    } else {
                        echo json_encode(['status' => 'error', 'message' => 'در هنگام ذخیره کد خطایی رخ داده است لطفا مجدد تلاش بفرمایید']);
                    }
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'خطایی در هنگام ارسال ایمیل رخ داده است لطفا مجدد تلاش بفرمایید']);
                }
            }else{
                echo json_encode(['status' => 'error', 'message' => 'کاربر یافت نشد']);
            }
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'بخش امنیت سایت ، شما را تایید نکرده است لطفا مجدد تلاش بفرمایید']);
    }
    exit();
}
//----------- Login No password ------------
add_action('wp_ajax_login_no_pass','login_no_pass');
add_action('wp_ajax_nopriv_login_no_pass','login_no_pass');
function login_no_pass(){
    session_start();
    if (isset($_POST['reg_iranamlak']) && wp_verify_nonce($_POST['reg_iranamlak'], 'reg_iranamlak_act')) {
       $check  = checkActiveCodeIranamlak($_POST['username'], $_POST['code']);
       if($check){
            if(is_email($_POST['username'])){
                $user = get_user_by('email',$_POST['username']);
            }else{
                $user = get_user_by('login',$_POST['username']);
            }

           wp_clear_auth_cookie();
           wp_set_current_user ( $user->ID );
           wp_set_auth_cookie  ( $user->ID );
           wp_redirect(get_page_link(op_am['select-page-login']));
       }else{
           $_SESSION['error'] = ['کد ارسالی نامعتبر میباشد'];
           wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=login_no_pass');
       }
    }else {
        $_SESSION['error'] = ['بخش امنیت سایت ، شما را تایید نکرده است لطفا مجدد فرم را ارسال بفرمایید'];
        wp_redirect(get_page_link(op_am['select-page-login']) . '?tab=login_no_pass');
    }
    exit();



}
