<?php
function amlak_user_key()
{
    global $wpdb;
    $metakey =[];
    $keys =  $wpdb->get_col( "SELECT DISTINCT meta_key FROM {$wpdb->usermeta}" );

    foreach($keys as $key){

        $metakey[$key] = $key;
    }

    return $metakey;
}

CSF::createSection($prefix, array(
    'id' => 'set_sms',
    'title' => 'تنظیمات پیامک',
    'icon' => 'fas fa-angle-left',
    'fields' => array(
)));


CSF::createSection($prefix, array(
    'parent'=>'set_sms',
    'id'=>'set_sms_omomi',
    'title' => 'تنظیمات عمومی',
    'icon' => 'fas fa-angle-left',
    'fields' => array(
        array(
            'id' => 'admin_phone',
            'type' => 'text',
            'title' => 'شماره همراه مدیر',

        ),
        array(
            'id'          => 'user_meta_key',
            'type'        => 'select',
            'title'       => 'کلید شماره همراه کاربر',
            'chosen'      => true,
            'placeholder' => 'انتخاب کلید شماره همراه کاربر',
            'desc' => 'فیلد شماره همراه کاربر در دیتابیس',
            'options'     =>  amlak_user_key(),
        ),

        array(
            'id' => 'var_send_notification',
            'type' => 'select',
            'title' => 'متغییر ارسالی در اطلاع رسانی ها',
            'options' => array(
                'title' => 'عنوان آگهی',
                'post_id' => 'کد ملک',
            ),

        ),
        array(
            'id' => 'expired_days_notifications',
            'type' => 'number',
            'title' => 'تعداد روز',
            'desc'=>'این فیلد تعداد روز را قبل از منقضی شدن برای ارسال آگهی تعیین میکند'
        ),

        array(
            'id' => 'tedadarghamcode',
            'type' => 'select',
            'default' => '4',
            'title' => 'تعداد رقم های کد تایید',
            'options' => array(
                '4' => '4',
                '5' => '5',
                '6' => '6',
                '7' => '7',
                '8' => '8',
            ),
            'desc'=>'این فیلد تعداد ارقام کد تایید ورود یا ثبت نام را مشخص میکند'
        ),

)));



CSF::createSection($prefix, array(
    'parent'=>'set_sms',
    'id'=>'set_sms_dargah',
    'title' => 'تنظیمات درگاه',
    'icon' => 'fas fa-angle-left',
    'fields' => array(
        array(
            'id' => 'panel_sms',
            'type' => 'select',
            'title' => 'پنل پیامکی',
            'placeholder' => 'انتخاب پنل پیامکی',

            'options' => array(
                'sms_ir' => 'SMS.IR',
                'ippanel' => 'آی پی پنل',
                'rayegansms' => 'رایگان اس ام اس',
                'kavenegar' => 'کاوه نگار',
                'melipayamak' => 'ملی پیامک',
            ),

        ),

        //-------------- SMS.IR  -------------//
        
        //array(
        //    'id' => 'secret_key_sms_ir',
        //    'type' => 'text',
        //    'title' => 'کلید امنیتی (Secret Key)',
        //    'dependency' => array('panel_sms', '==', 'sms_ir'),
        //),
        array(
            'id' => 'api_key_sms_ir',
            'type' => 'text',
            'title' => 'کلید api   (api key)',
            'dependency' => array('panel_sms', '==', 'sms_ir'),
        ),
        
        //-------------- ippanel  -------------//
        array(
            'id' => 'api_ippanel',
            'type' => 'text',
            'title' => 'کلید دسترسی',
            'dependency' => array('panel_sms', '==', 'ippanel'),
        ),

        array(
            'id' => 'from_ippanel',
            'type' => 'text',
            'title' => 'شماره ارسال کننده',
            'dependency' => array('panel_sms', '==', 'ippanel'),
        ),
        
        //-------------- rayegansms  -------------//
        array(
            'id' => 'username_rayegansms',
            'type' => 'text',
            'title' => 'نام کاربری',
            'dependency' => array('panel_sms', '==', 'rayegansms'),
        ),

        array(
            'id' => 'pass_rayegansms',
            'type' => 'text',
            'title' => 'رمز عبور',
            'dependency' => array('panel_sms', '==', 'rayegansms'),

        ),
        

        //-------------- kavenegar  -------------//

        array(
            'id' => 'api_key_kavenegar',
            'type' => 'text',
            'title' => 'کلید api   (api key)',
            'dependency' => array('panel_sms', '==', 'kavenegar'),
        ),

        
        //-------------- melipayamak  -------------//
        array(
            'id' => 'username_melipayamak',
            'type' => 'text',
            'title' => 'نام کاربری',
            'dependency' => array('panel_sms', '==', 'melipayamak'),
        ),
        array(
            'id' => 'pass_melipayamak',
            'type' => 'text',
            'title' => 'رمز عبور',
            'dependency' => array('panel_sms', '==', 'melipayamak'),

        ),
)));


CSF::createSection($prefix, array(
    'parent'=>'set_sms',
    'id'=>'set_sms_notif',
    'title' => 'تنظیمات اطلاع رسانی',
    'icon' => 'fas fa-angle-left',
    'fields' => array(
        
        array(
            'type'    => 'notice',
            'id'      => 'noting',
            'style'   => 'warning',
            'content' => '<strong>شما هنوز تنظیمات مروبط به درگاه پیامک را اعمال نکرده اید . در صورت عدم تنظیم هیچ یک از موارد زیر کار نخواهد کرد . </strong>',
            'dependency' =>array(
                array('panel_sms','==','' , 'set_sms_dargah') ,
            ),
        ),



        //-------------- ippanel  -------------//
        array(
            'id' => 'code_reg_ippanel',
            'type' => 'text',
            'title' => 'کد متن ثبت نام',
            'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر code باشد .',

        ),
        array(
            'id' => 'code_lost_ippanel',
            'type' => 'text',
            'title' => 'کد متن فراموشی رمز عبور',
            'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر code باشد .',

        ),
        array(
            'id' => 'code_disposable_ippanel',
            'type' => 'text',
            'title' => 'کد متن رمز یک بار مصرف',
            'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر code باشد .',

        ),



        //-------------- rayegansms  -------------//

        array(
            'id' => 'code_reg_rayegansms',
            'type' => 'textarea',
            'title' => 'متن ثبت نام',
              'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر کد عبارت code را وارد نمایید. توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',

        ),
        array(
            'id' => 'code_lost_rayegansms',
            'type' => 'textarea',
            'title' => 'متن فراموشی رمز عبور',
              'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر code باشد .',

        ),
        array(
            'id' => 'code_disposable_rayegansms',
            'type' => 'textarea',
            'title' => 'متن رمز یک بار مصرف',
              'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر code باشد .',

        ),



        //-------------- kavenegar  -------------//

        array(
            'id' => 'code_reg_kavenegar',
            'type' => 'text',
            'title' => 'متن ثبت نام',
              'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر کد عبارت code را وارد نمایید. توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',

        ),
        array(
            'id' => 'code_lost_kavenegar',
            'type' => 'text',
            'title' => 'متن فراموشی رمز عبور',
              'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر code باشد .',

        ),
        array(
            'id' => 'code_disposable_kavenegar',
            'type' => 'text',
            'title' => 'متن رمز یک بار مصرف',
              'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر code باشد .',

        ),


        
        //-------------- melipayamak  -------------//

        array(
            'id' => 'code_reg_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ثبت نام',
                    'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',

        ),
        array(
            'id' => 'code_lost_melipayamak',
            'type' => 'text',
            'title' => 'کد متن فراموشی رمز عبور',
                    'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),

            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),


        array(
            'id' => 'code_disposable_melipayamak',
            'type' => 'text',
            'title' => 'کد متن رمز یک بار مصرف',
                    'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),




        array(
            'id' => 'expire_time_auth',
            'type' => 'number',
            'title' => 'مدت اعتبار کد تایید به دقیقه',

        ),


        //-------------- sms.ir  -------------//

 array(
            'id' => 'code_reg_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ثبت نام',
            'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'sms_ir'),
            ),

            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #code# استفاده نمائید ',

        ),
        array(
            'id' => 'code_lost_sms_ir',
            'type' => 'text',
            'title' => 'کد متن فراموشی رمز عبور',
            'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'sms_ir'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #code# استفاده نمائید ',

        ),
        array(
            'id' => 'code_disposable_sms_ir',
            'type' => 'text',
            'title' => 'کد متن رمز یک بار مصرف',
            'dependency' =>array(
                array('active_mobile_auth','==','true' , 'set_auth') ,
                array('panel_sms', '==', 'sms_ir'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #code# استفاده نمائید ',
        ),


        

/*--------------------------------------------*/
        array(
            'id' => 'active_notif_after_send_adv_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از ثبت آگهی(ارسال به کاربر)',
            'text_width' => 80
        ),


        array(
            'id' => 'code_after_send_adv_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_user','==','true'),
                array('panel_sms', '==', 'sms_ir' , 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),

        array(
            'id' => 'code_after_send_adv_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),

        array(
            'id' => 'code_after_send_adv_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_send_adv_user_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),

        array(
            'id' => 'code_after_send_adv_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
            ),
            
/*--------------------------------------------*/

        array(
            'id' => 'active_notif_after_send_adv_admin',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از ثبت آگهی(ارسال به مدیر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_after_send_adv_admin_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_admin','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),
        array(
            'id' => 'code_after_send_adv_admin_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_admin','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_send_adv_admin_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_admin','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
            ),
            
        array(
            'id' => 'code_after_send_adv_admin_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_admin','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),

        array(
            'id' => 'code_after_send_adv_admin_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ثبت آگهی',
            'dependency' =>array(
                array('active_notif_after_send_adv_admin','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
    

/*--------------------------------------------*/


        array(
            'id' => 'active_notif_after_verify_adv_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از تایید آگهی(ارسال به کاربر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_after_verify_adv_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تایید آگهی',
            'dependency' =>array(
                array('active_notif_after_verify_adv_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),

        array(
            'id' => 'code_after_verify_adv_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تایید آگهی',
            'dependency' =>array(
                array('active_notif_after_verify_adv_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),

        array(
            'id' => 'code_after_verify_adv_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تایید آگهی',
            'dependency' =>array(
                array('active_notif_after_verify_adv_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),

        array(
            'id' => 'code_after_verify_adv_user_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تایید آگهی',
            'dependency' =>array(
                array('active_notif_after_verify_adv_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_verify_adv_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تایید آگهی',
            'dependency' =>array(
                array('active_notif_after_verify_adv_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
            ),
/*--------------------------------------------*/
        array(
            'id' => 'active_notif_after_reject_adv_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از رد آگهی(ارسال به کاربر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_after_reject_adv_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از رد آگهی',
            'dependency' =>array(
                array('active_notif_after_reject_adv_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_reject_adv_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از رد آگهی',
            'dependency' =>array(
                array('active_notif_after_reject_adv_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),

        array(
            'id' => 'code_after_reject_adv_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از رد آگهی',
            'dependency' =>array(
                array('active_notif_after_reject_adv_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),

        array(
            'id' => 'code_after_reject_adv_user_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از رد آگهی',
            'dependency' =>array(
                array('active_notif_after_reject_adv_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_reject_adv_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از رد آگهی',
            'dependency' =>array(
                array('active_notif_after_reject_adv_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
            ),


/*--------------------------------------------*/


        array(
            'id' => 'active_notif_after_fast_adv_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از فوری کردن آگهی(ارسال به کاربر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_after_fast_adv_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),
        array(
            'id' => 'code_after_fast_adv_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_fast_adv_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_fast_adv_user_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_fast_adv_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),


/*--------------------------------------------*/


        array(
            'id' => 'active_notif_after_fast_adv_admin',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از فوری کردن آگهی(ارسال به مدیر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_after_fast_adv_admin_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_admin','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),

        array(
            'id' => 'code_after_fast_adv_admin_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_admin','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_fast_adv_admin_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_admin','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_fast_adv_admin_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_admin','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_fast_adv_admin_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از فوری کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_fast_adv_admin','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),
        
/*--------------------------------------------*/


        array(
            'id' => 'active_notif_after_feature_adv_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از ویژه کردن آگهی(ارسال به کاربر)',
            'text_width' => 80
        ),
        array(
            'id' => 'code_after_feature_adv_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),

        array(
            'id' => 'code_after_feature_adv_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_feature_adv_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_feature_adv_user_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_feature_adv_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),
        
        
/*--------------------------------------------*/


        array(
            'id' => 'active_notif_after_feature_adv_admin',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از ویژه کردن آگهی(ارسال به مدیر)',
            'text_width' => 80
        ),
        array(
            'id' => 'code_after_feature_adv_admin_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_admin','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),
        array(
            'id' => 'code_after_feature_adv_admin_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_admin','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_feature_adv_admin_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_admin','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_feature_adv_admin_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_admin','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_feature_adv_admin_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از ویژه کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_feature_adv_admin','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),


/*--------------------------------------------*/


        array(
            'id' => 'active_notif_after_tamdid_adv_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از تمدید کردن آگهی(ارسال به کاربر)',
            'text_width' => 80
        ),
        array(
            'id' => 'code_after_tamdid_adv_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),
        array(
            'id' => 'code_after_tamdid_adv_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_tamdid_adv_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_tamdid_adv_user_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_tamdid_adv_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ), 
        
/*--------------------------------------------*/


        array(
            'id' => 'active_notif_after_tamdid_adv_admin',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از تمدید کردن آگهی(ارسال به مدیر)',
            'text_width' => 80
        ),
        array(
            'id' => 'code_after_tamdid_adv_admin_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_admin','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),
        array(
            'id' => 'code_after_tamdid_adv_admin_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_admin','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_tamdid_adv_admin_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_admin','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_tamdid_adv_admin_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_admin','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_tamdid_adv_admin_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از تمدید کردن آگهی',
            'dependency' =>array(
                array('active_notif_after_tamdid_adv_admin','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),
 
/*--------------------------------------------*/


        array(
            'id' => 'active_notif_after_expired_adv_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی بعد از منقضی شدن آگهی(ارسال به کاربر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_after_expired_adv_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_after_expired_adv_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),
        array(
            'id' => 'code_after_expired_adv_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_after_expired_adv_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_expired_adv_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_after_expired_adv_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_expired_adv_user_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_after_expired_adv_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_after_expired_adv_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_after_expired_adv_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),

/*--------------------------------------------*/


        array(
            'id' => 'active_notif_before_expired_adv_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی قبل از منقضی شدن آگهی(ارسال به کاربر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_before_expired_adv_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر قبل از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_before_expired_adv_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'ابتدا از پنل اسمس خود از بخش "ارسال سریع" قالب پیامکی مورد نظر خود را بسازید . سپس کد قالب را در اینجا قرار دهید . در ایجاد قالب پیامکی دقت داشته باشید برای متغیراز واژه #title# استفاده نمائید ',
        ),
        array(
            'id' => 'code_before_expired_adv_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر قبل از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_before_expired_adv_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_before_expired_adv_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر قبل از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_before_expired_adv_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),
        array(
            'id' => 'code_before_expired_adv_user_kavenegar',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر قبل از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_before_expired_adv_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'کد پترن مورد نظر را وارد نمایید . پترن مورد نظر باید دارای متغیر title باشد .',
        ),

        array(
            'id' => 'code_before_expired_adv_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر قبل از منقضی شدن آگهی',
            'dependency' =>array(
                array('active_notif_before_expired_adv_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' توجه داشته باشید فقط کد به صورت متغییر ارسال میگردد پس باید در متن شما فقط یک متغییر وجود داشته باشد',
        ),

/*--------------------------------------------*/


        array(
            'id' => 'active_notif_package_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی خرید پکیج(ارسال به کاربر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_notif_pack_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت price و به جای متغییر نام پکیج عبارت name را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_pack_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت price و به جای متغییر نام پکیج عبارت name را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_pack_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت price و به جای متغییر نام پکیج عبارت name را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_pack_user_kavenegar',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت price و به جای متغییر نام پکیج عبارت name را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_pack_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت 1 و به جای متغییر نام پکیج عبارت 0 را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),







/*--------------------------------------------*/


        array(
            'id' => 'active_notif_package_admin',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی خرید پکیج(ارسال به مدیر)',
            'text_width' => 80
        ),


        array(
            'id' => 'code_notif_pack_admin_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_admin','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت price و به جای متغییر نام پکیج عبارت name را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_pack_admin_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_admin','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت price و به جای متغییر نام پکیج عبارت name را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_pack_admin_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_admin','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت price و به جای متغییر نام پکیج عبارت name را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_pack_admin_kavenegar',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_admin','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت price و به جای متغییر نام پکیج عبارت name را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_pack_admin_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از خرید پکیج',
            'dependency' =>array(
                array('active_notif_package_admin','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => 'به جای متغییر قیمت عبارت 1 و به جای متغییر نام پکیج عبارت 0 را وارد نمایید ، دقت نمایید پترن تعریفی باید حاوی دو متغییر ذکر شده باشد',
        ),
/*--------------------------------------------*/


        array(
            'id' => 'active_notif_moshaver_user',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی مشاور شدن(ارسال به کاربر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_notif_moshaver_user_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_user','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر name و به جای نام خانوادگی family و به جای نام مشاور moshaver قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_moshaver_user_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_user','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر name و به جای نام خانوادگی family و به جای نام مشاور moshaver قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),

        array(
            'id' => 'code_notif_moshaver_user_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_user','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر name و به جای نام خانوادگی family و به جای نام مشاور moshaver قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_moshaver_user_kavenegar',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_user','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر name و به جای نام خانوادگی family و به جای نام مشاور moshaver قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),

        array(
            'id' => 'code_notif_moshaver_user_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به کاربر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_user','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر 0 و به جای نام خانوادگی 1 و به جای نام مشاور 2 قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),

        
/*--------------------------------------------*/


        array(
            'id' => 'active_notif_moshaver_admin',
            'type' => 'switcher',
            'title' => 'فعال سازی اطلاع رسانی مشاور شدن(ارسال به مدیر)',
            'text_width' => 80
        ),

        array(
            'id' => 'code_notif_moshaver_admin_sms_ir',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_admin','==','true'),
                array('panel_sms', '==', 'sms_ir', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر name و به جای نام خانوادگی family و به جای نام مشاور moshaver قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_moshaver_admin_ippanel',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_admin','==','true'),
                array('panel_sms', '==', 'ippanel', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر name و به جای نام خانوادگی family و به جای نام مشاور moshaver قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_moshaver_admin_rayegansms',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_admin','==','true'),
                array('panel_sms', '==', 'rayegansms', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر name و به جای نام خانوادگی family و به جای نام مشاور moshaver قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),
        array(
            'id' => 'code_notif_moshaver_admin_kavenegar',
            'type' => 'textarea',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_admin','==','true'),
                array('panel_sms', '==', 'kavenegar', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر name و به جای نام خانوادگی family و به جای نام مشاور moshaver قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),

        array(
            'id' => 'code_notif_moshaver_admin_melipayamak',
            'type' => 'text',
            'title' => 'کد متن ارسال پیامک به مدیر بعد از مشاور شدن',
            'dependency' =>array(
                array('active_notif_moshaver_admin','==','true'),
                array('panel_sms', '==', 'melipayamak', 'set_sms_dargah'),
            ),
            'desc' => ' به جای متغییر نام کاربر 0 و به جای نام خانوادگی 1 و به جای نام مشاور 2 قرار  ، دقت نمایید پترن تعریفی باید حاوی سه متغییر ذکر شده باشد',
        ),
        

/*--------------------------------------------*/






)));



        