/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-09-12 16:04:48 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=4822 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=19372 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=886 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_amlak_verify_code` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time_create` datetime NOT NULL,
  `expire_time` datetime NOT NULL,
  `user` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=96 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_iranamlak_map_data` (
  `post_id` bigint(20) NOT NULL,
  `transaction_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `estate_type` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `price` bigint(20) DEFAULT NULL,
  `rant` bigint(20) DEFAULT NULL,
  `deposit` bigint(20) DEFAULT NULL,
  `lat` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lng` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_iranamlak_orders` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `price` bigint(20) NOT NULL,
  `method` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `dargah` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(15) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `traking_code` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time_create` datetime NOT NULL,
  `time_update` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_iranamlak_orders_filing` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userid` bigint(20) NOT NULL,
  `file` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_iranamlak_orders_packages` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `price` bigint(20) NOT NULL,
  `number_adv` bigint(20) NOT NULL,
  `number_forosh` bigint(20) NOT NULL,
  `number_rahnejare` bigint(20) NOT NULL,
  `number_ejarerozane` bigint(20) NOT NULL,
  `pack_name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `dargah` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(15) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `traking_code` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time_create` datetime NOT NULL,
  `time_update` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_iranamlak_user_massages` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `userid` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `codemelk` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `myname` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `phone` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `massage` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time_create` datetime NOT NULL,
  `read` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_iranamlak_user_requests` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `userid` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `onvan` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `melk` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `moamele` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `myname` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `phone` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `massage` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time_create` datetime NOT NULL,
  `read` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_iranamlak_user_rezervs` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `userid` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `onvan` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `melk` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nafarat` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `shab` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tarikhvorod` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `myname` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `phone` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `massage` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time_create` datetime NOT NULL,
  `read` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_map_data` (
  `post_id` bigint(20) NOT NULL,
  `transaction_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `estate_type` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `price` bigint(20) DEFAULT NULL,
  `rant` bigint(20) DEFAULT NULL,
  `deposit` bigint(20) DEFAULT NULL,
  `lat` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lng` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=111081 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=27788 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=6544 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=1443 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1443 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3725 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfu_dbxqueue` (
  `iddbxqueue` mediumint(9) NOT NULL AUTO_INCREMENT,
  `fileid` mediumint(9) NOT NULL,
  `priority` mediumint(9) NOT NULL,
  `status` mediumint(9) NOT NULL,
  `jobid` varchar(10) NOT NULL,
  `start_time` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`iddbxqueue`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfu_log` (
  `idlog` mediumint(9) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `uploaduserid` int(11) NOT NULL,
  `uploadtime` bigint(20) DEFAULT NULL,
  `sessionid` varchar(40) DEFAULT NULL,
  `filepath` text NOT NULL,
  `filehash` varchar(100) NOT NULL,
  `filesize` bigint(20) NOT NULL,
  `uploadid` varchar(20) NOT NULL,
  `pageid` mediumint(9) DEFAULT NULL,
  `blogid` mediumint(9) DEFAULT NULL,
  `sid` varchar(10) DEFAULT NULL,
  `date_from` datetime DEFAULT NULL,
  `date_to` datetime DEFAULT NULL,
  `action` varchar(20) NOT NULL,
  `linkedto` mediumint(9) DEFAULT NULL,
  `filedata` text,
  PRIMARY KEY (`idlog`),
  KEY `uploadid` (`uploadid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfu_userdata` (
  `iduserdata` mediumint(9) NOT NULL AUTO_INCREMENT,
  `uploadid` varchar(20) NOT NULL,
  `property` varchar(100) NOT NULL,
  `propkey` mediumint(9) NOT NULL,
  `propvalue` text,
  `date_from` datetime DEFAULT NULL,
  `date_to` datetime DEFAULT NULL,
  PRIMARY KEY (`iduserdata`),
  KEY `uploadid` (`uploadid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpxlsdata` (
  `id_wpxlsdata` int(255) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `xlsname` varchar(255) NOT NULL,
  `description` text,
  `db` varchar(255) NOT NULL,
  PRIMARY KEY (`id_wpxlsdata`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpxlsdata_meta` (
  `id_meta` int(255) NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) CHARACTER SET utf8 NOT NULL,
  `meta_value` varchar(255) CHARACTER SET utf8 NOT NULL,
  `id_wpxlsdata` int(255) NOT NULL,
  `type_input` varchar(255) CHARACTER SET utf8 DEFAULT 'text',
  `isunique` tinyint(1) NOT NULL DEFAULT '0',
  `dbcolumn` varchar(255) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id_meta`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wpxlsdata_shortcode` (
  `id_shortcode` int(255) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `id_wpxlsdata` int(255) NOT NULL,
  `shortcode` text CHARACTER SET utf8,
  PRIMARY KEY (`id_shortcode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("4804", "action_scheduler/migration_hook", "complete", "2022-03-09 12:22:53", "2022-03-09 15:52:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828573;}", "1", "1", "2022-03-09 12:22:57", "2022-03-09 15:52:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4805", "wc-admin_import_customers", "complete", "2022-03-09 12:28:20", "2022-03-09 15:58:20", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828900;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828900;}", "3", "1", "2022-03-09 12:28:33", "2022-03-09 15:58:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4806", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:27", "2022-03-09 15:58:27", "[4691,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828907;}", "2", "1", "2022-03-09 12:28:33", "2022-03-09 15:58:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4813", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:38", "2022-03-09 15:58:38", "[4692,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828918;}", "2", "1", "2022-03-09 12:28:39", "2022-03-09 15:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4814", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:38", "2022-03-09 15:58:38", "[4693,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828918;}", "2", "1", "2022-03-09 12:28:39", "2022-03-09 15:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4815", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:38", "2022-03-09 15:58:38", "[4694,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828918;}", "2", "1", "2022-03-09 12:28:39", "2022-03-09 15:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4816", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:38", "2022-03-09 15:58:38", "[4695,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828918;}", "2", "1", "2022-03-09 12:28:39", "2022-03-09 15:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4817", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:38", "2022-03-09 15:58:38", "[4536,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828918;}", "2", "1", "2022-03-09 12:28:39", "2022-03-09 15:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4818", "woocommerce_run_update_callback", "complete", "2022-03-09 12:28:49", "2022-03-09 15:58:49", "{\"update_callback\":\"wc_update_630_create_product_attributes_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828929;}", "2", "1", "2022-03-09 12:28:53", "2022-03-09 15:58:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4819", "woocommerce_run_update_callback", "complete", "2022-03-09 12:28:53", "2022-03-09 15:58:53", "{\"update_callback\":\"wc_update_630_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828933;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828933;}", "2", "1", "2022-03-09 12:28:53", "2022-03-09 15:58:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4820", "woocommerce_update_db_to_current_version", "complete", "2022-03-09 12:28:54", "2022-03-09 15:58:54", "{\"version\":\"6.3.0\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828934;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828934;}", "2", "1", "2022-03-09 12:29:37", "2022-03-09 15:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4821", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2022-03-09 12:28:54", "2022-03-09 15:58:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828934;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828934;}", "2", "1", "2022-03-09 12:29:37", "2022-03-09 15:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4812", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:38", "2022-03-09 15:58:38", "[4691,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828918;}", "2", "1", "2022-03-09 12:28:39", "2022-03-09 15:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4809", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:27", "2022-03-09 15:58:27", "[4694,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828907;}", "2", "1", "2022-03-09 12:28:33", "2022-03-09 15:58:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4810", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:27", "2022-03-09 15:58:27", "[4695,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828907;}", "2", "1", "2022-03-09 12:28:33", "2022-03-09 15:58:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4811", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:27", "2022-03-09 15:58:27", "[4536,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828907;}", "2", "1", "2022-03-09 12:28:33", "2022-03-09 15:58:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4808", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:27", "2022-03-09 15:58:27", "[4693,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828907;}", "2", "1", "2022-03-09 12:28:33", "2022-03-09 15:58:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4807", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2022-03-09 12:28:27", "2022-03-09 15:58:27", "[4692,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1646828907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1646828907;}", "2", "1", "2022-03-09 12:28:33", "2022-03-09 15:58:33", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc-admin-data");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("885", "4821", "عملیات توسط Async Request کامل شد", "2022-03-09 12:29:37", "2022-03-09 15:59:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("884", "4821", "عملیات توسط Async Request شروع شد", "2022-03-09 12:29:37", "2022-03-09 15:59:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("881", "4819", "عملیات توسط WP Cron کامل شد", "2022-03-09 12:28:53", "2022-03-09 15:58:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("882", "4820", "عملیات توسط Async Request شروع شد", "2022-03-09 12:29:37", "2022-03-09 15:59:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("883", "4820", "عملیات توسط Async Request کامل شد", "2022-03-09 12:29:37", "2022-03-09 15:59:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("873", "4812", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("874", "4818", "ایجاد فعالیت", "2022-03-09 12:28:52", "2022-03-09 15:58:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("875", "4819", "ایجاد فعالیت", "2022-03-09 12:28:52", "2022-03-09 15:58:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("876", "4820", "ایجاد فعالیت", "2022-03-09 12:28:52", "2022-03-09 15:58:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("877", "4818", "عملیات توسط WP Cron شروع شد", "2022-03-09 12:28:53", "2022-03-09 15:58:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("855", "4807", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("880", "4819", "عملیات توسط WP Cron شروع شد", "2022-03-09 12:28:53", "2022-03-09 15:58:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("856", "4812", "ایجاد فعالیت", "2022-03-09 12:28:37", "2022-03-09 15:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("854", "4807", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("849", "4810", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("850", "4811", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("851", "4811", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("852", "4808", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("879", "4818", "عملیات توسط WP Cron کامل شد", "2022-03-09 12:28:53", "2022-03-09 15:58:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("878", "4821", "ایجاد فعالیت", "2022-03-09 12:28:53", "2022-03-09 15:58:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("853", "4808", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("848", "4810", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("847", "4809", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("846", "4809", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("845", "4806", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("844", "4806", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("838", "4808", "ایجاد فعالیت", "2022-03-09 12:28:26", "2022-03-09 15:58:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("839", "4809", "ایجاد فعالیت", "2022-03-09 12:28:26", "2022-03-09 15:58:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("840", "4810", "ایجاد فعالیت", "2022-03-09 12:28:26", "2022-03-09 15:58:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("841", "4811", "ایجاد فعالیت", "2022-03-09 12:28:26", "2022-03-09 15:58:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("842", "4805", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("843", "4805", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:33", "2022-03-09 15:58:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("832", "4804", "ایجاد فعالیت", "2022-03-09 12:21:53", "2022-03-09 15:51:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("872", "4812", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("871", "4817", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("870", "4817", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("869", "4816", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("868", "4816", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("857", "4813", "ایجاد فعالیت", "2022-03-09 12:28:37", "2022-03-09 15:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("858", "4814", "ایجاد فعالیت", "2022-03-09 12:28:37", "2022-03-09 15:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("859", "4815", "ایجاد فعالیت", "2022-03-09 12:28:37", "2022-03-09 15:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("860", "4816", "ایجاد فعالیت", "2022-03-09 12:28:37", "2022-03-09 15:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("861", "4817", "ایجاد فعالیت", "2022-03-09 12:28:37", "2022-03-09 15:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("862", "4813", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("863", "4813", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("864", "4814", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("865", "4814", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("866", "4815", "عملیات توسط Async Request شروع شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("867", "4815", "عملیات توسط Async Request کامل شد", "2022-03-09 12:28:39", "2022-03-09 15:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("837", "4807", "ایجاد فعالیت", "2022-03-09 12:28:26", "2022-03-09 15:58:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("836", "4806", "ایجاد فعالیت", "2022-03-09 12:28:26", "2022-03-09 15:58:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("835", "4805", "ایجاد فعالیت", "2022-03-09 12:28:15", "2022-03-09 15:58:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("834", "4804", "عملیات توسط Async Request کامل شد", "2022-03-09 12:22:57", "2022-03-09 15:52:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("833", "4804", "عملیات توسط Async Request شروع شد", "2022-03-09 12:22:57", "2022-03-09 15:52:57");

/* INSERT TABLE DATA: wp_amlak_verify_code */
INSERT INTO `wp_amlak_verify_code` VALUES("28", "738662", "2022-05-30 16:27:28", "2022-05-30 16:32:28", "arsalan.gholipor3@gmail.com");
INSERT INTO `wp_amlak_verify_code` VALUES("27", "251305", "2022-05-30 16:24:12", "2022-05-30 16:29:12", "arsalan.gholipor@gmail.com");
INSERT INTO `wp_amlak_verify_code` VALUES("26", "368073", "2022-05-29 20:01:04", "2022-05-29 20:06:04", "miladtahri@gmail.com");
INSERT INTO `wp_amlak_verify_code` VALUES("53", "847986", "2022-09-01 22:50:11", "2022-09-01 22:55:11", "hamiw3@gmail.com");
INSERT INTO `wp_amlak_verify_code` VALUES("36", "780019", "2022-06-21 19:42:05", "2022-06-21 19:47:05", "0913446455");
INSERT INTO `wp_amlak_verify_code` VALUES("93", "801918", "2023-01-02 11:16:55", "2023-01-02 11:17:55", "09112921876");
INSERT INTO `wp_amlak_verify_code` VALUES("71", "177698", "2022-10-12 09:09:41", "2022-10-12 09:10:41", "09120578449");
INSERT INTO `wp_amlak_verify_code` VALUES("72", "699893", "2022-11-08 22:06:42", "2022-11-08 22:07:42", "09191449947");
INSERT INTO `wp_amlak_verify_code` VALUES("78", "507374", "2022-11-29 15:13:52", "2022-11-29 15:14:52", "09191238014");
INSERT INTO `wp_amlak_verify_code` VALUES("89", "370802", "2022-12-28 01:34:43", "2022-12-28 01:35:43", "68657908765");
INSERT INTO `wp_amlak_verify_code` VALUES("91", "918343", "2022-12-31 22:38:22", "2022-12-31 22:39:22", "09138297422");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("17", "4900", "ووکامرس", "", "", "", "2021-07-01 13:17:03", "2021-07-01 08:47:03", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "4901", "ووکامرس", "", "", "", "2021-07-01 13:33:07", "2021-07-01 09:03:07", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "4702", "یوسف پور امینیان", "info@sitralweb.com", "", "", "2021-04-30 12:57:27", "2021-04-30 08:27:27", "موارد اضافه شده: انتخاب پکیج برای درج آگهی - 10 (#4692)<span class=\"description\"></span>", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "4702", "یوسف پور امینیان", "info@sitralweb.com", "", "", "2021-04-30 12:57:34", "2021-04-30 08:27:34", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "4898", "ووکامرس", "", "", "", "2021-06-29 00:06:42", "2021-06-28 19:36:42", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "4703", "یوسف پور امینیان", "info@sitralweb.com", "", "", "2021-04-30 12:59:40", "2021-04-30 08:29:40", "موارد اضافه شده: انتخاب پکیج برای درج آگهی - 20 (#4693)<span class=\"description\"></span>", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "4898", "ووکامرس", "", "", "", "2021-06-28 22:52:33", "2021-06-28 18:22:33", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "4703", "یوسف پور امینیان", "info@sitralweb.com", "", "", "2021-04-30 12:59:49", "2021-04-30 08:29:49", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "4712", "ووکامرس", "", "", "", "2021-05-01 15:44:12", "2021-05-01 11:14:12", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "4712", "ووکامرس", "", "", "", "2021-05-01 15:44:16", "2021-05-01 11:14:16", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "4712", "ووکامرس", "", "", "", "2021-05-01 18:03:22", "2021-05-01 13:33:22", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "4900", "ووکامرس", "", "", "", "2021-07-01 14:35:30", "2021-07-01 10:05:30", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "4901", "ووکامرس", "", "", "", "2021-07-01 14:35:30", "2021-07-01 10:05:30", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "5239", "ووکامرس", "", "", "", "2021-11-23 17:12:24", "2021-11-23 13:42:24", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "5239", "ووکامرس", "", "", "", "2021-11-23 17:12:29", "2021-11-23 13:42:29", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "5239", "ووکامرس", "", "", "", "2021-11-23 18:17:25", "2021-11-23 14:47:25", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("30", "iranamlak_7_6_3", "88669835fe30cfc76586_20230912155909", "22", "2023-09-12 16:04:47", "iranamlak", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-09-12 15:59:09\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.3.1\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"8.1.14\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:30;s:4:\"Name\";s:15:\"iranamlak_7_6_3\";s:4:\"Hash\";s:35:\"88669835fe30cfc76586_20230912155909\";s:8:\"NameHash\";s:51:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:61:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.3\";s:6:\"WPUser\";s:9:\"iranamlak\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:63:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/home/yousefamini/public_html/ir3\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:713;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:5260;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-09-12 15:59:09\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.3.1\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"8.1.14\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:15:\"iranamlak_7_6_3\";s:4:\"Hash\";s:35:\"88669835fe30cfc76586_20230912155909\";s:8:\"NameHash\";s:51:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:69:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:47:\"/home/yousefamini/public_html/ir3/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:64:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:30:\"MySQL Community Server - (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:130:\"/home/yousefamini/public_html/ir3/wp-content/backups-dup-lite/tmp/iranamlak_7_6_3_88669835fe30cfc76586_20230912155909_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:42:\"/home/yousefamini/public_html/ir3/wp-admin\";i:1;s:45:\"/home/yousefamini/public_html/ir3/wp-includes\";i:2;s:54:\"/home/yousefamini/public_html/ir3/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:33:\"/home/yousefamini/public_html/ir3\";i:1;s:33:\"/home/yousefamini/public_html/ir3\";i:2;s:44:\"/home/yousefamini/public_html/ir3/wp-content\";i:3;s:52:\"/home/yousefamini/public_html/ir3/wp-content/uploads\";i:4;s:52:\"/home/yousefamini/public_html/ir3/wp-content/plugins\";i:5;s:55:\"/home/yousefamini/public_html/ir3/wp-content/mu-plugins\";i:6;s:51:\"/home/yousefamini/public_html/ir3/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:65:\"/home/yousefamini/public_html/ir3/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_duplicator_pro_entities */
INSERT INTO `wp_duplicator_pro_entities` VALUES("1", "DUP_PRO_Global_Entity", "{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_phpdump_qrylimit\": 500,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"http\",\n    \"custom_ajax_url\": \"https:\\/\\/sitralweb.com\\/ir3\\/wp-admin\\/admin-ajax.php\",\n    \"server_kick_off_sslverify\": true,\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1594478300,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": true,\n    \"lkp\": \"\",\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1594478311,\n    \"initial_activation_timestamp\": 1594478311,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"notices\": {\n        \"dupArchiveSwitch\": false\n    }\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("2", "DUP_PRO_Secure_Global_Entity", "{\n    \"basic_auth_password\": null,\n    \"lkp\": \"\",\n    \"type\": \"DUP_PRO_Secure_Global_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("3", "DUP_PRO_System_Global_Entity", "{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1594480978,\n    \"type\": \"DUP_PRO_System_Global_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("4", "DUP_PRO_Package_Template_Entity", "{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("5", "DUP_PRO_Package_Template_Entity", "{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"database_filter_on\": 0,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"localhost\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}");

/* INSERT TABLE DATA: wp_iranamlak_map_data */
INSERT INTO `wp_iranamlak_map_data` VALUES("305", "", "", NULL, NULL, NULL, "", "", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("214", "خرید و فروش", "خانه و ویلا", "550000000", NULL, NULL, "36.7090957", "51.188221", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("6446", "خرید و فروش", "خانه و ویلا", "26000000000", NULL, NULL, "36.6444571", "51.49189", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("302", "", "", NULL, NULL, NULL, "", "", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("303", "", "", NULL, NULL, NULL, "", "", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("294", "", "", NULL, NULL, NULL, "", "", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("290", "", "", NULL, NULL, NULL, "", "", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("285", "", "", NULL, NULL, NULL, "", "", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("223", "", "", NULL, NULL, NULL, "", "", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("221", "", "", NULL, NULL, NULL, "", "", "publish");
INSERT INTO `wp_iranamlak_map_data` VALUES("212", "", "", NULL, NULL, NULL, "", "", "publish");

/* INSERT TABLE DATA: wp_iranamlak_orders */
INSERT INTO `wp_iranamlak_orders` VALUES("1", "1", "0", "5000", "send_agahi", "pay.ir", "pending", "c5eap54", NULL, "2022-02-05 12:54:22", "2022-02-05 12:54:22");
INSERT INTO `wp_iranamlak_orders` VALUES("2", "1", "5277", "5000", "send_agahi", "pay.ir", "pending", "c5eaqJU", NULL, "2022-02-05 12:55:13", "2022-02-05 12:55:13");
INSERT INTO `wp_iranamlak_orders` VALUES("3", "1", "5277", "5000", "send_agahi", "pay.ir", "paid", "c5eaqZ4", "65969", "2022-02-05 13:26:57", "2022-02-05 13:27:01");
INSERT INTO `wp_iranamlak_orders` VALUES("4", "1", "5277", "5000", "feature", "pay.ir", "paid", "c5eaqpY", "65971", "2022-02-05 13:30:13", "2022-02-05 13:30:15");
INSERT INTO `wp_iranamlak_orders` VALUES("5", "1", "5278", "5000", "send_agahi", "pay.ir", "pending", "c5eaqpk", NULL, "2022-02-05 13:31:03", "2022-02-05 13:31:03");
INSERT INTO `wp_iranamlak_orders` VALUES("6", "1", "5278", "5000", "send_agahi", "pay.ir", "paid", "c5eaqps", "65976", "2022-02-05 13:31:14", "2022-02-05 13:31:17");
INSERT INTO `wp_iranamlak_orders` VALUES("7", "1", "300", "2000", "tamdid", "pay.ir", "pending", "c5eaqpw", NULL, "2022-02-05 13:36:18", "2022-02-05 13:36:18");
INSERT INTO `wp_iranamlak_orders` VALUES("8", "1", "300", "2000", "tamdid", "pay.ir", "paid", "c5eaqp0", "65978", "2022-02-05 13:36:51", "2022-02-05 13:36:54");
INSERT INTO `wp_iranamlak_orders` VALUES("9", "2", "5267", "1000", "fast", "pay.ir", "paid", "c5iRrJo", "66095", "2022-02-05 18:38:53", "2022-02-05 18:38:58");
INSERT INTO `wp_iranamlak_orders` VALUES("10", "1", "303", "5000", "feature", "pay.ir", "pending", "c5iUqJU", NULL, "2022-02-06 19:24:36", "2022-02-06 19:24:36");
INSERT INTO `wp_iranamlak_orders` VALUES("11", "1", "5428", "5000", "send_agahi", "pay.ir", "pending", "c5iWpJ4", NULL, "2022-02-07 19:02:41", "2022-02-07 19:02:41");
INSERT INTO `wp_iranamlak_orders` VALUES("12", "1", "5429", "5000", "send_agahi", "pay.ir", "pending", "c5iWpZU", NULL, "2022-02-07 19:08:04", "2022-02-07 19:08:04");
INSERT INTO `wp_iranamlak_orders` VALUES("13", "1", "5430", "5000", "send_agahi", "pay.ir", "pending", "c5iWpZY", NULL, "2022-02-07 19:09:07", "2022-02-07 19:09:07");
INSERT INTO `wp_iranamlak_orders` VALUES("14", "1", "5439", "5000", "send_agahi", "pay.ir", "pending", "c5iWpZo", NULL, "2022-02-07 19:23:47", "2022-02-07 19:23:47");
INSERT INTO `wp_iranamlak_orders` VALUES("15", "1", "5442", "5000", "send_agahi", "pay.ir", "pending", "c5iWpZs", NULL, "2022-02-07 19:27:41", "2022-02-07 19:27:41");
INSERT INTO `wp_iranamlak_orders` VALUES("16", "1", "5443", "5000", "send_agahi", "pay.ir", "pending", "c5iWpZw", NULL, "2022-02-07 19:34:07", "2022-02-07 19:34:07");
INSERT INTO `wp_iranamlak_orders` VALUES("17", "1", "5445", "5000", "send_agahi", "pay.ir", "pending", "c5iWppU", NULL, "2022-02-07 19:45:27", "2022-02-07 19:45:27");
INSERT INTO `wp_iranamlak_orders` VALUES("18", "1", "5445", "5000", "send_agahi", "pay.ir", "paid", "c5iWppY", "66531", "2022-02-07 19:45:36", "2022-02-07 19:45:40");
INSERT INTO `wp_iranamlak_orders` VALUES("19", "1", "5445", "1000", "fast", "pay.ir", "paid", "c5iWppc", "66532", "2022-02-07 19:45:52", "2022-02-07 19:45:55");
INSERT INTO `wp_iranamlak_orders` VALUES("20", "1", "5446", "5000", "send_agahi", "pay.ir", "pending", "c5iWppg", NULL, "2022-02-07 19:47:08", "2022-02-07 19:47:08");
INSERT INTO `wp_iranamlak_orders` VALUES("21", "1", "5448", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000759694", NULL, "2022-02-07 20:34:14", "2022-02-07 20:34:14");
INSERT INTO `wp_iranamlak_orders` VALUES("22", "1", "5449", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000759696", NULL, "2022-02-07 20:36:11", "2022-02-07 20:36:11");
INSERT INTO `wp_iranamlak_orders` VALUES("23", "1", "5450", "5000", "send_agahi", "pay.ir", "pending", "c5iWp5k", NULL, "2022-02-07 20:36:47", "2022-02-07 20:36:47");
INSERT INTO `wp_iranamlak_orders` VALUES("24", "1", "5451", "5000", "send_agahi", "pay.ir", "pending", "c5iWp5o", NULL, "2022-02-07 20:37:39", "2022-02-07 20:37:39");
INSERT INTO `wp_iranamlak_orders` VALUES("25", "1", "5453", "5000", "send_agahi", "pay.ir", "pending", "c5iWp5s", NULL, "2022-02-07 20:38:29", "2022-02-07 20:38:29");
INSERT INTO `wp_iranamlak_orders` VALUES("26", "1", "5454", "5000", "send_agahi", "pay.ir", "pending", "c5iWp5w", NULL, "2022-02-07 20:39:18", "2022-02-07 20:39:18");
INSERT INTO `wp_iranamlak_orders` VALUES("27", "1", "5456", "5000", "send_agahi", "pay.ir", "paid", "c5iXpZw", "66627", "2022-02-08 11:19:10", "2022-02-08 11:19:16");
INSERT INTO `wp_iranamlak_orders` VALUES("28", "1", "5457", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000760097", "12345678", "2022-02-08 12:21:04", "2022-02-08 12:21:07");
INSERT INTO `wp_iranamlak_orders` VALUES("29", "1", "5458", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000760221", "12345678", "2022-02-08 12:57:52", "2022-02-08 12:57:55");
INSERT INTO `wp_iranamlak_orders` VALUES("30", "1", "5459", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000760224", "12345678", "2022-02-08 12:59:59", "2022-02-08 13:00:02");
INSERT INTO `wp_iranamlak_orders` VALUES("31", "1", "5463", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000760367", "12345678", "2022-02-08 14:16:58", "2022-02-08 14:17:03");
INSERT INTO `wp_iranamlak_orders` VALUES("32", "1", "5464", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760382", NULL, "2022-02-08 14:21:37", "2022-02-08 14:21:37");
INSERT INTO `wp_iranamlak_orders` VALUES("33", "1", "5464", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760384", NULL, "2022-02-08 14:22:11", "2022-02-08 14:22:11");
INSERT INTO `wp_iranamlak_orders` VALUES("34", "1", "5466", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000760401", "12345678", "2022-02-08 14:30:19", "2022-02-08 14:30:30");
INSERT INTO `wp_iranamlak_orders` VALUES("35", "2", "5465", "5000", "feature", "زرین پال", "paid", "000000000000000000000000000000760405", "12345678", "2022-02-08 14:32:20", "2022-02-08 14:32:25");
INSERT INTO `wp_iranamlak_orders` VALUES("36", "2", "5467", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760584", NULL, "2022-02-08 16:45:33", "2022-02-08 16:45:33");
INSERT INTO `wp_iranamlak_orders` VALUES("37", "2", "5468", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760586", NULL, "2022-02-08 16:46:49", "2022-02-08 16:46:49");
INSERT INTO `wp_iranamlak_orders` VALUES("38", "2", "5468", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760589", NULL, "2022-02-08 16:47:27", "2022-02-08 16:47:27");
INSERT INTO `wp_iranamlak_orders` VALUES("39", "2", "5469", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000760613", "12345678", "2022-02-08 17:02:43", "2022-02-08 17:02:59");
INSERT INTO `wp_iranamlak_orders` VALUES("40", "1", "5470", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000760618", "12345678", "2022-02-08 17:07:44", "2022-02-08 17:07:49");
INSERT INTO `wp_iranamlak_orders` VALUES("41", "1", "5471", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760625", NULL, "2022-02-08 17:15:14", "2022-02-08 17:15:14");
INSERT INTO `wp_iranamlak_orders` VALUES("42", "1", "5472", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760627", NULL, "2022-02-08 17:16:52", "2022-02-08 17:16:52");
INSERT INTO `wp_iranamlak_orders` VALUES("43", "2", "5473", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760629", NULL, "2022-02-08 17:18:21", "2022-02-08 17:18:21");
INSERT INTO `wp_iranamlak_orders` VALUES("44", "2", "5474", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760630", NULL, "2022-02-08 17:19:30", "2022-02-08 17:19:30");
INSERT INTO `wp_iranamlak_orders` VALUES("45", "1", "5475", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760631", NULL, "2022-02-08 17:20:30", "2022-02-08 17:20:30");
INSERT INTO `wp_iranamlak_orders` VALUES("46", "2", "5476", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760852", NULL, "2022-02-08 23:05:39", "2022-02-08 23:05:39");
INSERT INTO `wp_iranamlak_orders` VALUES("47", "2", "5476", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760861", NULL, "2022-02-08 23:20:08", "2022-02-08 23:20:08");
INSERT INTO `wp_iranamlak_orders` VALUES("48", "2", "5476", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760862", NULL, "2022-02-08 23:20:27", "2022-02-08 23:20:27");
INSERT INTO `wp_iranamlak_orders` VALUES("49", "2", "5476", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760866", NULL, "2022-02-08 23:24:59", "2022-02-08 23:24:59");
INSERT INTO `wp_iranamlak_orders` VALUES("50", "2", "5477", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000760867", NULL, "2022-02-08 23:25:42", "2022-02-08 23:25:42");
INSERT INTO `wp_iranamlak_orders` VALUES("51", "2", "5478", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000760998", "12345678", "2022-02-09 09:33:24", "2022-02-09 09:33:27");
INSERT INTO `wp_iranamlak_orders` VALUES("52", "2", "5479", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761008", "12345678", "2022-02-09 09:39:05", "2022-02-09 09:39:08");
INSERT INTO `wp_iranamlak_orders` VALUES("53", "1", "5480", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761012", "12345678", "2022-02-09 09:40:04", "2022-02-09 09:40:07");
INSERT INTO `wp_iranamlak_orders` VALUES("54", "2", "5481", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761020", "12345678", "2022-02-09 09:42:57", "2022-02-09 09:43:00");
INSERT INTO `wp_iranamlak_orders` VALUES("55", "2", "5482", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761025", "12345678", "2022-02-09 09:50:08", "2022-02-09 09:50:11");
INSERT INTO `wp_iranamlak_orders` VALUES("56", "2", "5483", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761027", "12345678", "2022-02-09 09:53:13", "2022-02-09 09:53:15");
INSERT INTO `wp_iranamlak_orders` VALUES("57", "2", "5484", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761036", "12345678", "2022-02-09 09:57:38", "2022-02-09 09:57:40");
INSERT INTO `wp_iranamlak_orders` VALUES("58", "1", "5485", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761042", "12345678", "2022-02-09 09:59:43", "2022-02-09 09:59:45");
INSERT INTO `wp_iranamlak_orders` VALUES("59", "1", "5486", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000761386", NULL, "2022-02-09 15:47:33", "2022-02-09 15:47:33");
INSERT INTO `wp_iranamlak_orders` VALUES("60", "1", "5487", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000761387", NULL, "2022-02-09 15:47:52", "2022-02-09 15:47:52");
INSERT INTO `wp_iranamlak_orders` VALUES("61", "2", "5488", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000761388", NULL, "2022-02-09 15:48:48", "2022-02-09 15:48:48");
INSERT INTO `wp_iranamlak_orders` VALUES("62", "2", "5489", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761407", "12345678", "2022-02-09 16:13:56", "2022-02-09 16:13:59");
INSERT INTO `wp_iranamlak_orders` VALUES("63", "2", "5490", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000761424", NULL, "2022-02-09 16:26:55", "2022-02-09 16:26:55");
INSERT INTO `wp_iranamlak_orders` VALUES("64", "1", "5491", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000761547", "12345678", "2022-02-09 19:10:26", "2022-02-09 19:10:29");
INSERT INTO `wp_iranamlak_orders` VALUES("65", "2", "5490", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000762466", NULL, "2022-02-10 21:40:37", "2022-02-10 21:40:37");
INSERT INTO `wp_iranamlak_orders` VALUES("66", "1", "300", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000763364", "12345678", "2022-02-12 13:21:42", "2022-02-12 13:21:51");
INSERT INTO `wp_iranamlak_orders` VALUES("67", "1", "4687", "2000", "tamdid", "زرین پال", "paid", "000000000000000000000000000000763368", "12345678", "2022-02-12 13:26:34", "2022-02-12 13:26:37");
INSERT INTO `wp_iranamlak_orders` VALUES("68", "1", "4687", "5000", "feature", "زرین پال", "pending", "000000000000000000000000000000763770", NULL, "2022-02-12 19:04:35", "2022-02-12 19:04:35");
INSERT INTO `wp_iranamlak_orders` VALUES("69", "1", "4687", "5000", "feature", "زرین پال", "pending", "000000000000000000000000000000766974", NULL, "2022-02-16 19:35:14", "2022-02-16 19:35:14");
INSERT INTO `wp_iranamlak_orders` VALUES("70", "160", "5520", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000771224", NULL, "2022-02-22 11:42:22", "2022-02-22 11:42:22");
INSERT INTO `wp_iranamlak_orders` VALUES("71", "1", "0", "150000", "moshaver", "زرین پال", "paid", "000000000000000000000000000000775137", "12345678", "2022-02-25 13:41:40", "2022-02-25 13:41:45");
INSERT INTO `wp_iranamlak_orders` VALUES("72", "161", "0", "150000", "moshaver", "زرین پال", "paid", "000000000000000000000000000000775142", "12345678", "2022-02-25 13:44:44", "2022-02-25 13:44:47");
INSERT INTO `wp_iranamlak_orders` VALUES("73", "1", "4687", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000782660", "12345678", "2022-03-06 16:45:42", "2022-03-06 16:45:48");
INSERT INTO `wp_iranamlak_orders` VALUES("74", "1", "5779", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000793120", NULL, "2022-03-17 20:06:24", "2022-03-17 20:06:24");
INSERT INTO `wp_iranamlak_orders` VALUES("75", "1", "5778", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000793294", "12345678", "2022-03-18 14:26:17", "2022-03-18 14:26:20");
INSERT INTO `wp_iranamlak_orders` VALUES("76", "1", "5779", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000793320", "12345678", "2022-03-18 16:09:25", "2022-03-18 16:09:28");
INSERT INTO `wp_iranamlak_orders` VALUES("77", "1", "4687", "5000", "feature", "زرین پال", "pending", "000000000000000000000000000000802238", NULL, "2022-04-05 22:03:19", "2022-04-05 22:03:19");
INSERT INTO `wp_iranamlak_orders` VALUES("78", "1", "2", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000802295", NULL, "2022-04-06 00:21:25", "2022-04-06 00:21:25");
INSERT INTO `wp_iranamlak_orders` VALUES("79", "1", "4687", "5000", "feature", "زرین پال", "pending", "000000000000000000000000000000802322", NULL, "2022-04-06 02:15:24", "2022-04-06 02:15:24");
INSERT INTO `wp_iranamlak_orders` VALUES("80", "1", "4687", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000817861", NULL, "2022-04-26 10:39:49", "2022-04-26 10:39:49");
INSERT INTO `wp_iranamlak_orders` VALUES("81", "1", "5496", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000819184", NULL, "2022-04-28 01:54:50", "2022-04-28 01:54:50");
INSERT INTO `wp_iranamlak_orders` VALUES("82", "1", "6149", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000819187", "12345678", "2022-04-28 02:04:34", "2022-04-28 02:04:37");
INSERT INTO `wp_iranamlak_orders` VALUES("83", "1", "4687", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000819911", NULL, "2022-04-29 14:14:46", "2022-04-29 14:14:46");
INSERT INTO `wp_iranamlak_orders` VALUES("84", "165", "6156", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000822812", "12345678", "2022-05-02 21:22:20", "2022-05-02 21:22:34");
INSERT INTO `wp_iranamlak_orders` VALUES("85", "165", "6156", "1000", "fast", "زرین پال", "pending", "000000000000000000000000000000822813", NULL, "2022-05-02 21:22:43", "2022-05-02 21:22:43");
INSERT INTO `wp_iranamlak_orders` VALUES("89", "165", "0", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000827122", NULL, "2022-05-09 06:37:21", "2022-05-09 06:37:21");
INSERT INTO `wp_iranamlak_orders` VALUES("87", "2", "6158", "5000", "feature", "زرین پال", "paid", "000000000000000000000000000000822926", "12345678", "2022-05-03 04:10:51", "2022-05-03 04:10:55");
INSERT INTO `wp_iranamlak_orders` VALUES("88", "2", "6158", "1000", "fast", "زرین پال", "paid", "000000000000000000000000000000822927", "12345678", "2022-05-03 04:11:00", "2022-05-03 04:11:03");
INSERT INTO `wp_iranamlak_orders` VALUES("90", "166", "6320", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000831989", "12345678", "2022-05-15 18:44:56", "2022-05-15 18:45:09");
INSERT INTO `wp_iranamlak_orders` VALUES("91", "167", "6322", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000832352", "12345678", "2022-05-16 10:39:42", "2022-05-16 10:39:47");
INSERT INTO `wp_iranamlak_orders` VALUES("92", "165", "6323", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000836010", NULL, "2022-05-21 04:35:15", "2022-05-21 04:35:15");
INSERT INTO `wp_iranamlak_orders` VALUES("93", "165", "6323", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000836011", NULL, "2022-05-21 04:35:44", "2022-05-21 04:35:44");
INSERT INTO `wp_iranamlak_orders` VALUES("94", "165", "6323", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000836013", "12345678", "2022-05-21 04:36:42", "2022-05-21 04:36:45");
INSERT INTO `wp_iranamlak_orders` VALUES("95", "165", "0", "150000", "moshaver", "زرین پال", "pending", "000000000000000000000000000000836015", NULL, "2022-05-21 04:37:05", "2022-05-21 04:37:05");
INSERT INTO `wp_iranamlak_orders` VALUES("96", "1", "6324", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000836154", "12345678", "2022-05-21 10:03:32", "2022-05-21 10:03:40");
INSERT INTO `wp_iranamlak_orders` VALUES("97", "1", "6327", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000836170", "12345678", "2022-05-21 10:14:25", "2022-05-21 10:14:28");
INSERT INTO `wp_iranamlak_orders` VALUES("98", "1", "0", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000836831", "12345678", "2022-05-21 17:57:19", "2022-05-21 17:57:31");
INSERT INTO `wp_iranamlak_orders` VALUES("99", "0", "6345", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000836927", NULL, "2022-05-21 20:54:27", "2022-05-21 20:54:27");
INSERT INTO `wp_iranamlak_orders` VALUES("100", "173", "6347", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000836941", "12345678", "2022-05-21 21:20:19", "2022-05-21 21:20:25");
INSERT INTO `wp_iranamlak_orders` VALUES("101", "173", "6348", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000836944", "12345678", "2022-05-21 21:26:50", "2022-05-21 21:26:53");
INSERT INTO `wp_iranamlak_orders` VALUES("102", "173", "6349", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000836955", "12345678", "2022-05-21 21:36:39", "2022-05-21 21:36:43");
INSERT INTO `wp_iranamlak_orders` VALUES("103", "1", "6350", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000836983", NULL, "2022-05-21 22:36:47", "2022-05-21 22:36:47");
INSERT INTO `wp_iranamlak_orders` VALUES("104", "1", "6352", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000836984", NULL, "2022-05-21 22:37:26", "2022-05-21 22:37:26");
INSERT INTO `wp_iranamlak_orders` VALUES("105", "1", "6356", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000836996", NULL, "2022-05-21 22:58:31", "2022-05-21 22:58:31");
INSERT INTO `wp_iranamlak_orders` VALUES("106", "175", "0", "150000", "moshaver", "زرین پال", "paid", "000000000000000000000000000000838548", "12345678", "2022-05-23 16:02:16", "2022-05-23 16:02:29");
INSERT INTO `wp_iranamlak_orders` VALUES("107", "1", "6356", "5000", "send_agahi", "زرین پال", "paid", "000000000000000000000000000000842582", "12345678", "2022-05-28 12:12:24", "2022-05-28 12:12:27");
INSERT INTO `wp_iranamlak_orders` VALUES("108", "1", "4687", "5000", "send_agahi", "زرین پال", "pending", "000000000000000000000000000000849276", NULL, "2022-06-05 17:41:40", "2022-06-05 17:41:40");
INSERT INTO `wp_iranamlak_orders` VALUES("109", "188", "0", "150000", "moshaver", "pay.ir", "paid", "c5WRpA", "6301", "2022-07-05 01:03:37", "2022-07-05 01:03:39");
INSERT INTO `wp_iranamlak_orders` VALUES("110", "191", "0", "150000", "moshaver", "pay.ir", "paid", "dJuVqw", "7948", "2022-07-15 19:05:23", "2022-07-15 19:05:30");
INSERT INTO `wp_iranamlak_orders` VALUES("111", "192", "0", "150000", "moshaver", "pay.ir", "paid", "dJuXpQ", "7962", "2022-07-15 23:24:56", "2022-07-15 23:25:00");
INSERT INTO `wp_iranamlak_orders` VALUES("112", "194", "0", "150000", "moshaver", "pay.ir", "paid", "dZiXpw", "8664", "2022-07-19 20:45:21", "2022-07-19 20:45:26");
INSERT INTO `wp_iranamlak_orders` VALUES("113", "1", "0", "150000", "moshaver", "pay.ir", "pending", "dpqSpA", NULL, "2022-07-26 14:25:20", "2022-07-26 14:25:20");
INSERT INTO `wp_iranamlak_orders` VALUES("114", "1", "6446", "5000", "feature", "pay.ir", "paid", "dpqSpQ", "9812", "2022-07-26 14:25:46", "2022-07-26 14:25:50");
INSERT INTO `wp_iranamlak_orders` VALUES("115", "203", "0", "150000", "moshaver", "pay.ir", "pending", "cJSZo5U", NULL, "2022-12-22 17:51:24", "2022-12-22 17:51:24");

/* INSERT TABLE DATA: wp_iranamlak_orders_filing */
INSERT INTO `wp_iranamlak_orders_filing` VALUES("17", "2", "303");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("16", "1", "212");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("15", "2", "294");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("14", "2", "296");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("13", "2", "221");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("18", "183", "221");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("19", "2", "302");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("20", "1", "305");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("21", "191", "1896");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("22", "191", "214");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("23", "2", "290");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("24", "191", "305");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("25", "2", "305");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("26", "2", "297");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("27", "2", "6446");
INSERT INTO `wp_iranamlak_orders_filing` VALUES("28", "2", "214");

/* INSERT TABLE DATA: wp_iranamlak_orders_packages */
INSERT INTO `wp_iranamlak_orders_packages` VALUES("1", "1", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpSSpw", "1214", "2022-06-07 12:47:27", "2022-06-07 12:47:31");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("2", "1", "10000", "10", "20", "30", "40", "پکیج یک", "pay.ir", "paid", "bpSSqA", "1215", "2022-06-07 12:49:08", "2022-06-07 12:49:10");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("3", "2", "0", "5", "10", "15", "20", "پکیج سه", "پرداخت رایگان", "paid", "000", "000", "2022-06-11 00:18:16", "2022-06-11 00:18:16");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("4", "2", "0", "5", "10", "15", "20", "پکیج سه", "پرداخت رایگان", "paid", "000", "000", "2022-06-11 00:18:41", "2022-06-11 00:18:41");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("5", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpuSrA", "1919", "2022-06-11 00:18:52", "2022-06-11 00:18:56");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("6", "183", "10000", "10", "20", "30", "40", "پکیج یک", "pay.ir", "paid", "b5qTpA", "2821", "2022-06-14 17:28:18", "2022-06-14 17:28:22");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("7", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "cZuUrA", NULL, "2022-06-26 16:22:05", "2022-06-26 16:22:05");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("8", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "cZuVow", "4940", "2022-06-26 16:22:15", "2022-06-26 16:22:18");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("9", "186", "10000", "10", "20", "30", "40", "پکیج یک", "pay.ir", "paid", "cpWXpQ", "5362", "2022-06-29 12:57:20", "2022-06-29 12:57:27");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("10", "2", "0", "5", "10", "15", "20", "پکیج سه", "پرداخت رایگان", "paid", "000", "000", "2022-07-03 23:48:47", "2022-07-03 23:48:47");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("11", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "cpuZrA", NULL, "2022-07-03 23:59:22", "2022-07-03 23:59:22");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("12", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "cpuaow", "5990", "2022-07-03 23:59:28", "2022-07-03 23:59:30");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("13", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "c5KRqQ", "6006", "2022-07-04 00:35:54", "2022-07-04 00:35:56");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("14", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "c5Saqw", "6298", "2022-07-05 00:48:38", "2022-07-05 00:48:42");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("15", "188", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "c5WRpQ", "6302", "2022-07-05 01:03:52", "2022-07-05 01:03:54");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("16", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "dJSTrA", "7229", "2022-07-09 18:01:15", "2022-07-09 18:01:17");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("17", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "dJSUow", NULL, "2022-07-09 18:01:45", "2022-07-09 18:01:45");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("18", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "dJSUpA", "7231", "2022-07-09 18:02:51", "2022-07-09 18:02:54");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("19", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "dJSYqg", "7277", "2022-07-10 03:17:05", "2022-07-10 03:17:07");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("20", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "dJuRpA", "7901", "2022-07-15 12:09:12", "2022-07-15 12:09:16");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("21", "191", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "dJuVrA", "7949", "2022-07-15 19:08:08", "2022-07-15 19:08:10");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("22", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "dZKRqA", "8005", "2022-07-16 12:49:27", "2022-07-16 12:49:33");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("23", "191", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "dZmRpA", "8701", "2022-07-20 10:04:02", "2022-07-20 10:04:08");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("24", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpKSq5w", "10187", "2022-07-28 16:32:40", "2022-07-28 16:32:49");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("25", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "bpKSq50", NULL, "2022-07-28 16:33:01", "2022-07-28 16:33:01");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("26", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "bpKSq54", NULL, "2022-07-28 16:33:12", "2022-07-28 16:33:12");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("27", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpKSrJs", "10196", "2022-07-28 17:21:34", "2022-07-28 17:21:51");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("28", "2", "0", "5", "10", "15", "20", "پکیج سه", "پرداخت رایگان", "paid", "000", "000", "2022-08-07 01:08:00", "2022-08-07 01:08:00");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("29", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "bpOapZs", NULL, "2022-08-07 01:08:07", "2022-08-07 01:08:07");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("30", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpOapZw", "11927", "2022-08-07 01:08:18", "2022-08-07 01:08:20");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("31", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpOapZ0", "11928", "2022-08-07 01:08:26", "2022-08-07 01:08:28");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("32", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpOappY", "11931", "2022-08-07 02:08:20", "2022-08-07 02:08:26");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("33", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "bpOappg", NULL, "2022-08-07 03:01:22", "2022-08-07 03:01:22");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("34", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "bpaRqZc", NULL, "2022-08-21 22:57:26", "2022-08-21 22:57:26");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("35", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpaWp54", "14549", "2022-08-23 16:09:06", "2022-08-23 16:09:10");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("36", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "bpaWqJU", "14550", "2022-08-23 16:09:24", "2022-08-23 16:09:27");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("37", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "b5OSqZg", NULL, "2022-10-03 22:21:51", "2022-10-03 22:21:51");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("38", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "b5eZqZc", "25862", "2022-11-14 11:31:17", "2022-11-14 11:31:20");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("39", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "b5iZpJk", "26814", "2022-11-22 03:10:40", "2022-11-22 03:10:52");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("40", "2", "0", "5", "10", "15", "20", "پکیج سه", "پرداخت رایگان", "paid", "000", "000", "2022-11-22 03:11:12", "2022-11-22 03:11:12");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("41", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "b5iZrJk", "26894", "2022-11-22 14:30:03", "2022-11-22 14:30:14");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("42", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "b5qTo5U", "28200", "2022-11-24 19:56:52", "2022-11-24 19:56:58");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("43", "202", "10000", "10", "20", "30", "40", "پکیج یک", "pay.ir", "paid", "b5uaq50", "29988", "2022-12-06 10:00:15", "2022-12-06 10:00:28");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("44", "202", "10000", "10", "20", "30", "40", "پکیج یک", "pay.ir", "paid", "cJKRqpw", "30077", "2022-12-06 17:08:59", "2022-12-06 17:09:06");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("45", "202", "10000", "10", "20", "30", "40", "پکیج یک", "pay.ir", "paid", "cJKRqp0", "30078", "2022-12-06 17:09:48", "2022-12-06 17:09:50");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("46", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "cJWRqJo", "33055", "2022-12-24 13:07:56", "2022-12-24 13:08:02");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("47", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "pending", "cJaYqJ0", NULL, "2023-01-01 23:33:45", "2023-01-01 23:33:45");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("48", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "cJaYqJ4", "34759", "2023-01-01 23:34:02", "2023-01-01 23:34:05");
INSERT INTO `wp_iranamlak_orders_packages` VALUES("49", "2", "20000", "25", "40", "50", "59", "پکیج دو", "pay.ir", "paid", "cJaYqZY", "34761", "2023-01-01 23:34:43", "2023-01-01 23:34:46");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://sitralweb.com/ir3/", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://sitralweb.com/ir3", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "قالب ایران املاک", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@sitralweb.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "Y-m-d", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i A", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:120:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:8:\"state/?$\";s:25:\"index.php?post_type=state\";s:38:\"state/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=state&feed=$matches[1]\";s:33:\"state/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=state&feed=$matches[1]\";s:25:\"state/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=state&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:41:\"index.php?post_tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?post_tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:30:\"index.php?post_tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:55:\"state_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?taxonomy=state_category&term=$matches[1]&feed=$matches[2]\";s:50:\"state_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?taxonomy=state_category&term=$matches[1]&feed=$matches[2]\";s:31:\"state_category/([^/]+)/embed/?$\";s:61:\"index.php?taxonomy=state_category&term=$matches[1]&embed=true\";s:43:\"state_category/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?taxonomy=state_category&term=$matches[1]&paged=$matches[2]\";s:25:\"state_category/([^/]+)/?$\";s:50:\"index.php?taxonomy=state_category&term=$matches[1]\";s:33:\"state/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"state/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"state/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"state/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"state/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"state/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"state/([^/]+)/embed/?$\";s:38:\"index.php?state=$matches[1]&embed=true\";s:26:\"state/([^/]+)/trackback/?$\";s:32:\"index.php?state=$matches[1]&tb=1\";s:46:\"state/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?state=$matches[1]&feed=$matches[2]\";s:41:\"state/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?state=$matches[1]&feed=$matches[2]\";s:34:\"state/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?state=$matches[1]&paged=$matches[2]\";s:41:\"state/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?state=$matches[1]&cpage=$matches[2]\";s:30:\"state/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?state=$matches[1]&page=$matches[2]\";s:22:\"state/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"state/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"state/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"state/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"state/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"state/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("111028", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1694527610;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:7:\"1.5.5.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicator.1.5.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}}}", "no");
INSERT INTO `wp_options` VALUES("111027", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.3.1.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.3.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.3.1\";s:7:\"version\";s:5:\"6.3.1\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1694527612;s:15:\"version_checked\";s:5:\"6.3.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:3:{i:0;s:33:\"classic-editor/classic-editor.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:25:\"duplicator/duplicator.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:3:{i:0;s:75:\"/home/yousefamini/public_html/ir3/wp-content/themes/iranamlak/functions.php\";i:1;s:71:\"/home/yousefamini/public_html/ir3/wp-content/themes/iranamlak/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "iranamlak", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "iranamlak", "yes");
INSERT INTO `wp_options` VALUES("6287", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "karbar", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "55853", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "0", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:5:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:22:\"acf-dropzone/index.php\";a:2:{i:0;s:23:\"AcfDropzone\\Core\\Plugin\";i:1;s:9:\"uninstall\";}s:101:\"home/yousefamini/public_html/iranamlak/wp-content/themes/iranamlak/admin/core/openstreetmap/index.php\";a:2:{i:0;s:33:\"ACFFieldOpenstreetmap\\Core\\Plugin\";i:1;s:9:\"uninstall\";}s:116:\"home/yousefamini/public_html/iranamlak/wp-content/themes/iranamlak/admin/update-checker/core/openstreetmap/index.php\";a:2:{i:0;s:33:\"ACFFieldOpenstreetmap\\Core\\Plugin\";i:1;s:9:\"uninstall\";}s:110:\"home/yousefamini/public_html/ir3/wp-content/themes/iranamlak/admin/update-checker/core/openstreetmap/index.php\";a:2:{i:0;s:33:\"ACFFieldOpenstreetmap\\Core\\Plugin\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "2", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "admin_email_lifespan", "1704555388", "yes");
INSERT INTO `wp_options` VALUES("94", "initial_db_version", "47018", "yes");
INSERT INTO `wp_options` VALUES("95", "wp_user_roles", "a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:140:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:16:\"rcp_view_members\";b:1;s:18:\"rcp_manage_members\";b:1;s:15:\"rcp_view_levels\";b:1;s:17:\"rcp_manage_levels\";b:1;s:18:\"rcp_view_discounts\";b:1;s:20:\"rcp_manage_discounts\";b:1;s:17:\"rcp_view_payments\";b:1;s:19:\"rcp_manage_payments\";b:1;s:19:\"rcp_manage_settings\";b:1;s:15:\"rcp_export_data\";b:1;s:13:\"rcp_view_help\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:9:\"read_post\";b:1;s:24:\"read_private_sgpb_popups\";b:1;s:15:\"edit_sgpb_popup\";b:1;s:16:\"edit_sgpb_popups\";b:1;s:23:\"edit_others_sgpb_popups\";b:1;s:26:\"edit_published_sgpb_popups\";b:1;s:19:\"publish_sgpb_popups\";b:1;s:18:\"delete_sgpb_popups\";b:1;s:25:\"delete_others_sgpb_popups\";b:1;s:26:\"delete_private_sgpb_popups\";b:1;s:25:\"delete_private_sgpb_popup\";b:1;s:28:\"delete_published_sgpb_popups\";b:1;s:19:\"sgpb_manage_options\";b:1;s:18:\"manage_popup_terms\";b:1;s:29:\"manage_popup_categories_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:33:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:9:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:7:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:12:\"upload_files\";b:1;s:17:\"unfiltered_upload\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"moshaver\";a:2:{s:4:\"name\";s:21:\"مشاور املاک\";s:12:\"capabilities\";a:43:{s:4:\"read\";b:1;s:10:\"edit_files\";b:1;s:12:\"delete_files\";b:1;s:12:\"create_files\";b:1;s:24:\"allow_subscriber_uploads\";b:1;s:20:\"allow_author_uploads\";b:1;s:17:\"unfiltered_upload\";b:1;s:15:\"unfiltered_html\";b:1;s:22:\"delete_published_state\";b:1;s:12:\"delete_state\";b:1;s:10:\"read_state\";b:1;s:10:\"edit_state\";b:1;s:17:\"edit_others_state\";b:1;s:20:\"edit_published_state\";b:1;s:13:\"publish_state\";b:1;s:19:\"delete_others_state\";b:1;s:20:\"delete_private_state\";b:1;s:20:\"publish_others_pages\";b:0;s:20:\"publish_others_posts\";b:0;s:13:\"publish_pages\";b:0;s:13:\"publish_posts\";b:0;s:21:\"publish_private_pages\";b:0;s:21:\"publish_private_posts\";b:0;s:23:\"publish_published_pages\";b:0;s:23:\"publish_published_posts\";b:0;s:19:\"delete_others_pages\";b:0;s:19:\"delete_others_posts\";b:0;s:12:\"delete_pages\";b:0;s:12:\"delete_posts\";b:0;s:20:\"delete_private_pages\";b:0;s:20:\"delete_private_posts\";b:0;s:22:\"delete_published_pages\";b:0;s:22:\"delete_published_posts\";b:0;s:17:\"edit_others_pages\";b:0;s:17:\"edit_others_posts\";b:0;s:10:\"edit_pages\";b:0;s:10:\"edit_posts\";b:1;s:18:\"edit_private_pages\";b:0;s:18:\"edit_private_posts\";b:0;s:20:\"edit_published_pages\";b:0;s:20:\"edit_published_posts\";b:0;s:18:\"edit_theme_options\";b:0;s:12:\"upload_files\";b:1;}}s:6:\"karbar\";a:2:{s:4:\"name\";s:19:\"کاربر عادی\";s:12:\"capabilities\";a:43:{s:4:\"read\";b:1;s:10:\"edit_files\";b:1;s:12:\"delete_files\";b:1;s:12:\"create_files\";b:1;s:24:\"allow_subscriber_uploads\";b:1;s:20:\"allow_author_uploads\";b:1;s:17:\"unfiltered_upload\";b:1;s:15:\"unfiltered_html\";b:1;s:22:\"delete_published_state\";b:1;s:12:\"delete_state\";b:1;s:10:\"read_state\";b:1;s:10:\"edit_state\";b:1;s:17:\"edit_others_state\";b:1;s:20:\"edit_published_state\";b:1;s:13:\"publish_state\";b:1;s:19:\"delete_others_state\";b:1;s:20:\"delete_private_state\";b:1;s:20:\"publish_others_pages\";b:0;s:20:\"publish_others_posts\";b:0;s:13:\"publish_pages\";b:0;s:13:\"publish_posts\";b:0;s:21:\"publish_private_pages\";b:0;s:21:\"publish_private_posts\";b:0;s:23:\"publish_published_pages\";b:0;s:23:\"publish_published_posts\";b:0;s:19:\"delete_others_pages\";b:0;s:19:\"delete_others_posts\";b:0;s:12:\"delete_pages\";b:0;s:12:\"delete_posts\";b:0;s:20:\"delete_private_pages\";b:0;s:20:\"delete_private_posts\";b:0;s:22:\"delete_published_pages\";b:0;s:22:\"delete_published_posts\";b:0;s:17:\"edit_others_pages\";b:0;s:17:\"edit_others_posts\";b:0;s:10:\"edit_pages\";b:0;s:10:\"edit_posts\";b:1;s:18:\"edit_private_pages\";b:0;s:18:\"edit_private_posts\";b:0;s:20:\"edit_published_pages\";b:0;s:20:\"edit_published_posts\";b:0;s:18:\"edit_theme_options\";b:0;s:12:\"upload_files\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:7:\"karmand\";a:2:{s:4:\"name\";s:12:\"کارمند\";s:12:\"capabilities\";a:44:{s:4:\"read\";b:1;s:10:\"edit_files\";b:1;s:12:\"delete_files\";b:1;s:12:\"create_files\";b:1;s:24:\"allow_subscriber_uploads\";b:1;s:20:\"allow_author_uploads\";b:1;s:17:\"unfiltered_upload\";b:1;s:15:\"unfiltered_html\";b:1;s:22:\"delete_published_state\";b:1;s:12:\"delete_state\";b:1;s:10:\"read_state\";b:1;s:10:\"edit_state\";b:1;s:17:\"edit_others_state\";b:1;s:20:\"edit_published_state\";b:1;s:13:\"publish_state\";b:1;s:19:\"delete_others_state\";b:1;s:20:\"delete_private_state\";b:1;s:20:\"publish_others_pages\";b:0;s:20:\"publish_others_posts\";b:1;s:13:\"publish_pages\";b:0;s:13:\"publish_posts\";b:1;s:5:\"pages\";b:0;s:5:\"posts\";b:1;s:21:\"publish_private_pages\";b:0;s:21:\"publish_private_posts\";b:1;s:23:\"publish_published_pages\";b:0;s:23:\"publish_published_posts\";b:1;s:19:\"delete_others_pages\";b:0;s:19:\"delete_others_posts\";b:1;s:12:\"delete_pages\";b:0;s:12:\"delete_posts\";b:1;s:20:\"delete_private_pages\";b:0;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:0;s:22:\"delete_published_posts\";b:1;s:17:\"edit_others_pages\";b:0;s:17:\"edit_others_posts\";b:1;s:10:\"edit_pages\";b:0;s:10:\"edit_posts\";b:1;s:18:\"edit_private_pages\";b:0;s:18:\"edit_private_posts\";b:1;s:20:\"edit_published_pages\";b:0;s:20:\"edit_published_posts\";b:1;s:18:\"edit_theme_options\";b:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("96", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("97", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("3604", "duplicator_new_storage_position", "1", "yes");
INSERT INTO `wp_options` VALUES("37288", "gperks_version", "2.2.2", "yes");
INSERT INTO `wp_options` VALUES("26857", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("122", "auth_key", "ENuAW,rn-q#(ZenS/BOCAOX@do6RCu@1B;y]UQU` yuFsR/#DtV`7Au^~0pq4-8S", "no");
INSERT INTO `wp_options` VALUES("123", "auth_salt", "Xh4e$~502<8#~^^*7iVm=t5ar[jD5 !#Zqv,)R0Q}XjUd21zp&Ov.S|nn/^ACpn|", "no");
INSERT INTO `wp_options` VALUES("124", "logged_in_key", "`Zo!K2zzf]wg|=sVbc^?lJAl1=`OmhY@7q oPhVRUupAoczt@8nN:$Dph]_UrHW>", "no");
INSERT INTO `wp_options` VALUES("125", "logged_in_salt", "v_-Ea;^o?E`KqG4kqy.Srl^}]ebLaQn-A<$Y7lov!Dy3e<n+~TKKx_i./]gaf~~+", "no");
INSERT INTO `wp_options` VALUES("104", "cron", "a:23:{i:1694535406;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1694535413;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1694536718;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1694542603;a:2:{s:23:\"rcp_check_member_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:27:\"rcp_mark_abandoned_payments\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694542806;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1694542807;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1694545395;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1694547179;a:2:{s:17:\"expired_adv_amlak\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:24:\"expired_adv_amlak_before\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1694548094;a:1:{s:20:\"rtlt_refresh_updates\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1694548180;a:1:{s:18:\"rtlt_general_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1694568178;a:1:{s:38:\"puc_cron_check_updates_theme-iranamlak\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1694569694;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1694586005;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694586012;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694586018;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694586124;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694586127;a:1:{s:28:\"wp_statistics_add_visit_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694589118;a:1:{s:32:\"4d9aa5866ba25ae2c949e6dd87131ca2\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694589407;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694616894;a:2:{s:31:\"iranAmlak_daily_validator_valid\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"iranAmlak_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1694931605;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1695050648;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "nonce_key", "{^i(eOA<$lwN$|X+eo_utS.>v*U5XZ;$UB:E^fekT^Sot6&H$k!^m={c|xDcr~9_", "no");
INSERT INTO `wp_options` VALUES("112", "nonce_salt", "mS`*tv{^6ecuJOJe~5:&)&2.$7#iF{GYp*R.v(m7k^kC*>Q3xSRu1.4E4M)XvV(?", "no");
INSERT INTO `wp_options` VALUES("113", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "recovery_keys", "a:2:{s:22:\"CuvGZSnPkSLKG0ehK5LkP1\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BRWdGXWe0Su.nR8xoYJNKISzqMx.a3/\";s:10:\"created_at\";i:1694442386;}s:22:\"hgkeltqm3OxKHiFVKIfITG\";a:2:{s:10:\"hashed_key\";s:34:\"$P$B1MjyM54reX..1VhQKpF0mlrBaJcJF.\";s:10:\"created_at\";i:1694529249;}}", "yes");
INSERT INTO `wp_options` VALUES("60216", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("121", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1590820274;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("26921", "woocommerce_tracker_last_send", "1613546487", "yes");
INSERT INTO `wp_options` VALUES("103719", "state_category_children", "a:3:{i:1422;a:5:{i:0;i:1386;i:1;i:1387;i:2;i:1389;i:3;i:1390;i:4;i:1391;}i:1423;a:4:{i:0;i:1388;i:1;i:1393;i:2;i:1394;i:3;i:1395;}i:1412;a:3:{i:0;i:1418;i:1;i:1419;i:2;i:1420;}}", "yes");
INSERT INTO `wp_options` VALUES("45138", "wppb_toolbox_forms_settings", "a:4:{s:9:\"ec-bypass\";a:0:{}s:29:\"restricted-email-domains-data\";a:0:{}s:32:\"restricted-email-domains-message\";s:81:\"The email address you are trying to register with is not allowed on this website.\";s:18:\"placeholder-labels\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("45139", "wppb_toolbox_fields_settings", "a:3:{s:23:\"restricted-words-fields\";a:0:{}s:21:\"restricted-words-data\";a:0:{}s:24:\"restricted-words-message\";s:38:\"Your submission contains banned words.\";}", "yes");
INSERT INTO `wp_options` VALUES("45140", "wppb_toolbox_userlisting_settings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("45141", "wppb_toolbox_shortcodes_settings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("45142", "wppb_toolbox_admin_settings", "a:2:{s:21:\"multiple-admin-emails\";s:0:\"\";s:12:\"admin-emails\";s:18:\"info@sitralweb.com\";}", "yes");
INSERT INTO `wp_options` VALUES("45143", "wppb_module_settings", "a:6:{s:16:\"wppb_userListing\";s:4:\"hide\";s:19:\"wppb_customRedirect\";s:4:\"hide\";s:20:\"wppb_emailCustomizer\";s:4:\"hide\";s:29:\"wppb_multipleEditProfileForms\";s:4:\"hide\";s:30:\"wppb_multipleRegistrationForms\";s:4:\"hide\";s:19:\"wppb_repeaterFields\";s:4:\"hide\";}", "yes");
INSERT INTO `wp_options` VALUES("65005", "sgpbModifiedRegisteredPluginsPaths2", "1", "yes");
INSERT INTO `wp_options` VALUES("65004", "sgpb-all-notifications-data", "[{\"priority\":1,\"type\":1,\"id\":\"sgpbMainRateUsNotification\",\"message\":\"\\t\\t<style>\\n\\t\\t\\t.sgpb-buttons-wrapper .press{\\n\\t\\t\\t\\tbox-sizing:border-box;\\n\\t\\t\\t\\tcursor:pointer;\\n\\t\\t\\t\\tdisplay:inline-block;\\n\\t\\t\\t\\tfont-size:1em;\\n\\t\\t\\t\\tmargin:0;\\n\\t\\t\\t\\tpadding:0.5em 0.75em;\\n\\t\\t\\t\\ttext-decoration:none;\\n\\t\\t\\t\\ttransition:background 0.15s linear\\n\\t\\t\\t}\\n\\t\\t\\t.sgpb-buttons-wrapper .press-grey {\\n\\t\\t\\t\\tbackground-color:#9E9E9E;\\n\\t\\t\\t\\tborder:2px solid #9E9E9E;\\n\\t\\t\\t\\tcolor: #FFF;\\n\\t\\t\\t}\\n\\t\\t\\t.sgpb-buttons-wrapper .press-lightblue {\\n\\t\\t\\t\\tbackground-color:#03A9F4;\\n\\t\\t\\t\\tborder:2px solid #03A9F4;\\n\\t\\t\\t\\tcolor: #FFF;\\n\\t\\t\\t}\\n\\t\\t\\t.sgpb-buttons-wrapper {\\n\\t\\t\\t\\ttext-align: center;\\n\\t\\t\\t}\\n\\t\\t\\t.sgpb-review-wrapper{\\n\\t\\t\\t\\ttext-align: center;\\n\\t\\t\\t\\tpadding: 20px;\\n\\t\\t\\t}\\n\\t\\t\\t.sgpb-review-wrapper p {\\n\\t\\t\\t\\tcolor: black;\\n\\t\\t\\t}\\n\\t\\t\\t.sgpb-review-h1 {\\n\\t\\t\\t\\tfont-size: 22px;\\n\\t\\t\\t\\tfont-weight: normal;\\n\\t\\t\\t\\tline-height: 1.384;\\n\\t\\t\\t}\\n\\t\\t\\t.sgrb-review-h2{\\n\\t\\t\\t\\tfont-size: 20px;\\n\\t\\t\\t\\tfont-weight: normal;\\n\\t\\t\\t}\\n\\t\\t\\t:root {\\n\\t\\t\\t\\t--main-bg-color: #1ac6ff;\\n\\t\\t\\t}\\n\\t\\t\\t.sgrb-review-strong{\\n\\t\\t\\t\\tcolor: var(--main-bg-color);\\n\\t\\t\\t}\\n\\t\\t\\t.sgrb-review-mt20{\\n\\t\\t\\t\\tmargin-top: 20px\\n\\t\\t\\t}\\n\\t\\t<\\/style>\\n\\t\\t<div class=\\\"sgpb-review-wrapper\\\">\\n\\t\\t\\t<div class=\\\"sgpb-review-description\\\">\\n\\t\\t\\t\\t<h1 class=\\\"sgpb-review-h1\\\"><strong class=\\\"sgrb-review-strong\\\">Awesome news!<\\/strong> <b>Popup Builder<\\/b> plugin helped you to share your message via <strong class=\\\"sgrb-review-strong\\\">\\u0627\\u062e\\u0637\\u0627\\u0631 !!!!!!!!!<\\/strong> popup with your visitors for <strong class=\\\"sgrb-review-strong\\\">700 times!<\\/strong><\\/h1>\\t\\t\\t\\t<h2 class=\\\"sgrb-review-h2\\\">This is really great for your website score.<\\/h2>\\n\\t\\t\\t\\t<p class=\\\"sgrb-review-mt20\\\">Have your input in the development of our plugin, and we\\u2019ll provide better conversions for your site!<br \\/> Leave your 5-star positive review and help us go further to the perfection!<\\/p>\\n\\t\\t\\t<\\/div>\\n\\t\\t\\t<div class=\\\"sgpb-buttons-wrapper\\\">\\n\\t\\t\\t\\t<button class=\\\"press press-grey sgpb-button-1 sgpb-close-promo-notification\\\" data-action=\\\"sg-already-did-review\\\">I already did<\\/button>\\n\\t\\t\\t\\t<button class=\\\"press press-lightblue sgpb-button-3 sgpb-close-promo-notification\\\" data-action=\\\"sg-you-worth-it\\\">You worth it!<\\/button>\\n\\t\\t\\t\\t<button class=\\\"press press-grey sgpb-button-2 sgpb-close-promo-notification\\\" data-action=\\\"sg-show-popup-period\\\" data-message-type=\\\"count\\\">Maybe later<\\/button><\\/div>\\n\\t\\t\\t<div>\\u00a0<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\"},{\"id\":\"sgpbMainSupportBanner\",\"priority\":1,\"type\":1,\"message\":\"<div class=\\\"sgpb-support-notification-wrapper sgpb-wrapper\\\"><h4 class=\\\"sgpb-support-notification-title\\\">Need some help?<\\/h4><h4 class=\\\"sgpb-support-notification-title\\\">Let us know what you think.<\\/h4><a class=\\\"btn btn-info\\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/popup-builder\\/reviews\\/\\\"><span class=\\\"dashicons sgpb-dashicons-heart sgpb-info-text-white\\\"><\\/span><span class=\\\"sg-info-text\\\">Rate Us<\\/span><\\/a><a class=\\\"btn btn-info\\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/help.popup-builder.com\\\"><span class=\\\"dashicons sgpb-dashicons-megaphone sgpb-info-text-white\\\"><\\/span>Support Potal<\\/a><a class=\\\"btn btn-info\\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/popup-builder\\\"><span class=\\\"dashicons sgpb-dashicons-admin-plugins sgpb-info-text-white\\\"><\\/span>Support Forum<\\/a><a class=\\\"btn btn-info\\\" target=\\\"_blank\\\" href=\\\"https:\\/\\/popup-builder.com\\/\\\"><span class=\\\"dashicons sgpb-dashicons-editor-help sgpb-info-text-white\\\"><\\/span>LIVE chat<\\/a><a class=\\\"btn btn-info\\\" target=\\\"_blank\\\" href=\\\"mailto:support@popup-builder.com?subject=Hello\\\"><span class=\\\"dashicons sgpb-dashicons-email-alt sgpb-info-text-white\\\"><\\/span>Email<\\/a><\\/div><div class=\\\"sgpb-support-notification-dont-show\\\">Bored of this?<a class=\\\"sgpb-dont-show-again-support-notification\\\" href=\\\"javascript:void(0)\\\"> Press here <\\/a>and we will not show it again!<\\/div>\"}]", "yes");
INSERT INTO `wp_options` VALUES("65045", "SgpbCounter", "a:1:{i:5085;i:705;}", "yes");
INSERT INTO `wp_options` VALUES("26821", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("145", "recently_activated", "a:1:{s:11:\"pwa/pwa.php\";i:1694446102;}", "yes");
INSERT INTO `wp_options` VALUES("26830", "action_scheduler_lock_async-request-runner", "1646829600", "yes");
INSERT INTO `wp_options` VALUES("150", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:18:\"info@sitralweb.com\";s:7:\"version\";s:5:\"6.2.2\";s:9:\"timestamp\";i:1684601714;}", "no");
INSERT INTO `wp_options` VALUES("152", "acf-openstreetmap-field_version", "1.3.2", "no");
INSERT INTO `wp_options` VALUES("151", "acf_osm_provider_tokens", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("90918", "wp-smush-settings", "a:24:{s:4:\"auto\";b:1;s:5:\"lossy\";b:0;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:0;s:6:\"backup\";b:0;s:8:\"no_scale\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:5:\"gform\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:1;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("90919", "wp-smush-install-type", "existing", "no");
INSERT INTO `wp_options` VALUES("90920", "wp-smush-version", "3.9.11", "no");
INSERT INTO `wp_options` VALUES("90923", "wpmudev_recommended_plugins_registered", "a:1:{s:23:\"wp-smushit/wp-smush.php\";a:1:{s:13:\"registered_at\";i:1655062982;}}", "no");
INSERT INTO `wp_options` VALUES("90924", "smush_global_stats", "a:9:{s:11:\"size_before\";i:2759541;s:10:\"size_after\";i:2523232;s:7:\"percent\";d:8.5999999999999996;s:5:\"human\";s:22:\"230,8 کیلوبایت\";s:5:\"bytes\";i:236309;s:12:\"total_images\";i:127;s:12:\"resize_count\";i:0;s:14:\"resize_savings\";i:0;s:18:\"conversion_savings\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("162", "wp_statistics", "a:28:{s:18:\"pending_db_updates\";a:2:{s:13:\"date_ip_agent\";b:0;s:11:\"unique_date\";b:0;}s:16:\"search_converted\";i:1;s:9:\"robotlist\";s:1715:\"007ac9\n5bot\nA6-Indexer\nAbachoBOT\naccoona\nAcoiRobot\nAddThis.com\nADmantX\nAdsBot-Google\nadvbot\nAhrefsBot\naiHitBot\nalexa\nalphabot\nAltaVista\nAntivirusPro\nanyevent\nappie\nApplebot\narchive.org_bot\nAsk Jeeves\nASPSeek\nBaiduspider\nBenjojo\nBeetleBot\nbingbot\nBlekkobot\nblexbot\nBOT for JCE\nbubing\nButterfly\ncbot\nclamantivirus\ncliqzbot\nclumboot\ncoccoc\ncrawler\nCrocCrawler\ncrowsnest.tv\ndbot\ndl2bot\ndotbot\ndownloadbot\nduckduckgo\nDumbot\nEasouSpider\neStyle\nEveryoneSocialBot\nExabot\nezooms\nfacebook.com\nfacebookexternalhit\nFAST\nFeedfetcher-Google\nfeedzirra\nfindxbot\nFirfly\nFriendFeedBot\nfroogle\nGeonaBot\nGigabot\ngirafabot\ngimme60bot\nglbot\nGooglebot\nGroupHigh\nia_archiver\nIDBot\nInfoSeek\ninktomi\nIstellaBot\njetmon\nKraken\nLeikibot\nlinkapediabot\nlinkdexbot\nLinkpadBot\nLoadTimeBot\nlooksmart\nltx71\nLycos\nMail.RU_Bot\nMe.dium\nmeanpathbot\nmediabot\nmedialbot\nMediapartners-Google\nMJ12bot\nmsnbot\nMojeekBot\nmonobot\nmoreover\nMRBOT\nNationalDirectory\nNerdyBot\nNetcraftSurveyAgent\nniki-bot\nnutch\nOpenbot\nOrangeBot\nowler\np4Bot\nPaperLiBot\npageanalyzer\nPagesInventory\nPimonster\nporkbun\npr-cy\nproximic\npwbot\nr4bot\nrabaz\nRambler\nRankivabot\nrevip\nriddler\nrogerbot\nScooter\nScrubby\nscrapy.org\nSearchmetricsBot\nsees.co\nSemanticBot\nSemrushBot\nSeznamBot\nsfFeedReader\nshareaholic-bot\nsistrix\nSiteExplorer\nSlurp\nSocialradarbot\nSocialSearch\nSogou web spider\nSpade\nspbot\nSpiderLing\nSputnikBot\nSuperfeedr\nSurveyBot\nTechnoratiSnoop\nTECNOSEEK\nTeoma\ntrendictionbot\nTweetmemeBot\nTwiceler\nTwitterbot\nTwitturls\nu2bot\nuMBot-LN\nuni5download\nunrulymedia\nUptimeRobot\nURL_Spider_SQL\nVagabondo\nvBSEO\nWASALive-Bot\nWebAlta Crawler\nWebBug\nWebFindBot\nWebMasterAid\nWeSEE\nWotbox\nwsowner\nwsr-agent\nwww.galaxy.com\nx100bot\nXoviBot\nxzybot\nyandex\nYahoo\nYammybot\nYoudaoBot\nZyBorg\nZemlyaCrawl\";s:13:\"anonymize_ips\";b:0;s:5:\"geoip\";b:0;s:10:\"useronline\";b:1;s:6:\"visits\";b:1;s:8:\"visitors\";b:1;s:5:\"pages\";b:1;s:12:\"check_online\";s:3:\"120\";s:8:\"menu_bar\";b:0;s:11:\"coefficient\";s:1:\"1\";s:12:\"stats_report\";b:0;s:11:\"time_report\";s:5:\"daily\";s:11:\"send_report\";s:4:\"mail\";s:14:\"content_report\";s:0:\"\";s:12:\"update_geoip\";b:1;s:8:\"store_ua\";b:0;s:21:\"exclude_administrator\";b:1;s:18:\"disable_se_clearch\";b:1;s:16:\"disable_se_qwant\";b:1;s:16:\"disable_se_baidu\";b:1;s:14:\"disable_se_ask\";b:1;s:8:\"map_type\";s:6:\"jqvmap\";s:9:\"ip_method\";s:11:\"REMOTE_ADDR\";s:18:\"force_robot_update\";b:1;s:17:\"show_welcome_page\";b:1;s:23:\"first_show_welcome_page\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("163", "wpp_settings", "a:18:{s:10:\"admin_lang\";s:6:\"enable\";s:9:\"user_lang\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:10:\"conv_title\";s:6:\"enable\";s:13:\"conv_contents\";s:6:\"enable\";s:12:\"conv_excerpt\";s:6:\"enable\";s:13:\"conv_comments\";s:6:\"enable\";s:18:\"conv_comment_count\";s:6:\"enable\";s:10:\"conv_dates\";s:6:\"enable\";s:9:\"conv_cats\";s:6:\"enable\";s:11:\"conv_arabic\";s:6:\"enable\";s:15:\"conv_permalinks\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:15:\"conv_page_title\";s:6:\"enable\";s:12:\"woo_fix_date\";s:6:\"enable\";s:13:\"woo_per_price\";s:6:\"enable\";s:9:\"dis_input\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("166", "ztjalali_options", "{\"force_timezone\":false,\"change_date_to_jalali\":true,\"change_jdate_number_to_persian\":true,\"change_url_date_to_jalali\":true,\"afghan_month_name\":false,\"disallow_month_short_name\":true,\"change_title_number_to_persian\":true,\"change_content_number_to_persian\":true,\"change_excerpt_number_to_persian\":true,\"change_comment_number_to_persian\":true,\"change_commentcount_number_to_persian\":true,\"change_category_number_to_persian\":false,\"change_point_to_persian\":true,\"change_arabic_to_persian\":true,\"change_archive_title\":true,\"save_changes_in_db\":false,\"ztjalali_admin_style\":false,\"persian_planet\":true}", "yes");
INSERT INTO `wp_options` VALUES("167", "ztjalali_version", "5.0.1", "yes");
INSERT INTO `wp_options` VALUES("170", "widget_a2a_share_save_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("171", "widget_a2a_follow_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("172", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("173", "widget_gform_widget", "a:3:{i:2;a:7:{s:5:\"title\";s:0:\"\";s:7:\"form_id\";s:1:\"1\";s:9:\"showtitle\";s:0:\"\";s:4:\"ajax\";s:0:\"\";s:15:\"disable_scripts\";s:0:\"\";s:15:\"showdescription\";s:0:\"\";s:8:\"tabindex\";s:1:\"1\";}i:3;a:7:{s:5:\"title\";s:0:\"\";s:7:\"form_id\";s:1:\"2\";s:9:\"showtitle\";s:0:\"\";s:4:\"ajax\";s:0:\"\";s:15:\"disable_scripts\";s:0:\"\";s:15:\"showdescription\";s:0:\"\";s:8:\"tabindex\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("174", "widget_ztjalali_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("175", "widget_ztjalali_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("176", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("177", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("178", "widget_wp_statistics_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("179", "widget_wppb-login-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("192", "gravityformsaddon_gravityformswebapi_version", "1.0", "yes");
INSERT INTO `wp_options` VALUES("181", "simplefavorites_dependencies", "a:2:{s:3:\"css\";s:4:\"true\";s:2:\"js\";s:4:\"true\";}", "yes");
INSERT INTO `wp_options` VALUES("182", "simplefavorites_users", "a:2:{s:9:\"anonymous\";a:2:{s:7:\"display\";s:4:\"true\";s:4:\"save\";s:4:\"true\";}s:6:\"saveas\";s:6:\"cookie\";}", "yes");
INSERT INTO `wp_options` VALUES("183", "simplefavorites_display", "a:10:{s:9:\"posttypes\";a:2:{s:4:\"post\";a:3:{s:7:\"display\";s:4:\"true\";s:13:\"after_content\";s:4:\"true\";s:8:\"postmeta\";s:4:\"true\";}s:5:\"state\";a:3:{s:7:\"display\";s:4:\"true\";s:8:\"postmeta\";s:4:\"true\";s:12:\"admincolumns\";s:4:\"true\";}}s:19:\"button_element_type\";s:6:\"button\";s:10:\"buttontype\";s:6:\"custom\";s:13:\"button_colors\";a:12:{s:6:\"custom\";s:4:\"true\";s:18:\"background_default\";s:7:\"#ffffff\";s:14:\"border_default\";s:7:\"#ffffff\";s:12:\"text_default\";s:7:\"#ffffff\";s:12:\"icon_default\";s:7:\"#ffcc00\";s:13:\"count_default\";s:0:\"\";s:17:\"background_active\";s:7:\"#ffffff\";s:13:\"border_active\";s:7:\"#ffffff\";s:11:\"text_active\";s:7:\"#ffcc00\";s:11:\"icon_active\";s:7:\"#ffcc00\";s:12:\"count_active\";s:0:\"\";s:10:\"box_shadow\";s:4:\"true\";}s:10:\"buttontext\";s:40:\"<i class=\"sf-icon-star-empty fa-2x\"></i>\";s:19:\"buttontextfavorited\";s:39:\"<i class=\"sf-icon-star-full fa-2x\"></i>\";s:16:\"loadingindicator\";a:1:{s:4:\"text\";s:7:\"Loading\";}s:7:\"listing\";a:5:{s:12:\"wrapper_type\";s:2:\"ul\";s:11:\"wrapper_css\";s:0:\"\";s:12:\"listing_type\";s:2:\"li\";s:11:\"listing_css\";s:0:\"\";s:18:\"custom_markup_html\";s:0:\"\";}s:14:\"clearfavorites\";s:39:\"پاکسازی علاقه مندی ها\";s:11:\"nofavorites\";s:28:\"بدون علاقه مندی\";}", "yes");
INSERT INTO `wp_options` VALUES("184", "simplefavorites_cache_enabled", "true", "yes");
INSERT INTO `wp_options` VALUES("185", "wppb_version", "3.4.1", "yes");
INSERT INTO `wp_options` VALUES("186", "wppb_manage_fields", "a:13:{i:0;a:21:{s:5:\"field\";s:24:\"Default - Name (Heading)\";s:11:\"field-title\";s:6:\"اسم\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"1\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:2:\"No\";}i:1;a:21:{s:5:\"field\";s:18:\"Default - Username\";s:11:\"field-title\";s:19:\"نام کاربری\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"2\";s:11:\"description\";s:58:\"نام کاربری قابل تغییر نمی‌باشد.\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:3:\"Yes\";}i:2;a:21:{s:5:\"field\";s:20:\"Default - First Name\";s:11:\"field-title\";s:6:\"نام\";s:9:\"meta-name\";s:10:\"first_name\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"3\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:2:\"No\";}i:3;a:21:{s:5:\"field\";s:19:\"Default - Last Name\";s:11:\"field-title\";s:9:\"Last Name\";s:9:\"meta-name\";s:9:\"last_name\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"4\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:2:\"No\";}i:4;a:21:{s:5:\"field\";s:18:\"Default - Nickname\";s:11:\"field-title\";s:6:\"لقب\";s:9:\"meta-name\";s:8:\"nickname\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"5\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:3:\"Yes\";}i:5;a:21:{s:5:\"field\";s:34:\"Default - Display name publicly as\";s:11:\"field-title\";s:28:\"نمایش عمومی نام\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:2:\"No\";}i:6;a:21:{s:5:\"field\";s:32:\"Default - Contact Info (Heading)\";s:11:\"field-title\";s:23:\"اطلاعات تماس\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"7\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:2:\"No\";}i:7;a:21:{s:5:\"field\";s:16:\"Default - E-mail\";s:11:\"field-title\";s:25:\"پست الکترونیک\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"8\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:3:\"Yes\";}i:8;a:21:{s:5:\"field\";s:17:\"Default - Website\";s:11:\"field-title\";s:12:\"وبسایت\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:1:\"9\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:2:\"No\";}i:9;a:21:{s:5:\"field\";s:34:\"Default - About Yourself (Heading)\";s:11:\"field-title\";s:19:\"درباره شما\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:2:\"13\";s:11:\"description\";s:0:\"\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:2:\"No\";}i:10;a:20:{s:5:\"field\";s:27:\"Default - Biographical Info\";s:11:\"field-title\";s:32:\"اطلاعات شرح زندگی\";s:9:\"meta-name\";s:11:\"description\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:2:\"14\";s:11:\"description\";s:211:\"اطلاعاتی از شرح زندگی خود برای پُر کردن حساب کاربری‌تان بنویسید. این اطلاعات ممکن است به صورت عمومی نمایش داده شوند.\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:8:\"required\";s:2:\"No\";}i:11;a:21:{s:5:\"field\";s:18:\"Default - Password\";s:11:\"field-title\";s:17:\"کلمه عبور\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:2:\"15\";s:11:\"description\";s:48:\"کلمه عبور خود را وارد کنید.\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:3:\"Yes\";}i:12;a:21:{s:5:\"field\";s:25:\"Default - Repeat Password\";s:11:\"field-title\";s:28:\"تکرار کلمه عبور\";s:9:\"meta-name\";s:0:\"\";s:18:\"overwrite-existing\";s:2:\"No\";s:2:\"id\";s:2:\"16\";s:11:\"description\";s:59:\"کلمه عبور خود را مجددا وارد کنید.\";s:9:\"row-count\";s:1:\"5\";s:24:\"allowed-image-extensions\";s:2:\".*\";s:25:\"allowed-upload-extensions\";s:2:\".*\";s:11:\"avatar-size\";s:3:\"100\";s:11:\"date-format\";s:8:\"mm/dd/yy\";s:18:\"terms-of-agreement\";s:0:\"\";s:7:\"options\";s:0:\"\";s:6:\"labels\";s:0:\"\";s:10:\"public-key\";s:0:\"\";s:11:\"private-key\";s:0:\"\";s:13:\"default-value\";s:0:\"\";s:14:\"default-option\";s:0:\"\";s:15:\"default-options\";s:0:\"\";s:15:\"default-content\";s:0:\"\";s:8:\"required\";s:3:\"Yes\";}}", "yes");
INSERT INTO `wp_options` VALUES("187", "wppb-ul-templates", "\n<table class=\"wppb-table\">\n	<thead>\n		<tr>\n		  <th scope=\"col\" colspan=\"2\" class=\"wppb-sorting\">{{{sort_user_name}}}</th>\n		  <th scope=\"col\" class=\"wppb-sorting\">{{{sort_first_name}}}</th>\n		  <th scope=\"col\" class=\"wppb-sorting\">{{{sort_role}}}</th>\n		  <th scope=\"col\" class=\"wppb-sorting\">{{{sort_number_of_posts}}}</th>\n		  <th scope=\"col\" class=\"wppb-sorting\">{{{sort_registration_date}}}</th>\n		  <th scope=\"col\">More</th>\n		</tr>\n	</thead>\n	<tbody>\n		{{#users}}\n		<tr>\n		  <td data-label=\"آواتار\" class=\"wppb-avatar\">{{{avatar_or_gravatar}}}</td>\n		  <td data-label=\"نام کاربری\" class=\"wppb-login\">{{meta_user_name}}</td>\n		  <td data-label=\"نام\" class=\"wppb-name\">{{meta_first_name}} {{meta_last_name}}</td>\n		  <td data-label=\"نقش کاربری\" class=\"wppb-role\">{{meta_role}}</td>\n		  <td data-label=\"نوشته‌ها\" class=\"wppb-posts\">{{{meta_number_of_posts}}}</td>\n		  <td data-label=\"تاریخ عضویت\" class=\"wppb-signup\">{{meta_registration_date}}</td>\n		  <td data-label=\"بیشتر\" class=\"wppb-moreinfo\">{{{more_info}}}</td>\n		</tr>\n		{{/users}}\n	</tbody>\n</table>\n{{{pagination}}}", "yes");
INSERT INTO `wp_options` VALUES("188", "wppb-single-ul-templates", "\n{{{extra_go_back_link}}}\n<ul class=\"wppb-profile\">\n  <li>\n    <h3>Name</h3>\n  </li>\n  <li class=\"wppb-avatar\">\n    {{{avatar_or_gravatar}}}\n  </li>\n  <li>\n    <label>Username:</label>\n    <span>{{meta_user_name}}</span>\n  </li>\n  <li>\n    <label>First Name:</label>\n    <span>{{meta_first_name}}</span>\n  </li>\n  <li>\n    <label>Last Name:</label>\n    <span>{{meta_last_name}}</span>\n  </li>\n  <li>\n    <label>Nickname:</label>\n    <span>{{meta_nickname}}</span>\n  </li>\n  <li>\n    <label>Display name:</label>\n	<span>{{meta_display_name}}</span>\n  </li>\n  <li>\n    <h3>Contact Info</h3>\n  </li>\n  <li>\n  	<label>Website:</label>\n	<span>{{meta_website}}</span>\n  </li>\n  <li>\n    <h3>About Yourself</h3>\n  </li>\n  <li>\n	<label>Biographical Info:</label>\n	<span>{{{meta_biographical_info}}}</span>\n  </li>\n</ul>\n{{{extra_go_back_link}}}", "yes");
INSERT INTO `wp_options` VALUES("189", "wppb_general_settings", "a:7:{s:17:\"extraFieldsLayout\";s:7:\"default\";s:17:\"emailConfirmation\";s:2:\"no\";s:21:\"activationLandingPage\";s:0:\"\";s:13:\"adminApproval\";s:2:\"no\";s:9:\"loginWith\";s:13:\"usernameemail\";s:11:\"rolesEditor\";s:2:\"no\";s:23:\"conditional_fields_ajax\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("190", "wp_statistics_check_useronline", "1607125975", "yes");
INSERT INTO `wp_options` VALUES("191", "external_updates-profile-builder-pro-update", "O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1617517326;s:14:\"checkedVersion\";s:5:\"3.3.3\";s:6:\"update\";O:12:\"PluginUpdate\":6:{s:2:\"id\";i:0;s:4:\"slug\";s:26:\"profile-builder-pro-update\";s:7:\"version\";s:5:\"3.4.1\";s:8:\"homepage\";N;s:12:\"download_url\";N;s:14:\"upgrade_notice\";N;}}", "yes");
INSERT INTO `wp_options` VALUES("193", "gform_version_info", "a:6:{s:12:\"is_valid_key\";s:1:\"0\";s:15:\"expiration_time\";i:0;s:7:\"version\";s:5:\"1.7.9\";s:3:\"url\";s:0:\"\";s:9:\"offerings\";a:0:{}s:9:\"timestamp\";i:1615969279;}", "no");
INSERT INTO `wp_options` VALUES("194", "acf_version", "6.0.7", "yes");
INSERT INTO `wp_options` VALUES("202", "current_theme", "Iranamlak", "yes");
INSERT INTO `wp_options` VALUES("203", "theme_mods_iranamlak", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"main-menu\";i:2;}s:19:\"ot_set_google_fonts\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1670668909;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:12:\"formmoshaver\";a:0:{}s:11:\"formcontact\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("204", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("207", "ot_media_post_ID", "7", "yes");
INSERT INTO `wp_options` VALUES("45136", "wppb_old_add_ons_status", "a:10:{s:42:\"pd-add-on-multiple-admin-e-mails/index.php\";b:0;s:41:\"pb-add-on-customization-toolbox/index.php\";b:0;s:44:\"pb-add-on-email-confirmation-field/index.php\";b:0;s:37:\"pb-add-on-placeholder-labels/pbpl.php\";b:0;s:78:\"pb-add-on-gdpr-communication-preferences/pb-gdpr-communication-preferences.php\";b:0;s:30:\"pb-add-on-labels-edit/pble.php\";b:0;s:44:\"pb-add-on-maximum-character-length/index.php\";b:0;s:48:\"pb-add-on-custom-css-classes-on-fields/index.php\";b:0;s:32:\"pb-add-on-import-export/pbie.php\";b:0;s:27:\"pb-add-on-select2/index.php\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("45137", "wppb_free_add_ons_settings", "a:5:{s:30:\"gdpr-communication-preferences\";b:0;s:11:\"labels-edit\";b:0;s:24:\"maximum-character-length\";b:0;s:28:\"custom-css-classes-on-fields\";b:0;s:13:\"import-export\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("6288", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("26855", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":3:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;s:17:\"new_product_count\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("251", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("339", "new_admin_email", "info@sitralweb.com", "yes");
INSERT INTO `wp_options` VALUES("10194", "secure_auth_key", "^a5f&`p~W;d&6Y8N_{lc#G~/V/@W[5O9-$g^N1`>|IAn<Hh5j[QxP(.5fB-}Zn2]", "no");
INSERT INTO `wp_options` VALUES("10195", "secure_auth_salt", "1D|T4ITj>>^,uL$e~7^a3,^A7#S6_-Aj+pGFH]1,uc(|nhK[Z~HXI$#>$|+Mw*.7", "no");
INSERT INTO `wp_options` VALUES("20087", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("20088", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("20089", "auto_update_core_major", "unset", "yes");
INSERT INTO `wp_options` VALUES("20767", "wppb_display_admin_settings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("14196", "wpaieOptions", "a:23:{s:13:\"checkFileName\";b:1;s:23:\"checkFileNameCharacters\";b:1;s:11:\"rootElement\";s:4:\"root\";s:10:\"rowTagName\";s:0:\"\";s:14:\"duplicateEntry\";s:4:\"skip\";s:10:\"postFields\";a:11:{i:0;s:10:\"post_title\";i:1;s:12:\"post_content\";i:2;s:12:\"post_excerpt\";i:3;s:9:\"post_date\";i:4;s:9:\"post_name\";i:5;s:11:\"post_author\";i:6;s:11:\"post_parent\";i:7;s:11:\"post_status\";i:8;s:8:\"post_tag\";i:9;s:13:\"post_category\";i:10;s:14:\"featured_image\";}s:14:\"postMetaFields\";a:149:{s:20:\"PM: __validate_email\";s:16:\"__validate_email\";s:12:\"PM: _address\";s:8:\"_address\";s:12:\"PM: _asansor\";s:8:\"_asansor\";s:12:\"PM: _darbast\";s:8:\"_darbast\";s:13:\"PM: _darkhast\";s:9:\"_darkhast\";s:20:\"PM: _data-pishforosh\";s:16:\"_data-pishforosh\";s:16:\"PM: _description\";s:12:\"_description\";s:14:\"PM: _edit_last\";s:10:\"_edit_last\";s:14:\"PM: _edit_lock\";s:10:\"_edit_lock\";s:10:\"PM: _email\";s:6:\"_email\";s:9:\"PM: _fast\";s:5:\"_fast\";s:12:\"PM: _gallery\";s:8:\"_gallery\";s:11:\"PM: _google\";s:7:\"_google\";s:12:\"PM: _hektari\";s:8:\"_hektari\";s:12:\"PM: _kabinet\";s:8:\"_kabinet\";s:12:\"PM: _kafposh\";s:8:\"_kafposh\";s:12:\"PM: _karbari\";s:8:\"_karbari\";s:12:\"PM: _kohpaye\";s:8:\"_kohpaye\";s:8:\"PM: _lat\";s:4:\"_lat\";s:8:\"PM: _lng\";s:4:\"_lng\";s:11:\"PM: _luxury\";s:7:\"_luxury\";s:18:\"PM: _masahat-zamin\";s:14:\"_masahat-zamin\";s:9:\"PM: _melk\";s:5:\"_melk\";s:22:\"PM: _menu_item_classes\";s:18:\"_menu_item_classes\";s:31:\"PM: _menu_item_menu_item_parent\";s:27:\"_menu_item_menu_item_parent\";s:21:\"PM: _menu_item_object\";s:17:\"_menu_item_object\";s:24:\"PM: _menu_item_object_id\";s:20:\"_menu_item_object_id\";s:21:\"PM: _menu_item_target\";s:17:\"_menu_item_target\";s:19:\"PM: _menu_item_type\";s:15:\"_menu_item_type\";s:18:\"PM: _menu_item_url\";s:14:\"_menu_item_url\";s:18:\"PM: _menu_item_xfn\";s:14:\"_menu_item_xfn\";s:12:\"PM: _metrazh\";s:8:\"_metrazh\";s:7:\"PM: _mg\";s:3:\"_mg\";s:12:\"PM: _moamele\";s:8:\"_moamele\";s:12:\"PM: _moaveze\";s:8:\"_moaveze\";s:16:\"PM: _moaveze-for\";s:12:\"_moaveze-for\";s:11:\"PM: _mobile\";s:7:\"_mobile\";s:13:\"PM: _moshaver\";s:9:\"_moshaver\";s:12:\"PM: _nafarat\";s:8:\"_nafarat\";s:9:\"PM: _nama\";s:5:\"_nama\";s:9:\"PM: _name\";s:5:\"_name\";s:14:\"PM: _num-hamam\";s:10:\"_num-hamam\";s:11:\"PM: _num-wc\";s:7:\"_num-wc\";s:12:\"PM: _okasion\";s:8:\"_okasion\";s:10:\"PM: _ostan\";s:6:\"_ostan\";s:14:\"PM: _ostan_cat\";s:10:\"_ostan_cat\";s:10:\"PM: _otagh\";s:6:\"_otagh\";s:12:\"PM: _parking\";s:8:\"_parking\";s:15:\"PM: _pishforosh\";s:11:\"_pishforosh\";s:16:\"PM: _price-ejare\";s:12:\"_price-ejare\";s:15:\"PM: _price-form\";s:11:\"_price-form\";s:14:\"PM: _price-kol\";s:10:\"_price-kol\";s:16:\"PM: _price-metri\";s:12:\"_price-metri\";s:15:\"PM: _price-rahn\";s:11:\"_price-rahn\";s:16:\"PM: _price-shabi\";s:12:\"_price-shabi\";s:18:\"PM: _price-tatilat\";s:14:\"_price-tatilat\";s:11:\"PM: _saheli\";s:7:\"_saheli\";s:10:\"PM: _sanad\";s:6:\"_sanad\";s:18:\"PM: _sayer-emkanat\";s:14:\"_sayer-emkanat\";s:12:\"PM: _senbana\";s:8:\"_senbana\";s:10:\"PM: _shahr\";s:6:\"_shahr\";s:13:\"PM: _shahraki\";s:9:\"_shahraki\";s:12:\"PM: _sokonat\";s:8:\"_sokonat\";s:12:\"PM: _special\";s:8:\"_special\";s:14:\"PM: _streetmap\";s:10:\"_streetmap\";s:12:\"PM: _tabaghe\";s:8:\"_tabaghe\";s:11:\"PM: _tabdil\";s:7:\"_tabdil\";s:10:\"PM: _tahol\";s:6:\"_tahol\";s:11:\"PM: _tahvil\";s:7:\"_tahvil\";s:19:\"PM: _tedad-tabaghat\";s:15:\"_tedad-tabaghat\";s:28:\"PM: _tedad-vahed-har-tabaghe\";s:24:\"_tedad-vahed-har-tabaghe\";s:20:\"PM: _tedad-vahed-kol\";s:16:\"_tedad-vahed-kol\";s:17:\"PM: _thumbnail_id\";s:13:\"_thumbnail_id\";s:19:\"PM: _validate_email\";s:15:\"_validate_email\";s:11:\"PM: _vaziat\";s:7:\"_vaziat\";s:7:\"PM: _wc\";s:3:\"_wc\";s:21:\"PM: _wp_attached_file\";s:17:\"_wp_attached_file\";s:27:\"PM: _wp_attachment_metadata\";s:23:\"_wp_attachment_metadata\";s:16:\"PM: _wp_old_date\";s:12:\"_wp_old_date\";s:16:\"PM: _wp_old_slug\";s:12:\"_wp_old_slug\";s:21:\"PM: _wp_page_template\";s:17:\"_wp_page_template\";s:11:\"PM: address\";s:7:\"address\";s:11:\"PM: asansor\";s:7:\"asansor\";s:11:\"PM: darbast\";s:7:\"darbast\";s:12:\"PM: darkhast\";s:8:\"darkhast\";s:19:\"PM: data-pishforosh\";s:15:\"data-pishforosh\";s:15:\"PM: description\";s:11:\"description\";s:9:\"PM: email\";s:5:\"email\";s:8:\"PM: fast\";s:4:\"fast\";s:11:\"PM: gallery\";s:7:\"gallery\";s:10:\"PM: google\";s:6:\"google\";s:11:\"PM: hektari\";s:7:\"hektari\";s:11:\"PM: kabinet\";s:7:\"kabinet\";s:11:\"PM: kafposh\";s:7:\"kafposh\";s:11:\"PM: karbari\";s:7:\"karbari\";s:11:\"PM: kohpaye\";s:7:\"kohpaye\";s:7:\"PM: lat\";s:3:\"lat\";s:7:\"PM: lng\";s:3:\"lng\";s:10:\"PM: luxury\";s:6:\"luxury\";s:17:\"PM: masahat-zamin\";s:13:\"masahat-zamin\";s:8:\"PM: melk\";s:4:\"melk\";s:11:\"PM: metrazh\";s:7:\"metrazh\";s:6:\"PM: mg\";s:2:\"mg\";s:11:\"PM: moamele\";s:7:\"moamele\";s:11:\"PM: moaveze\";s:7:\"moaveze\";s:15:\"PM: moaveze-for\";s:11:\"moaveze-for\";s:10:\"PM: mobile\";s:6:\"mobile\";s:12:\"PM: moshaver\";s:8:\"moshaver\";s:11:\"PM: nafarat\";s:7:\"nafarat\";s:8:\"PM: nama\";s:4:\"nama\";s:8:\"PM: name\";s:4:\"name\";s:13:\"PM: num-hamam\";s:9:\"num-hamam\";s:10:\"PM: num-wc\";s:6:\"num-wc\";s:11:\"PM: okasion\";s:7:\"okasion\";s:9:\"PM: ostan\";s:5:\"ostan\";s:13:\"PM: ostan_cat\";s:9:\"ostan_cat\";s:9:\"PM: otagh\";s:5:\"otagh\";s:11:\"PM: parking\";s:7:\"parking\";s:14:\"PM: pishforosh\";s:10:\"pishforosh\";s:15:\"PM: price-ejare\";s:11:\"price-ejare\";s:14:\"PM: price-form\";s:10:\"price-form\";s:13:\"PM: price-kol\";s:9:\"price-kol\";s:15:\"PM: price-metri\";s:11:\"price-metri\";s:14:\"PM: price-rahn\";s:10:\"price-rahn\";s:15:\"PM: price-shabi\";s:11:\"price-shabi\";s:17:\"PM: price-tatilat\";s:13:\"price-tatilat\";s:10:\"PM: saheli\";s:6:\"saheli\";s:9:\"PM: sanad\";s:5:\"sanad\";s:17:\"PM: sayer-emkanat\";s:13:\"sayer-emkanat\";s:11:\"PM: senbana\";s:7:\"senbana\";s:9:\"PM: shahr\";s:5:\"shahr\";s:12:\"PM: shahraki\";s:8:\"shahraki\";s:20:\"PM: sharing_disabled\";s:16:\"sharing_disabled\";s:25:\"PM: simplefavorites_count\";s:21:\"simplefavorites_count\";s:11:\"PM: sokonat\";s:7:\"sokonat\";s:11:\"PM: special\";s:7:\"special\";s:13:\"PM: streetmap\";s:9:\"streetmap\";s:11:\"PM: tabaghe\";s:7:\"tabaghe\";s:10:\"PM: tabdil\";s:6:\"tabdil\";s:9:\"PM: tahol\";s:5:\"tahol\";s:10:\"PM: tahvil\";s:6:\"tahvil\";s:18:\"PM: tedad-tabaghat\";s:14:\"tedad-tabaghat\";s:27:\"PM: tedad-vahed-har-tabaghe\";s:23:\"tedad-vahed-har-tabaghe\";s:19:\"PM: tedad-vahed-kol\";s:15:\"tedad-vahed-kol\";s:10:\"PM: vaziat\";s:6:\"vaziat\";s:6:\"PM: wc\";s:2:\"wc\";s:25:\"PM: wppb_ul_page_settings\";s:21:\"wppb_ul_page_settings\";s:28:\"PM: wppb-single-ul-templates\";s:24:\"wppb-single-ul-templates\";s:21:\"PM: wppb-ul-templates\";s:17:\"wppb-ul-templates\";}s:22:\"customTaxonomiesFields\";a:2:{s:15:\"CT: post_format\";s:11:\"post_format\";s:18:\"CT: state_category\";s:14:\"state_category\";}s:10:\"postStatus\";s:5:\"draft\";s:8:\"postDate\";s:11:\"currentdate\";s:7:\"dateval\";s:18:\"2020/11/21 3:02:45\";s:13:\"authorDetails\";s:8:\"authorId\";s:9:\"sqlExport\";s:3:\"yes\";s:13:\"termSeparator\";s:1:\"|\";s:17:\"categorySeparator\";s:1:\"|\";s:12:\"csvDelimiter\";s:1:\",\";s:13:\"purchase_code\";s:0:\"\";s:20:\"fileMailConfrimation\";s:2:\"no\";s:14:\"postContentImg\";s:2:\"no\";s:15:\"categorySetting\";s:2:\"no\";s:10:\"inisetting\";s:3:\"512\";s:22:\"setFeatureImgByDefault\";s:2:\"no\";s:22:\"woocommerceProductMeta\";a:44:{i:0;s:22:\"_product_image_gallery\";i:1;s:18:\"_product_variation\";i:2;s:19:\"_product_attributes\";i:3;s:11:\"_visibility\";i:4;s:13:\"_stock_status\";i:5;s:11:\"total_sales\";i:6;s:13:\"_downloadable\";i:7;s:8:\"_virtual\";i:8;s:14:\"_regular_price\";i:9;s:11:\"_sale_price\";i:10;s:14:\"_purchase_note\";i:11;s:9:\"_featured\";i:12;s:7:\"_weight\";i:13;s:7:\"_length\";i:14;s:6:\"_width\";i:15;s:7:\"_height\";i:16;s:4:\"_sku\";i:17;s:22:\"_sale_price_dates_from\";i:18;s:20:\"_sale_price_dates_to\";i:19;s:6:\"_price\";i:20;s:18:\"_sold_individually\";i:21;s:6:\"_stock\";i:22;s:11:\"_backorders\";i:23;s:13:\"_manage_stock\";i:24;s:16:\"post_views_count\";i:25;s:7:\"on_sale\";i:26;s:7:\"taxable\";i:27;s:11:\"_tax_status\";i:28;s:10:\"_tax_class\";i:29;s:15:\"_download_limit\";i:30;s:16:\"_download_expiry\";i:31;s:19:\"_downloadable_files\";i:32;s:14:\"_download_type\";i:33;s:12:\"_button_text\";i:34;s:17:\"shipping_required\";i:35;s:16:\"shipping_taxable\";i:36;s:22:\"product_shipping_class\";i:37;s:17:\"shipping_class_id\";i:38;s:18:\"_wc_average_rating\";i:39;s:16:\"_wc_rating_count\";i:40;s:16:\"_wc_review_count\";i:41;s:11:\"related_ids\";i:42;s:11:\"_upsell_ids\";i:43;s:14:\"_crosssell_ids\";}}", "yes");
INSERT INTO `wp_options` VALUES("3622", "dig_hid_addon_domain_notice", "1", "no");
INSERT INTO `wp_options` VALUES("3641", "duplicator_pro_package_active", "{\n    \"Created\": \"2020-07-11 15:09:37\",\n    \"Version\": \"3.8.9.1\",\n    \"VersionWP\": \"5.4.2\",\n    \"VersionDB\": \"5.7.29\",\n    \"VersionPHP\": \"7.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": null,\n    \"Name\": \"iranamlak_3_6\",\n    \"Hash\": \"9b4f569a97d517472215_20200711150937\",\n    \"NameHash\": \"iranamlak_3_6_9b4f569a97d517472215_20200711150937\",\n    \"Type\": 0,\n    \"Notes\": \"The default template.\",\n    \"StorePath\": \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/sitralweb.com\\/ir3\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"iranamlak_3_6_9b4f569a97d517472215_20200711150937_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"\\u067e\\u06cc\\u0634 \\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": null,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/.opcache\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/.tmb\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/bps-backup\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/cache\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/old-cache\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/updraft\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/wfcache\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/.htaccess\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/.user.ini\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/php.ini\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/web.config\",\n            \"\\/home\\/yousefamini\\/public_html\\/ir3\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/yousefamini\\/public_html\\/ir3\",\n        \"Size\": 156228620,\n        \"Dirs\": null,\n        \"DirCount\": 1218,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 9381,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": null,\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"localhost\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\",\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"yousefam_iransit\",\n            \"tablesBaseCount\": 30,\n            \"tablesFinalCount\": 30,\n            \"tablesRowCount\": 4734,\n            \"tablesSizeOnDisk\": 1820243,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"rows\": \"0\",\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"rows\": \"0\",\n                    \"size\": 7644\n                },\n                \"wp_duplicator_packages\": {\n                    \"rows\": \"0\",\n                    \"size\": 15780\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"rows\": \"5\",\n                    \"size\": 7828\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"rows\": \"0\",\n                    \"size\": 40360\n                },\n                \"wp_gf_draft_submissions\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_gf_entry\": {\n                    \"rows\": \"0\",\n                    \"size\": 6128\n                },\n                \"wp_gf_entry_meta\": {\n                    \"rows\": \"0\",\n                    \"size\": 15172\n                },\n                \"wp_gf_entry_notes\": {\n                    \"rows\": \"0\",\n                    \"size\": 4916\n                },\n                \"wp_gf_form\": {\n                    \"rows\": \"2\",\n                    \"size\": 2132\n                },\n                \"wp_gf_form_meta\": {\n                    \"rows\": \"2\",\n                    \"size\": 12652\n                },\n                \"wp_gf_form_revisions\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_gf_form_view\": {\n                    \"rows\": \"61\",\n                    \"size\": 8976\n                },\n                \"wp_links\": {\n                    \"rows\": \"0\",\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"rows\": \"228\",\n                    \"size\": 420264\n                },\n                \"wp_postmeta\": {\n                    \"rows\": \"2,526\",\n                    \"size\": 378060\n                },\n                \"wp_posts\": {\n                    \"rows\": \"137\",\n                    \"size\": 357048\n                },\n                \"wp_statistics_exclusions\": {\n                    \"rows\": \"0\",\n                    \"size\": 4096\n                },\n                \"wp_statistics_historical\": {\n                    \"rows\": \"0\",\n                    \"size\": 4096\n                },\n                \"wp_statistics_pages\": {\n                    \"rows\": \"642\",\n                    \"size\": 273368\n                },\n                \"wp_statistics_search\": {\n                    \"rows\": \"6\",\n                    \"size\": 11552\n                },\n                \"wp_statistics_useronline\": {\n                    \"rows\": \"1\",\n                    \"size\": 5948\n                },\n                \"wp_statistics_visit\": {\n                    \"rows\": \"44\",\n                    \"size\": 3820\n                },\n                \"wp_statistics_visitor\": {\n                    \"rows\": \"694\",\n                    \"size\": 151396\n                },\n                \"wp_term_relationships\": {\n                    \"rows\": \"35\",\n                    \"size\": 3807\n                },\n                \"wp_term_taxonomy\": {\n                    \"rows\": \"3\",\n                    \"size\": 4216\n                },\n                \"wp_termmeta\": {\n                    \"rows\": \"0\",\n                    \"size\": 4096\n                },\n                \"wp_terms\": {\n                    \"rows\": \"3\",\n                    \"size\": 13544\n                },\n                \"wp_usermeta\": {\n                    \"rows\": \"328\",\n                    \"size\": 45956\n                },\n                \"wp_users\": {\n                    \"rows\": \"17\",\n                    \"size\": 10220\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"version\": \"5.7.29\",\n            \"versionComment\": \"MySQL Community Server - (GPL)\",\n            \"tableWiseRowCounts\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": null,\n        \"File\": null,\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"DBMode\": null,\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - (GPL)\",\n        \"dbStorePathPublic\": null\n    },\n    \"Status\": 5,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": null,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": -1,\n        \"current_build_compression\": true,\n        \"custom_data\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tableIndex\": 0,\n        \"tableOffset\": 0,\n        \"totalRowOffset\": 0,\n        \"chunkIndex\": null,\n        \"validationStage1\": false,\n        \"bulkOffset\": 0,\n        \"bulkSizeOffset\": 0,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"tablesToProcess\": [],\n        \"startTime\": 0,\n        \"fileOffset\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"totalSchemaSize\": 0,\n        \"tablesSchemaSizes\": []\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}", "yes");
INSERT INTO `wp_options` VALUES("110412", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("110414", "duplicator_migration_data", "{\n    \"installType\": -1,\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/yousefamini\\/public_html\\/ir3\\/iranamlak_7_1_152b8fc35109ba6d4138_20230102171121_archive.daf\",\n    \"packageHash\": \"152b8fc-02171121\",\n    \"installerPath\": \"\\/home\\/yousefamini\\/public_html\\/ir3\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/yousefamini\\/public_html\\/ir3\\/dup-installer-bootlog__d0b4d29-02171121.txt\",\n    \"installerLog\": \"\\/home\\/yousefamini\\/public_html\\/ir3\\/dup-installer\\/dup-installer-log__d0b4d29-02171121.txt\",\n    \"dupInstallerPath\": \"\\/home\\/yousefamini\\/public_html\\/ir3\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/yousefamini\\/public_html\\/ir3\\/dup-installer\\/original_files_152b8fc-02171121\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true\n}", "no");
INSERT INTO `wp_options` VALUES("1832", "acf_osm_providers", "a:10:{s:13:\"OpenStreetMap\";a:1:{s:8:\"variants\";a:2:{s:2:\"CH\";s:1:\"0\";s:3:\"BZH\";s:1:\"0\";}}s:6:\"Stamen\";a:1:{s:8:\"variants\";a:2:{s:12:\"TopOSMRelief\";s:1:\"0\";s:14:\"TopOSMFeatures\";s:1:\"0\";}}s:9:\"FreeMapSK\";s:1:\"0\";s:9:\"BasemapAT\";s:1:\"0\";s:6:\"nlmaps\";s:1:\"0\";s:8:\"NASAGIBS\";s:1:\"0\";s:3:\"NLS\";s:1:\"0\";s:10:\"JusticeMap\";s:1:\"0\";s:16:\"GeoportailFrance\";s:1:\"0\";s:8:\"OneMapSG\";s:1:\"0\";}", "no");
INSERT INTO `wp_options` VALUES("681", "recovery_mode_email_last_sent", "1694529249", "yes");
INSERT INTO `wp_options` VALUES("26835", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("26780", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("26781", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("88681", "user_count", "4", "no");
INSERT INTO `wp_options` VALUES("3636", "duplicator_pro_reset_user_settings_required", "0", "yes");
INSERT INTO `wp_options` VALUES("3640", "duplicator_pro_ui_view_state", "a:3:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:25:\"dpro-pack-installer-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("3638", "duplicator_pro_plugin_version", "3.8.9.1", "yes");
INSERT INTO `wp_options` VALUES("3639", "duplicator_pro_license_key", "B5E0B5F8DD8689E6ACA49DD6E6E1A930", "yes");
INSERT INTO `wp_options` VALUES("6284", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("6285", "comment_previously_approved", "", "yes");
INSERT INTO `wp_options` VALUES("6286", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("26853", "wc_admin_note_home_screen_feedback_homescreen_accessed", "1613546207", "yes");
INSERT INTO `wp_options` VALUES("26854", "wc_remote_inbox_notifications_specs", "a:15:{s:23:\"facebook_pixel_api_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:23:\"facebook_pixel_api_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:44:\"Improve the performance of your Facebook ads\";s:7:\"content\";s:168:\"Enable Facebook Pixel and Conversions API through the latest version of Facebook for WooCommerce for improved performance and measurement of your Facebook ad campaigns.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"upgrade_now_facebook_pixel_api\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Upgrade now\";}}s:3:\"url\";s:67:\"plugin-install.php?tab=plugin-information&plugin=&section=changelog\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-02-15 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-02-29 00:00:00\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"facebook-for-woocommerce\";s:7:\"version\";s:5:\"2.1.4\";s:8:\"operator\";s:2:\"<=\";}}}s:16:\"facebook_ec_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:16:\"facebook_ec_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:59:\"Sync your product catalog with Facebook to help boost sales\";s:7:\"content\";s:170:\"A single click adds all products to your Facebook Business Page shop. Product changes are automatically synced, with the flexibility to control which products are listed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"learn_more_facebook_ec\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:42:\"https://woocommerce.com/products/facebook/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-03-01 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-03-15 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:24:\"facebook-for-woocommerce\";}}}}s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:255:\"WooCommerce Shipping & Tax helps get your store “ready to sell” as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:274:\"Product Add-Ons allow your customers to personalize products while they’re shopping on your online store. No more follow-up email requests—customers get what they want, before they’re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Manage subscriber payments from your store\'s dashboard\";s:7:\"content\";s:643:\"Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>  – now supporting <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Subscriptions</a>! <br/><br/><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"install-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Install now\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:10:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"1.7.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:8:\"industry\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";}}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:10;}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2020-11-18 14:00:00\";}i:7;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2020-12-07 00:00:00\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:9;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:26:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CO\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"DE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"FL\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"HI\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ID\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IN\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"KS\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"KY\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"LA\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MA\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MN\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MT\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NE\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NV\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NH\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NM\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ND\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OH\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OR\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"PA\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"SD\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"TN\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"TX\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"VA\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WA\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WI\";}}}}}s:27:\"wcpay-subscriptions-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"wcpay-subscriptions-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Manage subscriber payments from your store\'s dashboard\";s:7:\"content\";s:643:\"Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>  – now supporting <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Subscriptions</a>! <br/><br/><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"install-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Install now\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:10:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"1.7.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:8:\"industry\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";}}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:10;}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2020-11-18 14:00:00\";}i:7;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2020-12-07 00:00:00\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:9;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:24:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AL\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AK\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AZ\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AR\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CT\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"DC\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IL\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IA\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ME\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MD\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MI\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MS\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MO\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NJ\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NY\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NC\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OK\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"RI\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"SC\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"UT\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"VT\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WV\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WY\";}}}}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Get 50% off transaction fees with WooCommerce Payments\";s:7:\"content\";s:625:\"Keep more of your hard-earned cash by adding <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_exp20\" target=\"_blank\">WooCommerce Payments</a> to your store. Lock in a discounted rate of 1.5% + $0.15 for $25,000 of payments (or three months, whichever comes first). Limited time offer – don’t miss out! <br/><br/><em>By clicking \"Install now,\" you agree to our promotional <a href=\"https://woocommerce.com/terms-conditions/woocommerce-payments-promotion/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_exp20\" target=\"_blank\">Terms of Service</a>.</em>\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"install-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Install now\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:8:\"industry\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";}}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:10;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:26:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CO\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"DE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"FL\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"HI\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ID\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IN\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"KS\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"KY\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"LA\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MA\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MN\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MT\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NE\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NV\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NH\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NM\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ND\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OH\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OR\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"PA\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"SD\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"TN\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"TX\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"VA\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WA\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WI\";}}}}}s:27:\"wcpay-subscriptions-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"wcpay-subscriptions-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:43:\"Manage payments from your store\'s dashboard\";s:7:\"content\";s:560:\"Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>! Zero setup fees or monthly fees. Just pay-as-you-go, starting at just 2.9% + $0.30 per transaction for U.S.-issued cards. <br/><br/><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"install-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Install now\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:8:\"industry\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";}}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:10;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:24:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AL\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AK\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AZ\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AR\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CT\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"DC\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IL\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IA\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ME\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MD\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MI\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MS\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MO\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NJ\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NY\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NC\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OK\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"RI\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"SC\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"UT\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"VT\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WV\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WY\";}}}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:461:\"That\'s huge! You\'re well on your way to building a successful online store — now it’s time to think about how you\'ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";}}}s:31:\"wc-square-apple-pay-boost-sales\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"wc-square-apple-pay-boost-sales\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"Boost sales with Apple Pay\";s:7:\"content\";s:191:\"Now that you accept Apple Pay® with Square you can increase conversion rates by letting your customers know that Apple Pay® is available. Here’s a marketing guide to help you get started.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"boost-sales-marketing-guide\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"See marketing guide\";}}s:3:\"url\";s:97:\"https://developer.apple.com/apple-pay/marketing/?utm_source=inbox&utm_campaign=square-boost-sales\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:18:\"woocommerce-square\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"2.3\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"wc_square_apple_pay_enabled\";s:5:\"value\";i:1;s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:38:\"wc-square-apple-pay-grow-your-business\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:38:\"wc-square-apple-pay-grow-your-business\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:38:\"wc-square-apple-pay-grow-your-business\";O:8:\"stdClass\":8:{s:4:\"slug\";s:38:\"wc-square-apple-pay-grow-your-business\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"Grow your business with Square and Apple Pay \";s:7:\"content\";s:178:\"Now more than ever, shoppers want a fast, simple, and secure online checkout experience. Increase conversion rates by letting your customers know that you now accept Apple Pay®.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"grow-your-business-marketing-guide\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"See marketing guide\";}}s:3:\"url\";s:104:\"https://developer.apple.com/apple-pay/marketing/?utm_source=inbox&utm_campaign=square-grow-your-business\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:18:\"woocommerce-square\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"2.3\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"wc_square_apple_pay_enabled\";s:5:\"value\";i:2;s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:31:\"wc-square-apple-pay-boost-sales\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:31:\"wc-square-apple-pay-boost-sales\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:171:\"It\'s crucial to get your store\'s checkout as smooth as possible to avoid losing sales. Let\'s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:78:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";}}}s:39:\"wc-admin-first-five-things-to-customize\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-admin-first-five-things-to-customize\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"The first 5 things to customize in your store\";s:7:\"content\";s:173:\"Deciding what to start with first is tricky. To help you properly prioritize, we\'ve put together this short list of the first few things you should customize in WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/first-things-customize-woocommerce/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:2;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:5:\"value\";s:9:\"NOT EMPTY\";s:7:\"default\";s:9:\"NOT EMPTY\";s:9:\"operation\";s:2:\"!=\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("45392", "84f1d36fda919a9434139127332f04112807f476", "def50200cca3356248554c0959e9a7c9a09ff44e15ba83ae3c96522bbba3bb4293f5065062ef491626cbda84a6ea5c9b4893318695d0a0337dbe27cf6028b39d84c940810d4e291caa04c51d02a1a3cd994b13c2ea4076b6778cdbd49afd3e66458e4943e8372df0b309daed512618b23365653be46c976f28bc596a4014e67b3dd01886387d211c6bf6cc9356363dfe7457a62a4ade7b9e456d02f31c9422c6f18c98f3ffe466d693ebb35953d0118090caae09f476b7261ed31bf681e7d02b121dded76eec1b61cdf4dc431528f400701c9cb603b3fd37899ca5165f4b3749ebc14cef7d6015f79fc1529d841890ee6c6909089990ed146432de9e241bebfa04fb9c9281c15acec36db6f27fb36fc08cd5a0225f282835c656e1d2572a1a8294e65010cfe83ac4cb21baebdad02309a76b9f516cdb84bc0197c477a16967c4c60794720834fe96c81c6925fac587382044a00602fef3b22581501fcdefe9e0cdaa923dc3e9a9a705c6823c038df10bde3409f262d446fcd7749961f6a2f92325d8aa6e66c7b9caffde6d6a8548316ce44d167bf019ee7dc62b5a0260e9c76c39bc0d6c49b978448f61ab86bfb0feabb8ba5e389d6f35546aba7e31b4e8fff5f09d1af793e4a37d33b873686bb40bab5ba1f4aba6f1241f1f023ceb3741c67f84001f87886dafd5a1d16ba01dac13d609ad8f373038bd26558c0fd05ce7f9b1670a9c326069371ad9dd58883df86a7eeaf88855bc6a96404b2f48553f4c88020ce9d7237849d715950a68b0efa52ef82a7ff0a5648f0b3313d24b1550eb6d8e7bbae12be3af498acd9abf65c203ff3a5c05bba34b3b0ea5a32bc8a352a03f7669994ce6a567b383a1947d90ab0d2d2f8112ddc2b0b4b3409104ac816d55d08860691b17bc77112aa3bd4e17f03012b7f28b003c5aa81219d4d06c2d542034377f502c0ebc1e9632b31e0ec8bb37ce8aa4da9b908d75f2d904dad99bf0755b31580e7fa1df66566d5607c1036c1a6443fcf9474b22743953b41509f1f9edac7817e4dcdb089e6b94bcf1d7fbfe1303a77f7aba07355f09ab05af13c69eba929d5686ad58c99605a83a781fa00085abbd1cd86be5c1b5f4359cb04c90c91fd60006b28194525fc992944bac232a67e1e6f7c0fb64644d01b7dd6215a12f304cf313d7ff0cf5e4bd281044aa9e8fb0f1654378e290a0ef2a0b154b24a16c96ac27fc4b3990bd0df2de325e7906f186442d924a7854428b7a7fff007614fda56f3a57bccd6c514f57b32afc268136f32d25d4739e5dae9367e2efd2624bc89c40557cf16382f68cefbdf848bb35d4936b1656df819b9758571e1d6439187ca8d8cfbc8a1801c6a4212a65d0530d1e1b6b444ca1ace624ac0cbdeaca063552be22cdcbb92d86bbe46db70d81dc981a7c6ca17e293a98e67732ee4c209c60feea35ffbbe5a99d367cff477442faef2b8061f8f627a99904f6eb9a57ebd2cad010963034129873aa3042e00a1a49cc602f529d78fb98ec8342e2a52b415c8e683be2d4db0b5334d1ee2588e59b2546bb3b761d4c2fc38c0c84df9d32d2d7d2411238f1a6510ff6a53d5677af7acd19f67ef96f385835b43d71128c5ec27e6d324ee8a129e9651a43e5a2e67fdace649bfe0ee22a01324d68846ff59e82993c55fc8c8ea041258dc3a59516", "no");
INSERT INTO `wp_options` VALUES("45399", "auto_update_plugins", "a:1:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";}", "no");
INSERT INTO `wp_options` VALUES("38653", "gpMediaLibraryversion", "1.2.15", "yes");
INSERT INTO `wp_options` VALUES("37509", "rg_gforms_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("45131", "rg_gforms_message", "", "yes");
INSERT INTO `wp_options` VALUES("59749", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("60177", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:18:\"info@sitralweb.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:18:\"info@sitralweb.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("45391", "y86LyjHJ8zA3LQmLTA811s7Nzy32cLS1BQA", "BcHJomswAADQD7IguVQs3sJMzTXbldISQ6UxtF__ziHJPAINwE3jrVSGmJUA8wHGXFWWj-iOYn6TNvrUD0JI1ZofTH1ZoPkesSHMM9Vm7YyANWM5Te2YzDU4ccuJ4z6u5uNaumeDHUZKulq2i3BaPg5KudkmMhUObPzC2aZIK7O_2rKM3KTpB_j-E-Rwmvje9yk64mhu0Nc3hlThjsZiE5yMl9cTBO3z7OhVswN13YM1lNpRMdfjz0XNlJqwWDmxYdJ2_xj6PESWRpaLMPR00pGU9611xArWI2ZzWfDwvsnwJwbK95i8MkEG8trTw7dhGzvgbFVXhMvddKY2H0uU7OIPS7LSru-tWgnyB3WaGBajAhtkNkN2JjJvZtROMV_6PqYl6XM5gIe4D0rNvifUoxvwafeLnhtxujnITol0hm7Hi34Z0rx26-870_z0XZOV_nIf3-6uTfr-OJaSzWiDZRMUoFKi5IDuc4PBeKiBil1-sJD167nCLJDwCOz7t_1GMK5ODGvorMo1dRatl7MW57fY5RPDaO9ds07X4nXCbNe9QVAPDtxEr3sB5aUsLSk9cGFkaZS1wBt364XMqsHtz7RnNfhLhCnw33BhpuCep5-nGpKXUkdqQ0VdLsyXI4vRRyiluGN7YG9nl-TjVYCe9ah3dbptOJERfHB-sdfF5Hqd2Y9wdLS1xHxEOR4ktod_-rqAGVbVm70s9H3Rh_V9akLMtWZZMOMgskPDE6u1wzUbcDfcg8L3JYsP1SsbfbiZO5tpu50aPLbf06y4f_8B", "no");
INSERT INTO `wp_options` VALUES("33606", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("38651", "gwp_active_perks", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("98871", "_wp_suggested_policy_text_has_changed", "changed", "yes");
INSERT INTO `wp_options` VALUES("90902", "imsanity_max_width", "1920", "no");
INSERT INTO `wp_options` VALUES("90903", "imsanity_max_height", "1920", "no");
INSERT INTO `wp_options` VALUES("90904", "imsanity_max_width_library", "1920", "no");
INSERT INTO `wp_options` VALUES("90905", "imsanity_max_height_library", "1920", "no");
INSERT INTO `wp_options` VALUES("90906", "imsanity_max_width_other", "1920", "no");
INSERT INTO `wp_options` VALUES("90907", "imsanity_max_height_other", "1920", "no");
INSERT INTO `wp_options` VALUES("90908", "imsanity_bmp_to_jpg", "1", "no");
INSERT INTO `wp_options` VALUES("90909", "imsanity_png_to_jpg", "", "no");
INSERT INTO `wp_options` VALUES("90910", "imsanity_quality", "82", "no");
INSERT INTO `wp_options` VALUES("90911", "imsanity_delete_originals", "", "no");
INSERT INTO `wp_options` VALUES("90912", "imsanity_version", "2.8.0", "yes");
INSERT INTO `wp_options` VALUES("90927", "wp-smush-preset_configs", "a:1:{i:0;a:5:{s:2:\"id\";i:1;s:4:\"name\";s:12:\"Basic config\";s:11:\"description\";s:46:\"Recommended performance config for every site.\";s:7:\"default\";b:1;s:6:\"config\";a:2:{s:7:\"configs\";a:1:{s:8:\"settings\";a:22:{s:4:\"auto\";b:1;s:5:\"lossy\";b:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:1;s:6:\"backup\";b:1;s:10:\"png_to_jpg\";b:1;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;}}s:7:\"strings\";a:7:{s:10:\"bulk_smush\";a:1:{i:0;s:192:\"Automatic compression - Active\nSuper-Smush - Inactive\nMetadata - Active\nImage Resizing - Inactive\nUploaded Images - Inactive\nBackup Uploaded Images - Inactive\nPNG to JPEG Conversion - Inactive\";}s:9:\"lazy_load\";a:1:{i:0;s:8:\"Inactive\";}s:3:\"cdn\";a:1:{i:0;s:8:\"Inactive\";}s:8:\"webp_mod\";a:1:{i:0;s:8:\"Inactive\";}s:12:\"integrations\";a:1:{i:0;s:109:\"Gutenberg Support - Inactive\nWPBakery Page Builder - Inactive\nAmazon S3 - Inactive\nNextGen Gallery - Inactive\";}s:5:\"tools\";a:1:{i:0;s:33:\"Image Resize Detection - Inactive\";}s:8:\"settings\";a:1:{i:0;s:88:\"Color Accessibility - Inactive\nUsage Tracking - Inactive\nKeep Data On Uninstall - Active\";}}}}}", "no");
INSERT INTO `wp_options` VALUES("90928", "wp-smush-lazy_load", "a:9:{s:6:\"format\";a:6:{s:4:\"jpeg\";b:1;s:3:\"png\";b:1;s:4:\"webp\";b:1;s:3:\"gif\";b:1;s:3:\"svg\";b:1;s:6:\"iframe\";b:1;}s:6:\"output\";a:4:{s:7:\"content\";b:1;s:7:\"widgets\";b:1;s:10:\"thumbnails\";b:1;s:9:\"gravatars\";b:1;}s:9:\"animation\";a:4:{s:8:\"selected\";s:6:\"fadein\";s:6:\"fadein\";a:2:{s:8:\"duration\";i:400;s:5:\"delay\";i:0;}s:7:\"spinner\";a:2:{s:8:\"selected\";i:1;s:6:\"custom\";a:0:{}}s:11:\"placeholder\";a:3:{s:8:\"selected\";i:1;s:6:\"custom\";a:0:{}s:5:\"color\";s:7:\"#F3F3F3\";}}s:7:\"include\";a:7:{s:9:\"frontpage\";b:1;s:4:\"home\";b:1;s:4:\"page\";b:1;s:6:\"single\";b:1;s:7:\"archive\";b:1;s:8:\"category\";b:1;s:3:\"tag\";b:1;}s:13:\"exclude-pages\";a:0:{}s:15:\"exclude-classes\";a:0:{}s:6:\"footer\";b:1;s:6:\"native\";b:0;s:8:\"noscript\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("90929", "skip-smush-setup", "1", "yes");
INSERT INTO `wp_options` VALUES("90932", "dir_smush_stats", "a:2:{s:9:\"dir_smush\";a:2:{s:5:\"total\";i:0;s:9:\"optimised\";i:0;}s:14:\"combined_stats\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("90959", "wdev_logger_wp-smushit", "a:3:{s:6:\"option\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:13:\"global_module\";s:5:\"smush\";}s:7:\"modules\";a:10:{s:5:\"smush\";a:8:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:16:\"is_global_module\";b:1;s:4:\"name\";s:5:\"smush\";}s:3:\"cdn\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:3:\"cdn\";}s:4:\"lazy\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:4:\"lazy\";}s:4:\"webp\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:4:\"webp\";}s:7:\"png2jpg\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:7:\"png2jpg\";}s:6:\"resize\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:6:\"resize\";}s:3:\"dir\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:3:\"dir\";}s:6:\"backup\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:6:\"backup\";}s:3:\"api\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:3:\"api\";}s:12:\"integrations\";a:7:{s:25:\"use_native_filesystem_api\";b:1;s:12:\"max_log_size\";i:10;s:28:\"expected_log_size_in_percent\";d:0.69999999999999996;s:7:\"log_dir\";s:13:\"uploads/smush\";s:15:\"add_subsite_dir\";b:1;s:10:\"is_private\";b:1;s:4:\"name\";s:12:\"integrations\";}}s:13:\"global_module\";s:5:\"smush\";}", "no");
INSERT INTO `wp_options` VALUES("111010", "_site_transient_timeout_browser_ec6e53e23fd0a645dbd8049b21728394", "1695046603", "no");
INSERT INTO `wp_options` VALUES("111011", "_site_transient_browser_ec6e53e23fd0a645dbd8049b21728394", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"117.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("110420", "duplicator_settings", "a:16:{s:7:\"version\";s:7:\"1.5.5.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:30;}", "yes");
INSERT INTO `wp_options` VALUES("110548", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1678795431;}}", "yes");
INSERT INTO `wp_options` VALUES("111079", "_site_transient_timeout_theme_roots", "1694536044", "no");
INSERT INTO `wp_options` VALUES("111080", "_site_transient_theme_roots", "a:1:{s:9:\"iranamlak\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("110595", "check_am_req", "3", "yes");
INSERT INTO `wp_options` VALUES("110569", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("110570", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("110437", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-09-12 15:59:09\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.3.1\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"8.1.14\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:15:\"iranamlak_7_6_3\";s:4:\"Hash\";s:35:\"88669835fe30cfc76586_20230912155909\";s:8:\"NameHash\";s:51:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:61:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/home/yousefamini/public_html/ir3\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:713;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:5260;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-09-12 15:59:09\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.3.1\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"8.1.14\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:15:\"iranamlak_7_6_3\";s:4:\"Hash\";s:35:\"88669835fe30cfc76586_20230912155909\";s:8:\"NameHash\";s:51:\"iranamlak_7_6_3_88669835fe30cfc76586_20230912155909\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:47:\"/home/yousefamini/public_html/ir3/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:30:\"MySQL Community Server - (GPL)\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:42:\"/home/yousefamini/public_html/ir3/wp-admin\";i:1;s:45:\"/home/yousefamini/public_html/ir3/wp-includes\";i:2;s:54:\"/home/yousefamini/public_html/ir3/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:33:\"/home/yousefamini/public_html/ir3\";i:1;s:33:\"/home/yousefamini/public_html/ir3\";i:2;s:44:\"/home/yousefamini/public_html/ir3/wp-content\";i:3;s:52:\"/home/yousefamini/public_html/ir3/wp-content/uploads\";i:4;s:52:\"/home/yousefamini/public_html/ir3/wp-content/plugins\";i:5;s:55:\"/home/yousefamini/public_html/ir3/wp-content/mu-plugins\";i:6;s:51:\"/home/yousefamini/public_html/ir3/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:65:\"/home/yousefamini/public_html/ir3/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("110909", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_options` VALUES("93404", "duplicator_version_plugin", "1.5.5.1", "yes");
INSERT INTO `wp_options` VALUES("110756", "duplicator_notifications", "a:4:{s:6:\"update\";i:1694515376;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("111029", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1694527611;s:7:\"checked\";a:1:{s:9:\"iranamlak\";s:5:\"7.6.3\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("65007", "sgpb-unnecessary-scripts-removed-1", "1", "yes");
INSERT INTO `wp_options` VALUES("75773", "op_iranamlak", "a:443:{s:7:\"favicon\";a:8:{s:3:\"url\";s:61:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/icon.png\";s:2:\"id\";s:4:\"5271\";s:5:\"width\";s:2:\"50\";s:6:\"height\";s:2:\"46\";s:9:\"thumbnail\";s:61:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/icon.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:4:\"icon\";s:11:\"description\";s:0:\"\";}s:13:\"header-colors\";a:2:{s:7:\"color-1\";s:7:\"#1a90ff\";s:7:\"color-2\";s:7:\"#ffffff\";}s:9:\"tell-head\";s:11:\"09123456789\";s:11:\"menu-colors\";a:4:{s:7:\"color-1\";s:7:\"#ffffff\";s:7:\"color-2\";s:7:\"#000000\";s:7:\"color-3\";s:7:\"#1a90ff\";s:7:\"color-4\";s:7:\"#1a90ff\";}s:9:\"munumodel\";s:1:\"2\";s:9:\"headmodel\";s:0:\"\";s:8:\"sabtmelk\";s:1:\"1\";s:13:\"dokmesabtmelk\";s:19:\"ارسال آگهی\";s:23:\"add-state-button-colors\";a:4:{s:7:\"color-1\";s:7:\"#1a90ff\";s:7:\"color-2\";s:7:\"#ffffff\";s:7:\"color-3\";s:7:\"#0059ba\";s:7:\"color-4\";s:7:\"#ffffff\";}s:12:\"form_tagahza\";s:1:\"1\";s:17:\"dokmeform_tagahza\";s:17:\"تقاضا ملک\";s:27:\"taghaza-state-button-colors\";a:4:{s:7:\"color-1\";s:7:\"#1a90ff\";s:7:\"color-2\";s:7:\"#0059ba\";s:7:\"color-3\";s:7:\"#0059ba\";s:7:\"color-4\";s:7:\"#ffffff\";}s:5:\"logos\";a:8:{s:3:\"url\";s:62:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/logo3.png\";s:2:\"id\";s:4:\"2848\";s:5:\"width\";s:3:\"180\";s:6:\"height\";s:2:\"75\";s:9:\"thumbnail\";s:69:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/logo3-150x75.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:5:\"logo3\";s:11:\"description\";s:0:\"\";}s:7:\"popopad\";s:1:\"0\";s:13:\"popopad_title\";s:72:\"امکان درج تبلیغات پاپ اپ در ایران املاک \";s:13:\"popopad_width\";a:2:{s:5:\"width\";s:4:\"1000\";s:4:\"unit\";s:2:\"px\";}s:11:\"popopad_des\";s:1258:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.\r\n\r\nکتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد.\r\n\r\nتا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد.\r\n\r\nدر این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.\";s:21:\"banners_in_single_top\";s:0:\"\";s:24:\"banners_in_single_middle\";s:0:\"\";s:24:\"banners_in_single_bottom\";s:0:\"\";s:25:\"banners_in_single_sidebar\";s:0:\"\";s:26:\"banners_in_home_top_search\";s:0:\"\";s:29:\"banners_in_home_bottom_search\";s:0:\"\";s:27:\"banners_in_home_top_buttoms\";s:0:\"\";s:30:\"banners_in_home_bottom_buttoms\";s:0:\"\";s:22:\"banners_in_home_bottom\";s:0:\"\";s:26:\"banners_in_home_top_footer\";s:0:\"\";s:29:\"banners_in_home_bottom_footer\";s:0:\"\";s:10:\"homepageme\";s:1:\"1\";s:21:\"payam-sefareshi-onoff\";s:1:\"1\";s:15:\"payam-sefareshi\";s:124:\"<p><strong>هنوز ملک مورد نظرت رو پیدا نکردی ؟</strong> پس با ما تماس بگیر ... !</p>\";s:20:\"payam-sefareshi-link\";a:3:{s:3:\"url\";s:89:\"https://sitralweb.com/ir3/%d8%a7%d8%b1%d8%aa%d8%a8%d8%a7%d8%b7-%d8%a8%d8%a7-%d9%85%d8%a7/\";s:4:\"text\";s:22:\"ارتباط با ما\";s:6:\"target\";s:0:\"\";}s:11:\"links_index\";a:4:{i:0;a:3:{s:5:\"title\";s:27:\" ویلا های فروشی\";s:11:\"description\";s:37:\"تمامی ویلا های فروشی\";s:4:\"link\";a:3:{s:3:\"url\";s:156:\"https://sitralweb.com/ir3/%D8%AC%D8%B3%D8%AA%D8%AC%D9%88/?moamele=%D8%AE%D8%B1%DB%8C%D8%AF+%D9%88+%D9%81%D8%B1%D9%88%D8%B4&amp;melk=%D9%88%DB%8C%D9%84%D8%A7\";s:4:\"text\";s:27:\" ویلا های فروشی\";s:6:\"target\";s:0:\"\";}}i:1;a:3:{s:5:\"title\";s:39:\"آپارتمان های اجاره ای\";s:11:\"description\";s:48:\"کلیه آپارتمان های اجاره ای\";s:4:\"link\";a:3:{s:3:\"url\";s:92:\"https://sitralweb.com/ir3/جستجو/?moamele=رهن+و+اجاره&amp;melk=آپارتمان\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}i:2;a:3:{s:5:\"title\";s:28:\"زمین های مشارکت\";s:11:\"description\";s:39:\"کلیه زمین های مشارکتی\";s:4:\"link\";a:3:{s:3:\"url\";s:101:\"https://sitralweb.com/ir3/جستجو/?moamele=خرید+و+فروش&amp;melk=زمین&amp;mosharekat=1\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}i:3;a:3:{s:5:\"title\";s:17:\"معاوضه ها\";s:11:\"description\";s:37:\"کلیه املاک معاوضه ای\";s:4:\"link\";a:3:{s:3:\"url\";s:80:\"https://sitralweb.com/ir3/جستجو/?moamele=خرید+و+فروش&amp;moaveze=1\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}}s:12:\"states_index\";a:3:{i:0;a:22:{s:5:\"title\";s:48:\"فروشی های ویژه ایران املاک\";s:26:\"states_index_catselect_ops\";s:0:\"\";s:7:\"moamele\";s:20:\"خرید و فروش\";s:4:\"melk\";s:0:\"\";s:5:\"vijhe\";s:1:\"1\";s:4:\"fast\";s:0:\"\";s:10:\"mosharekat\";s:0:\"\";s:7:\"moaveze\";s:0:\"\";s:10:\"pishforosh\";s:0:\"\";s:7:\"kohpaye\";s:0:\"\";s:6:\"saheli\";s:0:\"\";s:8:\"shahraki\";s:0:\"\";s:9:\"pricefrom\";s:0:\"\";s:7:\"priceto\";s:0:\"\";s:9:\"ejarefrom\";s:0:\"\";s:7:\"ejareto\";s:0:\"\";s:15:\"ejarerozanefrom\";s:0:\"\";s:13:\"ejarerozaneto\";s:0:\"\";s:8:\"rahnfrom\";s:0:\"\";s:6:\"rahnto\";s:0:\"\";s:11:\"metrazhfrom\";s:0:\"\";s:9:\"metrazhto\";s:0:\"\";}i:1;a:22:{s:5:\"title\";s:48:\"فروشی های فوری ایران املاک\";s:26:\"states_index_catselect_ops\";s:0:\"\";s:7:\"moamele\";s:20:\"خرید و فروش\";s:4:\"melk\";s:0:\"\";s:5:\"vijhe\";s:0:\"\";s:4:\"fast\";s:1:\"1\";s:10:\"mosharekat\";s:0:\"\";s:7:\"moaveze\";s:0:\"\";s:10:\"pishforosh\";s:0:\"\";s:7:\"kohpaye\";s:0:\"\";s:6:\"saheli\";s:0:\"\";s:8:\"shahraki\";s:0:\"\";s:9:\"pricefrom\";s:0:\"\";s:7:\"priceto\";s:0:\"\";s:9:\"ejarefrom\";s:0:\"\";s:7:\"ejareto\";s:0:\"\";s:15:\"ejarerozanefrom\";s:0:\"\";s:13:\"ejarerozaneto\";s:0:\"\";s:8:\"rahnfrom\";s:0:\"\";s:6:\"rahnto\";s:0:\"\";s:11:\"metrazhfrom\";s:0:\"\";s:9:\"metrazhto\";s:0:\"\";}i:2;a:22:{s:5:\"title\";s:36:\"آخرین رهن و اجاره ها\";s:26:\"states_index_catselect_ops\";s:0:\"\";s:7:\"moamele\";s:20:\"رهن و اجاره\";s:4:\"melk\";s:0:\"\";s:5:\"vijhe\";s:0:\"\";s:4:\"fast\";s:0:\"\";s:10:\"mosharekat\";s:0:\"\";s:7:\"moaveze\";s:0:\"\";s:10:\"pishforosh\";s:0:\"\";s:7:\"kohpaye\";s:0:\"\";s:6:\"saheli\";s:0:\"\";s:8:\"shahraki\";s:0:\"\";s:9:\"pricefrom\";s:0:\"\";s:7:\"priceto\";s:0:\"\";s:9:\"ejarefrom\";s:0:\"\";s:7:\"ejareto\";s:0:\"\";s:15:\"ejarerozanefrom\";s:0:\"\";s:13:\"ejarerozaneto\";s:0:\"\";s:8:\"rahnfrom\";s:0:\"\";s:6:\"rahnto\";s:0:\"\";s:11:\"metrazhfrom\";s:0:\"\";s:9:\"metrazhto\";s:0:\"\";}}s:10:\"amlak_home\";s:1:\"1\";s:16:\"amlak_title_home\";s:40:\"آخرین آگهی های ثبت شده\";s:17:\"amlak_number_home\";s:1:\"9\";s:16:\"style_query_home\";s:6:\"style1\";s:9:\"news_home\";s:1:\"1\";s:15:\"news_title_home\";s:28:\"اخبار و اطلاعات\";s:16:\"news_number_home\";s:1:\"3\";s:14:\"moshavers_home\";s:1:\"1\";s:20:\"moshavers_title_home\";s:28:\"آژانس های املاک\";s:21:\"moshavers_number_home\";s:2:\"10\";s:13:\"karmands_home\";s:1:\"1\";s:23:\"admins_in_karmands_home\";s:1:\"1\";s:19:\"karmands_title_home\";s:22:\"اعضای تیم ما\";s:20:\"karmands_number_home\";s:2:\"10\";s:25:\"karmands_description_home\";s:150:\"توضیحات تست در اینجا قرار میگیرد . بزودی توضیحات جامع برای این بخش درج خواهیم نمود .\";s:7:\"faaliat\";a:3:{i:0;s:20:\"خرید و فروش\";i:1;s:20:\"رهن و اجاره\";i:2;s:23:\"اجاره روزانه\";}s:15:\"adminuserselect\";s:1:\"1\";s:25:\"adminuserselect-rahnejare\";s:1:\"1\";s:25:\"adminuserselect-ejarozane\";s:1:\"1\";s:26:\"admins_in_karmands_archive\";s:1:\"1\";s:11:\"theme_color\";s:7:\"#007aff\";s:4:\"font\";s:4:\"Dana\";s:16:\"breadcrumb-pages\";s:5:\"title\";s:16:\"breadcrumb-posts\";s:5:\"title\";s:16:\"breadcrumb-state\";s:5:\"false\";s:10:\"breadcrumb\";s:5:\"title\";s:7:\"aosmood\";s:1:\"1\";s:17:\"select-page-index\";s:1:\"2\";s:17:\"select-page-login\";s:2:\"41\";s:18:\"select-page-search\";s:2:\"25\";s:20:\"select-page-moshaver\";s:2:\"39\";s:21:\"select-page-karmandan\";s:4:\"6505\";s:16:\"select-page-blog\";s:4:\"3247\";s:22:\"select-page-faviorites\";s:2:\"34\";s:21:\"select-page-moghayese\";s:4:\"6497\";s:19:\"select-page-send-ad\";s:2:\"19\";s:15:\"select-page-ads\";s:4:\"6402\";s:19:\"select-page-tagahza\";s:4:\"4883\";s:14:\"select-page-me\";s:2:\"12\";s:23:\"select-page-editprofile\";s:2:\"21\";s:27:\"select-page-moshaver-shodan\";s:4:\"5518\";s:19:\"select-page-contact\";s:2:\"17\";s:10:\"javascript\";s:0:\"\";s:3:\"css\";s:0:\"\";s:15:\"active_auth_all\";s:4:\"true\";s:18:\"active_mobile_auth\";s:1:\"0\";s:6:\"noting\";s:0:\"\";s:13:\"reglogin_fast\";s:1:\"0\";s:22:\"active_auth_with_popop\";s:0:\"\";s:18:\"active_reg_for_all\";s:0:\"\";s:22:\"active_disposable_auth\";s:1:\"0\";s:17:\"active_terms_auth\";s:1:\"0\";s:30:\"active_terms_auth_descriptioan\";s:79:\"<p>قوانین و مقررات را خوانده ام و قبول دارم</p>\";s:23:\"active_valid_email_auth\";s:1:\"0\";s:23:\"subject_verify_mail_reg\";s:47:\"ایمیل تاییدیه ایران املاک\";s:21:\"text_valid_email_auth\";s:87:\"عرض ادب\r\n\r\nکد تایید شما در ایران املاک : {code}\r\n\r\nتشکر\";s:24:\"subject_verify_mail_lost\";s:54:\"\"ایران املاک\" بازیابی رمز عبور\";s:26:\"text_valid_email_auth_lost\";s:101:\"<p>عرض ادب</p><p>کد فراموشی رمز شما {code} میباشد .</p><p>باتشکر</p>\";s:30:\"subject_verify_mail_disposable\";s:50:\"\"ایران املاک\" رمز یکبار مصرف\";s:32:\"text_valid_email_auth_disposable\";s:99:\"<p>عرض ادب</p><p>کد یکبار مصرف شما {code} میباشد .</p><p>باتشکر</p>\";s:11:\"admin_phone\";s:0:\"\";s:13:\"user_meta_key\";s:5:\"phone\";s:21:\"var_send_notification\";s:5:\"title\";s:26:\"expired_days_notifications\";s:2:\"60\";s:15:\"tedadarghamcode\";s:1:\"4\";s:9:\"panel_sms\";s:0:\"\";s:14:\"api_key_sms_ir\";s:0:\"\";s:11:\"api_ippanel\";s:0:\"\";s:12:\"from_ippanel\";s:0:\"\";s:19:\"username_rayegansms\";s:0:\"\";s:15:\"pass_rayegansms\";s:0:\"\";s:17:\"api_key_kavenegar\";s:0:\"\";s:20:\"username_melipayamak\";s:0:\"\";s:16:\"pass_melipayamak\";s:0:\"\";s:16:\"code_reg_ippanel\";s:0:\"\";s:17:\"code_lost_ippanel\";s:0:\"\";s:23:\"code_disposable_ippanel\";s:0:\"\";s:19:\"code_reg_rayegansms\";s:0:\"\";s:20:\"code_lost_rayegansms\";s:0:\"\";s:26:\"code_disposable_rayegansms\";s:0:\"\";s:18:\"code_reg_kavenegar\";s:0:\"\";s:19:\"code_lost_kavenegar\";s:0:\"\";s:25:\"code_disposable_kavenegar\";s:0:\"\";s:20:\"code_reg_melipayamak\";s:0:\"\";s:21:\"code_lost_melipayamak\";s:0:\"\";s:27:\"code_disposable_melipayamak\";s:0:\"\";s:16:\"expire_time_auth\";s:1:\"1\";s:15:\"code_reg_sms_ir\";s:0:\"\";s:16:\"code_lost_sms_ir\";s:0:\"\";s:22:\"code_disposable_sms_ir\";s:0:\"\";s:32:\"active_notif_after_send_adv_user\";s:1:\"0\";s:31:\"code_after_send_adv_user_sms_ir\";s:0:\"\";s:32:\"code_after_send_adv_user_ippanel\";s:0:\"\";s:35:\"code_after_send_adv_user_rayegansms\";s:0:\"\";s:34:\"code_after_send_adv_user_kavenegar\";s:0:\"\";s:36:\"code_after_send_adv_user_melipayamak\";s:0:\"\";s:33:\"active_notif_after_send_adv_admin\";s:1:\"0\";s:32:\"code_after_send_adv_admin_sms_ir\";s:0:\"\";s:33:\"code_after_send_adv_admin_ippanel\";s:0:\"\";s:37:\"code_after_send_adv_admin_melipayamak\";s:0:\"\";s:36:\"code_after_send_adv_admin_rayegansms\";s:0:\"\";s:35:\"code_after_send_adv_admin_kavenegar\";s:0:\"\";s:34:\"active_notif_after_verify_adv_user\";s:1:\"0\";s:33:\"code_after_verify_adv_user_sms_ir\";s:0:\"\";s:34:\"code_after_verify_adv_user_ippanel\";s:0:\"\";s:37:\"code_after_verify_adv_user_rayegansms\";s:0:\"\";s:36:\"code_after_verify_adv_user_kavenegar\";s:0:\"\";s:38:\"code_after_verify_adv_user_melipayamak\";s:0:\"\";s:34:\"active_notif_after_reject_adv_user\";s:1:\"0\";s:37:\"code_after_reject_adv_user_rayegansms\";s:0:\"\";s:33:\"code_after_reject_adv_user_sms_ir\";s:0:\"\";s:34:\"code_after_reject_adv_user_ippanel\";s:0:\"\";s:36:\"code_after_reject_adv_user_kavenegar\";s:0:\"\";s:38:\"code_after_reject_adv_user_melipayamak\";s:0:\"\";s:32:\"active_notif_after_fast_adv_user\";s:1:\"0\";s:31:\"code_after_fast_adv_user_sms_ir\";s:0:\"\";s:32:\"code_after_fast_adv_user_ippanel\";s:0:\"\";s:35:\"code_after_fast_adv_user_rayegansms\";s:0:\"\";s:34:\"code_after_fast_adv_user_kavenegar\";s:0:\"\";s:36:\"code_after_fast_adv_user_melipayamak\";s:0:\"\";s:33:\"active_notif_after_fast_adv_admin\";s:1:\"0\";s:32:\"code_after_fast_adv_admin_sms_ir\";s:0:\"\";s:33:\"code_after_fast_adv_admin_ippanel\";s:0:\"\";s:36:\"code_after_fast_adv_admin_rayegansms\";s:0:\"\";s:35:\"code_after_fast_adv_admin_kavenegar\";s:0:\"\";s:37:\"code_after_fast_adv_admin_melipayamak\";s:0:\"\";s:35:\"active_notif_after_feature_adv_user\";s:1:\"0\";s:34:\"code_after_feature_adv_user_sms_ir\";s:0:\"\";s:35:\"code_after_feature_adv_user_ippanel\";s:0:\"\";s:38:\"code_after_feature_adv_user_rayegansms\";s:0:\"\";s:37:\"code_after_feature_adv_user_kavenegar\";s:0:\"\";s:39:\"code_after_feature_adv_user_melipayamak\";s:0:\"\";s:36:\"active_notif_after_feature_adv_admin\";s:1:\"0\";s:35:\"code_after_feature_adv_admin_sms_ir\";s:0:\"\";s:36:\"code_after_feature_adv_admin_ippanel\";s:0:\"\";s:39:\"code_after_feature_adv_admin_rayegansms\";s:0:\"\";s:38:\"code_after_feature_adv_admin_kavenegar\";s:0:\"\";s:40:\"code_after_feature_adv_admin_melipayamak\";s:0:\"\";s:34:\"active_notif_after_tamdid_adv_user\";s:0:\"\";s:33:\"code_after_tamdid_adv_user_sms_ir\";s:0:\"\";s:34:\"code_after_tamdid_adv_user_ippanel\";s:0:\"\";s:37:\"code_after_tamdid_adv_user_rayegansms\";s:0:\"\";s:36:\"code_after_tamdid_adv_user_kavenegar\";s:0:\"\";s:38:\"code_after_tamdid_adv_user_melipayamak\";s:0:\"\";s:35:\"active_notif_after_tamdid_adv_admin\";s:1:\"0\";s:34:\"code_after_tamdid_adv_admin_sms_ir\";s:0:\"\";s:35:\"code_after_tamdid_adv_admin_ippanel\";s:0:\"\";s:38:\"code_after_tamdid_adv_admin_rayegansms\";s:0:\"\";s:37:\"code_after_tamdid_adv_admin_kavenegar\";s:0:\"\";s:39:\"code_after_tamdid_adv_admin_melipayamak\";s:0:\"\";s:35:\"active_notif_after_expired_adv_user\";s:1:\"0\";s:34:\"code_after_expired_adv_user_sms_ir\";s:0:\"\";s:35:\"code_after_expired_adv_user_ippanel\";s:0:\"\";s:38:\"code_after_expired_adv_user_rayegansms\";s:0:\"\";s:37:\"code_after_expired_adv_user_kavenegar\";s:0:\"\";s:39:\"code_after_expired_adv_user_melipayamak\";s:0:\"\";s:36:\"active_notif_before_expired_adv_user\";s:1:\"0\";s:35:\"code_before_expired_adv_user_sms_ir\";s:0:\"\";s:36:\"code_before_expired_adv_user_ippanel\";s:0:\"\";s:39:\"code_before_expired_adv_user_rayegansms\";s:0:\"\";s:38:\"code_before_expired_adv_user_kavenegar\";s:0:\"\";s:40:\"code_before_expired_adv_user_melipayamak\";s:0:\"\";s:25:\"active_notif_package_user\";s:1:\"0\";s:27:\"code_notif_pack_user_sms_ir\";s:0:\"\";s:28:\"code_notif_pack_user_ippanel\";s:0:\"\";s:31:\"code_notif_pack_user_rayegansms\";s:0:\"\";s:30:\"code_notif_pack_user_kavenegar\";s:0:\"\";s:32:\"code_notif_pack_user_melipayamak\";s:0:\"\";s:26:\"active_notif_package_admin\";s:1:\"0\";s:28:\"code_notif_pack_admin_sms_ir\";s:0:\"\";s:29:\"code_notif_pack_admin_ippanel\";s:0:\"\";s:32:\"code_notif_pack_admin_rayegansms\";s:0:\"\";s:31:\"code_notif_pack_admin_kavenegar\";s:0:\"\";s:33:\"code_notif_pack_admin_melipayamak\";s:0:\"\";s:26:\"active_notif_moshaver_user\";s:1:\"0\";s:31:\"code_notif_moshaver_user_sms_ir\";s:0:\"\";s:32:\"code_notif_moshaver_user_ippanel\";s:0:\"\";s:35:\"code_notif_moshaver_user_rayegansms\";s:0:\"\";s:34:\"code_notif_moshaver_user_kavenegar\";s:0:\"\";s:36:\"code_notif_moshaver_user_melipayamak\";s:0:\"\";s:27:\"active_notif_moshaver_admin\";s:1:\"0\";s:32:\"code_notif_moshaver_admin_sms_ir\";s:0:\"\";s:33:\"code_notif_moshaver_admin_ippanel\";s:0:\"\";s:36:\"code_notif_moshaver_admin_rayegansms\";s:0:\"\";s:35:\"code_notif_moshaver_admin_kavenegar\";s:0:\"\";s:37:\"code_notif_moshaver_admin_melipayamak\";s:0:\"\";s:27:\"var_send_notification_email\";s:5:\"title\";s:32:\"expired_days_notifications_email\";s:0:\"\";s:38:\"active_notif_after_send_adv_user_email\";s:1:\"1\";s:28:\"subject_email_after_send_adv\";s:46:\"ارسال آگهی در ایران املاک\";s:28:\"content_email_after_send_adv\";s:214:\"<p>عرض ادب</p><p>آگهی شما با عنوان \" title \" با موفقیت ارسال گردید . پس از بررسی مدیریت در ایران املاک منتشر میگردد  .</p><p>تشکر</p>\";s:39:\"active_notif_after_send_adv_admin_email\";s:1:\"1\";s:34:\"subject_email_after_send_adv_admin\";s:46:\"ارسال آگهی در ایران املاک\";s:34:\"content_email_after_send_adv_admin\";s:213:\"<p>عرض ادب مدیر عزیز</p><p>آگهی جدید با عنوان \" title \" با موفقیت در ایران املاک ارسال شده است و منتظر تایید شماست  .</p><p>تشکر</p>\";s:41:\"active_notif_after_publish_adv_user_email\";s:1:\"1\";s:31:\"subject_email_after_publish_adv\";s:46:\"تایید آگهی در ایران املاک\";s:31:\"content_email_after_publish_adv\";s:152:\"<p>عرض ادب</p><p>آگهی شما با عنوان \" title \" با موفقیت در ایران املاک تایید گردید .</p><p>تشکر</p>\";s:40:\"active_notif_after_reject_adv_user_email\";s:1:\"1\";s:30:\"subject_email_after_reject_adv\";s:47:\"رد آگهی شما در ایران املاک\";s:30:\"content_email_after_reject_adv\";s:196:\"عرض ادب\r\n\r\nآگهی شما با عنوان \" title \" در ایرن املاک رد گردید . لطفا وارد سایت شده و دلیل آنرا مشاهده نمائید .\r\n\r\nتشکر\";s:38:\"active_notif_after_fast_adv_user_email\";s:1:\"1\";s:28:\"subject_email_after_fast_adv\";s:0:\"\";s:28:\"content_email_after_fast_adv\";s:158:\"عرض ادب\r\n\r\nآگهی شما با عنوان \" title \" با موفقیت در ایران املاک در لیست فوری قرار گرفت .\r\n\r\nتشکر\";s:39:\"active_notif_after_fast_adv_admin_email\";s:1:\"1\";s:34:\"subject_email_after_fast_adv_admin\";s:51:\"فوری شدن آگهی در ایران املاک\";s:34:\"content_email_after_fast_adv_admin\";s:160:\"عرض ادب\r\n\r\nآگهی جدید با عنوان \" title \" با موفقیت در ایران املاک در لیست فوری قرار گرفت .\r\n\r\nتشکر\";s:41:\"active_notif_after_feature_adv_user_email\";s:1:\"1\";s:31:\"subject_email_after_feature_adv\";s:58:\"ویژه شدن آگهی شما در ایران املاک\";s:31:\"content_email_after_feature_adv\";s:131:\"عرض ادب\r\n\r\nآگهی شما با عنوان \" title \" با موفقیت در لیست ویژه قرار گرفت .\r\n\r\nتشکر\";s:42:\"active_notif_after_feature_adv_admin_email\";s:1:\"1\";s:37:\"subject_email_after_feature_adv_admin\";s:33:\"ویژه شدن آگهی جدید\";s:37:\"content_email_after_feature_adv_admin\";s:150:\"عرض ادب\r\n\r\nمدیر عزیز ، یک آگهی با عنوان \" title \" با موفقیت در لیست ویژه قرار گرفت .\r\n\r\nتشکر\";s:40:\"active_notif_after_tamdid_adv_user_email\";s:1:\"1\";s:30:\"subject_email_after_tamdid_adv\";s:46:\"تمدید آگهی در ایران املاک\";s:30:\"content_email_after_tamdid_adv\";s:112:\"عرض ادب\r\n\r\nآگهی شما با عنوان \" title \" با موفقیت تمدید گردید .\r\n\r\nتشکر\";s:41:\"active_notif_after_tamdid_adv_admin_email\";s:0:\"\";s:36:\"subject_email_after_tamdid_adv_admin\";s:0:\"\";s:36:\"content_email_after_tamdid_adv_admin\";s:0:\"\";s:41:\"active_notif_after_expired_adv_user_email\";s:1:\"1\";s:31:\"subject_email_after_expired_adv\";s:33:\"منقضی شدن آگهی شما\";s:31:\"content_email_after_expired_adv\";s:98:\"عرض ادب\r\n\r\nآگهی شما با عنوان \" title \"  منقضی گردید  .\r\n\r\nتشکر\";s:42:\"active_notif_before_expired_adv_user_email\";s:1:\"1\";s:32:\"subject_email_before_expired_adv\";s:26:\"منقضی شدن آگهی\";s:32:\"content_email_before_expired_adv\";s:107:\"عرض ادب\r\n\r\nآگهی شما با عنوان \" title \" بزودی منقضی میگردد .\r\n\r\nتشکر\";s:31:\"active_notif_package_user_email\";s:0:\"\";s:21:\"subject_email_package\";s:0:\"\";s:21:\"content_email_package\";s:0:\"\";s:32:\"active_notif_package_admin_email\";s:0:\"\";s:27:\"subject_email_package_admin\";s:0:\"\";s:27:\"content_email_package_admin\";s:0:\"\";s:32:\"active_notif_moshaver_user_email\";s:0:\"\";s:22:\"subject_email_moshaver\";s:0:\"\";s:22:\"content_email_moshaver\";s:0:\"\";s:33:\"active_notif_moshaver_admin_email\";s:0:\"\";s:28:\"subject_email_moshaver_admin\";s:0:\"\";s:28:\"content_email_moshaver_admin\";s:0:\"\";s:26:\"search_home_defult_moamele\";s:0:\"\";s:11:\"shoar-onoff\";s:1:\"1\";s:5:\"shoar\";s:207:\"<h1 style=\"text-align: center;font-size: 18px;font-weight: normal\" data-mce-style=\"text-align: center; font-size: 18px; font-weight: normal;\">با ایران املاک یک گام جلوتر باشید</h1>\";s:21:\"filterbala-background\";s:16:\"backfilter-new-1\";s:10:\"index_tops\";a:11:{s:16:\"background-color\";s:7:\"#ffffff\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:16:\"background-image\";a:8:{s:3:\"url\";s:67:\"https://sitralweb.com/ir3/wp-content/uploads/2022/04/backsearch.jpg\";s:2:\"id\";s:4:\"6118\";s:5:\"width\";s:4:\"1280\";s:6:\"height\";s:3:\"742\";s:9:\"thumbnail\";s:75:\"https://sitralweb.com/ir3/wp-content/uploads/2022/04/backsearch-150x150.jpg\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:10:\"backsearch\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:13:\"center center\";s:17:\"background-repeat\";s:9:\"no-repeat\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-size\";s:5:\"cover\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:10:\"homeslider\";s:0:\"\";s:12:\"slider_index\";s:0:\"\";s:17:\"no_metrazh_search\";s:6:\"select\";s:14:\"metrazh_search\";a:11:{i:0;a:2:{s:5:\"title\";s:1:\"0\";s:7:\"meghdar\";s:1:\"0\";}i:1;a:2:{s:5:\"title\";s:9:\"50 متر\";s:7:\"meghdar\";s:2:\"50\";}i:2;a:2:{s:5:\"title\";s:9:\"60 متر\";s:7:\"meghdar\";s:2:\"60\";}i:3;a:2:{s:5:\"title\";s:9:\"70 متر\";s:7:\"meghdar\";s:2:\"70\";}i:4;a:2:{s:5:\"title\";s:9:\"85 متر\";s:7:\"meghdar\";s:2:\"85\";}i:5;a:2:{s:5:\"title\";s:10:\"100 متر\";s:7:\"meghdar\";s:3:\"100\";}i:6;a:2:{s:5:\"title\";s:10:\"150 متر\";s:7:\"meghdar\";s:3:\"150\";}i:7;a:2:{s:5:\"title\";s:10:\"200 متر\";s:7:\"meghdar\";s:3:\"200\";}i:8;a:2:{s:5:\"title\";s:10:\"300 متر\";s:7:\"meghdar\";s:3:\"300\";}i:9;a:2:{s:5:\"title\";s:10:\"500 متر\";s:7:\"meghdar\";s:3:\"500\";}i:10;a:2:{s:5:\"title\";s:11:\"1000 متر\";s:7:\"meghdar\";s:4:\"1000\";}}s:17:\"no_gheymat_forosh\";s:6:\"select\";s:14:\"gheymat_forosh\";a:9:{i:0;a:2:{s:5:\"title\";s:16:\"500 میلیون\";s:7:\"meghdar\";s:9:\"500000000\";}i:1;a:2:{s:5:\"title\";s:16:\"1 میلیارد\";s:7:\"meghdar\";s:10:\"1000000000\";}i:2;a:2:{s:5:\"title\";s:16:\"2 میلیارد\";s:7:\"meghdar\";s:10:\"2000000000\";}i:3;a:2:{s:5:\"title\";s:18:\"3.5 میلیارد\";s:7:\"meghdar\";s:10:\"3500000000\";}i:4;a:2:{s:5:\"title\";s:16:\"5 میلیارد\";s:7:\"meghdar\";s:10:\"5000000000\";}i:5;a:2:{s:5:\"title\";s:17:\"10 میلیارد\";s:7:\"meghdar\";s:11:\"10000000000\";}i:6;a:2:{s:5:\"title\";s:17:\"15 میلیارد\";s:7:\"meghdar\";s:11:\"15000000000\";}i:7;a:2:{s:5:\"title\";s:17:\"25 میلیارد\";s:7:\"meghdar\";s:11:\"25000000000\";}i:8;a:2:{s:5:\"title\";s:17:\"50 میلیارد\";s:7:\"meghdar\";s:11:\"50000000000\";}}s:16:\"no_gheymat_shabi\";s:6:\"select\";s:13:\"gheymat_shabi\";a:11:{i:0;a:2:{s:5:\"title\";s:1:\"0\";s:7:\"meghdar\";s:1:\"0\";}i:1;a:2:{s:5:\"title\";s:23:\"300 هزار تومان\";s:7:\"meghdar\";s:6:\"300000\";}i:2;a:2:{s:5:\"title\";s:23:\"500 هزار تومان\";s:7:\"meghdar\";s:6:\"500000\";}i:3;a:2:{s:5:\"title\";s:23:\"750 هزار تومان\";s:7:\"meghdar\";s:6:\"750000\";}i:4;a:2:{s:5:\"title\";s:14:\"1 میلیون\";s:7:\"meghdar\";s:7:\"1000000\";}i:5;a:2:{s:5:\"title\";s:16:\"1.5 میلیون\";s:7:\"meghdar\";s:7:\"1500000\";}i:6;a:2:{s:5:\"title\";s:16:\"2.5 میلیون\";s:7:\"meghdar\";s:7:\"2500000\";}i:7;a:2:{s:5:\"title\";s:14:\"4 میلیون\";s:7:\"meghdar\";s:7:\"4000000\";}i:8;a:2:{s:5:\"title\";s:14:\"8 میلیون\";s:7:\"meghdar\";s:7:\"8000000\";}i:9;a:2:{s:5:\"title\";s:15:\"15 میلیون\";s:7:\"meghdar\";s:8:\"15000000\";}i:10;a:2:{s:5:\"title\";s:15:\"50 میلیون\";s:7:\"meghdar\";s:8:\"50000000\";}}s:16:\"no_gheymat_ejare\";s:4:\"text\";s:13:\"gheymat_ejare\";a:11:{i:0;a:2:{s:5:\"title\";s:1:\"0\";s:7:\"meghdar\";s:1:\"0\";}i:1;a:2:{s:5:\"title\";s:23:\"500 هزار تومان\";s:7:\"meghdar\";s:6:\"500000\";}i:2;a:2:{s:5:\"title\";s:14:\"1 میلیون\";s:7:\"meghdar\";s:7:\"1000000\";}i:3;a:2:{s:5:\"title\";s:14:\"2 میلیون\";s:7:\"meghdar\";s:7:\"2000000\";}i:4;a:2:{s:5:\"title\";s:16:\"3.5 میلیون\";s:7:\"meghdar\";s:7:\"3500000\";}i:5;a:2:{s:5:\"title\";s:14:\"5 میلیون\";s:7:\"meghdar\";s:7:\"5000000\";}i:6;a:2:{s:5:\"title\";s:14:\"8 میلیون\";s:7:\"meghdar\";s:7:\"8000000\";}i:7;a:2:{s:5:\"title\";s:15:\"12 میلیون\";s:7:\"meghdar\";s:8:\"12000000\";}i:8;a:2:{s:5:\"title\";s:15:\"25 میلیون\";s:7:\"meghdar\";s:8:\"25000000\";}i:9;a:2:{s:5:\"title\";s:15:\"50 میلیون\";s:7:\"meghdar\";s:8:\"50000000\";}i:10;a:2:{s:5:\"title\";s:16:\"100 میلیون\";s:7:\"meghdar\";s:9:\"100000000\";}}s:12:\"gheymat_rahn\";a:10:{i:0;a:2:{s:5:\"title\";s:1:\"0\";s:7:\"meghdar\";s:1:\"0\";}i:1;a:2:{s:5:\"title\";s:15:\"10 میلیون\";s:7:\"meghdar\";s:8:\"10000000\";}i:2;a:2:{s:5:\"title\";s:15:\"25 میلیون\";s:7:\"meghdar\";s:8:\"25000000\";}i:3;a:2:{s:5:\"title\";s:15:\"50 میلیون\";s:7:\"meghdar\";s:8:\"50000000\";}i:4;a:2:{s:5:\"title\";s:16:\"100 میلیون\";s:7:\"meghdar\";s:9:\"100000000\";}i:5;a:2:{s:5:\"title\";s:16:\"200 میلیون\";s:7:\"meghdar\";s:9:\"200000000\";}i:6;a:2:{s:5:\"title\";s:16:\"500 میلیون\";s:7:\"meghdar\";s:9:\"500000000\";}i:7;a:2:{s:5:\"title\";s:16:\"1 میلیارد\";s:7:\"meghdar\";s:10:\"1000000000\";}i:8;a:2:{s:5:\"title\";s:16:\"2 میلیارد\";s:7:\"meghdar\";s:10:\"2000000000\";}i:9;a:2:{s:5:\"title\";s:16:\"5 میلیارد\";s:7:\"meghdar\";s:10:\"5000000000\";}}s:13:\"melkid_search\";s:1:\"1\";s:13:\"nomelk_search\";s:1:\"1\";s:12:\"otagh_search\";s:1:\"1\";s:14:\"senbana_search\";s:1:\"1\";s:18:\"havepicture_search\";s:1:\"1\";s:22:\"darkhastdehande_search\";s:1:\"1\";s:17:\"pishforosh_search\";s:1:\"1\";s:17:\"mosharekat_search\";s:1:\"1\";s:12:\"tahol_search\";s:1:\"1\";s:13:\"tabdil_search\";s:1:\"1\";s:14:\"darbast_search\";s:1:\"1\";s:14:\"emkanat_search\";s:1:\"1\";s:30:\"search-1-moamele-button-colors\";a:4:{s:7:\"color-1\";s:15:\"rgba(0,0,0,0.4)\";s:7:\"color-2\";s:7:\"#ffffff\";s:7:\"color-3\";s:21:\"rgba(255,255,255,0.6)\";s:7:\"color-4\";s:7:\"#000000\";}s:21:\"search-1-button-color\";a:4:{s:7:\"color-1\";s:7:\"#008cd8\";s:7:\"color-2\";s:7:\"#ffffff\";s:7:\"color-3\";s:7:\"#0059ba\";s:7:\"color-4\";s:7:\"#ffffff\";}s:28:\"search_filter_defult_moamele\";s:0:\"\";s:21:\"posts_per_page_search\";s:2:\"20\";s:18:\"style_query_search\";s:6:\"style1\";s:19:\"no_metrazh_search_2\";s:4:\"text\";s:16:\"metrazh_search_2\";s:0:\"\";s:19:\"no_gheymat_forosh_2\";s:4:\"text\";s:16:\"gheymat_forosh_2\";s:0:\"\";s:18:\"no_gheymat_shabi_2\";s:4:\"text\";s:15:\"gheymat_shabi_2\";s:0:\"\";s:18:\"no_gheymat_ejare_2\";s:4:\"text\";s:15:\"gheymat_ejare_2\";s:0:\"\";s:14:\"gheymat_rahn_2\";s:0:\"\";s:15:\"melkid_search_2\";s:1:\"1\";s:15:\"nomelk_search_2\";s:1:\"1\";s:14:\"otagh_search_2\";s:1:\"1\";s:16:\"senbana_search_2\";s:1:\"1\";s:20:\"havepicture_search_2\";s:1:\"1\";s:24:\"darkhastdehande_search_2\";s:1:\"1\";s:19:\"pishforosh_search_2\";s:1:\"1\";s:19:\"mosharekat_search_2\";s:1:\"1\";s:14:\"tahol_search_2\";s:1:\"1\";s:15:\"tabdil_search_2\";s:1:\"1\";s:16:\"darbast_search_2\";s:1:\"1\";s:16:\"emkanat_search_2\";s:1:\"1\";s:30:\"search-2-moamele-button-colors\";a:4:{s:7:\"color-1\";s:15:\"rgba(0,0,0,0.4)\";s:7:\"color-2\";s:7:\"#ffffff\";s:7:\"color-3\";s:21:\"rgba(255,255,255,0.6)\";s:7:\"color-4\";s:7:\"#000000\";}s:21:\"search-2-button-color\";a:4:{s:7:\"color-1\";s:7:\"#008cd8\";s:7:\"color-2\";s:7:\"#ffffff\";s:7:\"color-3\";s:7:\"#0059ba\";s:7:\"color-4\";s:7:\"#ffffff\";}s:20:\"filtermap-background\";s:13:\"backfiltermap\";s:8:\"map_tops\";a:11:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:16:\"background-image\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:7:\"maptype\";s:6:\"neshan\";s:15:\"map_api_key_web\";s:0:\"\";s:20:\"map_api_key_services\";s:0:\"\";s:17:\"search_map_defult\";a:4:{s:7:\"address\";s:0:\"\";s:8:\"latitude\";s:17:\"35.69611746729962\";s:9:\"longitude\";s:18:\"51.393856107237184\";s:4:\"zoom\";s:2:\"11\";}s:8:\"maptheme\";s:6:\"dreamy\";s:8:\"map-icon\";a:8:{s:3:\"url\";s:68:\"https://sitralweb.com/ir3/wp-content/uploads/2022/10/marker-icon.png\";s:2:\"id\";s:4:\"6464\";s:5:\"width\";s:2:\"25\";s:6:\"height\";s:2:\"41\";s:9:\"thumbnail\";s:68:\"https://sitralweb.com/ir3/wp-content/uploads/2022/10/marker-icon.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:11:\"marker-icon\";s:11:\"description\";s:0:\"\";}s:14:\"map-icon-hover\";a:8:{s:3:\"url\";s:67:\"https://sitralweb.com/ir3/wp-content/uploads/2022/10/marker-red.png\";s:2:\"id\";s:4:\"6463\";s:5:\"width\";s:2:\"25\";s:6:\"height\";s:2:\"41\";s:9:\"thumbnail\";s:67:\"https://sitralweb.com/ir3/wp-content/uploads/2022/10/marker-red.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:10:\"marker-red\";s:11:\"description\";s:0:\"\";}s:11:\"fileshowmap\";s:1:\"1\";s:14:\"dokmesearchmap\";s:1:\"2\";s:18:\"blog_sidebar_first\";s:0:\"\";s:12:\"blogcomments\";s:1:\"1\";s:11:\"blog_rating\";s:1:\"1\";s:17:\"blog_sidebar_last\";s:0:\"\";s:11:\"nopicsingle\";s:72:\"https://sitralweb.com/ir3/wp-content/uploads/woocommerce-placeholder.png\";s:9:\"watermark\";s:66:\"https://sitralweb.com/ir3/wp-content/uploads/2022/03/watermark.png\";s:14:\"watermarkplace\";s:6:\"random\";s:10:\"amarbazdid\";s:1:\"1\";s:8:\"boxortab\";s:3:\"tab\";s:14:\"monghazi_color\";s:7:\"#ff0000\";s:11:\"vijhe_color\";s:7:\"#ff0000\";s:10:\"fori_color\";s:7:\"#0084e2\";s:11:\"countimages\";s:1:\"1\";s:13:\"autoexpireing\";s:1:\"0\";s:15:\"timecantoexpire\";s:2:\"30\";s:12:\"expiredposts\";s:9:\"\"expired\"\";s:13:\"autodeleteing\";s:1:\"0\";s:15:\"timecantodelete\";s:1:\"0\";s:11:\"ads_special\";s:1:\"1\";s:13:\"form_moshaver\";s:1:\"1\";s:13:\"statecomments\";s:1:\"1\";s:12:\"state_rating\";s:1:\"1\";s:12:\"gheymatmetri\";s:1:\"0\";s:8:\"telmalek\";s:1:\"0\";s:10:\"addresmelk\";s:1:\"0\";s:8:\"nammalek\";s:1:\"0\";s:10:\"emailmalek\";s:1:\"0\";s:8:\"location\";s:1:\"0\";s:12:\"contentforme\";s:1:\"0\";s:12:\"maxpicnumber\";s:1:\"8\";s:12:\"maxpicupload\";s:1:\"5\";s:8:\"enteshar\";s:7:\"pending\";s:15:\"enteshar-edited\";s:7:\"pending\";s:13:\"show_ads_user\";s:1:\"1\";s:13:\"delet_by_user\";s:1:\"1\";s:16:\"monghazi_by_user\";s:1:\"1\";s:16:\"email_sendestate\";s:1:\"1\";s:16:\"phone_sendestate\";s:1:\"1\";s:15:\"name_sendestate\";s:1:\"1\";s:18:\"address_sendestate\";s:1:\"1\";s:18:\"sokonat_sendestate\";s:1:\"1\";s:13:\"mg_sendestate\";s:1:\"1\";s:17:\"saheli_sendestate\";s:1:\"1\";s:19:\"shahraki_sendestate\";s:1:\"1\";s:18:\"kohpaye_sendestate\";s:1:\"1\";s:16:\"video_sendestate\";s:1:\"1\";s:23:\"video_aparat_sendestate\";s:1:\"0\";s:16:\"hamam_sendestate\";s:1:\"1\";s:13:\"wc_sendestate\";s:1:\"1\";s:16:\"sanad_sendestate\";s:1:\"1\";s:23:\"sanad_sendestate_choice\";a:9:{i:0;a:1:{s:5:\"onvan\";s:11:\"تک برگ\";}i:1;a:1:{s:5:\"onvan\";s:19:\"منگوله دار\";}i:2;a:1:{s:5:\"onvan\";s:19:\"قولنامه ای\";}i:3;a:1:{s:5:\"onvan\";s:12:\"اوقافی\";}i:4;a:1:{s:5:\"onvan\";s:12:\"بنیادی\";}i:5;a:1:{s:5:\"onvan\";s:14:\"سازمانی\";}i:6;a:1:{s:5:\"onvan\";s:6:\"نسخ\";}i:7;a:1:{s:5:\"onvan\";s:22:\"در دست اقدام\";}i:8;a:1:{s:5:\"onvan\";s:8:\"سایر\";}}s:18:\"karbari_sendestate\";s:1:\"1\";s:25:\"karbari_sendestate_choice\";a:11:{i:0;a:1:{s:5:\"onvan\";s:12:\"مسکونی\";}i:1;a:1:{s:5:\"onvan\";s:10:\"تجاری\";}i:2;a:1:{s:5:\"onvan\";s:10:\"اداری\";}i:3;a:1:{s:5:\"onvan\";s:10:\"زراعی\";}i:4;a:1:{s:5:\"onvan\";s:10:\"باغات\";}i:5;a:1:{s:5:\"onvan\";s:12:\"تفریحی\";}i:6;a:1:{s:5:\"onvan\";s:10:\"ورزشی\";}i:7;a:1:{s:5:\"onvan\";s:15:\"فضای سبز\";}i:8;a:1:{s:5:\"onvan\";s:21:\"بدون کاربری\";}i:9;a:1:{s:5:\"onvan\";s:22:\"خارج از بافت\";}i:10;a:1:{s:5:\"onvan\";s:8:\"سایر\";}}s:15:\"nama_sendestate\";s:1:\"1\";s:22:\"nama_sendestate_choice\";a:11:{i:0;a:1:{s:5:\"onvan\";s:6:\"سنگ\";}i:1;a:1:{s:5:\"onvan\";s:10:\"سیمان\";}i:2;a:1:{s:5:\"onvan\";s:8:\"شیشه\";}i:3;a:1:{s:5:\"onvan\";s:16:\"کامپوزیت\";}i:4;a:1:{s:5:\"onvan\";s:12:\"کلاسیک\";}i:5;a:1:{s:5:\"onvan\";s:6:\"آجر\";}i:6;a:1:{s:5:\"onvan\";s:6:\"چوب\";}i:7;a:1:{s:5:\"onvan\";s:8:\"مدرن\";}i:8;a:1:{s:5:\"onvan\";s:12:\"ترکیبی\";}i:9;a:1:{s:5:\"onvan\";s:8:\"رومی\";}i:10;a:1:{s:5:\"onvan\";s:8:\"سایر\";}}s:18:\"senbana_sendestate\";s:1:\"1\";s:25:\"senbana_sendestate_choice\";a:7:{i:0;a:1:{s:5:\"onvan\";s:10:\"نوساز\";}i:1;a:1:{s:5:\"onvan\";s:15:\"1 تا 5 سال\";}i:2;a:1:{s:5:\"onvan\";s:16:\"5 تا 10 سال\";}i:3;a:1:{s:5:\"onvan\";s:17:\"10 تا 20 سال\";}i:4;a:1:{s:5:\"onvan\";s:18:\"20 تا 50 سال \";}i:5;a:1:{s:5:\"onvan\";s:23:\"50 سال به بالا\";}i:6;a:1:{s:5:\"onvan\";s:10:\"کلنگی\";}}s:18:\"kabinet_sendestate\";s:1:\"0\";s:25:\"kabinet_sendestate_choice\";a:7:{i:0;a:1:{s:5:\"onvan\";s:16:\"کابینت MDF\";}i:1;a:1:{s:5:\"onvan\";s:23:\"کابینت جزیره\";}i:2;a:1:{s:5:\"onvan\";s:19:\"کابینت چوب\";}i:3;a:1:{s:5:\"onvan\";s:21:\"کابینت فلزی\";}i:4;a:1:{s:5:\"onvan\";s:25:\"کابینت ممبران\";}i:5;a:1:{s:5:\"onvan\";s:25:\"کابینت هایگلس\";}i:6;a:1:{s:5:\"onvan\";s:8:\"سایر\";}}s:18:\"kafposh_sendestate\";s:1:\"1\";s:25:\"kafposh_sendestate_choice\";a:7:{i:0;a:1:{s:5:\"onvan\";s:10:\"پارکت\";}i:1;a:1:{s:5:\"onvan\";s:12:\"سرامیک\";}i:2;a:1:{s:5:\"onvan\";s:6:\"سنگ\";}i:3;a:1:{s:5:\"onvan\";s:10:\"سیمان\";}i:4;a:1:{s:5:\"onvan\";s:14:\"موزائیک\";}i:5;a:1:{s:5:\"onvan\";s:8:\"موکت\";}i:6;a:1:{s:5:\"onvan\";s:8:\"سایر\";}}s:20:\"myemkanat_sendestate\";s:1:\"1\";s:18:\"emkanat_sendestate\";a:30:{i:0;a:1:{s:5:\"onvan\";s:4:\"آب\";}i:1;a:1:{s:5:\"onvan\";s:6:\"برق\";}i:2;a:1:{s:5:\"onvan\";s:6:\"گاز\";}i:3;a:1:{s:5:\"onvan\";s:14:\"پارکینگ\";}i:4;a:1:{s:5:\"onvan\";s:14:\"آسانسور\";}i:5;a:1:{s:5:\"onvan\";s:12:\"انباری\";}i:6;a:1:{s:5:\"onvan\";s:20:\"درب ضد سرقت\";}i:7;a:1:{s:5:\"onvan\";s:8:\"تلفن\";}i:8;a:1:{s:5:\"onvan\";s:10:\"شوفاژ\";}i:9;a:1:{s:5:\"onvan\";s:12:\"شومینه\";}i:10;a:1:{s:5:\"onvan\";s:8:\"پکیج\";}i:11;a:1:{s:5:\"onvan\";s:8:\"کولر\";}i:12;a:1:{s:5:\"onvan\";s:8:\"سونا\";}i:13;a:1:{s:5:\"onvan\";s:10:\"استخر\";}i:14;a:1:{s:5:\"onvan\";s:10:\"جکوزی\";}i:15;a:1:{s:5:\"onvan\";s:23:\"آیفون تصویری\";}i:16;a:1:{s:5:\"onvan\";s:30:\"دوربین مدار بسته\";}i:17;a:1:{s:5:\"onvan\";s:17:\"درب ریموت\";}i:18;a:1:{s:5:\"onvan\";s:19:\"آنتن مرکزی\";}i:19;a:1:{s:5:\"onvan\";s:10:\"پاسیو\";}i:20;a:1:{s:5:\"onvan\";s:16:\"باربیکیو\";}i:21;a:1:{s:5:\"onvan\";s:10:\"بالکن\";}i:22;a:1:{s:5:\"onvan\";s:8:\"حیات\";}i:23;a:1:{s:5:\"onvan\";s:8:\"لابی\";}i:24;a:1:{s:5:\"onvan\";s:25:\"سالن اجتماعات\";}i:25;a:1:{s:5:\"onvan\";s:16:\"سرایداری\";}i:26;a:1:{s:5:\"onvan\";s:8:\"مبله\";}i:27;a:1:{s:5:\"onvan\";s:19:\"اطفاء حریق\";}i:28;a:1:{s:5:\"onvan\";s:6:\"وام\";}i:29;a:1:{s:5:\"onvan\";s:11:\"آب چاه\";}}s:14:\"map_sendestate\";s:1:\"1\";s:16:\"map_send_default\";a:4:{s:7:\"address\";s:0:\"\";s:8:\"latitude\";s:18:\"32.220237415852715\";s:9:\"longitude\";s:17:\"53.36527569099229\";s:4:\"zoom\";s:1:\"5\";}s:7:\"freeadd\";s:1:\"1\";s:16:\"add-free-sending\";s:1:\"5\";s:11:\"add-sending\";s:4:\"5000\";s:22:\"active_sending_feature\";s:1:\"1\";s:19:\"add-sending_feature\";s:4:\"5000\";s:22:\"active_sending_instant\";s:1:\"1\";s:19:\"add-sending_instant\";s:4:\"1000\";s:23:\"active_sending_continue\";s:1:\"1\";s:20:\"add-sending_continue\";s:4:\"2000\";s:13:\"free_pay_text\";s:0:\"\";s:25:\"active_karbar_to_moshaver\";s:1:\"1\";s:24:\"price_karbar_to_moshaver\";s:6:\"150000\";s:23:\"note_karbar_to_moshaver\";s:82:\"درخواست مشاور شدن شما در انتظار بررسی میباشد.\";s:26:\"content_karbar_to_moshaver\";s:0:\"\";s:10:\"dargahbank\";s:8:\"zarinpal\";s:18:\"terminal_saderatat\";s:0:\"\";s:13:\"mid_saderatat\";s:0:\"\";s:15:\"terminal_mellat\";s:0:\"\";s:11:\"name_mellat\";s:0:\"\";s:11:\"pass_mellat\";s:0:\"\";s:13:\"test_zarinpal\";s:1:\"1\";s:17:\"merchent_id_zarin\";s:36:\"xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\";s:10:\"desc_zarin\";s:37:\"خرید با درگاه آنلاین\";s:15:\"active_packages\";s:1:\"1\";s:21:\"pakages_irankala_page\";s:4:\"5275\";s:16:\"iranamlak-offers\";a:3:{i:0;a:8:{s:5:\"title\";s:13:\"پکیج یک\";s:16:\"active_for_users\";s:1:\"1\";s:11:\"description\";s:21:\"تست توضیحات\";s:5:\"tedad\";s:2:\"10\";s:6:\"forosh\";s:2:\"20\";s:9:\"rahnejare\";s:2:\"30\";s:11:\"ejarerozane\";s:2:\"40\";s:5:\"price\";s:5:\"10000\";}i:1;a:8:{s:5:\"title\";s:13:\"پکیج دو\";s:16:\"active_for_users\";s:1:\"2\";s:11:\"description\";s:21:\"تست توضیحات\";s:5:\"tedad\";s:2:\"25\";s:6:\"forosh\";s:2:\"40\";s:9:\"rahnejare\";s:2:\"50\";s:11:\"ejarerozane\";s:2:\"59\";s:5:\"price\";s:5:\"20000\";}i:2;a:8:{s:5:\"title\";s:13:\"پکیج سه\";s:16:\"active_for_users\";s:1:\"0\";s:11:\"description\";s:21:\"تست توضیحات\";s:5:\"tedad\";s:1:\"5\";s:6:\"forosh\";s:2:\"10\";s:9:\"rahnejare\";s:2:\"15\";s:11:\"ejarerozane\";s:2:\"20\";s:5:\"price\";s:1:\"0\";}}s:17:\"footer-background\";a:9:{s:16:\"background-color\";s:7:\"#efefef\";s:16:\"background-image\";a:8:{s:3:\"url\";s:67:\"https://sitralweb.com/ir3/wp-content/uploads/2022/02/avatar_all.png\";s:2:\"id\";s:4:\"5279\";s:5:\"width\";s:4:\"1126\";s:6:\"height\";s:3:\"150\";s:9:\"thumbnail\";s:75:\"https://sitralweb.com/ir3/wp-content/uploads/2022/02/avatar_all-150x150.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:10:\"avatar_all\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:13:\"center bottom\";s:17:\"background-repeat\";s:9:\"no-repeat\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:17:\"title-box2-footer\";s:34:\"درباره ایران املاک\";s:10:\"box2footer\";s:795:\"ایران املاک در ابتدا با هدف ایجاد کسب و کار و سپس برای ارئه اطلاعات دقیق ملکی اعم از خرید و فروش ، رهن و اجاره کلیه انواع ملک بصورت تخصصی و حرفه ای برای مشتریان عزیز راه اندازی گردید .\r\n\r\nبا توجه به استفاده های بسیار بالای مردمی از فضای مجازی ، به جهت دسترسی بهتر و آسانتر مشتریان با مقوله خرید و فروش ملک در شمال کشور ، با طراحی قالب ایران املاک در سال 1399 ، توانستم تا حدود بسیار زیادی راه را برای تعاملی بهتر فی مابین مشاور و مشتریان هموار کنیم .\";s:17:\"title-box3-footer\";s:38:\"اعتبارات ایران املاک\";s:10:\"box3footer\";s:150:\"<img class=\"wp-image-6424 alignright\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2022/06/enamad-150x150.png\" alt=\"\" width=\"110\" height=\"110\" />\";s:12:\"box3footer-2\";s:0:\"\";s:7:\"address\";s:51:\"ایران ، مازندران ، خیابان من\";s:5:\"email\";s:13:\"info@test.com\";s:6:\"mobile\";s:11:\"09123456789\";s:8:\"mobile-2\";s:11:\"09123456789\";s:4:\"tell\";s:11:\"01122334455\";s:12:\"social-links\";a:2:{i:0;a:3:{s:5:\"title\";s:12:\"تلگرام\";s:8:\"fonticon\";s:15:\"fab fa-telegram\";s:3:\"url\";a:3:{s:3:\"url\";s:13:\"https://t.me/\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}i:1;a:3:{s:5:\"title\";s:20:\"اینستاگرام\";s:8:\"fonticon\";s:16:\"fab fa-instagram\";s:3:\"url\";a:3:{s:3:\"url\";s:22:\"https://instagram.com/\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}}s:15:\"copyright_color\";a:1:{s:16:\"background-color\";s:7:\"#333333\";}s:9:\"copyright\";s:76:\"حقوق این قالب متعلق به ایران املاک می باشد\";s:11:\"cpsitralweb\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("110411", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("73659", "options_entekhab", "تست دو", "no");
INSERT INTO `wp_options` VALUES("73660", "_options_entekhab", "field_61d93abc43ae0", "no");
INSERT INTO `wp_options` VALUES("59755", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("64995", "SGPBUsageDays", "0", "yes");
INSERT INTO `wp_options` VALUES("64996", "SGPBInstallDate", "1630222639", "yes");
INSERT INTO `wp_options` VALUES("64997", "SGPBOpenNextTime", "1632814639", "yes");
INSERT INTO `wp_options` VALUES("64998", "SGPBMaxOpenCount", "80", "yes");
INSERT INTO `wp_options` VALUES("64999", "sgpbPopupBuilderRegisteredPlugins", "[]", "yes");
INSERT INTO `wp_options` VALUES("65000", "SGPB_INACTIVE_EXTENSIONS", "inactive", "yes");
INSERT INTO `wp_options` VALUES("53918", "rpwcm_options", "a:7:{s:18:\"rpwcm_redirect_url\";s:0:\"\";s:22:\"rpwcm_restrict_product\";i:0;s:23:\"rpwcm_reminders_enabled\";i:0;s:20:\"rpwcm_reminders_days\";s:0:\"\";s:18:\"rpwcm_admin_access\";i:1;s:16:\"rpwcm_block_urls\";a:0:{}s:19:\"rpwcm_main_site_url\";s:42:\"https://sitralw%%%RPWCM%%%eb.com/iranamlak\";}", "yes");
INSERT INTO `wp_options` VALUES("53938", "wpdb_rcp_memberships_version", "202003315", "yes");
INSERT INTO `wp_options` VALUES("53934", "wpdb_rcp_discounts_version", "202003313", "yes");
INSERT INTO `wp_options` VALUES("53936", "wpdb_rcp_membership_counts_version", "202003311", "yes");
INSERT INTO `wp_options` VALUES("53937", "wpdb_restrict_content_pro_version", "202009252", "yes");
INSERT INTO `wp_options` VALUES("53939", "wpdb_rcp_membershipmeta_version", "201901291", "yes");
INSERT INTO `wp_options` VALUES("53940", "wpdb_rcp_queue_version", "202003312", "yes");
INSERT INTO `wp_options` VALUES("53946", "ithemes-updater-cache", "a:12:{s:18:\"timeout-multiplier\";i:1;s:10:\"expiration\";i:0;s:9:\"timestamp\";i:0;s:8:\"packages\";a:0:{}s:14:\"update_plugins\";a:0:{}s:24:\"update_plugins_no_update\";a:0:{}s:13:\"update_themes\";a:0:{}s:23:\"update_themes_no_update\";a:0:{}s:12:\"use_ca_patch\";b:0;s:7:\"use_ssl\";b:1;s:14:\"quick_releases\";b:0;s:16:\"site_url_history\";a:1:{s:25:\"https://sitralweb.com/ir3\";i:1623581040;}}", "no");
INSERT INTO `wp_options` VALUES("47426", "wooccm_checkout_force_create_account", "no", "yes");
INSERT INTO `wp_options` VALUES("47438", "wooccm_shipping", "a:9:{i:0;a:69:{s:2:\"id\";i:0;s:3:\"key\";s:19:\"shipping_first_name\";s:4:\"name\";s:10:\"first_name\";s:4:\"type\";s:4:\"text\";s:8:\"disabled\";b:1;s:5:\"order\";i:1;s:8:\"priority\";i:10;s:5:\"label\";s:6:\"نام\";s:11:\"placeholder\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:14:\"form-row-first\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:1:{i:0;s:14:\"form-row-first\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:0:\"\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:12:\"autocomplete\";s:10:\"given-name\";}i:1;a:69:{s:2:\"id\";i:1;s:3:\"key\";s:18:\"shipping_last_name\";s:4:\"name\";s:9:\"last_name\";s:4:\"type\";s:4:\"text\";s:8:\"disabled\";b:1;s:5:\"order\";i:2;s:8:\"priority\";i:20;s:5:\"label\";s:23:\"نام خانوادگی\";s:11:\"placeholder\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:13:\"form-row-last\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-last\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:0:\"\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:12:\"autocomplete\";s:11:\"family-name\";}i:2;a:69:{s:2:\"id\";i:2;s:3:\"key\";s:16:\"shipping_company\";s:4:\"name\";s:7:\"company\";s:4:\"type\";s:4:\"text\";s:8:\"disabled\";b:1;s:5:\"order\";i:3;s:8:\"priority\";i:30;s:5:\"label\";s:15:\"نام شرکت\";s:11:\"placeholder\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:0:\"\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:12:\"autocomplete\";s:12:\"organization\";}i:3;a:69:{s:2:\"id\";i:3;s:3:\"key\";s:16:\"shipping_country\";s:4:\"name\";s:7:\"country\";s:4:\"type\";s:7:\"country\";s:8:\"disabled\";b:1;s:5:\"order\";i:4;s:8:\"priority\";i:40;s:5:\"label\";s:21:\"کشور / منطقه\";s:11:\"placeholder\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:3:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";i:2;s:23:\"update_totals_on_change\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:0:\"\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:12:\"autocomplete\";s:7:\"country\";}i:4;a:69:{s:2:\"id\";i:4;s:3:\"key\";s:18:\"shipping_address_1\";s:4:\"name\";s:9:\"address_1\";s:4:\"type\";s:4:\"text\";s:8:\"disabled\";b:1;s:5:\"order\";i:5;s:8:\"priority\";i:50;s:5:\"label\";s:21:\"آدرس خیابان\";s:11:\"placeholder\";s:40:\"نام خیابان و پلاک خانه\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:0:\"\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:12:\"autocomplete\";s:13:\"address-line1\";}i:5;a:69:{s:2:\"id\";i:5;s:3:\"key\";s:18:\"shipping_address_2\";s:4:\"name\";s:9:\"address_2\";s:4:\"type\";s:4:\"text\";s:8:\"disabled\";b:1;s:5:\"order\";i:6;s:8:\"priority\";i:60;s:5:\"label\";s:0:\"\";s:11:\"placeholder\";s:63:\"آپارتمان، مجتمع، واحد و... (اختیاری)\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:0:\"\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:12:\"autocomplete\";s:13:\"address-line2\";}i:6;a:69:{s:2:\"id\";i:6;s:3:\"key\";s:13:\"shipping_city\";s:4:\"name\";s:4:\"city\";s:4:\"type\";s:4:\"text\";s:8:\"disabled\";b:1;s:5:\"order\";i:7;s:8:\"priority\";i:70;s:5:\"label\";s:6:\"شهر\";s:11:\"placeholder\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:0:\"\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:12:\"autocomplete\";s:14:\"address-level2\";}i:7;a:71:{s:2:\"id\";i:7;s:3:\"key\";s:14:\"shipping_state\";s:4:\"name\";s:5:\"state\";s:4:\"type\";s:5:\"state\";s:8:\"disabled\";b:1;s:5:\"order\";i:8;s:8:\"priority\";i:80;s:5:\"label\";s:10:\"استان\";s:11:\"placeholder\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:2:\"IR\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:8:\"validate\";a:1:{i:0;s:5:\"state\";}s:12:\"autocomplete\";s:14:\"address-level1\";s:13:\"country_field\";s:16:\"shipping_country\";}i:8;a:70:{s:2:\"id\";i:8;s:3:\"key\";s:17:\"shipping_postcode\";s:4:\"name\";s:8:\"postcode\";s:4:\"type\";s:4:\"text\";s:8:\"disabled\";b:1;s:5:\"order\";i:9;s:8:\"priority\";i:90;s:5:\"label\";s:13:\"کد پستی\";s:11:\"placeholder\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:5:\"clear\";b:0;s:7:\"options\";a:1:{i:0;a:6:{s:5:\"label\";s:6:\"Option\";s:15:\"add_price_total\";i:0;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";i:0;s:7:\"default\";s:0:\"\";s:5:\"order\";i:0;}}s:8:\"required\";b:0;s:12:\"message_type\";s:4:\"info\";s:11:\"button_type\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:9:\"maxlength\";N;s:17:\"show_cart_minimum\";i:0;s:17:\"show_cart_maximun\";i:0;s:9:\"show_role\";a:0:{}s:9:\"hide_role\";a:0:{}s:12:\"more_product\";b:0;s:12:\"show_product\";a:0:{}s:12:\"hide_product\";a:0:{}s:16:\"show_product_cat\";a:0:{}s:16:\"hide_product_cat\";a:0:{}s:12:\"hide_account\";b:0;s:13:\"hide_checkout\";b:0;s:10:\"hide_email\";b:0;s:10:\"hide_order\";b:0;s:12:\"hide_invoice\";b:0;s:16:\"time_format_ampm\";b:1;s:16:\"time_limit_start\";N;s:14:\"time_limit_end\";N;s:19:\"time_limit_interval\";N;s:10:\"date_limit\";s:5:\"fixed\";s:11:\"date_format\";s:0:\"\";s:23:\"date_limit_variable_min\";i:-1;s:23:\"date_limit_variable_max\";i:1;s:20:\"date_limit_fixed_min\";s:10:\"2021-04-30\";s:20:\"date_limit_fixed_max\";s:10:\"2021-04-30\";s:15:\"date_limit_days\";a:0:{}s:9:\"add_price\";b:0;s:14:\"add_price_name\";s:0:\"\";s:15:\"add_price_total\";N;s:14:\"add_price_type\";s:5:\"fixed\";s:13:\"add_price_tax\";b:0;s:11:\"extra_class\";s:0:\"\";s:11:\"conditional\";b:0;s:22:\"conditional_parent_key\";s:0:\"\";s:24:\"conditional_parent_value\";s:0:\"\";s:7:\"country\";s:0:\"\";s:7:\"select2\";b:0;s:18:\"select2_allowclear\";b:0;s:21:\"select2_selectonclose\";b:0;s:21:\"select2_closeonselect\";b:0;s:14:\"select2_search\";b:0;s:10:\"file_limit\";i:1;s:10:\"file_types\";a:0:{}s:10:\"pickertype\";s:0:\"\";s:8:\"listable\";b:0;s:8:\"sortable\";b:0;s:10:\"filterable\";b:0;s:3:\"max\";s:0:\"\";s:3:\"min\";s:0:\"\";s:8:\"validate\";a:1:{i:0;s:8:\"postcode\";}s:12:\"autocomplete\";s:11:\"postal-code\";}}", "yes");
INSERT INTO `wp_options` VALUES("47445", "qlwcdc_wcd_imported2", "1", "yes");
INSERT INTO `wp_options` VALUES("47448", "qlwcdc_add_to_cart", "redirect", "yes");
INSERT INTO `wp_options` VALUES("79372", "amlak_set_user_digits_3111370", "1", "yes");
INSERT INTO `wp_options` VALUES("50763", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `wp_options` VALUES("55448", "acf-pgf-dnt-show-msg", "no", "yes");
INSERT INTO `wp_options` VALUES("80133", "iranAmlak_settings", "3cab4ddc1c43dc9415fe21c857818e21", "yes");
INSERT INTO `wp_options` VALUES("74204", "dig_preset", "1", "yes");
INSERT INTO `wp_options` VALUES("74205", "login_page_footer", "", "yes");
INSERT INTO `wp_options` VALUES("74206", "login_page_footer_text_color", "rgba(255,255,255,1)", "yes");
INSERT INTO `wp_options` VALUES("74978", "_prefix_my_options", "a:105:{s:7:\"favicon\";a:8:{s:3:\"url\";s:61:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/icon.png\";s:2:\"id\";s:4:\"5271\";s:5:\"width\";s:2:\"50\";s:6:\"height\";s:2:\"46\";s:9:\"thumbnail\";s:61:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/icon.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:4:\"icon\";s:11:\"description\";s:0:\"\";}s:5:\"logos\";a:8:{s:3:\"url\";s:62:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/logo3.png\";s:2:\"id\";s:4:\"2848\";s:5:\"width\";s:3:\"180\";s:6:\"height\";s:2:\"75\";s:9:\"thumbnail\";s:69:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/logo3-150x75.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:5:\"logo3\";s:11:\"description\";s:0:\"\";}s:9:\"tell-head\";s:11:\"09112921876\";s:9:\"nav_color\";s:7:\"#ffffff\";s:8:\"sabtmelk\";s:1:\"1\";s:13:\"dokmesabtmelk\";s:26:\"ثبت رایگان ملک\";s:12:\"form_tagahza\";s:1:\"1\";s:17:\"dokmeform_tagahza\";s:26:\"ثبت تقاضای ملک\";s:21:\"payam-sefareshi-onoff\";s:1:\"0\";s:15:\"payam-sefareshi\";s:0:\"\";s:11:\"shoar-onoff\";s:1:\"1\";s:5:\"shoar\";s:119:\"ایران املاک ، مشاور شما در خرید و فروش ، رهن و اجاره و اجاره روزانه\";s:10:\"index_tops\";a:9:{s:16:\"background-color\";s:7:\"#009e44\";s:16:\"background-image\";a:8:{s:3:\"url\";s:63:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/dfgd-1.jpg\";s:2:\"id\";s:1:\"9\";s:5:\"width\";s:4:\"1280\";s:6:\"height\";s:3:\"742\";s:9:\"thumbnail\";s:71:\"https://sitralweb.com/ir3/wp-content/uploads/2020/05/dfgd-1-150x150.jpg\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:6:\"dfgd-1\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:13:\"center center\";s:17:\"background-repeat\";s:8:\"repeat-x\";s:21:\"background-attachment\";s:5:\"fixed\";s:15:\"background-size\";s:5:\"cover\";s:17:\"background-origin\";s:10:\"border-box\";s:15:\"background-clip\";s:11:\"padding-box\";s:21:\"background-blend-mode\";s:6:\"normal\";}s:11:\"links_index\";a:4:{i:0;a:3:{s:5:\"title\";s:27:\" ویلا های فروشی\";s:11:\"description\";s:39:\"تمامی ویلا های فروشی\r\n\";s:4:\"link\";a:3:{s:3:\"url\";s:84:\"https://sitralweb.com/ir3/جستجو/?moamele=خرید+و+فروش&amp;melk=ویلا\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}i:1;a:3:{s:5:\"title\";s:32:\"املاک در مازندران\";s:11:\"description\";s:54:\"تمامی املاک فروشی در مازندران\";s:4:\"link\";a:3:{s:3:\"url\";s:93:\"https://sitralweb.com/ir3/جستجو/?moamele=خرید+و+فروش&amp;ostan=مازندران\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}i:2;a:3:{s:5:\"title\";s:21:\"املاک ساحلی\";s:11:\"description\";s:50:\"تمامی املاک با موقعیت ساحلی\";s:4:\"link\";a:3:{s:3:\"url\";s:79:\"https://sitralweb.com/ir3/جستجو/?moamele=خرید+و+فروش&amp;saheli=1\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}i:3;a:3:{s:5:\"title\";s:25:\"املاک کوهپایه\";s:11:\"description\";s:54:\"تمامی املاک با موقعیت کوهپایه\";s:4:\"link\";a:3:{s:3:\"url\";s:80:\"https://sitralweb.com/ir3/جستجو/?moamele=خرید+و+فروش&amp;kohpaye=1\";s:4:\"text\";s:0:\"\";s:6:\"target\";s:0:\"\";}}}s:12:\"states_index\";a:2:{i:0;a:15:{s:5:\"title\";s:30:\"املاک ویژه فروشی\";s:11:\"description\";s:81:\"آخرین املاک ثبت شده فروشی ویژه ما را ببینید ..\";s:7:\"moamele\";s:20:\"خرید و فروش\";s:4:\"melk\";s:0:\"\";s:5:\"vijhe\";s:1:\"1\";s:4:\"fast\";s:0:\"\";s:10:\"mosharekat\";s:0:\"\";s:7:\"moaveze\";s:0:\"\";s:10:\"pishforosh\";s:0:\"\";s:7:\"kohpaye\";s:0:\"\";s:6:\"saheli\";s:0:\"\";s:8:\"shahraki\";s:0:\"\";s:10:\"amlak_home\";s:0:\"\";s:17:\"amlak_number_home\";s:1:\"3\";s:9:\"news_home\";s:0:\"\";}i:1;a:15:{s:5:\"title\";s:31:\"املاک رهن و اجاره\";s:11:\"description\";s:82:\"آخرین املاک ثبت شده رهن و اجاره ما را ببینید ..\";s:7:\"moamele\";s:20:\"رهن و اجاره\";s:4:\"melk\";s:0:\"\";s:5:\"vijhe\";s:0:\"\";s:4:\"fast\";s:0:\"\";s:10:\"mosharekat\";s:0:\"\";s:7:\"moaveze\";s:0:\"\";s:10:\"pishforosh\";s:0:\"\";s:7:\"kohpaye\";s:0:\"\";s:6:\"saheli\";s:0:\"\";s:8:\"shahraki\";s:0:\"\";s:10:\"amlak_home\";s:0:\"\";s:17:\"amlak_number_home\";s:1:\"3\";s:9:\"news_home\";s:0:\"\";}}s:15:\"adminuserselect\";s:1:\"1\";s:7:\"faaliat\";a:3:{i:0;s:20:\"خرید و فروش\";i:1;s:20:\"رهن و اجاره\";i:2;s:23:\"اجاره روزانه\";}s:11:\"theme_color\";s:7:\"#0d3751\";s:13:\"theme_color_2\";s:7:\"#008cd8\";s:5:\"ls_no\";s:2:\"pb\";s:4:\"font\";s:7:\"B yekan\";s:18:\"select-page-search\";s:2:\"25\";s:20:\"select-page-moshaver\";s:2:\"39\";s:16:\"select-page-blog\";s:4:\"3247\";s:22:\"select-page-faviorites\";s:2:\"34\";s:19:\"select-page-send-ad\";s:2:\"19\";s:15:\"select-page-ads\";s:2:\"15\";s:19:\"select-page-tagahza\";s:4:\"4883\";s:14:\"select-page-me\";s:2:\"12\";s:17:\"select-page-login\";s:2:\"41\";s:20:\"select-page-register\";s:2:\"23\";s:23:\"page-login-netofication\";s:0:\"\";s:22:\"select-page-forgetpass\";s:2:\"37\";s:23:\"select-page-editprofile\";s:2:\"21\";s:10:\"javascript\";s:0:\"\";s:3:\"css\";s:0:\"\";s:13:\"melkid_search\";s:1:\"1\";s:13:\"nomelk_search\";s:1:\"1\";s:12:\"otagh_search\";s:1:\"1\";s:14:\"metrazh_search\";s:1:\"1\";s:14:\"gheymat_search\";s:1:\"1\";s:11:\"rahn_search\";s:1:\"1\";s:12:\"ejare_search\";s:1:\"1\";s:17:\"ejareshabi_search\";s:1:\"1\";s:14:\"senbana_search\";s:1:\"1\";s:14:\"asansor_search\";s:1:\"1\";s:14:\"parking_search\";s:1:\"1\";s:17:\"pishforosh_search\";s:1:\"1\";s:17:\"mosharekat_search\";s:1:\"1\";s:14:\"emkanat_search\";s:1:\"1\";s:15:\"manateghdelkhah\";s:1:\"1\";s:7:\"ostanha\";a:1:{i:0;s:16:\"مازندران\";}s:11:\"nopicsingle\";s:0:\"\";s:14:\"monghazi_color\";s:7:\"#ff0000\";s:11:\"vijhe_color\";s:7:\"#ff0000\";s:12:\"pishmo_color\";s:7:\"#008af5\";s:16:\"mosharekat_color\";s:7:\"#00ad3d\";s:12:\"nomelk_color\";s:7:\"#008af5\";s:15:\"nomoamele_color\";s:7:\"#ff0000\";s:13:\"autoexpireing\";s:1:\"0\";s:15:\"timecantoexpire\";s:1:\"0\";s:12:\"expiredposts\";s:1:\"0\";s:13:\"autodeleteing\";s:1:\"0\";s:15:\"timecantodelete\";s:1:\"0\";s:12:\"gheymatmetri\";s:0:\"\";s:11:\"ads_special\";s:1:\"1\";s:13:\"form_moshaver\";s:1:\"1\";s:8:\"telmalek\";s:1:\"0\";s:10:\"addresmelk\";s:1:\"0\";s:8:\"nammalek\";s:1:\"0\";s:10:\"emailmalek\";s:1:\"0\";s:8:\"location\";s:1:\"0\";s:8:\"enteshar\";s:7:\"publish\";s:15:\"enteshar-edited\";s:7:\"publish\";s:18:\"sokonat_sendestate\";s:1:\"0\";s:15:\"nama_sendestate\";s:1:\"0\";s:19:\"kabinaet_sendestate\";s:1:\"0\";s:18:\"kafposh_sendestate\";s:1:\"0\";s:13:\"mg_sendestate\";s:1:\"0\";s:17:\"saheli_sendestate\";s:1:\"0\";s:19:\"shahraki_sendestate\";s:1:\"0\";s:18:\"kohpaye_sendestate\";s:1:\"0\";s:14:\"map_sendestate\";s:1:\"0\";s:16:\"video_sendestate\";s:1:\"0\";s:16:\"sanad_sendestate\";s:1:\"0\";s:16:\"hamam_sendestate\";s:1:\"0\";s:13:\"wc_sendestate\";s:1:\"0\";s:16:\"email_sendestate\";s:1:\"0\";s:7:\"freeadd\";s:1:\"1\";s:16:\"add-free-sending\";s:1:\"5\";s:11:\"add-sending\";s:4:\"2000\";s:16:\"iranamlak-offers\";a:2:{i:0;a:4:{s:5:\"title\";s:23:\"پکیج مشاوران\";s:11:\"description\";s:61:\"توضیحات پکیج در اینجا درج میگردد .\";s:5:\"tedad\";s:2:\"15\";s:5:\"price\";s:5:\"15000\";}i:1;a:4:{s:5:\"title\";s:19:\"پکیج طلایی\";s:11:\"description\";s:90:\"تست توضیحات در اینجا برای پکیج طلایی قرار میگیرد .\";s:5:\"tedad\";s:2:\"50\";s:5:\"price\";s:5:\"50000\";}}s:10:\"dargahbank\";s:0:\"\";s:7:\"address\";s:0:\"\";s:5:\"email\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:8:\"mobile-2\";s:0:\"\";s:4:\"tell\";s:0:\"\";s:12:\"social-links\";s:0:\"\";s:17:\"title-box2-footer\";s:0:\"\";s:10:\"box2footer\";s:0:\"\";s:17:\"title-box3-footer\";s:0:\"\";s:10:\"box3footer\";s:0:\"\";s:9:\"copyright\";s:78:\" حقوق این قالب متعلق به ایران املاک می باشد \";s:11:\"cpsitralweb\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("87512", "wfu_queue_bTT9SX4J1p_count", "2", "yes");
INSERT INTO `wp_options` VALUES("82934", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("74147", "dig_bill_merge_phone", "0", "yes");
INSERT INTO `wp_options` VALUES("80526", "image_watermark_version", "1.7.0", "no");
INSERT INTO `wp_options` VALUES("74150", "dig_one_click_login_signup_third_party_actions", "0", "yes");
INSERT INTO `wp_options` VALUES("74484", "puc_external_updates_theme-iranamlak", "O:8:\"stdClass\":2:{s:9:\"lastCheck\";i:1672679446;s:14:\"checkedVersion\";s:3:\"7.1\";}", "no");
INSERT INTO `wp_options` VALUES("70157", "wpsh_pro_license_status", "0", "yes");
INSERT INTO `wp_options` VALUES("65337", "woocommerce_refund_returns_page_id", "5086", "yes");
INSERT INTO `wp_options` VALUES("80548", "image_watermark_options", "a:5:{s:15:\"watermark_image\";a:17:{s:10:\"plugin_off\";b:1;s:19:\"manual_watermarking\";b:1;s:9:\"extension\";s:0:\"\";s:15:\"frontend_active\";b:0;s:19:\"deactivation_delete\";b:0;s:8:\"position\";s:11:\"bottom_left\";s:11:\"offset_unit\";s:6:\"pixels\";s:12:\"offset_width\";i:15;s:13:\"offset_height\";i:15;s:3:\"url\";i:0;s:19:\"watermark_size_type\";i:0;s:14:\"absolute_width\";i:0;s:15:\"absolute_height\";i:0;s:5:\"width\";i:100;s:11:\"transparent\";i:50;s:7:\"quality\";i:100;s:11:\"jpeg_format\";s:8:\"baseline\";}s:12:\"watermark_on\";a:2:{s:11:\"img-370-250\";i:1;s:6:\"medium\";i:1;}s:16:\"watermark_cpt_on\";a:1:{s:5:\"state\";i:1;}s:16:\"image_protection\";a:3:{s:10:\"rightclick\";i:0;s:11:\"draganddrop\";i:0;s:9:\"forlogged\";i:0;}s:6:\"backup\";a:2:{s:12:\"backup_image\";b:1;s:14:\"backup_quality\";i:100;}}", "no");
INSERT INTO `wp_options` VALUES("80278", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("83413", "acfe", "a:2:{s:7:\"version\";s:7:\"0.8.8.7\";s:7:\"modules\";a:4:{s:11:\"block_types\";a:0:{}s:13:\"options_pages\";a:0:{}s:10:\"post_types\";a:0:{}s:10:\"taxonomies\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("87495", "wfu_environment_variables", "a:1:{s:22:\"WFU_US_HANDLER_CHANGED\";s:4:\"true\";}", "yes");
INSERT INTO `wp_options` VALUES("87496", "wordpress_file_upload_table_log_version", "4.0", "yes");
INSERT INTO `wp_options` VALUES("87497", "wordpress_file_upload_table_userdata_version", "1.0", "yes");
INSERT INTO `wp_options` VALUES("87498", "wordpress_file_upload_table_dbxqueue_version", "1.0", "yes");
INSERT INTO `wp_options` VALUES("87499", "widget_wordpress_file_upload_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("87500", "wordpress_file_upload_last_idlog", "a:3:{s:3:\"pre\";N;s:4:\"post\";N;s:4:\"time\";i:1653162274;}", "yes");
INSERT INTO `wp_options` VALUES("87501", "wfu_userstate_list", "7b22746e6a6a736e6d713473773833316b636b6c737770796e6378646d7474676771223a313635333136323433337d", "yes");
INSERT INTO `wp_options` VALUES("87502", "wfu_userstate_tnjjsnmq4sw831kcklswpyncxdmttggq", "[wfu_browser_actions_safe_storage]7b226a6b774e4b466e4b4274744562454837223a227766755f75706c6f616465645f66696c6573267461673d31222c227761424151677039336e6162656d455a223a226e6f5f72656665726572222c2251673754453233786a616d5a624b3951223a227766755f75706c6f616465645f66696c6573267461673d31222c2239386a366b345858417a73635a466266223a226e6f5f72656665726572227d{wfu_browser_actions_safe_storage}[wfu_add_shortcode_ticket_for_wordpress_file_upload]22654746465846356a31414162715a537122{wfu_add_shortcode_ticket_for_wordpress_file_upload}[wfu_filepath_safe_storage]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{wfu_filepath_safe_storage}[wfu_token_1]223136303933373336393936323839343134653564656631352e373832383736333922{wfu_token_1}[wfu_check_refresh_1]22646f206e6f742070726f6365737322{wfu_check_refresh_1}[wfu_shortcode_data_safe_storage]7b22705a4850395164514761584678436e32223a2237623232373036663733373435663639363432323361333233333332326332323730366637333734356636383631373336383232336132323332333333313634363236313330333933323331333133323635333136333336333433363330363633373634363136313330333736323635333933353634333232323263323237333638366637323734363336663634363532323361323235623737366637323634373037323635373337333566363636393663363535663735373036633666363136343564323232633232373036663733363937343639366636653232336133393332333933383764222c223633454151627061444f62664c417a74223a2237623232373036663733373435663639363432323361333233333332326332323730366637333734356636383631373336383232336132323332333333313634363236313330333933323331333133323635333136333336333433363330363633373634363136313330333736323635333933353634333232323263323237333638366637323734363336663634363532323361323235623737366637323634373037323635373337333566363636393663363535663735373036633666363136343564323232633232373036663733363937343639366636653232336133393332333933383764227d{wfu_shortcode_data_safe_storage}[wfu_uploadstatus_bTT9SX4J1p]31{wfu_uploadstatus_bTT9SX4J1p}[wfu_upload_first_pass_bTT9SX4J1p]227472756522{wfu_upload_first_pass_bTT9SX4J1p}[filedata_bTT9SX4J1p]5b7b2266696c655f756e697175655f6964223a223843734b574d353835645a487339726361626d32222c226f726967696e616c5f66696c656e616d65223a2253637265656e73686f7420323032322d30352d31392061742031332d30332d3239205c75303633345c75303634365c75303632375c75303633335c75303634365c75303632375c75303634355c75303634372e706e67222c2266696c6573697a65223a223632333436222c2266696c6570617468223a225c2f686f6d655c2f796f75736566616d696e695c2f7075626c69635f68746d6c5c2f6972616e616d6c616b5c2f77702d636f6e74656e745c2f75706c6f6164735c2f53637265656e73686f742d323032322d30352d31392d61742d31332d30332d32392d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2e706e67222c22757365725f64617461223a5b5d2c2275706c6f61645f726573756c74223a2273756363657373222c226d657373616765223a22222c2261646d696e5f6d65737361676573223a22227d5d{filedata_bTT9SX4J1p}[filedata_bTT9SX4J1p_0]7b2266696c655f756e697175655f6964223a223843734b574d353835645a487339726361626d32222c2266696c6570617468223a225c2f686f6d655c2f796f75736566616d696e695c2f7075626c69635f68746d6c5c2f6972616e616d6c616b5c2f77702d636f6e74656e745c2f75706c6f6164735c2f53637265656e73686f742d323032322d30352d31392d61742d31332d30332d32392d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2e706e67222c227573657264617461223a5b5d7d{filedata_bTT9SX4J1p_0}[wfu_start_time_1]223136353331363234333139373722{wfu_start_time_1}[wfu_uploadstatus_arulWy8AHi]31{wfu_uploadstatus_arulWy8AHi}[filedata_arulWy8AHi]5b7b2266696c655f756e697175655f6964223a224c70335a5a4c436b4f393679473357427a59526b222c226f726967696e616c5f66696c656e616d65223a2273756e666c6f77722e6a7067222c2266696c6573697a65223a373433332c2266696c6570617468223a225c2f686f6d655c2f796f75736566616d696e695c2f7075626c69635f68746d6c5c2f6972616e616d6c616b5c2f77702d636f6e74656e745c2f75706c6f6164735c2f73756e666c6f77722e6a7067222c22757365725f64617461223a5b5d2c2275706c6f61645f726573756c74223a2273756363657373222c226d657373616765223a22222c2261646d696e5f6d65737361676573223a22227d5d{filedata_arulWy8AHi}[filedata_arulWy8AHi_0]225c2f22{filedata_arulWy8AHi_0}", "yes");
INSERT INTO `wp_options` VALUES("87503", "wfu_userstate_list_last_check", "31363533313632313131", "yes");
INSERT INTO `wp_options` VALUES("87509", "wfu_params_index", "DybPgZh4GQxhwf8T||232||1||iranamlak", "yes");
INSERT INTO `wp_options` VALUES("87510", "wfu_params_DybPgZh4GQxhwf8T", "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", "yes");
INSERT INTO `wp_options` VALUES("110994", "_site_transient_timeout_php_check_d0f8c44ddd5901bff1588223538812e8", "1694932351", "no");
INSERT INTO `wp_options` VALUES("110995", "_site_transient_php_check_d0f8c44ddd5901bff1588223538812e8", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("110999", "check_am_req_mx", "1", "yes");
INSERT INTO `wp_options` VALUES("110457", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":5,\"critical\":0}", "yes");
INSERT INTO `wp_options` VALUES("104624", "auto_update_themes", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107998", "theme_mods_twentytwentythree", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1670668968;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("110482", "duplicator_activated", "a:1:{s:4:\"lite\";i:1677361069;}", "yes");
INSERT INTO `wp_options` VALUES("110831", "is_front_state_send_1", "1", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3", "5", "wppb-ul-templates", "");
INSERT INTO `wp_postmeta` VALUES("4", "5", "wppb-single-ul-templates", "");
INSERT INTO `wp_postmeta` VALUES("5", "5", "wppb_ul_page_settings", "a:1:{i:0;a:6:{s:16:\"roles-to-display\";s:1:\"*\";s:19:\"number-of-userspage\";s:1:\"5\";s:24:\"default-sorting-criteria\";s:5:\"login\";s:21:\"default-sorting-order\";s:3:\"asc\";s:27:\"avatar-size-all-userlisting\";s:2:\"40\";s:30:\"avatar-size-single-userlisting\";s:2:\"60\";}}");
INSERT INTO `wp_postmeta` VALUES("6", "2", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("7", "2", "_edit_lock", "1668939001:1");
INSERT INTO `wp_postmeta` VALUES("12", "3", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("13", "3", "_edit_lock", "1590825169:1");
INSERT INTO `wp_postmeta` VALUES("14", "12", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("15", "12", "_edit_lock", "1653723526:1");
INSERT INTO `wp_postmeta` VALUES("16", "12", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("17", "12", "sharing_disabled", "1");
INSERT INTO `wp_postmeta` VALUES("18", "12", "description", "");
INSERT INTO `wp_postmeta` VALUES("19", "12", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20", "13", "description", "");
INSERT INTO `wp_postmeta` VALUES("21", "13", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("29", "17", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("30", "17", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("31", "17", "description", "");
INSERT INTO `wp_postmeta` VALUES("32", "17", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("33", "18", "description", "");
INSERT INTO `wp_postmeta` VALUES("34", "18", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("35", "17", "_edit_lock", "1656417076:1");
INSERT INTO `wp_postmeta` VALUES("36", "19", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("37", "19", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("38", "19", "description", "");
INSERT INTO `wp_postmeta` VALUES("39", "19", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("40", "20", "description", "");
INSERT INTO `wp_postmeta` VALUES("41", "20", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("42", "19", "_edit_lock", "1651092254:1");
INSERT INTO `wp_postmeta` VALUES("43", "21", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("44", "21", "_edit_lock", "1653723497:1");
INSERT INTO `wp_postmeta` VALUES("45", "21", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("46", "21", "description", "");
INSERT INTO `wp_postmeta` VALUES("47", "21", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("48", "22", "description", "");
INSERT INTO `wp_postmeta` VALUES("49", "22", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27689", "6530", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27690", "6530", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27642", "6525", "_menu_item_object_id", "6525");
INSERT INTO `wp_postmeta` VALUES("57", "25", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("58", "25", "_edit_lock", "1653766081:1");
INSERT INTO `wp_postmeta` VALUES("59", "25", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("60", "25", "description", "");
INSERT INTO `wp_postmeta` VALUES("61", "25", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("62", "26", "description", "");
INSERT INTO `wp_postmeta` VALUES("63", "26", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("64", "27", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("65", "27", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("66", "27", "description", "");
INSERT INTO `wp_postmeta` VALUES("67", "27", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("68", "28", "description", "");
INSERT INTO `wp_postmeta` VALUES("69", "28", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("70", "27", "_edit_lock", "1656417021:1");
INSERT INTO `wp_postmeta` VALUES("77", "33", "description", "");
INSERT INTO `wp_postmeta` VALUES("78", "33", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("79", "34", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("80", "34", "_edit_lock", "1649187503:1");
INSERT INTO `wp_postmeta` VALUES("81", "34", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("82", "34", "description", "");
INSERT INTO `wp_postmeta` VALUES("83", "34", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("84", "35", "description", "");
INSERT INTO `wp_postmeta` VALUES("85", "35", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("93", "39", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("94", "39", "_edit_lock", "1649187562:1");
INSERT INTO `wp_postmeta` VALUES("95", "39", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("96", "39", "description", "");
INSERT INTO `wp_postmeta` VALUES("97", "39", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("98", "40", "description", "");
INSERT INTO `wp_postmeta` VALUES("99", "40", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("100", "41", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("101", "41", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("102", "41", "description", "");
INSERT INTO `wp_postmeta` VALUES("103", "41", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("104", "42", "description", "");
INSERT INTO `wp_postmeta` VALUES("105", "42", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("106", "41", "_edit_lock", "1690642295:1");
INSERT INTO `wp_postmeta` VALUES("119", "46", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("120", "46", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("121", "46", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("122", "46", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("123", "46", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("124", "46", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("125", "46", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("126", "46", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("247", "212", "masahat-zamin", "300");
INSERT INTO `wp_postmeta` VALUES("26572", "6446", "_onvan", "field_6276deb38a223");
INSERT INTO `wp_postmeta` VALUES("26571", "6446", "onvan", "ویلاباغ شهرکی استخردار نوشهر");
INSERT INTO `wp_postmeta` VALUES("23038", "6118", "_wp_attached_file", "2022/04/backsearch.jpg");
INSERT INTO `wp_postmeta` VALUES("146", "49", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("147", "49", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("148", "49", "_menu_item_object_id", "17");
INSERT INTO `wp_postmeta` VALUES("149", "49", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("150", "49", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("151", "49", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("152", "49", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("153", "49", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("8730", "1896", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("8731", "1896", "mosharekat", "1");
INSERT INTO `wp_postmeta` VALUES("8732", "1896", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("8734", "1896", "_tahvil", "field_5eef05ad461c0");
INSERT INTO `wp_postmeta` VALUES("8733", "1896", "tahvil", "");
INSERT INTO `wp_postmeta` VALUES("8729", "1896", "mantaghe", "1388");
INSERT INTO `wp_postmeta` VALUES("7917", "2288", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7918", "2288", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7919", "1896", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("7920", "1896", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("7921", "1896", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7922", "1896", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7923", "300", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("7924", "300", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("7925", "300", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7926", "300", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7927", "300", "tahvil", "1400/06/01");
INSERT INTO `wp_postmeta` VALUES("7928", "300", "_tahvil", "field_5eef05ad461c0");
INSERT INTO `wp_postmeta` VALUES("7929", "305", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("7930", "305", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("7931", "305", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7932", "305", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("191", "54", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("192", "54", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("193", "54", "_menu_item_object_id", "27");
INSERT INTO `wp_postmeta` VALUES("194", "54", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("195", "54", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("196", "54", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("197", "54", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("198", "54", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1919", "1995", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:719;s:6:\"height\";i:405;s:4:\"file\";s:45:\"2018/11/35ef17ff11e54f75ba0218445aa74c0c.jpeg\";s:5:\"sizes\";a:9:{s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"35ef17ff11e54f75ba0218445aa74c0c-300x169.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"35ef17ff11e54f75ba0218445aa74c0c-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:45:\"35ef17ff11e54f75ba0218445aa74c0c-370x250.jpeg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:43:\"35ef17ff11e54f75ba0218445aa74c0c-76x61.jpeg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:45:\"35ef17ff11e54f75ba0218445aa74c0c-262x190.jpeg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:45:\"35ef17ff11e54f75ba0218445aa74c0c-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:45:\"35ef17ff11e54f75ba0218445aa74c0c-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:45:\"35ef17ff11e54f75ba0218445aa74c0c-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:45:\"35ef17ff11e54f75ba0218445aa74c0c-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("7934", "305", "_tabdil", "field_5ee4c5caef41f");
INSERT INTO `wp_postmeta` VALUES("7935", "305", "tahol", "خانواده و مجرد");
INSERT INTO `wp_postmeta` VALUES("7933", "305", "tabdil", "ندارد");
INSERT INTO `wp_postmeta` VALUES("7205", "3249", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("7204", "3249", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("7203", "3249", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("7202", "3249", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("7201", "3249", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("7200", "3249", "_menu_item_object_id", "3247");
INSERT INTO `wp_postmeta` VALUES("7199", "3249", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("7198", "3249", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("7197", "3248", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("7196", "3248", "description", "");
INSERT INTO `wp_postmeta` VALUES("27694", "6531", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27692", "6530", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=خرید+و+فروش&ostan=&melk=خانه+و+ویلا&emkanat%5B%5D=استخر");
INSERT INTO `wp_postmeta` VALUES("27691", "6530", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("7195", "3247", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("7194", "3247", "description", "");
INSERT INTO `wp_postmeta` VALUES("7193", "3247", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("7191", "3247", "_edit_lock", "1669531160:1");
INSERT INTO `wp_postmeta` VALUES("7192", "3247", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("27688", "6530", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27687", "6530", "_menu_item_object_id", "6530");
INSERT INTO `wp_postmeta` VALUES("27686", "6530", "_menu_item_menu_item_parent", "6528");
INSERT INTO `wp_postmeta` VALUES("27685", "6530", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("248", "212", "description", "");
INSERT INTO `wp_postmeta` VALUES("249", "212", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("250", "212", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("251", "212", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("252", "212", "special", "0");
INSERT INTO `wp_postmeta` VALUES("253", "212", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("254", "212", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("255", "212", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("256", "212", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("257", "212", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("258", "212", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("259", "212", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("260", "212", "okasion", "0");
INSERT INTO `wp_postmeta` VALUES("261", "212", "_okasion", "field_5be01d6c83774");
INSERT INTO `wp_postmeta` VALUES("262", "212", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("263", "212", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("264", "212", "hektari", "0");
INSERT INTO `wp_postmeta` VALUES("265", "212", "_hektari", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("266", "212", "name", "دکتر امانی");
INSERT INTO `wp_postmeta` VALUES("267", "212", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("268", "212", "address", "بلوار 20 متری ، جنب غربی ۱۵");
INSERT INTO `wp_postmeta` VALUES("269", "212", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("270", "212", "mobile", "01155222569");
INSERT INTO `wp_postmeta` VALUES("271", "212", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("272", "212", "email", "");
INSERT INTO `wp_postmeta` VALUES("273", "212", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("274", "212", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("275", "212", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("276", "212", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("277", "212", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("278", "212", "ostan", "تهران");
INSERT INTO `wp_postmeta` VALUES("279", "212", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("280", "212", "shahr", "پیشوا");
INSERT INTO `wp_postmeta` VALUES("281", "212", "_shahr", "field_5be2b7acddc6d");
INSERT INTO `wp_postmeta` VALUES("282", "212", "metrazh", "150");
INSERT INTO `wp_postmeta` VALUES("283", "212", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("284", "212", "mg", "a:3:{i:0;s:10:\"شمالی\";i:1;s:8:\"شرقی\";i:2;s:10:\"جنوبی\";}");
INSERT INTO `wp_postmeta` VALUES("285", "212", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("286", "212", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("287", "212", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("288", "212", "nama", "چوب");
INSERT INTO `wp_postmeta` VALUES("289", "212", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("290", "212", "kabinet", "کابینت فلزی");
INSERT INTO `wp_postmeta` VALUES("291", "212", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("292", "212", "wc", "ایرانی");
INSERT INTO `wp_postmeta` VALUES("293", "212", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("294", "212", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("295", "212", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("296", "212", "sayer-emkanat", "a:9:{i:0;s:14:\"پارکینگ\";i:1;s:20:\"درب ضد سرقت\";i:2;s:12:\"شومینه\";i:3;s:8:\"پکیج\";i:4;s:10:\"استخر\";i:5;s:25:\"اینترنت مرکزی\";i:6;s:10:\"پاسیو\";i:7;s:10:\"بالکن\";i:8;s:23:\"شوتینگ زباله\";}");
INSERT INTO `wp_postmeta` VALUES("297", "212", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("298", "212", "gallery", "a:2:{i:0;s:4:\"5678\";i:1;s:4:\"2013\";}");
INSERT INTO `wp_postmeta` VALUES("299", "212", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("300", "212", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("301", "212", "price-kol", "3000000000");
INSERT INTO `wp_postmeta` VALUES("302", "212", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("303", "212", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("304", "212", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("305", "212", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("306", "212", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("307", "212", "senbana", "5 تا 10 سال");
INSERT INTO `wp_postmeta` VALUES("308", "212", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("309", "212", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("310", "212", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("311", "212", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("312", "212", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("313", "212", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("314", "212", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("315", "212", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("316", "212", "simplefavorites_count", "3");
INSERT INTO `wp_postmeta` VALUES("317", "212", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("318", "212", "streetmap", "a:7:{s:3:\"lat\";d:35.728398300000002;s:3:\"lng\";d:51.579458700000004;s:4:\"zoom\";i:15;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:39:\"فراهانی, 1658756911 Tehran, Iran\";s:13:\"default_label\";s:39:\"فراهانی, 1658756911 Tehran, Iran\";s:3:\"lat\";d:35.730418899999997;s:3:\"lng\";d:51.577892300000002;}}s:7:\"address\";s:39:\"فراهانی, 1658756911 Tehran, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("319", "212", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("320", "212", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("321", "212", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("322", "212", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("323", "212", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("324", "212", "otagh", "2");
INSERT INTO `wp_postmeta` VALUES("325", "212", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("326", "212", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("327", "212", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("328", "212", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("329", "214", "description", "ویلا اوکازیون در متل قو");
INSERT INTO `wp_postmeta` VALUES("330", "214", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("331", "214", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("332", "214", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("333", "214", "special", "1");
INSERT INTO `wp_postmeta` VALUES("334", "214", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("335", "214", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("336", "214", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("337", "214", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("338", "214", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("339", "214", "luxury", "0");
INSERT INTO `wp_postmeta` VALUES("340", "214", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("341", "214", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("342", "214", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("343", "214", "okasion", "1");
INSERT INTO `wp_postmeta` VALUES("344", "214", "_okasion", "field_5be01d6c83774");
INSERT INTO `wp_postmeta` VALUES("345", "214", "saheli", "1");
INSERT INTO `wp_postmeta` VALUES("346", "214", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("347", "214", "hektari", "0");
INSERT INTO `wp_postmeta` VALUES("348", "214", "_hektari", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("349", "214", "name", "تستی زاده");
INSERT INTO `wp_postmeta` VALUES("350", "214", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("351", "214", "address", "تست در تست در تست");
INSERT INTO `wp_postmeta` VALUES("352", "214", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("353", "214", "mobile", "09112921876");
INSERT INTO `wp_postmeta` VALUES("354", "214", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("355", "214", "email", "");
INSERT INTO `wp_postmeta` VALUES("356", "214", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("357", "214", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("358", "214", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("359", "214", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("360", "214", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("361", "214", "ostan", "مازندران");
INSERT INTO `wp_postmeta` VALUES("362", "214", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("363", "214", "shahr", "متل قو");
INSERT INTO `wp_postmeta` VALUES("364", "214", "_shahr", "field_5ae8523bb6a32");
INSERT INTO `wp_postmeta` VALUES("365", "214", "metrazh", "70");
INSERT INTO `wp_postmeta` VALUES("366", "214", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("367", "214", "masahat-zamin", "1500");
INSERT INTO `wp_postmeta` VALUES("368", "214", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("369", "214", "price-kol", "550000000");
INSERT INTO `wp_postmeta` VALUES("370", "214", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("371", "214", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("372", "214", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("373", "214", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("374", "214", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("375", "214", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("376", "214", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("377", "214", "mg", "a:3:{i:0;s:10:\"شمالی\";i:1;s:8:\"شرقی\";i:2;s:10:\"جنوبی\";}");
INSERT INTO `wp_postmeta` VALUES("378", "214", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("379", "214", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("380", "214", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("381", "214", "nama", "چوب");
INSERT INTO `wp_postmeta` VALUES("382", "214", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("383", "214", "kabinet", "کابینت چوب");
INSERT INTO `wp_postmeta` VALUES("384", "214", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("385", "214", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("386", "214", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("387", "214", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("388", "214", "sayer-emkanat", "a:9:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:12:\"انباری\";i:4;s:10:\"شوفاژ\";i:5;s:12:\"شومینه\";i:6;s:23:\"آیفون تصویری\";i:7;s:30:\"دوربین مدار بسته\";i:8;s:19:\"آنتن مرکزی\";}");
INSERT INTO `wp_postmeta` VALUES("27463", "214", "_hmd_code", "214");
INSERT INTO `wp_postmeta` VALUES("389", "214", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("390", "214", "gallery", "a:3:{i:0;s:4:\"5676\";i:1;s:4:\"2013\";i:2;s:4:\"4682\";}");
INSERT INTO `wp_postmeta` VALUES("391", "214", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("8302", "3520", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:2560;s:4:\"file\";s:42:\"2020/10/16039061361241965350643-scaled.jpg\";s:5:\"sizes\";a:9:{s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"16039061361241965350643-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"16039061361241965350643-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"16039061361241965350643-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"16039061361241965350643-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:37:\"16039061361241965350643-1152x1536.jpg\";s:5:\"width\";i:1152;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:37:\"16039061361241965350643-1536x2048.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:35:\"16039061361241965350643-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:33:\"16039061361241965350643-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:35:\"16039061361241965350643-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"SM-A500H\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1603918747\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"3.69\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:17:\"0.058823529411765\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:27:\"16039061361241965350643.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("8301", "3520", "_wp_attached_file", "2020/10/16039061361241965350643-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("25737", "5279", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:21.96105994358895;s:5:\"bytes\";i:24059;s:11:\"size_before\";i:109553;s:10:\"size_after\";i:85494;s:4:\"time\";d:0.71000000000000008;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:7:{s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:29.73;s:5:\"bytes\";i:2420;s:11:\"size_before\";i:8139;s:10:\"size_after\";i:5719;s:4:\"time\";d:0.02;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:20.030000000000001;s:5:\"bytes\";i:8267;s:11:\"size_before\";i:41267;s:10:\"size_after\";i:33000;s:4:\"time\";d:0.26000000000000001;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:21.84;s:5:\"bytes\";i:1171;s:11:\"size_before\";i:5362;s:10:\"size_after\";i:4191;s:4:\"time\";d:0.11;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:22.670000000000002;s:5:\"bytes\";i:6328;s:11:\"size_before\";i:27918;s:10:\"size_after\";i:21590;s:4:\"time\";d:0.12;}s:11:\"img-370-250\";O:8:\"stdClass\":5:{s:7:\"percent\";d:22.190000000000001;s:5:\"bytes\";i:3080;s:11:\"size_before\";i:13880;s:10:\"size_after\";i:10800;s:4:\"time\";d:0.14999999999999999;}s:9:\"img-76-61\";O:8:\"stdClass\":5:{s:7:\"percent\";d:19.52;s:5:\"bytes\";i:565;s:11:\"size_before\";i:2894;s:10:\"size_after\";i:2329;s:4:\"time\";d:0.01;}s:11:\"img-262-190\";O:8:\"stdClass\":5:{s:7:\"percent\";d:22.07;s:5:\"bytes\";i:2228;s:11:\"size_before\";i:10093;s:10:\"size_after\";i:7865;s:4:\"time\";d:0.040000000000000001;}}}");
INSERT INTO `wp_postmeta` VALUES("25152", "6366", "description", "نکته های مهم موقع خرید خانه");
INSERT INTO `wp_postmeta` VALUES("25736", "5767", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:55.294570658452059;s:5:\"bytes\";i:1436;s:11:\"size_before\";i:2597;s:10:\"size_after\";i:1161;s:4:\"time\";d:0.01;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:55.289999999999999;s:5:\"bytes\";i:1436;s:11:\"size_before\";i:2597;s:10:\"size_after\";i:1161;s:4:\"time\";d:0.01;}}}");
INSERT INTO `wp_postmeta` VALUES("25151", "232", "createquerystate", "a:3:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:8:\"havekadr\";s:13:\"breadcrumb-me\";s:5:\"title\";}");
INSERT INTO `wp_postmeta` VALUES("13103", "4682", "_wp_attached_file", "2020/04/apartment2.jpg");
INSERT INTO `wp_postmeta` VALUES("13104", "4682", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:22:\"2020/04/apartment2.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"apartment2-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"apartment2-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:22:\"apartment2-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:20:\"apartment2-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:22:\"apartment2-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:22:\"apartment2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:22:\"apartment2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("485", "221", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("486", "221", "tedad-vahed-kol", "");
INSERT INTO `wp_postmeta` VALUES("487", "221", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("488", "221", "tedad-vahed-har-tabaghe", "1");
INSERT INTO `wp_postmeta` VALUES("489", "221", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("490", "221", "tedad-tabaghat", "");
INSERT INTO `wp_postmeta` VALUES("491", "221", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("492", "221", "tabaghe", "");
INSERT INTO `wp_postmeta` VALUES("493", "221", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("494", "221", "otagh", "1");
INSERT INTO `wp_postmeta` VALUES("495", "221", "_google", "field_5ae856fce6376");
INSERT INTO `wp_postmeta` VALUES("496", "221", "google", "");
INSERT INTO `wp_postmeta` VALUES("497", "221", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("498", "221", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("499", "221", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("500", "221", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("501", "221", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("502", "221", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("503", "221", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("504", "221", "description", "ویلای لاکچری 500 متری 5 خوابه");
INSERT INTO `wp_postmeta` VALUES("505", "221", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("506", "221", "vaziat", "1");
INSERT INTO `wp_postmeta` VALUES("507", "221", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("508", "221", "special", "1");
INSERT INTO `wp_postmeta` VALUES("509", "221", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("510", "221", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("511", "221", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("512", "221", "shahraki", "0");
INSERT INTO `wp_postmeta` VALUES("513", "221", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("514", "221", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("515", "221", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("516", "221", "okasion", "0");
INSERT INTO `wp_postmeta` VALUES("517", "221", "_okasion", "field_5be01d6c83774");
INSERT INTO `wp_postmeta` VALUES("518", "221", "saheli", "1");
INSERT INTO `wp_postmeta` VALUES("519", "221", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("520", "221", "hektari", "0");
INSERT INTO `wp_postmeta` VALUES("521", "221", "_hektari", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("522", "221", "name", "یوسف امینی");
INSERT INTO `wp_postmeta` VALUES("523", "221", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("524", "221", "address", "تست ادرس در اینجا قرار میگیرد");
INSERT INTO `wp_postmeta` VALUES("525", "221", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("526", "221", "mobile", "01155222569");
INSERT INTO `wp_postmeta` VALUES("527", "221", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("528", "221", "email", "");
INSERT INTO `wp_postmeta` VALUES("529", "221", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("530", "221", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("531", "221", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("532", "221", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("533", "221", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("534", "221", "ostan", "تهران");
INSERT INTO `wp_postmeta` VALUES("535", "221", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("536", "221", "shahr", "شاهدشهر");
INSERT INTO `wp_postmeta` VALUES("537", "221", "_shahr", "field_5be2b7acddc6d");
INSERT INTO `wp_postmeta` VALUES("538", "221", "metrazh", "300");
INSERT INTO `wp_postmeta` VALUES("539", "221", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("540", "221", "masahat-zamin", "500");
INSERT INTO `wp_postmeta` VALUES("541", "221", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("542", "221", "price-kol", "700000000");
INSERT INTO `wp_postmeta` VALUES("543", "221", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("544", "221", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("545", "221", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("546", "221", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("547", "221", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("548", "221", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("549", "221", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("550", "221", "mg", "a:2:{i:0;s:10:\"شمالی\";i:1;s:8:\"غربی\";}");
INSERT INTO `wp_postmeta` VALUES("551", "221", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("552", "221", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("553", "221", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("554", "221", "nama", "کلاسیک");
INSERT INTO `wp_postmeta` VALUES("555", "221", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("556", "221", "kabinet", "کابینت جزیره");
INSERT INTO `wp_postmeta` VALUES("557", "221", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("558", "221", "wc", "ایرانی");
INSERT INTO `wp_postmeta` VALUES("559", "221", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("560", "221", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("561", "221", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("562", "221", "sayer-emkanat", "a:33:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:14:\"پارکینگ\";i:4;s:14:\"آسانسور\";i:5;s:12:\"انباری\";i:6;s:20:\"درب ضد سرقت\";i:7;s:8:\"تلفن\";i:8;s:10:\"شوفاژ\";i:9;s:12:\"شومینه\";i:10;s:8:\"چیلر\";i:11;s:13:\"فن کوئل\";i:12;s:8:\"پکیج\";i:13;s:8:\"کولر\";i:14;s:10:\"استخر\";i:15;s:8:\"سونا\";i:16;s:10:\"جکوزی\";i:17;s:23:\"آیفون تصویری\";i:18;s:30:\"دوربین مدار بسته\";i:19;s:17:\"درب ریموت\";i:20;s:19:\"آنتن مرکزی\";i:21;s:25:\"اینترنت مرکزی\";i:22;s:10:\"پاسیو\";i:23;s:16:\"باربیکیو\";i:24;s:10:\"بالکن\";i:25;s:8:\"حیاط\";i:26;s:8:\"لابی\";i:27;s:25:\"سالن اجتماعات\";i:28;s:16:\"سرایداری\";i:29;s:8:\"مبله\";i:30;s:19:\"اطفاء حریق\";i:31;s:23:\"شوتینگ زباله\";i:32;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("2011", "221", "streetmap", "a:7:{s:3:\"lat\";d:36.675853799999999;s:3:\"lng\";d:51.256198900000001;s:4:\"zoom\";i:12;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:116:\"قطعه۳ بهشتی ٢١, 46718-79988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:13:\"default_label\";s:116:\"قطعه۳ بهشتی ٢١, 46718-79988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:3:\"lat\";d:36.701182299999999;s:3:\"lng\";d:51.197319;}}s:7:\"address\";s:116:\"قطعه۳ بهشتی ٢١, 46718-79988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("563", "221", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("564", "221", "gallery", "a:2:{i:0;s:4:\"2013\";i:1;s:4:\"5676\";}");
INSERT INTO `wp_postmeta` VALUES("565", "221", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("566", "221", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("567", "221", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("568", "221", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("569", "221", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("570", "221", "lat", "");
INSERT INTO `wp_postmeta` VALUES("571", "221", "_lat", "field_5ea5803e5226f");
INSERT INTO `wp_postmeta` VALUES("572", "221", "lng", "");
INSERT INTO `wp_postmeta` VALUES("573", "221", "_lng", "field_5ea5806d52270");
INSERT INTO `wp_postmeta` VALUES("574", "223", "description", "رهن ملک اداری در تهران");
INSERT INTO `wp_postmeta` VALUES("575", "223", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("576", "223", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("577", "223", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("578", "223", "special", "1");
INSERT INTO `wp_postmeta` VALUES("579", "223", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("580", "223", "nama", "شیشه");
INSERT INTO `wp_postmeta` VALUES("581", "223", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("582", "223", "sokonat", "مستاجر ساکن");
INSERT INTO `wp_postmeta` VALUES("583", "223", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("584", "223", "tedad-vahed-kol", "80");
INSERT INTO `wp_postmeta` VALUES("585", "223", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("586", "223", "tedad-vahed-har-tabaghe", "4");
INSERT INTO `wp_postmeta` VALUES("587", "223", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("588", "223", "tedad-tabaghat", "20");
INSERT INTO `wp_postmeta` VALUES("589", "223", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("590", "223", "mg", "a:1:{i:0;s:10:\"جنوبی\";}");
INSERT INTO `wp_postmeta` VALUES("591", "223", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("592", "223", "senbana", "10 تا 20 سال");
INSERT INTO `wp_postmeta` VALUES("593", "223", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("594", "223", "gallery", "a:2:{i:0;s:4:\"2017\";i:1;s:4:\"4681\";}");
INSERT INTO `wp_postmeta` VALUES("595", "223", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("596", "223", "sayer-emkanat", "a:27:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:14:\"پارکینگ\";i:4;s:14:\"آسانسور\";i:5;s:12:\"انباری\";i:6;s:20:\"درب ضد سرقت\";i:7;s:8:\"تلفن\";i:8;s:10:\"شوفاژ\";i:9;s:13:\"فن کوئل\";i:10;s:8:\"پکیج\";i:11;s:8:\"کولر\";i:12;s:23:\"آیفون تصویری\";i:13;s:30:\"دوربین مدار بسته\";i:14;s:17:\"درب ریموت\";i:15;s:19:\"آنتن مرکزی\";i:16;s:25:\"اینترنت مرکزی\";i:17;s:10:\"پاسیو\";i:18;s:16:\"باربیکیو\";i:19;s:10:\"بالکن\";i:20;s:8:\"حیاط\";i:21;s:8:\"لابی\";i:22;s:25:\"سالن اجتماعات\";i:23;s:16:\"سرایداری\";i:24;s:8:\"مبله\";i:25;s:19:\"اطفاء حریق\";i:26;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("597", "223", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("598", "223", "kafposh", "سنگ");
INSERT INTO `wp_postmeta` VALUES("599", "223", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("600", "223", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("601", "223", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("602", "223", "kabinet", "فلزی طرح چوب");
INSERT INTO `wp_postmeta` VALUES("603", "223", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("604", "223", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("605", "223", "sanad", "شخصی");
INSERT INTO `wp_postmeta` VALUES("606", "223", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("607", "223", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("608", "223", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("609", "223", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("610", "223", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("611", "223", "otagh", "1");
INSERT INTO `wp_postmeta` VALUES("612", "223", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("613", "223", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("614", "223", "price-ejare", "250000");
INSERT INTO `wp_postmeta` VALUES("615", "223", "simplefavorites_count", "1");
INSERT INTO `wp_postmeta` VALUES("616", "223", "price-rahn", "250000000");
INSERT INTO `wp_postmeta` VALUES("617", "223", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("618", "223", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("619", "223", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("620", "223", "shahraki", "0");
INSERT INTO `wp_postmeta` VALUES("621", "223", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("622", "223", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("623", "223", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("624", "223", "okasion", "1");
INSERT INTO `wp_postmeta` VALUES("625", "223", "_okasion", "field_5be01d6c83774");
INSERT INTO `wp_postmeta` VALUES("626", "223", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("627", "223", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("628", "223", "hektari", "0");
INSERT INTO `wp_postmeta` VALUES("629", "223", "_hektari", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("630", "223", "name", "حسینی");
INSERT INTO `wp_postmeta` VALUES("631", "223", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("632", "223", "address", "تهران ، لواسان");
INSERT INTO `wp_postmeta` VALUES("633", "223", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("634", "223", "mobile", "09111111111");
INSERT INTO `wp_postmeta` VALUES("635", "223", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("636", "223", "email", "");
INSERT INTO `wp_postmeta` VALUES("637", "223", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("638", "223", "moamele", "رهن و اجاره");
INSERT INTO `wp_postmeta` VALUES("639", "223", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("640", "223", "melk", "اداری و تجاری");
INSERT INTO `wp_postmeta` VALUES("641", "223", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("642", "223", "ostan", "تهران");
INSERT INTO `wp_postmeta` VALUES("643", "223", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("644", "223", "shahr", "لواسان");
INSERT INTO `wp_postmeta` VALUES("645", "223", "_shahr", "field_5be2b7acddc6d");
INSERT INTO `wp_postmeta` VALUES("646", "223", "metrazh", "86");
INSERT INTO `wp_postmeta` VALUES("647", "223", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("648", "223", "masahat-zamin", "");
INSERT INTO `wp_postmeta` VALUES("649", "223", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("650", "223", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("651", "223", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("652", "223", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("653", "223", "_pishforosh", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("654", "223", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("655", "223", "_moaveze", "field_5bf2b3c79dc71");
INSERT INTO `wp_postmeta` VALUES("656", "285", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("657", "285", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("658", "285", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("659", "285", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("660", "285", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("661", "285", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("662", "285", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("663", "285", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("664", "285", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("665", "285", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("666", "285", "description", "اجاره آپارتمان 85 متری در دماوند");
INSERT INTO `wp_postmeta` VALUES("667", "285", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("668", "285", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("669", "285", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("670", "285", "special", "1");
INSERT INTO `wp_postmeta` VALUES("671", "285", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("672", "285", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("673", "285", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("674", "285", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("675", "285", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("676", "285", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("677", "285", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("678", "285", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("679", "285", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("680", "285", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("681", "285", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("682", "285", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("683", "285", "_pishforosh", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("684", "285", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("685", "285", "_moaveze", "field_5bf2b3c79dc71");
INSERT INTO `wp_postmeta` VALUES("686", "285", "name", "علیرضایی");
INSERT INTO `wp_postmeta` VALUES("687", "285", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("688", "285", "address", "تهران ولنجک");
INSERT INTO `wp_postmeta` VALUES("689", "285", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("690", "285", "mobile", "091212121232");
INSERT INTO `wp_postmeta` VALUES("691", "285", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("692", "285", "email", "");
INSERT INTO `wp_postmeta` VALUES("693", "285", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("694", "285", "moamele", "رهن و اجاره");
INSERT INTO `wp_postmeta` VALUES("695", "285", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("696", "285", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("697", "285", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("698", "285", "ostan", "تهران");
INSERT INTO `wp_postmeta` VALUES("699", "285", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("700", "285", "shahr", "دماوند");
INSERT INTO `wp_postmeta` VALUES("701", "285", "_shahr", "field_5be2b7acddc6d");
INSERT INTO `wp_postmeta` VALUES("702", "285", "metrazh", "85");
INSERT INTO `wp_postmeta` VALUES("703", "285", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("704", "285", "masahat-zamin", "");
INSERT INTO `wp_postmeta` VALUES("705", "285", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("706", "285", "price-kol", "800000000");
INSERT INTO `wp_postmeta` VALUES("707", "285", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("708", "285", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("709", "285", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("710", "285", "otagh", "2");
INSERT INTO `wp_postmeta` VALUES("711", "285", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("712", "285", "sanad", "شخصی");
INSERT INTO `wp_postmeta` VALUES("713", "285", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("714", "285", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("715", "285", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("716", "285", "mg", "a:2:{i:0;s:8:\"شرقی\";i:1;s:10:\"جنوبی\";}");
INSERT INTO `wp_postmeta` VALUES("717", "285", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("718", "285", "tabaghe", "10");
INSERT INTO `wp_postmeta` VALUES("719", "285", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("720", "285", "tedad-tabaghat", "12");
INSERT INTO `wp_postmeta` VALUES("721", "285", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("722", "285", "tedad-vahed-har-tabaghe", "4");
INSERT INTO `wp_postmeta` VALUES("723", "285", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("724", "285", "tedad-vahed-kol", "46");
INSERT INTO `wp_postmeta` VALUES("725", "285", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("726", "285", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("727", "285", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("728", "285", "nama", "سنگ");
INSERT INTO `wp_postmeta` VALUES("729", "285", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("730", "285", "kabinet", "کابینت ممبران");
INSERT INTO `wp_postmeta` VALUES("731", "285", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("732", "285", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("733", "285", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("734", "285", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("735", "285", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("736", "285", "sayer-emkanat", "a:32:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:14:\"پارکینگ\";i:4;s:14:\"آسانسور\";i:5;s:12:\"انباری\";i:6;s:8:\"تلفن\";i:7;s:10:\"شوفاژ\";i:8;s:12:\"شومینه\";i:9;s:8:\"چیلر\";i:10;s:13:\"فن کوئل\";i:11;s:8:\"پکیج\";i:12;s:8:\"کولر\";i:13;s:10:\"استخر\";i:14;s:8:\"سونا\";i:15;s:10:\"جکوزی\";i:16;s:23:\"آیفون تصویری\";i:17;s:30:\"دوربین مدار بسته\";i:18;s:17:\"درب ریموت\";i:19;s:19:\"آنتن مرکزی\";i:20;s:25:\"اینترنت مرکزی\";i:21;s:10:\"پاسیو\";i:22;s:16:\"باربیکیو\";i:23;s:10:\"بالکن\";i:24;s:8:\"حیاط\";i:25;s:8:\"لابی\";i:26;s:25:\"سالن اجتماعات\";i:27;s:16:\"سرایداری\";i:28;s:8:\"مبله\";i:29;s:19:\"اطفاء حریق\";i:30;s:23:\"شوتینگ زباله\";i:31;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("737", "285", "streetmap", "a:7:{s:3:\"lat\";d:35.706377400000001;s:3:\"lng\";d:51.613082900000002;s:4:\"zoom\";i:10;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:36:\"رفیعی, 11517-13513 Tehran, Iran\";s:13:\"default_label\";s:36:\"رفیعی, 11517-13513 Tehran, Iran\";s:3:\"lat\";d:35.696340499999998;s:3:\"lng\";d:51.4421082;}}s:7:\"address\";s:36:\"رفیعی, 11517-13513 Tehran, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("738", "285", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("739", "285", "gallery", "a:2:{i:0;s:4:\"4682\";i:1;s:4:\"4683\";}");
INSERT INTO `wp_postmeta` VALUES("740", "285", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("741", "285", "_wp_old_slug", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af");
INSERT INTO `wp_postmeta` VALUES("742", "285", "price-rahn", "150000000");
INSERT INTO `wp_postmeta` VALUES("743", "285", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("744", "285", "price-ejare", "200000");
INSERT INTO `wp_postmeta` VALUES("745", "285", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("746", "285", "simplefavorites_count", "2");
INSERT INTO `wp_postmeta` VALUES("747", "290", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("748", "290", "description", "رهن ویلا 180 متری در متل قو");
INSERT INTO `wp_postmeta` VALUES("749", "290", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("750", "290", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("751", "290", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("752", "290", "special", "0");
INSERT INTO `wp_postmeta` VALUES("753", "290", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("754", "290", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("755", "290", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("756", "290", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("757", "290", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("758", "290", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("759", "290", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("760", "290", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("761", "290", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("762", "290", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("763", "290", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("764", "290", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("765", "290", "_pishforosh", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("766", "290", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("767", "290", "_moaveze", "field_5bf2b3c79dc71");
INSERT INTO `wp_postmeta` VALUES("768", "290", "name", "علیرضایی");
INSERT INTO `wp_postmeta` VALUES("769", "290", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("770", "290", "address", "متلقو");
INSERT INTO `wp_postmeta` VALUES("771", "290", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("772", "290", "mobile", "091212121232");
INSERT INTO `wp_postmeta` VALUES("773", "290", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("774", "290", "email", "");
INSERT INTO `wp_postmeta` VALUES("775", "290", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("776", "290", "moamele", "رهن و اجاره");
INSERT INTO `wp_postmeta` VALUES("777", "290", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("778", "290", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("779", "290", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("780", "290", "ostan", "مازندران");
INSERT INTO `wp_postmeta` VALUES("781", "290", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("782", "290", "shahr", "متل قو");
INSERT INTO `wp_postmeta` VALUES("783", "290", "_shahr", "field_5ae8523bb6a32");
INSERT INTO `wp_postmeta` VALUES("784", "290", "metrazh", "180");
INSERT INTO `wp_postmeta` VALUES("785", "290", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("786", "290", "masahat-zamin", "350");
INSERT INTO `wp_postmeta` VALUES("787", "290", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("788", "290", "price-kol", "800000000");
INSERT INTO `wp_postmeta` VALUES("789", "290", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("790", "290", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("791", "290", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("792", "290", "otagh", "2");
INSERT INTO `wp_postmeta` VALUES("793", "290", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("794", "290", "sanad", "شخصی");
INSERT INTO `wp_postmeta` VALUES("795", "290", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("796", "290", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("797", "290", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("798", "290", "mg", "a:2:{i:0;s:10:\"شمالی\";i:1;s:8:\"شرقی\";}");
INSERT INTO `wp_postmeta` VALUES("799", "290", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("800", "290", "tabaghe", "10");
INSERT INTO `wp_postmeta` VALUES("801", "290", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("802", "290", "tedad-tabaghat", "12");
INSERT INTO `wp_postmeta` VALUES("803", "290", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("804", "290", "tedad-vahed-har-tabaghe", "4");
INSERT INTO `wp_postmeta` VALUES("805", "290", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("806", "290", "tedad-vahed-kol", "46");
INSERT INTO `wp_postmeta` VALUES("807", "290", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("808", "290", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("809", "290", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("810", "290", "nama", "سنگ");
INSERT INTO `wp_postmeta` VALUES("811", "290", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("812", "290", "kabinet", "کابینت MDF");
INSERT INTO `wp_postmeta` VALUES("813", "290", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("814", "290", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("815", "290", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("816", "290", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("817", "290", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("818", "290", "sayer-emkanat", "a:29:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:12:\"انباری\";i:4;s:10:\"شوفاژ\";i:5;s:12:\"شومینه\";i:6;s:8:\"چیلر\";i:7;s:13:\"فن کوئل\";i:8;s:8:\"پکیج\";i:9;s:8:\"کولر\";i:10;s:10:\"استخر\";i:11;s:8:\"سونا\";i:12;s:10:\"جکوزی\";i:13;s:23:\"آیفون تصویری\";i:14;s:30:\"دوربین مدار بسته\";i:15;s:17:\"درب ریموت\";i:16;s:19:\"آنتن مرکزی\";i:17;s:25:\"اینترنت مرکزی\";i:18;s:10:\"پاسیو\";i:19;s:16:\"باربیکیو\";i:20;s:10:\"بالکن\";i:21;s:8:\"حیاط\";i:22;s:8:\"لابی\";i:23;s:25:\"سالن اجتماعات\";i:24;s:16:\"سرایداری\";i:25;s:8:\"مبله\";i:26;s:19:\"اطفاء حریق\";i:27;s:23:\"شوتینگ زباله\";i:28;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("16494", "212", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("1996", "290", "streetmap", "a:7:{s:3:\"lat\";d:36.707925899999999;s:3:\"lng\";d:51.1891222;s:4:\"zoom\";i:14;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:99:\"مطهری, 4671879988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:13:\"default_label\";s:99:\"مطهری, 4671879988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:3:\"lat\";d:36.708269999999999;s:3:\"lng\";d:51.188049300000003;}}s:7:\"address\";s:99:\"مطهری, 4671879988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("819", "290", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("820", "290", "gallery", "a:1:{i:0;s:4:\"2012\";}");
INSERT INTO `wp_postmeta` VALUES("821", "290", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("822", "290", "_wp_old_slug", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af");
INSERT INTO `wp_postmeta` VALUES("823", "290", "price-rahn", "350000000");
INSERT INTO `wp_postmeta` VALUES("824", "290", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("825", "290", "price-ejare", "500000");
INSERT INTO `wp_postmeta` VALUES("826", "290", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("827", "290", "_wp_old_slug", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy");
INSERT INTO `wp_postmeta` VALUES("828", "294", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("829", "294", "description", "اجاره ویلای لاکچری استخردار در رامسر");
INSERT INTO `wp_postmeta` VALUES("830", "294", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("831", "294", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("832", "294", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("833", "294", "special", "0");
INSERT INTO `wp_postmeta` VALUES("834", "294", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("835", "294", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("836", "294", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("837", "294", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("838", "294", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("839", "294", "shahraki", "0");
INSERT INTO `wp_postmeta` VALUES("840", "294", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("841", "294", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("842", "294", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("843", "294", "saheli", "1");
INSERT INTO `wp_postmeta` VALUES("844", "294", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("845", "294", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("846", "294", "_pishforosh", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("847", "294", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("848", "294", "_moaveze", "field_5bf2b3c79dc71");
INSERT INTO `wp_postmeta` VALUES("849", "294", "name", "رامسریان");
INSERT INTO `wp_postmeta` VALUES("850", "294", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("851", "294", "address", "رامسر");
INSERT INTO `wp_postmeta` VALUES("852", "294", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("853", "294", "mobile", "091212121232");
INSERT INTO `wp_postmeta` VALUES("854", "294", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("855", "294", "email", "");
INSERT INTO `wp_postmeta` VALUES("856", "294", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("857", "294", "moamele", "رهن و اجاره");
INSERT INTO `wp_postmeta` VALUES("858", "294", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("859", "294", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("860", "294", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("861", "294", "ostan", "مازندران");
INSERT INTO `wp_postmeta` VALUES("862", "294", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("863", "294", "shahr", "رامسر");
INSERT INTO `wp_postmeta` VALUES("864", "294", "_shahr", "field_5ae8523bb6a32");
INSERT INTO `wp_postmeta` VALUES("865", "294", "metrazh", "220");
INSERT INTO `wp_postmeta` VALUES("866", "294", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("867", "294", "masahat-zamin", "430");
INSERT INTO `wp_postmeta` VALUES("868", "294", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("869", "294", "price-kol", "800000000");
INSERT INTO `wp_postmeta` VALUES("870", "294", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("871", "294", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("872", "294", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("873", "294", "otagh", "2");
INSERT INTO `wp_postmeta` VALUES("874", "294", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("875", "294", "sanad", "شخصی");
INSERT INTO `wp_postmeta` VALUES("876", "294", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("877", "294", "senbana", "5 تا 10 سال");
INSERT INTO `wp_postmeta` VALUES("878", "294", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("879", "294", "mg", "a:2:{i:0;s:10:\"شمالی\";i:1;s:8:\"شرقی\";}");
INSERT INTO `wp_postmeta` VALUES("880", "294", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("881", "294", "tabaghe", "10");
INSERT INTO `wp_postmeta` VALUES("882", "294", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("883", "294", "tedad-tabaghat", "12");
INSERT INTO `wp_postmeta` VALUES("884", "294", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("885", "294", "tedad-vahed-har-tabaghe", "4");
INSERT INTO `wp_postmeta` VALUES("886", "294", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("887", "294", "tedad-vahed-kol", "46");
INSERT INTO `wp_postmeta` VALUES("888", "294", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("889", "294", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("890", "294", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("891", "294", "nama", "سنگ");
INSERT INTO `wp_postmeta` VALUES("892", "294", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("893", "294", "kabinet", "کابینت MDF");
INSERT INTO `wp_postmeta` VALUES("894", "294", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("895", "294", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("896", "294", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("897", "294", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("898", "294", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("899", "294", "sayer-emkanat", "a:29:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:12:\"انباری\";i:4;s:10:\"شوفاژ\";i:5;s:12:\"شومینه\";i:6;s:8:\"چیلر\";i:7;s:13:\"فن کوئل\";i:8;s:8:\"پکیج\";i:9;s:8:\"کولر\";i:10;s:10:\"استخر\";i:11;s:8:\"سونا\";i:12;s:10:\"جکوزی\";i:13;s:23:\"آیفون تصویری\";i:14;s:30:\"دوربین مدار بسته\";i:15;s:17:\"درب ریموت\";i:16;s:19:\"آنتن مرکزی\";i:17;s:25:\"اینترنت مرکزی\";i:18;s:10:\"پاسیو\";i:19;s:16:\"باربیکیو\";i:20;s:10:\"بالکن\";i:21;s:8:\"حیاط\";i:22;s:8:\"لابی\";i:23;s:25:\"سالن اجتماعات\";i:24;s:16:\"سرایداری\";i:25;s:8:\"مبله\";i:26;s:19:\"اطفاء حریق\";i:27;s:23:\"شوتینگ زباله\";i:28;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("16490", "290", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16491", "290", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("1986", "294", "streetmap", "a:7:{s:3:\"lat\";d:36.921660699999997;s:3:\"lng\";d:50.655534299999999;s:4:\"zoom\";i:15;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:84:\"غربی ۱۳, 46918_96195 دهستان سخت سر Ramsar, Mazandaran Province Iran\";s:13:\"default_label\";s:84:\"غربی ۱۳, 46918_96195 دهستان سخت سر Ramsar, Mazandaran Province Iran\";s:3:\"lat\";d:36.922038100000002;s:3:\"lng\";d:50.6552553;}}s:7:\"address\";s:84:\"غربی ۱۳, 46918_96195 دهستان سخت سر Ramsar, Mazandaran Province Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("900", "294", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("901", "294", "gallery", "a:2:{i:0;s:4:\"4681\";i:1;s:4:\"2012\";}");
INSERT INTO `wp_postmeta` VALUES("902", "294", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("903", "294", "_wp_old_slug", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af");
INSERT INTO `wp_postmeta` VALUES("904", "294", "_wp_old_slug", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy");
INSERT INTO `wp_postmeta` VALUES("905", "294", "price-rahn", "150000000");
INSERT INTO `wp_postmeta` VALUES("906", "294", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("907", "294", "price-ejare", "4000000");
INSERT INTO `wp_postmeta` VALUES("908", "294", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("909", "294", "_wp_old_slug", "%d8%b1%d9%87%d9%86-%d9%88%db%8c%d9%84%d8%a7-180-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d9%85%d8%aa%d9%84-%d9%82%d9%88-copy");
INSERT INTO `wp_postmeta` VALUES("910", "294", "simplefavorites_count", "3");
INSERT INTO `wp_postmeta` VALUES("911", "296", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("912", "296", "description", "فروش ویلای کوهپایه در تنکابن");
INSERT INTO `wp_postmeta` VALUES("913", "296", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("914", "296", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("915", "296", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("916", "296", "special", "1");
INSERT INTO `wp_postmeta` VALUES("917", "296", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("918", "296", "fast", "0");
INSERT INTO `wp_postmeta` VALUES("919", "296", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("920", "296", "kohpaye", "1");
INSERT INTO `wp_postmeta` VALUES("921", "296", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("922", "296", "shahraki", "0");
INSERT INTO `wp_postmeta` VALUES("923", "296", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("924", "296", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("925", "296", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("926", "296", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("927", "296", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("928", "296", "pishforosh", "1");
INSERT INTO `wp_postmeta` VALUES("929", "296", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("930", "296", "moaveze", "1");
INSERT INTO `wp_postmeta` VALUES("931", "296", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("932", "296", "name", "تقی زاده");
INSERT INTO `wp_postmeta` VALUES("933", "296", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("934", "296", "address", "تنکابن");
INSERT INTO `wp_postmeta` VALUES("935", "296", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("936", "296", "mobile", "091212121232");
INSERT INTO `wp_postmeta` VALUES("937", "296", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("938", "296", "email", "");
INSERT INTO `wp_postmeta` VALUES("939", "296", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("940", "296", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("941", "296", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("942", "296", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("943", "296", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("944", "296", "ostan", "مازندران");
INSERT INTO `wp_postmeta` VALUES("945", "296", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("946", "296", "shahr", "تنکابن");
INSERT INTO `wp_postmeta` VALUES("947", "296", "_shahr", "field_5ae8523bb6a32");
INSERT INTO `wp_postmeta` VALUES("948", "296", "metrazh", "120");
INSERT INTO `wp_postmeta` VALUES("949", "296", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("950", "296", "masahat-zamin", "230");
INSERT INTO `wp_postmeta` VALUES("951", "296", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("952", "296", "price-kol", "8000000000");
INSERT INTO `wp_postmeta` VALUES("953", "296", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("954", "296", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("955", "296", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("956", "296", "otagh", "2");
INSERT INTO `wp_postmeta` VALUES("957", "296", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("958", "296", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("959", "296", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("960", "296", "senbana", "5 تا 10 سال");
INSERT INTO `wp_postmeta` VALUES("961", "296", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("962", "296", "mg", "a:3:{i:0;s:10:\"جنوبی\";i:1;s:8:\"غربی\";i:2;s:10:\"دونبش\";}");
INSERT INTO `wp_postmeta` VALUES("963", "296", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("964", "296", "tabaghe", "10");
INSERT INTO `wp_postmeta` VALUES("965", "296", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("966", "296", "tedad-tabaghat", "12");
INSERT INTO `wp_postmeta` VALUES("967", "296", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("968", "296", "tedad-vahed-har-tabaghe", "4");
INSERT INTO `wp_postmeta` VALUES("969", "296", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("970", "296", "tedad-vahed-kol", "46");
INSERT INTO `wp_postmeta` VALUES("971", "296", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("972", "296", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("973", "296", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("974", "296", "nama", "سنگ");
INSERT INTO `wp_postmeta` VALUES("975", "296", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("976", "296", "kabinet", "کابینت MDF");
INSERT INTO `wp_postmeta` VALUES("977", "296", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("978", "296", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("979", "296", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("980", "296", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("981", "296", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("982", "296", "sayer-emkanat", "a:29:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:12:\"انباری\";i:4;s:10:\"شوفاژ\";i:5;s:12:\"شومینه\";i:6;s:8:\"چیلر\";i:7;s:13:\"فن کوئل\";i:8;s:8:\"پکیج\";i:9;s:8:\"کولر\";i:10;s:10:\"استخر\";i:11;s:8:\"سونا\";i:12;s:10:\"جکوزی\";i:13;s:23:\"آیفون تصویری\";i:14;s:30:\"دوربین مدار بسته\";i:15;s:17:\"درب ریموت\";i:16;s:19:\"آنتن مرکزی\";i:17;s:25:\"اینترنت مرکزی\";i:18;s:10:\"پاسیو\";i:19;s:16:\"باربیکیو\";i:20;s:10:\"بالکن\";i:21;s:8:\"حیاط\";i:22;s:8:\"لابی\";i:23;s:25:\"سالن اجتماعات\";i:24;s:16:\"سرایداری\";i:25;s:8:\"مبله\";i:26;s:19:\"اطفاء حریق\";i:27;s:23:\"شوتینگ زباله\";i:28;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("16486", "294", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16487", "294", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("983", "296", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("984", "296", "gallery", "a:2:{i:0;s:4:\"2008\";i:1;s:4:\"2007\";}");
INSERT INTO `wp_postmeta` VALUES("985", "296", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("986", "296", "_wp_old_slug", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af");
INSERT INTO `wp_postmeta` VALUES("987", "296", "_wp_old_slug", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy");
INSERT INTO `wp_postmeta` VALUES("988", "296", "_wp_old_slug", "%d8%b1%d9%87%d9%86-%d9%88%db%8c%d9%84%d8%a7-180-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d9%85%d8%aa%d9%84-%d9%82%d9%88-copy");
INSERT INTO `wp_postmeta` VALUES("989", "296", "price-rahn", "");
INSERT INTO `wp_postmeta` VALUES("990", "296", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("991", "296", "price-ejare", "4000000");
INSERT INTO `wp_postmeta` VALUES("992", "296", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("993", "296", "_wp_old_slug", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d9%88%db%8c%d9%84%d8%a7%db%8c-%d9%84%d8%a7%da%a9%da%86%d8%b1%db%8c-%d8%a7%d8%b3%d8%aa%d8%ae%d8%b1%d8%af%d8%a7%d8%b1-%d8%af%d8%b1-%d8%b1%d8%a7%d9%85%d8%b3%d8%b1-copy");
INSERT INTO `wp_postmeta` VALUES("994", "296", "moaveze-for", "ماشین");
INSERT INTO `wp_postmeta` VALUES("995", "296", "_moaveze-for", "field_5eef05d1461c2");
INSERT INTO `wp_postmeta` VALUES("996", "296", "moshaver", "26");
INSERT INTO `wp_postmeta` VALUES("997", "296", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("998", "296", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("999", "296", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1000", "296", "lat", "");
INSERT INTO `wp_postmeta` VALUES("1001", "296", "_lat", "field_5ea5803e5226f");
INSERT INTO `wp_postmeta` VALUES("1002", "296", "lng", "");
INSERT INTO `wp_postmeta` VALUES("1003", "296", "_lng", "field_5ea5806d52270");
INSERT INTO `wp_postmeta` VALUES("1004", "296", "data-pishforosh", "اسفند 1399");
INSERT INTO `wp_postmeta` VALUES("1005", "296", "_data-pishforosh", "field_5ec21f0ef01b0");
INSERT INTO `wp_postmeta` VALUES("1006", "296", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1007", "296", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1008", "296", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1009", "296", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1010", "296", "simplefavorites_count", "1");
INSERT INTO `wp_postmeta` VALUES("1011", "297", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("1012", "297", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1013", "297", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1014", "297", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("1015", "297", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("1016", "297", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1017", "297", "description", "اجاره آپارتمان 3 طبقه ، طبقه سوم لاهیجان");
INSERT INTO `wp_postmeta` VALUES("1018", "297", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1019", "297", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("1020", "297", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("1021", "297", "special", "0");
INSERT INTO `wp_postmeta` VALUES("1022", "297", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("1023", "297", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("1024", "297", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("1025", "297", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("1026", "297", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("1027", "297", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("1028", "297", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("1029", "297", "okasion", "0");
INSERT INTO `wp_postmeta` VALUES("1030", "297", "_okasion", "field_5be01d6c83774");
INSERT INTO `wp_postmeta` VALUES("1031", "297", "saheli", "1");
INSERT INTO `wp_postmeta` VALUES("1032", "297", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("1033", "297", "hektari", "0");
INSERT INTO `wp_postmeta` VALUES("1034", "297", "_hektari", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("1035", "297", "name", "امینی");
INSERT INTO `wp_postmeta` VALUES("1036", "297", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("1037", "297", "address", "لاهجان ، بالاتر از کوچه سوم");
INSERT INTO `wp_postmeta` VALUES("1038", "297", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("1039", "297", "mobile", "09336668899");
INSERT INTO `wp_postmeta` VALUES("1040", "297", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("1041", "297", "email", "");
INSERT INTO `wp_postmeta` VALUES("1042", "297", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("1043", "297", "moamele", "رهن و اجاره");
INSERT INTO `wp_postmeta` VALUES("1044", "297", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("1045", "297", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("1046", "297", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("1047", "297", "ostan", "گیلان");
INSERT INTO `wp_postmeta` VALUES("1048", "297", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("1049", "297", "shahr", "لاهیجان");
INSERT INTO `wp_postmeta` VALUES("1050", "297", "_shahr", "field_5be3ddd570831");
INSERT INTO `wp_postmeta` VALUES("1051", "297", "metrazh", "250");
INSERT INTO `wp_postmeta` VALUES("1052", "297", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("1053", "297", "masahat-zamin", "300");
INSERT INTO `wp_postmeta` VALUES("1054", "297", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("1055", "297", "price-kol", "350000000");
INSERT INTO `wp_postmeta` VALUES("1056", "297", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("1057", "297", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("1058", "297", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("1059", "297", "otagh", "2");
INSERT INTO `wp_postmeta` VALUES("1060", "297", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("1061", "297", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1062", "297", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1063", "297", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1064", "297", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1065", "297", "sanad", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1066", "297", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("1067", "297", "senbana", "کلنگی");
INSERT INTO `wp_postmeta` VALUES("1068", "297", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("1069", "297", "mg", "a:2:{i:0;s:10:\"شمالی\";i:1;s:8:\"شرقی\";}");
INSERT INTO `wp_postmeta` VALUES("1070", "297", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("1071", "297", "tabaghe", "2");
INSERT INTO `wp_postmeta` VALUES("1072", "297", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("1073", "297", "tedad-tabaghat", "3");
INSERT INTO `wp_postmeta` VALUES("1074", "297", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("1075", "297", "tedad-vahed-har-tabaghe", "2");
INSERT INTO `wp_postmeta` VALUES("1076", "297", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("1077", "297", "tedad-vahed-kol", "6");
INSERT INTO `wp_postmeta` VALUES("1078", "297", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("1079", "297", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("1080", "297", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("1081", "297", "nama", "رومی");
INSERT INTO `wp_postmeta` VALUES("1082", "297", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("1083", "297", "kabinet", "کابینت MDF");
INSERT INTO `wp_postmeta` VALUES("1084", "297", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("1085", "297", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("1086", "297", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1087", "297", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("1088", "297", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("1089", "297", "sayer-emkanat", "a:6:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:12:\"انباری\";i:4;s:10:\"بالکن\";i:5;s:8:\"حیاط\";}");
INSERT INTO `wp_postmeta` VALUES("1090", "297", "streetmap", "a:7:{s:3:\"lat\";d:37.203209899999997;s:3:\"lng\";d:50.0040257;s:4:\"zoom\";i:16;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:62:\"امام ناصح, 44138-84635 Lahijan یوسف آباد, Iran\";s:13:\"default_label\";s:62:\"امام ناصح, 44138-84635 Lahijan یوسف آباد, Iran\";s:3:\"lat\";d:37.201962299999998;s:3:\"lng\";d:50.003542899999999;}}s:7:\"address\";s:62:\"امام ناصح, 44138-84635 Lahijan یوسف آباد, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("1091", "297", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("1092", "297", "gallery", "a:2:{i:0;s:4:\"6427\";i:1;s:4:\"2010\";}");
INSERT INTO `wp_postmeta` VALUES("1093", "297", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("1094", "297", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("1095", "297", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("1096", "297", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("1097", "297", "_pishforosh", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("1098", "297", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("1099", "297", "_moaveze", "field_5bf2b3c79dc71");
INSERT INTO `wp_postmeta` VALUES("1100", "297", "moaveze-for", "با ماشین");
INSERT INTO `wp_postmeta` VALUES("1101", "297", "_moaveze-for", "field_5bf2b4279dc72");
INSERT INTO `wp_postmeta` VALUES("1102", "297", "google", "");
INSERT INTO `wp_postmeta` VALUES("1103", "297", "_google", "field_5ae856fce6376");
INSERT INTO `wp_postmeta` VALUES("1104", "297", "_wp_old_slug", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-3-%d8%b7%d8%a8%d9%82%d9%87-%d8%af%d8%b1-%d8%b4%d9%85%d8%a7%d9%84-copy");
INSERT INTO `wp_postmeta` VALUES("1105", "297", "price-rahn", "250000000");
INSERT INTO `wp_postmeta` VALUES("1106", "297", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("1107", "297", "price-ejare", "1500000");
INSERT INTO `wp_postmeta` VALUES("1108", "297", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("1109", "297", "simplefavorites_count", "3");
INSERT INTO `wp_postmeta` VALUES("1110", "300", "simplefavorites_count", "4");
INSERT INTO `wp_postmeta` VALUES("1111", "300", "_wp_old_date", "2020-04-08");
INSERT INTO `wp_postmeta` VALUES("1112", "300", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1113", "300", "description", "پیش فروش آپارتمان در تهران");
INSERT INTO `wp_postmeta` VALUES("1114", "300", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1115", "300", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("1116", "300", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("1117", "300", "special", "1");
INSERT INTO `wp_postmeta` VALUES("1118", "300", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("1119", "300", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("1120", "300", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("1121", "300", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("1122", "300", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("1123", "300", "luxury", "0");
INSERT INTO `wp_postmeta` VALUES("1124", "300", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("1125", "300", "okasion", "1");
INSERT INTO `wp_postmeta` VALUES("1126", "300", "_okasion", "field_5be01d6c83774");
INSERT INTO `wp_postmeta` VALUES("1127", "300", "saheli", "1");
INSERT INTO `wp_postmeta` VALUES("1128", "300", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("1129", "300", "hektari", "0");
INSERT INTO `wp_postmeta` VALUES("1130", "300", "_hektari", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("1131", "300", "name", "رضاییان");
INSERT INTO `wp_postmeta` VALUES("1132", "300", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("1133", "300", "address", "تهران قرچک");
INSERT INTO `wp_postmeta` VALUES("1134", "300", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("1135", "300", "mobile", "09112223344");
INSERT INTO `wp_postmeta` VALUES("1136", "300", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("1137", "300", "email", "");
INSERT INTO `wp_postmeta` VALUES("1138", "300", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("1139", "300", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("1140", "300", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("1141", "300", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("1142", "300", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("1143", "300", "ostan", "تهران");
INSERT INTO `wp_postmeta` VALUES("1144", "300", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("1145", "300", "shahr", "پیشوا");
INSERT INTO `wp_postmeta` VALUES("1146", "300", "_shahr", "field_5be2b7acddc6d");
INSERT INTO `wp_postmeta` VALUES("1147", "300", "metrazh", "70");
INSERT INTO `wp_postmeta` VALUES("1148", "300", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("1149", "300", "masahat-zamin", "520");
INSERT INTO `wp_postmeta` VALUES("1150", "300", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("1151", "300", "price-kol", "120000000");
INSERT INTO `wp_postmeta` VALUES("1152", "300", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("1153", "300", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("1154", "300", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("1155", "300", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("1156", "300", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("1157", "300", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("1158", "300", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("1159", "300", "mg", "");
INSERT INTO `wp_postmeta` VALUES("1160", "300", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("1161", "300", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("1162", "300", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("1163", "300", "nama", "");
INSERT INTO `wp_postmeta` VALUES("1164", "300", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("1165", "300", "kabinet", "");
INSERT INTO `wp_postmeta` VALUES("1166", "300", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("1167", "300", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("1168", "300", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1169", "300", "kafposh", "");
INSERT INTO `wp_postmeta` VALUES("1170", "300", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("1171", "300", "sayer-emkanat", "a:4:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:12:\"انباری\";}");
INSERT INTO `wp_postmeta` VALUES("1172", "300", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("1173", "300", "gallery", "a:2:{i:0;s:4:\"5769\";i:1;s:4:\"4677\";}");
INSERT INTO `wp_postmeta` VALUES("1174", "300", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("1175", "300", "_wp_old_slug", "%d9%88%db%8c%d9%84%d8%a7-%d8%a7%d9%88%da%a9%d8%a7%d8%b2%db%8c%d9%88%d9%86-%d8%af%d8%b1-%d9%85%d8%aa%d9%84-%d9%82%d9%88-copy");
INSERT INTO `wp_postmeta` VALUES("1176", "300", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("1177", "300", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("1178", "300", "pishforosh", "1");
INSERT INTO `wp_postmeta` VALUES("1179", "300", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("1180", "300", "moaveze", "1");
INSERT INTO `wp_postmeta` VALUES("1181", "300", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("1182", "300", "moaveze-for", "آپارتمان کوچک در قرچک");
INSERT INTO `wp_postmeta` VALUES("1183", "300", "_moaveze-for", "field_5eef05d1461c2");
INSERT INTO `wp_postmeta` VALUES("1184", "300", "otagh", "2");
INSERT INTO `wp_postmeta` VALUES("1185", "300", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("1186", "300", "tabaghe", "2");
INSERT INTO `wp_postmeta` VALUES("1187", "300", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("1188", "300", "tedad-tabaghat", "7");
INSERT INTO `wp_postmeta` VALUES("1189", "300", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("1190", "300", "tedad-vahed-har-tabaghe", "2");
INSERT INTO `wp_postmeta` VALUES("1191", "300", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("1192", "300", "tedad-vahed-kol", "14");
INSERT INTO `wp_postmeta` VALUES("1193", "300", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("1194", "300", "lng", "");
INSERT INTO `wp_postmeta` VALUES("1195", "300", "_lat", "field_5ea5803e5226f");
INSERT INTO `wp_postmeta` VALUES("1196", "300", "lat", "");
INSERT INTO `wp_postmeta` VALUES("1197", "300", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1198", "300", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1199", "300", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1200", "300", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1201", "300", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1202", "300", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1203", "300", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("1204", "300", "data-pishforosh", "خرداد 1400");
INSERT INTO `wp_postmeta` VALUES("1205", "300", "_data-pishforosh", "field_5ec21f0ef01b0");
INSERT INTO `wp_postmeta` VALUES("1206", "300", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("1207", "300", "_lng", "field_5ea5806d52270");
INSERT INTO `wp_postmeta` VALUES("1208", "302", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("1209", "302", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1210", "302", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1211", "302", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1212", "302", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1213", "302", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1214", "302", "description", "فروش ویلا و معاوضه با ماشین");
INSERT INTO `wp_postmeta` VALUES("1215", "302", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1216", "302", "vaziat", "1");
INSERT INTO `wp_postmeta` VALUES("1217", "302", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("1218", "302", "special", "1");
INSERT INTO `wp_postmeta` VALUES("1219", "302", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("1220", "302", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("1221", "302", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("1222", "302", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("1223", "302", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("1224", "302", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("1225", "302", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("1226", "302", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("1227", "302", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("1228", "302", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("1229", "302", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("1230", "302", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("1231", "302", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("1232", "302", "moaveze", "1");
INSERT INTO `wp_postmeta` VALUES("1233", "302", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("1234", "302", "name", "علیرضایی");
INSERT INTO `wp_postmeta` VALUES("1235", "302", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("1236", "302", "address", "تهران ولنجک");
INSERT INTO `wp_postmeta` VALUES("1237", "302", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("1238", "302", "mobile", "091212121232");
INSERT INTO `wp_postmeta` VALUES("1239", "302", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("1240", "302", "email", "");
INSERT INTO `wp_postmeta` VALUES("1241", "302", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("1242", "302", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("1243", "302", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("1244", "302", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("1245", "302", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("1246", "302", "ostan", "");
INSERT INTO `wp_postmeta` VALUES("1247", "302", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("1248", "302", "shahr", "باغستان");
INSERT INTO `wp_postmeta` VALUES("1249", "302", "_shahr", "field_5be2b7acddc6d");
INSERT INTO `wp_postmeta` VALUES("1250", "302", "metrazh", "85");
INSERT INTO `wp_postmeta` VALUES("1251", "302", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("1252", "302", "masahat-zamin", "");
INSERT INTO `wp_postmeta` VALUES("1253", "302", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("1254", "302", "price-kol", "650000000");
INSERT INTO `wp_postmeta` VALUES("1255", "302", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("1256", "302", "price-metri", "150000000");
INSERT INTO `wp_postmeta` VALUES("1257", "302", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("1258", "302", "otagh", "4");
INSERT INTO `wp_postmeta` VALUES("1259", "302", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("1260", "302", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("1261", "302", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("1262", "302", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("1263", "302", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("1264", "302", "mg", "a:2:{i:0;s:10:\"شمالی\";i:1;s:8:\"شرقی\";}");
INSERT INTO `wp_postmeta` VALUES("1265", "302", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("1266", "302", "tabaghe", "10");
INSERT INTO `wp_postmeta` VALUES("1267", "302", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("1268", "302", "tedad-tabaghat", "4");
INSERT INTO `wp_postmeta` VALUES("1269", "302", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("1270", "302", "tedad-vahed-har-tabaghe", "4");
INSERT INTO `wp_postmeta` VALUES("1271", "302", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("1272", "302", "tedad-vahed-kol", "46");
INSERT INTO `wp_postmeta` VALUES("1273", "302", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("1274", "302", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("1275", "302", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("1276", "302", "nama", "آجر");
INSERT INTO `wp_postmeta` VALUES("1277", "302", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("1278", "302", "kabinet", "کابینت چوب");
INSERT INTO `wp_postmeta` VALUES("1279", "302", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("1280", "302", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("1281", "302", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1282", "302", "kafposh", "موزائیک");
INSERT INTO `wp_postmeta` VALUES("1283", "302", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("1284", "302", "simplefavorites_count", "3");
INSERT INTO `wp_postmeta` VALUES("1285", "302", "sayer-emkanat", "a:29:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:12:\"انباری\";i:4;s:10:\"شوفاژ\";i:5;s:12:\"شومینه\";i:6;s:8:\"چیلر\";i:7;s:13:\"فن کوئل\";i:8;s:8:\"پکیج\";i:9;s:8:\"کولر\";i:10;s:10:\"استخر\";i:11;s:8:\"سونا\";i:12;s:10:\"جکوزی\";i:13;s:23:\"آیفون تصویری\";i:14;s:30:\"دوربین مدار بسته\";i:15;s:17:\"درب ریموت\";i:16;s:19:\"آنتن مرکزی\";i:17;s:25:\"اینترنت مرکزی\";i:18;s:10:\"پاسیو\";i:19;s:16:\"باربیکیو\";i:20;s:10:\"بالکن\";i:21;s:8:\"حیاط\";i:22;s:8:\"لابی\";i:23;s:25:\"سالن اجتماعات\";i:24;s:16:\"سرایداری\";i:25;s:8:\"مبله\";i:26;s:19:\"اطفاء حریق\";i:27;s:23:\"شوتینگ زباله\";i:28;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("16435", "1896", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16436", "1896", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("1286", "302", "streetmap", "a:7:{s:3:\"lat\";d:35.804449099999999;s:3:\"lng\";d:51.4050078;s:4:\"zoom\";i:15;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:40:\"یاس, 19858-58962 Tehran Tajrish, Iran\";s:13:\"default_label\";s:40:\"یاس, 19858-58962 Tehran Tajrish, Iran\";s:3:\"lat\";d:35.806494499999999;s:3:\"lng\";d:51.405758900000002;}}s:7:\"address\";s:40:\"یاس, 19858-58962 Tehran Tajrish, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("1287", "302", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("1288", "302", "gallery", "a:2:{i:0;s:4:\"2007\";i:1;s:4:\"2008\";}");
INSERT INTO `wp_postmeta` VALUES("1289", "302", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("1290", "302", "_wp_old_slug", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af");
INSERT INTO `wp_postmeta` VALUES("1291", "302", "price-rahn", "150000000");
INSERT INTO `wp_postmeta` VALUES("1292", "302", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("1293", "302", "price-ejare", "200000");
INSERT INTO `wp_postmeta` VALUES("1294", "302", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("1295", "302", "_wp_old_slug", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy");
INSERT INTO `wp_postmeta` VALUES("1296", "302", "moaveze-for", "تویتا لندکروز");
INSERT INTO `wp_postmeta` VALUES("1297", "302", "_moaveze-for", "field_5eef05d1461c2");
INSERT INTO `wp_postmeta` VALUES("1298", "302", "moshaver", "26");
INSERT INTO `wp_postmeta` VALUES("1299", "302", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("1300", "302", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1301", "302", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1302", "302", "lat", "");
INSERT INTO `wp_postmeta` VALUES("1303", "302", "_lat", "field_5ea5803e5226f");
INSERT INTO `wp_postmeta` VALUES("1304", "302", "lng", "");
INSERT INTO `wp_postmeta` VALUES("1305", "302", "_lng", "field_5ea5806d52270");
INSERT INTO `wp_postmeta` VALUES("1306", "303", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1307", "303", "description", "فروش آپارتمان لب ساحل با ویو عالی");
INSERT INTO `wp_postmeta` VALUES("1308", "303", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1309", "303", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("1310", "303", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("1311", "303", "special", "0");
INSERT INTO `wp_postmeta` VALUES("1312", "303", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("1313", "303", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("1314", "303", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("1315", "303", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("1316", "303", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("1317", "303", "shahraki", "0");
INSERT INTO `wp_postmeta` VALUES("1318", "303", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("1319", "303", "luxury", "0");
INSERT INTO `wp_postmeta` VALUES("1320", "303", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("1321", "303", "saheli", "1");
INSERT INTO `wp_postmeta` VALUES("1322", "303", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("1323", "303", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("1324", "303", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("1325", "303", "moaveze", "1");
INSERT INTO `wp_postmeta` VALUES("1326", "303", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("1327", "303", "name", "علیرضایی");
INSERT INTO `wp_postmeta` VALUES("1328", "303", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("1329", "303", "address", "تهران ولنجک");
INSERT INTO `wp_postmeta` VALUES("1330", "303", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("1331", "303", "mobile", "091212121232");
INSERT INTO `wp_postmeta` VALUES("1332", "303", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("1333", "303", "email", "");
INSERT INTO `wp_postmeta` VALUES("1334", "303", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("1335", "303", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("1336", "303", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("1337", "303", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("1338", "303", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("1339", "303", "ostan", "گلستان");
INSERT INTO `wp_postmeta` VALUES("1340", "303", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("1341", "303", "shahr", "گرگان");
INSERT INTO `wp_postmeta` VALUES("1342", "303", "_shahr", "field_5be3da7d70830");
INSERT INTO `wp_postmeta` VALUES("1343", "303", "metrazh", "195");
INSERT INTO `wp_postmeta` VALUES("1344", "303", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("1345", "303", "masahat-zamin", "");
INSERT INTO `wp_postmeta` VALUES("1346", "303", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("1347", "303", "price-kol", "2000000000");
INSERT INTO `wp_postmeta` VALUES("1348", "303", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("1349", "303", "price-metri", "20000000");
INSERT INTO `wp_postmeta` VALUES("1350", "303", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("1351", "303", "otagh", "2");
INSERT INTO `wp_postmeta` VALUES("1352", "303", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("1353", "303", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("1354", "303", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("1355", "303", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("1356", "303", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("1357", "303", "mg", "a:2:{i:0;s:8:\"شرقی\";i:1;s:10:\"جنوبی\";}");
INSERT INTO `wp_postmeta` VALUES("1358", "303", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("1359", "303", "tabaghe", "10");
INSERT INTO `wp_postmeta` VALUES("1360", "303", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("1361", "303", "tedad-tabaghat", "12");
INSERT INTO `wp_postmeta` VALUES("1362", "303", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("1363", "303", "tedad-vahed-har-tabaghe", "4");
INSERT INTO `wp_postmeta` VALUES("1364", "303", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("1365", "303", "tedad-vahed-kol", "46");
INSERT INTO `wp_postmeta` VALUES("1366", "303", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("1367", "303", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("1368", "303", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("1369", "303", "nama", "شیشه");
INSERT INTO `wp_postmeta` VALUES("1370", "303", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("1371", "303", "kabinet", "کابینت جزیره");
INSERT INTO `wp_postmeta` VALUES("1372", "303", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("1373", "303", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("1374", "303", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1375", "303", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("1376", "303", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("1377", "303", "sayer-emkanat", "a:24:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:12:\"انباری\";i:4;s:10:\"شوفاژ\";i:5;s:12:\"شومینه\";i:6;s:8:\"چیلر\";i:7;s:13:\"فن کوئل\";i:8;s:8:\"پکیج\";i:9;s:8:\"کولر\";i:10;s:10:\"استخر\";i:11;s:8:\"سونا\";i:12;s:10:\"جکوزی\";i:13;s:23:\"آیفون تصویری\";i:14;s:30:\"دوربین مدار بسته\";i:15;s:17:\"درب ریموت\";i:16;s:19:\"آنتن مرکزی\";i:17;s:25:\"اینترنت مرکزی\";i:18;s:10:\"پاسیو\";i:19;s:16:\"باربیکیو\";i:20;s:10:\"بالکن\";i:21;s:8:\"حیاط\";i:22;s:8:\"مبله\";i:23;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("16474", "297", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16475", "297", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("1378", "303", "streetmap", "a:7:{s:3:\"lat\";d:36.917372;s:3:\"lng\";d:50.653109600000001;s:4:\"zoom\";i:14;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:81:\"یاسمن, 46918-96195 دهستان سخت سر Ramsar, Mazandaran Province Iran\";s:13:\"default_label\";s:81:\"یاسمن, 46918-96195 دهستان سخت سر Ramsar, Mazandaran Province Iran\";s:3:\"lat\";d:36.912964000000002;s:3:\"lng\";d:50.664825399999998;}}s:7:\"address\";s:81:\"یاسمن, 46918-96195 دهستان سخت سر Ramsar, Mazandaran Province Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("1379", "303", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("1380", "303", "gallery", "a:2:{i:0;s:4:\"4680\";i:1;s:4:\"4679\";}");
INSERT INTO `wp_postmeta` VALUES("1381", "303", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("1382", "303", "_wp_old_slug", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af");
INSERT INTO `wp_postmeta` VALUES("1383", "303", "price-rahn", "150000000");
INSERT INTO `wp_postmeta` VALUES("1384", "303", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("1385", "303", "price-ejare", "200000");
INSERT INTO `wp_postmeta` VALUES("1386", "303", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("1387", "303", "_wp_old_slug", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy");
INSERT INTO `wp_postmeta` VALUES("1388", "303", "moaveze-for", "خانه در ترکیه");
INSERT INTO `wp_postmeta` VALUES("1389", "303", "_moaveze-for", "field_5eef05d1461c2");
INSERT INTO `wp_postmeta` VALUES("1390", "303", "simplefavorites_count", "9");
INSERT INTO `wp_postmeta` VALUES("1391", "303", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1392", "303", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1393", "303", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1394", "303", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1395", "303", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1396", "303", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1397", "303", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("1398", "303", "moshaver", "26");
INSERT INTO `wp_postmeta` VALUES("1399", "303", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("13565", "4687", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("13566", "4687", "otagh", "1");
INSERT INTO `wp_postmeta` VALUES("13567", "4687", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("13568", "4687", "senbana", "10 تا 20 سال");
INSERT INTO `wp_postmeta` VALUES("13569", "4687", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("13570", "4687", "tabaghe", "");
INSERT INTO `wp_postmeta` VALUES("13571", "4687", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("13572", "4687", "tedad-tabaghat", "");
INSERT INTO `wp_postmeta` VALUES("13573", "4687", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("13574", "4687", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("13575", "4687", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("13576", "4687", "nama", "سیمان");
INSERT INTO `wp_postmeta` VALUES("13577", "4687", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("13578", "4687", "kabinet", "کابینت MDF");
INSERT INTO `wp_postmeta` VALUES("13579", "4687", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("13580", "4687", "kafposh", "پارکت");
INSERT INTO `wp_postmeta` VALUES("13581", "4687", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("13582", "4687", "mg", "a:2:{i:0;s:8:\"شرقی\";i:1;s:10:\"جنوبی\";}");
INSERT INTO `wp_postmeta` VALUES("13583", "4687", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("13584", "4687", "parking", "");
INSERT INTO `wp_postmeta` VALUES("13585", "4687", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("13586", "4687", "asansor", "");
INSERT INTO `wp_postmeta` VALUES("13587", "4687", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("13588", "4687", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("13589", "4687", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("13590", "4687", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("13591", "4687", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("13592", "4687", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("13593", "4687", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("13594", "4687", "sayer-emkanat", "a:5:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:8:\"سونا\";i:4;s:10:\"جکوزی\";}");
INSERT INTO `wp_postmeta` VALUES("13595", "4687", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("13596", "4687", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("13597", "4687", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("13598", "4687", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("13599", "4687", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("13600", "4687", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("13601", "4687", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("13602", "4687", "streetmap", "a:7:{s:3:\"lat\";d:35.687243500000001;s:3:\"lng\";d:51.377627799999999;s:4:\"zoom\";i:15;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:35:\"خجسته, 1419935164 Tehran, Iran\";s:13:\"default_label\";s:35:\"خجسته, 1419935164 Tehran, Iran\";s:3:\"lat\";d:35.688909600000002;s:3:\"lng\";d:51.376447499999998;}}s:7:\"address\";s:35:\"خجسته, 1419935164 Tehran, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("13603", "4687", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("13604", "4687", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("13605", "4687", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("13606", "4687", "gallery", "a:1:{i:0;s:4:\"5676\";}");
INSERT INTO `wp_postmeta` VALUES("13607", "4687", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("13608", "4687", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("13609", "4687", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("25163", "6368", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25159", "6367", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25162", "6368", "description", "نکته های مهم موقع خرید خانه");
INSERT INTO `wp_postmeta` VALUES("13877", "4703", "_billing_address_index", "         info@sitralweb.com ");
INSERT INTO `wp_postmeta` VALUES("13876", "4703", "_prices_include_tax", "no");
INSERT INTO `wp_postmeta` VALUES("13875", "4703", "_order_version", "5.1.0");
INSERT INTO `wp_postmeta` VALUES("13874", "4703", "_order_total", "34000");
INSERT INTO `wp_postmeta` VALUES("13873", "4703", "_order_tax", "0");
INSERT INTO `wp_postmeta` VALUES("13872", "4703", "_order_shipping_tax", "0");
INSERT INTO `wp_postmeta` VALUES("13871", "4703", "_order_currency", "IRT");
INSERT INTO `wp_postmeta` VALUES("13870", "4703", "_customer_user", "1");
INSERT INTO `wp_postmeta` VALUES("13869", "4703", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("13868", "4703", "_edit_lock", "1619772253:1");
INSERT INTO `wp_postmeta` VALUES("13549", "4687", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("13550", "4687", "ostan", "مازندران");
INSERT INTO `wp_postmeta` VALUES("13551", "4687", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("13552", "4687", "shahr", "گلوگاه");
INSERT INTO `wp_postmeta` VALUES("13553", "4687", "_shahr", "field_5ae8523bb6a32");
INSERT INTO `wp_postmeta` VALUES("13554", "4687", "metrazh", "150");
INSERT INTO `wp_postmeta` VALUES("13555", "4687", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("13556", "4687", "masahat-zamin", "200");
INSERT INTO `wp_postmeta` VALUES("13557", "4687", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("13558", "4687", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("13559", "4687", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("13560", "4687", "price-kol", "500000000");
INSERT INTO `wp_postmeta` VALUES("13561", "4687", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("13562", "4687", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("13563", "4687", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("13564", "4687", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("13095", "4678", "_wp_attached_file", "2020/05/apartment4.jpg");
INSERT INTO `wp_postmeta` VALUES("13096", "4678", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:22:\"2020/05/apartment4.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"apartment4-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"apartment4-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:22:\"apartment4-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:20:\"apartment4-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:22:\"apartment4-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:22:\"apartment4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:22:\"apartment4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1496", "305", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("1497", "305", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1498", "305", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1499", "305", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1500", "305", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1501", "305", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1502", "305", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1503", "305", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("1504", "305", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("1505", "305", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1506", "305", "description", "اجاره آپارتمان 95 متری در تهران منطقه دو");
INSERT INTO `wp_postmeta` VALUES("1507", "305", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1508", "305", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("1509", "305", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("1510", "305", "special", "0");
INSERT INTO `wp_postmeta` VALUES("1511", "305", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("1512", "305", "fast", "0");
INSERT INTO `wp_postmeta` VALUES("1513", "305", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("1514", "305", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("1515", "305", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("1516", "305", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("1517", "305", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("1518", "305", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("1519", "305", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("1520", "305", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("1521", "305", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("1522", "305", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("1523", "305", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("1524", "305", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("1525", "305", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("1526", "305", "name", "علیرضایی");
INSERT INTO `wp_postmeta` VALUES("1527", "305", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("1528", "305", "address", "تهران منطقه دو");
INSERT INTO `wp_postmeta` VALUES("1529", "305", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("1530", "305", "mobile", "091212121232");
INSERT INTO `wp_postmeta` VALUES("1531", "305", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("1532", "305", "email", "");
INSERT INTO `wp_postmeta` VALUES("1533", "305", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("1534", "305", "moamele", "رهن و اجاره");
INSERT INTO `wp_postmeta` VALUES("1535", "305", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("1536", "305", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("1537", "305", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("1538", "305", "ostan", "ایلام");
INSERT INTO `wp_postmeta` VALUES("1539", "305", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("1540", "305", "shahr", "آبدانان");
INSERT INTO `wp_postmeta` VALUES("1541", "305", "_shahr", "field_5be3da387082f");
INSERT INTO `wp_postmeta` VALUES("1542", "305", "metrazh", "85");
INSERT INTO `wp_postmeta` VALUES("1543", "305", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("1544", "305", "masahat-zamin", "");
INSERT INTO `wp_postmeta` VALUES("1545", "305", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("1546", "305", "price-kol", "800000000");
INSERT INTO `wp_postmeta` VALUES("1547", "305", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("1548", "305", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("1549", "305", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("1550", "305", "otagh", "");
INSERT INTO `wp_postmeta` VALUES("1551", "305", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("1552", "305", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("1553", "305", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("1554", "305", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("1555", "305", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("1556", "305", "mg", "a:2:{i:0;s:10:\"شمالی\";i:1;s:8:\"شرقی\";}");
INSERT INTO `wp_postmeta` VALUES("1557", "305", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("1558", "305", "tabaghe", "10");
INSERT INTO `wp_postmeta` VALUES("1559", "305", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("1560", "305", "tedad-tabaghat", "12");
INSERT INTO `wp_postmeta` VALUES("1561", "305", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("1562", "305", "tedad-vahed-har-tabaghe", "4");
INSERT INTO `wp_postmeta` VALUES("1563", "305", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("1564", "305", "tedad-vahed-kol", "46");
INSERT INTO `wp_postmeta` VALUES("1565", "305", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("1566", "305", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("1567", "305", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("1568", "305", "nama", "سنگ");
INSERT INTO `wp_postmeta` VALUES("1569", "305", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("1570", "305", "kabinet", "کابینت MDF");
INSERT INTO `wp_postmeta` VALUES("1571", "305", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("1572", "305", "wc", "ایرانی فرنگی");
INSERT INTO `wp_postmeta` VALUES("1573", "305", "_wc", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1574", "305", "kafposh", "سرامیک");
INSERT INTO `wp_postmeta` VALUES("1575", "305", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("1576", "305", "sayer-emkanat", "a:32:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:14:\"پارکینگ\";i:4;s:14:\"آسانسور\";i:5;s:12:\"انباری\";i:6;s:8:\"تلفن\";i:7;s:10:\"شوفاژ\";i:8;s:12:\"شومینه\";i:9;s:8:\"چیلر\";i:10;s:13:\"فن کوئل\";i:11;s:8:\"پکیج\";i:12;s:8:\"کولر\";i:13;s:10:\"استخر\";i:14;s:8:\"سونا\";i:15;s:10:\"جکوزی\";i:16;s:23:\"آیفون تصویری\";i:17;s:30:\"دوربین مدار بسته\";i:18;s:17:\"درب ریموت\";i:19;s:19:\"آنتن مرکزی\";i:20;s:25:\"اینترنت مرکزی\";i:21;s:10:\"پاسیو\";i:22;s:16:\"باربیکیو\";i:23;s:10:\"بالکن\";i:24;s:8:\"حیاط\";i:25;s:8:\"لابی\";i:26;s:25:\"سالن اجتماعات\";i:27;s:16:\"سرایداری\";i:28;s:8:\"مبله\";i:29;s:19:\"اطفاء حریق\";i:30;s:23:\"شوتینگ زباله\";i:31;s:6:\"وام\";}");
INSERT INTO `wp_postmeta` VALUES("27028", "6463", "_wp_attached_file", "2022/10/marker-red.png");
INSERT INTO `wp_postmeta` VALUES("1577", "305", "streetmap", "a:7:{s:3:\"lat\";d:35.632744299999999;s:3:\"lng\";d:51.436615000000003;s:4:\"zoom\";i:9;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:43:\"Vali-e Asr Street, 15178-33313 Tehran, Iran\";s:13:\"default_label\";s:43:\"Vali-e Asr Street, 15178-33313 Tehran, Iran\";s:3:\"lat\";d:35.728156800000001;s:3:\"lng\";d:51.413269;}}s:7:\"address\";s:43:\"Vali-e Asr Street, 15178-33313 Tehran, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("1578", "305", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("1579", "305", "gallery", "a:2:{i:0;s:4:\"2005\";i:1;s:4:\"4680\";}");
INSERT INTO `wp_postmeta` VALUES("1580", "305", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("1581", "305", "_wp_old_slug", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af");
INSERT INTO `wp_postmeta` VALUES("1582", "305", "price-rahn", "150000000");
INSERT INTO `wp_postmeta` VALUES("1583", "305", "_price-rahn", "field_5ae8561fe6373");
INSERT INTO `wp_postmeta` VALUES("1584", "305", "price-ejare", "200000");
INSERT INTO `wp_postmeta` VALUES("1585", "305", "_price-ejare", "field_5ae85638e6374");
INSERT INTO `wp_postmeta` VALUES("1586", "305", "simplefavorites_count", "8");
INSERT INTO `wp_postmeta` VALUES("1587", "305", "_wp_old_slug", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy-3");
INSERT INTO `wp_postmeta` VALUES("1588", "305", "lat", "37.375");
INSERT INTO `wp_postmeta` VALUES("1589", "305", "_lat", "field_5ea5803e5226f");
INSERT INTO `wp_postmeta` VALUES("1590", "305", "lng", "49.759");
INSERT INTO `wp_postmeta` VALUES("1591", "305", "_lng", "field_5ea5806d52270");
INSERT INTO `wp_postmeta` VALUES("13884", "4703", "_date_completed", "1619771389");
INSERT INTO `wp_postmeta` VALUES("13882", "4703", "_order_key", "wc_order_UaHweadfUJ4ds");
INSERT INTO `wp_postmeta` VALUES("13883", "4703", "_created_via", "admin");
INSERT INTO `wp_postmeta` VALUES("13097", "4679", "_wp_attached_file", "2020/04/apartment5.jpg");
INSERT INTO `wp_postmeta` VALUES("13098", "4679", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:22:\"2020/04/apartment5.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"apartment5-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"apartment5-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:22:\"apartment5-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:20:\"apartment5-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:22:\"apartment5-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:22:\"apartment5-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:22:\"apartment5-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("13099", "4680", "_wp_attached_file", "2020/04/apartment6.jpg");
INSERT INTO `wp_postmeta` VALUES("13100", "4680", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:22:\"2020/04/apartment6.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"apartment6-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"apartment6-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:22:\"apartment6-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:20:\"apartment6-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:22:\"apartment6-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:22:\"apartment6-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:22:\"apartment6-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment6-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10621", "3971", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:1080;s:4:\"file\";s:13:\"2020/12/2.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:15:\"2-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:13:\"2-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:13:\"2-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:11:\"2-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:13:\"2-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("13885", "4703", "_date_paid", "1619771389");
INSERT INTO `wp_postmeta` VALUES("14192", "4734", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1258;s:4:\"file\";s:22:\"2021/06/596-scaled.jpg\";s:5:\"sizes\";a:15:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"596-300x147.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:16:\"596-1024x503.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:503;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"596-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"596-768x377.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:377;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:16:\"596-1536x755.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:755;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:17:\"596-2048x1006.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1006;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:15:\"596-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:13:\"596-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:15:\"596-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:15:\"596-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:15:\"596-600x295.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:15:\"596-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"596-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"596-600x295.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"596-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:114:\"Vector pop art illustration of a man and a woman sitting at a negotiation table top view, concept of brainstorming\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:88:\"Vector pop art illustration of a man and a woman sitting at a negotiation table top view\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:50:{i:0;s:7:\"pop art\";i:1;s:6:\"vector\";i:2;s:10:\"discussion\";i:3;s:12:\"professional\";i:4;s:6:\"people\";i:5;s:11:\"negotiation\";i:6;s:4:\"desk\";i:7;s:7:\"meeting\";i:8;s:8:\"contract\";i:9;s:5:\"table\";i:10;s:8:\"business\";i:11;s:4:\"team\";i:12;s:8:\"teamwork\";i:13;s:9:\"corporate\";i:14;s:12:\"illustration\";i:15;s:6:\"laptop\";i:16;s:6:\"leader\";i:17;s:6:\"office\";i:18;s:5:\"group\";i:19;s:10:\"negotiator\";i:20;s:13:\"communication\";i:21;s:11:\"businessman\";i:22;s:10:\"brainstorm\";i:23;s:9:\"character\";i:24;s:8:\"interior\";i:25;s:9:\"workplace\";i:26;s:7:\"company\";i:27;s:7:\"success\";i:28;s:8:\"briefing\";i:29;s:6:\"person\";i:30;s:4:\"plan\";i:31;s:7:\"concept\";i:32;s:11:\"partnership\";i:33;s:7:\"sitting\";i:34;s:4:\"work\";i:35;s:4:\"hand\";i:36;s:5:\"woman\";i:37;s:3:\"man\";i:38;s:11:\"corporation\";i:39;s:8:\"solution\";i:40;s:8:\"template\";i:41;s:10:\"conference\";i:42;s:7:\"partner\";i:43;s:6:\"report\";i:44;s:3:\"job\";i:45;s:6:\"design\";i:46;s:8:\"strategy\";i:47;s:6:\"career\";i:48;s:3:\"top\";i:49;s:4:\"view\";}}s:14:\"original_image\";s:7:\"596.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("14191", "4734", "_wp_attached_file", "2021/06/596-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("27653", "6526", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("25267", "6373", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:854;s:4:\"file\";s:31:\"2022/05/3146723190705202102.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"3146723190705202102-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"3146723190705202102-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"3146723190705202102-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"3146723190705202102-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:31:\"3146723190705202102-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:29:\"3146723190705202102-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:31:\"3146723190705202102-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("25266", "6373", "_wp_attached_file", "2022/05/3146723190705202102.jpg");
INSERT INTO `wp_postmeta` VALUES("1681", "1896", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("1682", "1896", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1683", "1896", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("1684", "1896", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("1685", "1896", "special", "1");
INSERT INTO `wp_postmeta` VALUES("1686", "1896", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("1687", "1896", "fast", "1");
INSERT INTO `wp_postmeta` VALUES("1688", "1896", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("1689", "1896", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("1690", "1896", "streetmap", "a:7:{s:3:\"lat\";d:35.442176600000003;s:3:\"lng\";d:51.569695500000002;s:4:\"zoom\";i:16;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:61:\"مهدیه ۴, دهستان قشلاق جیتو Qarchak, Iran\";s:13:\"default_label\";s:61:\"مهدیه ۴, دهستان قشلاق جیتو Qarchak, Iran\";s:3:\"lat\";d:35.441721999999999;s:3:\"lng\";d:51.568987399999997;}}s:7:\"address\";s:61:\"مهدیه ۴, دهستان قشلاق جیتو Qarchak, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("1691", "1896", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("1692", "1896", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1693", "1896", "description", "");
INSERT INTO `wp_postmeta` VALUES("1694", "1896", "shahraki", "0");
INSERT INTO `wp_postmeta` VALUES("1695", "1896", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("1696", "1896", "luxury", "0");
INSERT INTO `wp_postmeta` VALUES("1697", "1896", "_luxury", "field_5bdede649e639");
INSERT INTO `wp_postmeta` VALUES("1698", "1896", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("1699", "1896", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("1700", "1896", "pishforosh", "1");
INSERT INTO `wp_postmeta` VALUES("1701", "1896", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("1702", "1896", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("1703", "1896", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("1704", "1896", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("1705", "1896", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("1706", "1896", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1707", "1896", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1708", "1896", "name", "اقای یوسفی");
INSERT INTO `wp_postmeta` VALUES("1709", "1896", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("1710", "1896", "address", "قرچک");
INSERT INTO `wp_postmeta` VALUES("1711", "1896", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("1712", "1896", "mobile", "0911");
INSERT INTO `wp_postmeta` VALUES("1713", "1896", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("1714", "1896", "email", "");
INSERT INTO `wp_postmeta` VALUES("1715", "1896", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("1716", "1896", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("1717", "1896", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("1718", "1896", "melk", "زمین");
INSERT INTO `wp_postmeta` VALUES("1719", "1896", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("1720", "1896", "ostan", "تهران");
INSERT INTO `wp_postmeta` VALUES("1721", "1896", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("1722", "1896", "shahr", "قرچک");
INSERT INTO `wp_postmeta` VALUES("1723", "1896", "_shahr", "field_5be2b7acddc6d");
INSERT INTO `wp_postmeta` VALUES("1724", "1896", "metrazh", "250");
INSERT INTO `wp_postmeta` VALUES("1725", "1896", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("1726", "1896", "price-kol", "1000000000");
INSERT INTO `wp_postmeta` VALUES("1727", "1896", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("1728", "1896", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("1729", "1896", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("1730", "1896", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("1731", "1896", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("1732", "1896", "mg", "a:4:{i:0;s:10:\"شمالی\";i:1;s:8:\"شرقی\";i:2;s:10:\"جنوبی\";i:3;s:11:\"سه نبش\";}");
INSERT INTO `wp_postmeta` VALUES("1733", "1896", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("1734", "1896", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1735", "1896", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1736", "1896", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1737", "1896", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1738", "1896", "sayer-emkanat", "a:4:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:11:\"آب چاه\";}");
INSERT INTO `wp_postmeta` VALUES("1739", "1896", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("1740", "1896", "lat", "");
INSERT INTO `wp_postmeta` VALUES("1741", "1896", "_lat", "field_5ea5803e5226f");
INSERT INTO `wp_postmeta` VALUES("1742", "1896", "lng", "");
INSERT INTO `wp_postmeta` VALUES("1743", "1896", "_lng", "field_5ea5806d52270");
INSERT INTO `wp_postmeta` VALUES("1744", "1896", "gallery", "a:1:{i:0;s:4:\"2001\";}");
INSERT INTO `wp_postmeta` VALUES("1745", "1896", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("2770", "2288", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("2769", "2288", "sayer-emkanat", "a:27:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:10:\"شوفاژ\";i:4;s:12:\"شومینه\";i:5;s:8:\"چیلر\";i:6;s:13:\"فن کوئل\";i:7;s:8:\"پکیج\";i:8;s:8:\"کولر\";i:9;s:10:\"استخر\";i:10;s:8:\"سونا\";i:11;s:10:\"جکوزی\";i:12;s:23:\"آیفون تصویری\";i:13;s:30:\"دوربین مدار بسته\";i:14;s:17:\"درب ریموت\";i:15;s:19:\"آنتن مرکزی\";i:16;s:25:\"اینترنت مرکزی\";i:17;s:10:\"پاسیو\";i:18;s:16:\"باربیکیو\";i:19;s:10:\"بالکن\";i:20;s:8:\"حیاط\";i:21;s:8:\"لابی\";i:22;s:25:\"سالن اجتماعات\";i:23;s:16:\"سرایداری\";i:24;s:8:\"مبله\";i:25;s:19:\"اطفاء حریق\";i:26;s:23:\"شوتینگ زباله\";}");
INSERT INTO `wp_postmeta` VALUES("2768", "2288", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("2767", "2288", "asansor", "ندارد");
INSERT INTO `wp_postmeta` VALUES("2766", "2288", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("2765", "2288", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("2764", "2288", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("2763", "2288", "mg", "");
INSERT INTO `wp_postmeta` VALUES("2762", "2288", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("2761", "2288", "kafposh", "");
INSERT INTO `wp_postmeta` VALUES("2760", "2288", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("2759", "2288", "kabinet", "");
INSERT INTO `wp_postmeta` VALUES("2758", "2288", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("2757", "2288", "nama", "مدرن");
INSERT INTO `wp_postmeta` VALUES("2756", "2288", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("2755", "2288", "sokonat", "");
INSERT INTO `wp_postmeta` VALUES("2754", "2288", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("2753", "2288", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("2752", "2288", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("2751", "2288", "sanad", "شخصی");
INSERT INTO `wp_postmeta` VALUES("2743", "2288", "masahat-zamin", "750");
INSERT INTO `wp_postmeta` VALUES("2744", "2288", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("2745", "2288", "price-shabi", "720000");
INSERT INTO `wp_postmeta` VALUES("2746", "2288", "_price-shabi", "field_5ee4c65aef420");
INSERT INTO `wp_postmeta` VALUES("2747", "2288", "price-tatilat", "1200000");
INSERT INTO `wp_postmeta` VALUES("2748", "2288", "_price-tatilat", "field_5ee4c67aef421");
INSERT INTO `wp_postmeta` VALUES("2749", "2288", "otagh", "3");
INSERT INTO `wp_postmeta` VALUES("2750", "2288", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("2742", "2288", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("2727", "2288", "address", "کیش ، خیابان هدیه ، کوچه قاسمی ، پلاک 2");
INSERT INTO `wp_postmeta` VALUES("2728", "2288", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("2729", "2288", "mobile", "1200000");
INSERT INTO `wp_postmeta` VALUES("2730", "2288", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("2731", "2288", "email", "");
INSERT INTO `wp_postmeta` VALUES("2732", "2288", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("2733", "2288", "moamele", "اجاره روزانه");
INSERT INTO `wp_postmeta` VALUES("2734", "2288", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("2735", "2288", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("2736", "2288", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("2737", "2288", "ostan", "مازندران");
INSERT INTO `wp_postmeta` VALUES("2738", "2288", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("2739", "2288", "shahr", "رامسر");
INSERT INTO `wp_postmeta` VALUES("2740", "2288", "_shahr", "field_5ae8523bb6a32");
INSERT INTO `wp_postmeta` VALUES("2741", "2288", "metrazh", "300");
INSERT INTO `wp_postmeta` VALUES("2726", "2288", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("2725", "2288", "name", "ناظریان");
INSERT INTO `wp_postmeta` VALUES("2724", "2288", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("2723", "2288", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("2722", "2288", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("2721", "2288", "moshaver", "2");
INSERT INTO `wp_postmeta` VALUES("2720", "2288", "_moaveze", "field_5bf2b3c79dc71");
INSERT INTO `wp_postmeta` VALUES("2719", "2288", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("2718", "2288", "_pishforosh", "field_5bdb368a3bae5");
INSERT INTO `wp_postmeta` VALUES("2717", "2288", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("2716", "2288", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("2715", "2288", "saheli", "0");
INSERT INTO `wp_postmeta` VALUES("2712", "2288", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("2713", "2288", "luxury", "1");
INSERT INTO `wp_postmeta` VALUES("2714", "2288", "_luxury", "field_5eef0b27f73b5");
INSERT INTO `wp_postmeta` VALUES("21525", "27", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:8:\"havekadr\";}");
INSERT INTO `wp_postmeta` VALUES("13106", "4683", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:17:\"2020/04/vila3.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"vila3-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"vila3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"vila3-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:17:\"vila3-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:15:\"vila3-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:17:\"vila3-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:17:\"vila3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:17:\"vila3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:17:\"vila3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:17:\"vila3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("12130", "290", "simplefavorites_count", "1");
INSERT INTO `wp_postmeta` VALUES("12131", "4378", "_wp_attached_file", "2021/01/WhatsApp-Image-2021-01-18-at-12.07.41.jpeg");
INSERT INTO `wp_postmeta` VALUES("12132", "4378", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1050;s:6:\"height\";i:593;s:4:\"file\";s:50:\"2021/01/WhatsApp-Image-2021-01-18-at-12.07.41.jpeg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:50:\"WhatsApp-Image-2021-01-18-at-12.07.41-300x169.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:51:\"WhatsApp-Image-2021-01-18-at-12.07.41-1024x578.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:578;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:50:\"WhatsApp-Image-2021-01-18-at-12.07.41-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:50:\"WhatsApp-Image-2021-01-18-at-12.07.41-768x434.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:434;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:50:\"WhatsApp-Image-2021-01-18-at-12.07.41-370x250.jpeg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:48:\"WhatsApp-Image-2021-01-18-at-12.07.41-76x61.jpeg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:50:\"WhatsApp-Image-2021-01-18-at-12.07.41-262x190.jpeg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("13863", "4702", "_new_order_email_sent", "true");
INSERT INTO `wp_postmeta` VALUES("13845", "4702", "_order_version", "5.1.0");
INSERT INTO `wp_postmeta` VALUES("2772", "2288", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("2773", "2288", "gallery", "");
INSERT INTO `wp_postmeta` VALUES("2774", "2288", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("13862", "4702", "_order_stock_reduced", "yes");
INSERT INTO `wp_postmeta` VALUES("2771", "2288", "streetmap", "a:7:{s:3:\"lat\";d:26.528950900000002;s:3:\"lng\";d:53.968191099999999;s:4:\"zoom\";i:13;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:55:\"Hormozgan, دهستان کیش, Hormozgan Province Iran\";s:13:\"default_label\";s:55:\"Hormozgan, دهستان کیش, Hormozgan Province Iran\";s:3:\"lat\";d:26.543847899999999;s:3:\"lng\";d:54.0060425;}}s:7:\"address\";s:55:\"Hormozgan, دهستان کیش, Hormozgan Province Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("1918", "1995", "_wp_attached_file", "2018/11/35ef17ff11e54f75ba0218445aa74c0c.jpeg");
INSERT INTO `wp_postmeta` VALUES("1915", "232", "_edit_lock", "1670670331:1");
INSERT INTO `wp_postmeta` VALUES("1916", "230", "_edit_lock", "1640862750:1");
INSERT INTO `wp_postmeta` VALUES("1917", "228", "_edit_lock", "1590842147:1");
INSERT INTO `wp_postmeta` VALUES("1902", "228", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1903", "228", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1904", "228", "description", "");
INSERT INTO `wp_postmeta` VALUES("1905", "230", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1906", "230", "description", "");
INSERT INTO `wp_postmeta` VALUES("1907", "230", "_thumbnail_id", "1997");
INSERT INTO `wp_postmeta` VALUES("1908", "230", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1909", "230", "simplefavorites_count", "3");
INSERT INTO `wp_postmeta` VALUES("1910", "232", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1911", "232", "description", "نکته های مهم موقع خرید خانه");
INSERT INTO `wp_postmeta` VALUES("1912", "232", "_thumbnail_id", "1995");
INSERT INTO `wp_postmeta` VALUES("1913", "232", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1914", "232", "simplefavorites_count", "9");
INSERT INTO `wp_postmeta` VALUES("1924", "1997", "_wp_attached_file", "2018/11/5327296.jpg");
INSERT INTO `wp_postmeta` VALUES("1922", "1996", "description", "نکته های مهم موقع خرید خانه");
INSERT INTO `wp_postmeta` VALUES("1923", "1996", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1925", "1997", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:600;s:4:\"file\";s:19:\"2018/11/5327296.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"5327296-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"5327296-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"5327296-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:19:\"5327296-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:17:\"5327296-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:19:\"5327296-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1930", "1999", "_wp_attached_file", "2018/11/What-is-Real-Estate.jpeg");
INSERT INTO `wp_postmeta` VALUES("1928", "1998", "description", "");
INSERT INTO `wp_postmeta` VALUES("1929", "1998", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1931", "1999", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:400;s:4:\"file\";s:32:\"2018/11/What-is-Real-Estate.jpeg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"What-is-Real-Estate-300x133.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:133;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"What-is-Real-Estate-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"What-is-Real-Estate-768x341.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:341;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:32:\"What-is-Real-Estate-370x250.jpeg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:30:\"What-is-Real-Estate-76x61.jpeg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:32:\"What-is-Real-Estate-262x190.jpeg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:8:\"Bigstock\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1932", "228", "_thumbnail_id", "1999");
INSERT INTO `wp_postmeta` VALUES("1937", "1896", "_edit_lock", "1656422516:1");
INSERT INTO `wp_postmeta` VALUES("1935", "2000", "description", "");
INSERT INTO `wp_postmeta` VALUES("1936", "2000", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("1938", "2001", "_wp_attached_file", "2020/05/zamin-1.jpeg");
INSERT INTO `wp_postmeta` VALUES("1939", "2001", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:700;s:4:\"file\";s:20:\"2020/05/zamin-1.jpeg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"zamin-1-300x205.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"zamin-1-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"zamin-1-768x525.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:525;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:20:\"zamin-1-370x250.jpeg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:18:\"zamin-1-76x61.jpeg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:20:\"zamin-1-262x190.jpeg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:20:\"zamin-1-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:20:\"zamin-1-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"zamin-1-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"zamin-1-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1941", "300", "_edit_lock", "1662457570:1");
INSERT INTO `wp_postmeta` VALUES("1942", "2002", "_wp_attached_file", "2020/05/apartment-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1943", "2002", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1191;s:6:\"height\";i:1190;s:4:\"file\";s:23:\"2020/05/apartment-1.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"apartment-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"apartment-1-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"apartment-1-768x767.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:767;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:23:\"apartment-1-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:21:\"apartment-1-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:23:\"apartment-1-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1944", "300", "streetmap", "a:7:{s:3:\"lat\";d:35.737455799999999;s:3:\"lng\";d:51.569673999999999;s:4:\"zoom\";i:15;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:31:\"دوم, 1658756911 Tehran, Iran\";s:13:\"default_label\";s:31:\"دوم, 1658756911 Tehran, Iran\";s:3:\"lat\";d:35.738117699999997;s:3:\"lng\";d:51.569223399999998;}}s:7:\"address\";s:31:\"دوم, 1658756911 Tehran, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("1945", "300", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("14101", "4715", "_price", "12000000");
INSERT INTO `wp_postmeta` VALUES("14100", "4715", "_product_version", "5.2.2");
INSERT INTO `wp_postmeta` VALUES("14099", "4715", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("14098", "4715", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("14097", "4715", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("14096", "4715", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("14094", "4715", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("14093", "4715", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("14014", "4706", "_price", "59000");
INSERT INTO `wp_postmeta` VALUES("14015", "4706", "_price", "59000");
INSERT INTO `wp_postmeta` VALUES("14016", "4706", "_price", "59000");
INSERT INTO `wp_postmeta` VALUES("1952", "305", "_edit_lock", "1665220583:1");
INSERT INTO `wp_postmeta` VALUES("1953", "303", "_edit_lock", "1665220584:1");
INSERT INTO `wp_postmeta` VALUES("1954", "2005", "_wp_attached_file", "2020/04/apartment-4.jpg");
INSERT INTO `wp_postmeta` VALUES("1955", "2005", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1152;s:6:\"height\";i:810;s:4:\"file\";s:23:\"2020/04/apartment-4.jpg\";s:5:\"sizes\";a:11:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"apartment-4-300x211.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:211;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"apartment-4-1024x720.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"apartment-4-768x540.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:23:\"apartment-4-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:21:\"apartment-4-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:23:\"apartment-4-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:23:\"apartment-4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:23:\"apartment-4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1958", "302", "_edit_lock", "1665220728:1");
INSERT INTO `wp_postmeta` VALUES("1959", "2007", "_wp_attached_file", "2020/04/vila-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1960", "2007", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:480;s:4:\"file\";s:18:\"2020/04/vila-1.jpg\";s:5:\"sizes\";a:9:{s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"vila-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:18:\"vila-1-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:16:\"vila-1-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:18:\"vila-1-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:18:\"vila-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"vila-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1961", "2008", "_wp_attached_file", "2020/04/vila-2.jpg");
INSERT INTO `wp_postmeta` VALUES("1962", "2008", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:341;s:4:\"file\";s:18:\"2020/04/vila-2.jpg\";s:5:\"sizes\";a:9:{s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"vila-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:18:\"vila-2-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:16:\"vila-2-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:18:\"vila-2-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:18:\"vila-2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"vila-2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1963", "296", "_edit_lock", "1646244800:1");
INSERT INTO `wp_postmeta` VALUES("1964", "296", "streetmap", "a:7:{s:3:\"lat\";d:36.818080199999997;s:3:\"lng\";d:50.8772564;s:4:\"zoom\";i:14;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:81:\"انقلاب, 46181 دهستان گلیجان Tonekabon, Mazandaran Province Iran\";s:13:\"default_label\";s:81:\"انقلاب, 46181 دهستان گلیجان Tonekabon, Mazandaran Province Iran\";s:3:\"lat\";d:36.817942799999997;s:3:\"lng\";d:50.872363999999997;}}s:7:\"address\";s:81:\"انقلاب, 46181 دهستان گلیجان Tonekabon, Mazandaran Province Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("1965", "296", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("1966", "297", "_edit_lock", "1656415658:1");
INSERT INTO `wp_postmeta` VALUES("1967", "2009", "_wp_attached_file", "2020/04/apartment-6-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("1968", "2009", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:2132;s:4:\"file\";s:30:\"2020/04/apartment-6-scaled.jpg\";s:5:\"sizes\";a:4:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:30:\"apartment-6-scaled-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:30:\"apartment-6-scaled-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:30:\"apartment-6-scaled-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:30:\"apartment-6-scaled-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1969", "2010", "_wp_attached_file", "2020/04/apartment-7.jpg");
INSERT INTO `wp_postmeta` VALUES("1970", "2010", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:425;s:4:\"file\";s:23:\"2020/04/apartment-7.jpg\";s:5:\"sizes\";a:9:{s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"apartment-7-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:23:\"apartment-7-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:21:\"apartment-7-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:23:\"apartment-7-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:23:\"apartment-7-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:23:\"apartment-7-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-7-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1971", "285", "_edit_lock", "1665220667:1");
INSERT INTO `wp_postmeta` VALUES("1972", "294", "_edit_lock", "1665220729:1");
INSERT INTO `wp_postmeta` VALUES("1973", "290", "_edit_lock", "1665220730:1");
INSERT INTO `wp_postmeta` VALUES("13105", "4683", "_wp_attached_file", "2020/04/vila3.jpg");
INSERT INTO `wp_postmeta` VALUES("1976", "2012", "_wp_attached_file", "2020/04/vila-8.jpg");
INSERT INTO `wp_postmeta` VALUES("1977", "2012", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:768;s:6:\"height\";i:567;s:4:\"file\";s:18:\"2020/04/vila-8.jpg\";s:5:\"sizes\";a:4:{s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"vila-8-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:18:\"vila-8-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1978", "294", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("1979", "294", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("1980", "294", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1981", "294", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1982", "294", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1983", "294", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1984", "294", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1985", "294", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1987", "294", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("1988", "290", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("1989", "290", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("1990", "290", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("1991", "290", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("1992", "290", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("1993", "290", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("1994", "290", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("1995", "290", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("1997", "290", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("1998", "221", "_edit_lock", "1665220807:1");
INSERT INTO `wp_postmeta` VALUES("1999", "214", "_edit_lock", "1685714995:1");
INSERT INTO `wp_postmeta` VALUES("2000", "212", "_edit_lock", "1665220697:1");
INSERT INTO `wp_postmeta` VALUES("2001", "2013", "_wp_attached_file", "2018/11/vila-4.jpg");
INSERT INTO `wp_postmeta` VALUES("2002", "2013", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:750;s:6:\"height\";i:391;s:4:\"file\";s:18:\"2018/11/vila-4.jpg\";s:5:\"sizes\";a:9:{s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"vila-4-300x156.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:156;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:18:\"vila-4-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:16:\"vila-4-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:18:\"vila-4-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:18:\"vila-4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"vila-4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"vila-4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2007", "221", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("2008", "221", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("2009", "221", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("2010", "221", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("2012", "221", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("2013", "214", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("2014", "214", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("2015", "214", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("2016", "214", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("2017", "214", "moaveze", "0");
INSERT INTO `wp_postmeta` VALUES("2018", "214", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("2019", "214", "moshaver", "211");
INSERT INTO `wp_postmeta` VALUES("2020", "214", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("2021", "214", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("2022", "214", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("2023", "214", "otagh", "4");
INSERT INTO `wp_postmeta` VALUES("2024", "214", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("2025", "214", "parking", "دارد");
INSERT INTO `wp_postmeta` VALUES("2026", "214", "_parking", "field_5aea8c93e4f0e");
INSERT INTO `wp_postmeta` VALUES("2027", "214", "asansor", "دارد");
INSERT INTO `wp_postmeta` VALUES("2028", "214", "_asansor", "field_5eb176915c011");
INSERT INTO `wp_postmeta` VALUES("2029", "214", "streetmap", "a:7:{s:3:\"lat\";d:36.709439699999997;s:3:\"lng\";d:51.187748900000003;s:4:\"zoom\";i:14;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:109:\"کوچه فرشته, 46718-79988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:13:\"default_label\";s:109:\"کوچه فرشته, 46718-79988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:3:\"lat\";d:36.709095699999999;s:3:\"lng\";d:51.188220999999999;}}s:7:\"address\";s:109:\"کوچه فرشته, 46718-79988 دهستان کلارآبادغربی Salman Shahr, Mazandaran Province Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("2030", "214", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("13861", "4702", "_recorded_coupon_usage_counts", "yes");
INSERT INTO `wp_postmeta` VALUES("2032", "223", "_edit_lock", "1665220667:1");
INSERT INTO `wp_postmeta` VALUES("13881", "4703", "_order_shipping", "0");
INSERT INTO `wp_postmeta` VALUES("2033", "2017", "_wp_attached_file", "2018/11/apartment-8.jpg");
INSERT INTO `wp_postmeta` VALUES("2034", "2017", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:600;s:4:\"file\";s:23:\"2018/11/apartment-8.jpg\";s:5:\"sizes\";a:4:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:23:\"apartment-8-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:23:\"apartment-8-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:23:\"apartment-8-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2035", "223", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("2036", "223", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("2037", "223", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("2038", "223", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("2039", "223", "tabaghe", "");
INSERT INTO `wp_postmeta` VALUES("2040", "223", "_tabaghe", "field_5b0ff93753c4e");
INSERT INTO `wp_postmeta` VALUES("2041", "223", "streetmap", "a:7:{s:3:\"lat\";d:35.817952400000003;s:3:\"lng\";d:51.630978599999999;s:4:\"zoom\";i:14;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:47:\"پرواز ۵, 3343181839 Lavasan Lavasan, Iran\";s:13:\"default_label\";s:47:\"پرواز ۵, 3343181839 Lavasan Lavasan, Iran\";s:3:\"lat\";d:35.816421200000001;s:3:\"lng\";d:51.628360700000002;}}s:7:\"address\";s:47:\"پرواز ۵, 3343181839 Lavasan Lavasan, Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("2042", "223", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("2043", "2019", "description", "");
INSERT INTO `wp_postmeta` VALUES("2044", "2019", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("2045", "2020", "_wp_attached_file", "2020/05/me.jpeg");
INSERT INTO `wp_postmeta` VALUES("2046", "2020", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:1080;s:4:\"file\";s:15:\"2020/05/me.jpeg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"me-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:17:\"me-1024x1024.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"me-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"me-768x768.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:15:\"me-370x250.jpeg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:13:\"me-76x61.jpeg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:15:\"me-262x190.jpeg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2047", "2021", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2048", "2021", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2049", "2022", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2.jpg");
INSERT INTO `wp_postmeta` VALUES("2050", "2022", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2051", "2023", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3.jpg");
INSERT INTO `wp_postmeta` VALUES("2052", "2023", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2053", "2024", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4.jpg");
INSERT INTO `wp_postmeta` VALUES("2054", "2024", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2055", "2025", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5.jpg");
INSERT INTO `wp_postmeta` VALUES("2056", "2025", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2057", "2026", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6.jpg");
INSERT INTO `wp_postmeta` VALUES("2058", "2026", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2059", "2027", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7.jpg");
INSERT INTO `wp_postmeta` VALUES("2060", "2027", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2061", "2028", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8.jpg");
INSERT INTO `wp_postmeta` VALUES("2062", "2028", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2063", "2029", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9.jpg");
INSERT INTO `wp_postmeta` VALUES("2064", "2029", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:960;s:4:\"file\";s:77:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:75:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:77:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2065", "2030", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10.jpg");
INSERT INTO `wp_postmeta` VALUES("2066", "2030", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:78:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:76:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2067", "2031", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11.jpg");
INSERT INTO `wp_postmeta` VALUES("2068", "2031", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:78:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:76:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2069", "2032", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12.jpg");
INSERT INTO `wp_postmeta` VALUES("2070", "2032", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:78:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:76:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2071", "2033", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13.jpg");
INSERT INTO `wp_postmeta` VALUES("2072", "2033", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:78:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:76:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2073", "2034", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14.jpg");
INSERT INTO `wp_postmeta` VALUES("2074", "2034", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:78:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:76:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2075", "2035", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15.jpg");
INSERT INTO `wp_postmeta` VALUES("2076", "2035", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:78:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:76:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2077", "2036", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16.jpg");
INSERT INTO `wp_postmeta` VALUES("2078", "2036", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:78:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:76:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2079", "2037", "_wp_attached_file", "2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17.jpg");
INSERT INTO `wp_postmeta` VALUES("2080", "2037", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1280;s:4:\"file\";s:78:\"2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:79:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:76:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:78:\"خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14017", "4706", "_price", "59000");
INSERT INTO `wp_postmeta` VALUES("14018", "4706", "_price", "59000");
INSERT INTO `wp_postmeta` VALUES("14019", "4706", "_edit_lock", "1619880342:1");
INSERT INTO `wp_postmeta` VALUES("14020", "4706", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("14021", "4706", "_thumbnail_id", "4681");
INSERT INTO `wp_postmeta` VALUES("14022", "4706", "_wp_old_slug", "%d9%85%d8%ad%d8%b5%d9%88%d9%84-%d9%85%d9%86");
INSERT INTO `wp_postmeta` VALUES("14023", "4706", "_regular_price", "59000");
INSERT INTO `wp_postmeta` VALUES("2711", "2288", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("2710", "2288", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("2709", "2288", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("2708", "2288", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("2703", "2288", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("2704", "2288", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("2705", "2288", "special", "1");
INSERT INTO `wp_postmeta` VALUES("2706", "2288", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("2707", "2288", "fast", "0");
INSERT INTO `wp_postmeta` VALUES("2699", "2288", "_edit_lock", "1653726668:1");
INSERT INTO `wp_postmeta` VALUES("2700", "2288", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2701", "2288", "description", "");
INSERT INTO `wp_postmeta` VALUES("2702", "2288", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("5105", "2834", "_wp_attached_file", "2020/07/829.png");
INSERT INTO `wp_postmeta` VALUES("5106", "2834", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:820;s:6:\"height\";i:304;s:4:\"file\";s:15:\"2020/07/829.png\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"829-300x111.png\";s:5:\"width\";i:300;s:6:\"height\";i:111;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"829-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:15:\"829-768x285.png\";s:5:\"width\";i:768;s:6:\"height\";i:285;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:15:\"829-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:13:\"829-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:15:\"829-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14042", "4712", "_prices_include_tax", "no");
INSERT INTO `wp_postmeta` VALUES("14043", "4712", "_billing_address_index", "         sd@yahoo.com ");
INSERT INTO `wp_postmeta` VALUES("13102", "4681", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:17:\"2020/04/vila5.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"vila5-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"vila5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"vila5-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:17:\"vila5-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:15:\"vila5-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:17:\"vila5-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:17:\"vila5-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:17:\"vila5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:17:\"vila5-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:17:\"vila5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2973", "290", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("2970", "290", "num-hamam", "2");
INSERT INTO `wp_postmeta` VALUES("2971", "290", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("2972", "290", "num-wc", "1");
INSERT INTO `wp_postmeta` VALUES("2965", "290", "_tahol", "field_5eeef989e2bc3");
INSERT INTO `wp_postmeta` VALUES("2966", "290", "darbast", "هست");
INSERT INTO `wp_postmeta` VALUES("2967", "290", "_darbast", "field_5eeefcb7e2bcc");
INSERT INTO `wp_postmeta` VALUES("2968", "290", "nafarat", "15");
INSERT INTO `wp_postmeta` VALUES("2969", "290", "_nafarat", "field_5eeefce1e2bcd");
INSERT INTO `wp_postmeta` VALUES("2964", "290", "tahol", "خانواده و مجرد");
INSERT INTO `wp_postmeta` VALUES("2963", "290", "_tabdil", "field_5ee4c5caef41f");
INSERT INTO `wp_postmeta` VALUES("2962", "290", "tabdil", "دارد");
INSERT INTO `wp_postmeta` VALUES("2961", "212", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("2960", "212", "tedad-tabaghat", "");
INSERT INTO `wp_postmeta` VALUES("2959", "214", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("2958", "214", "tedad-tabaghat", "");
INSERT INTO `wp_postmeta` VALUES("2957", "296", "_tahvil", "field_5eef05ad461c0");
INSERT INTO `wp_postmeta` VALUES("2956", "296", "tahvil", "99/12/1");
INSERT INTO `wp_postmeta` VALUES("2953", "2288", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("2955", "2288", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("2954", "2288", "tedad-tabaghat", "2");
INSERT INTO `wp_postmeta` VALUES("2952", "2288", "num-wc", "2");
INSERT INTO `wp_postmeta` VALUES("2951", "2288", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("2950", "2288", "num-hamam", "2");
INSERT INTO `wp_postmeta` VALUES("2949", "2288", "_nafarat", "field_5eeefce1e2bcd");
INSERT INTO `wp_postmeta` VALUES("2948", "2288", "nafarat", "15");
INSERT INTO `wp_postmeta` VALUES("2947", "2288", "_darbast", "field_5eeefcb7e2bcc");
INSERT INTO `wp_postmeta` VALUES("2946", "2288", "darbast", "هست");
INSERT INTO `wp_postmeta` VALUES("2945", "2288", "_tahol", "field_5eeef989e2bc3");
INSERT INTO `wp_postmeta` VALUES("6790", "2288", "ostan_cat", "5");
INSERT INTO `wp_postmeta` VALUES("2944", "2288", "tahol", "خانواده و مجرد");
INSERT INTO `wp_postmeta` VALUES("5667", "2848", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:180;s:6:\"height\";i:75;s:4:\"file\";s:17:\"2020/05/logo3.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo3-150x75.png\";s:5:\"width\";i:150;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:15:\"logo3-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5666", "2848", "_wp_attached_file", "2020/05/logo3.png");
INSERT INTO `wp_postmeta` VALUES("11202", "303", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11201", "303", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11200", "303", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("11199", "303", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("5663", "2846", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("14103", "4715", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("11195", "300", "video", "");
INSERT INTO `wp_postmeta` VALUES("11196", "300", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("4264", "2569", "_wp_attached_file", "2020/06/رسید-خرید-مودم-از-ایرانسل.png");
INSERT INTO `wp_postmeta` VALUES("4265", "2569", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:900;s:4:\"file\";s:58:\"2020/06/رسید-خرید-مودم-از-ایرانسل.png\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:58:\"رسید-خرید-مودم-از-ایرانسل-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:59:\"رسید-خرید-مودم-از-ایرانسل-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"رسید-خرید-مودم-از-ایرانسل-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:58:\"رسید-خرید-مودم-از-ایرانسل-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:59:\"رسید-خرید-مودم-از-ایرانسل-1536x864.png\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:58:\"رسید-خرید-مودم-از-ایرانسل-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:56:\"رسید-خرید-مودم-از-ایرانسل-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:58:\"رسید-خرید-مودم-از-ایرانسل-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6536", "3105", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1040;s:6:\"height\";i:780;s:4:\"file\";s:52:\"2020/08/WhatsApp-Image-2020-04-17-at-2.46.55-AM.jpeg\";s:5:\"sizes\";a:11:{s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-300x225.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:53:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-1024x768.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-768x576.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-370x250.jpeg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:50:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-76x61.jpeg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-262x190.jpeg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:52:\"WhatsApp-Image-2020-04-17-at-2.46.55-AM-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6535", "3105", "_wp_attached_file", "2020/08/WhatsApp-Image-2020-04-17-at-2.46.55-AM.jpeg");
INSERT INTO `wp_postmeta` VALUES("13913", "4706", "_product_version", "5.2.2");
INSERT INTO `wp_postmeta` VALUES("14078", "4714", "_product_version", "5.2.2");
INSERT INTO `wp_postmeta` VALUES("13892", "4703", "_order_stock_reduced", "yes");
INSERT INTO `wp_postmeta` VALUES("13891", "4703", "_recorded_coupon_usage_counts", "yes");
INSERT INTO `wp_postmeta` VALUES("13890", "4703", "_recorded_sales", "yes");
INSERT INTO `wp_postmeta` VALUES("13889", "4703", "_download_permissions_granted", "yes");
INSERT INTO `wp_postmeta` VALUES("13888", "4703", "_completed_date", "2021-04-30 12:59:49");
INSERT INTO `wp_postmeta` VALUES("13887", "4703", "_paid_date", "2021-04-30 12:59:49");
INSERT INTO `wp_postmeta` VALUES("13886", "4703", "_billing_email", "info@sitralweb.com");
INSERT INTO `wp_postmeta` VALUES("5662", "2846", "description", "");
INSERT INTO `wp_postmeta` VALUES("5661", "2845", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:395;s:6:\"height\";i:195;s:4:\"file\";s:32:\"2020/08/iranamlak2-sitralweb.png\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"iranamlak2-sitralweb-300x148.png\";s:5:\"width\";i:300;s:6:\"height\";i:148;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"iranamlak2-sitralweb-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:32:\"iranamlak2-sitralweb-370x195.png\";s:5:\"width\";i:370;s:6:\"height\";i:195;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:30:\"iranamlak2-sitralweb-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:32:\"iranamlak2-sitralweb-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5660", "2845", "_wp_attached_file", "2020/08/iranamlak2-sitralweb.png");
INSERT INTO `wp_postmeta` VALUES("5659", "2844", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("5658", "2844", "description", "");
INSERT INTO `wp_postmeta` VALUES("26652", "6446", "_streetmap", "field_5ec38ed14694f");
INSERT INTO `wp_postmeta` VALUES("26648", "6446", "_gallery", "field_5bdd406aef1f8");
INSERT INTO `wp_postmeta` VALUES("26649", "6446", "video", "");
INSERT INTO `wp_postmeta` VALUES("26650", "6446", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("26651", "6446", "streetmap", "a:7:{s:3:\"lat\";d:36.649415300000001;s:3:\"lng\";d:51.430263500000002;s:4:\"zoom\";i:12;s:7:\"markers\";a:1:{i:0;a:4:{s:5:\"label\";s:112:\"بلوار شهید خیریان, 46516-55897 دهستان خیرودکنار Nowshahr, Mazandaran Province Iran\";s:13:\"default_label\";s:112:\"بلوار شهید خیریان, 46516-55897 دهستان خیرودکنار Nowshahr, Mazandaran Province Iran\";s:3:\"lat\";d:36.644457099999997;s:3:\"lng\";d:51.491889999999998;}}s:7:\"address\";s:112:\"بلوار شهید خیریان, 46516-55897 دهستان خیرودکنار Nowshahr, Mazandaran Province Iran\";s:6:\"layers\";a:1:{i:0;s:20:\"OpenStreetMap.Mapnik\";}s:7:\"version\";s:5:\"1.3.2\";}");
INSERT INTO `wp_postmeta` VALUES("14041", "4712", "_order_version", "5.2.2");
INSERT INTO `wp_postmeta` VALUES("14040", "4712", "_order_total", "10000");
INSERT INTO `wp_postmeta` VALUES("14039", "4712", "_order_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14038", "4712", "_order_shipping_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14037", "4712", "_order_shipping", "0");
INSERT INTO `wp_postmeta` VALUES("14036", "4712", "_cart_discount_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14035", "4712", "_cart_discount", "0");
INSERT INTO `wp_postmeta` VALUES("14034", "4712", "_order_currency", "IRT");
INSERT INTO `wp_postmeta` VALUES("14033", "4712", "_billing_email", "sd@yahoo.com");
INSERT INTO `wp_postmeta` VALUES("14032", "4712", "_cart_hash", "eae70a2ebf5bb1dd0faa138f4fc674a0");
INSERT INTO `wp_postmeta` VALUES("14031", "4712", "_created_via", "checkout");
INSERT INTO `wp_postmeta` VALUES("14030", "4712", "_customer_user_agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:88.0) Gecko/20100101 Firefox/88.0");
INSERT INTO `wp_postmeta` VALUES("14029", "4712", "_customer_ip_address", "2.179.167.223");
INSERT INTO `wp_postmeta` VALUES("14028", "4712", "_payment_method_title", "Pay.ir");
INSERT INTO `wp_postmeta` VALUES("14027", "4712", "_payment_method", "payir");
INSERT INTO `wp_postmeta` VALUES("14026", "4712", "_customer_user", "0");
INSERT INTO `wp_postmeta` VALUES("14024", "4706", "_product_image_gallery", "4683,4682,4680");
INSERT INTO `wp_postmeta` VALUES("14025", "4712", "_order_key", "wc_order_PpfYbvySurIki");
INSERT INTO `wp_postmeta` VALUES("12499", "4565", "_elementor_version", "2.9.7");
INSERT INTO `wp_postmeta` VALUES("12497", "4565", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("12498", "4565", "_elementor_template_type", "kit");
INSERT INTO `wp_postmeta` VALUES("11620", "302", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11619", "302", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("11618", "302", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("11617", "305", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11616", "305", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("13101", "4681", "_wp_attached_file", "2020/04/vila5.jpg");
INSERT INTO `wp_postmeta` VALUES("27029", "6463", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:25;s:6:\"height\";i:41;s:4:\"file\";s:22:\"2022/10/marker-red.png\";s:8:\"filesize\";i:1109;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11615", "2288", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11614", "2288", "video", "");
INSERT INTO `wp_postmeta` VALUES("12662", "300", "mantaghe", "1412");
INSERT INTO `wp_postmeta` VALUES("12663", "300", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("10620", "3971", "_wp_attached_file", "2020/12/2.jpg");
INSERT INTO `wp_postmeta` VALUES("13898", "4706", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("13899", "4706", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("13900", "4706", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("13901", "4706", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("13902", "4706", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("13903", "4706", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("13904", "4706", "_virtual", "yes");
INSERT INTO `wp_postmeta` VALUES("13905", "4706", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("13906", "4706", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("13907", "4706", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("13908", "4706", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("13909", "4706", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("13910", "4706", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("13911", "4706", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("14077", "4714", "_wc_review_count", "0");
INSERT INTO `wp_postmeta` VALUES("14088", "4715", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("14089", "4715", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("14090", "4715", "_virtual", "no");
INSERT INTO `wp_postmeta` VALUES("14091", "4715", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("14092", "4715", "_product_image_gallery", "4717,4718");
INSERT INTO `wp_postmeta` VALUES("14087", "4715", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("14086", "4715", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("14085", "4715", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("14084", "4715", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("14083", "4715", "_regular_price", "12000000");
INSERT INTO `wp_postmeta` VALUES("14082", "4714", "_sale_price", "69000");
INSERT INTO `wp_postmeta` VALUES("14081", "4714", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("14080", "4714", "_edit_lock", "1619881361:1");
INSERT INTO `wp_postmeta` VALUES("14079", "4714", "_price", "69000");
INSERT INTO `wp_postmeta` VALUES("5690", "302", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("5691", "302", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("5692", "303", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("5693", "303", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("7949", "302", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("5694", "296", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("5695", "296", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("13093", "4677", "_wp_attached_file", "2020/05/apartment3.jpg");
INSERT INTO `wp_postmeta` VALUES("13094", "4677", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:22:\"2020/05/apartment3.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"apartment3-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"apartment3-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:22:\"apartment3-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:20:\"apartment3-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:22:\"apartment3-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:22:\"apartment3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:22:\"apartment3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"apartment3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26582", "6446", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("26581", "6446", "name", "سینا");
INSERT INTO `wp_postmeta` VALUES("5655", "2842", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("5654", "2842", "description", "");
INSERT INTO `wp_postmeta` VALUES("5653", "2841", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:24:\"2020/08/iranamlak-me.png\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"iranamlak-me-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"iranamlak-me-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:24:\"iranamlak-me-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:22:\"iranamlak-me-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:24:\"iranamlak-me-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5652", "2841", "_wp_attached_file", "2020/08/iranamlak-me.png");
INSERT INTO `wp_postmeta` VALUES("11194", "300", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("11193", "300", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("12660", "2288", "mantaghe", "1411");
INSERT INTO `wp_postmeta` VALUES("12661", "2288", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("12668", "4581", "_wp_attached_file", "2020/05/yousef-pouraminian.jpg");
INSERT INTO `wp_postmeta` VALUES("12669", "4581", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:290;s:4:\"file\";s:30:\"2020/05/yousef-pouraminian.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"yousef-pouraminian-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:30:\"yousef-pouraminian-300x250.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:28:\"yousef-pouraminian-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:30:\"yousef-pouraminian-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11205", "4240", "_wp_attached_file", "2020/04/iranamlak.mp4");
INSERT INTO `wp_postmeta` VALUES("11206", "4240", "_wp_attachment_metadata", "a:10:{s:8:\"filesize\";i:820416;s:9:\"mime_type\";s:9:\"video/mp4\";s:6:\"length\";i:16;s:16:\"length_formatted\";s:4:\"0:16\";s:5:\"width\";i:640;s:6:\"height\";i:426;s:10:\"fileformat\";s:3:\"mp4\";s:10:\"dataformat\";s:9:\"quicktime\";s:5:\"audio\";a:7:{s:10:\"dataformat\";s:3:\"mp4\";s:5:\"codec\";s:19:\"ISO/IEC 14496-3 AAC\";s:11:\"sample_rate\";d:44100;s:8:\"channels\";i:2;s:15:\"bits_per_sample\";i:16;s:8:\"lossless\";b:0;s:11:\"channelmode\";s:6:\"stereo\";}s:17:\"created_timestamp\";i:-2082844800;}");
INSERT INTO `wp_postmeta` VALUES("5674", "2849", "_wp_attached_file", "2020/05/C24rZucWgAAMGV6.jpg");
INSERT INTO `wp_postmeta` VALUES("5675", "2849", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:600;s:4:\"file\";s:27:\"2020/05/C24rZucWgAAMGV6.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"C24rZucWgAAMGV6-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"C24rZucWgAAMGV6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"C24rZucWgAAMGV6-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:27:\"C24rZucWgAAMGV6-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:25:\"C24rZucWgAAMGV6-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:27:\"C24rZucWgAAMGV6-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26580", "6446", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("26579", "6446", "darkhast", "مشاور املاک");
INSERT INTO `wp_postmeta` VALUES("26578", "6446", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("26577", "6446", "moshaver", "");
INSERT INTO `wp_postmeta` VALUES("26575", "6446", "description", "");
INSERT INTO `wp_postmeta` VALUES("26576", "6446", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("26574", "6446", "_tozihat", "field_6276decb8a224");
INSERT INTO `wp_postmeta` VALUES("8740", "1896", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("8739", "1896", "video", "");
INSERT INTO `wp_postmeta` VALUES("8735", "1896", "moaveze-for", "");
INSERT INTO `wp_postmeta` VALUES("8736", "1896", "_moaveze-for", "field_5eef05d1461c2");
INSERT INTO `wp_postmeta` VALUES("8737", "1896", "shahri", "0");
INSERT INTO `wp_postmeta` VALUES("8738", "1896", "_shahri", "field_5f912ce057bb8");
INSERT INTO `wp_postmeta` VALUES("6702", "3113", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1345;s:6:\"height\";i:1345;s:4:\"file\";s:31:\"2020/09/IMG_20200822_191101.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"IMG_20200822_191101-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"IMG_20200822_191101-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"IMG_20200822_191101-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"IMG_20200822_191101-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:31:\"IMG_20200822_191101-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:29:\"IMG_20200822_191101-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:31:\"IMG_20200822_191101-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:4:\"1.89\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:16:\"Redmi Note 8 Pro\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1598134777\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"5.43\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:8:\"0.002777\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6701", "3113", "_wp_attached_file", "2020/09/IMG_20200822_191101.jpg");
INSERT INTO `wp_postmeta` VALUES("6700", "1896", "simplefavorites_count", "1");
INSERT INTO `wp_postmeta` VALUES("13859", "4702", "_download_permissions_granted", "yes");
INSERT INTO `wp_postmeta` VALUES("13860", "4702", "_recorded_sales", "yes");
INSERT INTO `wp_postmeta` VALUES("6791", "2288", "_ostan_cat", "field_5f6adc4780fe0");
INSERT INTO `wp_postmeta` VALUES("7936", "305", "_tahol", "field_5eeef989e2bc3");
INSERT INTO `wp_postmeta` VALUES("7937", "305", "darbast", "هست");
INSERT INTO `wp_postmeta` VALUES("7938", "305", "_darbast", "field_5eeefcb7e2bcc");
INSERT INTO `wp_postmeta` VALUES("7939", "305", "nafarat", "5");
INSERT INTO `wp_postmeta` VALUES("7940", "305", "_nafarat", "field_5eeefce1e2bcd");
INSERT INTO `wp_postmeta` VALUES("7941", "305", "num-hamam", "2");
INSERT INTO `wp_postmeta` VALUES("7942", "305", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("7943", "305", "num-wc", "2");
INSERT INTO `wp_postmeta` VALUES("7944", "305", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("7947", "303", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7948", "303", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7950", "302", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7951", "297", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("7952", "297", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("7953", "297", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7954", "297", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7955", "297", "tabdil", "دارد");
INSERT INTO `wp_postmeta` VALUES("7956", "297", "_tabdil", "field_5ee4c5caef41f");
INSERT INTO `wp_postmeta` VALUES("7957", "297", "tahol", "خانواده و مجرد");
INSERT INTO `wp_postmeta` VALUES("7958", "297", "_tahol", "field_5eeef989e2bc3");
INSERT INTO `wp_postmeta` VALUES("7959", "297", "darbast", "هست");
INSERT INTO `wp_postmeta` VALUES("7960", "297", "_darbast", "field_5eeefcb7e2bcc");
INSERT INTO `wp_postmeta` VALUES("7961", "297", "nafarat", "10");
INSERT INTO `wp_postmeta` VALUES("26568", "6444", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:607;s:4:\"file\";s:31:\"2022/07/IMG-20220724-WA0036.jpg\";s:8:\"filesize\";i:101791;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0036-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16134;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"IMG-20220724-WA0036-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:132387;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0036-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7689;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0036-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:82354;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0036-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26503;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:29:\"IMG-20220724-WA0036-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2415;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0036-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15137;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("13548", "4687", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("13547", "4687", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("13546", "4687", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("13545", "4687", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("13544", "4687", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("13543", "4687", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("13542", "4687", "email", "");
INSERT INTO `wp_postmeta` VALUES("13541", "4687", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("13540", "4687", "mobile", "09121234567");
INSERT INTO `wp_postmeta` VALUES("13539", "4687", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("13538", "4687", "address", "تهران ");
INSERT INTO `wp_postmeta` VALUES("13536", "4687", "name", "حسینی");
INSERT INTO `wp_postmeta` VALUES("13537", "4687", "_name", "field_5bbb3d5833cd8");
INSERT INTO `wp_postmeta` VALUES("7962", "297", "_nafarat", "field_5eeefce1e2bcd");
INSERT INTO `wp_postmeta` VALUES("7963", "297", "num-hamam", "1");
INSERT INTO `wp_postmeta` VALUES("7964", "297", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("7965", "297", "num-wc", "1");
INSERT INTO `wp_postmeta` VALUES("7966", "297", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("7967", "296", "price-form", "توافقی");
INSERT INTO `wp_postmeta` VALUES("7968", "296", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7969", "294", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("7970", "294", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("7971", "294", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7972", "294", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7973", "294", "tabdil", "دارد");
INSERT INTO `wp_postmeta` VALUES("7974", "294", "_tabdil", "field_5ee4c5caef41f");
INSERT INTO `wp_postmeta` VALUES("7975", "294", "tahol", "خانواده و مجرد");
INSERT INTO `wp_postmeta` VALUES("7976", "294", "_tahol", "field_5eeef989e2bc3");
INSERT INTO `wp_postmeta` VALUES("7977", "294", "darbast", "هست");
INSERT INTO `wp_postmeta` VALUES("7978", "294", "_darbast", "field_5eeefcb7e2bcc");
INSERT INTO `wp_postmeta` VALUES("7979", "294", "nafarat", "6");
INSERT INTO `wp_postmeta` VALUES("7980", "294", "_nafarat", "field_5eeefce1e2bcd");
INSERT INTO `wp_postmeta` VALUES("7981", "294", "num-hamam", "1");
INSERT INTO `wp_postmeta` VALUES("7982", "294", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("7983", "294", "num-wc", "2");
INSERT INTO `wp_postmeta` VALUES("7984", "294", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("7985", "290", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("7437", "228", "simplefavorites_count", "0");
INSERT INTO `wp_postmeta` VALUES("7180", "3244", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:350;s:4:\"file\";s:26:\"2020/09/13-Reasons-Why.jpg\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"13-Reasons-Why-300x105.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:105;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"13-Reasons-Why-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"13-Reasons-Why-768x269.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:269;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:26:\"13-Reasons-Why-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:24:\"13-Reasons-Why-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:26:\"13-Reasons-Why-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:26:\"13-Reasons-Why-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:26:\"13-Reasons-Why-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:26:\"13-Reasons-Why-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"13-Reasons-Why-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("7179", "3244", "_wp_attached_file", "2020/09/13-Reasons-Why.jpg");
INSERT INTO `wp_postmeta` VALUES("4546", "2288", "simplefavorites_count", "3");
INSERT INTO `wp_postmeta` VALUES("14076", "4714", "_wc_average_rating", "0");
INSERT INTO `wp_postmeta` VALUES("14075", "4714", "_stock_status", "instock");
INSERT INTO `wp_postmeta` VALUES("14074", "4714", "_stock", NULL);
INSERT INTO `wp_postmeta` VALUES("14073", "4714", "_thumbnail_id", "1995");
INSERT INTO `wp_postmeta` VALUES("14072", "4714", "_download_expiry", "-1");
INSERT INTO `wp_postmeta` VALUES("14071", "4714", "_download_limit", "-1");
INSERT INTO `wp_postmeta` VALUES("14070", "4714", "_product_image_gallery", "4683,4682,4680");
INSERT INTO `wp_postmeta` VALUES("14069", "4714", "_downloadable", "no");
INSERT INTO `wp_postmeta` VALUES("14068", "4714", "_virtual", "yes");
INSERT INTO `wp_postmeta` VALUES("14067", "4714", "_sold_individually", "no");
INSERT INTO `wp_postmeta` VALUES("14066", "4714", "_backorders", "no");
INSERT INTO `wp_postmeta` VALUES("14065", "4714", "_manage_stock", "no");
INSERT INTO `wp_postmeta` VALUES("14064", "4714", "_tax_class", "");
INSERT INTO `wp_postmeta` VALUES("14063", "4714", "_tax_status", "taxable");
INSERT INTO `wp_postmeta` VALUES("14062", "4714", "total_sales", "0");
INSERT INTO `wp_postmeta` VALUES("14061", "4714", "_regular_price", "79000");
INSERT INTO `wp_postmeta` VALUES("14060", "49", "_wp_old_date", "2020-05-30");
INSERT INTO `wp_postmeta` VALUES("14058", "3249", "_wp_old_date", "2020-09-27");
INSERT INTO `wp_postmeta` VALUES("14055", "46", "_wp_old_date", "2020-05-30");
INSERT INTO `wp_postmeta` VALUES("14059", "54", "_wp_old_date", "2020-05-30");
INSERT INTO `wp_postmeta` VALUES("17016", "5279", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1126;s:6:\"height\";i:150;s:4:\"file\";s:22:\"2022/02/avatar_all.png\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"avatar_all-300x40.png\";s:5:\"width\";i:300;s:6:\"height\";i:40;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"avatar_all-1024x136.png\";s:5:\"width\";i:1024;s:6:\"height\";i:136;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"avatar_all-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"avatar_all-768x102.png\";s:5:\"width\";i:768;s:6:\"height\";i:102;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:22:\"avatar_all-370x150.png\";s:5:\"width\";i:370;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:20:\"avatar_all-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:22:\"avatar_all-262x150.png\";s:5:\"width\";i:262;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("17015", "5279", "_wp_attached_file", "2022/02/avatar_all.png");
INSERT INTO `wp_postmeta` VALUES("14045", "4712", "is_vat_exempt", "no");
INSERT INTO `wp_postmeta` VALUES("14044", "4712", "_shipping_address_index", "        ");
INSERT INTO `wp_postmeta` VALUES("14248", "4896", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:17:\"2021/06/vila3.jpg\";s:5:\"sizes\";a:12:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"vila3-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"vila3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"vila3-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:17:\"vila3-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:15:\"vila3-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:17:\"vila3-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:17:\"vila3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:17:\"vila3-600x423.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:17:\"vila3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:17:\"vila3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:17:\"vila3-600x423.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:17:\"vila3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14247", "4896", "_wp_attached_file", "2021/06/vila3.jpg");
INSERT INTO `wp_postmeta` VALUES("7986", "290", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("7987", "290", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7988", "290", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7989", "285", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("7990", "285", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("7991", "285", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("7992", "285", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("7993", "285", "tabdil", "دارد");
INSERT INTO `wp_postmeta` VALUES("7994", "285", "_tabdil", "field_5ee4c5caef41f");
INSERT INTO `wp_postmeta` VALUES("7995", "285", "tahol", "خانواده و مجرد");
INSERT INTO `wp_postmeta` VALUES("7996", "285", "_tahol", "field_5eeef989e2bc3");
INSERT INTO `wp_postmeta` VALUES("7997", "285", "darbast", "هست");
INSERT INTO `wp_postmeta` VALUES("7998", "285", "_darbast", "field_5eeefcb7e2bcc");
INSERT INTO `wp_postmeta` VALUES("7999", "285", "nafarat", "9");
INSERT INTO `wp_postmeta` VALUES("8000", "285", "_nafarat", "field_5eeefce1e2bcd");
INSERT INTO `wp_postmeta` VALUES("8001", "285", "num-hamam", "1");
INSERT INTO `wp_postmeta` VALUES("8002", "285", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("8003", "285", "num-wc", "2");
INSERT INTO `wp_postmeta` VALUES("8004", "285", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("8005", "223", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("8006", "223", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("8007", "223", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("8008", "223", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("8009", "223", "tabdil", "ندارد");
INSERT INTO `wp_postmeta` VALUES("8010", "223", "_tabdil", "field_5ee4c5caef41f");
INSERT INTO `wp_postmeta` VALUES("8011", "223", "tahol", "خانواده و مجرد");
INSERT INTO `wp_postmeta` VALUES("8012", "223", "_tahol", "field_5eeef989e2bc3");
INSERT INTO `wp_postmeta` VALUES("8013", "223", "darbast", "هست");
INSERT INTO `wp_postmeta` VALUES("8014", "223", "_darbast", "field_5eeefcb7e2bcc");
INSERT INTO `wp_postmeta` VALUES("8015", "223", "nafarat", "20");
INSERT INTO `wp_postmeta` VALUES("8016", "223", "_nafarat", "field_5eeefce1e2bcd");
INSERT INTO `wp_postmeta` VALUES("8017", "223", "num-hamam", "1");
INSERT INTO `wp_postmeta` VALUES("8018", "223", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("8019", "223", "num-wc", "1");
INSERT INTO `wp_postmeta` VALUES("8020", "223", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("8021", "221", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("8022", "221", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("8023", "221", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("8024", "221", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("8025", "214", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("8026", "214", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("8027", "214", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("8028", "214", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("8029", "212", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("8030", "212", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("8031", "212", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("8032", "212", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("13880", "4703", "_cart_discount_tax", "0");
INSERT INTO `wp_postmeta` VALUES("13879", "4703", "_cart_discount", "0");
INSERT INTO `wp_postmeta` VALUES("13878", "4703", "_shipping_address_index", "        ");
INSERT INTO `wp_postmeta` VALUES("13858", "4702", "_completed_date", "2021-04-30 12:57:33");
INSERT INTO `wp_postmeta` VALUES("13847", "4702", "_billing_address_index", "         info@sitralweb.com ");
INSERT INTO `wp_postmeta` VALUES("13848", "4702", "_shipping_address_index", "        ");
INSERT INTO `wp_postmeta` VALUES("13849", "4702", "_cart_discount", "0");
INSERT INTO `wp_postmeta` VALUES("13850", "4702", "_cart_discount_tax", "0");
INSERT INTO `wp_postmeta` VALUES("13851", "4702", "_order_shipping", "0");
INSERT INTO `wp_postmeta` VALUES("13852", "4702", "_order_key", "wc_order_ryhN3MEQUhYfq");
INSERT INTO `wp_postmeta` VALUES("13853", "4702", "_created_via", "admin");
INSERT INTO `wp_postmeta` VALUES("13854", "4702", "_date_completed", "1619771253");
INSERT INTO `wp_postmeta` VALUES("13855", "4702", "_date_paid", "1619771253");
INSERT INTO `wp_postmeta` VALUES("13856", "4702", "_billing_email", "info@sitralweb.com");
INSERT INTO `wp_postmeta` VALUES("13857", "4702", "_paid_date", "2021-04-30 12:57:33");
INSERT INTO `wp_postmeta` VALUES("12501", "4564", "_edit_lock", "1616318129:1");
INSERT INTO `wp_postmeta` VALUES("12502", "4564", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("12503", "4564", "_elementor_data", "[]");
INSERT INTO `wp_postmeta` VALUES("13846", "4702", "_prices_include_tax", "no");
INSERT INTO `wp_postmeta` VALUES("13843", "4702", "_order_tax", "0");
INSERT INTO `wp_postmeta` VALUES("13844", "4702", "_order_total", "18000");
INSERT INTO `wp_postmeta` VALUES("13841", "4702", "_order_currency", "IRT");
INSERT INTO `wp_postmeta` VALUES("13842", "4702", "_order_shipping_tax", "0");
INSERT INTO `wp_postmeta` VALUES("13840", "4702", "_customer_user", "1");
INSERT INTO `wp_postmeta` VALUES("13838", "4702", "_edit_lock", "1619771329:1");
INSERT INTO `wp_postmeta` VALUES("13839", "4702", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("25158", "6367", "description", "نکته های مهم موقع خرید خانه");
INSERT INTO `wp_postmeta` VALUES("25153", "6366", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("14102", "4715", "_edit_lock", "1670668772:1");
INSERT INTO `wp_postmeta` VALUES("21526", "5679", "description", "");
INSERT INTO `wp_postmeta` VALUES("21527", "5679", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("12175", "4531", "_wp_attached_file", "woocommerce-placeholder.png");
INSERT INTO `wp_postmeta` VALUES("12176", "4531", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1200;s:4:\"file\";s:27:\"woocommerce-placeholder.png\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"woocommerce-placeholder-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:33:\"woocommerce-placeholder-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("12159", "4381", "_wp_old_slug", "%db%8c%da%a9-%d9%85%d8%a7%d9%87%d9%87");
INSERT INTO `wp_postmeta` VALUES("12158", "4525", "_wp_old_slug", "4525");
INSERT INTO `wp_postmeta` VALUES("12157", "4525", "_for", "field_6023e899c972a");
INSERT INTO `wp_postmeta` VALUES("12156", "4525", "for", "کاربر عادی");
INSERT INTO `wp_postmeta` VALUES("12155", "4525", "_days", "field_6023e7e8c9729");
INSERT INTO `wp_postmeta` VALUES("12154", "4525", "days", "60");
INSERT INTO `wp_postmeta` VALUES("12153", "4525", "_price", "field_60240374c972c");
INSERT INTO `wp_postmeta` VALUES("12152", "4525", "price", "7000");
INSERT INTO `wp_postmeta` VALUES("12151", "4525", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("12150", "4525", "_edit_lock", "1612973065:1");
INSERT INTO `wp_postmeta` VALUES("12149", "4381", "_for", "field_6023e899c972a");
INSERT INTO `wp_postmeta` VALUES("12148", "4381", "for", "کاربر عادی");
INSERT INTO `wp_postmeta` VALUES("12147", "4381", "_days", "field_6023e7e8c9729");
INSERT INTO `wp_postmeta` VALUES("12146", "4381", "days", "30");
INSERT INTO `wp_postmeta` VALUES("9256", "3573", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:678;s:6:\"height\";i:805;s:4:\"file\";s:42:\"2020/12/5988_857256826b5cfaded8af65751.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:42:\"5988_857256826b5cfaded8af65751-253x300.jpg\";s:5:\"width\";i:253;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"5988_857256826b5cfaded8af65751-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:42:\"5988_857256826b5cfaded8af65751-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:40:\"5988_857256826b5cfaded8af65751-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:42:\"5988_857256826b5cfaded8af65751-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("9255", "3573", "_wp_attached_file", "2020/12/5988_857256826b5cfaded8af65751.jpg");
INSERT INTO `wp_postmeta` VALUES("12494", "4564", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("12495", "4564", "_elementor_template_type", "page");
INSERT INTO `wp_postmeta` VALUES("11643", "214", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11644", "212", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("11645", "212", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("11646", "212", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11647", "212", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("12496", "4564", "_elementor_version", "2.9.7");
INSERT INTO `wp_postmeta` VALUES("11642", "214", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11641", "214", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("11640", "214", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("11639", "221", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11638", "221", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11637", "221", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("11636", "221", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("11634", "223", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11635", "223", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11633", "285", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("27039", "223", "mg-vahed", "");
INSERT INTO `wp_postmeta` VALUES("11632", "285", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("27040", "223", "_mg-vahed", "field_6276dd820a3e9");
INSERT INTO `wp_postmeta` VALUES("11631", "290", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11630", "290", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11629", "294", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11628", "294", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11627", "296", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11626", "296", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("11625", "296", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("11624", "296", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("11623", "297", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11621", "302", "_video", "field_5fba5c83dbf63");
INSERT INTO `wp_postmeta` VALUES("11622", "297", "video", "4240");
INSERT INTO `wp_postmeta` VALUES("26573", "6446", "tozihat", "ویلاباغ شهرکی استخردار نوشهر\r\n۱۲۵۰ متر زمین ۵۵۰ متر بنا با سند و جواز ساخت .\r\nداخل شهرک با نگهبانی.\r\nبا استخرو جکوزی.\r\nمدرن و نوساز.\r\nچهار خوابه مستر.\r\n۲۶م");
INSERT INTO `wp_postmeta` VALUES("26567", "6444", "_wp_attached_file", "2022/07/IMG-20220724-WA0036.jpg");
INSERT INTO `wp_postmeta` VALUES("25743", "2837", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:4.6181451160704272;s:5:\"bytes\";i:2059;s:11:\"size_before\";i:44585;s:10:\"size_after\";i:42526;s:4:\"time\";d:0.15000000000000002;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:5:{s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.4000000000000004;s:5:\"bytes\";i:434;s:11:\"size_before\";i:9856;s:10:\"size_after\";i:9422;s:4:\"time\";d:0.050000000000000003;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.7199999999999998;s:5:\"bytes\";i:361;s:11:\"size_before\";i:6307;s:10:\"size_after\";i:5946;s:4:\"time\";i:0;}s:11:\"img-370-250\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.96;s:5:\"bytes\";i:613;s:11:\"size_before\";i:15469;s:10:\"size_after\";i:14856;s:4:\"time\";d:0.080000000000000002;}s:9:\"img-76-61\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.7699999999999996;s:5:\"bytes\";i:193;s:11:\"size_before\";i:2483;s:10:\"size_after\";i:2290;s:4:\"time\";d:0.01;}s:11:\"img-262-190\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.3700000000000001;s:5:\"bytes\";i:458;s:11:\"size_before\";i:10470;s:10:\"size_after\";i:10012;s:4:\"time\";d:0.01;}}}");
INSERT INTO `wp_postmeta` VALUES("21807", "5767", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:73;s:6:\"height\";i:43;s:4:\"file\";s:21:\"2022/03/watermark.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("21806", "5767", "_wp_attached_file", "2022/03/watermark.png");
INSERT INTO `wp_postmeta` VALUES("5570", "2836", "_wp_attached_file", "2020/08/2-6.png");
INSERT INTO `wp_postmeta` VALUES("5571", "2836", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:756;s:6:\"height\";i:467;s:4:\"file\";s:15:\"2020/08/2-6.png\";s:5:\"sizes\";a:9:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"2-6-300x185.png\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"2-6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:15:\"2-6-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:13:\"2-6-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:15:\"2-6-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:15:\"2-6-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:15:\"2-6-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"2-6-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"2-6-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("5572", "2837", "_wp_attached_file", "2020/08/14.jpg");
INSERT INTO `wp_postmeta` VALUES("5573", "2837", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:721;s:6:\"height\";i:406;s:4:\"file\";s:14:\"2020/08/14.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"14-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:14:\"14-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:12:\"14-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:14:\"14-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("12145", "4381", "_price", "field_60240374c972c");
INSERT INTO `wp_postmeta` VALUES("12144", "4381", "price", "0");
INSERT INTO `wp_postmeta` VALUES("13893", "4703", "_new_order_email_sent", "true");
INSERT INTO `wp_postmeta` VALUES("12137", "4381", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("12136", "4381", "_edit_lock", "1617176704:1");
INSERT INTO `wp_postmeta` VALUES("13535", "4687", "_darkhast", "field_5eb175445c00a");
INSERT INTO `wp_postmeta` VALUES("13534", "4687", "darkhast", "شخصی");
INSERT INTO `wp_postmeta` VALUES("13533", "4687", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("13532", "4687", "description", "");
INSERT INTO `wp_postmeta` VALUES("26569", "6445", "_wp_attached_file", "2022/07/IMG-20220724-WA0034.jpg");
INSERT INTO `wp_postmeta` VALUES("26570", "6445", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:607;s:4:\"file\";s:31:\"2022/07/IMG-20220724-WA0034.jpg\";s:8:\"filesize\";i:33336;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0034-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8350;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"IMG-20220724-WA0034-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48932;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0034-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3946;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0034-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32041;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0034-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11875;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:29:\"IMG-20220724-WA0034-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1804;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0034-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7351;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("23039", "6118", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:742;s:4:\"file\";s:22:\"2022/04/backsearch.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"backsearch-300x174.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:174;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"backsearch-1024x594.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:594;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"backsearch-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"backsearch-768x445.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:445;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:22:\"backsearch-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:20:\"backsearch-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:22:\"backsearch-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1650980678\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14245", "4895", "_wp_attached_file", "2021/06/vila2.jpg");
INSERT INTO `wp_postmeta` VALUES("14246", "4895", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:550;s:4:\"file\";s:17:\"2021/06/vila2.jpg\";s:5:\"sizes\";a:12:{s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"vila2-300x212.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:212;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"vila2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"vila2-768x542.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:542;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:17:\"vila2-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:15:\"vila2-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:17:\"vila2-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:17:\"vila2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:17:\"vila2-600x423.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:17:\"vila2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:17:\"vila2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:17:\"vila2-600x423.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:17:\"vila2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14236", "4687", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("14235", "4687", "tedad-vahed-kol", "");
INSERT INTO `wp_postmeta` VALUES("14234", "4687", "_tedad-vahed-har-tabaghe", "field_5aea8bdfe4f08");
INSERT INTO `wp_postmeta` VALUES("14233", "4687", "tedad-vahed-har-tabaghe", "");
INSERT INTO `wp_postmeta` VALUES("14232", "4687", "_moshaver", "field_5ea6e9f00c9ae");
INSERT INTO `wp_postmeta` VALUES("14231", "4687", "moshaver", "2");
INSERT INTO `wp_postmeta` VALUES("14230", "4687", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("14226", "4687", "_vaziat", "field_5bdd6738da7e8");
INSERT INTO `wp_postmeta` VALUES("14227", "4687", "special", "0");
INSERT INTO `wp_postmeta` VALUES("14228", "4687", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("14229", "4687", "fast", "0");
INSERT INTO `wp_postmeta` VALUES("14225", "4687", "vaziat", "0");
INSERT INTO `wp_postmeta` VALUES("14224", "4687", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("14223", "4687", "why-rejected", "محتوای نامناسب در عکس وجود دارد");
INSERT INTO `wp_postmeta` VALUES("14807", "4900", "_order_shipping", "0");
INSERT INTO `wp_postmeta` VALUES("14197", "4883", "_edit_lock", "1656417047:1");
INSERT INTO `wp_postmeta` VALUES("14198", "4883", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("14199", "4883", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("14200", "4883", "description", "");
INSERT INTO `wp_postmeta` VALUES("14201", "4883", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("14202", "4884", "description", "");
INSERT INTO `wp_postmeta` VALUES("14203", "4884", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("14204", "4885", "description", "");
INSERT INTO `wp_postmeta` VALUES("14205", "4885", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("14206", "4886", "description", "");
INSERT INTO `wp_postmeta` VALUES("14207", "4886", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("14208", "4887", "description", "");
INSERT INTO `wp_postmeta` VALUES("14209", "4887", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("14782", "4898", "_billing_email", "demo@sitralweb.com");
INSERT INTO `wp_postmeta` VALUES("14211", "4888", "_edit_lock", "1624634915:1");
INSERT INTO `wp_postmeta` VALUES("14212", "4888", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("14219", "4687", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("14220", "4687", "_edit_lock", "1650953375:1");
INSERT INTO `wp_postmeta` VALUES("14781", "4898", "_cart_hash", "7ebbf6cf26ae90ba4dfabe0c7a4b6df0");
INSERT INTO `wp_postmeta` VALUES("16345", "5252", "_wp_attached_file", "2021/12/1137_1_13951103175446.jpg");
INSERT INTO `wp_postmeta` VALUES("16346", "5252", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:948;s:6:\"height\";i:632;s:4:\"file\";s:33:\"2021/12/1137_1_13951103175446.jpg\";s:5:\"sizes\";a:12:{s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:31:\"1137_1_13951103175446-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:33:\"1137_1_13951103175446-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:33:\"1137_1_13951103175446-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14783", "4898", "_order_currency", "IRT");
INSERT INTO `wp_postmeta` VALUES("14780", "4898", "_created_via", "checkout");
INSERT INTO `wp_postmeta` VALUES("14774", "4898", "_order_key", "wc_order_OZQglsbXkdOkw");
INSERT INTO `wp_postmeta` VALUES("14775", "4898", "_customer_user", "2");
INSERT INTO `wp_postmeta` VALUES("14776", "4898", "_payment_method", "payir");
INSERT INTO `wp_postmeta` VALUES("14777", "4898", "_payment_method_title", "Pay.ir");
INSERT INTO `wp_postmeta` VALUES("14778", "4898", "_customer_ip_address", "2.147.134.6");
INSERT INTO `wp_postmeta` VALUES("14779", "4898", "_customer_user_agent", "Mozilla/5.0 (Linux; Android 9; SM-J530F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.120 Mobile Safari/537.36");
INSERT INTO `wp_postmeta` VALUES("27659", "6527", "_menu_item_menu_item_parent", "6522");
INSERT INTO `wp_postmeta` VALUES("25849", "6424", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:4:\"file\";s:18:\"2022/06/enamad.png\";s:8:\"filesize\";i:12366;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"enamad-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10221;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"enamad-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4520;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"enamad-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30491;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:18:\"enamad-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12018;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:16:\"enamad-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2069;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:18:\"enamad-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8214;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("25848", "6424", "_wp_attached_file", "2022/06/enamad.png");
INSERT INTO `wp_postmeta` VALUES("27672", "6528", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27069", "46", "_wp_old_date", "2022-06-25");
INSERT INTO `wp_postmeta` VALUES("27613", "6522", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27602", "6520", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27601", "6520", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27600", "6520", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27599", "6520", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27598", "6520", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27597", "6520", "_menu_item_object_id", "6505");
INSERT INTO `wp_postmeta` VALUES("27596", "6520", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("25828", "6421", "description", "");
INSERT INTO `wp_postmeta` VALUES("25829", "6421", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25827", "6420", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25826", "6420", "description", "");
INSERT INTO `wp_postmeta` VALUES("25825", "6420", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:8:\"havekadr\";}");
INSERT INTO `wp_postmeta` VALUES("25824", "6420", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("25823", "6420", "_edit_lock", "1656095661:1");
INSERT INTO `wp_postmeta` VALUES("25822", "6419", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25821", "6419", "description", "");
INSERT INTO `wp_postmeta` VALUES("25820", "6418", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25883", "6427", "_wp_attached_file", "2022/02/apartment-6-scaled-1.jpg");
INSERT INTO `wp_postmeta` VALUES("25819", "6418", "description", "");
INSERT INTO `wp_postmeta` VALUES("25818", "6418", "createquerystate", "a:2:{s:6:\"header\";s:6:\"header\";s:4:\"kadr\";s:6:\"nokadr\";}");
INSERT INTO `wp_postmeta` VALUES("25817", "6418", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("25816", "6418", "_edit_lock", "1656417417:1");
INSERT INTO `wp_postmeta` VALUES("25815", "6408", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25814", "6408", "description", "");
INSERT INTO `wp_postmeta` VALUES("25812", "6416", "description", "");
INSERT INTO `wp_postmeta` VALUES("25813", "6416", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25811", "49", "_wp_old_date", "2022-02-10");
INSERT INTO `wp_postmeta` VALUES("25810", "54", "_wp_old_date", "2022-02-10");
INSERT INTO `wp_postmeta` VALUES("25809", "3249", "_wp_old_date", "2022-02-10");
INSERT INTO `wp_postmeta` VALUES("27682", "6529", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27683", "6529", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=خرید+و+فروش&melk=آپارتمان&max_amount=5000000000");
INSERT INTO `wp_postmeta` VALUES("14809", "4900", "_order_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14808", "4900", "_order_shipping_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14806", "4900", "_cart_discount_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14805", "4900", "_cart_discount", "0");
INSERT INTO `wp_postmeta` VALUES("14804", "4900", "_order_currency", "IRT");
INSERT INTO `wp_postmeta` VALUES("14803", "4900", "_billing_email", "neyija2582@cnxingye.com");
INSERT INTO `wp_postmeta` VALUES("14802", "4900", "_cart_hash", "ef31d0be57c1a5f51c088248b022eda6");
INSERT INTO `wp_postmeta` VALUES("14801", "4900", "_created_via", "checkout");
INSERT INTO `wp_postmeta` VALUES("14800", "4900", "_customer_user_agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36");
INSERT INTO `wp_postmeta` VALUES("14799", "4900", "_customer_ip_address", "185.71.152.59");
INSERT INTO `wp_postmeta` VALUES("14798", "4900", "_payment_method_title", "Pay.ir");
INSERT INTO `wp_postmeta` VALUES("14797", "4900", "_payment_method", "payir");
INSERT INTO `wp_postmeta` VALUES("14796", "4900", "_customer_user", "0");
INSERT INTO `wp_postmeta` VALUES("14784", "4898", "_cart_discount", "0");
INSERT INTO `wp_postmeta` VALUES("14785", "4898", "_cart_discount_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14786", "4898", "_order_shipping", "0");
INSERT INTO `wp_postmeta` VALUES("14787", "4898", "_order_shipping_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14788", "4898", "_order_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14789", "4898", "_order_total", "108000");
INSERT INTO `wp_postmeta` VALUES("14790", "4898", "_order_version", "5.4.1");
INSERT INTO `wp_postmeta` VALUES("14791", "4898", "_prices_include_tax", "no");
INSERT INTO `wp_postmeta` VALUES("14792", "4898", "_billing_address_index", "         demo@sitralweb.com ");
INSERT INTO `wp_postmeta` VALUES("14793", "4898", "_shipping_address_index", "        ");
INSERT INTO `wp_postmeta` VALUES("14794", "4898", "is_vat_exempt", "no");
INSERT INTO `wp_postmeta` VALUES("14795", "4900", "_order_key", "wc_order_AkUADoCuvdH3X");
INSERT INTO `wp_postmeta` VALUES("27641", "6525", "_menu_item_menu_item_parent", "6523");
INSERT INTO `wp_postmeta` VALUES("15780", "5090", "_wp_attached_file", "2021/11/Arm-Amlakchi-2.png");
INSERT INTO `wp_postmeta` VALUES("15781", "5090", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:3543;s:6:\"height\";i:3543;s:4:\"file\";s:26:\"2021/11/Arm-Amlakchi-2.png\";s:5:\"sizes\";a:15:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"Arm-Amlakchi-2-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"Arm-Amlakchi-2-1536x1536.png\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:28:\"Arm-Amlakchi-2-2048x2048.png\";s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:24:\"Arm-Amlakchi-2-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-600x600.png\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-600x600.png\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"Arm-Amlakchi-2-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27671", "6528", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("26566", "6443", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:607;s:4:\"file\";s:31:\"2022/07/IMG-20220724-WA0037.jpg\";s:8:\"filesize\";i:71017;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0037-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13121;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"IMG-20220724-WA0037-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:96205;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0037-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6445;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0037-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61037;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0037-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21600;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:29:\"IMG-20220724-WA0037-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2318;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0037-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12677;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26565", "6443", "_wp_attached_file", "2022/07/IMG-20220724-WA0037.jpg");
INSERT INTO `wp_postmeta` VALUES("15664", "305", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("15665", "305", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("15680", "5078", "_wp_attached_file", "2021/08/202003261807_1.jpg");
INSERT INTO `wp_postmeta` VALUES("15681", "5078", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1800;s:6:\"height\";i:1200;s:4:\"file\";s:26:\"2021/08/202003261807_1.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"202003261807_1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"202003261807_1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"202003261807_1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"202003261807_1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"202003261807_1-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:26:\"202003261807_1-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:24:\"202003261807_1-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:26:\"202003261807_1-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:26:\"202003261807_1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:26:\"202003261807_1-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:26:\"202003261807_1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:26:\"202003261807_1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:26:\"202003261807_1-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"202003261807_1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("15682", "5079", "_wp_attached_file", "2021/08/d6ccjb3shpm6.jpeg");
INSERT INTO `wp_postmeta` VALUES("15683", "5079", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:750;s:4:\"file\";s:25:\"2021/08/d6ccjb3shpm6.jpeg\";s:5:\"sizes\";a:13:{s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-300x188.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"d6ccjb3shpm6-1024x640.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-768x480.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-370x250.jpeg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:23:\"d6ccjb3shpm6-76x61.jpeg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-262x190.jpeg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:25:\"d6ccjb3shpm6-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-600x375.jpeg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-600x375.jpeg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"d6ccjb3shpm6-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("15684", "5080", "_wp_attached_file", "2021/08/WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1.jpeg");
INSERT INTO `wp_postmeta` VALUES("15685", "5080", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:768;s:6:\"height\";i:1024;s:4:\"file\";s:63:\"2021/08/WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1.jpeg\";s:5:\"sizes\";a:11:{s:6:\"medium\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-225x300.jpeg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-370x250.jpeg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:61:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-76x61.jpeg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-262x190.jpeg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-600x800.jpeg\";s:5:\"width\";i:600;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-600x800.jpeg\";s:5:\"width\";i:600;s:6:\"height\";i:800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:63:\"WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1-100x100.jpeg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("15686", "5081", "_wp_attached_file", "2021/08/انحصاروراثت.jpg");
INSERT INTO `wp_postmeta` VALUES("15687", "5081", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:826;s:4:\"file\";s:34:\"2021/08/انحصاروراثت.jpg\";s:5:\"sizes\";a:13:{s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"انحصاروراثت-1024x705.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-768x529.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:529;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:32:\"انحصاروراثت-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:34:\"انحصاروراثت-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-600x413.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:413;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-600x413.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:413;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:34:\"انحصاروراثت-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("14836", "4901", "is_vat_exempt", "no");
INSERT INTO `wp_postmeta` VALUES("14835", "4901", "_shipping_address_index", "        ");
INSERT INTO `wp_postmeta` VALUES("14834", "4901", "_billing_address_index", "         hwymyo@solarunited.net ");
INSERT INTO `wp_postmeta` VALUES("14833", "4901", "_prices_include_tax", "no");
INSERT INTO `wp_postmeta` VALUES("14832", "4901", "_order_version", "5.4.1");
INSERT INTO `wp_postmeta` VALUES("14831", "4901", "_order_total", "18000");
INSERT INTO `wp_postmeta` VALUES("14830", "4901", "_order_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14829", "4901", "_order_shipping_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14828", "4901", "_order_shipping", "0");
INSERT INTO `wp_postmeta` VALUES("14827", "4901", "_cart_discount_tax", "0");
INSERT INTO `wp_postmeta` VALUES("14826", "4901", "_cart_discount", "0");
INSERT INTO `wp_postmeta` VALUES("14825", "4901", "_order_currency", "IRT");
INSERT INTO `wp_postmeta` VALUES("14824", "4901", "_billing_email", "hwymyo@solarunited.net");
INSERT INTO `wp_postmeta` VALUES("14823", "4901", "_cart_hash", "dcff878deb9c241af9e622225763732f");
INSERT INTO `wp_postmeta` VALUES("14822", "4901", "_created_via", "checkout");
INSERT INTO `wp_postmeta` VALUES("14821", "4901", "_customer_user_agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36");
INSERT INTO `wp_postmeta` VALUES("14820", "4901", "_customer_ip_address", "185.71.152.59");
INSERT INTO `wp_postmeta` VALUES("14819", "4901", "_payment_method_title", "Pay.ir");
INSERT INTO `wp_postmeta` VALUES("14818", "4901", "_payment_method", "payir");
INSERT INTO `wp_postmeta` VALUES("14817", "4901", "_customer_user", "0");
INSERT INTO `wp_postmeta` VALUES("14816", "4901", "_order_key", "wc_order_w8034GPX7gKli");
INSERT INTO `wp_postmeta` VALUES("14815", "4900", "is_vat_exempt", "no");
INSERT INTO `wp_postmeta` VALUES("14814", "4900", "_shipping_address_index", "        ");
INSERT INTO `wp_postmeta` VALUES("14813", "4900", "_billing_address_index", "         neyija2582@cnxingye.com ");
INSERT INTO `wp_postmeta` VALUES("14812", "4900", "_prices_include_tax", "no");
INSERT INTO `wp_postmeta` VALUES("14811", "4900", "_order_version", "5.4.1");
INSERT INTO `wp_postmeta` VALUES("14810", "4900", "_order_total", "59000");
INSERT INTO `wp_postmeta` VALUES("15087", "4687", "simplefavorites_count", "0");
INSERT INTO `wp_postmeta` VALUES("15688", "5082", "_wp_attached_file", "2021/08/کد-رهگیری-معاملات-ملکی.jpg");
INSERT INTO `wp_postmeta` VALUES("15689", "5082", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:700;s:6:\"height\";i:466;s:4:\"file\";s:53:\"2021/08/کد-رهگیری-معاملات-ملکی.jpg\";s:5:\"sizes\";a:11:{s:6:\"medium\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:51:\"کد-رهگیری-معاملات-ملکی-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-600x399.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-600x399.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:53:\"کد-رهگیری-معاملات-ملکی-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("16344", "5251", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:948;s:6:\"height\";i:632;s:4:\"file\";s:33:\"2021/12/1136_1_13951103114411.jpg\";s:5:\"sizes\";a:12:{s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:31:\"1136_1_13951103114411-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:33:\"1136_1_13951103114411-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:33:\"1136_1_13951103114411-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("16343", "5251", "_wp_attached_file", "2021/12/1136_1_13951103114411.jpg");
INSERT INTO `wp_postmeta` VALUES("26584", "6446", "_address", "field_5bbb3d3033cd6");
INSERT INTO `wp_postmeta` VALUES("26583", "6446", "address", "مارندران نوشهر");
INSERT INTO `wp_postmeta` VALUES("25354", "6376", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("16427", "302", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16428", "302", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("16429", "302", "mantaghe", "1419");
INSERT INTO `wp_postmeta` VALUES("16430", "302", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16329", "5239", "is_vat_exempt", "no");
INSERT INTO `wp_postmeta` VALUES("16328", "5239", "_shipping_address_index", "         ");
INSERT INTO `wp_postmeta` VALUES("16327", "5239", "_billing_address_index", "         demo@sitralweb.com ");
INSERT INTO `wp_postmeta` VALUES("16326", "5239", "_prices_include_tax", "no");
INSERT INTO `wp_postmeta` VALUES("16325", "5239", "_order_version", "5.9.0");
INSERT INTO `wp_postmeta` VALUES("16324", "5239", "_order_total", "108000");
INSERT INTO `wp_postmeta` VALUES("16323", "5239", "_order_tax", "0");
INSERT INTO `wp_postmeta` VALUES("16322", "5239", "_order_shipping_tax", "0");
INSERT INTO `wp_postmeta` VALUES("16321", "5239", "_order_shipping", "0");
INSERT INTO `wp_postmeta` VALUES("25734", "6118", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:7.0935797153191746;s:5:\"bytes\";i:19670;s:11:\"size_before\";i:277293;s:10:\"size_after\";i:257623;s:4:\"time\";d:0.14000000000000001;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:7:{s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.2800000000000002;s:5:\"bytes\";i:921;s:11:\"size_before\";i:12643;s:10:\"size_after\";i:11722;s:4:\"time\";d:0.01;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.9500000000000002;s:5:\"bytes\";i:9844;s:11:\"size_before\";i:141642;s:10:\"size_after\";i:131798;s:4:\"time\";d:0.050000000000000003;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.4299999999999997;s:5:\"bytes\";i:446;s:11:\"size_before\";i:6000;s:10:\"size_after\";i:5554;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.1900000000000004;s:5:\"bytes\";i:5783;s:11:\"size_before\";i:80453;s:10:\"size_after\";i:74670;s:4:\"time\";d:0.02;}s:11:\"img-370-250\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.1500000000000004;s:5:\"bytes\";i:1610;s:11:\"size_before\";i:22513;s:10:\"size_after\";i:20903;s:4:\"time\";d:0.029999999999999999;}s:9:\"img-76-61\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.1300000000000008;s:5:\"bytes\";i:170;s:11:\"size_before\";i:1863;s:10:\"size_after\";i:1693;s:4:\"time\";i:0;}s:11:\"img-262-190\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.3600000000000003;s:5:\"bytes\";i:896;s:11:\"size_before\";i:12179;s:10:\"size_after\";i:11283;s:4:\"time\";d:0.01;}}}");
INSERT INTO `wp_postmeta` VALUES("25370", "2288", "_celebrations", "field_61fffcd8f9002");
INSERT INTO `wp_postmeta` VALUES("25371", "2288", "Pets", "مجاز است");
INSERT INTO `wp_postmeta` VALUES("25372", "2288", "_Pets", "field_61fffd76f9003");
INSERT INTO `wp_postmeta` VALUES("25373", "2288", "tedad-vahed-kol", "");
INSERT INTO `wp_postmeta` VALUES("25374", "2288", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("26562", "6441", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:562;s:4:\"file\";s:31:\"2022/07/IMG-20220724-WA0032.jpg\";s:8:\"filesize\";i:75823;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0032-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13543;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0032-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6495;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0032-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67915;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0032-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22144;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:29:\"IMG-20220724-WA0032-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2238;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0032-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12515;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26561", "6441", "_wp_attached_file", "2022/07/IMG-20220724-WA0032.jpg");
INSERT INTO `wp_postmeta` VALUES("16513", "5258", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("16512", "5258", "description", "قالب ایران املاک توسط تیم طراحی و برنامه نویسی وب سیترال کدنویسی گردیده است");
INSERT INTO `wp_postmeta` VALUES("16511", "5257", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("16510", "5257", "description", "");
INSERT INTO `wp_postmeta` VALUES("16509", "2", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("16508", "2", "description", "قالب ایران املاک توسط تیم طراحی و برنامه نویسی وب سیترال کدنویسی گردیده است");
INSERT INTO `wp_postmeta` VALUES("16507", "305", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("16506", "305", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("16505", "1896", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("16504", "1896", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("16503", "212", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("16502", "212", "num-wc", "1");
INSERT INTO `wp_postmeta` VALUES("16501", "212", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("16500", "212", "num-hamam", "2");
INSERT INTO `wp_postmeta` VALUES("16499", "212", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("16498", "212", "tedad-vahed-kol", "");
INSERT INTO `wp_postmeta` VALUES("16497", "212", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16496", "212", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16495", "212", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("16493", "290", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16492", "290", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16489", "294", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16488", "294", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16485", "296", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("16484", "296", "num-wc", "1");
INSERT INTO `wp_postmeta` VALUES("16483", "296", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("16482", "296", "num-hamam", "1");
INSERT INTO `wp_postmeta` VALUES("16481", "296", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16480", "296", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16479", "296", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("16478", "296", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16477", "297", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16476", "297", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16473", "303", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("16472", "303", "num-wc", "1");
INSERT INTO `wp_postmeta` VALUES("16471", "303", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("16470", "303", "num-hamam", "1");
INSERT INTO `wp_postmeta` VALUES("16469", "303", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16468", "303", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16467", "303", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("16466", "303", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16465", "214", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("16464", "214", "num-wc", "2");
INSERT INTO `wp_postmeta` VALUES("16463", "214", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("16462", "214", "num-hamam", "2");
INSERT INTO `wp_postmeta` VALUES("16461", "214", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("16460", "214", "tedad-vahed-kol", "");
INSERT INTO `wp_postmeta` VALUES("16459", "214", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16458", "214", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16457", "214", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("16456", "214", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16455", "221", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("16454", "221", "num-wc", "3");
INSERT INTO `wp_postmeta` VALUES("16453", "221", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("16452", "221", "num-hamam", "3");
INSERT INTO `wp_postmeta` VALUES("16451", "221", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16450", "221", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16449", "221", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("16448", "221", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16447", "223", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16446", "223", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16445", "223", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("16444", "223", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16443", "285", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16442", "285", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16441", "285", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("16440", "285", "why-rejected", "");
INSERT INTO `wp_postmeta` VALUES("16439", "305", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("16438", "305", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("16437", "305", "_wp_old_slug", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-95-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%a7%db%8c%d9%84%d8%a7%d9%85");
INSERT INTO `wp_postmeta` VALUES("16434", "302", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("16433", "302", "num-wc", "2");
INSERT INTO `wp_postmeta` VALUES("16432", "302", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("16431", "302", "num-hamam", "2");
INSERT INTO `wp_postmeta` VALUES("27680", "6529", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("25799", "46", "_wp_old_date", "2022-02-10");
INSERT INTO `wp_postmeta` VALUES("27658", "6527", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27629", "6523", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=خرید+و+فروش");
INSERT INTO `wp_postmeta` VALUES("27628", "6523", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27627", "6523", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27626", "6523", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27625", "6523", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27624", "6523", "_menu_item_object_id", "6523");
INSERT INTO `wp_postmeta` VALUES("27622", "6523", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27623", "6523", "_menu_item_menu_item_parent", "6522");
INSERT INTO `wp_postmeta` VALUES("27634", "6524", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("25750", "6403", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25751", "6405", "name", "۸۹۰کگ۹۰گک۰۹۸");
INSERT INTO `wp_postmeta` VALUES("25752", "6405", "_name", "field_60d5a04f56d1e");
INSERT INTO `wp_postmeta` VALUES("25753", "6405", "phone", "گ۹۸گخعحگهخ");
INSERT INTO `wp_postmeta` VALUES("25754", "6405", "_phone", "field_60d5a06356d1f");
INSERT INTO `wp_postmeta` VALUES("25755", "6405", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("25756", "6405", "_melk", "field_60d5a06e56d20");
INSERT INTO `wp_postmeta` VALUES("25757", "6405", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("25758", "6405", "_moamele", "field_60d5a09656d21");
INSERT INTO `wp_postmeta` VALUES("25759", "6405", "description", "=--۸۰-ج۰۸۹ج-");
INSERT INTO `wp_postmeta` VALUES("25760", "6405", "_description", "field_60d5a0cd56d22");
INSERT INTO `wp_postmeta` VALUES("25761", "6405", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("25762", "6405", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("25763", "6407", "description", "");
INSERT INTO `wp_postmeta` VALUES("25764", "6407", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25765", "6409", "description", "");
INSERT INTO `wp_postmeta` VALUES("25766", "6409", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25767", "6410", "_edit_lock", "1656094834:1");
INSERT INTO `wp_postmeta` VALUES("25768", "6410", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("25769", "6410", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:6:\"nokadr\";}");
INSERT INTO `wp_postmeta` VALUES("25770", "6410", "description", "");
INSERT INTO `wp_postmeta` VALUES("25771", "6410", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25772", "6411", "description", "");
INSERT INTO `wp_postmeta` VALUES("25773", "6411", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25774", "6412", "_edit_lock", "1656417366:1");
INSERT INTO `wp_postmeta` VALUES("25775", "6412", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("25776", "6412", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:6:\"nokadr\";}");
INSERT INTO `wp_postmeta` VALUES("25777", "6412", "description", "");
INSERT INTO `wp_postmeta` VALUES("25778", "6412", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25779", "6413", "description", "");
INSERT INTO `wp_postmeta` VALUES("25780", "6413", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27633", "6524", "_menu_item_object_id", "6524");
INSERT INTO `wp_postmeta` VALUES("27632", "6524", "_menu_item_menu_item_parent", "6523");
INSERT INTO `wp_postmeta` VALUES("27631", "6524", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("16532", "5265", "_wp_attached_file", "2022/01/لوگو-ققنوس-رنگی.png");
INSERT INTO `wp_postmeta` VALUES("16533", "5265", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:5000;s:6:\"height\";i:4639;s:4:\"file\";s:40:\"2022/01/لوگو-ققنوس-رنگی.png\";s:5:\"sizes\";a:15:{s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-300x278.png\";s:5:\"width\";i:300;s:6:\"height\";i:278;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"لوگو-ققنوس-رنگی-1024x950.png\";s:5:\"width\";i:1024;s:6:\"height\";i:950;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-768x713.png\";s:5:\"width\";i:768;s:6:\"height\";i:713;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:42:\"لوگو-ققنوس-رنگی-1536x1425.png\";s:5:\"width\";i:1536;s:6:\"height\";i:1425;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:42:\"لوگو-ققنوس-رنگی-2048x1900.png\";s:5:\"width\";i:2048;s:6:\"height\";i:1900;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:38:\"لوگو-ققنوس-رنگی-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-600x557.png\";s:5:\"width\";i:600;s:6:\"height\";i:557;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-600x557.png\";s:5:\"width\";i:600;s:6:\"height\";i:557;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:40:\"لوگو-ققنوس-رنگی-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("16318", "5239", "_order_currency", "IRT");
INSERT INTO `wp_postmeta` VALUES("16319", "5239", "_cart_discount", "0");
INSERT INTO `wp_postmeta` VALUES("16320", "5239", "_cart_discount_tax", "0");
INSERT INTO `wp_postmeta` VALUES("16317", "5239", "_billing_email", "demo@sitralweb.com");
INSERT INTO `wp_postmeta` VALUES("16315", "5239", "_created_via", "checkout");
INSERT INTO `wp_postmeta` VALUES("16316", "5239", "_cart_hash", "7ebbf6cf26ae90ba4dfabe0c7a4b6df0");
INSERT INTO `wp_postmeta` VALUES("16314", "5239", "_customer_user_agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36");
INSERT INTO `wp_postmeta` VALUES("16313", "5239", "_customer_ip_address", "151.238.154.8");
INSERT INTO `wp_postmeta` VALUES("16311", "5239", "_payment_method", "payir");
INSERT INTO `wp_postmeta` VALUES("16312", "5239", "_payment_method_title", "Pay.ir");
INSERT INTO `wp_postmeta` VALUES("16310", "5239", "_customer_user", "2");
INSERT INTO `wp_postmeta` VALUES("16309", "5239", "_order_key", "wc_order_Rnd1YjNdhRKdK");
INSERT INTO `wp_postmeta` VALUES("27611", "6521", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("17014", "49", "_wp_old_date", "2021-05-01");
INSERT INTO `wp_postmeta` VALUES("17013", "54", "_wp_old_date", "2021-05-01");
INSERT INTO `wp_postmeta` VALUES("17012", "3249", "_wp_old_date", "2021-05-01");
INSERT INTO `wp_postmeta` VALUES("27681", "6529", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("17009", "46", "_wp_old_date", "2021-05-01");
INSERT INTO `wp_postmeta` VALUES("17008", "305", "_wp_old_date", "2020-04-08");
INSERT INTO `wp_postmeta` VALUES("17007", "303", "_wp_old_date", "2020-04-08");
INSERT INTO `wp_postmeta` VALUES("17006", "302", "_wp_old_date", "2020-04-08");
INSERT INTO `wp_postmeta` VALUES("17002", "285", "_wp_old_date", "2020-04-08");
INSERT INTO `wp_postmeta` VALUES("17003", "290", "_wp_old_date", "2020-04-08");
INSERT INTO `wp_postmeta` VALUES("17004", "294", "_wp_old_date", "2020-04-08");
INSERT INTO `wp_postmeta` VALUES("17005", "297", "_wp_old_date", "2020-04-08");
INSERT INTO `wp_postmeta` VALUES("17001", "223", "_wp_old_date", "2018-11-09");
INSERT INTO `wp_postmeta` VALUES("17000", "221", "_wp_old_date", "2018-11-09");
INSERT INTO `wp_postmeta` VALUES("16999", "214", "_wp_old_date", "2018-11-09");
INSERT INTO `wp_postmeta` VALUES("16788", "5271", "_wp_attached_file", "2020/05/icon.png");
INSERT INTO `wp_postmeta` VALUES("16789", "5271", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:46;s:4:\"file\";s:16:\"2020/05/icon.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("16791", "5275", "_edit_lock", "1653767561:1");
INSERT INTO `wp_postmeta` VALUES("16792", "5275", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("16793", "5275", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("16794", "5275", "description", "");
INSERT INTO `wp_postmeta` VALUES("16795", "5275", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("16796", "5276", "description", "");
INSERT INTO `wp_postmeta` VALUES("16797", "5276", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25749", "6403", "description", "");
INSERT INTO `wp_postmeta` VALUES("25748", "6402", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("25747", "6402", "description", "");
INSERT INTO `wp_postmeta` VALUES("25746", "6402", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:8:\"havekadr\";}");
INSERT INTO `wp_postmeta` VALUES("25745", "6402", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("25744", "6402", "_edit_lock", "1669536165:1");
INSERT INTO `wp_postmeta` VALUES("16997", "300", "_wp_old_date", "2021-06-23");
INSERT INTO `wp_postmeta` VALUES("16998", "212", "_wp_old_date", "2022-02-07");
INSERT INTO `wp_postmeta` VALUES("26564", "6442", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:607;s:4:\"file\";s:31:\"2022/07/IMG-20220724-WA0035.jpg\";s:8:\"filesize\";i:46089;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0035-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10423;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"IMG-20220724-WA0035-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65186;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0035-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5111;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0035-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42560;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0035-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15412;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:29:\"IMG-20220724-WA0035-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2044;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0035-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9447;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26563", "6442", "_wp_attached_file", "2022/07/IMG-20220724-WA0035.jpg");
INSERT INTO `wp_postmeta` VALUES("26647", "6446", "gallery", "a:7:{i:0;s:4:\"6439\";i:1;s:4:\"6441\";i:2;s:4:\"6440\";i:3;s:4:\"6442\";i:4;s:4:\"6443\";i:5;s:4:\"6444\";i:6;s:4:\"6445\";}");
INSERT INTO `wp_postmeta` VALUES("26646", "6446", "_sayer-emkanat", "field_5aea8d6fe4f14");
INSERT INTO `wp_postmeta` VALUES("26645", "6446", "sayer-emkanat", "a:19:{i:0;s:4:\"آب\";i:1;s:6:\"برق\";i:2;s:6:\"گاز\";i:3;s:14:\"پارکینگ\";i:4;s:12:\"انباری\";i:5;s:20:\"درب ضد سرقت\";i:6;s:8:\"تلفن\";i:7;s:10:\"شوفاژ\";i:8;s:12:\"شومینه\";i:9;s:8:\"سونا\";i:10;s:10:\"استخر\";i:11;s:10:\"جکوزی\";i:12;s:23:\"آیفون تصویری\";i:13;s:30:\"دوربین مدار بسته\";i:14;s:17:\"درب ریموت\";i:15;s:19:\"آنتن مرکزی\";i:16;s:16:\"باربیکیو\";i:17;s:10:\"بالکن\";i:18;s:16:\"سرایداری\";}");
INSERT INTO `wp_postmeta` VALUES("27465", "6446", "_hmd_code", "6446");
INSERT INTO `wp_postmeta` VALUES("26643", "6446", "kohpaye", "0");
INSERT INTO `wp_postmeta` VALUES("26644", "6446", "_kohpaye", "field_5eef0b5cf73b8");
INSERT INTO `wp_postmeta` VALUES("26642", "6446", "_shahraki", "field_5eef0b52f73b7");
INSERT INTO `wp_postmeta` VALUES("26585", "6446", "mobile", "09123456789");
INSERT INTO `wp_postmeta` VALUES("26586", "6446", "_mobile", "field_5bbb3d4733cd7");
INSERT INTO `wp_postmeta` VALUES("26587", "6446", "email", "");
INSERT INTO `wp_postmeta` VALUES("26588", "6446", "_email", "field_5bbb3d6d33cd9");
INSERT INTO `wp_postmeta` VALUES("26589", "6446", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("26590", "6446", "_moamele", "field_5ae851eab6a30");
INSERT INTO `wp_postmeta` VALUES("26591", "6446", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("26592", "6446", "_melk", "field_5ae856a6e6375");
INSERT INTO `wp_postmeta` VALUES("26593", "6446", "ostan", "");
INSERT INTO `wp_postmeta` VALUES("26594", "6446", "_ostan", "field_5ae85204b6a31");
INSERT INTO `wp_postmeta` VALUES("26595", "6446", "price-form", "نمایش قیمت");
INSERT INTO `wp_postmeta` VALUES("26596", "6446", "_price-form", "field_5f86aeb2fb14c");
INSERT INTO `wp_postmeta` VALUES("26597", "6446", "price-kol", "26000000000");
INSERT INTO `wp_postmeta` VALUES("26598", "6446", "_price-kol", "field_5ae855c7e6371");
INSERT INTO `wp_postmeta` VALUES("26599", "6446", "price-metri", "");
INSERT INTO `wp_postmeta` VALUES("26600", "6446", "_price-metri", "field_5ae855dee6372");
INSERT INTO `wp_postmeta` VALUES("26601", "6446", "metrazh", "550");
INSERT INTO `wp_postmeta` VALUES("26602", "6446", "_metrazh", "field_5ae8575ee637d");
INSERT INTO `wp_postmeta` VALUES("26603", "6446", "masahat-zamin", "1250");
INSERT INTO `wp_postmeta` VALUES("26604", "6446", "_masahat-zamin", "field_5b62b857b72c4");
INSERT INTO `wp_postmeta` VALUES("26605", "6446", "karbari", "مسکونی");
INSERT INTO `wp_postmeta` VALUES("26606", "6446", "_karbari", "field_5f1826676acef");
INSERT INTO `wp_postmeta` VALUES("26607", "6446", "sanad", "تک برگ");
INSERT INTO `wp_postmeta` VALUES("26608", "6446", "_sanad", "field_5aea8b19e4f02");
INSERT INTO `wp_postmeta` VALUES("26609", "6446", "tedad-tabaghat", "");
INSERT INTO `wp_postmeta` VALUES("26610", "6446", "_tedad-tabaghat", "field_5aea8bb9e4f07");
INSERT INTO `wp_postmeta` VALUES("26611", "6446", "tedad-vahed-kol", "");
INSERT INTO `wp_postmeta` VALUES("26612", "6446", "_tedad-vahed-kol", "field_5aea8bfde4f09");
INSERT INTO `wp_postmeta` VALUES("26613", "6446", "otagh", "4");
INSERT INTO `wp_postmeta` VALUES("26614", "6446", "_otagh", "field_5ae8581be6380");
INSERT INTO `wp_postmeta` VALUES("26615", "6446", "num-hamam", "4");
INSERT INTO `wp_postmeta` VALUES("26616", "6446", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("26617", "6446", "num-wc", "4");
INSERT INTO `wp_postmeta` VALUES("26618", "6446", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("26619", "6446", "senbana", "نوساز");
INSERT INTO `wp_postmeta` VALUES("26620", "6446", "_senbana", "field_5bcb08e30cb9c");
INSERT INTO `wp_postmeta` VALUES("26621", "6446", "sokonat", "تخلیه");
INSERT INTO `wp_postmeta` VALUES("26622", "6446", "_sokonat", "field_5aea8c30e4f0a");
INSERT INTO `wp_postmeta` VALUES("26623", "6446", "nama", "مدرن");
INSERT INTO `wp_postmeta` VALUES("26624", "6446", "_nama", "field_5aea8c53e4f0c");
INSERT INTO `wp_postmeta` VALUES("26625", "6446", "kabinet", "");
INSERT INTO `wp_postmeta` VALUES("26626", "6446", "_kabinet", "field_5aea8c60e4f0d");
INSERT INTO `wp_postmeta` VALUES("26627", "6446", "kafposh", "");
INSERT INTO `wp_postmeta` VALUES("26628", "6446", "_kafposh", "field_5aea8d32e4f13");
INSERT INTO `wp_postmeta` VALUES("26629", "6446", "pishforosh", "0");
INSERT INTO `wp_postmeta` VALUES("26630", "6446", "_pishforosh", "field_5eef0522461be");
INSERT INTO `wp_postmeta` VALUES("26631", "6446", "moaveze", "1");
INSERT INTO `wp_postmeta` VALUES("26632", "6446", "_moaveze", "field_5eef0579461bf");
INSERT INTO `wp_postmeta` VALUES("26633", "6446", "moaveze-for", "پول نقد و ملک در تهران");
INSERT INTO `wp_postmeta` VALUES("26634", "6446", "_moaveze-for", "field_5eef05d1461c2");
INSERT INTO `wp_postmeta` VALUES("26635", "6446", "mg", "");
INSERT INTO `wp_postmeta` VALUES("26636", "6446", "_mg", "field_5aea8b49e4f04");
INSERT INTO `wp_postmeta` VALUES("26637", "6446", "mosharekat", "0");
INSERT INTO `wp_postmeta` VALUES("26638", "6446", "_mosharekat", "field_5fbe4dc572edd");
INSERT INTO `wp_postmeta` VALUES("26639", "6446", "saheli", "1");
INSERT INTO `wp_postmeta` VALUES("26640", "6446", "_saheli", "field_5eef0b41f73b6");
INSERT INTO `wp_postmeta` VALUES("26641", "6446", "shahraki", "1");
INSERT INTO `wp_postmeta` VALUES("27021", "305", "_mg-vahed", "field_6276dd820a3e9");
INSERT INTO `wp_postmeta` VALUES("27020", "305", "mg-vahed", "");
INSERT INTO `wp_postmeta` VALUES("27019", "6459", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27018", "6459", "description", "");
INSERT INTO `wp_postmeta` VALUES("27017", "6458", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27016", "6458", "description", "");
INSERT INTO `wp_postmeta` VALUES("27015", "6458", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header3\";s:4:\"kadr\";s:8:\"havekadr\";}");
INSERT INTO `wp_postmeta` VALUES("27014", "6458", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("27013", "6458", "_edit_lock", "1661571633:1");
INSERT INTO `wp_postmeta` VALUES("27012", "6456", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("27011", "6456", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("27010", "6456", "_desc", "field_6065bf17b9a16");
INSERT INTO `wp_postmeta` VALUES("27009", "6456", "desc", "با سلام \r\nشاید به جرات میتونم بگم که یکی از بهترین مشاوره های که بابت خرید املاکام داشتم مشاوره های اقای علیرضا شیری\r\nتو کارشون یکی از بهترین ها هستن البته دقیق در خاطر نیستم ( از نظر عکس ) اما عالی هستند خواستم یک تشکری هم اینجا ازشون داشته باشم و آرزوی سلامتی و سعادت براشون بکنم  . با تشکر");
INSERT INTO `wp_postmeta` VALUES("27008", "6456", "_phone", "field_6065bec9b9a14");
INSERT INTO `wp_postmeta` VALUES("27007", "6456", "phone", "09123603610");
INSERT INTO `wp_postmeta` VALUES("27006", "6456", "_code", "field_60695e1ca3945");
INSERT INTO `wp_postmeta` VALUES("27005", "6456", "code", "3");
INSERT INTO `wp_postmeta` VALUES("27004", "6456", "_name", "field_6065beddb9a15");
INSERT INTO `wp_postmeta` VALUES("27003", "6456", "name", "رز غفوری");
INSERT INTO `wp_postmeta` VALUES("21412", "5518", "description", "");
INSERT INTO `wp_postmeta` VALUES("21413", "5518", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("21414", "5519", "description", "");
INSERT INTO `wp_postmeta` VALUES("21415", "5519", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("21521", "5678", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:648;s:6:\"height\";i:491;s:4:\"file\";s:25:\"2022/02/iranamlakpic2.png\";s:5:\"sizes\";a:9:{s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"iranamlakpic2-300x227.png\";s:5:\"width\";i:300;s:6:\"height\";i:227;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"iranamlakpic2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:25:\"iranamlakpic2-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:23:\"iranamlakpic2-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:25:\"iranamlakpic2-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:25:\"iranamlakpic2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:25:\"iranamlakpic2-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"iranamlakpic2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"iranamlakpic2-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("21520", "5678", "_wp_attached_file", "2022/02/iranamlakpic2.png");
INSERT INTO `wp_postmeta` VALUES("21519", "5676", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:1000;s:4:\"file\";s:24:\"2022/02/iranamlakpic.png\";s:5:\"sizes\";a:10:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"iranamlakpic-288x300.png\";s:5:\"width\";i:288;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"iranamlakpic-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"iranamlakpic-768x800.png\";s:5:\"width\";i:768;s:6:\"height\";i:800;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-370-250\";a:4:{s:4:\"file\";s:24:\"iranamlakpic-370x250.png\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"img-76-61\";a:4:{s:4:\"file\";s:22:\"iranamlakpic-76x61.png\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"img-262-190\";a:4:{s:4:\"file\";s:24:\"iranamlakpic-262x190.png\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:24:\"iranamlakpic-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:24:\"iranamlakpic-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"iranamlakpic-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"iranamlakpic-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("21518", "5676", "_wp_attached_file", "2022/02/iranamlakpic.png");
INSERT INTO `wp_postmeta` VALUES("21517", "223", "_Pets", "field_61fffd76f9003");
INSERT INTO `wp_postmeta` VALUES("21516", "223", "Pets", "مجاز است");
INSERT INTO `wp_postmeta` VALUES("21515", "285", "_Pets", "field_61fffd76f9003");
INSERT INTO `wp_postmeta` VALUES("21514", "285", "Pets", "مجاز است");
INSERT INTO `wp_postmeta` VALUES("21513", "290", "_Pets", "field_61fffd76f9003");
INSERT INTO `wp_postmeta` VALUES("21512", "290", "Pets", "مجاز است");
INSERT INTO `wp_postmeta` VALUES("21509", "297", "_Pets", "field_61fffd76f9003");
INSERT INTO `wp_postmeta` VALUES("21510", "294", "Pets", "مجاز است");
INSERT INTO `wp_postmeta` VALUES("21511", "294", "_Pets", "field_61fffd76f9003");
INSERT INTO `wp_postmeta` VALUES("21508", "297", "Pets", "مجاز است");
INSERT INTO `wp_postmeta` VALUES("21503", "5522", "description", "");
INSERT INTO `wp_postmeta` VALUES("21504", "5522", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("21505", "41", "createquerystate", "a:3:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:8:\"havekadr\";s:13:\"breadcrumb-me\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27778", "285", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27779", "305", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27780", "223", "post_views_count", "3");
INSERT INTO `wp_postmeta` VALUES("26842", "6450", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("26841", "6450", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("26840", "6450", "_description", "field_60d5a0cd56d22");
INSERT INTO `wp_postmeta` VALUES("26839", "6450", "description", "956213.fdbxv 0");
INSERT INTO `wp_postmeta` VALUES("26838", "6450", "_moamele", "field_60d5a09656d21");
INSERT INTO `wp_postmeta` VALUES("26837", "6450", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("26834", "6450", "_phone", "field_60d5a06356d1f");
INSERT INTO `wp_postmeta` VALUES("26835", "6450", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("26836", "6450", "_melk", "field_60d5a06e56d20");
INSERT INTO `wp_postmeta` VALUES("26831", "6450", "name", "rhfdbxv 784512");
INSERT INTO `wp_postmeta` VALUES("26832", "6450", "_name", "field_60d5a04f56d1e");
INSERT INTO `wp_postmeta` VALUES("26833", "6450", "phone", "784512");
INSERT INTO `wp_postmeta` VALUES("27050", "6465", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("27049", "6465", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("27042", "6465", "_name", "field_6065beddb9a15");
INSERT INTO `wp_postmeta` VALUES("27043", "6465", "code", "234523");
INSERT INTO `wp_postmeta` VALUES("27044", "6465", "_code", "field_60695e1ca3945");
INSERT INTO `wp_postmeta` VALUES("27045", "6465", "phone", "903485039458");
INSERT INTO `wp_postmeta` VALUES("27046", "6465", "_phone", "field_6065bec9b9a14");
INSERT INTO `wp_postmeta` VALUES("27047", "6465", "desc", "سلام تست میشه");
INSERT INTO `wp_postmeta` VALUES("27048", "6465", "_desc", "field_6065bf17b9a16");
INSERT INTO `wp_postmeta` VALUES("23918", "302", "mg-vahed", "a:2:{i:0;s:8:\"شرقی\";i:1;s:10:\"جنوبی\";}");
INSERT INTO `wp_postmeta` VALUES("23919", "302", "_mg-vahed", "field_6276dd820a3e9");
INSERT INTO `wp_postmeta` VALUES("25353", "6376", "description", "نکته های مهم موقع خرید خانه");
INSERT INTO `wp_postmeta` VALUES("25712", "5676", "_wp_attachment_image_alt", "ویلا اوکازیون در متل قو");
INSERT INTO `wp_postmeta` VALUES("26990", "6454", "name", "sdsds");
INSERT INTO `wp_postmeta` VALUES("26991", "6454", "_name", "field_60d5a04f56d1e");
INSERT INTO `wp_postmeta` VALUES("26992", "6454", "phone", "545454545454");
INSERT INTO `wp_postmeta` VALUES("26993", "6454", "_phone", "field_60d5a06356d1f");
INSERT INTO `wp_postmeta` VALUES("26994", "6454", "melk", "زمین و کلنگی");
INSERT INTO `wp_postmeta` VALUES("26995", "6454", "_melk", "field_60d5a06e56d20");
INSERT INTO `wp_postmeta` VALUES("26996", "6454", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("26997", "6454", "_moamele", "field_60d5a09656d21");
INSERT INTO `wp_postmeta` VALUES("26998", "6454", "description", "dfsffdfdsf");
INSERT INTO `wp_postmeta` VALUES("26999", "6454", "_description", "field_60d5a0cd56d22");
INSERT INTO `wp_postmeta` VALUES("27000", "6454", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("27001", "6454", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("27002", "3", "_wp_suggested_privacy_policy_content", "a:3:{s:11:\"plugin_name\";s:12:\"وردپرس\";s:11:\"policy_text\";s:7331:\"<h2>ما که هستیم</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>نشانی وب‌سایت ما: https://sitralweb.com/iranamlak.</p><h2>دیدگاه‌ها</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>هنگامی که بازدیدکنندگان نظرات خود را در سایت می‌نویسند، ما اطلاعاتی را که در فرم نظرات و همچنین بازدید کننده‌ها ارائه می‌شود جمع آوری می‌کنیم &#8217;s آدرس IP و رجیستر عامل کاربر مرورگر برای کمک به تشخیص هرزنامه.</p><p>یک رشته ناشناس ایجاد شده از آدرس ایمیل شما (همچنین هش نامیده می‌شود) ممکن است به سرویس Gravatar ارائه شود تا ببینید آیا از آن استفاده می‌کنید. سیاست حفظ حریم خصوصی خدمات Gravatar در اینجا در دسترس است: https://automattic.com/privacy/. پس از تأیید نظر شما، تصویر نمایه شما در متن نظر شما قابل مشاهده است.</p><h2>رسانه</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر تصاویر را به وبسایت آپلود کنید، نباید آپلود تصاویر با داده‌های مکان جغرافیایی (EXIF GPS) شامل شود. بازدیدکنندگان وب سایت می‌توانند هر گونه اطلاعات مکان را از تصاویر در وب سایت دانلود و استخراج کنند.</p><h2>کوکی‌ها</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر شما نظر خود را در سایت ما ثبت کنید، ممکن است برای ذخیره نام، آدرس ایمیل و وب سایت خود در کوکی‌ها تصمیم گیری کنید. اینها برای راحتی شما هستند، به طوری که شما مجبور نیستید دوباره جزئیات خود را پر کنید زمانی که نظر دیگری را ارسال کنید. این کوکی‌ها یک سال طول خواهد کشید.</p><p>اگر از برگه ورود ما بازدید نمایید، ما یک کوکی موقت برای مشخص نمودن اینکه آیا مروگر شما کوکی قبول می‌کند را تنظیم می‌کنیم. این کوکی محتوای اطلاعات شخصی شما نیست و وقتی مرورگر شما بسته می‌شود از بین می‌رود.</p><p>هنگام ورود به سیستم، ما همچنین کوکی‌ها را تنظیم خواهیم کرد تا اطلاعات ورود به سیستم و گزینه‌های صفحه نمایش خود را ذخیره کنید. کوکی‌های ورود به سیستم برای دو روز گذشته و کوکی‌های گزینه‌های صفحه نمایش برای یک سال گذشته است. اگر &quot; مرا به خاطر بسپار &quot; را انتخاب کنید، ورود شما برای دو هفته ادامه خواهد داشت. اگر از حساب خود خارج شوید، کوکی‌های ورود حذف خواهند شد.</p><p>اگر یک مقاله را ویرایش یا منتشر کنید، یک کوکی اضافی در مرورگر شما ذخیره خواهد شد. این کوکی حاوی اطلاعات شخصی نیست و به سادگی نشان می‌دهد که شناسه پست مقاله شما فقط ویرایش شده است. بعد از یک روز منقضی می‌شود.</p><h2>محتوای جاسازی‌شده از دیگر وب‌سایت‌ها</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>مقالات موجود در این سایت ممکن است شامل محتوای تعبیه شده (مثلا ویدئوها، تصاویر، مقالات و غیره) باشد. مطالب جاسازی شده از وب سایت‌های دیگر رفتار دقیقا همان طوری که بازدید کننده از وب سایت دیگر بازدید کرده است.</p><p>این وبسایت‌ها ممکن است اطلاعاتی مربوط به شما را جمع‌آوری کنند، از کوکی‌ها استفاده کنند، ردیابی سوم شخص اضافه را جاسازی کنند و تعامل شما را با محتوای تعبیه شده نظارت کنند که شامل ردیابی تعامل شما با محتوای جاسازی شده است اگر حساب کاربری داشته و به آن وبسایت وارد شده باشید.</p><h2>اطلاعات شما را با چه کسی به اشتراک می‌گذاریم</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر شما یک تنظیم دوباره رمز عبور را درخواست دادید، نشانی IP شما در ایمیل تنظیم دوباره وجود خواهد داشت.</p><h2>چه مدت ما اطلاعات شما را حفظ می‌کنیم</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر یک نظر را ارسال کنید، نظر و متادیتای آن به طور نامحدود حفظ می‌شوند. این به این معنا است که ما می‌توانیم نظرات بعدی را بطور خودکار بجای اینکه در صف بازدید قرار دهیم، تشخیص داده و تایید کنیم.</p><p>برای کاربرانی که در وب سایت ما ثبت نام می‌کنند (اگر وجود داشته باشند)، ما همچنین اطلاعات شخصی را که در مشخصات کاربر آنها ارائه می‌کنیم، ذخیره می‌کنیم. همه کاربران می‌توانند اطلاعات شخصی خود را در هر زمان (به جز آنها که نمی‌توانند نام کاربری خود را تغییر دهند) ببینند، ویرایش و یا حذف کنند. مدیران وب سایت همچنین می‌توانند این اطلاعات را مشاهده و ویرایش کنند.</p><h2>حقوقی که بر روی داده‌هایتان دارید</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>اگر در این سایت حساب کاربری دارید یا نظری ارسال کرده‌اید، می‌توانید درخواست دریافت یک فایل خروجی از اطلاعات شخصی که ما در مورد شما نگه می‌داریم، از جمله هرگونه داده‌ای که برای ما ارائه کرده‌اید را بدهید. همچنین می‌توانید درخواست کنید که ما هرگونه اطلاعات شخصی که در مورد شما داریم را پاک کنیم. این شامل اطلاعاتی نیست که ما مجبور به نگهداری آنها برای اهداف اداری، قانونی یا امنیتی باشیم.</p><h2>داده‌هایتان کجا فرستاده شد</h2><p><strong class=\"privacy-policy-tutorial\">متن پیشنهادی: </strong>دیدگاه‌های بازدیدکننده ممکن است از طریق یک سرویس تشخیص جفنگ خودکار بررسی شوند.</p>\";s:5:\"added\";i:1660806529;}");
INSERT INTO `wp_postmeta` VALUES("26900", "6452", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:960;s:6:\"height\";i:718;s:4:\"file\";s:29:\"2022/08/garden-tower-plan.jpg\";s:8:\"filesize\";i:63369;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"garden-tower-plan-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15616;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"garden-tower-plan-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7562;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"garden-tower-plan-768x574.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:574;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68955;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:29:\"garden-tower-plan-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20637;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:27:\"garden-tower-plan-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2346;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:29:\"garden-tower-plan-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12345;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26899", "6452", "_wp_attached_file", "2022/08/garden-tower-plan.jpg");
INSERT INTO `wp_postmeta` VALUES("27035", "303", "mg-vahed", "");
INSERT INTO `wp_postmeta` VALUES("27036", "303", "_mg-vahed", "field_6276dd820a3e9");
INSERT INTO `wp_postmeta` VALUES("27037", "285", "mg-vahed", "");
INSERT INTO `wp_postmeta` VALUES("27038", "285", "_mg-vahed", "field_6276dd820a3e9");
INSERT INTO `wp_postmeta` VALUES("25741", "5082", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:18.384956778573304;s:5:\"bytes\";i:11889;s:11:\"size_before\";i:64667;s:10:\"size_after\";i:52778;s:4:\"time\";d:0.089999999999999997;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:8:{s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:16.079999999999998;s:5:\"bytes\";i:1177;s:11:\"size_before\";i:7318;s:10:\"size_after\";i:6141;s:4:\"time\";d:0.029999999999999999;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.970000000000001;s:5:\"bytes\";i:675;s:11:\"size_before\";i:4509;s:10:\"size_after\";i:3834;s:4:\"time\";d:0.01;}s:11:\"img-370-250\";O:8:\"stdClass\":5:{s:7:\"percent\";d:18.41;s:5:\"bytes\";i:1928;s:11:\"size_before\";i:10472;s:10:\"size_after\";i:8544;s:4:\"time\";d:0.01;}s:9:\"img-76-61\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.119999999999999;s:5:\"bytes\";i:175;s:11:\"size_before\";i:1730;s:10:\"size_after\";i:1555;s:4:\"time\";d:0.01;}s:11:\"img-262-190\";O:8:\"stdClass\":5:{s:7:\"percent\";d:16.41;s:5:\"bytes\";i:1121;s:11:\"size_before\";i:6830;s:10:\"size_after\";i:5709;s:4:\"time\";d:0.01;}s:21:\"woocommerce_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:18.199999999999999;s:5:\"bytes\";i:2056;s:11:\"size_before\";i:11295;s:10:\"size_after\";i:9239;s:4:\"time\";d:0.01;}s:18:\"woocommerce_single\";O:8:\"stdClass\":5:{s:7:\"percent\";d:22.309999999999999;s:5:\"bytes\";i:4404;s:11:\"size_before\";i:19736;s:10:\"size_after\";i:15332;s:4:\"time\";d:0.01;}s:29:\"woocommerce_gallery_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.710000000000001;s:5:\"bytes\";i:353;s:11:\"size_before\";i:2777;s:10:\"size_after\";i:2424;s:4:\"time\";i:0;}}}");
INSERT INTO `wp_postmeta` VALUES("25740", "5090", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:13.71425528182251;s:5:\"bytes\";i:43777;s:11:\"size_before\";i:319208;s:10:\"size_after\";i:275431;s:4:\"time\";d:7.2800000000000002;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:11:{s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:20.300000000000001;s:5:\"bytes\";i:2121;s:11:\"size_before\";i:10450;s:10:\"size_after\";i:8329;s:4:\"time\";d:0.080000000000000002;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:12.92;s:5:\"bytes\";i:5466;s:11:\"size_before\";i:42322;s:10:\"size_after\";i:36856;s:4:\"time\";d:1.0600000000000001;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:21.09;s:5:\"bytes\";i:1130;s:11:\"size_before\";i:5357;s:10:\"size_after\";i:4227;s:4:\"time\";d:0.02;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.01;s:5:\"bytes\";i:4159;s:11:\"size_before\";i:29687;s:10:\"size_after\";i:25528;s:4:\"time\";d:0.31;}s:9:\"1536x1536\";O:8:\"stdClass\":5:{s:7:\"percent\";d:14.35;s:5:\"bytes\";i:10533;s:11:\"size_before\";i:73383;s:10:\"size_after\";i:62850;s:4:\"time\";d:1.1000000000000001;}s:9:\"2048x2048\";O:8:\"stdClass\":5:{s:7:\"percent\";d:10.109999999999999;s:5:\"bytes\";i:10956;s:11:\"size_before\";i:108325;s:10:\"size_after\";i:97369;s:4:\"time\";d:4.3600000000000003;}s:11:\"img-370-250\";O:8:\"stdClass\":5:{s:7:\"percent\";d:19.579999999999998;s:5:\"bytes\";i:2394;s:11:\"size_before\";i:12224;s:10:\"size_after\";i:9830;s:4:\"time\";d:0.13;}s:9:\"img-76-61\";O:8:\"stdClass\":5:{s:7:\"percent\";d:20.789999999999999;s:5:\"bytes\";i:538;s:11:\"size_before\";i:2588;s:10:\"size_after\";i:2050;s:4:\"time\";d:0.01;}s:11:\"img-262-190\";O:8:\"stdClass\":5:{s:7:\"percent\";d:20.800000000000001;s:5:\"bytes\";i:1826;s:11:\"size_before\";i:8777;s:10:\"size_after\";i:6951;s:4:\"time\";d:0.040000000000000001;}s:18:\"woocommerce_single\";O:8:\"stdClass\":5:{s:7:\"percent\";d:17.370000000000001;s:5:\"bytes\";i:3905;s:11:\"size_before\";i:22484;s:10:\"size_after\";i:18579;s:4:\"time\";d:0.16;}s:29:\"woocommerce_gallery_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:20.739999999999998;s:5:\"bytes\";i:749;s:11:\"size_before\";i:3611;s:10:\"size_after\";i:2862;s:4:\"time\";d:0.01;}}}");
INSERT INTO `wp_postmeta` VALUES("25739", "5251", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:6.535823930465293;s:5:\"bytes\";i:13114;s:11:\"size_before\";i:200648;s:10:\"size_after\";i:187534;s:4:\"time\";d:0.12;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:9:{s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.75;s:5:\"bytes\";i:1188;s:11:\"size_before\";i:17602;s:10:\"size_after\";i:16414;s:4:\"time\";d:0.01;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.8099999999999996;s:5:\"bytes\";i:744;s:11:\"size_before\";i:9530;s:10:\"size_after\";i:8786;s:4:\"time\";d:0.029999999999999999;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.6600000000000001;s:5:\"bytes\";i:3314;s:11:\"size_before\";i:58542;s:10:\"size_after\";i:55228;s:4:\"time\";d:0.01;}s:11:\"img-370-250\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.8899999999999997;s:5:\"bytes\";i:1656;s:11:\"size_before\";i:24048;s:10:\"size_after\";i:22392;s:4:\"time\";d:0.01;}s:9:\"img-76-61\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.3499999999999996;s:5:\"bytes\";i:344;s:11:\"size_before\";i:3680;s:10:\"size_after\";i:3336;s:4:\"time\";d:0.01;}s:11:\"img-262-190\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.5199999999999996;s:5:\"bytes\";i:1229;s:11:\"size_before\";i:16342;s:10:\"size_after\";i:15113;s:4:\"time\";d:0.01;}s:21:\"woocommerce_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.9000000000000004;s:5:\"bytes\";i:1544;s:11:\"size_before\";i:22384;s:10:\"size_after\";i:20840;s:4:\"time\";d:0.01;}s:18:\"woocommerce_single\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.1399999999999997;s:5:\"bytes\";i:2620;s:11:\"size_before\";i:42695;s:10:\"size_after\";i:40075;s:4:\"time\";d:0.02;}s:29:\"woocommerce_gallery_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.1500000000000004;s:5:\"bytes\";i:475;s:11:\"size_before\";i:5825;s:10:\"size_after\";i:5350;s:4:\"time\";d:0.01;}}}");
INSERT INTO `wp_postmeta` VALUES("26653", "6446", "special", "1");
INSERT INTO `wp_postmeta` VALUES("26654", "6446", "_special", "field_5bdd6738da86e");
INSERT INTO `wp_postmeta` VALUES("26655", "6446", "fast", "0");
INSERT INTO `wp_postmeta` VALUES("26656", "6446", "_fast", "field_5bdd6738da8f0");
INSERT INTO `wp_postmeta` VALUES("26657", "6446", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("26658", "6446", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("26659", "6446", "_edit_lock", "1685715028:1");
INSERT INTO `wp_postmeta` VALUES("26660", "6446", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("22526", "17", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:8:\"havekadr\";}");
INSERT INTO `wp_postmeta` VALUES("22525", "3247", "createquerystate", "a:3:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:6:\"nokadr\";s:13:\"breadcrumb-me\";s:3:\"big\";}");
INSERT INTO `wp_postmeta` VALUES("27111", "214", "_wp_old_date", "2022-02-04");
INSERT INTO `wp_postmeta` VALUES("27112", "6477", "_wp_attached_file", "2022/12/20221202_144911-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("22523", "2", "createquerystate", "a:2:{s:6:\"header\";s:6:\"header\";s:4:\"kadr\";s:8:\"havekadr\";}");
INSERT INTO `wp_postmeta` VALUES("23068", "6135", "description", "");
INSERT INTO `wp_postmeta` VALUES("27041", "6465", "name", "سلام تست میشه");
INSERT INTO `wp_postmeta` VALUES("23058", "6127", "description", "");
INSERT INTO `wp_postmeta` VALUES("23060", "6129", "description", "");
INSERT INTO `wp_postmeta` VALUES("23062", "6131", "description", "");
INSERT INTO `wp_postmeta` VALUES("23064", "6132", "description", "");
INSERT INTO `wp_postmeta` VALUES("23066", "6133", "description", "");
INSERT INTO `wp_postmeta` VALUES("25738", "5271", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:8.1458966565349531;s:5:\"bytes\";i:268;s:11:\"size_before\";i:3290;s:10:\"size_after\";i:3022;s:4:\"time\";d:0.040000000000000001;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.1500000000000004;s:5:\"bytes\";i:268;s:11:\"size_before\";i:3290;s:10:\"size_after\";i:3022;s:4:\"time\";d:0.040000000000000001;}}}");
INSERT INTO `wp_postmeta` VALUES("22527", "5782", "description", "");
INSERT INTO `wp_postmeta` VALUES("22528", "5782", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("22531", "4687", "gallerystate", "a:1:{s:7:\"gallery\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27031", "6464", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:25;s:6:\"height\";i:41;s:4:\"file\";s:23:\"2022/10/marker-icon.png\";s:8:\"filesize\";i:1466;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27030", "6464", "_wp_attached_file", "2022/10/marker-icon.png");
INSERT INTO `wp_postmeta` VALUES("26557", "6439", "_wp_attached_file", "2022/07/IMG-20220724-WA0031.jpg");
INSERT INTO `wp_postmeta` VALUES("26558", "6439", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:562;s:4:\"file\";s:31:\"2022/07/IMG-20220724-WA0031.jpg\";s:8:\"filesize\";i:79139;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0031-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13898;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0031-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7605;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0031-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:69951;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0031-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23789;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:29:\"IMG-20220724-WA0031-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2446;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0031-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14157;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27640", "6525", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27638", "6524", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=خرید+و+فروش&mosharekat=1");
INSERT INTO `wp_postmeta` VALUES("27637", "6524", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27610", "6521", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27608", "6521", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27609", "6521", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27647", "6525", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=خرید+و+فروش&pishforosh=1");
INSERT INTO `wp_postmeta` VALUES("27646", "6525", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27645", "6525", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27644", "6525", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27607", "6521", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27652", "6526", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27651", "6526", "_menu_item_object_id", "6526");
INSERT INTO `wp_postmeta` VALUES("27650", "6526", "_menu_item_menu_item_parent", "6522");
INSERT INTO `wp_postmeta` VALUES("27649", "6526", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27606", "6521", "_menu_item_object_id", "39");
INSERT INTO `wp_postmeta` VALUES("27656", "6526", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=رهن+و+اجاره");
INSERT INTO `wp_postmeta` VALUES("27655", "6526", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("20918", "5512", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20917", "5512", "description", "");
INSERT INTO `wp_postmeta` VALUES("20916", "5511", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20915", "5511", "description", "");
INSERT INTO `wp_postmeta` VALUES("23059", "6127", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20914", "5511", "createquerystate", "a:2:{s:6:\"header\";s:6:\"header\";s:4:\"kadr\";s:6:\"nokadr\";}");
INSERT INTO `wp_postmeta` VALUES("20913", "5511", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("20912", "5511", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("20911", "5511", "_edit_lock", "1656417533:1");
INSERT INTO `wp_postmeta` VALUES("20910", "5510", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20909", "5510", "description", "");
INSERT INTO `wp_postmeta` VALUES("20908", "5509", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20907", "5509", "description", "");
INSERT INTO `wp_postmeta` VALUES("23061", "6129", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20906", "5509", "createquerystate", "a:2:{s:6:\"header\";s:6:\"header\";s:4:\"kadr\";s:6:\"nokadr\";}");
INSERT INTO `wp_postmeta` VALUES("20905", "5509", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("20904", "5509", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("20903", "5509", "_edit_lock", "1656417563:1");
INSERT INTO `wp_postmeta` VALUES("20902", "5508", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20901", "5508", "description", "");
INSERT INTO `wp_postmeta` VALUES("20900", "5507", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20899", "5507", "description", "");
INSERT INTO `wp_postmeta` VALUES("23065", "6132", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("23078", "6140", "description", "");
INSERT INTO `wp_postmeta` VALUES("23079", "6140", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("23080", "6141", "description", "");
INSERT INTO `wp_postmeta` VALUES("23081", "6141", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("23082", "6144", "description", "");
INSERT INTO `wp_postmeta` VALUES("23083", "6144", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20898", "5507", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:6:\"nokadr\";}");
INSERT INTO `wp_postmeta` VALUES("20897", "5507", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("20896", "5507", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("20895", "5507", "_edit_lock", "1656417260:1");
INSERT INTO `wp_postmeta` VALUES("20891", "5505", "description", "");
INSERT INTO `wp_postmeta` VALUES("20892", "5505", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20893", "5506", "description", "");
INSERT INTO `wp_postmeta` VALUES("20894", "5506", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("23067", "6133", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("23074", "6138", "description", "");
INSERT INTO `wp_postmeta` VALUES("23075", "6138", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("23076", "6139", "description", "");
INSERT INTO `wp_postmeta` VALUES("23077", "6139", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20890", "5505", "createquerystate", "a:2:{s:6:\"header\";s:6:\"header\";s:4:\"kadr\";s:6:\"nokadr\";}");
INSERT INTO `wp_postmeta` VALUES("20889", "5505", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("20888", "5505", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("20887", "5505", "_edit_lock", "1651093431:1");
INSERT INTO `wp_postmeta` VALUES("27665", "6527", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=اجاره+روزانه");
INSERT INTO `wp_postmeta` VALUES("27664", "6527", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27663", "6527", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27662", "6527", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27661", "6527", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27660", "6527", "_menu_item_object_id", "6527");
INSERT INTO `wp_postmeta` VALUES("20877", "5503", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20876", "5503", "description", "");
INSERT INTO `wp_postmeta` VALUES("20875", "5502", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20874", "5502", "description", "");
INSERT INTO `wp_postmeta` VALUES("23063", "6131", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("23084", "6146", "description", "");
INSERT INTO `wp_postmeta` VALUES("23085", "6146", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20873", "5502", "createquerystate", "a:3:{s:6:\"header\";s:6:\"header\";s:4:\"kadr\";s:6:\"nokadr\";s:13:\"breadcrumb-me\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("20872", "5502", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("20871", "5502", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("20870", "5502", "_edit_lock", "1669533959:1");
INSERT INTO `wp_postmeta` VALUES("20864", "46", "_wp_old_date", "2022-02-06");
INSERT INTO `wp_postmeta` VALUES("20867", "3249", "_wp_old_date", "2022-02-06");
INSERT INTO `wp_postmeta` VALUES("20868", "54", "_wp_old_date", "2022-02-06");
INSERT INTO `wp_postmeta` VALUES("20869", "49", "_wp_old_date", "2022-02-06");
INSERT INTO `wp_postmeta` VALUES("27670", "6528", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27669", "6528", "_menu_item_object_id", "6528");
INSERT INTO `wp_postmeta` VALUES("27668", "6528", "_menu_item_menu_item_parent", "6507");
INSERT INTO `wp_postmeta` VALUES("27667", "6528", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27679", "6529", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27678", "6529", "_menu_item_object_id", "6529");
INSERT INTO `wp_postmeta` VALUES("27677", "6529", "_menu_item_menu_item_parent", "6528");
INSERT INTO `wp_postmeta` VALUES("27676", "6529", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27674", "6528", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("23069", "6135", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20845", "5498", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20844", "5498", "description", "");
INSERT INTO `wp_postmeta` VALUES("20843", "5497", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20842", "5497", "description", "");
INSERT INTO `wp_postmeta` VALUES("20841", "5496", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20840", "5496", "description", "");
INSERT INTO `wp_postmeta` VALUES("23070", "6136", "description", "");
INSERT INTO `wp_postmeta` VALUES("23071", "6136", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("23072", "6137", "description", "");
INSERT INTO `wp_postmeta` VALUES("23073", "6137", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("20839", "5496", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:6:\"nokadr\";}");
INSERT INTO `wp_postmeta` VALUES("20838", "5496", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("20837", "5496", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("20836", "5496", "_edit_lock", "1656096171:1");
INSERT INTO `wp_postmeta` VALUES("21408", "5518", "_edit_lock", "1656417168:1");
INSERT INTO `wp_postmeta` VALUES("21409", "5518", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("21410", "5518", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("21411", "5518", "createquerystate", "a:13:{s:26:\"states_index_catselect_ops\";s:0:\"\";s:7:\"moamele\";s:0:\"\";s:4:\"melk\";s:0:\"\";s:5:\"vijhe\";s:0:\"\";s:4:\"fast\";s:0:\"\";s:10:\"mosharekat\";s:0:\"\";s:7:\"moaveze\";s:0:\"\";s:10:\"pishforosh\";s:0:\"\";s:7:\"kohpaye\";s:0:\"\";s:6:\"saheli\";s:0:\"\";s:8:\"shahraki\";s:0:\"\";s:6:\"header\";s:6:\"header\";s:9:\"numstates\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("20831", "4687", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("20830", "4687", "num-wc", "2");
INSERT INTO `wp_postmeta` VALUES("20829", "4687", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("20828", "4687", "num-hamam", "2");
INSERT INTO `wp_postmeta` VALUES("20827", "4687", "_mantaghe", "field_5fb9212af3d9b");
INSERT INTO `wp_postmeta` VALUES("20826", "4687", "mantaghe", "");
INSERT INTO `wp_postmeta` VALUES("27605", "6521", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("27604", "6521", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("25868", "46", "_wp_old_date", "2022-06-24");
INSERT INTO `wp_postmeta` VALUES("27673", "6528", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27643", "6525", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27616", "6522", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27617", "6522", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27618", "6522", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27619", "6522", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27620", "6522", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("25880", "3249", "_wp_old_date", "2022-06-24");
INSERT INTO `wp_postmeta` VALUES("25881", "54", "_wp_old_date", "2022-06-24");
INSERT INTO `wp_postmeta` VALUES("25882", "49", "_wp_old_date", "2022-06-24");
INSERT INTO `wp_postmeta` VALUES("25884", "6427", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:2132;s:4:\"file\";s:32:\"2022/02/apartment-6-scaled-1.jpg\";s:8:\"filesize\";i:1050617;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"apartment-6-scaled-1-300x250.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21099;}s:5:\"large\";a:5:{s:4:\"file\";s:33:\"apartment-6-scaled-1-1024x853.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:853;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:186296;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"apartment-6-scaled-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8017;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"apartment-6-scaled-1-768x640.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109864;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:34:\"apartment-6-scaled-1-1536x1279.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1279;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:382538;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:34:\"apartment-6-scaled-1-2048x1706.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1706;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:635036;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:32:\"apartment-6-scaled-1-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24925;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:30:\"apartment-6-scaled-1-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2411;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:32:\"apartment-6-scaled-1-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14705;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("25885", "297", "mg-vahed", "");
INSERT INTO `wp_postmeta` VALUES("25886", "297", "_mg-vahed", "field_6276dd820a3e9");
INSERT INTO `wp_postmeta` VALUES("20955", "300", "why-rejected", "محتوای مناسب یافت نشد");
INSERT INTO `wp_postmeta` VALUES("25369", "2288", "celebrations", "مجاز است");
INSERT INTO `wp_postmeta` VALUES("26560", "6440", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:562;s:4:\"file\";s:31:\"2022/07/IMG-20220724-WA0030.jpg\";s:8:\"filesize\";i:52447;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0030-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11912;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0030-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5572;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0030-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51922;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0030-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18344;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:29:\"IMG-20220724-WA0030-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2102;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:31:\"IMG-20220724-WA0030-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10961;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26559", "6440", "_wp_attached_file", "2022/07/IMG-20220724-WA0030.jpg");
INSERT INTO `wp_postmeta` VALUES("25742", "5081", "wp-smpro-smush-data", "a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:2.8390563986957047;s:5:\"bytes\";i:5642;s:11:\"size_before\";i:198728;s:10:\"size_after\";i:193086;s:4:\"time\";d:0.13;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:10:{s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.6900000000000004;s:5:\"bytes\";i:552;s:11:\"size_before\";i:11767;s:10:\"size_after\";i:11215;s:4:\"time\";d:0.01;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.6299999999999999;s:5:\"bytes\";i:1012;s:11:\"size_before\";i:62105;s:10:\"size_after\";i:61093;s:4:\"time\";d:0.029999999999999999;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.4400000000000004;s:5:\"bytes\";i:400;s:11:\"size_before\";i:6215;s:10:\"size_after\";i:5815;s:4:\"time\";d:0.01;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9099999999999999;s:5:\"bytes\";i:798;s:11:\"size_before\";i:41792;s:10:\"size_after\";i:40994;s:4:\"time\";d:0.01;}s:11:\"img-370-250\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.1100000000000003;s:5:\"bytes\";i:636;s:11:\"size_before\";i:15485;s:10:\"size_after\";i:14849;s:4:\"time\";d:0.01;}s:9:\"img-76-61\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.2899999999999991;s:5:\"bytes\";i:195;s:11:\"size_before\";i:2353;s:10:\"size_after\";i:2158;s:4:\"time\";d:0.02;}s:11:\"img-262-190\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.7000000000000002;s:5:\"bytes\";i:466;s:11:\"size_before\";i:9915;s:10:\"size_after\";i:9449;s:4:\"time\";d:0.01;}s:21:\"woocommerce_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.48;s:5:\"bytes\";i:527;s:11:\"size_before\";i:15161;s:10:\"size_after\";i:14634;s:4:\"time\";d:0.01;}s:18:\"woocommerce_single\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.6200000000000001;s:5:\"bytes\";i:790;s:11:\"size_before\";i:30192;s:10:\"size_after\";i:29402;s:4:\"time\";d:0.01;}s:29:\"woocommerce_gallery_thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.1100000000000003;s:5:\"bytes\";i:266;s:11:\"size_before\";i:3743;s:10:\"size_after\";i:3477;s:4:\"time\";d:0.01;}}}");
INSERT INTO `wp_postmeta` VALUES("20963", "4687", "_wp_old_date", "2021-04-29");
INSERT INTO `wp_postmeta` VALUES("20962", "305", "_Pets", "field_61fffd76f9003");
INSERT INTO `wp_postmeta` VALUES("20961", "305", "Pets", "مجاز است");
INSERT INTO `wp_postmeta` VALUES("20960", "300", "_num-wc", "field_5eeefc8ce2bcb");
INSERT INTO `wp_postmeta` VALUES("20959", "300", "num-wc", "");
INSERT INTO `wp_postmeta` VALUES("20958", "300", "_num-hamam", "field_5eeefc64e2bca");
INSERT INTO `wp_postmeta` VALUES("20957", "300", "num-hamam", "");
INSERT INTO `wp_postmeta` VALUES("20956", "300", "_why-rejected", "field_60d5fc3512771");
INSERT INTO `wp_postmeta` VALUES("27570", "6517", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27571", "6517", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?melk=خانه+و+ویلا");
INSERT INTO `wp_postmeta` VALUES("27542", "6514", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27543", "6514", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27544", "6514", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27697", "6531", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27546", "6515", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27547", "6515", "_menu_item_menu_item_parent", "6507");
INSERT INTO `wp_postmeta` VALUES("27548", "6515", "_menu_item_object_id", "6515");
INSERT INTO `wp_postmeta` VALUES("27549", "6515", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27550", "6515", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27551", "6515", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27552", "6515", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27553", "6515", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("27696", "6531", "_menu_item_object_id", "6531");
INSERT INTO `wp_postmeta` VALUES("27555", "6516", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27556", "6516", "_menu_item_menu_item_parent", "6515");
INSERT INTO `wp_postmeta` VALUES("27557", "6516", "_menu_item_object_id", "6516");
INSERT INTO `wp_postmeta` VALUES("27558", "6516", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27559", "6516", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27560", "6516", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27561", "6516", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27562", "6516", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?melk=آپارتمان");
INSERT INTO `wp_postmeta` VALUES("27564", "6517", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27565", "6517", "_menu_item_menu_item_parent", "6515");
INSERT INTO `wp_postmeta` VALUES("27566", "6517", "_menu_item_object_id", "6517");
INSERT INTO `wp_postmeta` VALUES("27567", "6517", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27568", "6517", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27569", "6517", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27053", "6469", "_edit_lock", "1668939030:1");
INSERT INTO `wp_postmeta` VALUES("27054", "6469", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("27055", "6469", "createquerystate", "a:2:{s:6:\"header\";s:7:\"header3\";s:4:\"kadr\";s:8:\"havekadr\";}");
INSERT INTO `wp_postmeta` VALUES("27056", "6469", "description", "");
INSERT INTO `wp_postmeta` VALUES("27057", "6469", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27058", "6470", "description", "");
INSERT INTO `wp_postmeta` VALUES("27059", "6470", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27082", "3249", "_wp_old_date", "2022-06-25");
INSERT INTO `wp_postmeta` VALUES("27083", "54", "_wp_old_date", "2022-06-25");
INSERT INTO `wp_postmeta` VALUES("27084", "49", "_wp_old_date", "2022-06-25");
INSERT INTO `wp_postmeta` VALUES("27085", "6472", "_wp_attached_file", "2022/11/111620_18558047_3383912_dbffd7a9_image.jpg");
INSERT INTO `wp_postmeta` VALUES("27086", "6472", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:1000;s:4:\"file\";s:50:\"2022/11/111620_18558047_3383912_dbffd7a9_image.jpg\";s:8:\"filesize\";i:747570;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:50:\"111620_18558047_3383912_dbffd7a9_image-300x250.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12410;}s:5:\"large\";a:5:{s:4:\"file\";s:51:\"111620_18558047_3383912_dbffd7a9_image-1024x853.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:853;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:92579;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:50:\"111620_18558047_3383912_dbffd7a9_image-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5463;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:50:\"111620_18558047_3383912_dbffd7a9_image-768x640.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:56880;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:50:\"111620_18558047_3383912_dbffd7a9_image-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15982;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:48:\"111620_18558047_3383912_dbffd7a9_image-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1996;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:50:\"111620_18558047_3383912_dbffd7a9_image-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9614;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27087", "6473", "_wp_attached_file", "2022/11/311.jpg");
INSERT INTO `wp_postmeta` VALUES("27088", "6473", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1654;s:6:\"height\";i:1240;s:4:\"file\";s:15:\"2022/11/311.jpg\";s:8:\"filesize\";i:100846;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"311-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19989;}s:5:\"large\";a:5:{s:4:\"file\";s:16:\"311-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:148609;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"311-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7892;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:15:\"311-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:95226;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:17:\"311-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:271724;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:15:\"311-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26851;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:13:\"311-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2449;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:15:\"311-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15383;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27089", "6475", "description", "نکته های مهم موقع خرید خانه");
INSERT INTO `wp_postmeta` VALUES("27090", "6475", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27113", "6477", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1920;s:6:\"height\";i:2560;s:4:\"file\";s:34:\"2022/12/20221202_144911-scaled.jpg\";s:8:\"filesize\";i:363789;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"20221202_144911-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12194;}s:5:\"large\";a:5:{s:4:\"file\";s:28:\"20221202_144911-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76853;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"20221202_144911-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5761;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:28:\"20221202_144911-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76853;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:29:\"20221202_144911-1152x1536.jpg\";s:5:\"width\";i:1152;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:150067;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:29:\"20221202_144911-1536x2048.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:246081;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:27:\"20221202_144911-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15667;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:25:\"20221202_144911-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2175;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:27:\"20221202_144911-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9983;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"SM-A515F\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1669992552\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"4.6\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:4:\"0.05\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:19:\"20221202_144911.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("27750", "6537", "_menu_item_object_id", "25");
INSERT INTO `wp_postmeta` VALUES("27749", "6537", "_menu_item_menu_item_parent", "6507");
INSERT INTO `wp_postmeta` VALUES("27745", "6536", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27746", "6536", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27784", "290", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27748", "6537", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27744", "6536", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27743", "6536", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27742", "6536", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27741", "6536", "_menu_item_object_id", "6412");
INSERT INTO `wp_postmeta` VALUES("27740", "6536", "_menu_item_menu_item_parent", "6533");
INSERT INTO `wp_postmeta` VALUES("27739", "6536", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27785", "221", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27786", "214", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27737", "6535", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27736", "6535", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27735", "6535", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27734", "6535", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27733", "6535", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27732", "6535", "_menu_item_object_id", "6410");
INSERT INTO `wp_postmeta` VALUES("27731", "6535", "_menu_item_menu_item_parent", "6533");
INSERT INTO `wp_postmeta` VALUES("27730", "6535", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27787", "300", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27728", "6534", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27727", "6534", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27726", "6534", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27725", "6534", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27724", "6534", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27723", "6534", "_menu_item_object_id", "5507");
INSERT INTO `wp_postmeta` VALUES("27722", "6534", "_menu_item_menu_item_parent", "6533");
INSERT INTO `wp_postmeta` VALUES("27721", "6534", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27719", "6533", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("27718", "6533", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27717", "6533", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27716", "6533", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27715", "6533", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27714", "6533", "_menu_item_object_id", "6533");
INSERT INTO `wp_postmeta` VALUES("27713", "6533", "_menu_item_menu_item_parent", "6507");
INSERT INTO `wp_postmeta` VALUES("27712", "6533", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27710", "6532", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=رهن+و+اجاره&max_ejare=10000000&min_rahn=&max_rahn=250000000");
INSERT INTO `wp_postmeta` VALUES("27709", "6532", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27708", "6532", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27707", "6532", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27706", "6532", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27705", "6532", "_menu_item_object_id", "6532");
INSERT INTO `wp_postmeta` VALUES("27704", "6532", "_menu_item_menu_item_parent", "6528");
INSERT INTO `wp_postmeta` VALUES("27591", "46", "_wp_old_date", "2023-01-08");
INSERT INTO `wp_postmeta` VALUES("27592", "3249", "_wp_old_date", "2023-01-08");
INSERT INTO `wp_postmeta` VALUES("27583", "6519", "_menu_item_menu_item_parent", "6515");
INSERT INTO `wp_postmeta` VALUES("27584", "6519", "_menu_item_object_id", "6519");
INSERT INTO `wp_postmeta` VALUES("27585", "6519", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27586", "6519", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27587", "6519", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27588", "6519", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27589", "6519", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?melk=زمین+و+کلنگی");
INSERT INTO `wp_postmeta` VALUES("27582", "6519", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27593", "54", "_wp_old_date", "2023-01-08");
INSERT INTO `wp_postmeta` VALUES("27573", "6518", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27574", "6518", "_menu_item_menu_item_parent", "6515");
INSERT INTO `wp_postmeta` VALUES("27575", "6518", "_menu_item_object_id", "6518");
INSERT INTO `wp_postmeta` VALUES("27576", "6518", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27577", "6518", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27578", "6518", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27579", "6518", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27580", "6518", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?melk=اداری+و+تجاری");
INSERT INTO `wp_postmeta` VALUES("27594", "49", "_wp_old_date", "2023-01-08");
INSERT INTO `wp_postmeta` VALUES("27695", "6531", "_menu_item_menu_item_parent", "6528");
INSERT INTO `wp_postmeta` VALUES("27198", "6479", "name", "علی");
INSERT INTO `wp_postmeta` VALUES("27199", "6479", "_name", "field_60d5a04f56d1e");
INSERT INTO `wp_postmeta` VALUES("27200", "6479", "phone", "09337239853");
INSERT INTO `wp_postmeta` VALUES("27201", "6479", "_phone", "field_60d5a06356d1f");
INSERT INTO `wp_postmeta` VALUES("27202", "6479", "melk", "آپارتمان");
INSERT INTO `wp_postmeta` VALUES("27203", "6479", "_melk", "field_60d5a06e56d20");
INSERT INTO `wp_postmeta` VALUES("27204", "6479", "moamele", "رهن و اجاره");
INSERT INTO `wp_postmeta` VALUES("27205", "6479", "_moamele", "field_60d5a09656d21");
INSERT INTO `wp_postmeta` VALUES("27206", "6479", "description", "سلام");
INSERT INTO `wp_postmeta` VALUES("27207", "6479", "_description", "field_60d5a0cd56d22");
INSERT INTO `wp_postmeta` VALUES("27208", "6479", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("27209", "6479", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("27210", "6480", "name", "علی");
INSERT INTO `wp_postmeta` VALUES("27211", "6480", "_name", "field_60d5a04f56d1e");
INSERT INTO `wp_postmeta` VALUES("27212", "6480", "phone", "09337239853");
INSERT INTO `wp_postmeta` VALUES("27213", "6480", "_phone", "field_60d5a06356d1f");
INSERT INTO `wp_postmeta` VALUES("27214", "6480", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("27215", "6480", "_melk", "field_60d5a06e56d20");
INSERT INTO `wp_postmeta` VALUES("27216", "6480", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("27217", "6480", "_moamele", "field_60d5a09656d21");
INSERT INTO `wp_postmeta` VALUES("27218", "6480", "description", "نمت");
INSERT INTO `wp_postmeta` VALUES("27219", "6480", "_description", "field_60d5a0cd56d22");
INSERT INTO `wp_postmeta` VALUES("27220", "6480", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("27221", "6480", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("27222", "6481", "_wp_attached_file", "2022/12/wYj-S8cT.1.jpg");
INSERT INTO `wp_postmeta` VALUES("27223", "6481", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1125;s:6:\"height\";i:1500;s:4:\"file\";s:22:\"2022/12/wYj-S8cT.1.jpg\";s:8:\"filesize\";i:176424;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.1-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15562;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"wYj-S8cT.1-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112823;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6508;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"wYj-S8cT.1-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112823;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.1-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20847;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:20:\"wYj-S8cT.1-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2234;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.1-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12281;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:21:\"Payam Gooyan Ava Pars\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:21:\"Payam Gooyan Ava Pars\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27224", "6482", "_wp_attached_file", "2022/12/wYj-S8cT.1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("27225", "6482", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1125;s:6:\"height\";i:1500;s:4:\"file\";s:24:\"2022/12/wYj-S8cT.1-1.jpg\";s:8:\"filesize\";i:176424;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"wYj-S8cT.1-1-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15562;}s:5:\"large\";a:5:{s:4:\"file\";s:25:\"wYj-S8cT.1-1-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112823;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"wYj-S8cT.1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6508;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"wYj-S8cT.1-1-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112823;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:24:\"wYj-S8cT.1-1-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20847;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.1-1-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2234;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:24:\"wYj-S8cT.1-1-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12281;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:21:\"Payam Gooyan Ava Pars\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:21:\"Payam Gooyan Ava Pars\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27226", "6483", "_wp_attached_file", "2022/12/wYj-S8cT.2.jpg");
INSERT INTO `wp_postmeta` VALUES("27227", "6483", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1125;s:6:\"height\";i:1500;s:4:\"file\";s:22:\"2022/12/wYj-S8cT.2.jpg\";s:8:\"filesize\";i:201263;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.2-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16040;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"wYj-S8cT.2-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:125379;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6898;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"wYj-S8cT.2-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:125379;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.2-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23078;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:20:\"wYj-S8cT.2-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2384;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.2-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13486;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:21:\"Payam Gooyan Ava Pars\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:21:\"Payam Gooyan Ava Pars\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27228", "6484", "_wp_attached_file", "2022/12/wYj-S8cT.4.jpg");
INSERT INTO `wp_postmeta` VALUES("27229", "6484", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1125;s:6:\"height\";i:1500;s:4:\"file\";s:22:\"2022/12/wYj-S8cT.4.jpg\";s:8:\"filesize\";i:101318;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.4-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9140;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"wYj-S8cT.4-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66371;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4357;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"wYj-S8cT.4-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66371;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.4-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12549;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:20:\"wYj-S8cT.4-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1817;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:22:\"wYj-S8cT.4-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7712;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:21:\"Payam Gooyan Ava Pars\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:21:\"Payam Gooyan Ava Pars\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27230", "6485", "_wp_attached_file", "2022/12/wYj-S8cT.jpg");
INSERT INTO `wp_postmeta` VALUES("27231", "6485", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1125;s:6:\"height\";i:1500;s:4:\"file\";s:20:\"2022/12/wYj-S8cT.jpg\";s:8:\"filesize\";i:208174;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"wYj-S8cT-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15212;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"wYj-S8cT-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127246;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"wYj-S8cT-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6291;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:21:\"wYj-S8cT-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127246;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:20:\"wYj-S8cT-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21750;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:18:\"wYj-S8cT-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2210;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:20:\"wYj-S8cT-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12513;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:21:\"Payam Gooyan Ava Pars\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:21:\"Payam Gooyan Ava Pars\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27777", "303", "post_views_count", "3");
INSERT INTO `wp_postmeta` VALUES("27773", "6539", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27772", "6539", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27771", "6539", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27770", "6539", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27769", "6539", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27768", "6539", "_menu_item_object_id", "6458");
INSERT INTO `wp_postmeta` VALUES("27767", "6539", "_menu_item_menu_item_parent", "6537");
INSERT INTO `wp_postmeta` VALUES("27766", "6539", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27781", "212", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27764", "6538", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27782", "1896", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27763", "6538", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27762", "6538", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27755", "6537", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27783", "294", "post_views_count", "2");
INSERT INTO `wp_postmeta` VALUES("27757", "6538", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27758", "6538", "_menu_item_menu_item_parent", "6537");
INSERT INTO `wp_postmeta` VALUES("27759", "6538", "_menu_item_object_id", "25");
INSERT INTO `wp_postmeta` VALUES("27760", "6538", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27761", "6538", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27754", "6537", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27751", "6537", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27752", "6537", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27753", "6537", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27321", "6487", "name", "test");
INSERT INTO `wp_postmeta` VALUES("27322", "6487", "_name", "field_60d5a04f56d1e");
INSERT INTO `wp_postmeta` VALUES("27323", "6487", "phone", "09380535845");
INSERT INTO `wp_postmeta` VALUES("27324", "6487", "_phone", "field_60d5a06356d1f");
INSERT INTO `wp_postmeta` VALUES("27325", "6487", "melk", "خانه و ویلا");
INSERT INTO `wp_postmeta` VALUES("27326", "6487", "_melk", "field_60d5a06e56d20");
INSERT INTO `wp_postmeta` VALUES("27327", "6487", "moamele", "خرید و فروش");
INSERT INTO `wp_postmeta` VALUES("27328", "6487", "_moamele", "field_60d5a09656d21");
INSERT INTO `wp_postmeta` VALUES("27329", "6487", "description", "ویلا اوکازیون در متل قو");
INSERT INTO `wp_postmeta` VALUES("27330", "6487", "_description", "field_60d5a0cd56d22");
INSERT INTO `wp_postmeta` VALUES("27331", "6487", "_validate_email", "");
INSERT INTO `wp_postmeta` VALUES("27332", "6487", "__validate_email", "_validate_email");
INSERT INTO `wp_postmeta` VALUES("27333", "6489", "_wp_attached_file", "2022/12/20200521_183337-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("27334", "6489", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:34:\"2022/12/20200521_183337-scaled.jpg\";s:8:\"filesize\";i:360451;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"20200521_183337-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8328;}s:5:\"large\";a:5:{s:4:\"file\";s:28:\"20200521_183337-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64234;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"20200521_183337-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3651;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:27:\"20200521_183337-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38945;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:29:\"20200521_183337-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:134367;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:29:\"20200521_183337-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:233376;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:27:\"20200521_183337-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10776;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:25:\"20200521_183337-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1540;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:27:\"20200521_183337-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6508;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.9\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"SM-J500F\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1590086017\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"3.7\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:16:\"0.03030303030303\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:19:\"20200521_183337.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("27335", "6490", "_wp_attached_file", "2022/12/DSC04167-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("27336", "6490", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:27:\"2022/12/DSC04167-scaled.jpg\";s:8:\"filesize\";i:405458;s:5:\"sizes\";a:9:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"DSC04167-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9084;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"DSC04167-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68782;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"DSC04167-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4577;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"DSC04167-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40874;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:22:\"DSC04167-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:152031;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:22:\"DSC04167-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:264076;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:20:\"DSC04167-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11612;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:18:\"DSC04167-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1740;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:20:\"DSC04167-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7240;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"DSC-S750\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1204838975\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"5.8\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:12:\"DSC04167.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("27540", "6514", "_menu_item_object", "state_category");
INSERT INTO `wp_postmeta` VALUES("27539", "6514", "_menu_item_object_id", "1419");
INSERT INTO `wp_postmeta` VALUES("27538", "6514", "_menu_item_menu_item_parent", "6512");
INSERT INTO `wp_postmeta` VALUES("27537", "6514", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("27698", "6531", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27535", "6513", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27534", "6513", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27533", "6513", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27532", "6513", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27531", "6513", "_menu_item_object", "state_category");
INSERT INTO `wp_postmeta` VALUES("27530", "6513", "_menu_item_object_id", "1418");
INSERT INTO `wp_postmeta` VALUES("27529", "6513", "_menu_item_menu_item_parent", "6512");
INSERT INTO `wp_postmeta` VALUES("27528", "6513", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("27699", "6531", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27526", "6512", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27525", "6512", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27524", "6512", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27523", "6512", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27522", "6512", "_menu_item_object", "state_category");
INSERT INTO `wp_postmeta` VALUES("27521", "6512", "_menu_item_object_id", "1412");
INSERT INTO `wp_postmeta` VALUES("27520", "6512", "_menu_item_menu_item_parent", "6508");
INSERT INTO `wp_postmeta` VALUES("27519", "6512", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("27700", "6531", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27517", "6511", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27516", "6511", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27515", "6511", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27514", "6511", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27513", "6511", "_menu_item_object", "state_category");
INSERT INTO `wp_postmeta` VALUES("27512", "6511", "_menu_item_object_id", "1386");
INSERT INTO `wp_postmeta` VALUES("27511", "6511", "_menu_item_menu_item_parent", "6509");
INSERT INTO `wp_postmeta` VALUES("27510", "6511", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("27701", "6531", "_menu_item_url", "https://sitralweb.com/iranamlak/جستجو/?moamele=خرید+و+فروش&ostan=1412&melk=آپارتمان");
INSERT INTO `wp_postmeta` VALUES("27508", "6510", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27507", "6510", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27506", "6510", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27505", "6510", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27504", "6510", "_menu_item_object", "state_category");
INSERT INTO `wp_postmeta` VALUES("27503", "6510", "_menu_item_object_id", "1391");
INSERT INTO `wp_postmeta` VALUES("27502", "6510", "_menu_item_menu_item_parent", "6509");
INSERT INTO `wp_postmeta` VALUES("27501", "6510", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("27499", "6509", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27498", "6509", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27497", "6509", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27496", "6509", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27495", "6509", "_menu_item_object", "state_category");
INSERT INTO `wp_postmeta` VALUES("27494", "6509", "_menu_item_object_id", "1422");
INSERT INTO `wp_postmeta` VALUES("27493", "6509", "_menu_item_menu_item_parent", "6508");
INSERT INTO `wp_postmeta` VALUES("27492", "6509", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("27476", "6507", "_menu_item_object_id", "25");
INSERT INTO `wp_postmeta` VALUES("27477", "6507", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("27478", "6507", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27479", "6507", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27480", "6507", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27481", "6507", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("27703", "6532", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27483", "6508", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("27484", "6508", "_menu_item_menu_item_parent", "6507");
INSERT INTO `wp_postmeta` VALUES("27485", "6508", "_menu_item_object_id", "6508");
INSERT INTO `wp_postmeta` VALUES("27486", "6508", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("27487", "6508", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27488", "6508", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27489", "6508", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("27490", "6508", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("27475", "6507", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("27474", "6507", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27473", "6505", "_edit_lock", "1685715134:1");
INSERT INTO `wp_postmeta` VALUES("27472", "6506", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27469", "6505", "description", "");
INSERT INTO `wp_postmeta` VALUES("27470", "6505", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27471", "6506", "description", "");
INSERT INTO `wp_postmeta` VALUES("27468", "6505", "createquerystate", "a:3:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:8:\"havekadr\";s:13:\"breadcrumb-me\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27467", "6505", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("27423", "6492", "_wp_attached_file", "2023/01/File-3.gif");
INSERT INTO `wp_postmeta` VALUES("27424", "6492", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:468;s:6:\"height\";i:60;s:4:\"file\";s:18:\"2023/01/File-3.gif\";s:8:\"filesize\";i:7629;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"File-3-300x38.gif\";s:5:\"width\";i:300;s:6:\"height\";i:38;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:4434;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"File-3-150x60.gif\";s:5:\"width\";i:150;s:6:\"height\";i:60;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:4145;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:17:\"File-3-370x60.gif\";s:5:\"width\";i:370;s:6:\"height\";i:60;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:5760;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:16:\"File-3-76x60.gif\";s:5:\"width\";i:76;s:6:\"height\";i:60;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:2669;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:17:\"File-3-262x60.gif\";s:5:\"width\";i:262;s:6:\"height\";i:60;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:4977;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27425", "6493", "_wp_attached_file", "2023/01/File-8.gif");
INSERT INTO `wp_postmeta` VALUES("27426", "6493", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:120;s:6:\"height\";i:240;s:4:\"file\";s:18:\"2023/01/File-8.gif\";s:8:\"filesize\";i:32737;s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"File-8-120x150.gif\";s:5:\"width\";i:120;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:10103;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:16:\"File-8-76x61.gif\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:2851;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:18:\"File-8-120x190.gif\";s:5:\"width\";i:120;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:12371;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27427", "6494", "_wp_attached_file", "2023/01/joda1.jpg");
INSERT INTO `wp_postmeta` VALUES("27428", "6494", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1675;s:6:\"height\";i:99;s:4:\"file\";s:17:\"2023/01/joda1.jpg\";s:8:\"filesize\";i:12976;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"joda1-300x18.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:18;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1812;}s:5:\"large\";a:5:{s:4:\"file\";s:17:\"joda1-1024x61.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5997;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"joda1-150x99.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:99;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2914;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:16:\"joda1-768x45.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4272;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:17:\"joda1-1536x91.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:91;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9705;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:16:\"joda1-370x99.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:99;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5718;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:15:\"joda1-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1637;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:16:\"joda1-262x99.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:99;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4073;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27429", "6495", "_wp_attached_file", "2023/01/Screenshot_۲۰۲۳۰۱۰۲-۰۱۰۷۲۸_Divar.jpg");
INSERT INTO `wp_postmeta` VALUES("27430", "6495", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:720;s:6:\"height\";i:518;s:4:\"file\";s:58:\"2023/01/Screenshot_۲۰۲۳۰۱۰۲-۰۱۰۷۲۸_Divar.jpg\";s:8:\"filesize\";i:91153;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:58:\"Screenshot_۲۰۲۳۰۱۰۲-۰۱۰۷۲۸_Divar-300x216.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:216;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12639;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:58:\"Screenshot_۲۰۲۳۰۱۰۲-۰۱۰۷۲۸_Divar-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5710;}s:11:\"img-370-250\";a:5:{s:4:\"file\";s:58:\"Screenshot_۲۰۲۳۰۱۰۲-۰۱۰۷۲۸_Divar-370x250.jpg\";s:5:\"width\";i:370;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16693;}s:9:\"img-76-61\";a:5:{s:4:\"file\";s:56:\"Screenshot_۲۰۲۳۰۱۰۲-۰۱۰۷۲۸_Divar-76x61.jpg\";s:5:\"width\";i:76;s:6:\"height\";i:61;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2124;}s:11:\"img-262-190\";a:5:{s:4:\"file\";s:58:\"Screenshot_۲۰۲۳۰۱۰۲-۰۱۰۷۲۸_Divar-262x190.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10315;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("27431", "6497", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("27432", "6497", "createquerystate", "a:3:{s:6:\"header\";s:7:\"header2\";s:4:\"kadr\";s:8:\"havekadr\";s:13:\"breadcrumb-me\";s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27433", "6497", "description", "");
INSERT INTO `wp_postmeta` VALUES("27434", "6497", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27435", "6498", "description", "");
INSERT INTO `wp_postmeta` VALUES("27436", "6498", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27437", "6497", "_edit_lock", "1673208437:1");
INSERT INTO `wp_postmeta` VALUES("27438", "6499", "description", "");
INSERT INTO `wp_postmeta` VALUES("27439", "6499", "_description", "field_5bbda7f9fe590");
INSERT INTO `wp_postmeta` VALUES("27440", "46", "_wp_old_date", "2022-11-20");
INSERT INTO `wp_postmeta` VALUES("27614", "6522", "_menu_item_menu_item_parent", "6507");
INSERT INTO `wp_postmeta` VALUES("27615", "6522", "_menu_item_object_id", "6522");
INSERT INTO `wp_postmeta` VALUES("27775", "6446", "post_views_count", "3");
INSERT INTO `wp_postmeta` VALUES("27776", "302", "post_views_count", "4");
INSERT INTO `wp_postmeta` VALUES("27654", "6526", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27635", "6524", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27636", "6524", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("27595", "6520", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27454", "3249", "_wp_old_date", "2022-11-20");
INSERT INTO `wp_postmeta` VALUES("27455", "54", "_wp_old_date", "2022-11-20");
INSERT INTO `wp_postmeta` VALUES("27456", "49", "_wp_old_date", "2022-11-20");
INSERT INTO `wp_postmeta` VALUES("27541", "6514", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("27464", "214", "_hmd_code_type", "3");
INSERT INTO `wp_postmeta` VALUES("27466", "6446", "_hmd_code_type", "3");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("2", "1", "2020-05-30 09:50:04", "2020-05-30 05:20:04", "", "صفحه نخست", "", "publish", "closed", "closed", "", "%d8%b5%d9%81%d8%ad%d9%87-%d9%86%d8%ae%d8%b3%d8%aa", "", "", "2022-11-20 13:41:38", "2022-11-20 10:11:38", "", "0", "http://sitralweb.com/iranamlak2/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5258", "1", "2022-01-01 11:48:25", "2022-01-01 08:18:25", "", "صفحه نخست", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2022-01-01 11:48:25", "2022-01-01 08:18:25", "", "2", "https://sitralweb.com/ir3/?p=5258", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5265", "2", "2022-01-18 13:29:31", "2022-01-18 09:59:31", "", "لوگو ققنوس رنگی", "", "inherit", "open", "closed", "", "%d9%84%d9%88%da%af%d9%88-%d9%82%d9%82%d9%86%d9%88%d8%b3-%d8%b1%d9%86%da%af%db%8c", "", "", "2022-01-18 13:29:31", "2022-01-18 09:59:31", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/01/لوگو-ققنوس-رنگی.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("5271", "1", "2022-01-23 19:47:10", "2022-01-23 16:17:10", "", "icon", "", "inherit", "open", "closed", "", "icon", "", "", "2022-01-23 19:47:10", "2022-01-23 16:17:10", "", "7", "https://sitralweb.com/ir3/wp-content/uploads/2020/05/icon.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("5275", "1", "2022-02-02 20:29:49", "2022-02-02 16:59:49", "", "پکیج ها", "", "publish", "closed", "closed", "", "%d9%be%da%a9%db%8c%d8%ac-%d9%87%d8%a7", "", "", "2022-04-06 00:06:43", "2022-04-05 19:36:43", "", "0", "https://sitralweb.com/ir3/?page_id=5275", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("3", "1", "2020-05-30 09:50:04", "2020-05-30 06:20:04", "<!-- wp:heading --><h2>ما که هستیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p>نشانی وب‌سایت ما: http://sitralweb.com/iranamlak2.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>کدامیک از اطلاعات شخصی را جمع آوری میکنیم و چرا</h2><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>دیدگاه‌ها</h3><!-- /wp:heading --><!-- wp:paragraph --><p>هنگامی که بازدیدکنندگان نظرات خود را در سایت می‌نویسند، ما اطلاعاتی را که در فرم نظرات و همچنین بازدید کننده‌ها ارائه می‌شود جمع آوری می‌کنیم &#8217;s آدرس IP و رجیستر عامل کاربر مرورگر برای کمک به تشخیص هرزنامه.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>یک رشته ناشناس ایجاد شده از آدرس ایمیل شما (همچنین هش نامیده می‌شود) ممکن است به سرویس Gravatar ارائه شود تا ببینید آیا از آن استفاده می‌کنید. سیاست حفظ حریم خصوصی خدمات Gravatar در اینجا در دسترس است: https://automattic.com/privacy/. پس از تأیید نظر شما، تصویر نمایه شما در متن نظر شما قابل مشاهده است.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>رسانه</h3><!-- /wp:heading --><!-- wp:paragraph --><p>اگر تصاویر را به وبسایت آپلود کنید، نباید آپلود تصاویر با داده‌های مکان جغرافیایی (EXIF GPS) شامل شود. بازدیدکنندگان وب سایت می‌توانند هر گونه اطلاعات مکان را از تصاویر در وب سایت دانلود و استخراج کنند.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>فرم‌های تماس</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>کوکی‌ها</h3><!-- /wp:heading --><!-- wp:paragraph --><p>اگر شما نظر خود را در سایت ما ثبت کنید، ممکن است برای ذخیره نام، آدرس ایمیل و وب سایت خود در کوکی‌ها تصمیم گیری کنید. اینها برای راحتی شما هستند، به طوری که شما مجبور نیستید دوباره جزئیات خود را پر کنید زمانی که نظر دیگری را ترک کنید. این کوکی‌ها یک سال طول خواهد کشید.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر از برگه ورود ما بازدید نمایید، ما یک کوکی موقت برای مشخص نمودن اینکه آیا مروگر شما کوکی قبول می‌کند را تنظیم می‌کنیم. این کوکی محتوای اطلاعات شخصی شما نیست و وقتی مرورگر شما بسته می‌شود از بین می‌رود.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>هنگام ورود به سیستم، ما همچنین کوکی‌ها را تنظیم خواهیم کرد تا اطلاعات ورود به سیستم و گزینه‌های صفحه نمایش خود را ذخیره کنید. کوکی‌های ورود به سیستم برای دو روز گذشته و کوکی‌های گزینه‌های صفحه نمایش برای یک سال گذشته است. اگر شما انتخاب کنید &quot; به یاد داشته باشید من Me&quot;، ورود شما برای دو هفته ادامه خواهد داشت. اگر از حساب خود خارج شوید، کوکی‌های ورود حذف خواهند شد.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر یک مقاله را ویرایش یا منتشر کنید، یک کوکی اضافی در مرورگر شما ذخیره خواهد شد. این کوکی حاوی اطلاعات شخصی نیست و به سادگی نشان می‌دهد که شناسه پست مقاله شما فقط ویرایش شده است. بعد از یک روز منقضی می‌شود.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>محتوای جاسازی‌شده از دیگر وب‌سایت‌ها</h3><!-- /wp:heading --><!-- wp:paragraph --><p>مقالات موجود در این سایت ممکن است شامل محتوای تعبیه شده (مثلا ویدئوها، تصاویر، مقالات و غیره) باشد. مطالب جاسازی شده از وب سایت‌های دیگر رفتار دقیقا همان طوری که بازدید کننده از وب سایت دیگر بازدید کرده است.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>این وبسایت‌ها ممکن است اطلاعاتی مربوط به شما را جمع‌آوری کنند، از کوکی‌ها استفاده کنند، ردیابی سوم شخص اضافه را جاسازی کنند و تعامل شما را با محتوای تعبیه شده نظارت کنند که شامل ردیابی تعامل شما با محتوای جاسازی شده است اگر حساب کاربری داشته و به آن وبسایت وارد شده باشید.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>تجزیه و تحلیل</h3><!-- /wp:heading --><!-- wp:heading --><h2>اطلاعات شما را با چه کسی به اشتراک می‌گذاریم</h2><!-- /wp:heading --><!-- wp:heading --><h2>چه مدت ما اطلاعات شما را حفظ می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p>اگر یک نظر را ترک کنید، نظر و متادیتای آن به طور نامحدود حفظ می‌شوند. این به این معنا است که ما می‌توانیم به جای برگزاری آنها در یک خط مؤثر، به طور خودکار هر نظر پیگیری را تصدیق و تأیید کنیم.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>برای کاربرانی که در وب سایت ما ثبت نام می‌کنند (اگر وجود داشته باشند)، ما همچنین اطلاعات شخصی را که در مشخصات کاربر آنها ارائه می‌کنیم، ذخیره می‌کنیم. همه کاربران می‌توانند اطلاعات شخصی خود را در هر زمان (به جز آنها که نمی‌توانند نام کاربری خود را تغییر دهند) ببینند، ویرایش و یا حذف کنند. مدیران وب سایت همچنین می‌توانند این اطلاعات را مشاهده و ویرایش کنند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>حقوقی که بر روی داده‌هایتان دارید</h2><!-- /wp:heading --><!-- wp:paragraph --><p>اگر در این سایت حساب کاربری دارید یا نظرها را ترک کرده اید، می‌توانید درخواست دریافت یک فایل صادر شده از اطلاعات شخصی که ما در مورد شما نگه می‌داریم، از جمله هر گونه داده‌ای که برای ما ارائه کرده اید. همچنین می‌توانید درخواست کنید که ما هر گونه اطلاعات شخصی که در مورد شما نگه داریم پاک کنیم. این شامل اطلاعاتی نیست که ما مجبور به نگهداری آنها برای اهداف اداری، قانونی یا امنیتی باشیم.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>داده‌های شما را به کجا ارسال می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p>دیدگاه‌های بازدیدکننده ممکن است از طریق یک سرویس تشخیص جفنگ خودکار بررسی شوند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>اطلاعات تماس شما</h2><!-- /wp:heading --><!-- wp:heading --><h2>اطلاعات اضافی</h2><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>چگونه از اطلاعات شما حفاظت می‌کنیم</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>چه رویه‌های نقض اطلاعات در حال حاضر وجود دارد</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>چه چیز جدیدی از داده‌ها دریافت می‌کنیم</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>تصمیم گیری خودکار و / یا پروفایل ما با داده‌های کاربر انجام می‌شود</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>الزامات افشای قانونی صنعت</h3><!-- /wp:heading -->", "سیاست حریم خصوصی", "", "publish", "closed", "closed", "", "%d8%b3%db%8c%d8%a7%d8%b3%d8%aa-%d8%ad%d9%81%d8%b8-%d8%ad%d8%b1%db%8c%d9%85-%d8%ae%d8%b5%d9%88%d8%b5%db%8c", "", "", "2020-05-30 11:22:49", "2020-05-30 07:52:49", "", "0", "http://sitralweb.com/iranamlak2/?page_id=3", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5", "0", "2020-05-30 09:52:04", "2020-05-30 06:22:04", "Default Userlisting form placeholder", "Userlisting", "", "publish", "closed", "closed", "", "userlisting", "", "", "2020-05-30 09:52:04", "2020-05-30 06:22:04", "", "0", "http://sitralweb.com/iranamlak2/?p=5", "0", "wppb-ul-cpt", "", "0");
INSERT INTO `wp_posts` VALUES("5257", "1", "2022-01-01 11:32:42", "2022-01-01 08:02:42", "", "صفحه نخست", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2022-01-01 11:32:42", "2022-01-01 08:02:42", "", "2", "https://sitralweb.com/ir3/?p=5257", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2020-05-30 10:01:06", "2020-05-30 06:31:06", "<!-- wp:paragraph -->\n<p>این یک برگهٔ نمونه است. این از یک نوشتهٔ وبلاگ متفاوت است زیرا در یک مکان باقی خواهد ماند و در راهبری سایتتان (در بیشتر پوسته‌ها) نشان داده خواهد شد. بیشتر مردم با یک برگه درباره که آن‌ها را به بازدیدکنندگان بالقوهٔ سایت معرفی می‌کند، آغاز می‌کنند. که ممکن است چیزی همانند این باشد:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>سلام! من یک پیام‌رسان دوچرخه‌سوار در روز، بازیگر مشتاق در شب هستم، و این وب‌سایت من است. من در لس آنجلس زندگی می‌کنم، یک سگ بزرگ به نام جک دارم، و من پینیا کولادا دوست دارم. (همچنین گرفتار شدن در باران را دوست دارم.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...یا چیزهایی مانند این:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>شرکت XYZ در سال ۱۹۷۱ تأسیس شد، و تا کنون چیزهای با کیفیتی را به عموم عرضه کرده است. این شرکت در شهر گاتهام واقع شده است، بیش از ۲۰۰۰ نفر در آن کار می‌کنند و همه نوع چیز عالی برای جامعه گاتهام انجام می‌دهد.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>به عنوان یک کاربر جدید وردپرس، برای حذف این برگه و ایجاد برگه‌های جدید برای محتوای خود شما باید به <a href=\"http://sitralweb.com/iranamlak2/wp-admin/\">پیشخوان</a> بروید. خوش بگذره!</p>\n<!-- /wp:paragraph -->", "صفحه نخست", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2020-05-30 10:01:06", "2020-05-30 06:31:06", "", "2", "http://sitralweb.com/iranamlak2/?p=6", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2020-05-30 10:01:16", "2020-05-30 06:31:16", "", "Media", "", "private", "closed", "closed", "", "media", "", "", "2020-05-30 10:01:16", "2020-05-30 06:31:16", "", "0", "http://sitralweb.com/iranamlak2/?option-tree=media", "0", "option-tree", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2020-05-30 11:11:13", "2020-05-30 07:41:13", "", "پیشنمایش زنده", "", "publish", "closed", "closed", "", "%d9%be%db%8c%d8%b4%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%b2%d9%86%d8%af%d9%87", "", "", "2020-05-30 11:11:13", "2020-05-30 07:41:13", "", "0", "http://sitralweb.com/iranamlak2/?gf_live_preview=%d9%be%db%8c%d8%b4%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%b2%d9%86%d8%af%d9%87", "0", "gf_live_preview", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2020-05-30 11:22:49", "2020-05-30 07:52:49", "<!-- wp:heading --><h2>ما که هستیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p>نشانی وب‌سایت ما: http://sitralweb.com/iranamlak2.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>کدامیک از اطلاعات شخصی را جمع آوری میکنیم و چرا</h2><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>دیدگاه‌ها</h3><!-- /wp:heading --><!-- wp:paragraph --><p>هنگامی که بازدیدکنندگان نظرات خود را در سایت می‌نویسند، ما اطلاعاتی را که در فرم نظرات و همچنین بازدید کننده‌ها ارائه می‌شود جمع آوری می‌کنیم &#8217;s آدرس IP و رجیستر عامل کاربر مرورگر برای کمک به تشخیص هرزنامه.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>یک رشته ناشناس ایجاد شده از آدرس ایمیل شما (همچنین هش نامیده می‌شود) ممکن است به سرویس Gravatar ارائه شود تا ببینید آیا از آن استفاده می‌کنید. سیاست حفظ حریم خصوصی خدمات Gravatar در اینجا در دسترس است: https://automattic.com/privacy/. پس از تأیید نظر شما، تصویر نمایه شما در متن نظر شما قابل مشاهده است.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>رسانه</h3><!-- /wp:heading --><!-- wp:paragraph --><p>اگر تصاویر را به وبسایت آپلود کنید، نباید آپلود تصاویر با داده‌های مکان جغرافیایی (EXIF GPS) شامل شود. بازدیدکنندگان وب سایت می‌توانند هر گونه اطلاعات مکان را از تصاویر در وب سایت دانلود و استخراج کنند.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>فرم‌های تماس</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>کوکی‌ها</h3><!-- /wp:heading --><!-- wp:paragraph --><p>اگر شما نظر خود را در سایت ما ثبت کنید، ممکن است برای ذخیره نام، آدرس ایمیل و وب سایت خود در کوکی‌ها تصمیم گیری کنید. اینها برای راحتی شما هستند، به طوری که شما مجبور نیستید دوباره جزئیات خود را پر کنید زمانی که نظر دیگری را ترک کنید. این کوکی‌ها یک سال طول خواهد کشید.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر از برگه ورود ما بازدید نمایید، ما یک کوکی موقت برای مشخص نمودن اینکه آیا مروگر شما کوکی قبول می‌کند را تنظیم می‌کنیم. این کوکی محتوای اطلاعات شخصی شما نیست و وقتی مرورگر شما بسته می‌شود از بین می‌رود.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>هنگام ورود به سیستم، ما همچنین کوکی‌ها را تنظیم خواهیم کرد تا اطلاعات ورود به سیستم و گزینه‌های صفحه نمایش خود را ذخیره کنید. کوکی‌های ورود به سیستم برای دو روز گذشته و کوکی‌های گزینه‌های صفحه نمایش برای یک سال گذشته است. اگر شما انتخاب کنید &quot; به یاد داشته باشید من Me&quot;، ورود شما برای دو هفته ادامه خواهد داشت. اگر از حساب خود خارج شوید، کوکی‌های ورود حذف خواهند شد.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>اگر یک مقاله را ویرایش یا منتشر کنید، یک کوکی اضافی در مرورگر شما ذخیره خواهد شد. این کوکی حاوی اطلاعات شخصی نیست و به سادگی نشان می‌دهد که شناسه پست مقاله شما فقط ویرایش شده است. بعد از یک روز منقضی می‌شود.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>محتوای جاسازی‌شده از دیگر وب‌سایت‌ها</h3><!-- /wp:heading --><!-- wp:paragraph --><p>مقالات موجود در این سایت ممکن است شامل محتوای تعبیه شده (مثلا ویدئوها، تصاویر، مقالات و غیره) باشد. مطالب جاسازی شده از وب سایت‌های دیگر رفتار دقیقا همان طوری که بازدید کننده از وب سایت دیگر بازدید کرده است.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>این وبسایت‌ها ممکن است اطلاعاتی مربوط به شما را جمع‌آوری کنند، از کوکی‌ها استفاده کنند، ردیابی سوم شخص اضافه را جاسازی کنند و تعامل شما را با محتوای تعبیه شده نظارت کنند که شامل ردیابی تعامل شما با محتوای جاسازی شده است اگر حساب کاربری داشته و به آن وبسایت وارد شده باشید.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>تجزیه و تحلیل</h3><!-- /wp:heading --><!-- wp:heading --><h2>اطلاعات شما را با چه کسی به اشتراک می‌گذاریم</h2><!-- /wp:heading --><!-- wp:heading --><h2>چه مدت ما اطلاعات شما را حفظ می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p>اگر یک نظر را ترک کنید، نظر و متادیتای آن به طور نامحدود حفظ می‌شوند. این به این معنا است که ما می‌توانیم به جای برگزاری آنها در یک خط مؤثر، به طور خودکار هر نظر پیگیری را تصدیق و تأیید کنیم.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>برای کاربرانی که در وب سایت ما ثبت نام می‌کنند (اگر وجود داشته باشند)، ما همچنین اطلاعات شخصی را که در مشخصات کاربر آنها ارائه می‌کنیم، ذخیره می‌کنیم. همه کاربران می‌توانند اطلاعات شخصی خود را در هر زمان (به جز آنها که نمی‌توانند نام کاربری خود را تغییر دهند) ببینند، ویرایش و یا حذف کنند. مدیران وب سایت همچنین می‌توانند این اطلاعات را مشاهده و ویرایش کنند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>حقوقی که بر روی داده‌هایتان دارید</h2><!-- /wp:heading --><!-- wp:paragraph --><p>اگر در این سایت حساب کاربری دارید یا نظرها را ترک کرده اید، می‌توانید درخواست دریافت یک فایل صادر شده از اطلاعات شخصی که ما در مورد شما نگه می‌داریم، از جمله هر گونه داده‌ای که برای ما ارائه کرده اید. همچنین می‌توانید درخواست کنید که ما هر گونه اطلاعات شخصی که در مورد شما نگه داریم پاک کنیم. این شامل اطلاعاتی نیست که ما مجبور به نگهداری آنها برای اهداف اداری، قانونی یا امنیتی باشیم.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>داده‌های شما را به کجا ارسال می‌کنیم</h2><!-- /wp:heading --><!-- wp:paragraph --><p>دیدگاه‌های بازدیدکننده ممکن است از طریق یک سرویس تشخیص جفنگ خودکار بررسی شوند.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>اطلاعات تماس شما</h2><!-- /wp:heading --><!-- wp:heading --><h2>اطلاعات اضافی</h2><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>چگونه از اطلاعات شما حفاظت می‌کنیم</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>چه رویه‌های نقض اطلاعات در حال حاضر وجود دارد</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>چه چیز جدیدی از داده‌ها دریافت می‌کنیم</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>تصمیم گیری خودکار و / یا پروفایل ما با داده‌های کاربر انجام می‌شود</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>الزامات افشای قانونی صنعت</h3><!-- /wp:heading -->", "سیاست حریم خصوصی", "", "inherit", "closed", "closed", "", "3-revision-v1", "", "", "2020-05-30 11:22:49", "2020-05-30 07:52:49", "", "3", "http://sitralweb.com/iranamlak2/?p=11", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2020-05-30 11:27:41", "2020-05-30 06:57:41", "", "ناحیه کاربری", "", "publish", "closed", "closed", "", "dashboard", "", "", "2022-05-28 12:08:46", "2022-05-28 07:38:46", "", "0", "http://sitralweb.com/iranamlak2/?page_id=12", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2020-05-30 11:27:41", "2020-05-30 07:57:41", "", "ناحیه کاربری", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2020-05-30 11:27:41", "2020-05-30 07:57:41", "", "12", "http://sitralweb.com/iranamlak2/?p=13", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2020-05-30 11:30:29", "2020-05-30 07:00:29", "&nbsp;\r\n\r\n&nbsp;\r\n\r\nجهت دریافت اطلاعات بیشتر با مشاورین املاک ایران املاک تماس حاصل فرمایید ...\r\n\r\n09123456789\r\n\r\n01234567890\r\n\r\ninfo@test.com\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nو یا همچنین میتوانید از فرم روبرو جهت ارسال هرگونه نظرات و یا انتقادات خود استفاده نمایید .\r\n\r\nهمکاران ما در اسرع وقت با شما در ارتباط خواهد بود ...", "ارتباط با ما", "", "publish", "closed", "closed", "", "%d8%a7%d8%b1%d8%aa%d8%a8%d8%a7%d8%b7-%d8%a8%d8%a7-%d9%85%d8%a7", "", "", "2022-04-30 13:21:19", "2022-04-30 08:51:19", "", "0", "http://sitralweb.com/iranamlak2/?page_id=17", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2020-05-30 11:30:29", "2020-05-30 08:00:29", "", "ارتباط با ما", "", "inherit", "closed", "closed", "", "17-revision-v1", "", "", "2020-05-30 11:30:29", "2020-05-30 08:00:29", "", "17", "http://sitralweb.com/iranamlak2/17-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2020-05-30 11:30:57", "2020-05-30 07:00:57", "", "ارسال ملک", "", "publish", "closed", "closed", "", "%d8%a7%d8%b1%d8%b3%d8%a7%d9%84-%d9%85%d9%84%da%a9", "", "", "2022-04-06 00:06:23", "2022-04-05 19:36:23", "", "0", "http://sitralweb.com/iranamlak2/?page_id=19", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2020-05-30 11:30:57", "2020-05-30 08:00:57", "", "ارسال ملک", "", "inherit", "closed", "closed", "", "19-revision-v1", "", "", "2020-05-30 11:30:57", "2020-05-30 08:00:57", "", "19", "http://sitralweb.com/iranamlak2/19-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2020-05-30 11:31:22", "2020-05-30 07:01:22", "", "پروفایل من", "", "publish", "closed", "closed", "", "profile", "", "", "2022-05-28 12:08:17", "2022-05-28 07:38:17", "", "0", "http://sitralweb.com/iranamlak2/?page_id=21", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2020-05-30 11:31:22", "2020-05-30 08:01:22", "", "پروفایل من", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2020-05-30 11:31:22", "2020-05-30 08:01:22", "", "21", "http://sitralweb.com/iranamlak2/21-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2020-05-30 11:32:04", "2020-05-30 07:02:04", "", "جستجو", "", "publish", "closed", "closed", "", "%d8%ac%d8%b3%d8%aa%d8%ac%d9%88", "", "", "2022-04-06 00:06:53", "2022-04-05 19:36:53", "", "0", "http://sitralweb.com/iranamlak2/?page_id=25", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2020-05-30 11:32:04", "2020-05-30 08:02:04", "", "جستجو", "", "inherit", "closed", "closed", "", "25-revision-v1", "", "", "2020-05-30 11:32:04", "2020-05-30 08:02:04", "", "25", "http://sitralweb.com/iranamlak2/25-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2020-05-30 11:32:44", "2020-05-30 08:02:44", "ایران املاک در ابتدا با هدف ایجاد کسب و کار و سپس برای ارئه اطلاعات دقیق ملکی اعم از خرید و فروش ، رهن و اجاره کلیه انواع ملک بصورت تخصصی و حرفه ای برای مشتریان عزیز راه اندازی گردید .\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-2845 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png\" alt=\"\" width=\"300\" height=\"148\" />\r\n\r\n&nbsp;\r\n<p style=\"text-align: right;\">با توجه به استفاده های بسیار بالای مردمی از فضای مجازی ، به جهت دسترسی بهتر و آسانتر مشتریان با مقوله خرید و فروش ملک در شمال کشور ، با طراحی قالب ایران املاک در سال 1399 ، توانستم تا حدود بسیار زیادی راه را برای تعاملی بهتر فی مابین مشاور و مشتریان هموار کنیم .</p>\r\n<p style=\"text-align: right;\">همینک اینجانب یوسف پور امینیان در زمینه خرید و فروش ، رهن و اجاره سالانه و روزانه مفتخریم بصورت کاملا حرفه ای و تخصصی در کنار مشتریان با مشاوره دقیق در خدمتتان باشیم.</p>\r\n<p style=\"text-align: center;\"><img class=\"alignnone wp-image-2841 size-full\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me.png\" alt=\"\" width=\"600\" height=\"600\" /></p>\r\nحوضه فعالیت ایران املاک در کل کشور مستقر میباشد و هر شخص در هر کجای کشور عزیزمان ایران میتواند ملک خود را به ثبت برساند و پس از بررسی کارشناسان سیترال وب تایید و در لیست اخرین املاک قرار بگیرد .\r\n\r\nقالب ایران املاک دارای امکانات کم نظیر ، همانند فیلتر جستجو پیشرفته ، ارسال ملک با جزئیات ریز بریز و به سلیقه ایران پسند ، کدنویسی بسیار تمیز بدون حتی یک خط کد اضافی ، سئو بسیار عالی جهت کاهش حجم تصاویر بطور خودکار و درج متا تگ های تصویر از روی عنوان ملک ، امکان ساخت لینک با فیلتر دلخواه و درج آن در هر کجای از سایت و یا ارسال ان به دیگران ، کنترل پنل بی نظیر اختصاصی کاربر و مشاور و موارد دیگر ... میباشد .\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید از طریق مراجعه به صفحه ارتباط با ما از طریق روابط ارتباطی موجود، درخواست ها شکایات انتقادات و نظرات خود را برای ما بفرستید .\r\n\r\nبا تشکر از همکاری شما", "درباره ما", "", "publish", "closed", "closed", "", "%d8%af%d8%b1%d8%a8%d8%a7%d8%b1%d9%87-%d9%85%d8%a7", "", "", "2022-04-30 13:21:30", "2022-04-30 08:51:30", "", "0", "http://sitralweb.com/iranamlak2/?page_id=27", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2020-05-30 11:32:44", "2020-05-30 08:02:44", "ایران املاک با 30 سال تجربه، سريعترين راه دسترسي به املاك را جهت خريداران، فروشندگان، آژانسهاي املاک و م سكن، ادارات، سازمانها، ارگانها و شركتهاي مهندسي راه اندازي كرده است.\r\n\r\nمشاوره تخصصی در منطقه شمیرانات(ا لهیه زعفرانیه محمودیه ولنجک) مخصوصا و باقی مناطق.در مورد خرید,آپارتمان, ویلا ,خانه کلنگی می توانید با مشاورین ما به نتیجه مطلوب برسید\r\n\r\nمتن کوتاه درباره این آزانس ملکی بزودی در این بخش قرار خواهد گرفت و توضیحات جامع و شفاف به کاربران عزیز این وب سایت ارائه خواهیم داد . ازینکه بیصبرانه منتظر مانده اید پوزش میطلبیم\r\n\r\n&nbsp;\r\n\r\nتیم ایران املاک دارای 3 کارشناس آقای امینی ، آقای اسماعیلی و اقای رضایی میباشد .\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-317 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/happy-businessman-png-shaking-hands-business-115632690125rwl0x2uto-293x300.png\" alt=\"\" width=\"293\" height=\"300\" />\r\n<h3>آقای امینی مشاور بخش فروش</h3>\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-318 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/Businessman_PNG_Image_32489-148x300.png\" alt=\"\" width=\"148\" height=\"300\" />\r\n<h3>آقای اسماعیلی مشاور بخش اجاره</h3>\r\n<img class=\"size-medium wp-image-319 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/Businessman_PNG_Image_32519-189x300.png\" alt=\"\" width=\"189\" height=\"300\" />\r\n<h3>و آقای رضایی مشاور بخش مالی و مکاتبات</h3>", "درباره ما", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2020-05-30 11:32:44", "2020-05-30 08:02:44", "", "27", "http://sitralweb.com/iranamlak2/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6420", "1", "2022-06-24 23:05:33", "2022-06-24 18:35:33", "[iranamlak numstates=\"20\" style_query_shortcode=\"style1\" mantaghe=\"1412\"]", "نمایش صفحه بدون فیلتر جستجو", "", "publish", "closed", "closed", "", "%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%b5%d9%81%d8%ad%d9%87-%d8%a8%d8%af%d9%88%d9%86-%d9%81%db%8c%d9%84%d8%aa%d8%b1-%d8%ac%d8%b3%d8%aa%d8%ac%d9%88", "", "", "2022-06-24 23:05:33", "2022-06-24 18:35:33", "", "0", "https://sitralweb.com/ir3/?page_id=6420", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6421", "1", "2022-06-24 23:05:33", "2022-06-24 18:35:33", "[iranamlak numstates=\"20\" style_query_shortcode=\"style1\" mantaghe=\"1412\"]", "نمایش صفحه بدون فیلتر جستجو", "", "inherit", "closed", "closed", "", "6420-revision-v1", "", "", "2022-06-24 23:05:33", "2022-06-24 18:35:33", "", "6420", "https://sitralweb.com/ir3/?p=6421", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6520", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "اعضای تیم ما", "", "publish", "closed", "closed", "", "%d8%a7%d8%b9%d8%b6%d8%a7%db%8c-%d8%aa%db%8c%d9%85-%d9%85%d8%a7", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6520", "34", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6472", "2", "2022-11-21 11:24:07", "2022-11-21 07:54:07", "", "111620_18558047_3383912_dbffd7a9_image", "", "inherit", "open", "closed", "", "111620_18558047_3383912_dbffd7a9_image", "", "", "2022-11-21 11:24:09", "2022-11-21 07:54:09", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/11/111620_18558047_3383912_dbffd7a9_image.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6424", "1", "2022-06-25 17:30:43", "2022-06-25 13:00:43", "", "enamad", "", "inherit", "open", "closed", "", "enamad", "", "", "2022-06-25 17:30:43", "2022-06-25 13:00:43", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/06/enamad.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("6418", "1", "2022-06-24 23:05:12", "2022-06-24 18:35:12", "[iranamlak numstates=\"20\" style_query_shortcode=\"style1\" mantaghe=\"1412\"]", "نمایش صفحه با فیلتر جستجو", "", "publish", "closed", "closed", "", "%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%b5%d9%81%d8%ad%d9%87-%d8%a8%d8%a7-%d9%81%db%8c%d9%84%d8%aa%d8%b1-%d8%ac%d8%b3%d8%aa%d8%ac%d9%88", "", "", "2022-06-25 19:20:45", "2022-06-25 14:50:45", "", "0", "https://sitralweb.com/ir3/?page_id=6418", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6419", "1", "2022-06-24 23:05:12", "2022-06-24 18:35:12", "[iranamlak numstates=\"20\" style_query_shortcode=\"style1\" mantaghe=\"1412\"]", "نمایش صفحه با فیلتر جستجو", "", "inherit", "closed", "closed", "", "6418-revision-v1", "", "", "2022-06-24 23:05:12", "2022-06-24 18:35:12", "", "6418", "https://sitralweb.com/ir3/?p=6419", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2020-05-30 11:33:59", "2020-05-30 08:03:59", "ایران املاک با 30 سال تجربه، سريعترين راه دسترسي به املاك را جهت خريداران، فروشندگان، آژانسهاي املاک و م سكن، ادارات، سازمانها، ارگانها و شركتهاي مهندسي راه اندازي كرده است.\r\n\r\nمشاوره تخصصی در منطقه شمیرانات(ا لهیه زعفرانیه محمودیه ولنجک) مخصوصا و باقی مناطق.در مورد خرید,آپارتمان, ویلا ,خانه کلنگی می توانید با مشاورین ما به نتیجه مطلوب برسید\r\n\r\nمتن کوتاه درباره این آزانس ملکی بزودی در این بخش قرار خواهد گرفت و توضیحات جامع و شفاف به کاربران عزیز این وب سایت ارائه خواهیم داد . ازینکه بیصبرانه منتظر مانده اید پوزش میطلبیم\r\n\r\n&nbsp;\r\n\r\nتیم ایران املاک دارای 3 کارشناس آقای امینی ، آقای اسماعیلی و اقای رضایی میباشد .\r\n<p style=\"text-align: center;\"></p>\r\n<p style=\"text-align: center;\"></p>\r\n\r\n<h3 style=\"text-align: center;\">آقای امینی مشاور بخش فروش</h3>\r\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-29\" src=\"http://sitralweb.com/iranamlak2/wp-content/uploads/2020/05/Businessman_PNG_Image_32519-189x300-1.png\" alt=\"\" width=\"189\" height=\"300\" /></p>\r\n\r\n<h3 style=\"text-align: center;\">آقای اسماعیلی مشاور بخش اجاره</h3>\r\n<p style=\"text-align: center;\"><img class=\"alignnone size-full wp-image-30\" src=\"http://sitralweb.com/iranamlak2/wp-content/uploads/2020/05/Businessman_PNG_Image_32489-148x300-1.png\" alt=\"\" width=\"148\" height=\"300\" /></p>\r\n\r\n<h3 style=\"text-align: center;\">و آقای رضایی مشاور بخش مالی و مکاتبات</h3>\r\n<img class=\"alignnone size-full wp-image-31 aligncenter\" src=\"http://sitralweb.com/iranamlak2/wp-content/uploads/2020/05/happy-businessman-png-shaking-hands-business-115632690125rwl0x2uto-293x300-1.png\" alt=\"\" width=\"293\" height=\"300\" />", "درباره ما", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2020-05-30 11:33:59", "2020-05-30 08:03:59", "", "27", "http://sitralweb.com/iranamlak2/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2020-05-30 11:34:17", "2020-05-30 07:04:17", "", "علاقه مندی های من", "", "publish", "closed", "closed", "", "%d8%b9%d9%84%d8%a7%d9%82%d9%87-%d9%85%d9%86%d8%af%db%8c-%d9%87%d8%a7%db%8c-%d9%85%d9%86", "", "", "2022-04-06 00:08:23", "2022-04-05 19:38:23", "", "0", "http://sitralweb.com/iranamlak2/?page_id=34", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2020-05-30 11:34:17", "2020-05-30 08:04:17", "", "علاقه مندی های من", "", "inherit", "closed", "closed", "", "34-revision-v1", "", "", "2020-05-30 11:34:17", "2020-05-30 08:04:17", "", "34", "http://sitralweb.com/iranamlak2/34-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2020-05-30 11:34:22", "2020-05-30 08:04:22", "", "علاقه مندی های من", "", "inherit", "closed", "closed", "", "34-autosave-v1", "", "", "2020-05-30 11:34:22", "2020-05-30 08:04:22", "", "34", "http://sitralweb.com/iranamlak2/34-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2020-05-30 11:35:05", "2020-05-30 07:05:05", "", "مشاورین املاک", "", "publish", "closed", "closed", "", "%d9%85%d8%b4%d8%a7%d9%88%d8%b1%db%8c%d9%86-%d8%a7%d9%85%d9%84%d8%a7%da%a9", "", "", "2022-04-06 00:09:22", "2022-04-05 19:39:22", "", "0", "http://sitralweb.com/iranamlak2/?page_id=39", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2020-05-30 11:35:05", "2020-05-30 08:05:05", "", "مشاورین املاک", "", "inherit", "closed", "closed", "", "39-revision-v1", "", "", "2020-05-30 11:35:05", "2020-05-30 08:05:05", "", "39", "http://sitralweb.com/iranamlak2/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2022-02-25 11:35:33", "2022-02-25 08:05:33", "", "ورود / ثبت نام", "", "publish", "closed", "closed", "", "auth", "", "", "2023-07-29 18:23:55", "2023-07-29 14:53:55", "", "0", "http://sitralweb.com/iranamlak2/?page_id=41", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2020-05-30 11:35:33", "2020-05-30 08:05:33", "", "ورود", "", "inherit", "closed", "closed", "", "41-revision-v1", "", "", "2020-05-30 11:35:33", "2020-05-30 08:05:33", "", "41", "http://sitralweb.com/iranamlak2/41-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2023-06-02 17:56:54", "2020-05-30 12:07:40", " ", "", "", "publish", "closed", "closed", "", "46", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "http://sitralweb.com/iranamlak2/?p=46", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2023-06-02 17:56:54", "2020-05-30 12:07:40", " ", "", "", "publish", "closed", "closed", "", "49", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "http://sitralweb.com/iranamlak2/?p=49", "37", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("3249", "1", "2023-06-02 17:56:54", "2020-09-27 12:40:32", "", "بلاگ", "", "publish", "closed", "closed", "", "%d8%a2%d8%b1%d8%b4%db%8c%d9%88-%d8%a7%d8%ae%d8%a8%d8%a7%d8%b1", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=3249", "35", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2023-06-02 17:56:54", "2020-05-30 12:07:40", " ", "", "", "publish", "closed", "closed", "", "54", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "http://sitralweb.com/iranamlak2/?p=54", "36", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("3248", "1", "2020-09-27 16:05:09", "2020-09-27 12:35:09", "", "اخبار و مقالات", "", "inherit", "closed", "closed", "", "3247-revision-v1", "", "", "2020-09-27 16:05:09", "2020-09-27 12:35:09", "", "3247", "https://sitralweb.com/ir3/3247-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("3247", "1", "2020-09-27 16:05:09", "2020-09-27 12:35:09", "", "اخبار و مقالات", "", "publish", "closed", "closed", "", "blog", "", "", "2022-11-27 10:02:58", "2022-11-27 06:32:58", "", "0", "https://sitralweb.com/ir3/?page_id=3247", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6531", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "آپارتمان های پیشفروش تهران", "", "publish", "closed", "closed", "", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d9%87%d8%a7%db%8c-%d9%be%db%8c%d8%b4%d9%81%d8%b1%d9%88%d8%b4-%d8%aa%d9%87%d8%b1%d8%a7%d9%86", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6531", "24", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("212", "1", "2022-02-04 19:10:03", "2022-02-04 15:40:03", "این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد .\r\nاین متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد . این متن به عنوان تست در اینجا قرار میگیرد و هیچ وجود واقعی ندارد .", "ویلای لوکس در تهران", "", "publish", "open", "closed", "", "%d9%88%db%8c%d9%84%d8%a7%db%8c-%d9%84%d9%88%da%a9%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=212", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("214", "1", "2022-11-26 19:17:31", "2022-11-26 15:47:31", "توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد .\r\nتوضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد .", "ویلا اوکازیون در متل قو", "", "publish", "open", "closed", "", "%d9%88%db%8c%d9%84%d8%a7-%d8%a7%d9%88%da%a9%d8%a7%d8%b2%db%8c%d9%88%d9%86-%d8%af%d8%b1-%d9%85%d8%aa%d9%84-%d9%82%d9%88", "", "", "2023-06-02 17:42:13", "2023-06-02 14:12:13", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=214", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("221", "1", "2022-02-04 19:34:47", "2022-02-04 16:04:47", "توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد .\r\nتوضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد .", "ویلای لاکچری 500 متری 4 خوابه", "", "publish", "open", "closed", "", "%d9%88%db%8c%d9%84%d8%a7%db%8c-%d9%84%d8%a7%da%a9%da%86%d8%b1%db%8c-500-%d9%85%d8%aa%d8%b1%db%8c-4-%d8%ae%d9%88%d8%a7%d8%a8%d9%87", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=221", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("223", "1", "2022-02-04 19:44:38", "2022-02-04 16:14:38", "توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد .\r\nتوضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد .\r\nتوضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد . توضیحات رهن ملک اداری در تهران در اینجا قرار میگیرد .", "رهن ملک اداری در تهران", "", "publish", "open", "closed", "", "%d8%b1%d9%87%d9%86-%d9%85%d9%84%da%a9-%d8%a7%d8%af%d8%a7%d8%b1%db%8c-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=223", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("285", "1", "2022-02-04 22:47:53", "2022-02-04 19:17:53", "آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد . آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد .", "اجاره آپارتمان 85 متری در دماوند", "", "publish", "open", "closed", "", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=285", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("290", "1", "2022-02-04 22:55:09", "2022-02-04 19:25:09", "آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد . آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد .", "رهن ویلا 180 متری در متل قو", "", "publish", "open", "closed", "", "%d8%b1%d9%87%d9%86-%d9%88%db%8c%d9%84%d8%a7-180-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d9%85%d8%aa%d9%84-%d9%82%d9%88", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/state/%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy/", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("294", "1", "2022-02-04 22:58:02", "2022-02-04 19:28:02", "آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد . آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد .", "اجاره ویلای لاکچری استخردار در رامسر", "", "publish", "open", "closed", "", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d9%88%db%8c%d9%84%d8%a7%db%8c-%d9%84%d8%a7%da%a9%da%86%d8%b1%db%8c-%d8%a7%d8%b3%d8%aa%d8%ae%d8%b1%d8%af%d8%a7%d8%b1-%d8%af%d8%b1-%d8%b1%d8%a7%d9%85%d8%b3%d8%b1", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/state/%d8%b1%d9%87%d9%86-%d9%88%db%8c%d9%84%d8%a7-180-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d9%85%d8%aa%d9%84-%d9%82%d9%88-copy/", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("296", "1", "2022-02-04 23:01:24", "2022-02-04 19:31:24", "آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد . آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد .", "فروش ویلای کوهپایه در تنکابن", "", "pending", "open", "closed", "", "%d9%81%d8%b1%d9%88%d8%b4-%d9%88%db%8c%d9%84%d8%a7%db%8c-%da%a9%d9%88%d9%87%d9%be%d8%a7%db%8c%d9%87-%d8%af%d8%b1-%d8%aa%d9%86%da%a9%d8%a7%d8%a8%d9%86", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/state/%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d9%88%db%8c%d9%84%d8%a7%db%8c-%d9%84%d8%a7%da%a9%da%86%d8%b1%db%8c-%d8%a7%d8%b3%d8%aa%d8%ae%d8%b1%d8%af%d8%a7%d8%b1-%d8%af%d8%b1-%d8%b1%d8%a7%d9%85%d8%b3%d8%b1-copy/", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("297", "1", "2022-02-04 23:03:30", "2022-02-04 19:33:30", "توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد .\r\nتوضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد .\r\nتوضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد . توضیحات آپارتمان 3 طبقه در شمال اینجا قرار میگیرد و تستی میباشد .", "اجاره آپارتمان 3 طبقه ، طبقه سوم لاهیجان", "", "pending", "open", "closed", "", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-3-%d8%b7%d8%a8%d9%82%d9%87-%d8%8c-%d8%b7%d8%a8%d9%82%d9%87-%d8%b3%d9%88%d9%85-%d9%84%d8%a7%d9%87%db%8c%d8%ac%d8%a7%d9%86", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/state/%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-3-%d8%b7%d8%a8%d9%82%d9%87-%d8%af%d8%b1-%d8%b4%d9%85%d8%a7%d9%84-copy/", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("300", "1", "2022-02-05 10:06:54", "2022-02-05 06:36:54", "توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد .\r\nتوضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد . توضیحات ویلا اوکازیون در متل قو اینجا قرار میگیرد و تستی میباشد .", "پیش فروش آپارتمان در تهران", "", "rejected", "open", "closed", "", "%d9%be%db%8c%d8%b4-%d9%81%d8%b1%d9%88%d8%b4-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/state/%d9%88%db%8c%d9%84%d8%a7-%d8%a7%d9%88%da%a9%d8%a7%d8%b2%db%8c%d9%88%d9%86-%d8%af%d8%b1-%d9%85%d8%aa%d9%84-%d9%82%d9%88-copy/", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("302", "1", "2022-02-04 23:14:12", "2022-02-04 19:44:12", "آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد . آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد .", "فروش ویلا و معاوضه با ماشین", "", "publish", "open", "closed", "", "%d9%81%d8%b1%d9%88%d8%b4-%d9%88%db%8c%d9%84%d8%a7-%d9%88-%d9%85%d8%b9%d8%a7%d9%88%d8%b6%d9%87-%d8%a8%d8%a7-%d9%85%d8%a7%d8%b4%db%8c%d9%86", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/state/%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy/", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("303", "1", "2022-02-04 23:14:12", "2022-02-04 19:44:12", "آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد . آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد .", "فروش آپارتمان لب ساحل با ویو عالی", "", "publish", "open", "closed", "", "%d9%81%d8%b1%d9%88%d8%b4-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d9%84%d8%a8-%d8%b3%d8%a7%d8%ad%d9%84-%d8%a8%d8%a7-%d9%88%db%8c%d9%88-%d8%b9%d8%a7%d9%84%db%8c", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/state/%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy/", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("5239", "1", "2021-11-23 17:12:19", "2021-11-23 13:42:19", "", "Order &ndash; آذر ۲, ۱۴۰۰ @ ۰۵:۱۲ بعد از ظهر", "", "wc-cancelled", "open", "closed", "wc_order_Rnd1YjNdhRKdK", "%d8%b3%d9%81%d8%a7%d8%b1%d8%b4-nov-23-2021-0142-pm", "", "", "2021-11-23 18:17:25", "2021-11-23 14:47:25", "", "0", "https://sitralweb.com/ir3/?post_type=shop_order&#038;p=5239", "0", "shop_order", "", "3");
INSERT INTO `wp_posts` VALUES("305", "1", "2022-02-04 23:14:14", "2022-02-04 19:44:14", "آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد . آپارتمان فوق بسیار لاکچری بوده و دارای ویو کامل به کوه و تهران میباشد . دارای 2 مستر و یک اتاق خاب یا دو تراس و یک حمام و 2 خواب عالی . این متن بصورت تست بوده و هیچ کاربرد دیگری ندارد .", "اجاره آپارتمان 95 متری در تهران", "", "publish", "open", "closed", "", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-95-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/state/%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-85-%d9%85%d8%aa%d8%b1%db%8c-%d8%af%d8%b1-%d8%af%d9%85%d8%a7%d9%88%d9%86%d8%af-copy-3/", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("1896", "1", "2021-12-20 18:57:59", "2021-12-20 15:27:59", "یک قطعه زمین در قرچک با کلیه مشاعات به فروش میرسد.\r\n\r\nتوجه کلیه مطالب در این سایت تست بوده و هیج ماهیتی ندارد .", "250 متر زمین در قرچک", "", "expired", "open", "closed", "", "250-%d9%85%d8%aa%d8%b1-%d8%b2%d9%85%db%8c%d9%86-%d8%af%d8%b1-%d9%82%d8%b1%da%86%da%a9", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=1896", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("228", "1", "2018-11-10 01:39:29", "2018-11-09 22:09:29", "به تمام ملک های منقول و غیر منقول املاک می گویند.\r\nالبته ملک هایی مثل زمین های صنعتی ، زمین مسکونی ، مواد معدنی ، چاه ، ساختمان ها ، محصولات کشاورزی و … جزء املاک محسوب می شوند.\r\nدر بین مردم واژه املاک فقط به خانه و مسکن و یا آپارتمان و مغازه اطلاق می شود اما این تصور اشتباه است.\r\nهمه ملزومات و مکان هایی که در کنار یک ملک قرار دارد و قابل بهره برداری می باشد مانند چاه آب و دامپروری و معدن و زمین کشاورزی هم در این گروه قرار می گیرد.\r\nواژه املاک\r\nیک واژه کلی است که به همه مستغلات و کسب و کار هم تعلق دارد و همچنین به کسی که در زمینه خرید و فروش و امور ملکی باشد هم املاکی می گویند.", "املاک چیست ؟", "", "publish", "open", "open", "", "%d8%a7%d9%85%d9%84%d8%a7%da%a9-%da%86%db%8c%d8%b3%d8%aa-%d8%9f", "", "", "2020-05-30 16:07:46", "2020-05-30 12:37:46", "", "0", "https://sitralweb.com/ir3/?p=228", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("230", "1", "2018-11-10 01:43:19", "2018-11-09 22:13:19", "بار ها شنیده اید که پارکینگ فلان واحد اختصاصی است یا پارکینگ های فلان ساختمان مشاء هستند , این دو با هم تفاوت هایی دارند که خیلی از مردم فرق این دو را نمی دانند.\r\nاجاره خانه, رهن آپارتمان, رهن مغازه, اجاره مغازه بزرگ\r\nدر مقالات قبلی درباره قوانین ملک ها و شرایط آپارتمان نشینی صحبت کرده ایم , امروز درباره تفاوت بین پارکیگ مشاء و پارکینگ اختصاصی صحبت خواهیم کرد.\r\nاکثر آپارتمان هایی که در دهه ۹۰ ساخته می شوند دارای پارکینگ های اختصاصی می باشند. که گاها بعضی از ساختمان ها دارای ۲ یا چند پارکینگ اختصاصی برای هر واحد می باشند.\r\nفروش خانه, خرید خانه, فروش زمین, خرید زمین کشاورزی, فروش آپارتمان\r\nالبته تعدادی از آپارتمان ها برای هر واحد یک آپارتمان اختصاصی دارد و تعدادی هم پارکینگ را مشاء قرار می دهند و از آنجایی که بعضی از مردم تفاوت بین پارکینگ مشاء و پارکینگ اختصاصی را نمی دانند در این مقاله به تفاوت بین این دو نوع پارکینگ می پردازیم.\r\nپارکینگ اختصاصی :\r\nزمانی که در سند یک واحد آپارتمان قید می شود دارای یک واحد پارکینگ به آدرس فلان می باشد.\r\nیعنی یکی از پارکینگ های ساختمان متعلق به این واحد است و هیچ یک از همسایگان حق دخل و تصرف و ایجاد مزاحمت را ندارد و هیچ شخصی غیر از مالک آپارتمان حق ندارد حتی برای یک لحظه کوتاه خودرو خود را در این پارکینک پارک نماید.\r\nپارکینگ مشاء :\r\nاگر یک شیئی یا جایی بین چند نفر مشترک باشد به طوری که بدونه اجازه جمع مالکین کسی حق ایجاد تغییرات بنیادی را در آن ندارد به آن مشاء می گویند.\r\nاین تفسیر در مورد پارکینگ مشاء هم صادق است , پارکینگ مشا بین تمام ساکنین مشترک است.\r\nبه طوری که همه ساکنان ساختمان در پارکینگ سهم دارند و هیچ کدام به تنهایی حق ندارد قسمتی را ادعای مالکیت کند و یا در ورود کرده و تغییراتی را ایجاد نماید .\r\n\r\nدر این گونه ساختمان ها کسی نمی تواند بدونه اجازه جمع برای خود قسمتی را جدا سازی کند و ادعای سهم خواحی داشته باشد.\r\nاز این رو در پارکینگ های مشاء دو یا چند نفر یا همه مالکین سهم دارند و باید به نسبت سهم خود توافق کنند و از پارکینگ استفاده نمایند.\r\nپس باید به نحوه نگارش پارکینگ در سند خود دقت کنید :\r\nپارکینگ مشاء در سند این طور نگارش می شود که آقای فلانی برای پارک خودرو یک یا چند سهم از کل را دارد و یا فلانی حق استفاده از پارکینگ را برای یک یا چند خودرو دارد.\r\nپارکینگ های اختصاصی در سند با درج شماره قطعه با آدرس دقیق داخل پارکینگ و متراژ قید می شود.\r\nهمراه ما باشید …\r\nایران املاک با ۳۰ سال سابقه املاک داری موفق و سابقه ای درخشان در جنوب شرق استان تهران معرف همه مردم می باشد.\r\nمشتری مداری در سرلوحه کارهای ما قرار دارد و طی این سالها همواره سعی شده مشتریان را در زمینه خرید یا فروش آپارتمان یا رهن و اجاره آپارتمان و سایر زمینه ها راضی نگه داریم.\r\nبرخی از فعالیت های ما به شرح زیر می باشد:\r\n#خرید_زمین\r\n#فروش_زمین\r\n#پیش_فروش_آپارتمان\r\n#رهن_مغازه\r\n#رهن_آپارتمان\r\n#رهن_خانه_ویلایی\r\n#اجاره_خانه_ویلایی\r\n#رهن_کامل_خانه\r\n#فروش_زمین_های_کشاورزی\r\n#خرید_آپارتمان\r\n#فروش_مغازه\r\n#رهن\r\n#رهن_در_ورامین\r\n#اجاره_در_ورامین", "تفاوت پارکینگ مشاء و اختصاصی", "", "publish", "open", "open", "", "%d8%aa%d9%81%d8%a7%d9%88%d8%aa-%d9%be%d8%a7%d8%b1%da%a9%db%8c%d9%86%da%af-%d9%85%d8%b4%d8%a7%d8%a1-%d9%88-%d8%a7%d8%ae%d8%aa%d8%b5%d8%a7%d8%b5%db%8c", "", "", "2020-05-30 16:06:53", "2020-05-30 12:36:53", "", "0", "https://sitralweb.com/ir3/?p=230", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("232", "1", "2018-11-10 10:14:30", "2018-11-10 06:44:30", "<!-- wp:paragraph -->\r\n<p>با رعایت این نکته های مهم موقع خرید خانه شما با چشم باز خرید می کنید و در واقع مانند یک کارشناس ساختمان به ملک نگاه می کنید.<br />اگر با این نگاه هوشمندانه ملکی را خرید کنید, هرگز از خرید خود پشیمان نمی شوید.<br />۱_ همسایه ها : به همه ما ثابت شده است که داشتن همسایه های خوب از خوب بودن خود ملک مهم تر است.<br />لازم است که قبل از خرید از وضعیت همسایگان اطلاع پیدا کنیم, چند دفعه به محل رفت و آمد کنید آمار کل محل دستتون میاد.<br />یا می تونید از سوپری محل بپرسید.<br />البته موقع خرید آپارتمان از تمیز بودن راه پله ها و نبودن کفش و جا کفشی و لوازم شخصی تو راه پله میشه فهمید که چقدر با قوانین آپارتمان نشینی آشنا هستند و این قوانین رو رعایت می کنند.<br />۲_ عرض کوچه : در محل های شلوغ اگر عرض کوچه کم باشه موقع رفت و آمد با خودرو به زحمت خواهید افتاد.<br />تو یه کوچه باریک روز اول موقع اساس کشی شما خسته هستید و همسایه ها کلافه شدن , حالا فقط باید صبور باشید.<br />۳_ سکوت و آرامش : معمولا خونه های نزدیک مدارس و اتوبان ها و بیمارستان ها ساختمان های اداری و تجاری روی سکوت و آرامش را نمی بینند. البته خونه هایی که مبحث ۱۹ رو رعایت کرده اند و از عایق های صوتی و حرارتی برای دیوارها و کف و سقف ساختمان استفاده کرده اند از این قاعده مستثنا هستند.<br />۴_ امکانات رفاهی : فاصله یه خونه تا سوپرمارکت, مغازه های میوه فروشی , نانوایی و … مهم است . چرا که هر روز شما یا فرزند شما به زحمت کمتری بیوفتید.<br />۵-امکانات حمل و نقلی : نزدیک بودن ملک به ایستگاه های تاکسی و اتوبوس مهم است چرا که در صورت نیاز زحمت کمتری را متحمل خواهید شد.<br />اما اگر وسیله شخصی دارید دسترسی به اتوبان و خیابان اصلی را در اولویت قرار دهید.<br />توجه به وضعیت ساختمان<br />۶- درب ورودی : عرض درب ورودی ساختمان و همچنین عرض ورودی واحد هم مهم است. شما باید به فکر رد کردن یخچال ساید بای ساید تون باشید.<br />پس خجالت نداره عرض ورودی را متر کنید که کمتر از اندازه مد نظر نباشد. البته اگر دو لنگه باشه بهتره است.<br />۷- راه پله ها : راه پله ها یکی از مهم ترین قسمت های ساختمان است و تمیز بودن آن بستگی به مصالحی دارد که در آن کار شده است.<br />برخی از ساختمان های بی کیفیت دیوار های راه پله را با گچ سفید می کنند . هر ساله باید هزینه ای را متحمل شوید که دیوار های راه پله را رنگ آمیزی کنید.<br />اما در ساختمان های درجه کیفی بالا دیوار های راه پله را سنگ یا سرامیک می کنند . به صورت هفتگی یا ماهانه یا یک دستمال نم دار همه جا پاکیزه می شود.<br />عرض راه پله و پاگرد ها مهم است تا در موقع اسباب کشی به مشکل بر نخورید.<br />۸-تعدا واحد ها : در ساختمان هایی که تعداد واحد ها کمتر است سر و صدای کمتری را خواهید شنید.<br />موقع دیدن ملک به تعدا هر واحد در طبقه و نزدیکی ورودی ها به یک دیگر دقت کنید.<br />۹- حفظ حریم خصوصی : این موضوع برای ما ایرانی ها اهمیت بالایی دارد پس دقت کنیم درب ورودی واحد ها روبری هم نباشند.<br />۱۰- پارکینگ خودرو : برخی ساختمان ها پارکینگ های اضافی علاوه بر مالک برای مهمان ها هم دارند.<br />البته مهم است پارکینگ سقف دارد یا در فضای باز و همچنین هرچه شیب ورودی پارکینگ کمتر باشد عبور و مرور راحت تر است.<br />۱۱- کنتور گاز آب برق : حتما نوع کنتور ها را بپرسید که مشترک هستند یا انفرادی ؟<br />اگر کنتور ها مشترک هستند از مشاور املاک روش محاسبه بهإ آب و گاز و برق را بپرسید و بدانید تا بعدا به مشکل بر نخورید.<br />۱۲- پول شارژ ساختمان : این فکر اشتباه است که بگوییم هرچه شارژ کمتر باشد بهتر است.<br />مبلغ شارژ ساختمان بستگی به عمر ساختمان دارد و باید با هزینه ها و نیاز های ساختمان همخوانی داشته باشد.<br />ساختمان های نوساز معمولا کم هزینه هستند و هواستان باشد اگر ساختمان کلنگی می خرید احتمال تحمیل هزینه تعمیرات بیشتر است.<br />۱۳- کدام طبقه : اگر ساختمان آسانسور ندارد هواستان به پله نوردی روزانه باشد و طبقات اول را انتخاب کنید.<br />و در صورتی که آسانسور دارد طبقات بالا انتخاب بهتری است تا آرامش را لمس کنید.<br />نکته های داخل واحد مسکونی :<br />۱۴- نورگیری واحد : یکی از مهمترین نکات در خرید خانه نورگیری خانه می باشد. خونه های شمالی نور گیری کمتری را نسبت به خانه های جنوبی دارند. و در این واحد ها لامپ های خانه شبانه روز باید روشن باشند.<br />البته نوع معماری و قرار گرفتن تعداد پنجره ها و پاسیو و تراس به دادن نور کافی به داخل واحد کمک می کند.<br />۱۵- نوع گرمایش و سرمایش : اگر سیستم گرمایشی شوفاژ خانه مرکزی هستش حتما به موتورخانه سربزنید و از فرسوده نبودن تجهیزات موتوخانه اطمینان حاصل کنید.<br />اما امروزه اکثر واحد ها پکیج دارند که فقط از سلامت آن مطمعن شوید.<br />داشتن سیستم سرمایشی کولر گازی یک مزیت نیست بلکه به فکر قبض برق هم باشید.<br />اگر سیستم سرمایشی کولر آبی هستش به پشت بام یه سر بزنید ببینید چیزی از کولر آبی باقی مونده یا پوسیده و فرسوده شده است.<br />۱۶- معماری آشپزخانه : نکاتی که در آشپزخانه باید به آن دقت کنید یکی نور آن می باشد. داشتن پنجره خوب می تواند آرامش را به خانم ها بدهد.<br />از دیگر نکات مهم در آشپزخانه داشتن خروجی هود و قرار گیری مناسب مکان اتصالات مربوط به لباس شویی و آبگرکن یا پکیج و اجاق گاز و … می باشد. البته اگر آشپزخانه کابینت بندی شده به مکان یخچال ساید بای ساید هم یه نگاهی بندازید.<br />۱۷- بالکن یا تراس خانه : داشتن بالکن بزرگ تر و با نور گیر کافی یک مزیت است. البته اگر به سمت آشپز خانه باشد در خانه داری به خانم خانه کمک بزرگی می کند.<br />۱۸- دیوارپوش ها : اگر موقع خرید به نوع و سلامت دیوار پوش ها دقت کنید دیگر نیازی نیست که بعدا هزینه کنید.<br />۱۹- حتما نوع کفپوش خانه و مزایای سایر کفپوش ها را از مشاور املاک سوال بپرسید تا بعدا به مشکل بر نخورید.<br />۲۰- اگر نیت خرید خانه را داری حتما نوع سند و قدرالسهم آپارتمان و میزان مشاعات را از مشاور املاک بپرسید.<br />در پایان این که هیچ خانه ای را پیدا نمی کنید که همه این نکته ها را یک جا داشته باشد. پس شما باید درنظر بگیرید برخی از آیتم ها غیر قابل تغییر است مانند نورگیر بودن خانه<br />اما برخی از این آیتم ها با انجام هزینه هایی قابل حل است مانند دیوارپوش و کف شوش و …<br />در نهایت باید از راهنمایی های یک مشاور املاک نهایت استفاده را ببرید.</p>\r\n<!-- /wp:paragraph -->", "نکته های مهم موقع خرید خانه", "", "publish", "open", "open", "", "%d9%86%da%a9%d8%aa%d9%87-%d9%87%d8%a7%db%8c-%d9%85%d9%87%d9%85-%d9%85%d9%88%d9%82%d8%b9-%d8%ae%d8%b1%db%8c%d8%af-%d8%ae%d8%a7%d9%86%d9%87", "", "", "2022-11-26 10:56:59", "2022-11-26 07:26:59", "", "0", "https://sitralweb.com/ir3/?p=232", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("1995", "1", "2020-05-30 16:05:54", "2020-05-30 12:35:54", "", "35ef17ff11e54f75ba0218445aa74c0c", "", "inherit", "open", "closed", "", "35ef17ff11e54f75ba0218445aa74c0c", "", "", "2020-05-30 16:05:54", "2020-05-30 12:35:54", "", "232", "http://sitralweb.com/iranamlak2/wp-content/uploads/2018/11/35ef17ff11e54f75ba0218445aa74c0c.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6366", "1", "2022-05-22 00:15:14", "2022-05-21 19:45:14", "با رعایت این نکته های مهم موقع خرید خانه شما با چشم باز خرید می کنید و در واقع مانند یک کارشناس ساختمان به ملک نگاه می کنید.\r\nاگر با این نگاه هوشمندانه ملکی را خرید کنید, هرگز از خرید خود پشیمان نمی شوید.\r\n۱_ همسایه ها : به همه ما ثابت شده است که داشتن همسایه های خوب از خوب بودن خود ملک مهم تر است.\r\nلازم است که قبل از خرید از وضعیت همسایگان اطلاع پیدا کنیم, چند دفعه به محل رفت و آمد کنید آمار کل محل دستتون میاد.\r\nیا می تونید از سوپری محل بپرسید.\r\nالبته موقع خرید آپارتمان از تمیز بودن راه پله ها و نبودن کفش و جا کفشی و لوازم شخصی تو راه پله میشه فهمید که چقدر با قوانین آپارتمان نشینی آشنا هستند و این قوانین رو رعایت می کنند.\r\n۲_ عرض کوچه : در محل های شلوغ اگر عرض کوچه کم باشه موقع رفت و آمد با خودرو به زحمت خواهید افتاد.\r\nتو یه کوچه باریک روز اول موقع اساس کشی شما خسته هستید و همسایه ها کلافه شدن , حالا فقط باید صبور باشید.\r\n۳_ سکوت و آرامش : معمولا خونه های نزدیک مدارس و اتوبان ها و بیمارستان ها ساختمان های اداری و تجاری روی سکوت و آرامش را نمی بینند. البته خونه هایی که مبحث ۱۹ رو رعایت کرده اند و از عایق های صوتی و حرارتی برای دیوارها و کف و سقف ساختمان استفاده کرده اند از این قاعده مستثنا هستند.\r\n۴_ امکانات رفاهی : فاصله یه خونه تا سوپرمارکت, مغازه های میوه فروشی , نانوایی و … مهم است . چرا که هر روز شما یا فرزند شما به زحمت کمتری بیوفتید.\r\n۵-امکانات حمل و نقلی : نزدیک بودن ملک به ایستگاه های تاکسی و اتوبوس مهم است چرا که در صورت نیاز زحمت کمتری را متحمل خواهید شد.\r\nاما اگر وسیله شخصی دارید دسترسی به اتوبان و خیابان اصلی را در اولویت قرار دهید.\r\nتوجه به وضعیت ساختمان\r\n۶- درب ورودی : عرض درب ورودی ساختمان و همچنین عرض ورودی واحد هم مهم است. شما باید به فکر رد کردن یخچال ساید بای ساید تون باشید.\r\nپس خجالت نداره عرض ورودی را متر کنید که کمتر از اندازه مد نظر نباشد. البته اگر دو لنگه باشه بهتره است.\r\n۷- راه پله ها : راه پله ها یکی از مهم ترین قسمت های ساختمان است و تمیز بودن آن بستگی به مصالحی دارد که در آن کار شده است.\r\nبرخی از ساختمان های بی کیفیت دیوار های راه پله را با گچ سفید می کنند . هر ساله باید هزینه ای را متحمل شوید که دیوار های راه پله را رنگ آمیزی کنید.\r\nاما در ساختمان های درجه کیفی بالا دیوار های راه پله را سنگ یا سرامیک می کنند . به صورت هفتگی یا ماهانه یا یک دستمال نم دار همه جا پاکیزه می شود.\r\nعرض راه پله و پاگرد ها مهم است تا در موقع اسباب کشی به مشکل بر نخورید.\r\n۸-تعدا واحد ها : در ساختمان هایی که تعداد واحد ها کمتر است سر و صدای کمتری را خواهید شنید.\r\nموقع دیدن ملک به تعدا هر واحد در طبقه و نزدیکی ورودی ها به یک دیگر دقت کنید.\r\n۹- حفظ حریم خصوصی : این موضوع برای ما ایرانی ها اهمیت بالایی دارد پس دقت کنیم درب ورودی واحد ها روبری هم نباشند.\r\n۱۰- پارکینگ خودرو : برخی ساختمان ها پارکینگ های اضافی علاوه بر مالک برای مهمان ها هم دارند.\r\nالبته مهم است پارکینگ سقف دارد یا در فضای باز و همچنین هرچه شیب ورودی پارکینگ کمتر باشد عبور و مرور راحت تر است.\r\n۱۱- کنتور گاز آب برق : حتما نوع کنتور ها را بپرسید که مشترک هستند یا انفرادی ؟\r\nاگر کنتور ها مشترک هستند از مشاور املاک روش محاسبه بهإ آب و گاز و برق را بپرسید و بدانید تا بعدا به مشکل بر نخورید.\r\n۱۲- پول شارژ ساختمان : این فکر اشتباه است که بگوییم هرچه شارژ کمتر باشد بهتر است.\r\nمبلغ شارژ ساختمان بستگی به عمر ساختمان دارد و باید با هزینه ها و نیاز های ساختمان همخوانی داشته باشد.\r\nساختمان های نوساز معمولا کم هزینه هستند و هواستان باشد اگر ساختمان کلنگی می خرید احتمال تحمیل هزینه تعمیرات بیشتر است.\r\n۱۳- کدام طبقه : اگر ساختمان آسانسور ندارد هواستان به پله نوردی روزانه باشد و طبقات اول را انتخاب کنید.\r\nو در صورتی که آسانسور دارد طبقات بالا انتخاب بهتری است تا آرامش را لمس کنید.\r\nنکته های داخل واحد مسکونی :\r\n۱۴- نورگیری واحد : یکی از مهمترین نکات در خرید خانه نورگیری خانه می باشد. خونه های شمالی نور گیری کمتری را نسبت به خانه های جنوبی دارند. و در این واحد ها لامپ های خانه شبانه روز باید روشن باشند.\r\nالبته نوع معماری و قرار گرفتن تعداد پنجره ها و پاسیو و تراس به دادن نور کافی به داخل واحد کمک می کند.\r\n۱۵- نوع گرمایش و سرمایش : اگر سیستم گرمایشی شوفاژ خانه مرکزی هستش حتما به موتورخانه سربزنید و از فرسوده نبودن تجهیزات موتوخانه اطمینان حاصل کنید.\r\nاما امروزه اکثر واحد ها پکیج دارند که فقط از سلامت آن مطمعن شوید.\r\nداشتن سیستم سرمایشی کولر گازی یک مزیت نیست بلکه به فکر قبض برق هم باشید.\r\nاگر سیستم سرمایشی کولر آبی هستش به پشت بام یه سر بزنید ببینید چیزی از کولر آبی باقی مونده یا پوسیده و فرسوده شده است.\r\n۱۶- معماری آشپزخانه : نکاتی که در آشپزخانه باید به آن دقت کنید یکی نور آن می باشد. داشتن پنجره خوب می تواند آرامش را به خانم ها بدهد.\r\nاز دیگر نکات مهم در آشپزخانه داشتن خروجی هود و قرار گیری مناسب مکان اتصالات مربوط به لباس شویی و آبگرکن یا پکیج و اجاق گاز و … می باشد. البته اگر آشپزخانه کابینت بندی شده به مکان یخچال ساید بای ساید هم یه نگاهی بندازید.\r\n۱۷- بالکن یا تراس خانه : داشتن بالکن بزرگ تر و با نور گیر کافی یک مزیت است. البته اگر به سمت آشپز خانه باشد در خانه داری به خانم خانه کمک بزرگی می کند.\r\n۱۸- دیوارپوش ها : اگر موقع خرید به نوع و سلامت دیوار پوش ها دقت کنید دیگر نیازی نیست که بعدا هزینه کنید.\r\n۱۹- حتما نوع کفپوش خانه و مزایای سایر کفپوش ها را از مشاور املاک سوال بپرسید تا بعدا به مشکل بر نخورید.\r\n۲۰- اگر نیت خرید خانه را داری حتما نوع سند و قدرالسهم آپارتمان و میزان مشاعات را از مشاور املاک بپرسید.\r\nدر پایان این که هیچ خانه ای را پیدا نمی کنید که همه این نکته ها را یک جا داشته باشد. پس شما باید درنظر بگیرید برخی از آیتم ها غیر قابل تغییر است مانند نورگیر بودن خانه\r\nاما برخی از این آیتم ها با انجام هزینه هایی قابل حل است مانند دیوارپوش و کف شوش و …\r\nدر نهایت باید از راهنمایی های یک مشاور املاک نهایت استفاده را ببرید.\r\n\r\n&nbsp;\r\n\r\n[wordpress_file_upload]", "نکته های مهم موقع خرید خانه", "", "inherit", "closed", "closed", "", "232-revision-v1", "", "", "2022-05-22 00:15:14", "2022-05-21 19:45:14", "", "232", "https://sitralweb.com/ir3/?p=6366", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1996", "1", "2020-05-30 16:06:05", "2020-05-30 12:36:05", "با رعایت این نکته های مهم موقع خرید خانه شما با چشم باز خرید می کنید و در واقع مانند یک کارشناس ساختمان به ملک نگاه می کنید.\r\nاگر با این نگاه هوشمندانه ملکی را خرید کنید, هرگز از خرید خود پشیمان نمی شوید.\r\n۱_ همسایه ها : به همه ما ثابت شده است که داشتن همسایه های خوب از خوب بودن خود ملک مهم تر است.\r\nلازم است که قبل از خرید از وضعیت همسایگان اطلاع پیدا کنیم, چند دفعه به محل رفت و آمد کنید آمار کل محل دستتون میاد.\r\nیا می تونید از سوپری محل بپرسید.\r\nالبته موقع خرید آپارتمان از تمیز بودن راه پله ها و نبودن کفش و جا کفشی و لوازم شخصی تو راه پله میشه فهمید که چقدر با قوانین آپارتمان نشینی آشنا هستند و این قوانین رو رعایت می کنند.\r\n۲_ عرض کوچه : در محل های شلوغ اگر عرض کوچه کم باشه موقع رفت و آمد با خودرو به زحمت خواهید افتاد.\r\nتو یه کوچه باریک روز اول موقع اساس کشی شما خسته هستید و همسایه ها کلافه شدن , حالا فقط باید صبور باشید.\r\n۳_ سکوت و آرامش : معمولا خونه های نزدیک مدارس و اتوبان ها و بیمارستان ها ساختمان های اداری و تجاری روی سکوت و آرامش را نمی بینند. البته خونه هایی که مبحث ۱۹ رو رعایت کرده اند و از عایق های صوتی و حرارتی برای دیوارها و کف و سقف ساختمان استفاده کرده اند از این قاعده مستثنا هستند.\r\n۴_ امکانات رفاهی : فاصله یه خونه تا سوپرمارکت, مغازه های میوه فروشی , نانوایی و … مهم است . چرا که هر روز شما یا فرزند شما به زحمت کمتری بیوفتید.\r\n۵-امکانات حمل و نقلی : نزدیک بودن ملک به ایستگاه های تاکسی و اتوبوس مهم است چرا که در صورت نیاز زحمت کمتری را متحمل خواهید شد.\r\nاما اگر وسیله شخصی دارید دسترسی به اتوبان و خیابان اصلی را در اولویت قرار دهید.\r\nتوجه به وضعیت ساختمان\r\n۶- درب ورودی : عرض درب ورودی ساختمان و همچنین عرض ورودی واحد هم مهم است. شما باید به فکر رد کردن یخچال ساید بای ساید تون باشید.\r\nپس خجالت نداره عرض ورودی را متر کنید که کمتر از اندازه مد نظر نباشد. البته اگر دو لنگه باشه بهتره است.\r\n۷- راه پله ها : راه پله ها یکی از مهم ترین قسمت های ساختمان است و تمیز بودن آن بستگی به مصالحی دارد که در آن کار شده است.\r\nبرخی از ساختمان های بی کیفیت دیوار های راه پله را با گچ سفید می کنند . هر ساله باید هزینه ای را متحمل شوید که دیوار های راه پله را رنگ آمیزی کنید.\r\nاما در ساختمان های درجه کیفی بالا دیوار های راه پله را سنگ یا سرامیک می کنند . به صورت هفتگی یا ماهانه یا یک دستمال نم دار همه جا پاکیزه می شود.\r\nعرض راه پله و پاگرد ها مهم است تا در موقع اسباب کشی به مشکل بر نخورید.\r\n۸-تعدا واحد ها : در ساختمان هایی که تعداد واحد ها کمتر است سر و صدای کمتری را خواهید شنید.\r\nموقع دیدن ملک به تعدا هر واحد در طبقه و نزدیکی ورودی ها به یک دیگر دقت کنید.\r\n۹- حفظ حریم خصوصی : این موضوع برای ما ایرانی ها اهمیت بالایی دارد پس دقت کنیم درب ورودی واحد ها روبری هم نباشند.\r\n۱۰- پارکینگ خودرو : برخی ساختمان ها پارکینگ های اضافی علاوه بر مالک برای مهمان ها هم دارند.\r\nالبته مهم است پارکینگ سقف دارد یا در فضای باز و همچنین هرچه شیب ورودی پارکینگ کمتر باشد عبور و مرور راحت تر است.\r\n۱۱- کنتور گاز آب برق : حتما نوع کنتور ها را بپرسید که مشترک هستند یا انفرادی ؟\r\nاگر کنتور ها مشترک هستند از مشاور املاک روش محاسبه بهإ آب و گاز و برق را بپرسید و بدانید تا بعدا به مشکل بر نخورید.\r\n۱۲- پول شارژ ساختمان : این فکر اشتباه است که بگوییم هرچه شارژ کمتر باشد بهتر است.\r\nمبلغ شارژ ساختمان بستگی به عمر ساختمان دارد و باید با هزینه ها و نیاز های ساختمان همخوانی داشته باشد.\r\nساختمان های نوساز معمولا کم هزینه هستند و هواستان باشد اگر ساختمان کلنگی می خرید احتمال تحمیل هزینه تعمیرات بیشتر است.\r\n۱۳- کدام طبقه : اگر ساختمان آسانسور ندارد هواستان به پله نوردی روزانه باشد و طبقات اول را انتخاب کنید.\r\nو در صورتی که آسانسور دارد طبقات بالا انتخاب بهتری است تا آرامش را لمس کنید.\r\nنکته های داخل واحد مسکونی :\r\n۱۴- نورگیری واحد : یکی از مهمترین نکات در خرید خانه نورگیری خانه می باشد. خونه های شمالی نور گیری کمتری را نسبت به خانه های جنوبی دارند. و در این واحد ها لامپ های خانه شبانه روز باید روشن باشند.\r\nالبته نوع معماری و قرار گرفتن تعداد پنجره ها و پاسیو و تراس به دادن نور کافی به داخل واحد کمک می کند.\r\n۱۵- نوع گرمایش و سرمایش : اگر سیستم گرمایشی شوفاژ خانه مرکزی هستش حتما به موتورخانه سربزنید و از فرسوده نبودن تجهیزات موتوخانه اطمینان حاصل کنید.\r\nاما امروزه اکثر واحد ها پکیج دارند که فقط از سلامت آن مطمعن شوید.\r\nداشتن سیستم سرمایشی کولر گازی یک مزیت نیست بلکه به فکر قبض برق هم باشید.\r\nاگر سیستم سرمایشی کولر آبی هستش به پشت بام یه سر بزنید ببینید چیزی از کولر آبی باقی مونده یا پوسیده و فرسوده شده است.\r\n۱۶- معماری آشپزخانه : نکاتی که در آشپزخانه باید به آن دقت کنید یکی نور آن می باشد. داشتن پنجره خوب می تواند آرامش را به خانم ها بدهد.\r\nاز دیگر نکات مهم در آشپزخانه داشتن خروجی هود و قرار گیری مناسب مکان اتصالات مربوط به لباس شویی و آبگرکن یا پکیج و اجاق گاز و … می باشد. البته اگر آشپزخانه کابینت بندی شده به مکان یخچال ساید بای ساید هم یه نگاهی بندازید.\r\n۱۷- بالکن یا تراس خانه : داشتن بالکن بزرگ تر و با نور گیر کافی یک مزیت است. البته اگر به سمت آشپز خانه باشد در خانه داری به خانم خانه کمک بزرگی می کند.\r\n۱۸- دیوارپوش ها : اگر موقع خرید به نوع و سلامت دیوار پوش ها دقت کنید دیگر نیازی نیست که بعدا هزینه کنید.\r\n۱۹- حتما نوع کفپوش خانه و مزایای سایر کفپوش ها را از مشاور املاک سوال بپرسید تا بعدا به مشکل بر نخورید.\r\n۲۰- اگر نیت خرید خانه را داری حتما نوع سند و قدرالسهم آپارتمان و میزان مشاعات را از مشاور املاک بپرسید.\r\nدر پایان این که هیچ خانه ای را پیدا نمی کنید که همه این نکته ها را یک جا داشته باشد. پس شما باید درنظر بگیرید برخی از آیتم ها غیر قابل تغییر است مانند نورگیر بودن خانه\r\nاما برخی از این آیتم ها با انجام هزینه هایی قابل حل است مانند دیوارپوش و کف شوش و …\r\nدر نهایت باید از راهنمایی های یک مشاور املاک نهایت استفاده را ببرید.", "نکته های مهم موقع خرید خانه", "", "inherit", "closed", "closed", "", "232-revision-v1", "", "", "2020-05-30 16:06:05", "2020-05-30 12:36:05", "", "232", "http://sitralweb.com/iranamlak2/232-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1997", "1", "2020-05-30 16:06:44", "2020-05-30 12:36:44", "", "5327296", "", "inherit", "open", "closed", "", "5327296", "", "", "2020-05-30 16:06:44", "2020-05-30 12:36:44", "", "230", "http://sitralweb.com/iranamlak2/wp-content/uploads/2018/11/5327296.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("1998", "1", "2020-05-30 16:06:53", "2020-05-30 12:36:53", "بار ها شنیده اید که پارکینگ فلان واحد اختصاصی است یا پارکینگ های فلان ساختمان مشاء هستند , این دو با هم تفاوت هایی دارند که خیلی از مردم فرق این دو را نمی دانند.\r\nاجاره خانه, رهن آپارتمان, رهن مغازه, اجاره مغازه بزرگ\r\nدر مقالات قبلی درباره قوانین ملک ها و شرایط آپارتمان نشینی صحبت کرده ایم , امروز درباره تفاوت بین پارکیگ مشاء و پارکینگ اختصاصی صحبت خواهیم کرد.\r\nاکثر آپارتمان هایی که در دهه ۹۰ ساخته می شوند دارای پارکینگ های اختصاصی می باشند. که گاها بعضی از ساختمان ها دارای ۲ یا چند پارکینگ اختصاصی برای هر واحد می باشند.\r\nفروش خانه, خرید خانه, فروش زمین, خرید زمین کشاورزی, فروش آپارتمان\r\nالبته تعدادی از آپارتمان ها برای هر واحد یک آپارتمان اختصاصی دارد و تعدادی هم پارکینگ را مشاء قرار می دهند و از آنجایی که بعضی از مردم تفاوت بین پارکینگ مشاء و پارکینگ اختصاصی را نمی دانند در این مقاله به تفاوت بین این دو نوع پارکینگ می پردازیم.\r\nپارکینگ اختصاصی :\r\nزمانی که در سند یک واحد آپارتمان قید می شود دارای یک واحد پارکینگ به آدرس فلان می باشد.\r\nیعنی یکی از پارکینگ های ساختمان متعلق به این واحد است و هیچ یک از همسایگان حق دخل و تصرف و ایجاد مزاحمت را ندارد و هیچ شخصی غیر از مالک آپارتمان حق ندارد حتی برای یک لحظه کوتاه خودرو خود را در این پارکینک پارک نماید.\r\nپارکینگ مشاء :\r\nاگر یک شیئی یا جایی بین چند نفر مشترک باشد به طوری که بدونه اجازه جمع مالکین کسی حق ایجاد تغییرات بنیادی را در آن ندارد به آن مشاء می گویند.\r\nاین تفسیر در مورد پارکینگ مشاء هم صادق است , پارکینگ مشا بین تمام ساکنین مشترک است.\r\nبه طوری که همه ساکنان ساختمان در پارکینگ سهم دارند و هیچ کدام به تنهایی حق ندارد قسمتی را ادعای مالکیت کند و یا در ورود کرده و تغییراتی را ایجاد نماید .\r\n\r\nدر این گونه ساختمان ها کسی نمی تواند بدونه اجازه جمع برای خود قسمتی را جدا سازی کند و ادعای سهم خواحی داشته باشد.\r\nاز این رو در پارکینگ های مشاء دو یا چند نفر یا همه مالکین سهم دارند و باید به نسبت سهم خود توافق کنند و از پارکینگ استفاده نمایند.\r\nپس باید به نحوه نگارش پارکینگ در سند خود دقت کنید :\r\nپارکینگ مشاء در سند این طور نگارش می شود که آقای فلانی برای پارک خودرو یک یا چند سهم از کل را دارد و یا فلانی حق استفاده از پارکینگ را برای یک یا چند خودرو دارد.\r\nپارکینگ های اختصاصی در سند با درج شماره قطعه با آدرس دقیق داخل پارکینگ و متراژ قید می شود.\r\nهمراه ما باشید …\r\nایران املاک با ۳۰ سال سابقه املاک داری موفق و سابقه ای درخشان در جنوب شرق استان تهران معرف همه مردم می باشد.\r\nمشتری مداری در سرلوحه کارهای ما قرار دارد و طی این سالها همواره سعی شده مشتریان را در زمینه خرید یا فروش آپارتمان یا رهن و اجاره آپارتمان و سایر زمینه ها راضی نگه داریم.\r\nبرخی از فعالیت های ما به شرح زیر می باشد:\r\n#خرید_زمین\r\n#فروش_زمین\r\n#پیش_فروش_آپارتمان\r\n#رهن_مغازه\r\n#رهن_آپارتمان\r\n#رهن_خانه_ویلایی\r\n#اجاره_خانه_ویلایی\r\n#رهن_کامل_خانه\r\n#فروش_زمین_های_کشاورزی\r\n#خرید_آپارتمان\r\n#فروش_مغازه\r\n#رهن\r\n#رهن_در_ورامین\r\n#اجاره_در_ورامین", "تفاوت پارکینگ مشاء و اختصاصی", "", "inherit", "closed", "closed", "", "230-revision-v1", "", "", "2020-05-30 16:06:53", "2020-05-30 12:36:53", "", "230", "http://sitralweb.com/iranamlak2/230-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("1999", "1", "2020-05-30 16:07:36", "2020-05-30 12:37:36", "", "What-is-Real-Estate", "", "inherit", "open", "closed", "", "what-is-real-estate", "", "", "2020-05-30 16:07:36", "2020-05-30 12:37:36", "", "228", "http://sitralweb.com/iranamlak2/wp-content/uploads/2018/11/What-is-Real-Estate.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2000", "1", "2020-05-30 16:07:46", "2020-05-30 12:37:46", "به تمام ملک های منقول و غیر منقول املاک می گویند.\r\nالبته ملک هایی مثل زمین های صنعتی ، زمین مسکونی ، مواد معدنی ، چاه ، ساختمان ها ، محصولات کشاورزی و … جزء املاک محسوب می شوند.\r\nدر بین مردم واژه املاک فقط به خانه و مسکن و یا آپارتمان و مغازه اطلاق می شود اما این تصور اشتباه است.\r\nهمه ملزومات و مکان هایی که در کنار یک ملک قرار دارد و قابل بهره برداری می باشد مانند چاه آب و دامپروری و معدن و زمین کشاورزی هم در این گروه قرار می گیرد.\r\nواژه املاک\r\nیک واژه کلی است که به همه مستغلات و کسب و کار هم تعلق دارد و همچنین به کسی که در زمینه خرید و فروش و امور ملکی باشد هم املاکی می گویند.", "املاک چیست ؟", "", "inherit", "closed", "closed", "", "228-revision-v1", "", "", "2020-05-30 16:07:46", "2020-05-30 12:37:46", "", "228", "http://sitralweb.com/iranamlak2/228-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("2001", "1", "2020-05-30 16:16:50", "2020-05-30 12:46:50", "", "zamin-1", "", "inherit", "open", "closed", "", "zamin-1", "", "", "2020-05-30 16:18:13", "2020-05-30 12:48:13", "", "1896", "http://sitralweb.com/iranamlak2/wp-content/uploads/2020/05/zamin-1.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2002", "1", "2020-05-30 16:17:39", "2020-05-30 12:47:39", "", "apartment-1", "", "inherit", "open", "closed", "", "apartment-1", "", "", "2020-05-30 16:17:41", "2020-05-30 12:47:41", "", "300", "http://sitralweb.com/iranamlak2/wp-content/uploads/2020/05/apartment-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2005", "1", "2020-05-30 16:21:13", "2020-05-30 12:51:13", "", "apartment-4", "", "inherit", "open", "closed", "", "apartment-4", "", "", "2020-05-30 16:31:15", "2020-05-30 13:01:15", "", "305", "http://sitralweb.com/iranamlak2/wp-content/uploads/2020/04/apartment-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4683", "1", "2021-04-05 10:13:59", "2021-04-05 05:43:59", "", "vila3", "", "inherit", "open", "closed", "", "vila3", "", "", "2021-06-25 20:28:14", "2021-06-25 15:58:14", "", "285", "https://sitralweb.com/ir3/wp-content/uploads/2020/04/vila3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2007", "1", "2020-05-30 16:33:12", "2020-05-30 13:03:12", "", "vila-1", "", "inherit", "open", "closed", "", "vila-1", "", "", "2020-05-30 16:33:57", "2020-05-30 13:03:57", "", "302", "http://sitralweb.com/iranamlak2/wp-content/uploads/2020/04/vila-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2008", "1", "2020-05-30 16:33:13", "2020-05-30 13:03:13", "", "vila-2", "", "inherit", "open", "closed", "", "vila-2", "", "", "2020-05-30 16:33:13", "2020-05-30 13:03:13", "", "302", "http://sitralweb.com/iranamlak2/wp-content/uploads/2020/04/vila-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2009", "1", "2020-05-30 16:35:13", "2020-05-30 13:05:13", "", "apartment-6", "", "inherit", "open", "closed", "", "apartment-6", "", "", "2020-05-30 16:35:51", "2020-05-30 13:05:51", "", "297", "http://sitralweb.com/iranamlak2/wp-content/uploads/2020/04/apartment-6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2010", "1", "2020-05-30 16:35:19", "2020-05-30 13:05:19", "", "apartment-7", "", "inherit", "open", "closed", "", "apartment-7", "", "", "2020-05-30 16:35:19", "2020-05-30 13:05:19", "", "297", "http://sitralweb.com/iranamlak2/wp-content/uploads/2020/04/apartment-7.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4682", "1", "2021-04-05 10:13:56", "2021-04-05 05:43:56", "", "apartment2", "", "inherit", "open", "closed", "", "apartment2", "", "", "2022-03-02 21:49:37", "2022-03-02 18:19:37", "", "285", "https://sitralweb.com/ir3/wp-content/uploads/2020/04/apartment2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2012", "1", "2020-05-30 16:36:48", "2020-05-30 13:06:48", "", "vila-8", "", "inherit", "open", "closed", "", "vila-8", "", "", "2020-05-30 16:36:48", "2020-05-30 13:06:48", "", "294", "http://sitralweb.com/iranamlak2/wp-content/uploads/2020/04/vila-8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2013", "1", "2020-05-30 16:38:20", "2020-05-30 13:08:20", "", "vila-4", "", "inherit", "open", "closed", "", "vila-4", "", "", "2020-05-30 16:38:57", "2020-05-30 13:08:57", "", "221", "http://sitralweb.com/iranamlak2/wp-content/uploads/2018/11/vila-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("3520", "2", "2020-10-28 21:00:52", "2020-10-28 17:30:52", "", "16039061361241965350643", "", "inherit", "open", "closed", "", "16039061361241965350643", "", "", "2020-10-28 21:00:52", "2020-10-28 17:30:52", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/10/16039061361241965350643.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2017", "1", "2020-05-30 16:40:44", "2020-05-30 13:10:44", "", "apartment-8", "", "inherit", "open", "closed", "", "apartment-8", "", "", "2020-05-30 16:40:51", "2020-05-30 13:10:51", "", "223", "http://sitralweb.com/iranamlak2/wp-content/uploads/2018/11/apartment-8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6410", "1", "2022-06-24 22:14:03", "2022-06-24 17:44:03", "[iranamlak numstates=\"20\" style_query_shortcode=\"style3\"]", "نمایش آگهی ها به سبک سه", "", "publish", "closed", "closed", "", "%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%a2%da%af%d9%87%db%8c-%d9%87%d8%a7-%d8%a8%d9%87-%d8%b3%d8%a8%da%a9-%d8%b3%d9%87", "", "", "2022-06-24 22:17:28", "2022-06-24 17:47:28", "", "0", "https://sitralweb.com/ir3/?page_id=6410", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("2019", "1", "2020-05-30 17:54:34", "2020-05-30 13:24:34", "&nbsp;\r\n\r\n&nbsp;\r\n\r\nجهت دریافت اطلاعات بیشتر با مشاورین املاک ایران املاک تماس حاصل فرمایید ...\r\n\r\n09112921876\r\n\r\n01155222569\r\n\r\ninfo@sitralweb.com\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nو یا همچنین میتوانید از فرم روبرو جهت ارسال هرگونه نظرات و یا انتقادات خود استفاده نمایید .\r\n\r\nهمکاران ما در اسرع وقت با شما در ارتباط خواهد بود ...", "ارتباط با ما", "", "inherit", "closed", "closed", "", "17-revision-v1", "", "", "2020-05-30 17:54:34", "2020-05-30 13:24:34", "", "17", "https://sitralweb.com/ir3/17-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("2020", "1", "2020-05-30 17:57:38", "2020-05-30 13:27:38", "", "me", "", "inherit", "open", "closed", "", "me", "", "", "2020-05-30 17:57:38", "2020-05-30 13:27:38", "", "7", "https://sitralweb.com/ir3/wp-content/uploads/2020/05/me.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2021", "2", "2020-06-01 22:40:51", "2020-06-01 18:10:51", "", "خرید آپارتمان شیک چالوس رادیو دریا (1)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-1", "", "", "2020-06-01 22:40:51", "2020-06-01 18:10:51", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2022", "2", "2020-06-01 22:40:53", "2020-06-01 18:10:53", "", "خرید آپارتمان شیک چالوس رادیو دریا (2)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-2", "", "", "2020-06-01 22:40:53", "2020-06-01 18:10:53", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2023", "2", "2020-06-01 22:40:54", "2020-06-01 18:10:54", "", "خرید آپارتمان شیک چالوس رادیو دریا (3)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-3", "", "", "2020-06-01 22:40:54", "2020-06-01 18:10:54", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2024", "2", "2020-06-01 22:40:56", "2020-06-01 18:10:56", "", "خرید آپارتمان شیک چالوس رادیو دریا (4)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-4", "", "", "2020-06-01 22:40:56", "2020-06-01 18:10:56", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2025", "2", "2020-06-01 22:40:57", "2020-06-01 18:10:57", "", "خرید آپارتمان شیک چالوس رادیو دریا (5)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-5", "", "", "2020-06-01 22:40:57", "2020-06-01 18:10:57", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2026", "2", "2020-06-01 22:40:58", "2020-06-01 18:10:58", "", "خرید آپارتمان شیک چالوس رادیو دریا (6)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-6", "", "", "2020-06-01 22:40:58", "2020-06-01 18:10:58", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2027", "2", "2020-06-01 22:41:00", "2020-06-01 18:11:00", "", "خرید آپارتمان شیک چالوس رادیو دریا (7)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-7", "", "", "2020-06-01 22:41:00", "2020-06-01 18:11:00", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-7.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2028", "2", "2020-06-01 22:41:02", "2020-06-01 18:11:02", "", "خرید آپارتمان شیک چالوس رادیو دریا (8)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-8", "", "", "2020-06-01 22:41:02", "2020-06-01 18:11:02", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2029", "2", "2020-06-01 22:41:04", "2020-06-01 18:11:04", "", "خرید آپارتمان شیک چالوس رادیو دریا (9)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-9", "", "", "2020-06-01 22:41:04", "2020-06-01 18:11:04", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-9.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2030", "2", "2020-06-01 22:41:06", "2020-06-01 18:11:06", "", "خرید آپارتمان شیک چالوس رادیو دریا (10)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-10", "", "", "2020-06-01 22:41:06", "2020-06-01 18:11:06", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-10.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2031", "2", "2020-06-01 22:41:08", "2020-06-01 18:11:08", "", "خرید آپارتمان شیک چالوس رادیو دریا (11)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-11", "", "", "2020-06-01 22:41:08", "2020-06-01 18:11:08", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-11.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2032", "2", "2020-06-01 22:41:09", "2020-06-01 18:11:09", "", "خرید آپارتمان شیک چالوس رادیو دریا (12)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-12", "", "", "2020-06-01 22:41:09", "2020-06-01 18:11:09", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-12.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2033", "2", "2020-06-01 22:41:11", "2020-06-01 18:11:11", "", "خرید آپارتمان شیک چالوس رادیو دریا (13)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-13", "", "", "2020-06-01 22:41:11", "2020-06-01 18:11:11", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-13.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2034", "2", "2020-06-01 22:41:13", "2020-06-01 18:11:13", "", "خرید آپارتمان شیک چالوس رادیو دریا (14)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-14", "", "", "2020-06-01 22:41:13", "2020-06-01 18:11:13", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-14.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2035", "2", "2020-06-01 22:41:15", "2020-06-01 18:11:15", "", "خرید آپارتمان شیک چالوس رادیو دریا (15)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-15", "", "", "2020-06-01 22:41:15", "2020-06-01 18:11:15", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-15.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2036", "2", "2020-06-01 22:41:17", "2020-06-01 18:11:17", "", "خرید آپارتمان شیک چالوس رادیو دریا (16)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-16", "", "", "2020-06-01 22:41:17", "2020-06-01 18:11:17", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-16.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2037", "2", "2020-06-01 22:41:19", "2020-06-01 18:11:19", "", "خرید آپارتمان شیک چالوس رادیو دریا (17)", "", "inherit", "open", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b4%db%8c%da%a9-%da%86%d8%a7%d9%84%d9%88%d8%b3-%d8%b1%d8%a7%d8%af%db%8c%d9%88-%d8%af%d8%b1%db%8c%d8%a7-17", "", "", "2020-06-01 22:41:19", "2020-06-01 18:11:19", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/خرید-آپارتمان-شیک-چالوس-رادیو-دریا-17.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("5767", "1", "2022-03-11 13:18:03", "2022-03-11 09:48:03", "", "watermark", "", "inherit", "open", "closed", "", "watermark", "", "", "2022-03-11 13:18:03", "2022-03-11 09:48:03", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/03/watermark.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("4525", "1", "2021-02-10 19:35:51", "2021-02-10 16:05:51", "", "دو ماهه کاربر عادی", "", "publish", "closed", "closed", "", "%d8%af%d9%88-%d9%85%d8%a7%d9%87%d9%87-%da%a9%d8%a7%d8%b1%d8%a8%d8%b1-%d8%b9%d8%a7%d8%af%db%8c", "", "", "2021-02-10 19:36:41", "2021-02-10 16:06:41", "", "0", "https://sitralweb.com/ir3/?post_type=package&#038;p=4525", "0", "package", "", "0");
INSERT INTO `wp_posts` VALUES("4531", "1", "2021-02-17 10:46:45", "2021-02-17 07:16:45", "", "woocommerce-placeholder", "", "inherit", "open", "closed", "", "woocommerce-placeholder", "", "", "2021-02-17 10:46:45", "2021-02-17 07:16:45", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/02/woocommerce-placeholder.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("4715", "1", "2021-05-01 19:35:16", "2021-05-01 15:05:16", "تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .", "یک دستگاه گوشی همراه", "تست توضیحات کوتاه محصول در اینجا قرار میگیرد .تست توضیحات کوتاه محصول در اینجا قرار میگیرد . تست توضیحات کوتاه محصول در اینجا قرار میگیرد . تست توضیحات کوتاه محصول در اینجا قرار میگیرد .", "publish", "closed", "closed", "", "%db%8c%da%a9-%d8%af%d8%b3%d8%aa%da%af%d8%a7%d9%87-%da%af%d9%88%d8%b4%db%8c-%d9%87%d9%85%d8%b1%d8%a7%d9%87", "", "", "2021-05-01 19:37:49", "2021-05-01 15:07:49", "", "0", "https://sitralweb.com/ir3/?post_type=product&#038;p=4715", "0", "product", "", "0");
INSERT INTO `wp_posts` VALUES("2836", "2", "2020-08-01 22:37:34", "2020-08-01 18:07:34", "", "2-6", "", "inherit", "open", "closed", "", "2-6", "", "", "2020-08-01 22:37:34", "2020-08-01 18:07:34", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/08/2-6.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("2837", "2", "2020-08-07 02:50:10", "2020-08-06 22:20:10", "", "14", "", "inherit", "open", "closed", "", "14", "", "", "2020-08-07 02:50:10", "2020-08-06 22:20:10", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/08/14.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("2841", "1", "2020-08-08 12:33:07", "2020-08-08 08:03:07", "", "iranamlak-me", "", "inherit", "open", "closed", "", "iranamlak-me", "", "", "2020-08-08 12:33:07", "2020-08-08 08:03:07", "", "27", "https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("6416", "1", "2022-06-24 22:16:53", "2022-06-24 17:46:53", "[iranamlak numstates=\"20\" style_query_shortcode=\"style4\"]", "نمایش آگهی ها به سبک لیستی", "", "inherit", "closed", "closed", "", "6412-autosave-v1", "", "", "2022-06-24 22:16:53", "2022-06-24 17:46:53", "", "6412", "https://sitralweb.com/ir3/?p=6416", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6417", "1", "2022-06-24 23:04:22", "2022-06-24 18:34:22", "<p>[iranamlak numstates=\"20\" style_query_shortcode=\"style1\" mantaghe=\"1412\"]</p>", "نمایش آگهی های یک منطقه خاص", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-06-24 23:04:22", "2022-06-24 18:34:22", "", "5496", "https://sitralweb.com/ir3/?p=6417", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("2842", "1", "2020-08-08 12:36:08", "2020-08-08 08:06:08", "ایران املاک در ابتدا با هدف ایجاد کسب و کار و سپس برای ارئه اطلاعات دقیق ملکی اعم از خرید و فروش ، رهن و اجاره کلیه انواع ملک بصورت تخصصی و حرفه ای برای مشتریان عزیز راه اندازی گردید .\r\n\r\n<img class=\"size-medium wp-image-2840 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-sitralweb-300x156.png\" alt=\"\" width=\"300\" height=\"156\" />\r\n<p style=\"text-align: right;\">\r\nبا توجه به استفاده های بسیار بالای مردمی از فضای مجازی ، به جهت دسترسی بهتر و آسانتر مشتریان با مقوله خرید و فروش ملک در شمال کشور ، با طراحی قالب ایران املاک در سال 1399 ، توانستم تا حدود بسیار زیادی راه را برای تعاملی بهتر فی مابین مشاور و مشتریان هموار کنیم .</p>\r\n<p style=\"text-align: right;\">همینک اینجانب یوسف پور امینیان در زمینه خرید و فروش ، رهن و اجاره سالانه و روزانه مفتخریم بصورت کاملا حرفه ای و تخصصی در کنار مشتریان با مشاوره دقیق در خدمتتان باشیم.</p>\r\n<p style=\"text-align: center;\"><img class=\"alignnone size-medium wp-image-2841\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me-300x300.png\" alt=\"\" width=\"300\" height=\"300\" /></p>\r\nحوضه فعالیت ایران املاک در کل کشور مستقر میباشد و هر شخص در هر کجای کشور عزیزمان ایران میتواند ملک خود را به ثبت برساند و پس از بررسی کارشناسان سیترال وب تایید و در لیست اخرین املاک قرار بگیرد .\r\n\r\nهمچنین جهت دریافت اطلاعات بیشتر میتوانید از طریق مراجعه به صفحه ارتباط با ما از طریق روابط ارتباطی موجود، درخواست ها شکایات انتقادات و نظرات خود را برای ما بفرستید .\r\n\r\nبا تشکر از همکاری شما", "درباره ما", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2020-08-08 12:36:08", "2020-08-08 08:06:08", "", "27", "https://sitralweb.com/ir3/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6428", "1", "2022-06-28 16:22:17", "2022-06-28 11:52:17", "ایران املاک در ابتدا با هدف ایجاد کسب و کار و سپس برای ارئه اطلاعات دقیق ملکی اعم از خرید و فروش ، رهن و اجاره کلیه انواع ملک بصورت تخصصی و حرفه ای برای مشتریان عزیز راه اندازی گردید .\n\n&nbsp;\n\n<img class=\"size-medium wp-image-2845 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png\" alt=\"\" width=\"300\" height=\"148\" />\n\n&nbsp;\n<p style=\"text-align: right;\">با توجه به استفاده های بسیار بالای مردمی از فضای مجازی ، به جهت دسترسی بهتر و آسانتر مشتریان با مقوله خرید و فروش ملک در شمال کشور ، با طراحی قالب ایران املاک در سال 1399 ، توانستم تا حدود بسیار زیادی راه را برای تعاملی بهتر فی مابین مشاور و مشتریان هموار کنیم .</p>\n<p style=\"text-align: right;\">همینک اینجانب یوسف پور امینیان در زمینه خرید و فروش ، رهن و اجاره سالانه و روزانه مفتخریم بصورت کاملا حرفه ای و تخصصی در کنار مشتریان با مشاوره دقیق در خدمتتان باشیم.</p>\n<p style=\"text-align: center;\"><img class=\"alignnone wp-image-2841 size-full\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me.png\" alt=\"\" width=\"600\" height=\"600\" /></p>\nحوضه فعالیت ایران املاک در کل کشور مستقر میباشد و هر شخص در هر کجای کشور عزیزمان ایران میتواند ملک خود را به ثبت برساند و پس از بررسی کارشناسان سیترال وب تایید و در لیست اخرین املاک قرار بگیرد .\n\nقالب ایران املاک دارای امکانات کم نظیر ، همانند فیلتر جستجو پیشرفته ، ارسال ملک با جزئیات ریز بریز و به سلیقه ایران پسند ، کدنویسی بسیار تمیز بدون حتی یک خط کد اضافی ، سئو بسیار عالی جهت کاهش حجم تصاویر بطور خودکار و درج متا تگ های تصویر از روی عنوان ملک ، امکان ساخت لینک با فیلتر دلخواه و درج آن در هر کجای از سایت و یا ارسال ان به دیگران ، کنترل پنل بی نظیر اختصاصی کاربر و مشاور و موارد دیگر ... میباشد .\n\nجهت دریافت اطلاعات بیشتر میتوانید از طریق مراجعه به صفحه ارتباط با ما از طریق روابط ارتباطی موجود، درخواست ها شکایات انتقادات و نظرات خود را برای ما بفرستید .\n\nبا تشکر از همکاری شما", "درباره ما", "", "inherit", "closed", "closed", "", "27-autosave-v1", "", "", "2022-06-28 16:22:17", "2022-06-28 11:52:17", "", "27", "https://sitralweb.com/ir3/?p=6428", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6411", "1", "2022-06-24 22:14:03", "2022-06-24 17:44:03", "[iranamlak numstates=\"20\" style_query_shortcode=\"style3\"]", "نمایش آگهی ها به سبک سه", "", "inherit", "closed", "closed", "", "6410-revision-v1", "", "", "2022-06-24 22:14:03", "2022-06-24 17:44:03", "", "6410", "https://sitralweb.com/ir3/?p=6411", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6412", "1", "2022-06-24 22:14:25", "2022-06-24 17:44:25", "[iranamlak numstates=\"20\" style_query_shortcode=\"style4\"]", "نمایش آگهی ها به سبک لیستی", "", "publish", "closed", "closed", "", "%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%a2%da%af%d9%87%db%8c-%d9%87%d8%a7-%d8%a8%d9%87-%d8%b3%d8%a8%da%a9-%d9%84%db%8c%d8%b3%d8%aa%db%8c", "", "", "2022-06-24 22:17:20", "2022-06-24 17:47:20", "", "0", "https://sitralweb.com/ir3/?page_id=6412", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6413", "1", "2022-06-24 22:14:25", "2022-06-24 17:44:25", "[iranamlak numstates=\"20\" style_query_shortcode=\"style4\"]", "نمایش آگهی ها به سبک لیستی", "", "inherit", "closed", "closed", "", "6412-revision-v1", "", "", "2022-06-24 22:14:25", "2022-06-24 17:44:25", "", "6412", "https://sitralweb.com/ir3/?p=6413", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6524", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "مشارکت در ساخت", "", "publish", "closed", "closed", "", "%d9%85%d8%b4%d8%a7%d8%b1%da%a9%d8%aa-%d8%af%d8%b1-%d8%b3%d8%a7%d8%ae%d8%aa", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6524", "17", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6523", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "خرید و فروش", "", "publish", "closed", "closed", "", "%d8%ae%d8%b1%db%8c%d8%af-%d9%88-%d9%81%d8%b1%d9%88%d8%b4", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6523", "16", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("5679", "1", "2022-03-02 21:57:52", "2022-03-02 18:27:52", "ایران املاک در ابتدا با هدف ایجاد کسب و کار و سپس برای ارئه اطلاعات دقیق ملکی اعم از خرید و فروش ، رهن و اجاره کلیه انواع ملک بصورت تخصصی و حرفه ای برای مشتریان عزیز راه اندازی گردید .\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-2845 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png\" alt=\"\" width=\"300\" height=\"148\" />\r\n\r\n&nbsp;\r\n<p style=\"text-align: right;\">با توجه به استفاده های بسیار بالای مردمی از فضای مجازی ، به جهت دسترسی بهتر و آسانتر مشتریان با مقوله خرید و فروش ملک در شمال کشور ، با طراحی قالب ایران املاک در سال 1399 ، توانستم تا حدود بسیار زیادی راه را برای تعاملی بهتر فی مابین مشاور و مشتریان هموار کنیم .</p>\r\n<p style=\"text-align: right;\">همینک اینجانب یوسف پور امینیان در زمینه خرید و فروش ، رهن و اجاره سالانه و روزانه مفتخریم بصورت کاملا حرفه ای و تخصصی در کنار مشتریان با مشاوره دقیق در خدمتتان باشیم.</p>\r\n<p style=\"text-align: center;\"><img class=\"alignnone wp-image-2841 size-full\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me.png\" alt=\"\" width=\"600\" height=\"600\" /></p>\r\nحوضه فعالیت ایران املاک در کل کشور مستقر میباشد و هر شخص در هر کجای کشور عزیزمان ایران میتواند ملک خود را به ثبت برساند و پس از بررسی کارشناسان سیترال وب تایید و در لیست اخرین املاک قرار بگیرد .\r\n\r\nقالب ایران املاک دارای امکانات کم نظیر ، همانند فیلتر جستجو پیشرفته ، ارسال ملک با جزئیات ریز بریز و به سلیقه ایران پسند ، کدنویسی بسیار تمیز بدون حتی یک خط کد اضافی ، سئو بسیار عالی جهت کاهش حجم تصاویر بطور خودکار و درج متا تگ های تصویر از روی عنوان ملک ، امکان ساخت لینک با فیلتر دلخواه و درج آن در هر کجای از سایت و یا ارسال ان به دیگران ، کنترل پنل بی نظیر اختصاصی کاربر و مشاور و موارد دیگر ... میباشد .\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید از طریق مراجعه به صفحه ارتباط با ما از طریق روابط ارتباطی موجود، درخواست ها شکایات انتقادات و نظرات خود را برای ما بفرستید .\r\n\r\nبا تشکر از همکاری شما", "درباره ما", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2022-03-02 21:57:52", "2022-03-02 18:27:52", "", "27", "https://sitralweb.com/ir3/?p=5679", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("2846", "1", "2020-08-08 16:19:42", "2020-08-08 11:49:42", "ایران املاک در ابتدا با هدف ایجاد کسب و کار و سپس برای ارئه اطلاعات دقیق ملکی اعم از خرید و فروش ، رهن و اجاره کلیه انواع ملک بصورت تخصصی و حرفه ای برای مشتریان عزیز راه اندازی گردید .\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-2845 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png\" alt=\"\" width=\"300\" height=\"148\" />\r\n\r\n&nbsp;\r\n<p style=\"text-align: right;\">با توجه به استفاده های بسیار بالای مردمی از فضای مجازی ، به جهت دسترسی بهتر و آسانتر مشتریان با مقوله خرید و فروش ملک در شمال کشور ، با طراحی قالب ایران املاک در سال 1399 ، توانستم تا حدود بسیار زیادی راه را برای تعاملی بهتر فی مابین مشاور و مشتریان هموار کنیم .</p>\r\n<p style=\"text-align: right;\">همینک اینجانب یوسف پور امینیان در زمینه خرید و فروش ، رهن و اجاره سالانه و روزانه مفتخریم بصورت کاملا حرفه ای و تخصصی در کنار مشتریان با مشاوره دقیق در خدمتتان باشیم.</p>\r\n<p style=\"text-align: center;\"><img class=\"alignnone wp-image-2841 size-full\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me.png\" alt=\"\" width=\"600\" height=\"600\" /></p>\r\nحوضه فعالیت ایران املاک در کل کشور مستقر میباشد و هر شخص در هر کجای کشور عزیزمان ایران میتواند ملک خود را به ثبت برساند و پس از بررسی کارشناسان سیترال وب تایید و در لیست اخرین املاک قرار بگیرد .\r\n\r\nقالب ایران املاک دارای امکانات کم نظیر ، همانند فیلتر جستجو پیشرفته ، ارسال ملک با جزئیات ریز بریز و به سلیقه ایران پسند ، کدنویسی بسیار تمیز بدون حتی یک خط کد اضافی ، سئو بسیار عالی جهت کاهش حجم تصاویر بطور خودکار و درج متا تگ های تصویر از روی عنوان ملک ، امکان ساخت لینک با فیلتر دلخواه و درج آن در هر کجای از سایت و یا ارسال ان به دیگران ، کنترل پنل بی نظیر اختصاصی کاربر و مشاور و موارد دیگر ... میباشد .\r\n\r\nاز دیگر مزایای قالب ایران املاک امکان سفارش اپلیکیشن اختصاصی تنها با یک دهم قیمت و تحویل در زمان نهایت یک هفته ای میباشد که به شدت از هزینه های بسیار بالای طراحی اپلیکیشن برایتان میکاهد .\r\n\r\nیک اپلیکیشن اندروید با امکان جستجو ملک ، درج ملک ، ویرایش اطلاعات کاربری ، نمایش اخرین املاک تایید شده در سایت ...\r\n\r\n&nbsp;\r\n\r\n<img class=\"wp-image-2843 size-full aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/application.png\" alt=\"\" width=\"678\" height=\"404\" />\r\n\r\n&nbsp;\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید از طریق مراجعه به صفحه ارتباط با ما از طریق روابط ارتباطی موجود، درخواست ها شکایات انتقادات و نظرات خود را برای ما بفرستید .\r\n\r\nبا تشکر از همکاری شما", "درباره ما", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2020-08-08 16:19:42", "2020-08-08 11:49:42", "", "27", "https://sitralweb.com/ir3/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("2844", "1", "2020-08-08 16:10:57", "2020-08-08 11:40:57", "ایران املاک در ابتدا با هدف ایجاد کسب و کار و سپس برای ارئه اطلاعات دقیق ملکی اعم از خرید و فروش ، رهن و اجاره کلیه انواع ملک بصورت تخصصی و حرفه ای برای مشتریان عزیز راه اندازی گردید .\r\n\r\n<img class=\"size-medium wp-image-2840 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-sitralweb-300x156.png\" alt=\"\" width=\"300\" height=\"156\" />\r\n<p style=\"text-align: right;\">با توجه به استفاده های بسیار بالای مردمی از فضای مجازی ، به جهت دسترسی بهتر و آسانتر مشتریان با مقوله خرید و فروش ملک در شمال کشور ، با طراحی قالب ایران املاک در سال 1399 ، توانستم تا حدود بسیار زیادی راه را برای تعاملی بهتر فی مابین مشاور و مشتریان هموار کنیم .</p>\r\n<p style=\"text-align: right;\">همینک اینجانب یوسف پور امینیان در زمینه خرید و فروش ، رهن و اجاره سالانه و روزانه مفتخریم بصورت کاملا حرفه ای و تخصصی در کنار مشتریان با مشاوره دقیق در خدمتتان باشیم.</p>\r\n<p style=\"text-align: center;\"><img class=\"alignnone wp-image-2841 size-full\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me.png\" alt=\"\" width=\"600\" height=\"600\" /></p>\r\nحوضه فعالیت ایران املاک در کل کشور مستقر میباشد و هر شخص در هر کجای کشور عزیزمان ایران میتواند ملک خود را به ثبت برساند و پس از بررسی کارشناسان سیترال وب تایید و در لیست اخرین املاک قرار بگیرد .\r\n\r\nقالب ایران املاک دارای امکانات کم نظیر ، همانند فیلتر جستجو پیشرفته ، ارسال ملک با جزئیات ریز بریز و به سلیقه ایران پسند ، کدنویسی بسیار تمیز بدون حتی یک خط کد اضافی ، سئو بسیار عالی جهت کاهش حجم تصاویر بطور خودکار و درج متا تگ های تصویر از روی عنوان ملک ، امکان ساخت لینک با فیلتر دلخواه و درج آن در هر کجای از سایت و یا ارسال ان به دیگران ، کنترل پنل بی نظیر اختصاصی کاربر و مشاور و موارد دیگر ... میباشد .\r\n\r\nاز دیگر مزایای قالب ایران املاک امکان سفارش اپلیکیشن اختصاصی تنها با یک دهم قیمت و تحویل در زمان نهایت یک هفته ای میباشد که به شدت از هزینه های بسیار بالای طراحی اپلیکیشن برایتان میکاهد .\r\n\r\nیک اپلیکیشن اندروید با امکان جستجو ملک ، درج ملک ، ویرایش اطلاعات کاربری ، نمایش اخرین املاک تایید شده در سایت ...\r\n\r\n&nbsp;\r\n\r\n<img class=\"wp-image-2843 size-full aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/application.png\" alt=\"\" width=\"678\" height=\"404\" />\r\n\r\n&nbsp;\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید از طریق مراجعه به صفحه ارتباط با ما از طریق روابط ارتباطی موجود، درخواست ها شکایات انتقادات و نظرات خود را برای ما بفرستید .\r\n\r\nبا تشکر از همکاری شما", "درباره ما", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2020-08-08 16:10:57", "2020-08-08 11:40:57", "", "27", "https://sitralweb.com/ir3/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("2845", "1", "2020-08-08 16:19:32", "2020-08-08 11:49:32", "", "iranamlak2-sitralweb", "", "inherit", "open", "closed", "", "iranamlak2-sitralweb", "", "", "2020-08-08 16:19:32", "2020-08-08 11:49:32", "", "27", "https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("2848", "1", "2020-08-08 16:44:38", "2020-08-08 12:14:38", "", "logo3", "", "inherit", "open", "closed", "", "logo3", "", "", "2020-08-08 16:44:38", "2020-08-08 12:14:38", "", "7", "https://sitralweb.com/ir3/wp-content/uploads/2020/05/logo3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("6427", "1", "2022-06-28 10:24:28", "2022-06-28 05:54:28", "", "apartment-6-scaled", "", "inherit", "open", "closed", "", "apartment-6-scaled", "", "", "2022-06-28 10:24:38", "2022-06-28 05:54:38", "", "297", "https://sitralweb.com/ir3/wp-content/uploads/2022/02/apartment-6-scaled-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6429", "1", "2022-06-28 16:23:21", "2022-06-28 11:53:21", "&nbsp;\n\n&nbsp;\n\nجهت دریافت اطلاعات بیشتر با مشاورین املاک ایران املاک تماس حاصل فرمایید ...\n\n09123456789\n\n01234567890\n\ninfo@test.com\n\n&nbsp;\n\n&nbsp;\n\nو یا همچنین میتوانید از فرم روبرو جهت ارسال هرگونه نظرات و یا انتقادات خود استفاده نمایید .\n\nهمکاران ما در اسرع وقت با شما در ارتباط خواهد بود ...", "ارتباط با ما", "", "inherit", "closed", "closed", "", "17-autosave-v1", "", "", "2022-06-28 16:23:21", "2022-06-28 11:53:21", "", "17", "https://sitralweb.com/ir3/?p=6429", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6430", "1", "2022-06-28 16:30:36", "2022-06-28 12:00:36", "[iranamlak moamele=\"خرید و فروش\" pishforosh=\"1\"]", "همه پیشفروش ها", "", "inherit", "closed", "closed", "", "5511-autosave-v1", "", "", "2022-06-28 16:30:36", "2022-06-28 12:00:36", "", "5511", "https://sitralweb.com/ir3/?p=6430", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6376", "1", "2022-05-25 11:40:41", "2022-05-25 07:10:41", "<!-- wp:paragraph -->\n<p>با رعایت این نکته های مهم موقع خرید خانه شما با چشم باز خرید می کنید و در واقع مانند یک کارشناس ساختمان به ملک نگاه می کنید.<br>اگر با این نگاه هوشمندانه ملکی را خرید کنید, هرگز از خرید خود پشیمان نمی شوید.<br>۱_ همسایه ها : به همه ما ثابت شده است که داشتن همسایه های خوب از خوب بودن خود ملک مهم تر است.<br>لازم است که قبل از خرید از وضعیت همسایگان اطلاع پیدا کنیم, چند دفعه به محل رفت و آمد کنید آمار کل محل دستتون میاد.<br>یا می تونید از سوپری محل بپرسید.<br>البته موقع خرید آپارتمان از تمیز بودن راه پله ها و نبودن کفش و جا کفشی و لوازم شخصی تو راه پله میشه فهمید که چقدر با قوانین آپارتمان نشینی آشنا هستند و این قوانین رو رعایت می کنند.<br>۲_ عرض کوچه : در محل های شلوغ اگر عرض کوچه کم باشه موقع رفت و آمد با خودرو به زحمت خواهید افتاد.<br>تو یه کوچه باریک روز اول موقع اساس کشی شما خسته هستید و همسایه ها کلافه شدن , حالا فقط باید صبور باشید.<br>۳_ سکوت و آرامش : معمولا خونه های نزدیک مدارس و اتوبان ها و بیمارستان ها ساختمان های اداری و تجاری روی سکوت و آرامش را نمی بینند. البته خونه هایی که مبحث ۱۹ رو رعایت کرده اند و از عایق های صوتی و حرارتی برای دیوارها و کف و سقف ساختمان استفاده کرده اند از این قاعده مستثنا هستند.<br>۴_ امکانات رفاهی : فاصله یه خونه تا سوپرمارکت, مغازه های میوه فروشی , نانوایی و … مهم است . چرا که هر روز شما یا فرزند شما به زحمت کمتری بیوفتید.<br>۵-امکانات حمل و نقلی : نزدیک بودن ملک به ایستگاه های تاکسی و اتوبوس مهم است چرا که در صورت نیاز زحمت کمتری را متحمل خواهید شد.<br>اما اگر وسیله شخصی دارید دسترسی به اتوبان و خیابان اصلی را در اولویت قرار دهید.<br>توجه به وضعیت ساختمان<br>۶- درب ورودی : عرض درب ورودی ساختمان و همچنین عرض ورودی واحد هم مهم است. شما باید به فکر رد کردن یخچال ساید بای ساید تون باشید.<br>پس خجالت نداره عرض ورودی را متر کنید که کمتر از اندازه مد نظر نباشد. البته اگر دو لنگه باشه بهتره است.<br>۷- راه پله ها : راه پله ها یکی از مهم ترین قسمت های ساختمان است و تمیز بودن آن بستگی به مصالحی دارد که در آن کار شده است.<br>برخی از ساختمان های بی کیفیت دیوار های راه پله را با گچ سفید می کنند . هر ساله باید هزینه ای را متحمل شوید که دیوار های راه پله را رنگ آمیزی کنید.<br>اما در ساختمان های درجه کیفی بالا دیوار های راه پله را سنگ یا سرامیک می کنند . به صورت هفتگی یا ماهانه یا یک دستمال نم دار همه جا پاکیزه می شود.<br>عرض راه پله و پاگرد ها مهم است تا در موقع اسباب کشی به مشکل بر نخورید.<br>۸-تعدا واحد ها : در ساختمان هایی که تعداد واحد ها کمتر است سر و صدای کمتری را خواهید شنید.<br>موقع دیدن ملک به تعدا هر واحد در طبقه و نزدیکی ورودی ها به یک دیگر دقت کنید.<br>۹- حفظ حریم خصوصی : این موضوع برای ما ایرانی ها اهمیت بالایی دارد پس دقت کنیم درب ورودی واحد ها روبری هم نباشند.<br>۱۰- پارکینگ خودرو : برخی ساختمان ها پارکینگ های اضافی علاوه بر مالک برای مهمان ها هم دارند.<br>البته مهم است پارکینگ سقف دارد یا در فضای باز و همچنین هرچه شیب ورودی پارکینگ کمتر باشد عبور و مرور راحت تر است.<br>۱۱- کنتور گاز آب برق : حتما نوع کنتور ها را بپرسید که مشترک هستند یا انفرادی ؟<br>اگر کنتور ها مشترک هستند از مشاور املاک روش محاسبه بهإ آب و گاز و برق را بپرسید و بدانید تا بعدا به مشکل بر نخورید.<br>۱۲- پول شارژ ساختمان : این فکر اشتباه است که بگوییم هرچه شارژ کمتر باشد بهتر است.<br>مبلغ شارژ ساختمان بستگی به عمر ساختمان دارد و باید با هزینه ها و نیاز های ساختمان همخوانی داشته باشد.<br>ساختمان های نوساز معمولا کم هزینه هستند و هواستان باشد اگر ساختمان کلنگی می خرید احتمال تحمیل هزینه تعمیرات بیشتر است.<br>۱۳- کدام طبقه : اگر ساختمان آسانسور ندارد هواستان به پله نوردی روزانه باشد و طبقات اول را انتخاب کنید.<br>و در صورتی که آسانسور دارد طبقات بالا انتخاب بهتری است تا آرامش را لمس کنید.<br>نکته های داخل واحد مسکونی :<br>۱۴- نورگیری واحد : یکی از مهمترین نکات در خرید خانه نورگیری خانه می باشد. خونه های شمالی نور گیری کمتری را نسبت به خانه های جنوبی دارند. و در این واحد ها لامپ های خانه شبانه روز باید روشن باشند.<br>البته نوع معماری و قرار گرفتن تعداد پنجره ها و پاسیو و تراس به دادن نور کافی به داخل واحد کمک می کند.<br>۱۵- نوع گرمایش و سرمایش : اگر سیستم گرمایشی شوفاژ خانه مرکزی هستش حتما به موتورخانه سربزنید و از فرسوده نبودن تجهیزات موتوخانه اطمینان حاصل کنید.<br>اما امروزه اکثر واحد ها پکیج دارند که فقط از سلامت آن مطمعن شوید.<br>داشتن سیستم سرمایشی کولر گازی یک مزیت نیست بلکه به فکر قبض برق هم باشید.<br>اگر سیستم سرمایشی کولر آبی هستش به پشت بام یه سر بزنید ببینید چیزی از کولر آبی باقی مونده یا پوسیده و فرسوده شده است.<br>۱۶- معماری آشپزخانه : نکاتی که در آشپزخانه باید به آن دقت کنید یکی نور آن می باشد. داشتن پنجره خوب می تواند آرامش را به خانم ها بدهد.<br>از دیگر نکات مهم در آشپزخانه داشتن خروجی هود و قرار گیری مناسب مکان اتصالات مربوط به لباس شویی و آبگرکن یا پکیج و اجاق گاز و … می باشد. البته اگر آشپزخانه کابینت بندی شده به مکان یخچال ساید بای ساید هم یه نگاهی بندازید.<br>۱۷- بالکن یا تراس خانه : داشتن بالکن بزرگ تر و با نور گیر کافی یک مزیت است. البته اگر به سمت آشپز خانه باشد در خانه داری به خانم خانه کمک بزرگی می کند.<br>۱۸- دیوارپوش ها : اگر موقع خرید به نوع و سلامت دیوار پوش ها دقت کنید دیگر نیازی نیست که بعدا هزینه کنید.<br>۱۹- حتما نوع کفپوش خانه و مزایای سایر کفپوش ها را از مشاور املاک سوال بپرسید تا بعدا به مشکل بر نخورید.<br>۲۰- اگر نیت خرید خانه را داری حتما نوع سند و قدرالسهم آپارتمان و میزان مشاعات را از مشاور املاک بپرسید.<br>در پایان این که هیچ خانه ای را پیدا نمی کنید که همه این نکته ها را یک جا داشته باشد. پس شما باید درنظر بگیرید برخی از آیتم ها غیر قابل تغییر است مانند نورگیر بودن خانه<br>اما برخی از این آیتم ها با انجام هزینه هایی قابل حل است مانند دیوارپوش و کف شوش و …<br>در نهایت باید از راهنمایی های یک مشاور املاک نهایت استفاده را ببرید.</p>\n<!-- /wp:paragraph -->", "نکته های مهم موقع خرید خانه", "", "inherit", "closed", "closed", "", "232-revision-v1", "", "", "2022-05-25 11:40:41", "2022-05-25 07:10:41", "", "232", "https://sitralweb.com/ir3/?p=6376", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5519", "1", "2022-02-21 16:19:01", "2022-02-21 12:49:01", "", "مشاور شوید", "", "inherit", "closed", "closed", "", "5518-revision-v1", "", "", "2022-02-21 16:19:01", "2022-02-21 12:49:01", "", "5518", "https://sitralweb.com/ir3/?p=5519", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5518", "1", "2022-02-21 16:19:01", "2022-02-21 12:49:01", "", "مشاور شوید", "", "publish", "closed", "closed", "", "%d9%85%d8%b4%d8%a7%d9%88%d8%b1-%d8%b4%d9%88%db%8c%d8%af", "", "", "2022-04-06 00:09:18", "2022-04-05 19:39:18", "", "0", "https://sitralweb.com/ir3/?page_id=5518", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5496", "1", "2022-02-10 13:53:32", "2022-02-10 10:23:32", "<p>[iranamlak numstates=\"20\" style_query_shortcode=\"style1\" mantaghe=\"1412\"]</p>", "نمایش آگهی های یک منطقه خاص", "", "publish", "closed", "closed", "", "%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%a2%da%af%d9%87%db%8c-%d9%87%d8%a7%db%8c-%db%8c%da%a9-%d9%85%d9%86%d8%b7%d9%82%d9%87-%d8%ae%d8%a7%d8%b5", "", "", "2022-06-24 23:04:22", "2022-06-24 18:34:22", "", "0", "https://sitralweb.com/ir3/?page_id=5496", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6142", "1", "2022-04-28 01:49:59", "2022-04-27 21:19:59", "{\"version\": 2, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-iranamlak", "", "", "2022-04-28 01:49:59", "2022-04-27 21:19:59", "", "0", "https://sitralweb.com/ir3/wp-global-styles-iranamlak/", "0", "wp_global_styles", "", "0");
INSERT INTO `wp_posts` VALUES("6146", "1", "2022-04-28 01:55:29", "2022-04-27 21:25:29", "<!-- wp:paragraph -->\r\n<p>&nbsp;</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:shortcode -->\r\n<p>[iranamlak mantaghe=\"1412\"]</p>\r\n<!-- /wp:shortcode -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>&nbsp;</p>\r\n<!-- /wp:paragraph -->", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-04-28 01:55:29", "2022-04-27 21:25:29", "", "5496", "https://sitralweb.com/ir3/?p=6146", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5498", "1", "2022-02-10 13:54:29", "2022-02-10 10:24:29", "شما میتوانید یک دسته بندی با لینک دلخاه با مشخصات دلخاه ایجاد نمایید به راحتی اب خوردن بدون هیچگونه دانش کد نویسی . سیترال وب در تلاش است بهترین ها را به ارمغان بیاورد .\r\n\r\nتوضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-02-10 13:54:29", "2022-02-10 10:24:29", "", "5496", "https://sitralweb.com/ir3/?p=5498", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6373", "2", "2022-05-24 17:46:40", "2022-05-24 13:16:40", "", "3146723190705202102", "", "inherit", "open", "closed", "", "3146723190705202102", "", "", "2022-12-17 08:09:37", "2022-12-17 04:39:37", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/05/3146723190705202102.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6530", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "ویلا های دارای استخر", "", "publish", "closed", "closed", "", "%d9%88%db%8c%d9%84%d8%a7-%d9%87%d8%a7%db%8c-%d8%af%d8%a7%d8%b1%d8%a7%db%8c-%d8%a7%d8%b3%d8%aa%d8%ae%d8%b1", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6530", "23", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6529", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "آپارتمان زیر 5 میلیارد", "", "publish", "closed", "closed", "", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-%d8%b2%db%8c%d8%b1-5-%d9%85%db%8c%d9%84%db%8c%d8%a7%d8%b1%d8%af", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6529", "22", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("5497", "1", "2022-02-10 13:53:32", "2022-02-10 10:23:32", "توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .\r\n\r\nتوضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .\r\n\r\nتوضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-02-10 13:53:32", "2022-02-10 10:23:32", "", "5496", "https://sitralweb.com/ir3/?p=5497", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6526", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "رهن و اجاره", "", "publish", "closed", "closed", "", "%d8%b1%d9%87%d9%86-%d9%88-%d8%a7%d8%ac%d8%a7%d8%b1%d9%87", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6526", "19", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6525", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "پیش فروش", "", "publish", "closed", "closed", "", "%d9%be%db%8c%d8%b4-%d9%81%d8%b1%d9%88%d8%b4", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6525", "18", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("5512", "1", "2022-02-10 16:42:42", "2022-02-10 13:12:42", "", "همه پیشفروش ها", "", "inherit", "closed", "closed", "", "5511-revision-v1", "", "", "2022-02-10 16:42:42", "2022-02-10 13:12:42", "", "5511", "https://sitralweb.com/ir3/?p=5512", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6527", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "اجاره روزانه", "", "publish", "closed", "closed", "", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%b1%d9%88%d8%b2%d8%a7%d9%86%d9%87", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6527", "20", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("5511", "1", "2022-02-10 16:42:42", "2022-02-10 13:12:42", "[iranamlak moamele=\"خرید و فروش\" pishforosh=\"1\"]", "همه پیشفروش ها", "", "publish", "closed", "closed", "", "%d9%87%d9%85%d9%87-%d9%be%db%8c%d8%b4%d9%81%d8%b1%d9%88%d8%b4-%d9%87%d8%a7", "", "", "2022-04-28 01:20:25", "2022-04-27 20:50:25", "", "0", "https://sitralweb.com/ir3/?page_id=5511", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5510", "1", "2022-02-10 16:42:20", "2022-02-10 13:12:20", "", "همه مشارکت در ساخت ها", "", "inherit", "closed", "closed", "", "5509-revision-v1", "", "", "2022-02-10 16:42:20", "2022-02-10 13:12:20", "", "5509", "https://sitralweb.com/ir3/?p=5510", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5509", "1", "2022-02-10 16:42:20", "2022-02-10 13:12:20", "[iranamlak moamele=\"خرید و فروش\" mosharekat=\"1\"]", "همه مشارکت در ساخت ها", "", "publish", "closed", "closed", "", "%d9%87%d9%85%d9%87-%d9%85%d8%b4%d8%a7%d8%b1%da%a9%d8%aa-%d8%af%d8%b1-%d8%b3%d8%a7%d8%ae%d8%aa-%d9%87%d8%a7", "", "", "2022-04-28 01:20:52", "2022-04-27 20:50:52", "", "0", "https://sitralweb.com/ir3/?page_id=5509", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5508", "1", "2022-02-10 16:41:41", "2022-02-10 13:11:41", "", "همه ملک های اجاره ای", "", "inherit", "closed", "closed", "", "5507-revision-v1", "", "", "2022-02-10 16:41:41", "2022-02-10 13:11:41", "", "5507", "https://sitralweb.com/ir3/?p=5508", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5506", "1", "2022-02-10 16:40:55", "2022-02-10 13:10:55", "", "همه ملک های رامسر", "", "inherit", "closed", "closed", "", "5505-revision-v1", "", "", "2022-02-10 16:40:55", "2022-02-10 13:10:55", "", "5505", "https://sitralweb.com/ir3/?p=5506", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5507", "1", "2022-02-10 16:41:41", "2022-02-10 13:11:41", "[iranamlak numstates=\"20\" style_query_shortcode=\"style2\"]", "نمایش آگهی ها به سبک دو", "", "publish", "closed", "closed", "", "%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%a2%da%af%d9%87%db%8c-%d9%87%d8%a7-%d8%a8%d9%87-%d8%b3%d8%a8%da%a9-%d8%af%d9%88", "", "", "2022-06-24 22:27:15", "2022-06-24 17:57:15", "", "0", "https://sitralweb.com/ir3/?page_id=5507", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5505", "1", "2022-02-10 16:40:55", "2022-02-10 13:10:55", "[iranamlak mantaghe=\"1386\"]", "همه ملک های رامسر", "", "publish", "closed", "closed", "", "%d9%87%d9%85%d9%87-%d9%85%d9%84%da%a9-%d9%87%d8%a7%db%8c-%d8%b1%d8%a7%d9%85%d8%b3%d8%b1", "", "", "2022-04-28 01:22:03", "2022-04-27 20:52:03", "", "0", "https://sitralweb.com/ir3/?page_id=5505", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5502", "1", "2022-02-10 16:39:11", "2022-02-10 13:09:11", "[iranamlak moamele=\"خرید و فروش\" moaveze=\"1\"]", "همه معاوضه ها", "", "publish", "closed", "closed", "", "%d9%87%d9%85%d9%87-%d9%85%d8%b9%d8%a7%d9%88%d8%b6%d9%87-%d9%87%d8%a7", "", "", "2022-11-27 10:15:56", "2022-11-27 06:45:56", "", "0", "https://sitralweb.com/ir3/?page_id=5502", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5503", "1", "2022-02-10 16:39:11", "2022-02-10 13:09:11", "", "همه معاوضه ها", "", "inherit", "closed", "closed", "", "5502-revision-v1", "", "", "2022-02-10 16:39:11", "2022-02-10 13:09:11", "", "5502", "https://sitralweb.com/ir3/?p=5503", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6528", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "ترکیبی", "", "publish", "closed", "closed", "", "%d8%aa%d8%b1%da%a9%db%8c%d8%a8%db%8c", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6528", "21", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("5276", "1", "2022-02-02 20:29:49", "2022-02-02 16:59:49", "", "پکیج ها", "", "inherit", "closed", "closed", "", "5275-revision-v1", "", "", "2022-02-02 20:29:49", "2022-02-02 16:59:49", "", "5275", "https://sitralweb.com/ir3/?p=5276", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5678", "1", "2022-03-02 21:51:01", "2022-03-02 18:21:01", "", "iranamlakpic2", "", "inherit", "open", "closed", "", "iranamlakpic2", "", "", "2022-04-26 10:17:10", "2022-04-26 05:47:10", "", "212", "https://sitralweb.com/ir3/wp-content/uploads/2022/02/iranamlakpic2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("6368", "1", "2022-05-22 00:17:42", "2022-05-21 19:47:42", "با رعایت این نکته های مهم موقع خرید خانه شما با چشم باز خرید می کنید و در واقع مانند یک کارشناس ساختمان به ملک نگاه می کنید.\r\nاگر با این نگاه هوشمندانه ملکی را خرید کنید, هرگز از خرید خود پشیمان نمی شوید.\r\n۱_ همسایه ها : به همه ما ثابت شده است که داشتن همسایه های خوب از خوب بودن خود ملک مهم تر است.\r\nلازم است که قبل از خرید از وضعیت همسایگان اطلاع پیدا کنیم, چند دفعه به محل رفت و آمد کنید آمار کل محل دستتون میاد.\r\nیا می تونید از سوپری محل بپرسید.\r\nالبته موقع خرید آپارتمان از تمیز بودن راه پله ها و نبودن کفش و جا کفشی و لوازم شخصی تو راه پله میشه فهمید که چقدر با قوانین آپارتمان نشینی آشنا هستند و این قوانین رو رعایت می کنند.\r\n۲_ عرض کوچه : در محل های شلوغ اگر عرض کوچه کم باشه موقع رفت و آمد با خودرو به زحمت خواهید افتاد.\r\nتو یه کوچه باریک روز اول موقع اساس کشی شما خسته هستید و همسایه ها کلافه شدن , حالا فقط باید صبور باشید.\r\n۳_ سکوت و آرامش : معمولا خونه های نزدیک مدارس و اتوبان ها و بیمارستان ها ساختمان های اداری و تجاری روی سکوت و آرامش را نمی بینند. البته خونه هایی که مبحث ۱۹ رو رعایت کرده اند و از عایق های صوتی و حرارتی برای دیوارها و کف و سقف ساختمان استفاده کرده اند از این قاعده مستثنا هستند.\r\n۴_ امکانات رفاهی : فاصله یه خونه تا سوپرمارکت, مغازه های میوه فروشی , نانوایی و … مهم است . چرا که هر روز شما یا فرزند شما به زحمت کمتری بیوفتید.\r\n۵-امکانات حمل و نقلی : نزدیک بودن ملک به ایستگاه های تاکسی و اتوبوس مهم است چرا که در صورت نیاز زحمت کمتری را متحمل خواهید شد.\r\nاما اگر وسیله شخصی دارید دسترسی به اتوبان و خیابان اصلی را در اولویت قرار دهید.\r\nتوجه به وضعیت ساختمان\r\n۶- درب ورودی : عرض درب ورودی ساختمان و همچنین عرض ورودی واحد هم مهم است. شما باید به فکر رد کردن یخچال ساید بای ساید تون باشید.\r\nپس خجالت نداره عرض ورودی را متر کنید که کمتر از اندازه مد نظر نباشد. البته اگر دو لنگه باشه بهتره است.\r\n۷- راه پله ها : راه پله ها یکی از مهم ترین قسمت های ساختمان است و تمیز بودن آن بستگی به مصالحی دارد که در آن کار شده است.\r\nبرخی از ساختمان های بی کیفیت دیوار های راه پله را با گچ سفید می کنند . هر ساله باید هزینه ای را متحمل شوید که دیوار های راه پله را رنگ آمیزی کنید.\r\nاما در ساختمان های درجه کیفی بالا دیوار های راه پله را سنگ یا سرامیک می کنند . به صورت هفتگی یا ماهانه یا یک دستمال نم دار همه جا پاکیزه می شود.\r\nعرض راه پله و پاگرد ها مهم است تا در موقع اسباب کشی به مشکل بر نخورید.\r\n۸-تعدا واحد ها : در ساختمان هایی که تعداد واحد ها کمتر است سر و صدای کمتری را خواهید شنید.\r\nموقع دیدن ملک به تعدا هر واحد در طبقه و نزدیکی ورودی ها به یک دیگر دقت کنید.\r\n۹- حفظ حریم خصوصی : این موضوع برای ما ایرانی ها اهمیت بالایی دارد پس دقت کنیم درب ورودی واحد ها روبری هم نباشند.\r\n۱۰- پارکینگ خودرو : برخی ساختمان ها پارکینگ های اضافی علاوه بر مالک برای مهمان ها هم دارند.\r\nالبته مهم است پارکینگ سقف دارد یا در فضای باز و همچنین هرچه شیب ورودی پارکینگ کمتر باشد عبور و مرور راحت تر است.\r\n۱۱- کنتور گاز آب برق : حتما نوع کنتور ها را بپرسید که مشترک هستند یا انفرادی ؟\r\nاگر کنتور ها مشترک هستند از مشاور املاک روش محاسبه بهإ آب و گاز و برق را بپرسید و بدانید تا بعدا به مشکل بر نخورید.\r\n۱۲- پول شارژ ساختمان : این فکر اشتباه است که بگوییم هرچه شارژ کمتر باشد بهتر است.\r\nمبلغ شارژ ساختمان بستگی به عمر ساختمان دارد و باید با هزینه ها و نیاز های ساختمان همخوانی داشته باشد.\r\nساختمان های نوساز معمولا کم هزینه هستند و هواستان باشد اگر ساختمان کلنگی می خرید احتمال تحمیل هزینه تعمیرات بیشتر است.\r\n۱۳- کدام طبقه : اگر ساختمان آسانسور ندارد هواستان به پله نوردی روزانه باشد و طبقات اول را انتخاب کنید.\r\nو در صورتی که آسانسور دارد طبقات بالا انتخاب بهتری است تا آرامش را لمس کنید.\r\nنکته های داخل واحد مسکونی :\r\n۱۴- نورگیری واحد : یکی از مهمترین نکات در خرید خانه نورگیری خانه می باشد. خونه های شمالی نور گیری کمتری را نسبت به خانه های جنوبی دارند. و در این واحد ها لامپ های خانه شبانه روز باید روشن باشند.\r\nالبته نوع معماری و قرار گرفتن تعداد پنجره ها و پاسیو و تراس به دادن نور کافی به داخل واحد کمک می کند.\r\n۱۵- نوع گرمایش و سرمایش : اگر سیستم گرمایشی شوفاژ خانه مرکزی هستش حتما به موتورخانه سربزنید و از فرسوده نبودن تجهیزات موتوخانه اطمینان حاصل کنید.\r\nاما امروزه اکثر واحد ها پکیج دارند که فقط از سلامت آن مطمعن شوید.\r\nداشتن سیستم سرمایشی کولر گازی یک مزیت نیست بلکه به فکر قبض برق هم باشید.\r\nاگر سیستم سرمایشی کولر آبی هستش به پشت بام یه سر بزنید ببینید چیزی از کولر آبی باقی مونده یا پوسیده و فرسوده شده است.\r\n۱۶- معماری آشپزخانه : نکاتی که در آشپزخانه باید به آن دقت کنید یکی نور آن می باشد. داشتن پنجره خوب می تواند آرامش را به خانم ها بدهد.\r\nاز دیگر نکات مهم در آشپزخانه داشتن خروجی هود و قرار گیری مناسب مکان اتصالات مربوط به لباس شویی و آبگرکن یا پکیج و اجاق گاز و … می باشد. البته اگر آشپزخانه کابینت بندی شده به مکان یخچال ساید بای ساید هم یه نگاهی بندازید.\r\n۱۷- بالکن یا تراس خانه : داشتن بالکن بزرگ تر و با نور گیر کافی یک مزیت است. البته اگر به سمت آشپز خانه باشد در خانه داری به خانم خانه کمک بزرگی می کند.\r\n۱۸- دیوارپوش ها : اگر موقع خرید به نوع و سلامت دیوار پوش ها دقت کنید دیگر نیازی نیست که بعدا هزینه کنید.\r\n۱۹- حتما نوع کفپوش خانه و مزایای سایر کفپوش ها را از مشاور املاک سوال بپرسید تا بعدا به مشکل بر نخورید.\r\n۲۰- اگر نیت خرید خانه را داری حتما نوع سند و قدرالسهم آپارتمان و میزان مشاعات را از مشاور املاک بپرسید.\r\nدر پایان این که هیچ خانه ای را پیدا نمی کنید که همه این نکته ها را یک جا داشته باشد. پس شما باید درنظر بگیرید برخی از آیتم ها غیر قابل تغییر است مانند نورگیر بودن خانه\r\nاما برخی از این آیتم ها با انجام هزینه هایی قابل حل است مانند دیوارپوش و کف شوش و …\r\nدر نهایت باید از راهنمایی های یک مشاور املاک نهایت استفاده را ببرید.", "نکته های مهم موقع خرید خانه", "", "inherit", "closed", "closed", "", "232-revision-v1", "", "", "2022-05-22 00:17:42", "2022-05-21 19:47:42", "", "232", "https://sitralweb.com/ir3/?p=6368", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6367", "1", "2022-05-22 00:16:41", "2022-05-21 19:46:41", "با رعایت این نکته های مهم موقع خرید خانه شما با چشم باز خرید می کنید و در واقع مانند یک کارشناس ساختمان به ملک نگاه می کنید.\r\nاگر با این نگاه هوشمندانه ملکی را خرید کنید, هرگز از خرید خود پشیمان نمی شوید.\r\n۱_ همسایه ها : به همه ما ثابت شده است که داشتن همسایه های خوب از خوب بودن خود ملک مهم تر است.\r\nلازم است که قبل از خرید از وضعیت همسایگان اطلاع پیدا کنیم, چند دفعه به محل رفت و آمد کنید آمار کل محل دستتون میاد.\r\nیا می تونید از سوپری محل بپرسید.\r\nالبته موقع خرید آپارتمان از تمیز بودن راه پله ها و نبودن کفش و جا کفشی و لوازم شخصی تو راه پله میشه فهمید که چقدر با قوانین آپارتمان نشینی آشنا هستند و این قوانین رو رعایت می کنند.\r\n۲_ عرض کوچه : در محل های شلوغ اگر عرض کوچه کم باشه موقع رفت و آمد با خودرو به زحمت خواهید افتاد.\r\nتو یه کوچه باریک روز اول موقع اساس کشی شما خسته هستید و همسایه ها کلافه شدن , حالا فقط باید صبور باشید.\r\n۳_ سکوت و آرامش : معمولا خونه های نزدیک مدارس و اتوبان ها و بیمارستان ها ساختمان های اداری و تجاری روی سکوت و آرامش را نمی بینند. البته خونه هایی که مبحث ۱۹ رو رعایت کرده اند و از عایق های صوتی و حرارتی برای دیوارها و کف و سقف ساختمان استفاده کرده اند از این قاعده مستثنا هستند.\r\n۴_ امکانات رفاهی : فاصله یه خونه تا سوپرمارکت, مغازه های میوه فروشی , نانوایی و … مهم است . چرا که هر روز شما یا فرزند شما به زحمت کمتری بیوفتید.\r\n۵-امکانات حمل و نقلی : نزدیک بودن ملک به ایستگاه های تاکسی و اتوبوس مهم است چرا که در صورت نیاز زحمت کمتری را متحمل خواهید شد.\r\nاما اگر وسیله شخصی دارید دسترسی به اتوبان و خیابان اصلی را در اولویت قرار دهید.\r\nتوجه به وضعیت ساختمان\r\n۶- درب ورودی : عرض درب ورودی ساختمان و همچنین عرض ورودی واحد هم مهم است. شما باید به فکر رد کردن یخچال ساید بای ساید تون باشید.\r\nپس خجالت نداره عرض ورودی را متر کنید که کمتر از اندازه مد نظر نباشد. البته اگر دو لنگه باشه بهتره است.\r\n۷- راه پله ها : راه پله ها یکی از مهم ترین قسمت های ساختمان است و تمیز بودن آن بستگی به مصالحی دارد که در آن کار شده است.\r\nبرخی از ساختمان های بی کیفیت دیوار های راه پله را با گچ سفید می کنند . هر ساله باید هزینه ای را متحمل شوید که دیوار های راه پله را رنگ آمیزی کنید.\r\nاما در ساختمان های درجه کیفی بالا دیوار های راه پله را سنگ یا سرامیک می کنند . به صورت هفتگی یا ماهانه یا یک دستمال نم دار همه جا پاکیزه می شود.\r\nعرض راه پله و پاگرد ها مهم است تا در موقع اسباب کشی به مشکل بر نخورید.\r\n۸-تعدا واحد ها : در ساختمان هایی که تعداد واحد ها کمتر است سر و صدای کمتری را خواهید شنید.\r\nموقع دیدن ملک به تعدا هر واحد در طبقه و نزدیکی ورودی ها به یک دیگر دقت کنید.\r\n۹- حفظ حریم خصوصی : این موضوع برای ما ایرانی ها اهمیت بالایی دارد پس دقت کنیم درب ورودی واحد ها روبری هم نباشند.\r\n۱۰- پارکینگ خودرو : برخی ساختمان ها پارکینگ های اضافی علاوه بر مالک برای مهمان ها هم دارند.\r\nالبته مهم است پارکینگ سقف دارد یا در فضای باز و همچنین هرچه شیب ورودی پارکینگ کمتر باشد عبور و مرور راحت تر است.\r\n۱۱- کنتور گاز آب برق : حتما نوع کنتور ها را بپرسید که مشترک هستند یا انفرادی ؟\r\nاگر کنتور ها مشترک هستند از مشاور املاک روش محاسبه بهإ آب و گاز و برق را بپرسید و بدانید تا بعدا به مشکل بر نخورید.\r\n۱۲- پول شارژ ساختمان : این فکر اشتباه است که بگوییم هرچه شارژ کمتر باشد بهتر است.\r\nمبلغ شارژ ساختمان بستگی به عمر ساختمان دارد و باید با هزینه ها و نیاز های ساختمان همخوانی داشته باشد.\r\nساختمان های نوساز معمولا کم هزینه هستند و هواستان باشد اگر ساختمان کلنگی می خرید احتمال تحمیل هزینه تعمیرات بیشتر است.\r\n۱۳- کدام طبقه : اگر ساختمان آسانسور ندارد هواستان به پله نوردی روزانه باشد و طبقات اول را انتخاب کنید.\r\nو در صورتی که آسانسور دارد طبقات بالا انتخاب بهتری است تا آرامش را لمس کنید.\r\nنکته های داخل واحد مسکونی :\r\n۱۴- نورگیری واحد : یکی از مهمترین نکات در خرید خانه نورگیری خانه می باشد. خونه های شمالی نور گیری کمتری را نسبت به خانه های جنوبی دارند. و در این واحد ها لامپ های خانه شبانه روز باید روشن باشند.\r\nالبته نوع معماری و قرار گرفتن تعداد پنجره ها و پاسیو و تراس به دادن نور کافی به داخل واحد کمک می کند.\r\n۱۵- نوع گرمایش و سرمایش : اگر سیستم گرمایشی شوفاژ خانه مرکزی هستش حتما به موتورخانه سربزنید و از فرسوده نبودن تجهیزات موتوخانه اطمینان حاصل کنید.\r\nاما امروزه اکثر واحد ها پکیج دارند که فقط از سلامت آن مطمعن شوید.\r\nداشتن سیستم سرمایشی کولر گازی یک مزیت نیست بلکه به فکر قبض برق هم باشید.\r\nاگر سیستم سرمایشی کولر آبی هستش به پشت بام یه سر بزنید ببینید چیزی از کولر آبی باقی مونده یا پوسیده و فرسوده شده است.\r\n۱۶- معماری آشپزخانه : نکاتی که در آشپزخانه باید به آن دقت کنید یکی نور آن می باشد. داشتن پنجره خوب می تواند آرامش را به خانم ها بدهد.\r\nاز دیگر نکات مهم در آشپزخانه داشتن خروجی هود و قرار گیری مناسب مکان اتصالات مربوط به لباس شویی و آبگرکن یا پکیج و اجاق گاز و … می باشد. البته اگر آشپزخانه کابینت بندی شده به مکان یخچال ساید بای ساید هم یه نگاهی بندازید.\r\n۱۷- بالکن یا تراس خانه : داشتن بالکن بزرگ تر و با نور گیر کافی یک مزیت است. البته اگر به سمت آشپز خانه باشد در خانه داری به خانم خانه کمک بزرگی می کند.\r\n۱۸- دیوارپوش ها : اگر موقع خرید به نوع و سلامت دیوار پوش ها دقت کنید دیگر نیازی نیست که بعدا هزینه کنید.\r\n۱۹- حتما نوع کفپوش خانه و مزایای سایر کفپوش ها را از مشاور املاک سوال بپرسید تا بعدا به مشکل بر نخورید.\r\n۲۰- اگر نیت خرید خانه را داری حتما نوع سند و قدرالسهم آپارتمان و میزان مشاعات را از مشاور املاک بپرسید.\r\nدر پایان این که هیچ خانه ای را پیدا نمی کنید که همه این نکته ها را یک جا داشته باشد. پس شما باید درنظر بگیرید برخی از آیتم ها غیر قابل تغییر است مانند نورگیر بودن خانه\r\nاما برخی از این آیتم ها با انجام هزینه هایی قابل حل است مانند دیوارپوش و کف شوش و …\r\nدر نهایت باید از راهنمایی های یک مشاور املاک نهایت استفاده را ببرید.\r\n\r\n&nbsp;\r\n\r\n[wordpress_file_upload forceclassic=\"true\"]", "نکته های مهم موقع خرید خانه", "", "inherit", "closed", "closed", "", "232-revision-v1", "", "", "2022-05-22 00:16:41", "2022-05-21 19:46:41", "", "232", "https://sitralweb.com/ir3/?p=6367", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6405", "0", "2022-06-19 13:56:20", "0000-00-00 00:00:00", "", "۸۹۰کگ۹۰گک۰۹۸", "", "pending", "closed", "closed", "", "", "", "", "2022-06-19 13:56:20", "0000-00-00 00:00:00", "", "0", "https://sitralweb.com/ir3/?post_type=taghaza&p=6405", "0", "taghaza", "", "0");
INSERT INTO `wp_posts` VALUES("6140", "1", "2022-04-28 01:42:04", "2022-04-27 21:12:04", "<p style=\"float: right; display: block; width: 100%;\">شما میتوانید یک دسته بندی با لینک دلخاه با مشخصات دلخاه ایجاد نمایید به راحتی اب خوردن بدون هیچگونه دانش کد نویسی . سیترال وب در تلاش است بهترین ها را به ارمغان بیاورد .</p>\r\n<p style=\"float: right; display: block; width: 100%;\">توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .</p>\r\n\r\n[iranamlak mantaghe=\"1412\"]", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-04-28 01:42:04", "2022-04-27 21:12:04", "", "5496", "https://sitralweb.com/ir3/?p=6140", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6139", "1", "2022-04-28 01:26:00", "2022-04-27 20:56:00", "\r\n[iranamlak mantaghe=\"1412\"]\r\n\r\n<p style=\"float: right;display:block;width:100%\">شما میتوانید یک دسته بندی با لینک دلخاه با مشخصات دلخاه ایجاد نمایید به راحتی اب خوردن بدون هیچگونه دانش کد نویسی . سیترال وب در تلاش است بهترین ها را به ارمغان بیاورد .</p>\r\n<p style=\"float: right;display:block;width:100%\">توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .</p>", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-04-28 01:26:00", "2022-04-27 20:56:00", "", "5496", "https://sitralweb.com/ir3/?p=6139", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6141", "1", "2022-04-28 01:47:07", "2022-04-27 21:17:07", "[iranamlak mantaghe=\"1412\"]", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-04-28 01:47:07", "2022-04-27 21:17:07", "", "5496", "https://sitralweb.com/ir3/?p=6141", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6138", "1", "2022-04-28 01:25:09", "2022-04-27 20:55:09", "<p style=\"float: right;display:block;width:100%\">شما میتوانید یک دسته بندی با لینک دلخاه با مشخصات دلخاه ایجاد نمایید به راحتی اب خوردن بدون هیچگونه دانش کد نویسی . سیترال وب در تلاش است بهترین ها را به ارمغان بیاورد .</p>\r\n<p style=\"float: right;display:block;width:100%\">توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .</p>\r\n\r\n\r\n[iranamlak mantaghe=\"1412\"]", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-04-28 01:25:09", "2022-04-27 20:55:09", "", "5496", "https://sitralweb.com/ir3/?p=6138", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("4895", "2", "2021-06-26 15:03:28", "2021-06-26 10:33:28", "", "vila2", "", "inherit", "open", "closed", "", "vila2", "", "", "2021-06-26 15:03:28", "2021-06-26 10:33:28", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/06/vila2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4896", "2", "2021-06-26 15:03:30", "2021-06-26 10:33:30", "", "vila3", "", "inherit", "open", "closed", "", "vila3-2", "", "", "2021-06-26 15:03:30", "2021-06-26 10:33:30", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/06/vila3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4898", "1", "2021-06-28 22:52:27", "2021-06-28 18:22:27", "", "Order &ndash; تیر ۷, ۱۴۰۰ @ ۱۰:۵۲ بعد از ظهر", "", "wc-cancelled", "open", "closed", "wc_order_OZQglsbXkdOkw", "%d8%b3%d9%81%d8%a7%d8%b1%d8%b4-%da%98%d9%88%d8%a6%d9%86-28-2021-0622", "", "", "2021-06-29 00:06:42", "2021-06-28 19:36:42", "", "0", "https://sitralweb.com/ir3/?post_type=shop_order&#038;p=4898", "0", "shop_order", "", "2");
INSERT INTO `wp_posts` VALUES("5782", "1", "2022-04-06 15:39:05", "2022-04-06 11:09:05", "&nbsp;\r\n\r\n&nbsp;\r\n\r\nجهت دریافت اطلاعات بیشتر با مشاورین املاک ایران املاک تماس حاصل فرمایید ...\r\n\r\n09123456789\r\n\r\n01234567890\r\n\r\ninfo@test.com\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nو یا همچنین میتوانید از فرم روبرو جهت ارسال هرگونه نظرات و یا انتقادات خود استفاده نمایید .\r\n\r\nهمکاران ما در اسرع وقت با شما در ارتباط خواهد بود ...", "ارتباط با ما", "", "inherit", "closed", "closed", "", "17-revision-v1", "", "", "2022-04-06 15:39:05", "2022-04-06 11:09:05", "", "17", "https://sitralweb.com/ir3/?p=5782", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("4887", "1", "2021-06-25 14:24:07", "2021-06-25 09:54:07", "&nbsp;\r\n\r\nآیا در وب سایت ایران املاک اقدام به جستجو نمودید و همچنان ملک مورد نظر خود را نیافته اید ؟\r\n\r\n&nbsp;\r\n\r\nکافیست فرم فرم ذیل را برای کارشناسان ما ارسال نمایید تا در اولین فرصتی که ملکی با مشخصات مد نظر شما در فایلینگ ما قرار گرفت به شما اطلاع رسانی شود .\r\n\r\n&nbsp;\r\n\r\nبا ایران املاک بهترین ها را تجربه خواهید نمود ...\r\n\r\n&nbsp;\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید با شماره هی تماس ما در بالا و پایین وب سایت ما تماس حاصل نمایید ..\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-2845 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png\" sizes=\"(max-width: 300px) 100vw, 300px\" srcset=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png 300w, https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb.png 395w\" alt=\"\" width=\"300\" height=\"148\" />\r\n\r\n&nbsp;", "تقاضای ملک", "", "inherit", "closed", "closed", "", "4883-revision-v1", "", "", "2021-06-25 14:24:07", "2021-06-25 09:54:07", "", "4883", "https://sitralweb.com/ir3/4883-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("4886", "1", "2021-06-25 14:23:08", "2021-06-25 09:53:08", "&nbsp;\r\n\r\nآیا در وب سایت ایران املاک اقدام به جستجو نمودید و همچنان ملک مورد نظر خود را نیافته اید ؟\r\n\r\nکافیست فرم فرم ذیل را برای کارشناسان ما ارسال نمایید تا در اولین فرصتی که ملکی با مشخصات مد نظر شما در فایلینگ ما قرار گرفت به شما اطلاع رسانی شود .\r\n\r\n&nbsp;\r\n\r\nبا ایران املاک بهترین ها را تجربه خواهید نمود ...\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید با شماره هی تماس ما در بالا و پایین وب سایت ما تماس حاصل نمایید ..\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-2845 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png\" sizes=\"(max-width: 300px) 100vw, 300px\" srcset=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png 300w, https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb.png 395w\" alt=\"\" width=\"300\" height=\"148\" />\r\n\r\n&nbsp;", "تقاضای ملک", "", "inherit", "closed", "closed", "", "4883-revision-v1", "", "", "2021-06-25 14:23:08", "2021-06-25 09:53:08", "", "4883", "https://sitralweb.com/ir3/4883-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("4885", "1", "2021-06-25 14:20:40", "2021-06-25 09:50:40", "&nbsp;\r\n\r\nآیا در وب سایت ایران املاک اقدام به جستجو نمودید و همچنان ملک مورد نظر خود را نیافته اید ؟\r\n\r\nکافیست فرم فرم ذیل را برای کارشناسان ما ارسال نمایید تا در اولین فرصتی که ملکی با مشخصات مد نظر شما در فایلینگ ما قرار گرفت به شما اطلاع رسانی شود .\r\n\r\n&nbsp;\r\n\r\nبا ایران املاک بهترین ها را تجربه خواهید نمود ...\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید با شماره هی تماس ما در بالا و پایین وب سایت ما تماس حاصل نمایید ..\r\n\r\n&nbsp;\r\n\r\n<img class=\"wp-image-2841 size-full aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me.png\" sizes=\"(max-width: 600px) 100vw, 600px\" srcset=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me.png 600w, https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me-300x300.png 300w, https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak-me-150x150.png 150w\" alt=\"\" width=\"600\" height=\"600\" />\r\n\r\n&nbsp;", "تقاضای ملک", "", "inherit", "closed", "closed", "", "4883-revision-v1", "", "", "2021-06-25 14:20:40", "2021-06-25 09:50:40", "", "4883", "https://sitralweb.com/ir3/4883-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6136", "1", "2022-04-28 01:23:35", "2022-04-27 20:53:35", "<p style=\"text-align: right;\">شما میتوانید یک دسته بندی با لینک دلخاه با مشخصات دلخاه ایجاد نمایید به راحتی اب خوردن بدون هیچگونه دانش کد نویسی . سیترال وب در تلاش است بهترین ها را به ارمغان بیاورد .</p>\r\n<p style=\"text-align: right;\">توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .\r\n\r\n[iranamlak mantaghe=\"1412\"]</p>", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-04-28 01:23:35", "2022-04-27 20:53:35", "", "5496", "https://sitralweb.com/ir3/?p=6136", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("4884", "1", "2021-06-25 14:18:44", "2021-06-25 09:48:44", "&nbsp;\r\n\r\nآیا در وب سایت ایران املاک اقدام به جستجو نمودید و همچنان ملک مورد نظر خود را نیافته اید ؟\r\n\r\nکافیست فرم فرم ذیل را برای کارشناسان ما ارسال نمایید تا در اولین فرصتی که ملکی با مشخصات مد نظر شما در فایلینگ ما قرار گرفت به شما اطلاع رسانی شود .\r\n\r\n&nbsp;\r\n\r\nبا ایران املاک بهترین ها را تجربه خواهید نمود ...\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید با شماره هی تماس ما در بالا و پایین وب سایت ما تماس حاصل نمایید ..\r\n\r\n&nbsp;\r\n\r\nتشکر\r\n\r\n&nbsp;", "تقاضای ملک", "", "inherit", "closed", "closed", "", "4883-revision-v1", "", "", "2021-06-25 14:18:44", "2021-06-25 09:48:44", "", "4883", "https://sitralweb.com/ir3/4883-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6135", "1", "2022-04-28 01:22:37", "2022-04-27 20:52:37", "شما میتوانید یک دسته بندی با لینک دلخاه با مشخصات دلخاه ایجاد نمایید به راحتی اب خوردن بدون هیچگونه دانش کد نویسی . سیترال وب در تلاش است بهترین ها را به ارمغان بیاورد .\r\n\r\nتوضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد . توضیحات من در اینجا قرار میگیرد .\r\n\r\n[iranamlak mantaghe=\"1412\"]", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-04-28 01:22:37", "2022-04-27 20:52:37", "", "5496", "https://sitralweb.com/ir3/?p=6135", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6407", "1", "2022-06-24 22:12:00", "2022-06-24 17:42:00", "<p>[iranamlak numstates=\"20\" style_query_shortcode=\"style1\" mantaghe=\"1412\"]</p>", "همه آگهی های منطقه دو تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-06-24 22:12:00", "2022-06-24 17:42:00", "", "5496", "https://sitralweb.com/ir3/?p=6407", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6144", "1", "2022-04-28 01:54:47", "2022-04-27 21:24:47", "<!-- wp:paragraph -->\n<p>تست جدید </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:shortcode -->\n[iranamlak mantaghe=\"1412\"]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p>تست بلوک جدید</p>\n<!-- /wp:paragraph -->", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-revision-v1", "", "", "2022-04-28 01:54:47", "2022-04-27 21:24:47", "", "5496", "https://sitralweb.com/ir3/?p=6144", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("4883", "1", "2021-06-25 14:18:44", "2021-06-25 09:48:44", "&nbsp;\r\n\r\nآیا در وب سایت ایران املاک اقدام به جستجو نمودید و همچنان ملک مورد نظر خود را نیافته اید ؟\r\n\r\n&nbsp;\r\n\r\nکافیست فرم فرم ذیل را برای کارشناسان ما ارسال نمایید تا در اولین فرصتی که ملکی با مشخصات مد نظر شما در فایلینگ ما قرار گرفت به شما اطلاع رسانی شود .\r\n\r\n&nbsp;\r\n\r\nبا ایران املاک بهترین ها را تجربه خواهید نمود ...\r\n\r\n&nbsp;\r\n\r\nجهت دریافت اطلاعات بیشتر میتوانید با شماره هی تماس ما در بالا و پایین وب سایت ما تماس حاصل نمایید ..\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-2845 aligncenter\" src=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png\" sizes=\"(max-width: 300px) 100vw, 300px\" srcset=\"https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb-300x148.png 300w, https://sitralweb.com/ir3/wp-content/uploads/2020/08/iranamlak2-sitralweb.png 395w\" alt=\"\" width=\"300\" height=\"148\" />\r\n\r\n&nbsp;", "تقاضای ملک", "", "publish", "closed", "closed", "", "%d8%aa%d9%82%d8%a7%d8%b6%d8%a7%db%8c-%d9%85%d9%84%da%a9", "", "", "2022-04-06 00:06:48", "2022-04-05 19:36:48", "", "0", "https://sitralweb.com/ir3/?page_id=4883", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6132", "1", "2022-04-28 01:21:36", "2022-04-27 20:51:36", "[iranamlak moamele=\"رهن و اجاره\"]", "همه ملک های اجاره ای", "", "inherit", "closed", "closed", "", "5507-revision-v1", "", "", "2022-04-28 01:21:36", "2022-04-27 20:51:36", "", "5507", "https://sitralweb.com/ir3/?p=6132", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6133", "1", "2022-04-28 01:22:03", "2022-04-27 20:52:03", "[iranamlak mantaghe=\"1386\"]", "همه ملک های رامسر", "", "inherit", "closed", "closed", "", "5505-revision-v1", "", "", "2022-04-28 01:22:03", "2022-04-27 20:52:03", "", "5505", "https://sitralweb.com/ir3/?p=6133", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6130", "1", "2022-04-28 01:21:11", "2022-04-27 20:51:11", "[iranamlak moamele=\"خرید و فروش\" moaveze=\"1\"]", "همه معاوضه ها", "", "inherit", "closed", "closed", "", "5502-autosave-v1", "", "", "2022-04-28 01:21:11", "2022-04-27 20:51:11", "", "5502", "https://sitralweb.com/ir3/?p=6130", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6131", "1", "2022-04-28 01:21:13", "2022-04-27 20:51:13", "[iranamlak moamele=\"خرید و فروش\" moaveze=\"1\"]", "همه معاوضه ها", "", "inherit", "closed", "closed", "", "5502-revision-v1", "", "", "2022-04-28 01:21:13", "2022-04-27 20:51:13", "", "5502", "https://sitralweb.com/ir3/?p=6131", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6127", "1", "2022-04-28 01:20:25", "2022-04-27 20:50:25", "[iranamlak moamele=\"خرید و فروش\" pishforosh=\"1\"]", "همه پیشفروش ها", "", "inherit", "closed", "closed", "", "5511-revision-v1", "", "", "2022-04-28 01:20:25", "2022-04-27 20:50:25", "", "5511", "https://sitralweb.com/ir3/?p=6127", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6118", "1", "2022-04-26 13:45:52", "2022-04-26 09:15:52", "", "backsearch", "", "inherit", "open", "closed", "", "backsearch", "", "", "2022-04-26 13:45:52", "2022-04-26 09:15:52", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/04/backsearch.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4714", "1", "2021-05-01 19:18:20", "2021-05-01 14:48:20", "تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .", "محصول دوم یک محصول ویژه", "تست توضیحات کوتاه محصول در اینجا قرار میگیرد .تست توضیحات کوتاه محصول در اینجا قرار میگیرد . تست توضیحات کوتاه محصول در اینجا قرار میگیرد . تست توضیحات کوتاه محصول در اینجا قرار میگیرد .", "publish", "closed", "closed", "", "%d9%85%d8%ad%d8%b5%d9%88%d9%84-%d8%af%d9%88%d9%85-%db%8c%da%a9-%d9%85%d8%ad%d8%b5%d9%88%d9%84-%d9%88%db%8c%da%98%d9%87", "", "", "2021-05-01 19:19:15", "2021-05-01 14:49:15", "", "0", "https://sitralweb.com/ir3/?post_type=product&#038;p=4714", "0", "product", "", "0");
INSERT INTO `wp_posts` VALUES("4678", "1", "2021-04-05 09:52:16", "2021-04-05 05:22:16", "", "apartment4", "", "inherit", "open", "closed", "", "apartment4", "", "", "2021-04-05 09:52:16", "2021-04-05 05:22:16", "", "300", "https://sitralweb.com/ir3/wp-content/uploads/2020/05/apartment4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4679", "1", "2021-04-05 09:56:40", "2021-04-05 05:26:40", "", "apartment5", "", "inherit", "open", "closed", "", "apartment5", "", "", "2022-04-26 10:31:58", "2022-04-26 06:01:58", "", "303", "https://sitralweb.com/ir3/wp-content/uploads/2020/04/apartment5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4680", "1", "2021-04-05 09:56:43", "2021-04-05 05:26:43", "", "apartment6", "", "inherit", "open", "closed", "", "apartment6", "", "", "2022-04-26 10:48:33", "2022-04-26 06:18:33", "", "303", "https://sitralweb.com/ir3/wp-content/uploads/2020/04/apartment6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4681", "1", "2021-04-05 10:10:00", "2021-04-05 05:40:00", "", "vila5", "", "inherit", "open", "closed", "", "vila5", "", "", "2022-03-02 21:45:59", "2022-03-02 18:15:59", "", "294", "https://sitralweb.com/ir3/wp-content/uploads/2020/04/vila5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4677", "1", "2021-04-05 09:52:11", "2021-04-05 05:22:11", "", "apartment3", "", "inherit", "open", "closed", "", "apartment3", "", "", "2021-04-05 09:52:11", "2021-04-05 05:22:11", "", "300", "https://sitralweb.com/ir3/wp-content/uploads/2020/05/apartment3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4702", "1", "2021-04-30 12:56:00", "2021-04-30 08:26:00", "", "Order &ndash; اردیبهشت ۱۰, ۱۴۰۰ @ ۱۲:۵۷ بعد از ظهر", "", "wc-completed", "closed", "closed", "", "", "", "", "2021-04-30 12:57:33", "2021-04-30 08:27:33", "", "0", "https://sitralweb.com/ir3/?post_type=shop_order&#038;p=4702", "0", "shop_order", "", "2");
INSERT INTO `wp_posts` VALUES("4703", "1", "2021-04-30 12:58:00", "2021-04-30 08:28:00", "", "Order &ndash; اردیبهشت ۱۰, ۱۴۰۰ @ ۱۲:۵۹ بعد از ظهر", "", "wc-completed", "closed", "closed", "", "", "", "", "2021-04-30 12:59:49", "2021-04-30 08:29:49", "", "0", "https://sitralweb.com/ir3/?post_type=shop_order&#038;p=4703", "0", "shop_order", "", "2");
INSERT INTO `wp_posts` VALUES("4706", "1", "2021-05-01 11:16:24", "2021-05-01 06:46:24", "تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .\r\n\r\nتست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .تست توضیحات اصلی محصول در اینجا قرار میگیرد .", "محصول تستی من", "تست توضیحات کوتاه محصول در اینجا قرار میگیرد .تست توضیحات کوتاه محصول در اینجا قرار میگیرد . تست توضیحات کوتاه محصول در اینجا قرار میگیرد . تست توضیحات کوتاه محصول در اینجا قرار میگیرد .", "publish", "closed", "closed", "", "%d9%85%d8%ad%d8%b5%d9%88%d9%84-%d8%aa%d8%b3%d8%aa%db%8c-%d9%85%d9%86", "", "", "2021-05-01 19:16:20", "2021-05-01 14:46:20", "", "0", "https://sitralweb.com/ir3/?post_type=product&#038;p=4706", "0", "product", "", "0");
INSERT INTO `wp_posts` VALUES("5279", "1", "2022-02-06 16:34:17", "2022-02-06 13:04:17", "", "avatar_all", "", "inherit", "open", "closed", "", "avatar_all", "", "", "2022-04-26 10:17:04", "2022-04-26 05:47:04", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/02/avatar_all.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("4712", "1", "2021-05-01 15:44:03", "2021-05-01 11:14:03", "", "Order &ndash; اردیبهشت ۱۱, ۱۴۰۰ @ ۰۳:۴۴ بعد از ظهر", "", "wc-cancelled", "open", "closed", "wc_order_PpfYbvySurIki", "%d8%b3%d9%81%d8%a7%d8%b1%d8%b4-01-%d9%85%d9%87-2021-%d8%af%d8%b1-1114", "", "", "2021-05-01 18:03:22", "2021-05-01 13:33:22", "", "0", "https://sitralweb.com/ir3/?post_type=shop_order&#038;p=4712", "0", "shop_order", "", "3");
INSERT INTO `wp_posts` VALUES("4565", "1", "2021-03-20 12:29:25", "2021-03-20 08:59:25", "", "Default Kit", "", "publish", "closed", "closed", "", "default-kit", "", "", "2021-03-20 12:29:25", "2021-03-20 08:59:25", "", "0", "https://sitralweb.com/ir3/?elementor_library=default-kit", "0", "elementor_library", "", "0");
INSERT INTO `wp_posts` VALUES("4564", "1", "2021-03-20 12:34:38", "0000-00-00 00:00:00", "", "home - 1", "", "draft", "closed", "closed", "", "", "", "", "2021-03-20 12:34:38", "2021-03-20 09:04:38", "", "0", "https://sitralweb.com/ir3/?post_type=elementor_library&#038;p=4564", "0", "elementor_library", "", "0");
INSERT INTO `wp_posts` VALUES("2834", "2", "2020-07-26 14:11:17", "2020-07-26 09:41:17", "", "829", "", "inherit", "open", "closed", "", "829", "", "", "2020-07-26 14:11:17", "2020-07-26 09:41:17", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/07/829.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("2849", "1", "2020-08-08 16:58:25", "2020-08-08 12:28:25", "", "C24rZucWgAAMGV6", "", "inherit", "open", "closed", "", "c24rzucwgaamgv6", "", "", "2020-08-08 16:58:25", "2020-08-08 12:28:25", "", "7", "https://sitralweb.com/ir3/wp-content/uploads/2020/05/C24rZucWgAAMGV6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("3105", "2", "2020-08-12 10:56:49", "2020-08-12 06:26:49", "", "WhatsApp Image 2020-04-17 at 2.46.55 AM", "", "inherit", "open", "closed", "", "whatsapp-image-2020-04-17-at-2-46-55-am", "", "", "2020-08-12 10:56:49", "2020-08-12 06:26:49", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/08/WhatsApp-Image-2020-04-17-at-2.46.55-AM.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4240", "1", "2020-12-17 21:18:34", "2020-12-17 17:48:34", "", "iranamlak", "", "inherit", "open", "closed", "", "iranamlak", "", "", "2020-12-17 21:18:34", "2020-12-17 17:48:34", "", "303", "https://sitralweb.com/ir3/wp-content/uploads/2020/04/iranamlak.mp4", "0", "attachment", "video/mp4", "0");
INSERT INTO `wp_posts` VALUES("3244", "2", "2020-09-26 16:35:50", "2020-09-26 13:05:50", "", "13-Reasons-Why", "", "inherit", "open", "closed", "", "13-reasons-why", "", "", "2020-09-26 16:35:50", "2020-09-26 13:05:50", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/09/13-Reasons-Why.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("3113", "2", "2020-09-09 23:53:45", "2020-09-09 19:23:45", "", "IMG_20200822_191101", "", "inherit", "open", "closed", "", "img_20200822_191101", "", "", "2020-09-09 23:53:45", "2020-09-09 19:23:45", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/09/IMG_20200822_191101.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("3971", "26", "2020-12-08 09:46:06", "2020-12-08 06:16:06", "", "2", "", "inherit", "open", "closed", "", "2", "", "", "2020-12-08 09:46:06", "2020-12-08 06:16:06", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/12/2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4378", "2", "2021-01-19 10:14:54", "2021-01-19 06:44:54", "", "WhatsApp Image 2021-01-18 at 12.07.41", "", "inherit", "open", "closed", "", "whatsapp-image-2021-01-18-at-12-07-41", "", "", "2021-01-19 10:14:54", "2021-01-19 06:44:54", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/01/WhatsApp-Image-2021-01-18-at-12.07.41.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4687", "1", "2022-02-12 09:56:37", "2022-02-12 09:56:37", "فول امکانات", "آپارتمان 150 متری", "", "unpaid", "closed", "closed", "", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86-150-%d9%85%d8%aa%d8%b1%db%8c", "", "", "2022-04-26 10:39:48", "2022-04-26 06:09:48", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=4687", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("4381", "1", "2021-02-10 17:32:45", "2021-02-10 14:02:45", "", "یک ماهه کاربر عادی", "", "publish", "closed", "closed", "", "%db%8c%da%a9-%d9%85%d8%a7%d9%87%d9%87-%da%a9%d8%a7%d8%b1%d8%a8%d8%b1-%d8%b9%d8%a7%d8%af%db%8c", "", "", "2021-02-10 19:37:25", "2021-02-10 16:07:25", "", "0", "https://sitralweb.com/ir3/?post_type=package&#038;p=4381", "0", "package", "", "0");
INSERT INTO `wp_posts` VALUES("2288", "1", "2021-05-26 18:07:39", "2021-05-26 13:37:39", "اجاره منزل استخر دار در کیش در خیابان کیشیان ، با قیمت عالی جهت اطلاعات بیشتر تماس بگیرید ...", "اجاره ویلایی در کیش", "", "pending", "open", "closed", "", "%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d9%88%db%8c%d9%84%d8%a7%db%8c%db%8c-%d8%af%d8%b1-%da%a9%db%8c%d8%b4", "", "", "2023-01-08 23:42:06", "2023-01-08 20:12:06", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=2288", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("2569", "2", "2020-06-28 20:31:50", "2020-06-28 16:01:50", "", "رسید خرید مودم از ایرانسل", "", "inherit", "open", "closed", "", "%d8%b1%d8%b3%db%8c%d8%af-%d8%ae%d8%b1%db%8c%d8%af-%d9%85%d9%88%d8%af%d9%85-%d8%a7%d8%b2-%d8%a7%db%8c%d8%b1%d8%a7%d9%86%d8%b3%d9%84", "", "", "2020-06-28 20:31:50", "2020-06-28 16:01:50", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/06/رسید-خرید-مودم-از-ایرانسل.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("6408", "1", "2022-06-24 22:18:56", "2022-06-24 17:48:56", "[iranamlak numstates=\"20\" style_query_shortcode=\"style2\"]", "نمایش آگهی ها به سبک دو", "", "inherit", "closed", "closed", "", "5507-autosave-v1", "", "", "2022-06-24 22:18:56", "2022-06-24 17:48:56", "", "5507", "https://sitralweb.com/ir3/?p=6408", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6409", "1", "2022-06-24 22:13:40", "2022-06-24 17:43:40", "[iranamlak numstates=\"20\" style_query_shortcode=\"style2\"]", "نمایش آگهی ها به سبک دو", "", "inherit", "closed", "closed", "", "5507-revision-v1", "", "", "2022-06-24 22:13:40", "2022-06-24 17:43:40", "", "5507", "https://sitralweb.com/ir3/?p=6409", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6403", "1", "2022-06-13 16:48:58", "2022-06-13 12:18:58", "", "آگهی های من", "", "inherit", "closed", "closed", "", "6402-revision-v1", "", "", "2022-06-13 16:48:58", "2022-06-13 12:18:58", "", "6402", "https://sitralweb.com/ir3/?p=6403", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6402", "1", "2022-06-13 16:48:58", "2022-06-13 12:18:58", "", "آگهی های من", "", "publish", "closed", "closed", "", "%d9%81%d8%a7%db%8c%d9%84%db%8c%d9%86%da%af-%d9%85%d9%86", "", "", "2022-06-13 16:48:58", "2022-06-13 12:18:58", "", "0", "https://sitralweb.com/ir3/?page_id=6402", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6505", "1", "2023-06-02 17:44:24", "2023-06-02 14:14:24", "", "کارمندان", "", "publish", "closed", "closed", "", "%da%a9%d8%a7%d8%b1%d9%85%d9%86%d8%af%d8%a7%d9%86", "", "", "2023-06-02 17:44:24", "2023-06-02 14:14:24", "", "0", "https://sitralweb.com/ir3/?page_id=6505", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6506", "1", "2023-06-02 17:44:24", "2023-06-02 14:14:24", "", "کارمندان", "", "inherit", "closed", "closed", "", "6505-revision-v1", "", "", "2023-06-02 17:44:24", "2023-06-02 14:14:24", "", "6505", "https://sitralweb.com/ir3/?p=6506", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6507", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", "", "آگهی ها", "", "publish", "closed", "closed", "", "%d8%a2%da%af%d9%87%db%8c-%d9%87%d8%a7", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6507", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6508", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", "", "به تفکیک منطقه", "", "publish", "closed", "closed", "", "%d8%a8%d9%87-%d8%aa%d9%81%da%a9%db%8c%da%a9-%d9%85%d9%86%d8%b7%d9%82%d9%87", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6508", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6509", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", " ", "", "", "publish", "closed", "closed", "", "6509", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6509", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6510", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", " ", "", "", "publish", "closed", "closed", "", "6510", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "1422", "https://sitralweb.com/ir3/?p=6510", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6511", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", " ", "", "", "publish", "closed", "closed", "", "6511", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "1422", "https://sitralweb.com/ir3/?p=6511", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6512", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", " ", "", "", "publish", "closed", "closed", "", "6512", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6512", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6513", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", " ", "", "", "publish", "closed", "closed", "", "6513", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "1412", "https://sitralweb.com/ir3/?p=6513", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6514", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", " ", "", "", "publish", "closed", "closed", "", "6514", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "1412", "https://sitralweb.com/ir3/?p=6514", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6515", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", "", "نوع ملک", "", "publish", "closed", "closed", "", "%d9%86%d9%88%d8%b9-%d9%85%d9%84%da%a9", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6515", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6516", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", "", "آپارتمان", "", "publish", "closed", "closed", "", "%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6516", "11", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6517", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", "", "خانه و ویلا", "", "publish", "closed", "closed", "", "%d8%ae%d8%a7%d9%86%d9%87-%d9%88-%d9%88%db%8c%d9%84%d8%a7", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6517", "12", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6518", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", "", "اداری و تجاری", "", "publish", "closed", "closed", "", "%d8%a7%d8%af%d8%a7%d8%b1%db%8c-%d9%88-%d8%aa%d8%ac%d8%a7%d8%b1%db%8c", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6518", "13", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6519", "1", "2023-06-02 17:56:54", "2023-06-02 14:21:22", "", "زمین و کلنگی", "", "publish", "closed", "closed", "", "%d8%b2%d9%85%db%8c%d9%86-%d9%88-%da%a9%d9%84%d9%86%da%af%db%8c", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6519", "14", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6128", "1", "2022-04-28 01:20:46", "2022-04-27 20:50:46", "[iranamlak moamele=\"خرید و فروش\" mosharekat=\"1\"]", "همه مشارکت در ساخت ها", "", "inherit", "closed", "closed", "", "5509-autosave-v1", "", "", "2022-04-28 01:20:46", "2022-04-27 20:50:46", "", "5509", "https://sitralweb.com/ir3/?p=6128", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6129", "1", "2022-04-28 01:20:52", "2022-04-27 20:50:52", "[iranamlak moamele=\"خرید و فروش\" mosharekat=\"1\"]", "همه مشارکت در ساخت ها", "", "inherit", "closed", "closed", "", "5509-revision-v1", "", "", "2022-04-28 01:20:52", "2022-04-27 20:50:52", "", "5509", "https://sitralweb.com/ir3/?p=6129", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6521", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", " ", "", "", "publish", "closed", "closed", "", "6521", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6521", "33", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("6522", "1", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "نوع معامله", "", "publish", "closed", "closed", "", "%d9%86%d9%88%d8%b9-%d9%85%d8%b9%d8%a7%d9%85%d9%84%d9%87", "", "", "2023-06-02 17:56:54", "2023-06-02 14:26:54", "", "0", "https://sitralweb.com/ir3/?p=6522", "15", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("3573", "26", "2020-12-03 15:48:20", "2020-12-03 12:18:20", "", "5988_857256826b5cfaded8af65751", "", "inherit", "open", "closed", "", "5988_857256826b5cfaded8af65751", "", "", "2020-12-03 15:48:20", "2020-12-03 12:18:20", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2020/12/5988_857256826b5cfaded8af65751.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("5079", "2", "2021-08-13 18:52:20", "2021-08-13 14:22:20", "", "d6ccjb3shpm6", "", "inherit", "open", "closed", "", "d6ccjb3shpm6", "", "", "2021-08-13 18:52:20", "2021-08-13 14:22:20", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/08/d6ccjb3shpm6.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("5080", "2", "2021-08-13 18:52:21", "2021-08-13 14:22:21", "", "WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024", "", "inherit", "open", "closed", "", "whatsapp-image-2020-01-29-at-5-44-49-pm-768x1024", "", "", "2021-08-13 18:52:21", "2021-08-13 14:22:21", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/08/WhatsApp-Image-2020-01-29-at-5.44.49-PM-768x1024-1.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("5081", "2", "2021-08-13 18:52:23", "2021-08-13 14:22:23", "", "انحصار+وراثت", "", "inherit", "open", "closed", "", "%d8%a7%d9%86%d8%ad%d8%b5%d8%a7%d8%b1%d9%88%d8%b1%d8%a7%d8%ab%d8%aa", "", "", "2022-05-26 09:43:06", "2022-05-26 05:13:06", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/08/انحصاروراثت.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("5082", "2", "2021-08-13 18:52:24", "2021-08-13 14:22:24", "", "کد-رهگیری-معاملات-ملکی", "", "inherit", "open", "closed", "", "%da%a9%d8%af-%d8%b1%d9%87%da%af%db%8c%d8%b1%db%8c-%d9%85%d8%b9%d8%a7%d9%85%d9%84%d8%a7%d8%aa-%d9%85%d9%84%da%a9%db%8c", "", "", "2021-08-13 18:52:24", "2021-08-13 14:22:24", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/08/کد-رهگیری-معاملات-ملکی.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4734", "2", "2021-06-15 11:56:17", "2021-06-15 07:26:17", "", "Vector pop art illustration of a man and a woman sitting at a negotiation table top view", "Vector pop art illustration of a man and a woman sitting at a negotiation table top view, concept of brainstorming", "inherit", "open", "closed", "", "vector-pop-art-illustration-of-a-man-and-a-woman-sitting-at-a-negotiation-table-top-view", "", "", "2021-06-15 11:56:17", "2021-06-15 07:26:17", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/06/596.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("5078", "2", "2021-08-13 18:52:17", "2021-08-13 14:22:17", "", "202003261807_1", "", "inherit", "open", "closed", "", "202003261807_1", "", "", "2021-08-13 18:52:17", "2021-08-13 14:22:17", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2021/08/202003261807_1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("4900", "1", "2021-07-01 13:06:42", "2021-07-01 08:36:42", "", "Order &ndash; تیر ۱۰, ۱۴۰۰ @ ۰۱:۰۶ بعد از ظهر", "", "wc-cancelled", "open", "closed", "wc_order_AkUADoCuvdH3X", "%d8%b3%d9%81%d8%a7%d8%b1%d8%b4-%da%98%d9%88%d8%a6%db%8c%d9%87-01-2021-0836", "", "", "2021-07-01 14:35:30", "2021-07-01 10:05:30", "", "0", "https://sitralweb.com/ir3/?post_type=shop_order&#038;p=4900", "0", "shop_order", "", "2");
INSERT INTO `wp_posts` VALUES("4901", "1", "2021-07-01 13:32:51", "2021-07-01 09:02:51", "", "Order &ndash; تیر ۱۰, ۱۴۰۰ @ ۰۱:۳۲ بعد از ظهر", "", "wc-cancelled", "open", "closed", "wc_order_w8034GPX7gKli", "%d8%b3%d9%81%d8%a7%d8%b1%d8%b4-%da%98%d9%88%d8%a6%db%8c%d9%87-01-2021-0902", "", "", "2021-07-01 14:35:30", "2021-07-01 10:05:30", "", "0", "https://sitralweb.com/ir3/?post_type=shop_order&#038;p=4901", "0", "shop_order", "", "2");
INSERT INTO `wp_posts` VALUES("6452", "2", "2022-08-07 11:29:09", "2022-08-07 06:59:09", "", "garden-tower-plan", "", "inherit", "open", "closed", "", "garden-tower-plan", "", "", "2022-12-17 08:09:09", "2022-12-17 04:39:09", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/08/garden-tower-plan.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6465", "0", "2022-10-08 18:04:58", "0000-00-00 00:00:00", "", "سلام تست میشه", "", "pending", "closed", "closed", "", "", "", "", "2022-10-08 18:04:58", "0000-00-00 00:00:00", "", "0", "https://sitralweb.com/ir3/?post_type=payam&p=6465", "0", "payam", "", "0");
INSERT INTO `wp_posts` VALUES("6450", "0", "2022-08-05 01:15:50", "0000-00-00 00:00:00", "", "rhfdbxv 784512", "", "pending", "closed", "closed", "", "", "", "", "2022-08-05 01:15:50", "0000-00-00 00:00:00", "", "0", "https://sitralweb.com/ir3/?post_type=taghaza&p=6450", "0", "taghaza", "", "0");
INSERT INTO `wp_posts` VALUES("6439", "1", "2022-07-24 19:10:51", "2022-07-24 14:40:51", "", "IMG-20220724-WA0031", "", "inherit", "open", "closed", "", "img-20220724-wa0031", "", "", "2022-07-24 19:11:01", "2022-07-24 14:41:01", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/07/IMG-20220724-WA0031.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6440", "1", "2022-07-24 19:10:52", "2022-07-24 14:40:52", "", "IMG-20220724-WA0030", "", "inherit", "open", "closed", "", "img-20220724-wa0030", "", "", "2022-07-24 19:10:52", "2022-07-24 14:40:52", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/07/IMG-20220724-WA0030.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6441", "1", "2022-07-24 19:10:53", "2022-07-24 14:40:53", "", "IMG-20220724-WA0032", "", "inherit", "open", "closed", "", "img-20220724-wa0032", "", "", "2022-07-24 19:10:53", "2022-07-24 14:40:53", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/07/IMG-20220724-WA0032.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6442", "1", "2022-07-24 19:10:55", "2022-07-24 14:40:55", "", "IMG-20220724-WA0035", "", "inherit", "open", "closed", "", "img-20220724-wa0035", "", "", "2022-07-24 19:10:55", "2022-07-24 14:40:55", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/07/IMG-20220724-WA0035.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6443", "1", "2022-07-24 19:10:56", "2022-07-24 14:40:56", "", "IMG-20220724-WA0037", "", "inherit", "open", "closed", "", "img-20220724-wa0037", "", "", "2022-07-24 19:10:56", "2022-07-24 14:40:56", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/07/IMG-20220724-WA0037.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6444", "1", "2022-07-24 19:10:57", "2022-07-24 14:40:57", "", "IMG-20220724-WA0036", "", "inherit", "open", "closed", "", "img-20220724-wa0036", "", "", "2022-07-24 19:10:57", "2022-07-24 14:40:57", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/07/IMG-20220724-WA0036.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6445", "1", "2022-07-24 19:10:58", "2022-07-24 14:40:58", "", "IMG-20220724-WA0034", "", "inherit", "open", "closed", "", "img-20220724-wa0034", "", "", "2022-07-24 19:10:58", "2022-07-24 14:40:58", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/07/IMG-20220724-WA0034.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("6446", "26", "2022-07-24 19:15:14", "2022-07-24 14:45:14", "ویلاباغ شهرکی استخردار نوشهر\r\n۱۲۵۰ متر زمین ۵۵۰ متر بنا با سند و جواز ساخت .\r\nداخل شهرک با نگهبانی.\r\nبا استخرو جکوزی.\r\nمدرن و نوساز.\r\nچهار خوابه مستر.\r\n۲۶م", "ویلاباغ شهرکی استخردار نوشهر", "", "publish", "open", "closed", "", "%d9%88%db%8c%d9%84%d8%a7%d8%a8%d8%a7%d8%ba-%d8%b4%d9%87%d8%b1%da%a9%db%8c-%d8%a7%d8%b3%d8%aa%d8%ae%d8%b1%d8%af%d8%a7%d8%b1-%d9%86%d9%88%d8%b4%d9%87%d8%b1", "", "", "2023-06-02 17:42:42", "2023-06-02 14:12:42", "", "0", "https://sitralweb.com/ir3/?post_type=state&#038;p=6446", "0", "state", "", "0");
INSERT INTO `wp_posts` VALUES("6463", "1", "2022-10-06 14:02:50", "2022-10-06 10:32:50", "", "marker-red", "", "inherit", "open", "closed", "", "marker-red", "", "", "2022-10-06 14:02:50", "2022-10-06 10:32:50", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/10/marker-red.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("6464", "1", "2022-10-06 14:02:58", "2022-10-06 10:32:58", "", "marker-icon", "", "inherit", "open", "closed", "", "marker-icon", "", "", "2022-10-06 14:02:58", "2022-10-06 10:32:58", "", "0", "https://sitralweb.com/ir3/wp-content/uploads/2022/10/marker-icon.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("6454", "0", "2022-08-12 12:30:03", "0000-00-00 00:00:00", "", "sdsds", "", "pending", "closed", "closed", "", "", "", "", "2022-08-12 12:30:03", "0000-00-00 00:00:00", "", "0", "https://sitralweb.com/ir3/?post_type=taghaza&p=6454", "0", "taghaza", "", "0");
INSERT INTO `wp_posts` VALUES("6456", "0", "2022-08-21 08:58:38", "0000-00-00 00:00:00", "", "رز غفوری", "", "pending", "closed", "closed", "", "", "", "", "2022-08-21 08:58:38", "0000-00-00 00:00:00", "", "0", "https://sitralweb.com/ir3/?post_type=payam&p=6456", "0", "payam", "", "0");
INSERT INTO `wp_posts` VALUES("6458", "1", "2022-08-27 08:12:18", "2022-08-27 03:42:18", "توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .\r\nتوضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .\r\nتوضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .\r\nتوضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .", "نمایش نقشه", "", "publish", "closed", "closed", "", "map", "", "", "2022-08-27 08:12:27", "2022-08-27 03:42:27", "", "0", "https://sitralweb.com/ir3/?page_id=6458", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6459", "1", "2022-08-27 08:12:18", "2022-08-27 03:42:18", "توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .\r\nتوضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .\r\nتوضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .\r\nتوضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .توضیحات بیشتری بزودی در اینجا درج میگردد .", "نمایش نقشه", "", "inherit", "closed", "closed", "", "6458-revision-v1", "", "", "2022-08-27 08:12:18", "2022-08-27 03:42:18", "", "6458", "https://sitralweb.com/ir3/?p=6459", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("6150", "1", "2022-04-29 16:07:14", "2022-04-29 11:37:14", "<!-- wp:paragraph --><!-- /wp:paragraph -->\n\n<!-- wp:shortcode -->\n<p>[iranamlak mantaghe=\"1412\"]</p>\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p>&nbsp;</p>\n<!-- /wp:paragraph -->", "همه آگهی های تهران", "", "inherit", "closed", "closed", "", "5496-autosave-v1", "", "", "2022-04-29 16:07:14", "2022-04-29 11:37:14", "", "5496", "https://sitralweb.com/ir3/?p=6150", "0", "revision"