<?php
$statusFile = __DIR__ . '/ads_status.txt';

if (!file_exists($statusFile)) {
    file_put_contents($statusFile, 'IDLE');
}

// --- handle state changes or status requests ---
if (isset($_GET['action'])) {
    $action = $_GET['action'];

    if ($action === 'status') {
        header('Content-Type: text/plain');
        echo trim(file_get_contents($statusFile));
        exit;
    }

    // 👇 آی‌پی پابلیک کاربر (کلاینت)
    if ($action === 'ip') {
        header('Content-Type: text/plain');

        // تشخیص دقیق آی‌پی واقعی کاربر حتی پشت Cloudflare / Proxy
        function getClientIP() {
            $headers = [
                'HTTP_CLIENT_IP',
                'HTTP_X_FORWARDED_FOR',
                'HTTP_CF_CONNECTING_IP',  // برای Cloudflare
                'REMOTE_ADDR'
            ];
            foreach ($headers as $key) {
                if (!empty($_SERVER[$key])) {
                    $ipList = explode(',', $_SERVER[$key]);
                    return trim($ipList[0]);
                }
            }
            return 'Unknown';
        }

        $clientIp = getClientIP();
        echo $clientIp;
        exit;
    }

    if ($action === 'run') {
        file_put_contents($statusFile, 'RUN');
    } elseif ($action === 'reset') {
        file_put_contents($statusFile, 'IDLE');
    } elseif ($action === 'done') {
        file_put_contents($statusFile, 'DONE');
    }

    header('Content-Type: text/plain');
    echo trim(file_get_contents($statusFile));
    exit;
}

function getStatusClass($status) {
    switch ($status) {
        case 'RUN': return 'bg-warning text-dark';
        case 'DONE': return 'bg-success text-white';
        default: return 'bg-secondary text-white';
    }
}

$status = trim(file_get_contents($statusFile));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ads.py Control Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #f6f6f6; }
        .card { max-width: 480px; margin: 60px auto; box-shadow: 0 0 15px rgba(0,0,0,0.1);}
        .status-box { font-size: 22px; padding: 12px; border-radius: 8px; }
        .big-run-btn { font-size: 1.5rem; padding: 1rem 2rem; border-radius: 10px; }
        .btn-group button { min-width: 120px; }
        .big-run-btn:hover { transform: scale(1.05); background-color: #ffbb33; }
    </style>
</head>
<body>

<div class="card p-4 text-center">
    <h4 class="mb-3">🖥 ads.py Control Panel</h4>

    <div id="statusBox" class="status-box mb-3 <?php echo getStatusClass($status); ?>">
        Current Status: <strong id="statusText"><?php echo htmlspecialchars($status); ?></strong>
    </div>

    <div id="ipBox" class="mb-2 text-secondary" style="font-size:24px;">
        Client Public IP: <strong id="ipText">Loading...</strong>
    </div>

    <div class="my-3">
        <button class="btn btn-warning btn-lg w-75 big-run-btn" onclick="sendAction('run')">🚀 Run ads.py</button>
    </div>

    <div class="btn-group d-flex justify-content-center gap-2">
        <button class="btn btn-success flex-fill" onclick="sendAction('done')">✅ Mark as Done</button>
        <button class="btn btn-secondary flex-fill" onclick="sendAction('reset')">♻️ Reset</button>
    </div>

    <div class="mt-3 small text-muted">
        Status and your IP refresh automatically every 5 seconds.
    </div>
</div>

<script>
function sendAction(action) {
    fetch(`?action=${action}`)
        .then(res => res.text())
        .then(status => updateStatus(status.trim()));
}

function updateStatus(status) {
    const box = document.getElementById('statusBox');
    const text = document.getElementById('statusText');
    text.textContent = status;

    box.className = "status-box mb-3";
    if (status === "RUN") box.classList.add("bg-warning","text-dark");
    else if (status === "DONE") box.classList.add("bg-success","text-white");
    else box.classList.add("bg-secondary","text-white");
}

// auto-refresh every 5 seconds
setInterval(() => {
    fetch('?action=status')
        .then(res => res.text())
        .then(status => { 
            if (status.trim().match(/^(RUN|IDLE|DONE)$/i)) 
                updateStatus(status.trim().toUpperCase()); 
        });

    fetch('?action=ip')
        .then(res => res.text())
        .then(ip => {
            document.getElementById('ipText').textContent = ip.trim();
        });
}, 2000);

// اولین بار آی‌پی کاربر را بخوان
fetch('?action=ip')
    .then(res => res.text())
    .then(ip => {
        document.getElementById('ipText').textContent = ip.trim();
    });
</script>

</body>
</html>
