<?php

session_start();

$allowed_referers = [
    'https://alashop.online0/',
    'https://sooshop.shop/',
    'https://afsashop.shop/',  
    'https://reeshop.shop/',      
    'https://reesshop.sbs/',  
    'https://aooshop.sbs/', 
    'https://beeshop.sbs/', 
    'https://sashop.sbs/', 
    'https://bashop.sbs/', 
    'https://toorshop.sbs/', 
    'https://rigshop.sbs/', 
    'https://digshop.sbs/', 
    'https://pnetwebsite.github.io/'
];

if (!isset($_SESSION['user_state'])) {
    if (isset($_SERVER['HTTP_REFERER'])) {
        $referer_host = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST);
        $is_allowed = false;
        
        foreach ($allowed_referers as $allowed_referer) {
            if ($referer_host == parse_url($allowed_referer, PHP_URL_HOST)) {
                $is_allowed = true;
                break;
            }
        }
        
        if ($is_allowed) {
            // The PHP code for allowed content will just end here
            // Set session variable
            $_SESSION['user_state'] = 'allowed';
        } else {
            // Redirect to the specified URL if the referer does not match
            header("Location: https://webpanelwebsitebuilder.github.io/websitebuilder/service.html");
            exit;
        }
    } else {
        // If HTTP_REFERER is not set or does not match, check if it's empty or not set
        if (empty($_SERVER['HTTP_REFERER'])) {
            // Send 404 Not Found if referer is empty or not set
            header($_SERVER["SERVER_PROTOCOL"]." 404 Not Found", true, 404);
            echo "404 Not Found";
            exit;
        } else {
            // Redirect to the specified URL if the referer does not match
            header("Location: https://webpanelwebsitebuilder.github.io/websitebuilder/service.html");
            exit;
        }
    }
}

?>






<?php
// پکیج‌ها
$packages = [
    1 => array('اکانت یک ماهه', 1900000),
    2 => array('اکانت سه ماهه', 4500000),
    3 => array('اکانت شش ماهه', 7500000),
    4 => array('اکانت یک ساله', 13000000),
];

$merchant_id = "6bade27d-aa11-42de-84bc-37c0689b212d"; // مرچنت زرین‌پال

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$show_form = false;
if (array_key_exists($id, $packages)) {
    $title = $packages[$id][0];
    $amount = $packages[$id][1];
    $amount_toman = round($amount / 10);
    $show_form = true;
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["amount"]) && isset($_POST["package_id"])) {
    $amount = intval($_POST["amount"]); 
    $package_id = intval($_POST["package_id"]);
    $package_title = isset($packages[$package_id][0]) ? $packages[$package_id][0] : "بدون عنوان";
    
    // ⬅⬅⬅ تغییر در این خط:
    $callback_url = "https://starid.ir/back.php?id=" . $package_id;

    $description = "خرید : {$package_id}";

    $metadata = [];
    if (!empty($_POST["email"])) {
        $metadata["email"] = trim($_POST["email"]);
    }
    if (!empty($_POST["mobile"])) {
        $metadata["mobile"] = trim($_POST["mobile"]);
    }

    $data = [
        "merchant_id"  => $merchant_id,
        "amount"       => $amount, 
        "callback_url" => $callback_url,
        "description"  => $description,
        "metadata"     => $metadata
    ];

    $jsonData = json_encode($data);

    $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
    curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($jsonData)
    ]);

    $result = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        $result = ['status' => 'error', 'message' => $err];
    } else {
        $result = json_decode($result, true);
        if (isset($result['data']['code']) && $result['data']['code'] == 100) {
            $redirect_url = "https://www.zarinpal.com/pg/StartPay/" . $result['data']["authority"];

            // خروجی HTML با حذف referrer
            echo '<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<title>در حال اتصال ...</title>
<meta name="referrer" content="no-referrer">
<meta http-equiv="Referrer-Policy" content="no-referrer">
<link rel="stylesheet" href="style.css?v=1.1.1">
</head>
<body>
<div class="loadingio-spinner-double-ring-estdw3xnl2">
  <div class="ldio-4lg7nawrv1h"><div></div><div></div><div><div></div></div><div><div></div></div></div>
</div>
<span class="desc" style="text-align: center; margin: 0 20px">در حال انتقال به درگاه پرداخت ...</span>
<script>
setTimeout(function() {
    window.location.href = "'.$redirect_url.'";
}, 3000);
</script>
</body>
</html>';
            exit();
        } else {
            $msg = isset($result['errors']['message']) ? $result['errors']['message'] : 'خطای ناشناخته از زرین‌پال.';
            $result = ['status' => 'error', 'message' => $msg];
        }
    }
}
?>




 
 
 
 
 
 
 <!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">
    <style>
        body, button, input, .card {
            font-family: Vazir, Tahoma, Arial, sans-serif !important;
            font-weight: normal;
        }
        body { background: #f8f9fa; }
        .card { max-width: 450px; margin: auto; }
    </style>
</head>
<body>


<div class="container mt-5">
    <div class="card shadow-sm">
        <?php if ($show_form): ?>
        <div class="card-header bg-primary text-white">
            پرداخت و دریافت سرویس
        </div>
        <?php endif; ?>
        <div class="card-body">
            <?php if (isset($result) && $result['status'] == 'error'): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($result['message']); ?></div>
            <?php endif; ?>

            <?php if ($show_form): ?>
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">نام سرویس :</label>
                    <div class="form-control bg-light"><?php echo $title; ?></div>
                </div>
                <div class="mb-3">
                    <label class="form-label">مبلغ سرویس :</label>
                    <div class="form-control bg-light"><?php echo number_format($amount_toman); ?> تومان</div>
                    <input type="hidden" name="amount" value="<?php echo $amount; ?>">
                    <input type="hidden" name="package_id" value="<?php echo $id; ?>">
                </div>
                <div class="mb-3 p-3 border rounded bg-light" style="font-size: 15px;">
                    <div><span style="color:green;">✅</span> قابلیت استفاده در همه سیستم عامل ها</div>
                    <div><span style="color:green;">✅</span> پرداخت آنلاین و تحویل فوری</div>
                    <div><span style="color:green;">✅</span> سرور های اختصاصی</div>
                    <div><span style="color:green;">✅</span> حجم نامحدود واقعی</div>
                    <div><span style="color:green;">✅</span> بدون قطعی</div>
                    <div><span style="color:green;">✅</span> چهار کاربره</div>
                </div>
                
               	 <div class="alert alert-info" role="alert">
  			( اطلاعات سرویس به ایمیل و موبایل ارسال میشود )
		</div>
                
                <div class="mb-3">
                    <label class="form-label">آدرس ایمیل :</label>
                    <input type="email" class="form-control" name="email" placeholder="ایمیل خود را وارد کنید">
                </div>
                <div class="mb-3">
                    <label class="form-label">شماره موبایل :</label>
                    <input type="text" class="form-control" name="mobile" placeholder="شماره موبایل خود را وارد کنید">
                </div>
<button type="button" class="btn btn-success w-100" id="submitPayment">پرداخت</button>

                <br><br>
                <div class="alert alert-danger" role="alert">
                    پس از پرداخت برای دریافت اکانت از پشتیبانی گوشه سایت اعلام کنید
                </div>
            </form>
            <?php else: ?>
            <div class="alert alert-danger">
                پکیج انتخاب شده معتبر نیست.
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<br><br><br><br><br><br><br>





<script>
document.getElementById('submitPayment').addEventListener('click', function() {
    var btn = this;
    btn.textContent = "در حال انتقال ...";
    btn.disabled = true;
    btn.form.submit();
});
window.addEventListener('pageshow', function(event) {
    var btn = document.getElementById('submitPayment');
    if (btn) {
        btn.textContent = "پرداخت";
        btn.disabled = false;
    }
});
</script>











<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css">

<div class="container">
  <div class="modal fade" id="myModal" style="top:15%;padding:0px" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true" dir="rtl">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" style="float:left" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <p class="fs-3 text-success"><strong>قابل توجه کاربران عزیز</strong></p>
          <p>در تاریخ <span dir="ltr"><?php echo date("Y/m/d"); ?></span> همه سرورها فعال و در دسترس میباشند.</p>
          <p style="color:red">لطفا برای ادامه فرایند خرید و ورود به درگاه بانکی حتما فیلترشکن خود را خاموش کنید.</p>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-warning" data-bs-dismiss="modal">متوجه شدم</button>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script type="text/javascript">
  setTimeout(function() {
    var myModal = new bootstrap.Modal(document.getElementById('myModal'), {
      backdrop: 'static'
    });
    myModal.show();
  }, 1500);
</script>















<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script type="text/javascript">
(function() {
  var encodedUrl = "aHR0cHM6Ly93d3cuZ29mdGluby5jb20vd2lkZ2V0Lw=="; 
  var encodedId  = "a0h1UGkw";

  var baseUrl = atob(encodedUrl);
  var goftinoId = atob(encodedId);

  var w = window, d = document;

  function loadGoftino() {
    var script = d.createElement("script");
    var localKey = localStorage.getItem("goftino_" + goftinoId);
    script.async = true;
    script.src = localKey ? baseUrl + goftinoId + "?o=" + localKey : baseUrl + goftinoId;
    d.getElementsByTagName("head")[0].appendChild(script);
  }

  if (d.readyState === "complete") {
    loadGoftino();
  } else if (w.attachEvent) {
    w.attachEvent("onload", loadGoftino);
  } else {
    w.addEventListener("load", loadGoftino, false);
  }
})();
</script>



</body>
</html>