/**
 *
 * -----------------------------------------------------------
 *
 * Codestar Framework
 * A Lightweight and easy-to-use WordPress Options Framework
 *
 * Copyright 2015 Codestar <info@codestarlive.com>
 *
 * -----------------------------------------------------------
 *
 */
jQuery( function( $ ) {
  'use strict';

  // caching
  var CodevzFramework     = {};
  var $body   = $( document.body );
  var has_rtl = $body.hasClass('rtl');

  CodevzFramework.funcs = {};
  CodevzFramework.vars  = {};

  //
  // Helper Functions - CODEVZ, Regex changed and trigger change added
  //
  CodevzFramework.helper = {
    name_replace: function( $selector ) {

      if ( $selector.closest( '.widget-content' ).length ) {

        $selector.find('.codevz-cloneable-item').each( function( index ) {
          $(this).find('input').each( function(){
            this.name = this.name.replace(/\]\[\d+\]/g, ']['+ index +']');
            $( this ).trigger( 'change' );
          });
        });

      } else {

        $selector.find('.codevz-cloneable-item').each( function( index ) {
          $(this).find(':input').each( function(){
            this.name = this.name.replace(/\[(\d+)\]/, '['+ index +']');
          });
        });

      }
    },

    debounce: function( callback, threshold, immediate ) {
      var timeout;
      return function() {
        var context = this, args = arguments;
        var later = function() {
          timeout = null;
          if ( !immediate ) {
            callback.apply(context, args);
          }
        };
        var callNow = ( immediate && !timeout );
        clearTimeout( timeout );
        timeout = setTimeout( later, threshold );
        if ( callNow ){
          callback.apply(context, args);
        }
      };
    }
  };

  //
  // Navigation
  //
  $.fn.codevz_navigation = function() {
    return this.each(function() {

      var $nav     = $(this),
          $parent  = $nav.closest('.codevz'),
          $section = $parent.find('.codevz-section-id'),
          $expand  = $parent.find('.codevz-expand-all'),
          $tabbed;

      $nav.find('ul:first a').on('click', function (e) {

        e.preventDefault();

        var $el     = $(this),
            $next   = $el.next(),
            $target = $el.data('section');

        if( $next.is('ul') ) {

          $el.closest('li').toggleClass('codevz-tab-active');

        } else {

          $tabbed = $('#codevz-tab-'+$target);

          $tabbed.removeClass('hidden').siblings().addClass('hidden');

          $nav.find('a').removeClass('codevz-section-active');
          $el.addClass('codevz-section-active');
          $section.val($target);

          $tabbed.codevz_reload_script();

        }

      });

      $expand.on('click', function (e) {

        e.preventDefault();

        $parent.find('.codevz-wrapper').toggleClass('codevz-show-all');
        $parent.find('.codevz-section').not('.codevz-onload').codevz_reload_script();
        $(this).find('.fa').toggleClass('fa-eye-slash' ).toggleClass('fa-eye');

      });

    });
  };

  //
  // Custom clone for textarea and select clone() bug
  //
  $.fn.codevz_clone = function () {

    var base   = $.fn.clone.apply(this, arguments),
        clone  = this.find('select').add(this.filter('select')),
        cloned = base.find('select').add(base.filter('select'));

    for( var i = 0; i < clone.length; ++i ) {
      for( var j = 0; j < clone[i].options.length; ++j ) {

        if( clone[i].options[j].selected === true ) {
          cloned[i].options[j].selected = true;
        }

      }
    }

    return base;

  };

  //
  // Dependency System
  //
  $.fn.codevz_dependency = function ( param ) {
    return this.each(function () {

      var base  = this,
          $this = $(this);

      base.init = function () {

        base.ruleset = $.deps.createRuleset();

        var cfg = {
          show: function( el ) {
            el.removeClass('hidden');
          },
          hide: function( el ) {
            el.addClass('hidden');
          },
          log: false,
          checkTargets: false
        };

        if( param !== undefined ) {
          base.depSub();
        } else {
          base.depRoot();
        }

        $.deps.enable( $this, base.ruleset, cfg );

      };

      base.depRoot = function() {

        $this.each( function() {

          $(this).find('[data-controller]').each( function() {

            var $this       = $(this),
                _controller = $this.data('controller').split('|'),
                _condition  = $this.data('condition').split('|'),
                _value      = $this.data('value').toString().split('|'),
                _rules      = base.ruleset;

            $.each(_controller, function(index, element) {

              var value     = _value[index] || '',
                  condition = _condition[index] || _condition[0];

              _rules = _rules.createRule('[data-depend-id="'+ element +'"]', condition, value);
              _rules.include($this);

            });

          });

        });

      };

      base.depSub = function() {

        $this.each( function() {

          $(this).find('[data-sub-controller]').each( function() {

            var $this       = $(this),
                _controller = $this.data('sub-controller').split('|'),
                _condition  = $this.data('sub-condition').split('|'),
                _value      = $this.data('sub-value').toString().split('|'),
                _rules      = base.ruleset;

            $.each(_controller, function(index, element) {

              var value     = _value[index] || '',
                  condition = _condition[index] || _condition[0];

              _rules = _rules.createRule('[data-sub-depend-id="'+ element +'"]', condition, value);
              _rules.include($this);

            });

          });

        });

      };

      base.init();

    });
  };

  //
  // Field Image Selector
  //
  $.fn.codevz_field_image_selector = function() {
    return this.each(function() {

      $(this).find('label').on('click', function () {
        $(this).siblings().find('input').prop('checked', false);
      });

    });
  };

  //
  // Field Upload
  //
  $.fn.codevz_field_upload = function() {
    return this.each(function() {

      var $this      = $(this),
          $button    = $this.find('.codevz-button'),
          $preview   = $this.find('.codevz-image-preview'),
          $remove    = $this.find('.codevz-image-remove'),
          $img       = $this.find('img'),
          $input     = $this.find('input'),
          extensions = ['jpg', 'gif', 'png', 'svg', 'jpeg'],
          wp_media_frame;

      $button.on('click', function( e ) {

        e.preventDefault();

        if ( typeof wp === 'undefined' || ! wp.media || ! wp.media.gallery ) {
          return;
        }

        if ( wp_media_frame ) {
          wp_media_frame.open();
          return;
        }

        wp_media_frame = wp.media({
          title: $button.data('frame-title'),
          library: {
            type: $button.data('upload-type')
          },
          button: {
            text: $button.data('insert-title'),
          }
        });

        wp_media_frame.on( 'select', function() {

          var attachment = wp_media_frame.state().get( 'selection' ).first();
          $input.val( attachment.attributes.url ).trigger('change');

        });

        wp_media_frame.open();

      });

      if( $preview.length ) {

        $input.on('change keyup', function() {

          var $this = $(this),
              value = $this.val(),
              ext   = value.toLowerCase().slice((value.toLowerCase().lastIndexOf('.') - 1) + 2);

          // CODEVZ
          $preview.removeClass('hidden');
          $img.attr('src', value);

        });

        $remove.on('click', function( e ) {

          e.preventDefault();
          $input.val('').trigger('change');
          $preview.addClass('hidden');

        });

      }

    });

  };

  //
  // Field Image
  //
  $.fn.codevz_field_image = function() {
    return this.each(function() {

      var $this    = $(this),
          $button  = $this.find('.codevz-button'),
          $preview = $this.find('.codevz-image-preview'),
          $remove  = $this.find('.codevz-image-remove'),
          $input   = $this.find('input'),
          $img     = $this.find('img'),
          wp_media_frame;

      $button.on('click', function( e ) {

        e.preventDefault();

        if ( typeof wp === 'undefined' || ! wp.media || ! wp.media.gallery ) {
          return;
        }

        if ( wp_media_frame ) {
          wp_media_frame.open();
          return;
        }

        wp_media_frame = wp.media({
          library: {
            type: 'image'
          }
        });

        wp_media_frame.on( 'select', function() {

          var attachment = wp_media_frame.state().get('selection').first().attributes;
          var thumbnail = ( typeof attachment.sizes !== 'undefined' && typeof attachment.sizes.thumbnail !== 'undefined' ) ? attachment.sizes.thumbnail.url : attachment.url;

          $preview.removeClass('hidden');
          $img.attr('src', thumbnail);
          $input.val( attachment.id ).trigger('change');

        });

        wp_media_frame.open();

      });

      $remove.on('click', function( e ) {
        e.preventDefault();
        $input.val('').trigger('change');
        $preview.addClass('hidden');
      });

    });

  };

  //
  // Field Gallery
  //
  $.fn.codevz_field_gallery = function() {
    return this.each(function() {

      var $this  = $(this),
          $edit  = $this.find('.codevz-edit-gallery'),
          $clear = $this.find('.codevz-clear-gallery'),
          $list  = $this.find('ul'),
          $input = $this.find('input'),
          $img   = $this.find('img'),
          wp_media_frame,
          wp_media_click;

      $this.on('click', '.codevz-button, .codevz-edit-gallery', function( e ) {

        var $el   = $(this),
            what  = ( $el.hasClass('codevz-edit-gallery') ) ? 'edit' : 'add',
            state = ( what === 'edit' ) ? 'gallery-edit' : 'gallery-library';

        e.preventDefault();

        if ( typeof wp === 'undefined' || ! wp.media || ! wp.media.gallery ) {
          return;
        }

        if ( wp_media_frame ) {
          wp_media_frame.open();
          wp_media_frame.setState(state);
          return;
        }

        wp_media_frame = wp.media({
          library: {
            type: 'image'
          },
          frame: 'post',
          state: 'gallery',
          multiple: true
        });

        wp_media_frame.on('open', function() {

          var ids = $input.val();

          if ( ids ) {

            var get_array = ids.split(',');
            var library   = wp_media_frame.state('gallery-edit').get('library');

            wp_media_frame.setState(state);

            get_array.forEach(function(id) {
              var attachment = wp.media.attachment(id);
              library.add( attachment ? [ attachment ] : [] );
            });

          }
        });

        wp_media_frame.on( 'update', function() {

          var inner  = '';
          var ids    = [];
          var images = wp_media_frame.state().get('library');

          images.each(function(attachment) {

            var attributes = attachment.attributes;
            var thumbnail  = ( typeof attributes.sizes.thumbnail !== 'undefined' ) ? attributes.sizes.thumbnail.url : attributes.url;

            inner += '<li><img src="'+ thumbnail +'"></li>';
            ids.push(attributes.id);

          });

          $input.val(ids).trigger('change');
          $list.html('').append(inner);
          $clear.removeClass('hidden');
          $edit.removeClass('hidden');

        });

        wp_media_frame.open();
        wp_media_click = what;

      });

      $clear.on('click', function( e ) {
        e.preventDefault();
        $list.html('');
        $input.val('').trigger('change');
        $clear.addClass('hidden');
        $edit.addClass('hidden');
      });

    });

  };

  // CODEVZ, Live group title
  function codevz_live_title( $this ) {
      setTimeout(function() {
        $this.find( '.codevz-cloneable-content' ).each(function() {
          var en = $( this ),
              tt = en.parent().find( '> .codevz-cloneable-title .codevz-cloneable-text' );

          en.find( '> .codevz-field:first-child [name]' ).off( 'change.cc keyup.cc' ).on( 'change.cc keyup.cc', function() {
            var een = $( this );
            if ( een.is( "select" ) ) {
              tt.html( een.find( 'option:selected' ).text() );
            } else {
              tt.html( een.val() ? een.val() : '...' );
            }
          }).trigger( 'change' );
        });
      }, 250 );
  }

  //
  // Field Group
  //
  $.fn.codevz_field_group = function() {
    return this.each(function() {

      var $this    = $(this),
          $wrapper = $this.find('.codevz-cloneable-wrapper'),
          $data    = $this.find('.codevz-cloneable-data'),
          $hidden  = $this.find('.codevz-cloneable-hidden'),
          unique   = $data.data('unique-id'),
          limit    = parseInt( $data.data('limit') );

      $wrapper.accordion({
        header: '.codevz-cloneable-title',
        collapsible : true,
        active: false,
        animate: false,
        heightStyle: 'content',
        icons: {
          'header': 'codevz-cloneable-header-icon fa fa-angle-right',
          'activeHeader': 'codevz-cloneable-header-icon fa fa-angle-down'
        },
        beforeActivate: function( event, ui ) {
          var $panel = ui.newPanel;
          if( $panel.length && !$panel.data( 'opened' ) ) {
            $panel.find('.codevz-field').removeClass('codevz-no-script');
            $panel.codevz_reload_script('sub');
            $panel.data( 'opened', true );
          }
        }
      });

      $wrapper.sortable({
        connectWith: ".codevz-cloneable-wrapper",
        axis: 'y',
        handle: '.codevz-cloneable-title',
        helper: 'original',
        cursor: 'move',
        placeholder: 'widget-placeholder',
        start: function( event, ui ) {
          $( 'body' ).attr( 'xtra-group', $wrapper.parent().find( '.codevz-cloneable-hidden [data-sub-depend-id="element_id"]' ).val() );
          $wrapper.accordion({ active:false });
          $wrapper.sortable('refreshPositions');
        },
        stop: function( event, ui ) {
          CodevzFramework.helper.name_replace( $wrapper );
          $wrapper.codevz_customizer_refresh();
        },
        // CODEVZ.
        receive: function( event, ui ) {

          var elementID = $wrapper.parent().find( '[data-sub-depend-id="element_id"]' ).val();

          $wrapper.find(':input').each( function(){
            this.name = this.name.replace( $( 'body' ).attr( 'xtra-group' ), elementID );
          });

          $wrapper.find( '[data-sub-depend-id="element_id"]' ).val( elementID ).trigger( 'change' );

          CodevzFramework.helper.name_replace( $wrapper );
          $wrapper.codevz_customizer_refresh();

        },
      });

      codevz_live_title( $this );

      // CODEVZ, Add icon to group add
      $this.find( '.codevz-cloneable-add' ).prepend( '<i class="fa fa-plus"></i>' );

      $this.on('click', '.codevz-cloneable-add', function( e ) {

        e.preventDefault();

        var count = $wrapper.find('.codevz-cloneable-item').length;

        if( limit && (count+1) > limit ) {
          $data.show();
          return;
        }

        var $cloned_item = $hidden.codevz_clone().removeClass('codevz-cloneable-hidden');

        $cloned_item.find(':input').each( function() {
          this.name = this.name.replace('_nonce', unique).replace('num', count);
        });

        $wrapper.append($cloned_item);
        $wrapper.accordion('refresh');
        $wrapper.accordion({active: count});
        $wrapper.codevz_customizer_refresh();
        $wrapper.codevz_customizer_listen(true);
        codevz_live_title( $this );

      });

      $wrapper.on('click', '.codevz-cloneable-clone', function( e ) {

        e.preventDefault();

        if( limit && parseInt($wrapper.find('.codevz-cloneable-item').length+1) > limit ) {
          $data.show();
          return;
        }

        var $this   = $(this),
            $parent = $this.closest('.codevz-cloneable-item'),
            $cloned = $parent.codevz_clone().addClass('codevz-cloned'),
            $childs = $wrapper.children();

        $childs.eq($parent.index()).after($cloned);

        CodevzFramework.helper.name_replace( $wrapper );

        $wrapper.accordion('refresh');
        $wrapper.codevz_customizer_refresh();
        $wrapper.codevz_customizer_listen(true);
        codevz_live_title( $parent.parent() );

      });

      $wrapper.on('click', '.codevz-cloneable-remove', function(e) {

        e.preventDefault();

        $(this).closest('.codevz-cloneable-item').remove();

        CodevzFramework.helper.name_replace( $wrapper );

        $wrapper.codevz_customizer_refresh();

        $data.hide();

      });

    });
  };

  //
  // Field Icon
  //
  $.fn.codevz_field_icon = function() {

    return this.each( function() {

      var $this = $(this);

      $this.on('click', '.codevz-icon-add', function ( e ) {

        var $modal = $('#codevz-modal-icon'),
            // CODEVZ
            old_item = $( this ).parent().find( 'input' ).val(),
            active_icon = function() {
              if ( old_item ) {
                $modal.find( 'a' ).each(function() {
                  if ( old_item === $( this ).data( 'codevz-icon' ) ) {
                    $( this ).addClass( 'cz_active_icon' ).siblings().removeClass( 'cz_active_icon' );
                  }
                });
              }
            };// CODEVZ

        e.preventDefault();

        $modal.show();
        $body.addClass('codevz-icon-scrolling');

        CodevzFramework.vars.$icon_target = $this;

        if( !CodevzFramework.vars.icon_modal_loaded ) {

          $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
              action: 'codevz-framework-get-icons'
            },
            success: function( content ) {

              CodevzFramework.vars.icon_modal_loaded = true;

              var $load = $modal.find('.codevz-modal-content').html( content );

              $load.on('click', 'a', function ( e ) {

                e.preventDefault();

                var icon = $(this).data('codevz-icon');

                CodevzFramework.vars.$icon_target.find('i').removeAttr('class').addClass(icon);
                CodevzFramework.vars.$icon_target.find('input').val(icon).trigger('change');
                CodevzFramework.vars.$icon_target.find('.codevz-icon-preview').removeClass('hidden');
                CodevzFramework.vars.$icon_target.find('.codevz-icon-remove').removeClass('hidden');

                $modal.hide();
                $body.removeClass('codevz-icon-scrolling');

              });

              active_icon(); // CODEVZ

              var timeout = 0,
                  $icons  = $load.find('a');

              $modal.on('change keyup', '.codevz-icon-search', function(){

                var value = $(this).val();

                clearTimeout( timeout );

                timeout = setTimeout(function() {

                  $icons.each(function() {

                    var $elem = $(this);

                    if ( $elem.data('codevz-icon').search( new RegExp( value, 'i' ) ) < 0 ) {
                      $elem.hide();
                    } else {
                      $elem.show();
                    }

                  });

                }, 1000 );


              });

              $modal.on('click', '.codevz-modal-close, .codevz-modal-overlay', function() {

                $modal.hide();
                $body.removeClass('codevz-icon-scrolling');

              });

            }

          });

        } else {
          active_icon(); // CODEVZ
        }

      });

      $this.on('click', '.codevz-icon-remove', function ( e ) {

        e.preventDefault();

        $this.find('.codevz-icon-preview').addClass('hidden');
        $this.find('input').val('').trigger('change');
        $(this).addClass('hidden');

      });

    });
  };

  //
  // CODEVZ: Field Font select
  //
  $.fn.codevz_field_select_font = function() {

    return this.each( function() {

      var $this = $(this);

      $this.on('click', '.codevz-font-add', function ( e ) {

        if ( $( this ).closest( '.xtra-readonly' ).length ) {

          alert( sk_aiL10n.pro );

          return false;

        }

        var $modal = $('#codevz-modal-font'),
            old_font = $( this ).prev( 'input' ).val(),
            active_font = function() {
              if ( old_font ) {
                old_font = old_font.indexOf( '=' ) > 0 ? old_font.substring( 0, old_font.indexOf( "=" ) ) : old_font;
                $modal.find( 'span' ).each(function() {
                  if ( old_font === $( this ).text() ) {
                    $( this ).parent().addClass( 'cz_active_font' ).removeClass( 'cz_font' ).siblings().removeClass( 'cz_active_font' );
                  }
                });
              }
            };

        e.preventDefault();

        $modal.show();
        $body.addClass('codevz-font-scrolling');

        CodevzFramework.vars.$font_target = $this;

        var cz_add_google_font_link = function( fonts_elements ) {
          fonts_elements.each(function() {
            var dis = $( this ),
                font = $( 'span', dis ).html();
            if ( ! dis.hasClass( 'websafe_font' ) && ! $( 'link', dis ).length ) {
              dis.css( 'font-family', font ).append('<link rel="stylesheet"  href="//fonts.googleapis.com/css?family=' + font.replace( / /g, '+' ) + ':100,200,300,400,500,600,700,800,900" media="all" />');
              setTimeout(function() {
                dis.show().removeClass( 'cz_font' );
                $( '#loadMore_font' ).removeClass( 'cz_loader' );
              }, 1000 );
            }
          });
        };

        if( !CodevzFramework.vars.font_modal_loaded ) {

          $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
              action: 'codevz-get-fonts'
            },
            success: function( content ) {

              CodevzFramework.vars.font_modal_loaded = true;

              var $load = $modal.find('.codevz-modal-content').html( content );

              $( '.codevz-modal-content', $modal ).append('<div class="clr"></div><a href="#" id="loadMore_font" class="cz_loader">' + sk_aiL10n.load_more + '</a>');

              var size_li = $( '.codevz-modal-content a', $modal ).length;
              var x = 20;
              cz_add_google_font_link( $( '.cz_font:lt('+x+')', $modal ) );

              $( '#loadMore_font' ).on('click', function (e) {

                  if ( $( this ).closest( '.xtra-readonly' ).length ) {

                    alert( sk_aiL10n.pro );

                    return false;

                  }

                  $( this ).addClass( 'cz_loader' );

                  cz_add_google_font_link( $( '.cz_font:lt('+x+')', $modal ) );

                  e.preventDefault();

                  return false;

              });

              // Font params
              $load.on('click', 'a i', function ( e ) {
                var diz = $( this ).parent().next( '.cz_font_params' );
                $( '.cz_font_params' ).not( diz ).fadeOut();
                diz.fadeToggle();
              });
              $( document.body ).on( 'click', function( e ) {
                if ( ! $( e.target ).closest( '.codevz-modal-content' ).length ) {
                  $( '.cz_font_params' ).fadeOut();
                }
              });

              active_font();

              // Select font
              $load.on('click', 'a', function ( e ) {
                e.preventDefault();

                if ( $( e.target ).prop( 'tagName' ) == 'A' || $( e.target ).prop( 'tagName' ) == 'SPAN' || $( e.target ).prop( 'tagName' ) == 'DIV' ) {
                  var font = $( 'span', this).html(), 
                      font_css = font;

                  // Font params
                  if ( $( this ).next( 'div' ).find( '.cz_font_variants :checkbox:checked' ).val() ) {
                    var vala = [];
                    $( this ).next( 'div' ).find( '.cz_font_variants :checkbox:checked' ).each(function(i){
                      vala[i] = $( this ).val();
                    });

                    font = font + '=' + vala.join(",");
                  }
                  if ( $( this ).next( 'div' ).find( '.cz_font_subsets :checkbox:checked' ).val() ) {
                    var valb = [];
                    $( this ).next( 'div' ).find( '.cz_font_subsets :checkbox:checked' ).each(function(i){
                      valb[i] = $( this ).val();
                    });

                    font = font + '&' + valb.join(",");
                  }
                  $( '.cz_font_params' ).fadeOut();

                  CodevzFramework.vars.$font_target.find('input').val( font ).trigger('change');
                  CodevzFramework.vars.$font_target.find('.codevz-font-preview, .codevz-font-remove').removeClass('hidden');

                  $modal.hide();
                  $body.removeClass('codevz-font-scrolling');
                }
              });

              $modal.on('change keyup', '.codevz-font-search', function(){

                var value  = $(this).val(),
                    $fonts = $load.find('a');

                if ( ! value ) {
                  var x = 20;
                  $( '.codevz-modal-content a', $modal ).hide().not( '.cz_font' ).show();
                  $( '#loadMore_font, .websafe_font', $modal ).show();
                  return false;
                }

                if ( value.length < 3 ) {
                  return false;
                }
                $( '#loadMore_font' ).hide();

                $fonts.each(function() {

                  var $elem = $(this),
                      search = new RegExp( value, 'i' );

                  if ( search && $elem.find('span').html().search( search ) < 0 ) {
                    $elem.hide();
                  } else {
                    $elem.show();
                    cz_add_google_font_link( $elem );
                  }

                });

              });
              
              // Change font preview text
              $modal.on('change keyup', '.codevz-font-placeholder', function(){

                var value = $( this ).val();

                if ( value ) {
                  $modal.addClass( 'xtra-search-active' );
                  $modal.find('.codevz-modal-content .cz_preview').show().html( value );
                } else {
                  $modal.find('.codevz-modal-content .cz_preview').hide();
                  $modal.removeClass( 'xtra-search-active' );
                }

              });

              $modal.on('click', '.codevz-modal-close, .codevz-modal-overlay', function() {

                $modal.hide();
                $body.removeClass('codevz-font-scrolling');

              });

            }

          });

        } else {
          active_font();
        }

      });

      $this.on('click', '.codevz-font-remove', function ( e ) {

        e.preventDefault();

        $this.find('input').val('').trigger('change');
        $( this ).addClass('hidden');

      });

    });
  };


  //
  // Color Picker Helper
  //
  if( typeof Color === 'function' ) {
 
    Color = xtraColor;

    Color.fn.toString = function () {

      if ( this._alpha < 1 ) {
        return this.toCSS('rgba', this._alpha).replace(/\s+/g, '');
      }

      var hex = parseInt( this._color, 10 ).toString( 16 );

      if ( this.error ) { return ''; }

      if ( hex.length < 6 ) {
        for (var i = 6 - hex.length - 1; i >= 0; i--) {
          hex = '0' + hex;
        }
      }

      return '#' + hex;

    };

  }

  CodevzFramework.funcs.PARSE_COLOR_VALUE = function( val ) {

    var value = val.replace(/\s+/g, ''),
        alpha = ( value.indexOf('rgba') !== -1 ) ? parseFloat( value.replace(/^.*,(.+)\)/, '$1') * 100 ) : 100,
        rgba  = ( alpha < 100 ) ? true : false;

    return { value: value, alpha: alpha, rgba: rgba };

  };

  //
  // Field Color Picker
  //
  $.fn.codevz_field_colorpicker = function() {

    return this.each(function() {

      var $this     = $(this),
          $input    = $this.find('.codevz-wp-color-picker'),
          $wppicker = $this.find('.wp-picker-container');

      // BY CODEVZ: setTimeout for better customizer performance
      setTimeout(function() {

        // Destroy and Reinit
        // EDITED BY CODEVZ
        if( $wppicker.length && ! $this.closest( '.codevz-field-codevz_box_shadow' ).length ) {
          $wppicker.after($input).remove();
        }

        if( $input.data('rgba') !== false ) {

          // CODEVZ
          var picker = CodevzFramework.funcs.PARSE_COLOR_VALUE( $input.val() ),
              primary_color = typeof codevz_primary_color == 'string' ? codevz_primary_color : '',
              secondary_color = typeof codevz_secondary_color == 'string' ? codevz_secondary_color : '',
              palettes = ['#000000','#FFFFFF','transparent','#E53935','#FF5722','#FFEB3B','#8BC34A','#3F51B5',primary_color];

            if ( secondary_color ) {
              palettes.push( secondary_color );
            }

          $input.wpColorPicker({

            palettes: palettes, // CODEVZ

            clear: function() {
              $input.trigger('input');
              $( '[name="padding[top]"]' ).trigger( 'change' );
            },

            change: function( event, ui ) {

              var ui_color_value = ui.color.toString();
              if ( ui.color.error ) {
                ui_color_value = 'transparent';
              }

              $input.closest('.wp-picker-container').find('.codevz-alpha-slider-offset').css('background-color', ui_color_value);
              $input.val(ui_color_value).trigger('change');

            },

            create: function() {

              var a8cIris       = $input.data('a8cIris'),
                  $container    = $input.closest('.wp-picker-container'),

                  $alpha_wrap   = $('<div class="codevz-alpha-wrap">' +
                                    '<div class="codevz-alpha-slider"></div>' +
                                    '<div class="codevz-alpha-slider-offset"></div>' +
                                    '<div class="codevz-alpha-text"></div>' +
                                    '</div>').appendTo( $container.find('.wp-picker-holder') ),

                  $alpha_slider = $alpha_wrap.find('.codevz-alpha-slider'),
                  $alpha_text   = $alpha_wrap.find('.codevz-alpha-text'),
                  $alpha_offset = $alpha_wrap.find('.codevz-alpha-slider-offset');

              $alpha_slider.slider({

                slide: function( event, ui ) {

                  var slide_value = parseFloat( ui.value / 100 );

                  a8cIris._color._alpha = slide_value;
                  $input.wpColorPicker( 'color', a8cIris._color.toString() );
                  $alpha_text.text( ( slide_value < 1 ? slide_value : '' ) );

                },

                create: function() {

                  var slide_value = parseFloat( picker.alpha / 100 ),
                      alpha_text_value = slide_value < 1 ? slide_value : '';

                  $alpha_text.text(alpha_text_value);
                  $alpha_offset.css('background-color', picker.value);

                  $container.on('click', '.wp-picker-clear', function() {

                    a8cIris._color._alpha = 1;
                    $alpha_text.text('').trigger('change');
                    $alpha_slider.slider('option', 'value', 100).trigger('slide');

                  });

                  $container.on('click', '.wp-picker-default', function() {

                    var default_picker = CodevzFramework.funcs.PARSE_COLOR_VALUE( $input.data('default-color') ),
                        default_value  = parseFloat( default_picker.alpha / 100 ),
                        default_text   = default_value < 1 ? default_value : '';

                    a8cIris._color._alpha = default_value;
                    $alpha_text.text(default_text);
                    $alpha_slider.slider('option', 'value', default_picker.alpha).trigger('slide');

                  });

                  $container.on('click', '.wp-color-result', function() {
                    $alpha_wrap.toggle();
                  });

                  $body.on( 'click.wpcolorpicker', function() {
                    $alpha_wrap.hide();
                  });

                },

                value: picker.alpha,
                step: 1,
                min: 1,
                max: 100

              });
            }

          });

        } else {

          $input.wpColorPicker({
            clear: function() {
              $input.trigger('input');
            },
            change: function( event, ui ) {
              $input.val(ui.color.toString()).trigger('change');
            }
          });

        }

      }, 500 );

    });

  };

  //
  // Field Backup
  //
  $.fn.codevz_field_backup = function() {
    return this.each( function() {

      var $this   = $(this),
          $reset  = $this.find('.codevz-reset-js'),
          $import = $this.find('.codevz-import-js'),
          data    = $this.find('.codevz-data').data();

      $reset.on( 'click', function( e ) {

        $('.codevz-options').addClass('codevz-saving');

        e.preventDefault();

        $.ajax({
          type: 'POST',
          url: ajaxurl,
          data: {
            action: 'codevz-framework-reset-options',
            unique: data.unique,
            wpnonce: data.wpnonce
          },
          success: function() {
            location.reload();
          }
        });

      });

      $import.on( 'click', function( e ) {

        $('.codevz-options').addClass('codevz-saving');

        e.preventDefault();

        $.ajax({
          type: 'POST',
          url: ajaxurl,
          data: {
            action: 'codevz-framework-import-options',
            unique: data.unique,
            wpnonce: data.wpnonce,
            value: $this.find('.codevz-import-data').val()
          },
          success: function( content ) {
            location.reload();
          }
        });

      });


    });
  };

  //
  // Taxonomy Framework
  //
  $.fn.codevz_taxonomy = function() {
    return this.each( function() {

      var $this   = $(this),
          $parent = $this.parent();

      if( $parent.attr('id') === 'addtag' ) {

        var $submit  = $parent.find('#submit'),
            $clone   = $this.find('.codevz-field').codevz_clone(),
            $list    = $('#the-list'),
            flooding = false;

        $submit.on( 'click', function() {

          if( !flooding ) {

            $list.on( 'DOMNodeInserted', function() {

              if( flooding ) {

                $this.empty();
                $this.html( $clone );
                $clone = $clone.codevz_clone();

                $this.codevz_reload_script();

                flooding = false;

              }

            });

          }

          flooding = true;

        });

      }

    });
  };

  //
  // Helper Tooltip
  //
  $.fn.codevz_tooltip = function() {
    return this.each(function() {

      var $this = $(this),
          $tooltip,
          tooltip_left;

      $this.on({
        mouseenter: function () {

          $tooltip = $( '<div class="codevz-tooltip"></div>' ).html( $this.attr( 'data-title' ) ).appendTo('body');

          // CODEVZ ! added
          tooltip_left = ( ! has_rtl ) ? ( $this.offset().left + 24 ) : ( $this.offset().left - $tooltip.outerWidth() );

          $tooltip.css({
            top: $this.offset().top - ( ( $tooltip.outerHeight() / 2 ) - 12 ),
            left: tooltip_left,
          });

        },
        mouseleave: function () {

          if( $tooltip !== undefined ) {
            $tooltip.remove();
          }

        }

      });

    });
  };

  //
  // Customize Refresh
  //
  $.fn.codevz_customizer_refresh = function() {
    return this.each(function() {

      var $this    = $(this),
          $complex = $this.closest('.codevz-customize-complex');

      $(document).trigger('codevz-customizer-refresh', $this);

      if( wp.customize === undefined || $complex.length === 0 ) { return; }

      var $input  = $complex.find(':input'),
          $unique = $complex.data('unique-id'),
          $option = $complex.data('option-id'),
          obj     = $input.serializeObjectCodevz(),
          data    = ( !$.isEmptyObject(obj) ) ? obj[$unique][$option] : '';

      wp.customize.control( $unique +'['+ $option +']' ).setting.set( data );

    });
  };

  //
  // Customize Listen Form Elements - CODEVZ EDITED DELAY
  //
  $.fn.codevz_customizer_listen = function( has_closest ) {
    return this.each(function() {

      if( wp.customize === undefined ) { return; }

      var $this   = ( has_closest ) ? $(this).closest('.codevz-customize-complex') : $(this),
          $input  = $this.find(':input'),
          $unique = $this.data('unique-id'),
          $option = $this.data('option-id'),
          delay   = ( $option.indexOf( '_css_' ) >= 0 ) ? 0 : 250;

      if( $unique === undefined ) { return; }

      $input.on('change keyup', CodevzFramework.helper.debounce( function() {

        var obj  = $this.find(':input').serializeObjectCodevz();
        var data = ( !$.isEmptyObject(obj) ) ? obj[$unique][$option] : '';

        wp.customize.control( $unique +'['+ $option +']' ).setting.set( data );

      }, 250 ) );

    });
  };

  //
  // Customizer Listener for Reload JS
  //
  $(document).on( 'expanded', '.control-section-csf', function() {

    var $this = $(this);

    if( !$this.data('inited') ) {
      $this.codevz_reload_script();
      $this.find('.codevz-customize-complex').codevz_customizer_listen();
    }

  });

  //
  // Widgets Framework
  //
  $.fn.codevz_search = function() {
    return this.each(function() {

      var $this   = $(this),
          $widgets = $this.find('.widget-liquid-right .widget');

      $widgets.each( function() {

        var $widget  = $(this),
            $title = $widget.find('.widget-top');

        $title.on('click', function() {
          $widget.codevz_reload_script();
        });

      });

    });
  };

  //
  // Widget Listener for Reload JS
  //
  $(document).on( 'widget-added widget-updated', function( event, $widget ) {
    $widget.data( 'inited', false ); // CODEVZ
    $widget.codevz_reload_script();
  });

  //
  // Reload Widget Plugins
  //
  // API CODEVZ.
  $.fn.codevz_reload_script = function( has_sub, api ) {
    return this.each(function() {

      var $this = $(this);

      // Avoid for conflicts
      if( !$this.data('inited') ) {

        $this.find('.codevz-field-image-selector').not('.codevz-no-script').codevz_field_image_selector();
        $this.find('.codevz-field-image').not('.codevz-no-script').codevz_field_image();
        $this.find('.codevz-field-gallery').not('.codevz-no-script').codevz_field_gallery();
        $this.find('.codevz-field-upload').not('.codevz-no-script').codevz_field_upload();
        $this.find('.codevz-field-color_picker').not('.codevz-no-script').codevz_field_colorpicker();
        $this.find('.codevz-field-icon').not('.codevz-no-script').codevz_field_icon();
        $this.find('.codevz-field-select_font').not('.codevz-no-script').codevz_field_select_font();
        $this.find('.codevz-field-group').not('.codevz-no-script').codevz_field_group();
        $this.find('.codevz-field-backup').not('.codevz-no-script').codevz_field_backup();
        $this.find('.codevz-help').not('.codevz-no-script').codevz_tooltip();

        $this.codevz_dependency();

        if( has_sub ) {
          $this.codevz_dependency('sub');
        }

        $this.data('inited', true);

        setTimeout( function() {

          // API CODEVZ.
          $(document).trigger( 'codevz-reload-script', [ $this, api ] );

        }, 250 );

      }

    });
  };

  $('.codevz-taxonomy').codevz_taxonomy();
  $('.widgets-php').codevz_search();
  $('.codevz-nav').codevz_navigation();
  $('.codevz-onload').codevz_reload_script();

});
