<?php
/**
 * Source file was changed on the Tue Sep 6 16:23:37 2022 +0200
 */

namespace WP_Rocket\Engine\CDN\RocketCDN;

use Exception;
use WP_Rocket\Event_Management\Subscriber_Interface;

/**
 * Subscriber for the ApiClient
 *
 * @note CL
 */
class ApiClientSubscriber implements Subscriber_Interface {
	/**
	 * RocketCDN API Client instance.
	 *
	 * @var APIClient
	 */
	private $api_client;

	/**
	 * Constructor
	 *
	 * @param APIClient $api_client    RocketCDN API Client instance.
	 */
	public function __construct( APIClient $api_client ) {
		$this->api_client = $api_client;
	}

	/**
	 * {@inheritdoc}
	 */
	public static function get_subscribed_events() {
		return [
			'rocketcdn_accelerate_wp_cli_cdn_enable'  => [ 'cli_cdn_enable', 10, 2 ],
			'rocketcdn_accelerate_wp_cli_cdn_disable' => 'cli_cdn_disable',
		];
	}

	/**
	 * Enable CDN and add PullZone URL to WP Rocket options
	 *
	 * @param  int    $account_id  Account id.
	 * @param  string $cdn_url  Cdn url.
	 *
	 * @return void
	 * @throws Exception Data error.
	 */
	public function cli_cdn_enable( int $account_id, string $cdn_url ) {
		$this->api_client->enable( $account_id, $cdn_url );
	}

	/**
	 * Disable the CDN and remove the RocketCDN URL from WP Rocket options
	 *
	 * @return bool
	 */
	public function cli_cdn_disable() {
		$this->api_client->disable();

		return true;
	}
}
