@extends('Layouts.frontLayout',['color'=>$data['color'],'themColorTheme'=>$data['themColorTheme'],'cssFile'=>$data['cssFile'],'jsFile'=>$data['jsFile']])@section('content')
    <div class="row m-0 overflow-hidden">
        <aside class="aside-nav d-none d-sm-block col-2 p-0">
            <nav class="text-center">
                <button class="menu-toggle" aria-label="toggle menu"><span class="f-line"></span> <span
                            class="s-line"></span> <span class="t-line"></span></button>
                <div class="logo m-auto">
                    <div>
                        {{ \App\Model\Settings::getSettingName('titleSite')}}
                    </div>
                </div>
                <div class="menu w-100">
                    <ul class="overflow-hidden text-capitalize list-unstyled">
                        <li>
                            <a class="active" href="#home" data-slide="intro">{{trans('langFront.home')}}</a>
                            <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none">
                                            <circle cx="13.116" cy="12.815" r="3.358"/>
                                            <path
                                                    d="M1.8659999999999997,12.815a11.25,11.25 0 1,0 22.5,0a11.25,11.25 0 1,0 -22.5,0"
                                                    stroke="#ad966d"/>
                                        </svg>
                                    </span>
                        </li>
                        <li>
                            <a href="#about" data-slide="about">{{trans('langFront.about_us')}}</a>
                            <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none">
                                            <circle cx="13.116" cy="12.815" r="3.358"/>
                                            <path
                                                    d="M1.8659999999999997,12.815a11.25,11.25 0 1,0 22.5,0a11.25,11.25 0 1,0 -22.5,0"
                                                    stroke="#ad966d"/>
                                        </svg>
                                    </span>
                        </li>

                        <li>
                            <a href="#resume" data-slide="resume">{{trans('langFront.resumes')}}</a>
                            <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none">
                                            <circle cx="13.116" cy="12.815" r="3.358"/>
                                            <path
                                                    d="M1.8659999999999997,12.815a11.25,11.25 0 1,0 22.5,0a11.25,11.25 0 1,0 -22.5,0"
                                                    stroke="#ad966d"/>
                                        </svg>
                                    </span>
                        </li>
                        <li>
                            <a href="#services" data-slide="services">{{trans('langFront.service')}}</a>
                            <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none">
                                            <circle cx="13.116" cy="12.815" r="3.358"/>
                                            <path
                                                    d="M1.8659999999999997,12.815a11.25,11.25 0 1,0 22.5,0a11.25,11.25 0 1,0 -22.5,0"
                                                    stroke="#ad966d"/>
                                        </svg>
                                    </span>
                        </li>
                        <li>
                            <a href="#portfolio" data-slide="portfolio">{{trans('langFront.portfolios')}}</a>
                            <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none">
                                            <circle cx="13.116" cy="12.815" r="3.358"/>
                                            <path
                                                    d="M1.8659999999999997,12.815a11.25,11.25 0 1,0 22.5,0a11.25,11.25 0 1,0 -22.5,0"
                                                    stroke="#ad966d"/>
                                        </svg>
                                    </span>
                        </li>
                        <li>
                            <a href="#blog" data-slide="blog">{{trans('langFront.blog')}}</a>
                            <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none">
                                            <circle cx="13.116" cy="12.815" r="3.358"/>
                                            <path
                                                    d="M1.8659999999999997,12.815a11.25,11.25 0 1,0 22.5,0a11.25,11.25 0 1,0 -22.5,0"
                                                    stroke="#ad966d"/>
                                        </svg>
                                    </span>
                        </li>
                        <li>
                            <a href="#why-me" data-slide="why-me">{{trans('langFront.comments')}}</a>
                            <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none">
                                            <circle cx="13.116" cy="12.815" r="3.358"/>
                                            <path
                                                    d="M1.8659999999999997,12.815a11.25,11.25 0 1,0 22.5,0a11.25,11.25 0 1,0 -22.5,0"
                                                    stroke="#ad966d"/>
                                        </svg>
                                    </span>
                        </li>
                        <li>
                            <a href="#contact" data-slide="contact">{{trans('langFront.contact')}} </a>
                            <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="none">
                                            <circle cx="13.116" cy="12.815" r="3.358"/>
                                            <path
                                                    d="M1.8659999999999997,12.815a11.25,11.25 0 1,0 22.5,0a11.25,11.25 0 1,0 -22.5,0"
                                                    stroke="#ad966d"/>
                                        </svg>
                                    </span>
                        </li>
                    </ul>
                    <div 
                    
                                 
                                    class="company">{{ \App\Model\Settings::getSettingName('')}}</span></span>
                                    
                    </div>
                </div>
            </nav>
        </aside>
        <div class="aside-section container col-12 col-sm-10 pl-sm-4">
            <section id="intro" class="intro first">
                <div class="container">
                    <div class="row">
                        <div class="intro-content col-md-6 d-flex">
                            <div class="my-infos w-100">
                                <div class="greeting my-5 mt-sm-0"><h2
                                            class="display-3">{{(isset($data['settings']['slideTitle']))?$data['settings']['slideTitle']:''}}</h2>
                                </div>
                                <div class="me my-5"><h1
                                            class="i-am"></h1> {{(isset($data['settings']['slideExpertise']))?$data['settings']['slideExpertise']:''}}
                                </div>
                                <div class="btns my-2">
                                    <a href="/{{(isset($data['settings']['resume']))?$data['settings']['resume']:''}}"
                                       target="_blank">
                                        <button
                                                class="btn btn-light btn-cv mr-4 mb-3">{{trans('langFront.download')}}</button>
                                    </a>

                                </div>
                                <div class="sm-links mt-5">
                                    <ul class="list-unstyled list-inline">
                                        @if(isset($data['settings']['facebook'])  and !empty($data['settings']['facebook']))
                                            <li class="list-inline-item mr-3 mr-md-4">
                                                <a href="{{$data['settings']['facebook']}}" aria-label="facebook link">
                                                    <div class="fab fa-facebook-f fa-lg"></div>
                                                </a>
                                            </li>
                                        @endif
                                        @if(isset($data['settings']['twitter']) and !empty($data['settings']['twitter']))
                                            <li class="list-inline-item m-3 m-md-4">
                                                <a href="{{$data['settings']['twitter']}}" aria-label="twitter link"><i
                                                            class="fab fa-twitter fa-lg"></i></a>
                                            </li>
                                        @endif
                                        @if(isset($data['settings']['linkedin']) and !empty($data['settings']['linkedin']))
                                            <li class="list-inline-item m-3 m-md-4">
                                                <a href="{{$data['settings']['linkedin']}}" aria-label="linked-in link"><i
                                                            class="fab fa-linkedin-in fa-lg"></i></a>
                                            </li>
                                        @endif
                                        @if(isset($data['settings']['instagram']) and !empty($data['settings']['instagram']))
                                            <li class="list-inline-item ml-3 ml-md-4">
                                                <a href="{{$data['settings']['instagram']}}"
                                                   aria-label="instagram link"><i
                                                            class="fab fa-instagram fa-lg"></i></a>
                                            </li>
                                        @endif
                                        @if(isset($data['settings']['telegram']) and !empty($data['settings']['telegram']))
                                            <li class="list-inline-item ml-3 ml-md-4">
                                                <a href="{{$data['settings']['telegram']}}"
                                                   aria-label="telegram link"><i class="fab fa-telegram fa-lg"></i></a>
                                            </li>
                                        @endif

                                        @if(isset($data['settings']['github']) and !empty($data['settings']['github']))
                                            <li class="list-inline-item ml-3 ml-md-4">
                                                <a href="{{$data['settings']['github']}}" aria-label="github link"><i
                                                            class="fab fa-github fa-lg"></i></a>
                                            </li>
                                        @endif

                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="my-pic col-md-6 d-flex px-0 text-center">
                            <div class="pic-wrapper px-0 position-relative m-auto">
                                <div class="pic-border">
                                    <div class="pic-bg"><img
                                                src="{{(isset($data['settings']['slideImg']))?$data['settings']['slideImg']:''}}"
                                                alt="my pic" class="img-fluid rounded-circle"/></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="scroll-down position-fixed"><img src="/Front/images/arrow-down.svg " alt="scroll down"/>
                </div>
            </section>
            <section id="about" class="about">
                <div class="container">
                    <div class="about-content row">
                        <div class="col-md-6 col-sm-12 infos">
                            <div class="title mb-4">
                                <h1><span>{{trans('langFront.about_us')}}</span></h1>
                            </div>
                            <div class="text-content mb-4">
                                <p>
                                    {{(isset($data['settings']['slideExpertise']))?$data['settings']['slideExpertise']:''}}
                                </p>

                            </div>
                            <div class="btns mt-5">
                                <a href="/{{(isset($data['settings']['resume']))?$data['settings']['resume']:''}}"
                                   target="_blank"
                                   class="btn mr-5 mb-3 btn-light btn-cv">{{trans('langFront.download')}}</a>
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12 pl-4 pl-lg-5 more-details">
                            <ul class="list-unstyled">
                                <li class="my-5 pt-4 pb-2">
                                    <i class="fas fa-user-tie mr-3 mr-lg-5 fa-lg"></i> <span><span class="mr-4 label">{{trans('langFront.birth_date')}} :</span><span>{{(isset($data['user']->birth_date))?$data['user']->birth_date:''}}</span></span>
                                </li>
                                <li class="my-5 py-2">
                                    <i class="fas fa-paper-plane mr-3 mr-lg-5 fa-lg"></i> <span><span
                                                class="mr-4 label">{{trans('langFront.email')}}:</span><a
                                                href="mailto:{{(isset($data['user']->email))?$data['user']->email:''}}">{{(isset($data['user']->email))?$data['user']->email:''}}</a></span>
                                </li>
                                <li class="my-5 py-2">
                                    <i class="fas fa-phone-alt mr-3 mr-lg-5 fa-lg"></i> <span><span class="mr-4 label">{{trans('langFront.phone')}} ::</span><a
                                                href="tel:{{(isset($data['user']->tel))?$data['user']->tel:''}}">{{(isset($data['user']->tel))?$data['user']->tel:''}}</a></span>
                                </li>
                                <li class="my-5 py-2">
                                    <i class="fas fa-map-marker-alt mr-3 mr-lg-5 fa-lg"></i> <span><span
                                                class="mr-4 label">{{trans('langFront.address')}}:</span><span>{{(isset($data['user']->address))?$data['user']->address:''}}</span></span>
                                </li>
                                <li class="my-5 py-2">
                                    <i class="fas fa-briefcase mr-3 mr-lg-5 fa-lg"></i> <span><span class="mr-4 label">{{trans('langFront.mobile')}} :</span><span>{{(isset($data['user']->mobile))?$data['user']->mobile:''}}</span></span>
                                </li>
                            </ul>
                            <div class="sm-links">

                                <ul class="list-unstyled list-inline social-media">
                                    @if(isset($data['settings']['facebook'])  and !empty($data['settings']['facebook']))
                                        <li class="list-inline-item mr-5 mr-md-5">
                                            <a href="{{$data['settings']['facebook']}}">
                                                <div class="fab fa-facebook-f fa-lg"></div>
                                            </a>
                                        </li>
                                    @endif
                                    @if(isset($data['settings']['twitter']) and !empty($data['settings']['twitter']))
                                        <li class="list-inline-item mr-5 mr-md-5">
                                            <a href="{{$data['settings']['twitter']}}"><i
                                                        class="fab fa-twitter fa-lg"></i></a>
                                        </li>
                                    @endif
                                    @if(isset($data['settings']['linkedin']) and !empty($data['settings']['linkedin']))
                                        <li class="list-inline-item mr-5 mr-md-5">
                                            <a href="{{$data['settings']['linkedin']}}"><i
                                                        class="fab fa-linkedin-in fa-lg"></i></a>
                                        </li>
                                    @endif
                                    @if(isset($data['settings']['instagram']) and !empty($data['settings']['instagram']))
                                        <li class="list-inline-item mr-5 mr-md-5">
                                            <a href="{{$data['settings']['instagram']}}"><i
                                                        class="fab fa-instagram fa-lg"></i></a>
                                        </li>
                                    @endif
                                    @if(isset($data['settings']['telegram']) and !empty($data['settings']['telegram']))
                                        <li class="list-inline-item mr-5 mr-md-5">
                                            <a href="{{$data['settings']['telegram']}}"><i
                                                        class="fab fa-telegram fa-lg"></i></a>
                                        </li>
                                    @endif

                                    @if(isset($data['settings']['github']) and !empty($data['settings']['github']))
                                        <li class="list-inline-item ">
                                            <a href="{{$data['settings']['github']}}"><i
                                                        class="fab fa-github fa-lg"></i></a>
                                        </li>
                                    @endif

                                </ul>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="resume" class="resume">
                <div class="container">
                    <div class="resume-content m-auto row">
                        <div class="col-12 skills mb-5 res-card">
                            <div class="row">
                                <div class="col-12 my-4">
                                    <div class="icon d-inline-block position-relative"><i
                                                class="fas fa-pencil-ruler fa-2x"></i></div>
                                    <h1 class="d-inline-block res-title ml-1">{{trans('langFront.skill')}}</h1>
                                </div>

                                @if(isset($data['skill'][0]))
                                    @foreach($data['skill'][0] as $item)
                                        <div class="skill ml-4 col-md-4 my-4">
                                            <div class="d-block"><h3>{{$item['title']}}</h3></div>
                                            <div class="skill-perc">
                                                <div class="progress">
                                                    <div class="progress-bar" style="width: {{$item['percent']}}%;"
                                                         role="progressbar" aria-valuenow="{{$item['percent']}}"
                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif

                                @if(isset($data['skill'][1]))
                                    @foreach($data['skill'][1] as $item)
                                        <div class="skill ml-4 col-md-4 my-4">
                                            <div class="d-block"><h3>{{$item['title']}}</h3></div>
                                            <div class="skill-perc">
                                                <div class="progress">
                                                    <div class="progress-bar" style="width: {{$item['percent']}}%;"
                                                         role="progressbar" aria-valuenow="{{$item['percent']}}"
                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif


                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12 education my-5 res-card">
                            <div class="row">
                                <div class="col-12 mb-4">
                                    <div class="icon d-inline-block position-relative"><i
                                                class="fas fa-graduation-cap fa-2x"></i></div>
                                    <h2 class="d-inline-block res-title">{{trans('langFront.resumesEdu')}}</h2>
                                </div>

                                <div class="time-line pl-4 col-12">
                                    @foreach($data['resumesEdu'] as $item)
                                        <div class="time-box-wrapper">
                                            <div class="time-box">
                                                <div class="end-date"><span>{{$item->end_date}}</span></div>
                                                <div class="job"><span class="role">{{$item->title}}</span></div>
                                                <div class="more-details"><p>{!! $item->text !!}</p></div>
                                                <div class="start-date"><span>{{$item->start_date}}</span></div>
                                            </div>
                                        </div>
                                    @endforeach

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12 experience my-5 res-card">
                            <div class="row">
                                <div class="col-12 mb-4">
                                    <div class="icon d-inline-block position-relative"><i
                                                class="fas fa-seedling fa-2x"></i></div>
                                    <h2 class="d-inline-block res-title ml-1">{{trans('langFront.resumesJobs')}}</h2>
                                </div>
                                <div class="time-line pl-4 col-12">
                                    @foreach($data['resumesJobs'] as $item)
                                        <div class="time-box-wrapper">
                                            <div class="time-box">
                                                <div class="end-date"><span>{{$item->end_date}}</span></div>
                                                <div class="job"><span class="role">{{$item->title}}</span></div>
                                                <div class="more-details"><p>{!! $item->text !!}</p></div>
                                                <div class="start-date"><span>{{$item->start_date}}</span></div>
                                            </div>
                                        </div>
                                    @endforeach

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="services" class="services">
                <div class="container">
                    <div class="services-content row">
                        <div class="title col-12 mb-4">
                            <h1><span>{{trans('langFront.services')}}</span></h1>
                        </div>
                        <div class="col-12 row my-3 ser-cards">


                            @foreach($data['Services'] as $Services)
                                <div class="col-md-4 my-3 ser-card position-relative">
                                    <div class="card border-0 px-2 py-4">
                                        <div class="card-header border-0 p-0 mb-3">
                                            <div class="icon d-inline-block"><img src="{{$Services->image}}"></div>
                                            <div class="card-title d-inline-block text-align-right">
                                                <h3>{{$Services->title}}</h3></div>
                                        </div>
                                        <div class="text-content d-block"><p>{{$Services->text}}</p></div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </section>
            <section id="portfolio" class="portfolio">
                <div class="container">
                    <div class="portfolio-content row">
                        <div class="title col-12 mb-4">
                            <h1><span>{{trans('langFront.portfolios')}}</span></h1>
                        </div>
                        <div class="col-12 mt-5">
                            <div class="portfolio-controls mb-4">
                                <button class="prev" style="    right: calc(50% + 2rem);left: unset;">
                                    <svg width="13" height="28" viewbox="0 0 13 28" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12.1387 0.752075L0.74494 13.9719L12.1387 27.1918" stroke="black"
                                              stroke-opacity="0.7"/>
                                    </svg>
                                </button>
                                <button class="next" style="    right: calc(50% - 2rem);">
                                    <svg width="13" height="29" viewbox="0 0 13 29" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M0.584961 1.28015L11.9787 14.5L0.584961 27.7199" stroke="black"
                                              stroke-opacity="0.7"/>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <div class="work-cards col-12">
                            <div class="owl-carousel blog-cards " id="owl-carousel2">

                                @foreach($data['Portfolio'] as $Portfolio)

                                    <div>
                                        <div id="tns3-mw" class="tns-ovh" onclick="portfolio({{$Portfolio->id}})">
                                            <div class="tns-inner" id="tns3-iw">
                                                <div
                                                        class="work-slider slider  tns-slider tns-carousel tns-subpixel tns-calc tns-horizontal"
                                                        id="tns3"
                                                        style="transition-duration: 0s; transform: translate3d(0%, 0px, 0px);">
                                                    <a href="#" class="work-card tns-item tns-slide-active"
                                                       id="tns3-item0"
                                                       dideo-checked="true">
                                                        <div class="card-wrapper" data-posttype="portfolio">
                                                            <div class="content">
                                                                <div class="img"
                                                                     style="background-image: url('{{$Portfolio->image}}');"></div>
                                                                <div class="text-content">
                                                                    <div class="wrapper">
                                                                        <div class="category mt-md-5 my-sm-1">
                                                                            <span>{{$Portfolio->category_id}} </span>
                                                                        </div>
                                                                        <h4 class="mb-1">{{$Portfolio->title}}</h4>
                                                                        <div class="more d-inline-block mt-2">
                                                                            <span class="mr-2">بیشتر</span>
                                                                            <svg class="svg-icon" viewBox="0 0 20 20">
                                                                                <path fill="none" d="M18.271,9.212H3.615l4.184-4.184c0.306-0.306,0.306-0.801,0-1.107c-0.306-0.306-0.801-0.306-1.107,0
	L1.21,9.403C1.194,9.417,1.174,9.421,1.158,9.437c-0.181,0.181-0.242,0.425-0.209,0.66c0.005,0.038,0.012,0.071,0.022,0.109
	c0.028,0.098,0.075,0.188,0.142,0.271c0.021,0.026,0.021,0.061,0.045,0.085c0.015,0.016,0.034,0.02,0.05,0.033l5.484,5.483
	c0.306,0.307,0.801,0.307,1.107,0c0.306-0.305,0.306-0.801,0-1.105l-4.184-4.185h14.656c0.436,0,0.788-0.353,0.788-0.788
	S18.707,9.212,18.271,9.212z"></path>
                                                                            </svg>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="blog" class="blog">
                <div class="container">
                    <div class="blog-content row">
                        <div class="title col-12 mb-4">
                            <h1><span>{{trans('langFront.bloglast')}}</span></h1>
                        </div>
                        <div class="owl-carousel blog-cards " id="owl-carousel22">

                            @foreach($data['blogs'] as $blog)
                                <div>
                                    <div class="blogs-slider slider" onclick="blogtext({{$blog->id}})">
                                        <a class="post-card" data-posttype="blog">
                                            <div class="card-wrapper">
                                                <div class="card-bg"
                                                     style="background-image: url('{{$blog->image}}');"></div>
                                                <div class="content">
                                                    <h4 class="mb-3">{{$blog->title}}</h4>
                                                    <p class="m-0">{!!str_limit($blog->text, $limit = 150, $end = '...') !!}</p>
                                                    <div class="more">
                                                        <span>{{trans('langFront.more')}}...</span>
                                                        <svg width="49" height="12" viewbox="0 0 49 12" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                    d="M0.602699 3.52779C0.40744 3.72306 0.40744 4.03964 0.602699 4.2349L3.78468 7.41688C3.97994 7.61214 4.29652 7.61214 4.49179 7.41688C4.68705 7.22162 4.68705 6.90504 4.49179 6.70977L1.66336 3.88135L4.49179 1.05292C4.68705 0.857658 4.68705 0.541076 4.49179 0.345814C4.29652 0.150552 3.97994 0.150552 3.78468 0.345814L0.602699 3.52779ZM65.1777 3.38135L0.956253 3.38135V4.38135L65.1777 4.38135V3.38135Z"
                                                                    fill="black"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="blogs-controls" style="display: block!important;width: 100%;">
                            <button class="b-next" style="        left: 0.5rem;z-index: 1500">
                                <svg width="13" height="28" viewbox="0 0 13 28" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.1387 0.752075L0.74494 13.9719L12.1387 27.1918" stroke="black"
                                          stroke-opacity="0.7"/>
                                </svg>
                            </button>
                            <button class="b-prev" style="    right: 0.5rem;
    z-index: 1500;">
                                <svg width="13" height="29" viewbox="0 0 13 29" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M0.584961 1.28015L11.9787 14.5L0.584961 27.7199" stroke="black"
                                          stroke-opacity="0.7"/>
                                </svg>
                            </button>
                        </div>
                        <!--                        </div>-->
                    </div>
                </div>
            </section>
            <section id="why-me" class="why-me">
                <div class="container">
                    <div class="why-me-content">
                        <div class="statistics row">
                            @php $i=0;@endphp
                            @foreach($data['counters'] as $item)
                                @if($i==0)
                                    <div class="col-md-2 col-sm-12 p-0">
                                        <div class="sts">
                                            <div class="numb d-inline-block"><p class="m-0 pr-1">{{$item->number}}</p>
                                            </div>
                                            <div class="icon d-inline-block position-relative"><img
                                                        src="/{{$item->image}}"></div>
                                            <div class="text"><p class="m-0">{{$item->title}}</p></div>
                                        </div>
                                    </div>
                                @else
                                    @if($i==1)
                                        <div class="col-md-3 d-none d-md-block sts-line line-one"><span></span></div>
                                    @else
                                        <div class="col-md-3 d-none d-md-block sts-line line-two p-0"><span></span>
                                        </div>
                                    @endif
                                    <div class="col-md-2 col-sm-12 my-5 my-md-0 p-0">
                                        <div class="sts">
                                            <div class="numb d-inline-block"><p class="m-0 pr-1"></p></div>
                                            <div class="icon d-inline-block position-relative"><img
                                                        src="/{{$item->image}}"></div>
                                            <div class="text"><p class="m-0">{{$item->title}}</p></div>
                                        </div>
                                    </div>
                                @endif
                                @php $i++;@endphp
                            @endforeach
                        </div>
                        <div class="title col-12 mb-4 text-center my-5 py-5">
                            <h1 class="m-auto d-inline-block"><span>{{trans('langFront.comments')}}</span></h1>
                        </div>
                        <div class="testimonials col-12">
                            <div class="owl-carousel blog-cards " id="owl-about">
                                @foreach($data['Comment'] as $Comment)
                                    <div>
                                        <div class="testimonial-cards ">
                                            <div class="testimonials-slider slider">
                                                <div class="tsm-card">
                                                    <div class="tsm-wrapper text-center">
                                                        <div class="image mb-3"><img src="{{$Comment->image}}"
                                                                                     alt="{{$Comment->fullname}}"/>
                                                        </div>
                                                        <p class="name m-1">{{$Comment->fullname}}</p>
                                                        <p class="job"></p>
                                                        <p class="quote">
                                                            {{$Comment->text}}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="contact" class="contact">
                <div class="container">
                    <div class="contact-content overflow-hidden">
                        <div class="row">
                            <div class="title col-12 mb-4">
                                <h1><span>{{trans('langFront.contact')}}</span></h1>
                            </div>
                            <div class="col-md-5 col-sm-12 px-4 more-details">
                                <ul class="list-unstyled">
                                    <li class="my-5">
                                        <i class="fas fa-paper-plane mr-2 mr-lg-5 fa-lg"></i> <span><span
                                                    class="mr-4 label">{{trans('langFront.email')}}:</span> <a
                                                    href="mailto:{{(isset($data['user']->email))?$data['user']->email:''}}">{{(isset($data['user']->email))?$data['user']->email:''}}</a></span>
                                    </li>
                                    <li class="my-5">
                                        <i class="fas fa-phone-alt mr-2 mr-lg-5 fa-lg"></i> <span><span
                                                    class="mr-4 label">{{trans('langFront.phone')}}:</span><a
                                                    href="tel:{{(isset($data['user']->tel))?$data['user']->tel:''}}">{{(isset($data['user']->tel))?$data['user']->tel:''}}</a></span>
                                    </li>
                                    <li class="my-5">
                                        <i class="fas fa-map-marker-alt mr-2 mr-lg-5 fa-lg"></i> <span><span
                                                    class="mr-4 label">{{trans('langFront.address')}}:</span><span>{{(isset($data['user']->address))?$data['user']->address:''}}</span></span>
                                    </li>
                                </ul>
                                <div class="sm-links">

                                    <ul class="list-unstyled list-inline social-media d-flex">
                                        @if(isset($data['settings']['facebook'])  and !empty($data['settings']['facebook']))
                                            <li class="list-inline-item mr-5 mr-md-5">
                                                <a href="{{$data['settings']['facebook']}}">
                                                    <div class="fab fa-facebook-f fa-lg"></div>
                                                </a>
                                            </li>
                                        @endif
                                        @if(isset($data['settings']['twitter']) and !empty($data['settings']['twitter']))
                                            <li class="list-inline-item ">
                                                <a href="{{$data['settings']['twitter']}}"><i
                                                            class="fab fa-twitter fa-lg"></i></a>
                                            </li>
                                        @endif
                                        @if(isset($data['settings']['linkedin']) and !empty($data['settings']['linkedin']))
                                            <li class="list-inline-item ">
                                                <a href="{{$data['settings']['linkedin']}}"><i
                                                            class="fab fa-linkedin-in fa-lg"></i></a>
                                            </li>
                                        @endif
                                        @if(isset($data['settings']['instagram']) and !empty($data['settings']['instagram']))
                                            <li class="list-inline-item ">
                                                <a href="{{$data['settings']['instagram']}}"><i
                                                            class="fab fa-instagram fa-lg"></i></a>
                                            </li>
                                        @endif
                                        @if(isset($data['settings']['telegram']) and !empty($data['settings']['telegram']))
                                            <li class="list-inline-item ">
                                                <a href="{{$data['settings']['telegram']}}"><i
                                                            class="fab fa-telegram fa-lg"></i></a>
                                            </li>
                                        @endif

                                        @if(isset($data['settings']['github']) and !empty($data['settings']['github']))
                                            <li class="list-inline-item ">
                                                <a href="{{$data['settings']['github']}}"><i
                                                            class="fab fa-github fa-lg"></i></a>
                                            </li>
                                        @endif

                                    </ul>

                                </div>
                            </div>
                            <div class="offset-sm-0 offset-md-1 col-md-6 mt-sm-5 contact-form for-form">
                                <img class="dots-bg dots-top d-none" src="/Front/images/dots-2.svg" alt="dots-bg"/>
                                <form method="POST" action="{{route('contacts.store')}}"
                                      id="contact_form2">

                                    <input id="_token" type="hidden" name="_token" value="<?php echo csrf_token(); ?>">
                                    <div class="form-row">
                                        <div class="col-6 my-3 my-md-0"><input name="fullname" id="fullname"
                                                                               placeholder="{{trans('langFront.name')}}*"
                                                                               class="form-control mb-2"/></div>
                                        <div class="col-6 my-3 my-md-0"><input name="subject" id="subject"
                                                                               class="form-control mb-2"
                                                                               placeholder="{{trans('langFront.subject')}}*"/>
                                        </div>
                                        <div class="col-12 my-3 my-md-4 my-md-3"><input id="email" type="email"
                                                                                        name="email"
                                                                                        placeholder="{{trans('langFront.email')}}*"
                                                                                        class="form-control mb-2"/>
                                        </div>
                                        <div class="col-12 my-3"><textarea id="message" class="form-control"
                                                                           name="message"
                                                                           placeholder="{{trans('langFront.text')}}..."></textarea>
                                        </div>

                                        <div class="col-12 mt-3 mt-md-5">
                                            <button type="submit">{{trans('langFront.send')}} <i
                                                        class="send_icon fas fa-paper-plane"></i> <i
                                                        class="sending fas fa-spinner fa-spin d-none"></i></button>
                                        </div>
                                    </div>
                                </form>
                                <img class="dots-bg dots-bottom d-none" src="/Front/images/dots-2.svg" alt="dots-bg"/>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <section class="single-post position-absolute w-100 h-100 d-none">
            <div class="container-fluid top-nav py-3" style="    height: 100vh;
    overflow: scroll;">
                <div class="col-md-12">
                    <div class="logo float-left">{{ \App\Model\Settings::getSettingName('titleSite')}} </div>
                    <div class="close float-right"><img src="/Front/images/close.svg" alt="close"/></div>
                    <div class="clearfix"></div>
                    <div class="row">
                        <div class="container mt-4">
                            <div class="single-blog-content">
                                <div class="container blog-container">
                                    <div class="blog-head col-12 mb-4 text-center">
                                        <div class="tag"><a href="#">لورم</a></div>
                                        <h1 class="title"> لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت
                                            چاپ</h1>
                                        <div class="date">
                                            {{--                                            <i class="fas fa-calendar-alt mr-2"></i><span>1396</span>--}}
                                        </div>
                                    </div>
                                    <div class="blog-body my-4">
                                        <div style="background-image: url('./images/blog-2.jpg')"
                                             class="img-thumbnail text-center border-0"></div>
                                        <div class="blog-text px-4">

                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row px-4 comment-b">
                                        <div class="comment-head col-12 mt-1 mb-2">
                                            <h2 class="text-center">
                                                نظرات
                                            </h2>
                                        </div>
                                        <div class="blog-comments col-12 my-4">
                                            <div class="comments-media">
                                                <div class="media my-4">
                                                    <img class="mr-3" height="64" width="64" src="images/face2.jpg"
                                                         alt="User Picture">
                                                    <div class="media-body">
                                                        <h5>لورم</h5>
                                                        <span class="date">1398</span>
                                                        <p>
                                                            لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ.
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="comment-form">
                                                <form method="POST" action="{{route('comments.store',1)}}">
                                                    @CSRF
                                                    <div class="form-row">
                                                        <div class="col-12 my-2">
                                                            <textarea name="text" id="blog-comments" rows="4"
                                                                      class="form-control"
                                                                      placeholder="متن پیام را وارد کنید"></textarea>
                                                        </div>
                                                        <div class="col-md-6 col-sm-12 my-2">
                                                            <input name="fullname" id="blog-name" type="text"
                                                                   placeholder=" نام خود را وارد کنید*" required=""
                                                                   class="form-control mb-2">
                                                        </div>
                                                        <div class="col-sm-12 col-md-6 my-2">
                                                            <input name="email" id="blog-email" type="email"
                                                                   placeholder="ایمیل را وارد کنید*" required=""
                                                                   class="form-control mb-2">
                                                        </div>

                                                        <div class="col-12">
                                                            <button type="submit">{{trans('langFront.send')}}</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr class="line-separate">
                            </div>
                            <div class="go-back my-5 ml-4">
                                <!--<div class="icon d-inline-block">-->
                                <!--    <svg width="66" height="8" viewBox="0 0 49 12" fill="none"-->
                                <!--         xmlns="http://www.w3.org/2000/svg">-->
                                <!--        <path-->
                                <!--            d="M48.6763 6.53033C48.9692 6.23744 48.9692 5.76257 48.6763 5.46967L43.9034 0.696703C43.6105 0.40381 43.1356 0.403809 42.8427 0.696703C42.5498 0.989596 42.5498 1.46447 42.8427 1.75736L47.0853 6L42.8427 10.2426C42.5498 10.5355 42.5498 11.0104 42.8427 11.3033C43.1356 11.5962 43.6105 11.5962 43.9034 11.3033L48.6763 6.53033ZM0.145996 6.75L48.146 6.75L48.146 5.25L0.145996 5.25L0.145996 6.75Z"-->
                                <!--            fill="black"></path>-->
                                <!--    </svg>-->
                                <!--</div>-->
                                <!--<span>برگشت</span>-->
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
    </div>

@endsection
