@extends('Layouts.adminLayout')
@section('title')
    |{{trans('langPanel.resumeList')}}
@endsection
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/vendors/css/extensions/sweetalert2.min.css') }}">
@endsection
@section('content')



    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body">
                <!-- Dashboard Analytics Start -->
                <section id="dashboard-analytics">

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                @include('Layouts.msg')

                                <div class="card-header">
                                    <h4 class="mb-0">{{trans('langPanel.resumeList')}}</h4>
                                </div>
                                <div class="card-content">
                                    <div class="table-responsive mt-1">
                                        <table class="table table-hover-animation mb-0  data-list-view">
                                            <thead>
                                            <tr>

                                                <th>{{trans('langPanel.index')}}</th>
                                                <th>{{trans('langPanel.title')}}</th>
                                                <th>{{trans('langPanel.start_date')}}</th>
                                                <th>{{trans('langPanel.end_date')}}</th>
                                                <th>{{trans('langPanel.Possibilities')}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>

                                            @php $i=1; @endphp
                                            @foreach($data['Resumes'] as $value)
                                                <tr>
                                                    <td>{{$i++}}</td>
                                                    <td>{{$value->title}}</td>
                                                    <td>{{$value->start_date}}</td>
                                                    <td>{{$value->end_date}}</td>

                                                    <td>

                                                        <a href="{{route('Admin.resumes.edit',$value->id)}}"
                                                           type="button"
                                                           class="btn btn-icon  rounded-circle btn-warning mr-1 mb-1 waves-effect waves-light"><i
                                                                class="feather icon-edit"></i></a>

                                                        <a onclick="deleteRecord('{{route('Admin.resumes.destroy',$value->id)}}')"
                                                           type="button"
                                                           class="btn btn-icon rounded-circle btn-danger mr-1 mb-1 waves-effect waves-light"><i
                                                                class="feather icon-delete"></i></a>

                                                    </td>
                                                </tr>

                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- Dashboard Analytics end -->

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('Admin/app-assets/vendors/js/extensions/sweetalert2.all.min.js')}}"></script>
    <script src="{{ asset('Admin/app-assets/js/scripts/extensions/sweet-alerts.js')}}"></script>

@endsection
