<?php

namespace App\Model;
use Faker\Provider\File;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Blog extends Model
{
    protected $table = 'blogs';
    public $timestamps = true;


   public static function store($data)
    {
		try {
        $Blog=new Blog();
        $Blog->text=$data['text'];
        $Blog->title=$data['title'];
        $Blog->author_name=$data['author_name'];
        $Blog->image=$data['image'];
        $Blog->save();
		return true;
		  } catch (\Exception $e) {
            return $e->getMessage();
        }
	}
   public static function getBlogs(){
        $Blogs=Blog::all();
        return $Blogs;
    }
	
 public static function getBlog($id){
	 
        $Blog=Blog::find($id);
		 if($Blog!=null)
            return $Blog;
        else
            return "";

    }
	
	 public static function BlogDelete($id){
		 
		  try {
            $Blog = Blog::getBlog($id);
            if (\Illuminate\Support\Facades\File::exists($Blog->image)) {
                \Illuminate\Support\Facades\File::delete($Blog->image);
            }
            $Blog->delete();
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }

    }
	
	 public static function updateBlog($data,$id){
		 try {
         $Blog=Blog::find($id);
         $Blog->text=$data['text'];
        $Blog->title=$data['title'];
        $Blog->author_name=$data['author_name'];
        $Blog->image=$data['image'];
        $Blog->update();
		     return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
	
	
}

