<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class Counters extends FormRequest
{

    protected $rules = [
        'title' => 'required:max:30',
        'file' => 'required|image|dimensions:max_width:37,max_height:37',
        'number' => 'required|max:250',
    ];

    public function authorize()
    {
        if (\Request::route()->getName() == "Admin.counters.update") {
            $this->rules['file'] = 'nullable';
        }

        return true;
    }

    public function rules()
    {
        return $this->rules;
    }
}
