
<?php
$image = get_field('clients_img', 'option');
$title = get_field('clients_title', 'option');
$text = get_field('clients_text', 'option');
?>
<section class="clients-section" id="home-clients">

    <div class="container-lg">
        <div class="row align-items-center">
            <div class="col-12 col-sm-6 mx-auto col-md-4">
                <?php if($image) { ?>
                    <div class="image">
                        <img
                            src="<?php echo $image['url']; ?>"
                            width="<?php echo $image['width']; ?>"
                            height="<?php echo $image['height']; ?>"
                            alt="<?php echo $image['alt']; ?>" />
                    </div>
                <?php } ?>
            </div>
            <div class="col-12 col-md-8">
                <div class="clients-content">
                    <div class="clients-title wow fadeInUp" data-wow-delay="0.25s">
                        <div class="clients-icon"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/client.png" width="60" height="60" alt="client"></div>
                        <h3 class="title"><?php echo $title; ?></h3>
                    </div>
                    <div class="clients-content_inner d-flex position-relative">
                        <div class="text wow fadeInUp" data-wow-delay="0.5s">
                            <?php echo $text; ?>
                        </div>
                        
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/image_shape.png" draggable="false" class="absolute bottom-0 right-0 2xl:-right-20 hidden sm:block">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
