<?php
/* Template Name: Contact */
get_header();
$post_thumbnail_id = get_post_thumbnail_id( get_the_ID() );
$post_thumbnail_url = wp_get_attachment_image_url( $post_thumbnail_id, 'full' );

$map_code = get_field('map-code');
$contact_phone = get_field('contact_phone', 'options');
$contact_email = get_field('contact_email', 'options');
$contact_address = get_field('contact_address', 'options');
?>
<div class="page-header" style="background:transparent url(<?php echo $post_thumbnail_url;?>) center no-repeat">
    <div class="page-header-overlay"></div>
    <div class="container">
        <div class="row">
            <div class="col-12 page-head">
                <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo get_the_title(); ?>
                </h1>
                <?php get_template_part('templates/content/breadcrumb'); ?>
            </div>
        </div>
    </div>
</div>
<div class="page-wrap contact_page">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 col-md-8 mx-auto page-inner-head text-center">
                <?php
                    echo '<span class="sub-title wow fadeInUp" data-wow-delay="0.25s">Contact info</span>';
                    echo '<h2 class="title wow fadeInUp" data-wow-delay="0.25s"><span>Reach</span> Out to US</h2>';
                ?>
            </div>
    
            <div class="col-12 col-lg-10 mx-auto">
                <div class="row contact-info-box mt-5 mb-5">
                    <?php
                        if ($contact_address != '') {
                            echo '<div class="col-12 col-md-6 wow fadeInUp" data-wow-delay="0.75s">
                                <div class="contact-item">
                                    <span class="contact-icon"><i class="icon-location"></i></span>
                                    <div class="contact-inner d-flex flex-column">
                                        <h3 class="contact-title">Our Location</h3>
                                        <p>' . $contact_address . '</p>
                                        <p>International Representative:
Liligate Digital — Istanbul, Turkey</p>
                                    </div>
                                </div>
                            </div>';
                        }
                        
                        if ($contact_phone != '') {
                    echo '<div class="col-12 col-md-6"><div class="row h-100"><div class="col-12 col-sm-6 wow fadeInUp" data-wow-delay="0.5s">
                                <div class="contact-item">
                                    <span class="contact-icon"><i class="icon-phone"></i></span>
                                    <div class="contact-inner d-flex flex-column">
                                        <h3 class="contact-title">Call us</h3>
                                        <a class="ltr" href="tel:' . $contact_phone . '">' . $contact_phone . '</a>
                                    </div>
                                </div>
                            </div>';
                        }
                        if ($contact_email != '') {
                            echo '<div class="col-12 col-sm-6 wow fadeInUp" data-wow-delay=""0.75s">
                                <div class="contact-item">
                                    <span class="contact-icon"><i class="icon-email"></i></span>
                                    <div class="contact-inner d-flex flex-column">
                                        <h3 class="contact-title">Email us</h3>
                                        <a href="mailto:' . $contact_email . '">' . $contact_email . '</a>
                                    </div>
                                </div>
                            </div></div></div>';
                        }
                    ?>
                </div>
            </div>
        </div>
    </div>


    <section class="contact-form-section position-relative">
        <div class="container-lg">
            <div class="row mb-5">
                <div class="col-12 col-md-6">
                    <?php
                    echo '<div class="contact-form-wrap">';
                    echo '<h4 class="section-title">Feel Free to Get in Touch or Visit our Location.</h4>';
                    echo do_shortcode('[contact-form-7 id="ec9b648" title="Contact form 1"]');
                    echo '</div>';
                    ?>
                </div>
                <div class="col-12 col-md-6">
                    <?php if ($map_code != '') { ?>
                        <div class="contact-map">
                            <?php echo $map_code; ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer(); ?>

