<?php
/**
 * Sidebar
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/sidebar.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     1.6.4
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
?>
<div class="sidebar_head d-flex">
    <span class="filter-title">فیلترها</span>
    <div class="close-sidebar">
        <i class="icon-close"></i>
    </div>
</div>
<div class="shop-sidebar">
    <form method="GET" action="">
        <?php
        foreach ($_GET as $key => $value) {
            if ($key !== 'stock_status') {
                echo '<input type="hidden" name="' . esc_attr($key) . '" value="' . esc_attr($value) . '">';
            }
        }
        ?>
        <label class="switch-container" for="switch-input" dir="rtl">
            <input type="checkbox" name="stock_status" value="instock" id="switch-input" class="switch-input" onchange="this.form.submit();"
                <?php if ( isset($_GET['stock_status']) && $_GET['stock_status'] === 'instock' ) echo 'checked'; ?>>
                <span class="switch-slider"></span>
            <span class="switch-label">فقط کالاهای موجود</span>
        </label>
    </form>
    <?php if ((is_active_sidebar('sidebar-woocommerce-filter')) != '') : ?>
        <?php dynamic_sidebar('sidebar-woocommerce-filter'); ?>
    <?php endif; ?>
</div>
