<?php
/* Template Name: Contact */
get_header();
$map_code = get_field('map');
$contact_phone = get_field('phone1');
$contact_phone2 = get_field('phone2');
$contact_mobile = get_field('mobile');
$contact_address = get_field('address');
$contact_desc = get_field('contact_desc');

$section_title = get_field('section_title', 'option');
$section_subtitle = get_field('section_subtitle', 'option');
?>
<div class="page-wrap contact-page">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 col-lg-10 mx-auto">
                <div class="text-center contact-head wow fadeInUp" data-wow-delay="0.25s">
                    <h1 class="section-title">
                        <?php if (get_field('contact_title') != '') {
                            echo get_field('contact_title');
                        } else {
                            echo get_the_title();
                        } ?>
                    </h1>
                    <?php
                        if (get_field('contact_subtitle') != '') {
                            echo '<span class="d-block subtitle">'
                                . get_field('contact_subtitle') .
                           '</span>';
                        }
                    ?>
                </div>
                <div class="row align-items-center contact-top">
                    <div class="col-12 col-lg-6 contact-info-wrap">
                        <div class="contact-info-box">
                            <?php if($contact_desc) { echo '<p class="contact-info-text wow fadeInUp" data-wow-delay="0.5s">'.$contact_desc.'</p>'; } ?>
                            <?php
                                if ($contact_phone != '' || $contact_phone2!='') {
                                    echo '<div class="contact-item d-flex align-items-center wow fadeInUp" data-wow-delay="0.5s">
                                        <span class="contact-label"><i class="icon-phone"></i> تلفن ها:</span>
                                        <div class="contact-inner d-flex">                           
                                            <a class="ltr" href="tel:' . $contact_phone . '">' . $contact_phone . '</a>
                                            <a class="ltr" href="tel:' . $contact_phone2 . '">' . $contact_phone2 . '</a>
                                        </div>
                                    </div>';
                                }

                                if ($contact_mobile != '') {
                                    echo '<div class="contact-item d-flex align-items-center wow fadeInUp" data-wow-delay="0.75s">
                                        <span class="contact-label"><i class="icon-mobile"></i>موبایل:</span>
                                        <p class="mb-0">                                      
                                            <a class="ltr" href="tel:' . $contact_mobile . '">' . $contact_mobile . '</a>
                                        </p>
                                    </div>';
                                }
                                if ($contact_address != '') {
                                    echo '<div class="contact-item d-flex align-items-center wow fadeInUp" data-wow-delay="0.75s">
                                        <span class="contact-label"><i class="icon-location"></i> آدرس:</span>                                        
                                        <p class="mb-0">' . $contact_address . '</p>
                                    </div>';
                                }
                            ?>
                        </div>
                    </div>

                    <?php if ($map_code != '') { ?>
                        <div class="col-12 col-lg-6">
                            <div class="contact-map wow fadeInUp" data-wow-delay="0.5s">
                                <?php echo $map_code; ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>

                <div class="row contact-form">
                    <div class="col-12">
                        <?php echo do_shortcode('[contact-form-7 id="d6f2058" title="Contact form 1"]'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <section class="faq py-48">
        <div class="container-lg">
            <div class="row">
                <div class="col-12 col-md-10 mx-auto">
                    <?php if (have_rows('faq')): ?>
                        <div class="text-center section-head wow fadeInUp" data-wow-delay="0.25s">
                            <?php if ($section_title) {
                                echo '<h2 class="section-title">' . $section_title . '</h2>';
                            } ?>
                            <?php if ($section_subtitle) {
                                echo '<span class="d-block subtitle">' . $section_subtitle . '</span>';
                            } ?>
                        </div>
                        <div class="faq_wrapper accordion" id="faqAccordion">
                            <?php
                            $count = 1;
                            $i = 1;
                            $j = 0.25;
                            $faqjd = '<script type="application/ld+json">
                                    {
                                      "@context": "https://schema.org",
                                      "@type": "FAQPage"';
                            $i = 0;
                            while (have_rows('faq')) : the_row();
                                $faq_title = get_sub_field('question');
                                $faq_text = get_sub_field('answer');
                                ?>
                                <div class="faq-item">
                                    <?php if ($faq_title != '') { ?>
                                        <div class="faq-question d-flex align-items-center <?php echo ($count === 1) ? '' : 'collapsed'; ?>" data-bs-toggle="collapse"
                                             data-bs-target="#collapse<?php echo $i; ?>"
                                             aria-expanded="true"
                                             aria-controls="collapse<?php echo $i; ?>">
                                            <h4 class="faq-question-title"><?php echo $faq_title; ?></h4>
                                            <span class="icon-holder"><i class="icon-plus"></i></span>
                                        </div>
                                    <?php }
                                    if ($faq_text != '') {
                                        ?>
                                        <div id="collapse<?php echo $i; ?>"
                                             class="faq-answer collapse <?php echo ($count == 1) ? 'show' : ''; ?>" aria-labelledby="heading<?php echo $i; ?>"
                                             data-bs-parent="#faqAccordion">
                                            <?php echo $faq_text; ?>
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php
                                if ($i == 0) {
                                    $faqjd = $faqjd . ',"mainEntity": [{';
                                    $i = 1;
                                } else {
                                    $faqjd = $faqjd . ',{';
                                }
                                $faqjd = $faqjd . '"@type": "Question",
                                            "name": "' . get_sub_field('question_faq') . '",
                                            "acceptedAnswer": {
                                              "@type": "Answer",
                                              "text": "' . str_replace("\"", "'", get_sub_field('answer_faq')) . '"
                                            }
                                          }';
                                $count++;
                                $i++;
                                $j += 0.25;
                                $i++; endwhile;
                            $faqjd = $faqjd . ']}</script>';
                            ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer(); ?>

