<?php
/* template name: Machinery */
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
?>

<div class="page-wrap archive-project">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-10 mx-auto page-head">
                <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo get_the_title(); ?>
                </h1>
            </div>
            <div class="col-12">
                <div class="row">
                    <?php
                    $args = array(
                        'post_type' => 'machinery',
                        'paged' => $paged,
                        'post_status ' => 'publish',
                        'posts_per_page' => 15
                    );
                    $posts = new WP_Query($args);
                    if ($posts->have_posts()):
                    $i = 0.25;
                    while ($posts->have_posts()) : $posts->the_post();
                    ?>
                    <div class="col-12 col-sm-6 col-lg-3 project-ca">

                        <div class="project-card">
                            <div class="entry-media position-relative">
                                <a href="<?php echo get_the_permalink(); ?>">
                                    <figure>
                                        <?php the_post_thumbnail('project-img'); ?>
                                    </figure>
                                </a>
                            </div>

                            <div class="entry-content">
                                <h3 class="entry-title"><a
                                        href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                </h3>
                            </div>
                        </div>
                        <?php echo '</div>';
                        $i += 0.25; endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                    </div>
                    <!-- Pagination -->
                    <div class="pagination">
                        <?php pagination_bar($posts); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php get_footer(); ?>
