<?php

use WHMCS\Carbon;
use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$reportdata["title"] = "سرویس ها";

$filterfields = [
    'id' => 'شناسه',
    'userid' => 'شناسه کاربر',
    'clientname' => 'نام مششتری',
    'orderid' => 'شماره سفارش',
    'packageid' => 'شناسه محصول',
    'server' => 'شناسه سرور',
    'regdate' => 'تاریخ ثبت نام',
    'domain' => 'نام دامنه',
    'dedicatedip' => 'آی پی اختصاصی',
    'assignedips' => 'آیپی های اختصاص داده شده',
    'firstpaymentamount' => 'مبلغ پرداخت اول',
    'amount' => 'مقدار تکرارشونده',
    'billingcycle' => 'چرخه صورتحساب',
    'nextduedate' => 'سررسید بعدی',
    'paymentmethod' => 'روش پرداخت',
    'termination_date' => 'تاریخ پایان',
    'completed_date' => 'تاریخ تکمیل',
    'domainstatus' => 'وضعیت',
    'username' => 'نام کاربری',
    'password' => 'رمز عبور',
    'notes' => 'یادداشت ها',
    'subscriptionid' => 'شناسه اشتراک',
    'suspendreason' => 'دلیل تعلیق'
];

$dateRangeFields = [
    'regdate' => 'تاریخ ثبت نام',
    'nextduedate' => 'تاریخ سررسید بعدی',
    'termination_date' => 'تاریخ اتمام',
    'completed_date' => 'تاریخ تکمیل',
];

$removedDateRangeFields = array_diff($filterfields, $dateRangeFields);

$reportdata["description"] = $reportdata["headertext"] = '';

$incfields = $whmcs->get_req_var('incfields');
$filterfield = $whmcs->get_req_var('filterfield');
$filtertype = $whmcs->get_req_var('filtertype');
$filterq = $whmcs->get_req_var('filterq');

$regDateRange = App::getFromRequest('regDateRange');
$nextDueDateRange = App::getFromRequest('nextDueDateRange');
$termDateRange = App::getFromRequest('termDateRange');
$completedDateRange = App::getFromRequest('completedDateRange');

if (!is_array($incfields)) {
    $incfields = [];
}
if (!is_array($filterfield)) {
    $filterfield = [];
}
if (!is_array($filtertype)) {
    $filtertype = [];
}
if (!is_array($filterq)) {
    $filterq = [];
}

if (!$print) {
    $reportdata["description"] = "از این گزارش می توان برای ایجاد خروجی سفارشی سرویس ها"
        . " با اعمال حداکثر 5 فیلتر استفاده کرد.  خروجی CSV از طریق منوی ابزارها در سمت چپ در دسترس است.";

    $reportdata["headertext"] = '<form method="post" action="reports.php?report=' . $report . '">
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
<tr><td width="20%" class="fieldlabel">فیلدها برای انتخاب</td><td class="fieldarea"><table width="100%"><tr>';
    $i=0;
    foreach ($filterfields as $k => $v) {
        $reportdata["headertext"] .= '<td width="20%"><input type="checkbox" name="incfields[]" value="' . $k . '" id="fd' . $k . '"';
        if (in_array($k, $incfields)) {
            $reportdata["headertext"] .= ' checked';
        }
        $reportdata["headertext"] .= ' /> <label for="fd' . $k . '">' . $v . '</label></td>';
        $i++;
        if (($i%5)==0) {
            $reportdata["headertext"] .= '</tr><tr>';
        }
    }
    $reportdata["headertext"] .= '</tr></table></td></tr>';

    for ($i = 1; $i <= 5; $i ++) {
        $reportdata["headertext"] .= '<tr><td width="20%" class="fieldlabel">فیلتر ' . $i . '</td><td class="fieldarea"><select name="filterfield[' . $i . ']" class="form-control select-inline"><option value="">هیچ</option>';
        foreach ($removedDateRangeFields as $k => $v) {
            $reportdata["headertext"] .= '<option value="' . $k . '"';
            if (isset($filterfield[$i]) && $filterfield[$i] == $k) {
                $reportdata["headertext"] .= ' selected';
            }
            $reportdata["headertext"] .= '>' . $v . '</option>';
        }
        $reportdata["headertext"] .= '</select> <select name="filtertype[' . $i . ']" class="form-control select-inline">'
            . '<option value="=">مطابقت کامل</option><option value="like"';
        if (isset($filtertype[$i]) && $filtertype[$i] == "like") {
            $reportdata["headertext"] .= ' selected';
        }
        $reportdata["headertext"] .= '>حاوی</option></select>'
            . ' <input type="text" name="filterq[' . $i . ']" class="form-control input-inline input-250" value="' . (isset($filterq[$i]) ? $filterq[$i] : '') . '" /></td></tr>';
    }

    $reportdata["headertext"] .= <<<HTML
        <tr>
            <td width="20%" class="fieldlabel">محدوده تاریخ ثبت نام</td>
            <td class="fieldarea">
                <div class="form-group date-picker-prepend-icon">
                    <label for="inputFilterDate" class="field-icon">
                        <i class="fal fa-calendar-alt"></i>
                    </label>
                    <input id="inputFilterDate"
                           type="text"
                           name="regDateRange"
                           value="{$regDateRange}"
                           class="form-control date-picker-search"
                    />
                </div>
            </td>
        </tr>
        <tr>
            <td width="20%" class="fieldlabel">محدوده سررسید بعدی</td>
            <td class="fieldarea">
                <div class="form-group date-picker-prepend-icon">
                    <label for="inputFilterDate" class="field-icon">
                        <i class="fal fa-calendar-alt"></i>
                    </label>
                    <input id="inputFilterDate"
                           type="text"
                           name="nextDueDateRange"
                           value="{$nextDueDateRange}"
                           class="form-control date-picker-search"
                    />
                </div>
            </td>
        </tr>
        <tr>
            <td width="20%" class="fieldlabel">محدوده تاریخ اتمام</td>
            <td class="fieldarea">
                <div class="form-group date-picker-prepend-icon">
                    <label for="inputFilterDate" class="field-icon">
                        <i class="fal fa-calendar-alt"></i>
                    </label>
                    <input id="inputFilterDate"
                           type="text"
                           name="termDateRange"
                           value="{$termDateRange}"
                           class="form-control date-picker-search"
                    />
                </div>
            </td>
        </tr>
        <tr>
            <td width="20%" class="fieldlabel">محدوده تاریخ تکمیل شده</td>
            <td class="fieldarea">
                <div class="form-group date-picker-prepend-icon">
                    <label for="inputFilterDate" class="field-icon">
                        <i class="fal fa-calendar-alt"></i>
                    </label>
                    <input id="inputFilterDate"
                           type="text"
                           name="completedDateRange"
                           value="{$completedDateRange}"
                           class="form-control date-picker-search"
                    />
                </div>
            </td>
        </tr>
    </table>
    <p align="center"><input type="submit" value="فیلتر" class="btn btn-primary"/></p>
</form>
HTML;
}

if (count($incfields)) {
    $query = Capsule::table('tblhosting');

    foreach ($filterfield as $i => $val) {
        if ($val && array_key_exists($val, $filterfields)) {
            if ($filtertype[$i] == 'like') {
                $filterq[$i] = "%{$filterq[$i]}%";
            }
            if ($val == 'clientname') {
                $query->whereRaw(
                    "concat(tblclients.firstname, ' ', tblclients.lastname) "
                    . "{$filtertype[$i]} '{$filterq[$i]}'"
                );
            } else {
                $query->where(
                    "tblhosting.{$filterfield[$i]}",
                    $filtertype[$i],
                    $filterq[$i]
                );
            }
        }
    }

    foreach ($incfields as $fieldname) {
        if (array_key_exists($fieldname, $filterfields)) {
            $reportdata["tableheadings"][] = $filterfields[$fieldname];
            if ($fieldname == "clientname") {
                $query->addSelect(Capsule::raw("concat(tblclients.firstname, ' ', tblclients.lastname)"));
            } else {
                $query->addSelect("tblhosting.{$fieldname}");
            }
        }
    }

    if ($regDateRange) {
        $dateRange = Carbon::parseDateRangeValue($regDateRange);
        $fromdate = $dateRange['from']->toDateTimeString();
        $todate = $dateRange['to']->toDateTimeString();
        $query->whereBetween('regdate', [$fromdate, $todate]);
    }

    if ($nextDueDateRange) {
        $dateRange = Carbon::parseDateRangeValue($nextDueDateRange);
        $fromdate = $dateRange['from']->toDateTimeString();
        $todate = $dateRange['to']->toDateTimeString();
        $query->whereBetween('nextduedate', [$fromdate, $todate]);
    }

    if ($termDateRange) {
        $dateRange = Carbon::parseDateRangeValue($termDateRange);
        $fromdate = $dateRange['from']->toDateTimeString();
        $todate = $dateRange['to']->toDateTimeString();
        $query->whereBetween('termination_date', [$fromdate, $todate]);
    }

    if ($completedDateRange) {
        $dateRange = Carbon::parseDateRangeValue($completedDateRange);
        $fromdate = $dateRange['from']->toDateTimeString();
        $todate = $dateRange['to']->toDateTimeString();
        $query->whereBetween('completed_date', [$fromdate, $todate]);
    }

    $results = $query
        ->join('tblclients', 'tblclients.id', '=', 'tblhosting.userid')
        ->get()
        ->all();

    foreach ($results as $result) {
        $result = (array) $result;
        if (isset($result['paymentmethod'])) {
            $result['paymentmethod'] = $gateways->getDisplayName($result['paymentmethod']);
        }
        if (isset($result['password'])) {
            $result['password'] = decrypt($result['password']);
        }
        $reportdata["tablevalues"][] = $result;
    }
}
