<?php

use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$reportdata["title"] = "تعلیق محصولات";
$reportdata["description"] = "این گزارش به شما امکان می دهد تا تمامی محصولات معلق و دلایل مشخص شده برای تعلیق آنها را بررسی کنید";

$reportdata["tableheadings"] = array("شناسه سرویس","نام مشتری","نام محصولات","دامنه","سررسید بعدی","دلیل تعلیق");

$results = Capsule::table('tblhosting')
    ->select('tblhosting.*', 'tblclients.firstname', 'tblclients.lastname', 'tblproducts.name')
    ->join('tblclients', 'tblclients.id', '=', 'tblhosting.userid')
    ->join('tblproducts', 'tblproducts.id', '=', 'tblhosting.packageid')
    ->where('domainstatus', '=', 'Suspended')
    ->orderBy('id', 'asc')
    ->get()
    ->all();
foreach ($results as $result) {
    $serviceid = $result->id;
    $userid = $result->userid;
    $clientname = $result->firstname . " " . $result->lastname;
    $productname = $result->name;
    $domain = $result->domain;
    $nextduedate = $result->nextduedate;
    $suspendreason = $result->suspendreason;

    if (!$suspendreason) {
        $suspendreason = 'تاخیر در پرداخت';
    }

    $nextduedate = fromMySQLDate($nextduedate);

    $reportdata["tablevalues"][] = [
        '<a href="clientshosting.php?userid=' . $userid . '&id=' . $serviceid . '">' . $serviceid . '</a>',
        '<a href="clientssummary.php?userid=' . $userid . '">' . $clientname . '</a>',
        $productname,
        $domain,
        $nextduedate,
        $suspendreason,
    ];
}

$data["footertext"] = '';
