<?php

use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$reportdata["title"] = "خلاصه فضای دیسک و استفاده از پهنای باند";
$reportdata["description"] = "این گزارش آمار فضای دیسک و استفاده از پهنای باند را برای حساب‌های میزبانی نشان می‌دهد";

$reportdata["tableheadings"] = array("نام مشتری / دامنه","استفاده از دیسک","محدودیت دیسک","درصد استفاده شده","پهنای باند استفاده شده","محدودیت پهنای باند","درصد استفاده شده");

if ($_GET["action"]=="updatestats") {
    require("../includes/modulefunctions.php");
    ServerUsageUpdate();
}

$results = Capsule::table('tblservers')
    ->orderBy('name', 'asc')
    ->get()
    ->all();
foreach ($results as $result) {
    $serverid = $result->id;
    $name = $result->name;
    $ipaddress = $result->ipaddress;
    $reportdata["tablevalues"][] = ["**<strong>{$name}</strong> - {$ipaddress}"];

    $services = Capsule::table('tblhosting')
        ->select(
            'tblhosting.domain',
            'tblhosting.diskusage',
            'tblhosting.disklimit',
            'tblhosting.bwlimit',
            'tblhosting.bwusage',
            'tblhosting.domainstatus',
            'tblclients.firstname',
            'tblclients.lastname',
            'tblclients.companyname',
            'tblhosting.lastupdate'
        )
        ->join('tblclients', 'tblclients.id', '=', 'tblhosting.userid')
        ->where('tblhosting.server', '=', (int) $serverid)
        ->where('tblhosting.lastupdate', '!=', '0000-00-00 00:00:00')
        ->whereIn('domainstatus', ['Active', 'Suspended'])
        ->orderBy('tblhosting.domain', 'asc')
        ->get()
        ->all();
    foreach ($services as $service) {
        $name = "{$service->firstname} {$service->lastname}";
        $companyname = $service->companyname;
        if ($companyname != "") {
            $name .= " ({$companyname})";
        }

        $domain = $service->domain;
        $diskusage = $service->diskusage;
        $disklimit = $service->disklimit;
        $bwusage = $service->bwusage;
        $bwlimit = $service->bwlimit;
        $lastupdate = $service->lastupdate;

        if ($disklimit == "0") {
            $percentused = "در دسترس نیست";
        } else {
            @$percentused = number_format((($diskusage / $disklimit) * 100), 0, '.', '');
        }
        if ($disklimit=="0") {
            $disklimit="نامحدود";
        }
        if ($bwlimit == "0") {
            $bwpercentused = "در دسترس نیست";
        } else {
            @$bwpercentused = number_format((($bwusage / $bwlimit) * 100), 0, '.', '');
        }
        if ($bwlimit == "0") {
            $bwlimit = "نامحدود";
        }
        if ($percentused != "در دسترس نیست") {
            $percentused .= "%";
        }
        if ($bwpercentused != "در دسترس نیست") {
            $bwpercentused .= "%";
        }

        $reportdata["tablevalues"][] = [
            "{$name}<br />{$domain}",
            "{$diskusage} مگابایت",
            "{$disklimit} مگابایت",
            "{$percentused}",
            "{$bwusage} مگابایت",
            "{$bwlimit} مگابایت",
            "{$bwpercentused}"
        ];
    }
}

$data["footertext"] = "<p>آمار استفاده از فضای دیسک آخرین به روز رسانی در "
    . fromMySQLDate($lastupdate, "time")
    . " - <a href=\"{$_SERVER["PHP_SELF"]}?report={$_GET["report"]}&action=updatestats\">اکنون به روز رسانی کنید</a></p>";
