<?php

use WHMCS\Carbon;
use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$dateFilter = Carbon::create(
    $year,
    $month,
    1
);

/** @var Carbon $today */
$startOfMonth = $dateFilter->startOfMonth()->toDateTimeString();
$endOfMonth = $dateFilter->endOfMonth()->toDateTimeString();

$reportdata["title"] = "عملکرد روزانه برای " . $months[(int) $month] . " " . $year;
$reportdata["description"] = "این گزارش خلاصه فعالیت روزانه را برای یک ماه مشخص نشان می دهد.";

$reportdata["monthspagination"] = true;

$reportdata["tableheadings"] = array(
    "تاریخ",
    "سفارشات تکمیل شده",
    "فاکتورهای جدید",
    "فاکتورهای پرداخت شده",
    "تیکت  های باز شده",
    "تیکت های پاسخ داده شده",
    "درخواست های لغو",
);

$reportvalues = array();

$dateFormat = Capsule::raw('date_format(`date`, "%e")');
$reportvalues['orders_active'] = Capsule::table('tblorders')
    ->where('status', 'Active')
    ->whereBetween(
        'date',
        [
            $startOfMonth,
            $endOfMonth
        ]
    )
    ->groupBy($dateFormat)
    ->orderBy('date')
    ->pluck(Capsule::raw('count(id) as total'), Capsule::raw('date_format(`date`, "%e") as day'))->all();

$reportvalues['invoices_new'] = Capsule::table('tblinvoices')
    ->whereBetween(
        'date',
        [
            $startOfMonth,
            $endOfMonth
        ]
    )
    ->groupBy($dateFormat)
    ->orderBy('date')
    ->pluck(Capsule::raw('count(id) as total'), Capsule::raw('date_format(`date`, "%e") as day'))->all();

$reportvalues['invoices_paid'] = Capsule::table('tblinvoices')
    ->whereBetween(
        'date',
        [
            $startOfMonth,
            $endOfMonth
        ]
    )
    ->groupBy(Capsule::raw('date_format(`datepaid`, "%e")'))
    ->orderBy('date')
    ->pluck(Capsule::raw('count(id) as total'), Capsule::raw('date_format(`datepaid`, "%e") as day'))->all();

$reportvalues['tickets_new'] = Capsule::table('tbltickets')
    ->whereBetween(
        'date',
        [
            $startOfMonth,
            $endOfMonth
        ]
    )
    ->groupBy($dateFormat)
    ->orderBy('date')
    ->pluck(Capsule::raw('count(id) as total'), Capsule::raw('date_format(`date`, "%e") as day'))->all();

$reportvalues['tickets_staff_replies'] = Capsule::table('tblticketreplies')
    ->whereBetween(
        'date',
        [
            $startOfMonth,
            $endOfMonth
        ]
    )
    ->where('admin', '!=', '')
    ->groupBy($dateFormat)
    ->orderBy('date')
    ->pluck(Capsule::raw('count(id) as total'), Capsule::raw('date_format(`date`, "%e") as day'))->all();

$reportvalues['cancellations_new'] = Capsule::table('tblcancelrequests')
    ->whereBetween(
        'date',
        [
            $startOfMonth,
            $endOfMonth
        ]
    )
    ->groupBy($dateFormat)
    ->orderBy('date')
    ->pluck(Capsule::raw('count(id) as total'), Capsule::raw('date_format(`date`, "%e") as day'))->all();

for ($day = 1; $day <= $dateFilter->endOfMonth()->day; $day++) {
    $date = Carbon::create($year, $month, $day);
    $daytext = $date->format('l');
    $date = $date->toDateString();

    $neworders = isset($reportvalues['orders_active'][$day]) ? $reportvalues['orders_active'][$day] : '0';
    $newinvoices = isset($reportvalues['invoices_new'][$day]) ? $reportvalues['invoices_new'][$day] : '0';
    $paidinvoices = isset($reportvalues['invoices_paid'][$day]) ? $reportvalues['invoices_paid'][$day] : '0';
    $newtickets = isset($reportvalues['tickets_new'][$day]) ? $reportvalues['tickets_new'][$day] : '0';
    $ticketreplies = isset($reportvalues['tickets_staff_replies'][$day]) ? $reportvalues['tickets_staff_replies'][$day] : '0';
    $cancellations = isset($reportvalues['cancellations_new'][$day]) ? $reportvalues['cancellations_new'][$day] : '0';

    $reportdata["tablevalues"][] = array(
        $daytext . ' ' . fromMySQLDate($date),
        $neworders,
        $newinvoices,
        $paidinvoices,
        $newtickets,
        $ticketreplies,
        $cancellations,
    );

    $chartdata['rows'][] = array(
        'c' => array(
            array('v' => fromMySQLDate($date)),
            array('v' => (int)$neworders),
            array('v' => (int)$newinvoices),
            array('v' => (int)$paidinvoices),
            array('v' => (int)$newtickets),
            array('v' => (int)$ticketreplies),
            array('v' => (int)$cancellations)
        )
    );
}

$chartdata['cols'][] = array('label' => 'روز', 'type' => 'string');
$chartdata['cols'][] = array('label' => 'سفارشات تکمیل شده', 'type' => 'number');
$chartdata['cols'][] = array('label' => 'فاکتورهای جدید', 'type' => 'number');
$chartdata['cols'][] = array('label' => 'فاکتورهای پرداخت شده', 'type' => 'number');
$chartdata['cols'][] = array('label' => 'تیکت  های باز شده', 'type' => 'number');
$chartdata['cols'][] = array('label' => 'تیکت های پاسخ داده شده', 'type' => 'number');
$chartdata['cols'][] = array('label' => 'درخواست های لغو', 'type' => 'number');

$args = array();
$args['legendpos'] = 'right';

include  __DIR__ . '../../addons/jalalidate_pro/src/reports/daily_performance.php';

$reportdata["headertext"] = $chart->drawChart('Area', $chartdata, $args, '400px');
