<?php

use WHMCS\Carbon;
use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("دسترسی مستقیم به این فایل امکان پذیر نیست");
}

$reportdata["title"] = "منابع مشتری";
$reportdata["description"] = "این گزارش خلاصه‌ای از پاسخ‌های مشتریان به «چگونه ما را پیدا کردید» ارائه می‌کند؟ یا از کجا درباره ما شنیدی؟ سوال ثبت نام فیلد سفارشی";

$range = App::getFromRequest('range');
if (!$range) {
    $today = Carbon::today()->endOfDay();
    $lastWeek = Carbon::today()->subDays(6)->startOfDay();
    $range = $lastWeek->toAdminDateFormat() . ' - ' . $today->toAdminDateFormat();
}

$customfieldid = get_query_val("tblcustomfields","id",array("type"=>"client","fieldname"=>"How did you find us?"));
if (!$customfieldid) $customfieldid = get_query_val("tblcustomfields","id",array("type"=>"client","fieldname"=>"Where did you hear about us?"));

if (!$customfieldid && isset($_REQUEST['fieldname']) && isset($_REQUEST['options'])) {
    check_token('WHMCS.admin.default');
    $customfieldid = insert_query("tblcustomfields",array("type"=>"client","fieldname"=>$_REQUEST['fieldname'],"fieldtype"=>"dropdown","fieldoptions"=>$_REQUEST['options'],"showorder"=>"on"));
}

if (!$customfieldid) $reportdata["headertext"] = '<div style="margin:50px auto;width:50%;padding:15px;border:1px dashed #ccc;text-align:center;font-size:14px;">این گزارش از شما می‌خواهد که یک فیلد سفارشی که در طول فرآیند ثبت‌نام نشان داده شده است را با نام «چگونه ما را پیدا کردید» تنظیم کنید. یا "از کجا درباره ما شنیدی؟" به منظور جمع آوری این داده ها از مشتریان ایجاد کنید

<br /><br />به نظر می رسد هنوز تنظیمات فیلد سفارشی را نداشته باشید، بنابراین ما می توانیم این کار را اکنون انجام دهیم:
<br /><br /><form method="post" action="reports.php?report=client_sources"> : فیلد نام <select name="fieldname"><option> چگونه ما را پیدا کردی؟</option><option>از کجا درباره ما شنیدی؟</option></select><br />گزینه ها: <input type="text" name="options" value="گوگل، بینگ، موتور جستجوی دیگر، هاستینگ ها  دوست، تبلیغات، سایر موارد" style="width:70%;" /><br /><br /><input type="submit" value="ایجاد &raquo;" class="btn btn-primary" /></form></div>';
else {
    $reportdata['headertext'] = '';
    if (!$print) {
        $reportdata['headertext'] = <<<HTML
<form method="post" action="?report={$report}&currencyid={$currencyid}&calculate=true">
    <div class="report-filters-wrapper">
        <div class="inner-container">
            <h3>فیلترها</h3>
            <div class="row">
                <div class="col-md-3 col-sm-6">
                    <div class="form-group">
                        <label for="inputFilterDate">{$dateRangeText}</label>
                        <div class="form-group date-picker-prepend-icon">
                            <label for="inputFilterDate" class="field-icon">
                                <i class="fal fa-calendar-alt"></i>
                            </label>
                            <input id="inputFilterDate"
                                   type="text"
                                   name="range"
                                   value="{$range}"
                                   class="form-control date-picker-search"
                            />
                        </div>
                    </div>
                </div>
            </div>
            <button type="submit" class="btn btn-primary">
                {$aInt->lang('reports', 'generateReport')}
            </button>
        </div>
    </div>
</form>
HTML;
    }
}

$reportdata["tableheadings"][] = "مکان ارجاع";
$reportdata["tableheadings"][] = "تعداد";

$dateRange = Carbon::parseDateRangeValue($range);
$fromdate = $dateRange['from']->toDateTimeString();
$todate = $dateRange['to']->toDateTimeString();

$results = Capsule::table('tblcustomfieldsvalues')
    ->select(Capsule::raw('tblcustomfieldsvalues.value, count(*) as `rows`'))
    ->join('tblclients', 'tblclients.id', '=', 'tblcustomfieldsvalues.relid')
    ->where('fieldid', '=', (int) $customfieldid)
    ->whereBetween(
        'datecreated',
        [
            $fromdate,
            $todate,
        ]
    )
    ->orderBy('value', 'asc')
    ->groupBy('value')
    ->get()
    ->all();

foreach ($results as $result) {
    $reportdata["tablevalues"][] = [$result->value, $result->rows];
    $chartdata['rows'][] = [
        'c' => [
            ['v' => $result->value],
            ['v' => $result->rows, 'f' => $result->rows],
        ],
    ];
}

$chartdata['cols'][] = array('label'=>'مکان ارجاع','type'=>'string');
$chartdata['cols'][] = array('label'=>'تعداد','type'=>'number');

$args = array();
$args['legendpos'] = 'right';

if ($customfieldid) $reportdata["footertext"] = $chart->drawChart('Pie',$chartdata,$args,'300px');
