<?php
/*
 - Author : NextPay.IR
 - Module Designed For The : NextPay.IR
*/
use WHMCS\Database\Capsule;
if(isset($_REQUEST['invoiceId']) && is_numeric($_REQUEST['invoiceId'])){
    require_once __DIR__ . '/../../init.php';
    require_once __DIR__ . '/../../includes/gatewayfunctions.php';
    require_once __DIR__ . '/../../includes/invoicefunctions.php';
    $gatewayParams = getGatewayVariables('nextpay');
    if(isset($_REQUEST['trans_id'], $_REQUEST['callback']) && $_REQUEST['callback'] == 1){
        $invoice = Capsule::table('tblinvoices')->where('id', $_REQUEST['invoiceId'])->where('status', 'Unpaid')->first();
        if(!$invoice){
            die("Invoice not found");
        }
        if (isset($_REQUEST['trans_id'])) {
            $amount = ceil($invoice->total / ($gatewayParams['currencyType'] == 'IRT' ? 1 : 10));
            
            $result = nextpay_req('verify', [
                'api_key' => $gatewayParams['MerchantID'],
                'trans_id' => $_REQUEST['trans_id'],
                'amount' => $amount,
            ]);
            if ($result->code == '0') {
                checkCbTransID($_REQUEST['trans_id']);
                logTransaction($gatewayParams['name'], $_REQUEST, 'Success');
                addInvoicePayment(
                    $invoice->id,
                    $_REQUEST['trans_id'],
                    $invoice->total,
                    0,
                    'nextpay'
                );
            } else {
                logTransaction($gatewayParams['name'], array(
                    'Code'        => 'NextPay Status Code',
                    'Message'     => $result->code,
                    'Transaction' => $_REQUEST['trans_id'],
                    'Invoice'     => $invoice->id,
                    'Amount'      => $invoice->total,
                ), 'Failure');
            }
        }
        header('Location: ' . $gatewayParams['systemurl'] . '/viewinvoice.php?id=' . $invoice->id);
    } else if(isset($_SESSION['uid'])){
        $invoice = Capsule::table('tblinvoices')->where('id', $_REQUEST['invoiceId'])->where('status', 'Unpaid')->where('userid', $_SESSION['uid'])->first();
        if(!$invoice){
            die("Invoice not found");
        }
        $client = Capsule::table('tblclients')->where('id', $_SESSION['uid'])->first();
        $amount = ceil($invoice->total / ($gatewayParams['currencyType'] == 'IRT' ? 1 : 10));
        
        $result = nextpay_req('token', [
            'api_key' => $gatewayParams['MerchantID'],
            'amount' => $amount,
            'order_id' => $invoice->id,
            'customer_phone' => $client->phonenumber,
            'callback_uri' => $gatewayParams['systemurl'] . '/modules/gateways/nextpay.php?invoiceId=' . $invoice->id . '&callback=1',
        ]);
        if ($result->code == '-1') {
           
                
                    header('Location: https://nextpay.org/nx/gateway/payment/'.$result->trans_id);
                 
            
        } else {
            echo 'اتصال به درگاه امکان پذیر نیست: ', $result->code;
        }
    }
    return;
}

if (!defined('WHMCS')) {
	die('This file cannot be accessed directly');
}

function nextpay_req($method, $data){
    $gatewayParams = getGatewayVariables('nextpay');
    
        $ch = curl_init("https://nextpay.org/nx/gateway/$method");
    
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData = json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
     'Content-Type: application/json',
     'Content-Length: ' . strlen($jsonData)
    ));
    $result = curl_exec($ch);
    $err = curl_error($ch);
    $result = json_decode($result);
    curl_close($ch);
    return $result;
}

function nextpay_MetaData()
{
    return array(
        'DisplayName' => 'ماژول درگاه پرداخت نکست پی برای WHMCS',
        'APIVersion' => '3.0',
    );
}

function nextpay_config()
{
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'NextPay.IR',
        ),
        'currencyType' => array(
            'FriendlyName' => 'نوع ارز',
            'Type' => 'dropdown',
            'Options' => array(
                'IRR' => 'ریال',
                'IRT' => 'تومان',
            ),
        ),
        'MerchantID' => array(
            'FriendlyName' => 'کلید مجوز دهی',
            'Type' => 'text',
            'Size' => '255',
            'Default' => '',
            'Description' => 'کلید API KEY دریافت شده از نکست پی',
        ),
    );
}

function nextpay_link($params)
{
    $htmlOutput = '<form method="GET" action="modules/gateways/nextpay.php">';
    $htmlOutput .= '<input type="hidden" name="invoiceId" value="' . $params['invoiceid'] .'">';
    $htmlOutput .= '<input type="submit" value="' . $params['langpaynow'] . '" />';
    $htmlOutput .= '</form>';
    return $htmlOutput;
}
