<?php
class Random extends \Elementor\Widget_Base {

	public function get_name() {
		return 'random';
	}

	public function get_title() {
		return __( 'Random', 'denver' );
	}

	public function get_icon() {
		return 'eicon-thumbnails-down';
	}

	public function get_categories() {
		return [ 'elementor-widget-be-shop' ];
	}
	public function get_script_depends() {
		return [ 'elementor-hello-world' ];
	}
	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'denver' ),
			]
		);

		$this->add_control(
			'title_min',
			[
				'label' => __( 'Title', 'denver' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Edible and drinkable',
			]
		);
		$this->add_control(
			'countdown',
			[
			  'label' => __( 'countdown', 'denver' ),
			  'type' => \Elementor\Controls_Manager::SWITCHER,
			  'label_on' => __( 'Show', 'denver' ),
			  'label_off' => __( 'Hide', 'denver' ),
			  'return_value' => 'yes',
			  'default' => 'yes',
			]
		  );

		$this->end_controls_section();
        $this->start_controls_section(
            'denver-products',
            [
                'label' => esc_html__( 'Product Settings', 'denver' ),
            ]
        );
            $this->add_control(
                'my_plugin_product_grid_product_filter',
                [
                    'label' => esc_html__( 'Filter By', 'denver' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'Recent Products', 'denver' ),
                        'featured' => esc_html__( 'Featured Products', 'denver' ),
                        'best_selling' => esc_html__( 'Best Selling Products', 'denver' ),
                        'sale' => esc_html__( 'Sale Products', 'denver' ),
                        'top_rated' => esc_html__( 'Top Rated Products', 'denver' ),
                        'mixed_order' => esc_html__( 'Mixed order Products', 'denver' ),
                    ],
                ]
            );
            $this->add_control(
              'my_plugin_product_grid_products_count',
              [
                 'label'   => __( 'Products Count', 'denver' ),
                 'type'    => \Elementor\Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'my_plugin_product_grid_categories',
                [
                    'label' => esc_html__( 'Product Categories', 'denver' ),
                    'type' => \Elementor\Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => my_plugin_taxonomy_list(),
                ]
            );

            $this->add_control(
                'custom_order',
                [
                    'label' => esc_html__( 'Custom order', 'denver' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'orderby',
                [
                    'label' => esc_html__( 'Orderby', 'denver' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'none',
                    'options' => [
                        'none'          => esc_html__('None','denver'),
                        'ID'            => esc_html__('ID','denver'),
                        'date'          => esc_html__('Date','denver'),
                        'name'          => esc_html__('Name','denver'),
                        'title'         => esc_html__('Title','denver'),
                        'comment_count' => esc_html__('Comment count','denver'),
                        'rand'          => esc_html__('Random','denver'),
                    ],
                    'condition' => [
                        'custom_order' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => esc_html__( 'order', 'denver' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'DESC',
                    'options' => [
                        'DESC'  => esc_html__('Descending','denver'),
                        'ASC'   => esc_html__('Ascending','denver'),
                    ],
                    'condition' => [
                        'custom_order' => 'yes',
                    ]
                ]
            );

        $this->end_controls_section();
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'denver' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color_1',
			[
				'label' => __( 'Title Color', 'denver' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_2',
			[
				'label' => __( 'Title Color 2', 'denver' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_3',
			[
				'label' => __( 'Title Color 3', 'denver' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_4',
			[
				'label' => __( 'color show more', 'denver' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}
	protected function render() { ?>
        <script>	
    $('.owl-carousel.focarousell').owlCarousel({
        rtl:true,
        loop:true,
        autoplay:true,
        autoplayTimeout:5000,
        margin:0,
        dots:false,
        nav:false,
        items:1,
    });
	$('#lgi__slider .trcarousel').owlCarousel({
        rtl:true,
        loop:true,
        autoplay:true,
        autoplayTimeout:5000,
        margin:0,
        dots:false,
        nav:false,
        items:1,
    });
		</script>
		<?php 
		$settings = $this->get_settings_for_display();
		$settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('my_plugin_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('my_plugin_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab         = $this->get_settings_for_display('producttab');
		
        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
		);
        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated':
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['my_plugin_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'][] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }
		$products = new \WP_Query( $args );
		if ( $producttab == 'yes' ) { 
				$m=0;
				if( is_array( $product_cats ) && count( $product_cats ) > 0 ){

					// Category retrive
					$catargs = array(
						'orderby'    => 'name',
						'order'      => 'ASC',
						'hide_empty' => true,
						'slug'       => $product_cats,
					);
					$prod_categories = get_terms( 'product_cat', $catargs);

					foreach( $prod_categories as $prod_cats ){
						$m++;
						$field_name = is_numeric( $product_cats[0] ) ? 'term_id' : 'slug';
						$args['tax_query'] = array(
							array(
								'taxonomy' => 'product_cat',
								'terms' => $prod_cats,
								'field' => $field_name,
								'include_children' => false
							),
						);
						if( 'featured' == $product_type ){
							$args['tax_query'][] = array(
								'taxonomy' => 'product_visibility',
								'field'    => 'name',
								'terms'    => 'featured',
								'operator' => 'IN',
							);
						}

					}
				}
			 };
		 if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ):
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    if( 'featured' == $product_type ){
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'featured',
                            'operator' => 'IN',
                        );
                    }
                    $products = new \WP_Query( $args );

                    if( $products->have_posts() ):
                    ?>
                <?php endif; endforeach;?>

            <?php else:?>
			<?php 			
			$k=1;
            if( $products->have_posts() ): ?>
            <div class="container pr_0">
                <section class="woo-list-slider-owl random">
                    <header>
                        <span style="color: <?php echo $settings['title_color_1'] ?>;"><?php echo $settings['title_min']; ?></span>
                    </header>
                    <div class="boxs--slide">
                        <div class="boxs--slide-container owl-carousel focarousell owl-theme">
                        <?php while( $products->have_posts() ): $products->the_post(); ?>
                            <div class="item wrapper--products">
                                <div class="wrapper--products-slide woo-product-box">
                                    <a href="" class="woo-product-box_img" title="<?php the_title() ?>">
                                    <?php the_post_thumbnail( array(300, 300) , array('alt'=>''.get_the_title(),'title'=>''.get_the_title().'')); ?>
                                    </a>
                                    <div class="woo-product-box_title">
                                        <?php echo the_title(); ?>
                                    </div>
                                    <div class="woo-product_price">
                                    <?php 
                                        woocommerce_show_product_loop_sale_flash();
                                        woocommerce_template_loop_price();
                                    ?>
                                    </div>
                                    <div class="woo-product-box_footer">
                                    <?php
                                        if ( 'yes' === $settings['countdown'] ) {
                                                theme_product_sale_countdown();
                                            }
                                    ?>    
                                    </div>
                                </div>
                            </div>
                        <?php $k++; endwhile; wp_reset_postdata(); ?>
                    </div>
                </div>
            </section>
        </div>
    <?php
	endif;
	endif;
	}

}
