<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class CLOUD_FIREWALLRULES_ADMIN
{

    public static function  GetList($token, $fwid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $ca = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
        if ($ca["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
        }

        $sql = "SELECT cfrid as id ,cfr_traffic_type as trafictype,  cfr_protocol as protocol,
        cfr_port as port, cfr_ip ip  from " .
            $GLOBALS["tbl_cloud_firewall_rules"] . " where " . $GLOBALS["cfr_cfid_fk"] . "=" . $fwid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد ", "data" => $listOfRecordType];
    }
    public static function AddAdminFireWallRules($traffictype, $protocol, $port, $ip, $fwid, $iptype)
    {
        $sql = "INSERT INTO " . $GLOBALS["tbl_cloud_firewall_rules"] .
            " VALUES (0,'" . $traffictype . "','" . $protocol . "','" . $port . "','" . $ip . "','" . $fwid . "',''," . $iptype . ")";
        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", "id" => $last_id];
    }
    public static function RemoveAllRulesByFirewallID($fwid)
    {
        $sql = "DELETE FROM  " . $GLOBALS["tbl_cloud_firewall_rules"] .
            " WHERE " . $GLOBALS["cfr_cfid_fk"] . "=" . $fwid;
        $conn = GetConnection();
        $conn->query($sql);
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
    }
    public static function AddFireWallRules($token, $traffictype, $protocol, $port, $ip, $fwid, $iptype)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);


        $ca = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
        if ($ca["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
        }
        $idcid = $ca["data"][0]["cf_idcid_fk"];
        $security_group_id =  $ca["data"][0]["cf_serverid"];
        $validprotocol = [
            "Any", "Custom TCP Rule", "Custom UDP Rule", "Custom ICMP Rule",
            "Other Protocol", "All ICMP", "All TCP", "All UDP",
            "DNS", "HTTP", "HTTPS", "IMAP", "IMAPS", "LDAP", "MS SQL", "MYSQL", "POP3", "POP3S", "RDP", "SMTP", "SMTPS", "SSH"
        ];
        return $port;
        if ($port != "any") {
            if (strpos($port, '-')) {
                $p = explode("-", $port);
                if (count(($p)) != 2) {
                    return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است "];
                } else {
                    if ($p[0] < 0 || $p[0] > 65535) {
                        return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است "];
                    }
                    if ($p[1] < 0 || $p[1] > 65535) {
                        return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است "];
                    }
                }
                $port_range_min = $p[0];
                $port_range_max = $p[1];
            } else {
                if ($port < 0 || $port > 65535) {
                    return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است "];
                }
                $port_range_min = $port;
                $port_range_max = $port;
            }
        }
        $v = array_map('strtoupper', $validprotocol);
        if (!in_array(strtoupper($protocol), $v)) {
            return ["status" => "error", "message" => "پروتکل ارسالی اشتباه است ",];
        }

        if(strtoupper($protocol)=="CUSTOM ICMP RULE"){
            if (strpos($port, '-')) {
                $p = explode("-", $port);
                if (count(($p)) != 2) {
                    return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است "];
                } else {
                    if ($p[0] < 0 || $p[0] > 255) {
                        return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است "];
                    }
                    if ($p[1] < 0 || $p[1] > 255) {
                        return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است "];
                    }
                }
                $port_range_min = $p[0];
                $port_range_max = $p[1];
            } else {
                if ($port < 0 || $port > 255) {
                    return ["status" => "error", "message" => "شماره پورت ارسالی نامعتبر است "];
                }
                $port_range_min = $port;
                $port_range_max = $port;
            }
        }
        $allprotocol = [
            "ANY" => ["proto" => "256", "minport" => "1", "maxport" => "65535"],
            "CUSTOM TCP RULE"=>["proto" => "tcp", "minport" =>  $port_range_min, "maxport" => $port_range_max ],
            "CUSTOM UDP RULE"=>["proto" => "udp", "minport" =>  $port_range_min, "maxport" => $port_range_max ],
            "CUSTOM ICMP RULE"=>["proto" => "icmp", "minport" =>  $port_range_min, "maxport" => $port_range_max ],
            "OTHER PROTOCOL"=>["proto" => "256", "minport" =>  $port_range_min, "maxport" => $port_range_max ],
            "All ICMP"=>["proto" => "icmp", "minport" => "1", "maxport" => "255" ],
            "All TCP"=>["proto" => "tcp", "minport" => "1", "maxport" => "65535" ],
            "All UDP"=>["proto" => "udp", "minport" => "1", "maxport" => "65535" ],
            "DNS"=>["proto" => "udp", "minport" => "53", "maxport" => "53" ],
            "HTTP"=>["proto" => "tcp", "minport" => "80", "maxport" => "80" ],
            "HTTPS"=>["proto" => "tcp", "minport" => "443", "maxport" => "443" ],
            "IMAP"=>["proto" => "tcp", "minport" => "143", "maxport" => "143" ],
            "IMAPS"=>["proto" => "tcp", "minport" => "993", "maxport" => "993" ],
            "LDAP"=>["proto" => "tcp", "minport" => "389", "maxport" => "389" ],
            "MS SQL"=>["proto" => "tcp", "minport" => "1433", "maxport" => "1434" ],
            "MYSQL"=>["proto" => "tcp", "minport" => "3306", "maxport" => "3306" ],
            "POP3"=>["proto" => "tcp", "minport" => "110", "maxport" => "110" ],
            "POP3S"=>["proto" => "tcp", "minport" => "110", "maxport" => "110" ],
            "RDP"=>["proto" => "tcp", "minport" => "3389", "maxport" => "3389" ],
            "SMTP"=>["proto" => "tcp", "minport" => "25", "maxport" => "25" ],
            "SMTPS"=>["proto" => "tcp", "minport" => "587", "maxport" => "587" ],
            "SSH"=>["proto" => "tcp", "minport" => "22", "maxport" => "22" ]
        ];
        $validtrafficType = ["inbound", "outbound"];
        if (!in_array($traffictype, $validtrafficType)) {
            return ["status" => "error", "message" => "نوع ترافیک ارسالی اشتباه است  "];
        }
        if (  $ip == "0.0.0.0/0" || $ip == "::/0") {
        } else {
            if (strpos($ip, '/')) {
                $p = explode("/", $ip);
                if (count(($p)) != 2) {
                    return ["status" => "error", "message" => "IP ارسالی نامعتبر است "];
                } else {
                    if ($p[1] <= 0 || $p[1] >= 32) {
                        return ["status" => "error", "message" => "IP ارسالی نامعتبر است "];
                    }
                    if (!filter_var($p[0], FILTER_VALIDATE_IP)) {
                        return ["status" => "error", "message" => "IP ارسالی نامعتبر است ", $ip];
                    }
                }
            } else {
                if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                    return ["status" => "error", "message" => "IP ارسالی نامعتبر است ", $ip];
                }
            }
        }
        if (CLOUD_FIREWALLRULES_ADMIN::CheckDulicatedRules($traffictype, $protocol, $port, $ip, $fwid)[0]["cid"] != "0") {
            return ["status" => "error", "message" => " قانون درج شده تکراری است "];
        }
      
        $sql = "INSERT INTO " . $GLOBALS["tbl_cloud_firewall_rules"] .
            " VALUES (0,'" . $traffictype . "','" . $protocol . "','" . $port . "','" . $ip . "','" . $fwid . "',''," . $iptype . ")";
        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        $ethertype = "IPv" . $iptype;

        $projectid = CLOUD_PROJECT_ADMIN::GetUserByIDC($idcid, $uid)["data"][0]["cp_project_id"];

        $direction = $traffictype == "inbound" ? "ingress" : "egress";
        $protocol = $protocol == "any" ? "256" : $protocol;
        $project_id["data"][0]["cp_project_id"] = CLOUD_PROJECT_ADMIN::GetUserByIDC($idcid, $uid);
        $returndid = API_CLOUD_FIREWALLRULES_ADMIN::RunCreateAPIFIREWALLRULES(
            $direction,
            "rules",
            $m,
            $idcid,
            $allprotocol[strtoupper($protocol)]["minport"],
            $allprotocol[strtoupper($protocol)]["maxport"],
            $ethertype,
            $ip,
            $security_group_id,
            $allprotocol[strtoupper($protocol)]["proto"],
            $project_id
        ); 
        $c=self::UpdateServerIDFromAPI($last_id, self::ReturnServerIDForRules($m,$security_group_id,$idcid));
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", "id" => $last_id,$returndid];
    }
    public static function UpdateServerIDFromAPI($id, $serverid)
    {
        $sql = "UPDATE  " . $GLOBALS["tbl_cloud_firewall_rules"] .
            " SET " . $GLOBALS["cfr_server_id"] . "='" . $serverid . "' WHERE " . $GLOBALS["cfrid"] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function CheckDulicatedRules($trafficType, $protocol, $port, $ip, $fwid)
    {
        $sql = "SELECT count(cfrid) as cid from " . $GLOBALS["tbl_cloud_firewall_rules"] . "  where " .
            $GLOBALS["cfr_cfid_fk"] . "='" . $fwid . "' and " . $GLOBALS["cfr_protocol"] . "='" . $protocol . "' and
        " . $GLOBALS["cfr_traffic_type"] . "='" . $trafficType . "' and " . $GLOBALS["cfr_port"] . "='" . $port . "' and
        " . $GLOBALS["cfr_ip"] . "='" . $ip . "' ";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return $listOfRecordType;
    }
    public static function  ReturnServerIDForRules($m,$fwid,$idc){
       $o= API_CLOUD_FIREWALLRULES_ADMIN::RunGetSecurityGroupRules($m,$fwid,$idc);
       $m=str_replace("'",'"',$o);
       $n=json_decode($m,true);
       array_multisort( array_column($n, "created_at"), SORT_DESC, $n );
       return $n[0]["id"];
    }
    

    public static function  GetOneRule( $ruleid)
    {
        $sql = "SELECT *  from " .
            $GLOBALS["tbl_cloud_firewall_rules"] . " where " . $GLOBALS["cfrid"] . "=" . $ruleid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد ", "data" => $listOfRecordType];
    }
    public static function DeleteFireWallRules($token, $fwid, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        $ca = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
        if ($ca["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
        }
        $sid=self::GetOneRule($id)["data"][0]["cfr_server_id"]; 
        
        $sql = "delete  from " . $GLOBALS["tbl_cloud_firewall_rules"] . "  where " .
            $GLOBALS['cfrid'] . "=" . $id . " and " . $GLOBALS["cfr_cfid_fk"] . "=" . $fwid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
      
        $out=API_CLOUD_FIREWALLRULES_ADMIN::RunDeleteSecurityGroupRule($m,$sid,$ca["data"][0]["cf_idcid_fk"]);
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد ",$out];
    }
}
