<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';



class VOD_DOMAIN_ADMIN
{

    public static function GetList($token)
    {
        /**
         *   دریافت اطلاعات یک دامنه در VOD براساس کاربر
         * 
         *   ورودی : 
         *              string token
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    output : آرایه ای از فولدرها
         */
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $uid = $u["userdetail"][0]["uid"];
        $sql = "SELECT * FROM " . $GLOBALS["vod_domain_tablename"] . " WHERE " . $GLOBALS['vd_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما دامنه ای انتخاب نکرده اید"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicatedName($name)
    {
        /**
         *   بررسی تکراری بودن نام دامنه
         * 
         *   ورودی : 
         *              string name
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         */
        $sql = "SELECT * FROM " . $GLOBALS["vod_domain_tablename"] . " WHERE " . $GLOBALS['vdname'] . "='" . $name . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "error"];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function AddDomain($token, $domain)
    {
         /**
         *   افزودن نام دامنه جدید برای کاربر
         * 
         *   ورودی : 
         *              string name
         *              string Token
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         */
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "success") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $name = TOOLS_ADMIN::seo_friendly_url($domain);
        if (VOD_DOMAIN_ADMIN::CheckDuplicatedName($name)["status"] == "error") {
            return ["status" => "error", "message" => "نام درخواستی شما تکراری است و قابل ثبت نیست لطفا نام دیگری انتخاب نمایید"];
        }
        $sqlins = "INSERT INTO " . $GLOBALS["vod_domain_tablename"] . "(" . $GLOBALS['vdname'] . "," . $GLOBALS['vd_uid_fk'] . "," . $GLOBALS['vd_status'] . ") VALUES ('"
            . $name . "'," . $u["userdetail"][0]["uid"] . ",1)";
        $conn = GetConnection();

        if ($conn->query($sqlins) === TRUE) {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
        } else {
            $listOfRecordType = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function UserCanAccessToStreamDomain($uid, $streamdomainid)
    {
         /**
         *   بررسی دسترسی کاربر به یک دامنه 
         * 
         *   ورودی : 
         *              string name
         *              string DomainID
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست 
         *                    data   : اطلاعات دامنه کاربر
         */
        $sql = "SELECT * FROM " . $GLOBALS["vod_domain_tablename"] . " WHERE " . $GLOBALS['vd_uid_fk'] . "=" . $uid . " AND " .
            $GLOBALS['vdid'] . "=" . $streamdomainid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید "];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
}
