<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class API_CLOUD_FIREWALLRULES_ADMIN
{

    public static function RunCreateAPIFIREWALLRULES(
        $direction,
        $description,
        $email,
        $idcid,
        $port_range_min,
        $port_range_max,
        $ethertype,
        $remote_ip_prefix,
        $security_group_id,
        $protocol,
        $project_id
    ) {

        $actionUrl = "api/v1/securitygroup/rule/create";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["direction"] = $direction;

        $postededata["port_range_min"] = $port_range_min;
        $postededata["port_range_max"] = $port_range_max;

        $postededata["description"] = $description;
        $postededata["ethertype"] = $ethertype;
        $postededata["remote_ip_prefix"] = $remote_ip_prefix;
        $postededata["protocol"] = $protocol;
        $postededata["security_group_id"] = $security_group_id;
        $postededata["project_id"] = $project_id;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
        $api = json_decode($apiOut, true);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return   $apiOut;
    }
    public static function RunDeleteSecurityGroupRule($email, $ruleid, $idcid)
    {

        $actionUrl = "api/v1/securitygroup/rule/delete";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $ruleid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
        $api = json_decode($apiOut, true);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return  [$postededata, $apiOut];
    }
    public static function RunGetSecurityGroupRules($email, $fwid, $idcid)
    {
        $actionUrl = "api/v1/securitygroup/rules";

        $postededata["useraccount"] = $email;
        $postededata["passcode"] = md5($email);
        $postededata["id"] = $fwid;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
        $api = json_decode($apiOut, true);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        return $apiOut;
    }
}
