<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/sslpools/sslpools_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/sslwebsites/admin/sslwebsites_admin_class.php';

class SSLPOOLS_ADMIN
{
    public static function ReturnSSLDetails($crt, $prv)
    {
        if (openssl_x509_check_private_key($crt, $prv)) {
            $certinfo = openssl_x509_parse($crt);
            if ($certinfo['validFrom_time_t'] > time() || $certinfo['validTo_time_t'] < time())
                return ["status" => 400, "message" => "گواهینامه منقضی شده  است"];
            else {
                $crtindfo = [];
                $crtindfo["MainDomain"] = $certinfo["subject"]["CN"];
                $crtindfo["issuer"] = $certinfo["issuer"]["CN"];
                $crtindfo["startdate"] = date('Y/m/d H:i:s', $certinfo["validFrom_time_t"]);
                $crtindfo["expiredate"] = date('Y/m/d H:i:s', $certinfo["validTo_time_t"]);
                $crtindfo["alternativedomains"] = $certinfo["extensions"]["subjectAltName"];
                return ["status" => 200, "data" => $crtindfo];
            }
        } else {
            return ["status" => 400, "message" => "گواهینامه و کلید خصوصی آن با هم منطبق نیست"];
        }
    }
    public static function GetListByUsers($token, $domain)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $dmn = DOMAINS_ADMIN::CheckDomainOwnerID($domain, $uid);
        if ($dmn["status"] == "error") {
                         return ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
        }

        $sql = "SELECT " . $GLOBALS['sslpoolsid'] . " as id ," .
            $GLOBALS['sp_startdate'] . " as StartDate," .
            $GLOBALS['sp_cert'] . " as Certificate," .
            $GLOBALS['sp_cabundle'] . " as CABundle," .
            $GLOBALS['sp_privatekey'] . " as PrivateKey," .
            $GLOBALS['sp_expiredate'] . " as ExpireDate," .
            $GLOBALS['sp_domain'] . " as MainDomain," .
            $GLOBALS['sp_name'] . " as CertifiCateName," .
            $GLOBALS['sp_issuername'] . " as IssuerName," .
            $GLOBALS['sp_altdomain'] . " as  AlternativeDomains"
            . " FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sp_uid_fk'] . "=" . $uid . " AND sp_did_fk =" . $domain . " AND sp_privatekey!='FREESSL'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما SSL ثبت نکرده اید "];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["status" => "success", "message" => "لیست سایت ها با موفقیت دریافت شد", "data" => $list];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetByCertificate($crt)
    {

        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sp_cert'] . "='" . $crt . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
                         $listOfRecordType = ["status" => "error", "message" => "این گواهینامه قبلا ثبت شده است"];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function AddCertificateToPools($token, $crt, $privatekey, $cabundle, $spname, $domain)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $dmn = DOMAINS_ADMIN::CheckDomainOwnerID($domain, $uid);
        if ($dmn["status"] == "error") {
                         return ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
        }
        // if ($dmn["data"][0]["d_plan"] == "free") {
        //     return ["status" => "error", "message" => "شما امکان استفاده از این بخش را در پلان پایه ندارید "];
        // }
        $crtinfo = SSLPOOLS_ADMIN::ReturnSSLDetails($crt, $privatekey);
        if ($crtinfo["status"] != 200) {
            VARS_ADMIN::ReturnHeaders($crtinfo["status"]);
            return ["status" => "error", "message" => $crtinfo["message"]];
        }

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteListByUserID($uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شما سایتی در این پنل کاربری ندارید
            لطفا ابتدا سایت جدیدی اضافه نمایید سپس اقدام به افزودن SSL نمایید", $websitesOwner];
        } else {
            if (SSLPOOLS_ADMIN::GetByCertificate($crt)["status"] == "error") {
                                 return ["status" => "error", "message" => "این گواهینامه قبلا ثبت شده است"];
            }
            // if ($dmn["data"][0]["d_plan"] == "free") {
            //     return ["status" => "error", "message" => "شما امکان استفاده از این بخش را در پلان پایه ندارید "];
            // }

            $sql = "INSERT INTO " . $GLOBALS["sslpools_tablename"] . " (" .
                $GLOBALS['sp_uid_fk'] . "," . $GLOBALS['sp_cert'] . "," . $GLOBALS['sp_cabundle'] . "," .
                $GLOBALS['sp_privatekey'] . "," . $GLOBALS['sp_startdate'] . "," . $GLOBALS['sp_expiredate'] .
                "," . $GLOBALS['sp_domain'] . "," . $GLOBALS['sp_altdomain'] . "," . $GLOBALS['sp_name'] . "," .
                $GLOBALS['sp_issuername'] . "," .
                $GLOBALS['sp_did_fk'] . ") VALUES(
             %s,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')";

            $sql = sprintf(
                $sql,
                $uid,
                $crt,
                $cabundle,
                $privatekey,
                $crtinfo["data"]["startdate"],
                $crtinfo["data"]["expiredate"],
                $crtinfo["data"]["MainDomain"],
                $crtinfo["data"]["alternativedomains"],
                $spname,
                $crtinfo["data"]["issuer"],
                $domain
            );

            $conn = GetConnection();
            $result = $conn->query($sql);
            $listOfRecordType = [
                "status" => "success", "message" =>
                "درخواست شما با موفقیت انجام شدو میتوانید SSL را به سایت مد نظر خوداضافه نمایید",
                "id" => $conn->insert_id
            ];
            $conn->close();
            return $listOfRecordType;
        }
    }
    public static function DeleteFromPools($poolid, $token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        if (SSLPOOLS_ADMIN::CheckPoolidExist($poolid)["status"] == "error") {
                         return ["status" => "error", "status" => "error", "message" => "شناسه ارسالی شما نامعتبر است"];
        }

        if (SSLWEBSITES_ADMIN::CheckSSLIsInUse($token, $poolid)["status"] == "error") {
                         return ["status" => "error", "message" => "گواهبنامه درخواستی شما بر روی وب سایت افزوده شده است و امکان حذف آن در حال حاضر نیست
             لطفا ابتدا از وب سایت مورد نظر حذف نمایید و سپس درخواست حذف از این بخش را ارسال نمایید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "DELETE  from " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sslpoolsid'] . "=" . $poolid . " AND " . $GLOBALS['sp_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        VARS_ADMIN::ReturnHeaders(200);
        $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckPoolidExist($poolid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sslpoolsid'] . "=" . $poolid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CanAccessToPoolid($poolid, $uid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sslpoolsid'] . "=" . $poolid . " AND " . $GLOBALS['sp_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", $sql];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => $list
            ];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function InternalCanAccessToPoolid($poolid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sslpoolsid'] . "=" . $poolid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => $list
            ];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function AddFreeCertificateToPools($uid, $spname, $dname, $alterdname, $domainid)
    {
        $did = DOMAINS_ADMIN::GetDomainOwnerDetails($dname, $uid);
        if ($did["status"] == "error") {
            return [$dname, $did, "status" => "error", "message" => " شما اجازه دسترسی به این دامنه را ندارید"];
        }
        $sql = "INSERT INTO " . $GLOBALS["sslpools_tablename"] . " (sp_did_fk," .
            $GLOBALS['sp_uid_fk'] . "," . $GLOBALS['sp_cert'] . "," . $GLOBALS['sp_cabundle'] . "," .
            $GLOBALS['sp_privatekey'] . "," . $GLOBALS['sp_startdate'] . "," . $GLOBALS['sp_expiredate'] .
            "," . $GLOBALS['sp_domain'] . "," . $GLOBALS['sp_altdomain'] . "," . $GLOBALS['sp_name']
            . "," . $GLOBALS['sp_issuername'] . " ) VALUES(
             %s,'%s','%s','%s','%s','%s','%s','%s','%s','%s' ,'%s')";
        $now = date("Y/m/d H:i:s");
        $datetime = date("Y/m/d H:i:s", strtotime("+90 days"));

        $date = $datetime;
        $EXP = date('Y/m/d H:i:s', strtotime("+90 days"));
        $sql = sprintf(
            $sql,
            $domainid,
            $uid,
            'FREESSL',
            'FREESSL',
            'FREESSL',
            $now,
            $EXP,
            $dname,
            $alterdname,
            $spname,
            "Lets Encrypt Authority X3, Lets Encrypt Write review of Lets Encrypt"
        );

        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = [
            $sql,
            "message" =>
            "درخواست شما با موفقیت انجام شدو میتوانید SSL را به سایت مد نظر خوداضافه نمایید",
            "id" =>  $conn->insert_id,
        ];
        $conn->close();
        return $listOfRecordType;
    }
}
