<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/getdomainsrecord/admin/getdomainsrecord_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/domains/admin/domains_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/domainsnsrecords/admin/domainsnsrecords_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/domains/domainapi.php';

class GETDOMAINRECORDS_ADMIN {

public static function GetListOfRecordWithType($dname,$token,$type)
{
    $DomainDetails=DOMAINS_ADMIN::GetDomainDetailsWithName($dname);

    $AllARecords=DOMAINNSRECORD_ADMIN::GetListOfRecord($dname,$token,$type);

    DOMAINNSRECORD_ADMIN::GenerateDNSFile($dname);

    return ["data" => $AllARecords];
}

public static function GetListOfRecord($dname,$token)
{
    $DomainDetails=DOMAINS_ADMIN::GetDomainDetailsWithName($dname);
    $dns = @dns_get_record($dname, DNS_A);
    if(!$dns){
        $ns["cname"]=[];
        $ns["a"]=[];
        $ns["mx"]=[];
        $ns["txt"]=[];
    }
    else{
        $ns["cname"]=(dns_get_record($dname, DNS_CNAME ));
        $ns["a"]=(dns_get_record($dname, DNS_A ));
        $ns["mx"]=(dns_get_record($dname, DNS_MX ));
        $ns["txt"]=(dns_get_record($dname, DNS_TXT ));
    }

    $ins=[];
    $CountOfarecord=count($ns["a"]);
    $CountOfCNamerecord=count($ns["cname"]);
    $CountOfMXrecord=count($ns["mx"]);
    $CountOfTXTrecord=count($ns["txt"]);

   //AddRecord($domain,$token,$type,$name,$ip,$ttl,$proxied,$priority,$port,$weight,$value)
    $out=[];

    for($i=0;$i<$CountOfarecord;$i++){
        $ns["a"][$i]["rtype"]="A";
        if(DOMAINNSRECORD_ADMIN::GetOneRecord($dname,$ns["a"][$i])["record"]=="notexist"){
            $o=DOMAINNSRECORD_ADMIN::AddRecord($dname,
                                        $DomainDetails[0]["domain_id"],
                                        $token,
                                        "A",
                                        $ns["a"][$i]["host"],
                                        $ns["a"][$i]["ip"],
                                        $ns["a"][$i]["ttl"],1,
                                        0,0,0,0);
        array_push($out,$o);
        }

    }
    for($i=0;$i<$CountOfCNamerecord;$i++){
        $ns["cname"][$i]["rtype"]="CNAME";
        if(DOMAINNSRECORD_ADMIN::GetOneRecord($dname,$ns["cname"][$i])["record"]=="notexist"){

        $o=DOMAINNSRECORD_ADMIN::AddRecord($dname,
            $DomainDetails[0]["domain_id"],
            $token,
            "CNAME",
            $ns["cname"][$i]["host"],
            $ns["cname"][$i]["ip"],
            $ns["cname"][$i]["ttl"],1,
            0,0,0,0);
        array_push($out,$o);
        }
    }
    for($i=0;$i<$CountOfMXrecord;$i++){
        $ns["mx"][$i]["rtype"]="MX";
        if(DOMAINNSRECORD_ADMIN::GetOneRecord($dname,$ns["mx"][$i])["record"]=="notexist"){
        $o=DOMAINNSRECORD_ADMIN::AddRecord($dname,
            $DomainDetails[0]["domain_id"],
            $token,
            "MX",
            $ns["mx"][$i]["host"],
            " ",
            $ns["mx"][$i]["ttl"],0,
            $ns["mx"][$i]["pri"],
            0,0, $ns["mx"][$i]["target"]);
        array_push($out,$o);
        }
    }

    for($i=0;$i<$CountOfTXTrecord;$i++){
        $ns["txt"][$i]["rtype"]="TXT";

        if(DOMAINNSRECORD_ADMIN::GetOneRecord($dname,$ns["txt"][$i])["record"]=="notexist")
        {
            $o=DOMAINNSRECORD_ADMIN::AddRecord($dname,
                $DomainDetails[0]["domain_id"],
                $token,
                "TXT",
                $ns["txt"][$i]["host"],
                " ",
                $ns["txt"][$i]["ttl"],0,
                0,0,0, $ns["txt"][$i]["txt"]);
                array_push($out,$o);
        }
    }

    $AllARecords=DOMAINNSRECORD_ADMIN::GetListOfRecord($dname,$token,"A");
    $AllCNAMERecords=DOMAINNSRECORD_ADMIN::GetListOfRecord($dname,$token,"CNAME");
    $AllANAMERecords=DOMAINNSRECORD_ADMIN::GetListOfRecord($dname,$token,"ANAME");
    $AllAAAARecords=DOMAINNSRECORD_ADMIN::GetListOfRecord($dname,$token,"AAAA");
    $AllMXRecords=DOMAINNSRECORD_ADMIN::GetListOfRecord($dname,$token,"MX");
    $AllTXTRecords=DOMAINNSRECORD_ADMIN::GetListOfRecord($dname,$token,"TXT");

    DOMAINNSRECORD_ADMIN::GenerateDNSFile($dname);

    return  ["A"=>$AllARecords,"CNAME"=>$AllCNAMERecords,"AAAA"=>$AllAAAARecords,"ANAME"=>$AllANAMERecords,
             "MX"=>$AllMXRecords,"TXT"=>$AllTXTRecords];
}

public static function CheckNSExist($domain){
    ini_set('display_errors', 'Off');
    $i=0;
    try {
        $a=dns_get_record( $domain, DNS_NS );
        $i=1;
    }
    catch(Exception $e)
{
    throw new Exception($e->getMessage(),$e->getCode());
}

return  $i;

}

public static function ReturnNSRecord($domain){
    $nsr=(dns_get_record($domain, DNS_NS ));

    $arr=[];
    foreach($nsr as $ns){
        if($ns["type"]=="NS")
            array_push($arr,$ns["target"]);
    }
return $arr;

}

}
