<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/domainsnsrecords/domainnsrecords_filed_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/domains/admin/domains_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/cdnrangeips/admin/cdnrangeips_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/cdn/cdn.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/dnsbalancer/admin/dnsbalancer_admin_class.php';


class DOMAINNSRECORD_ADMIN
{
	public static function CheckRecordHasCluster($recordname, $domainid, $domainname)
	{

		$sql = "SELECT * FROM `tbl_clusters_websites`,tbl_domains,tbl_websites,tbl_domains_ns_records
                        WHERE ws_recordname=dnr_name AND
                            domain_id=ws_domainid_fk AND cw_ws_id_fk =wsid AND dnr_d_id_fk=domain_id AND dnr_type='A' AND dnr_name='" . $recordname . "' and domain_id=" . $domainid;
		$conn = GetConnection();
		$re = $conn->query($sql);
		if ($re && mysqli_num_rows($re) > 0)
			return ["status" => "error", "message" => "شما برای این دامنه کلاستر اضافه نموده اید و امکان ویرایش رکورد ندارید"];
		return ["status" => "success"];
	}
	public static function CheckValidationForDownrade($domainID, $plan, $newplan)
	{
		if (isset(ReturnPlans()[$plan]["wildcardcdn"])) {
			if (!isset(ReturnPlans()[$newplan]["wildcardcdn"])) {
				$sql = "SELECT * FROM `tbl_domains_ns_records` WHERE dnr_proxied=1 AND `dnr_name` LIKE '%*%' AND `dnr_d_id_fk`=" . $domainID;
				$conn = GetConnection();
				$re = $conn->query($sql);
				if ($re && mysqli_num_rows($re) > 0) {
					$conn->close();
					return ["status" => "error", "message" => "شما ابر رکورد * را روشن کرده اید و به همین دلیل امکان کاهش پلان وجود ندارد"];
				}
				$conn->close();
			}
		}
		return ["status" => "success"];
	}
	public static function RunQueue()
	{
		        $sql="SELECT DISTINCT( qname),qtype  FROM `tbl_dns_queue` ";
		        $conn = GetConnection();
		        $l=$conn->query($sql);
		         $list = mysqli_fetch_all($l, MYSQLI_ASSOC);
		         $conn->close();
		//         //  print_r($list);

		  foreach($list as $l){
		      if($l["qtype"]=="balancer"){
		             API_DOMAIN_ADMIN::RunAddClusterDNS1($l["qname"]);
		          $sql2="DELETE FROM `tbl_dns_queue` WHERE qname='".$l["qname"]."' and qtype='balancer'";
		            $conn = GetConnection();
		         $conn->query($sql2);
		         $conn->close();
		      }
			}
		//       else if($l["qtype"]=="bind"){
		//               DOMAINNSRECORD_ADMIN::GenerateDNSFile($l["qname"]);
		//               sleep(1);
		//               API_DOMAIN_ADMIN::RunAddAPI1($l["qname"]);
		//           $sql2="DELETE FROM `tbl_dns_queue` WHERE qname='".$l["qname"]."' and qtype='bind'";
		//             $conn = GetConnection();
		//          $conn->query($sql2);
		//          $conn->close();
		//       }
		//   echo $l["qname"];
		//   }
	}
	public static function ReturnAllActiveCDNByDomainID($domainid)
	{
		$sql = "SELECT * FROM tbl_domains_ns_records WHERE dnr_d_id_fk=" . $domainid . " AND dnr_proxied=1";
		$conn = GetConnection();
		$l = $conn->query($sql);
		$list = mysqli_fetch_all($l, MYSQLI_ASSOC);
		$conn->close();
		return $list;
	}
	public static function ReturnAllDeActiveCDNByDomainID($domainid)
	{
		$sql = "SELECT * FROM tbl_domains_ns_records WHERE dnr_d_id_fk=" . $domainid . " AND dnr_proxied=2";
		$conn = GetConnection();
		$l = $conn->query($sql);
		$list = mysqli_fetch_all($l, MYSQLI_ASSOC);
		$conn->close();
		return $list;
	}
	public static function RunDisableCDNforRecord($rid, $domainname, $rname, $uid, $ip, $domainid)
	{
		if ($domainname == $rname) {
			$o1 = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $domainname, 0);
			// API_CDN_ADMIN::RunDisableAPICDN($domainname, $ip);
		} else {
			$o1 = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $domainname, 0);
			// API_CDN_ADMIN::RunDisableAPICDN(
			//     $rname . "." . $domainname,
			//     $ip
			// );
		}
		$sql = "UPDATE tbl_domains_ns_records SET dnr_proxied=2 WHERE dnrid=" . $rid;
		$conn = GetConnection();
		if ($conn->query($sql) === TRUE) {
			$out = $domainname . $rname . "Record updated successfully";
		} else {
			$out = $domainname . $rname . "Error updating record: " . $conn->error;
		}
		$conn->close();
		return [$out, "o" => $o1];
	}
	public static function RunActivateCDNforRecord($uid)
	{
		$domainlist = DOMAINS_ADMIN::GetListOfDomainsbyuid($uid);

		if (count($domainlist) > 0) {
			foreach ($domainlist as $l) {
				$listofAllRecords = self::ReturnAllDeActiveCDNByDomainID($l["domain_id"]);
				if (count($listofAllRecords) > 0) {
					foreach ($listofAllRecords as $lr) {
						$dmn = $l["d_name"];
						if ($lr["dnr_name"] == $l["d_name"]) {
							$o1 = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($l["domain_id"], $l["d_name"], 1);
							// API_CDN_ADMIN::RunEanbleCDN($dmn);
						} else {
							$dmn = $lr["dnr_name"] . "." . $l["d_name"];
							$o1 = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($l["domain_id"], $lr["dnr_name"], 1);
							// API_CDN_ADMIN::RunEanbleCDN($dmn);
						}
						$sql = "UPDATE tbl_domains_ns_records set dnr_proxied=1 where  	dnrid=" . $lr["dnrid"];
						$conn = GetConnection();
						if ($conn->query($sql) === TRUE) {
							// $out = $domainname . $rname . "Record updated successfully";
						} else {
							// $out = $domainname . $rname . "Error updating record: " . $conn->error;
						}
						$conn->close();

						//  mt7dsmtzm9
					}
				}
				$mailTemplate = '%s عزیز،
                                <br />
                                سرویس CDN دامنه %s شما فعال شد
                                <br /><br />';
				$uname = $l["uname"] . " " . $l["ufamily"];
				$mailTemplate = sprintf($mailTemplate, $uname, $l["d_name"]);

				$o = EMAILCLASS::SendEmailPanel($l["umail"], "فعال شدن سرویس CDN در میزبان کلود", $mailTemplate, "error");
				// DNSBALANCER_ADMIN::AddDomainToQueue($l["d_name"],"bind");
				self::GenerateDNSFile($l["d_name"]);
			}
		}
		//ReturnAllDeActiveCDNByDomainID
		//     if ($domainname == $rname) {
		//         $o1=WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $domainname, 0);
		//         API_CDN_ADMIN::RunDisableAPICDN($domainname, $ip);
		//     } else {
		//         $o1=WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $domainname, 0);
		//         API_CDN_ADMIN::RunDisableAPICDN(
		//             $rname . "." . $domainname,
		//             $ip
		//         );
		//     }
		//     $sql="UPDATE tbl_domains_ns_records set dnr_proxied=2 where  	dnrid=".$rid;
		//     $conn = GetConnection();
		//   if ($conn->query($sql) === TRUE) {
		//       $out= $domainname.$rname."Record updated successfully";
		//     } else {
		//       $out= $domainname.$rname."Error updating record: " . $conn->error;
		//     }
		//     $conn->close();
		//     return [$out,"o"=>$o1];

	}
	public static function RunDisableCDNforDomain($rid, $domainname, $rname, $uid, $ip, $domainid)
	{
		if ($domainname == $rname) {
			$o1 = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $domainname, 0);
			// API_CDN_ADMIN::RunDisableAPICDN($domainname, $ip);
		} else {
			$o1 = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $domainname, 0);
			// API_CDN_ADMIN::RunDisableAPICDN(
			//     $rname . "." . $domainname,
			//     $ip
			// );
		}
		$sql = "UPDATE tbl_domains_ns_records SET dnr_proxied=2 WHERE dnrid=" . $rid;
		$conn = GetConnection();
		if ($conn->query($sql) === TRUE) {
			$out = $domainname . $rname . "Record updated successfully";
		} else {
			$out = $domainname . $rname . "Error updating record: " . $conn->error;
		}
		$conn->close();
		return [$out, "o" => $o1];
	}
	public static function RunDeActivateCDNforDomain($domainID)
	{
		$listofAllRecords = self::ReturnAllDeActiveCDNByDomainID($domainID);
		if (count($listofAllRecords) > 0) {
			foreach ($listofAllRecords as $lr) {
				$dmn = $lr["d_name"];
				if ($lr["dnr_name"] == $lr["d_name"]) {
					//  API_CDN_ADMIN::RunDisableAPICDN($dmn);
				} else {
					$dmn = $lr["dnr_name"] . "." . $lr["d_name"];
					// API_CDN_ADMIN::RunDisableAPICDN($dmn);
				}
			}
		}
	}
	public static function ExportDnsRecord($token, $domainid, $dname)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		if (DOMAINS_ADMIN::CheckDomainOwner($dname, $token)["status"] == "error") {
			return ["status" => "error", "message" => "شما امکان دسترسی به این دامنه را ندارید"];
		}

		$records = DOMAINNSRECORD_ADMIN::RecordsForGenerateFile($dname);

		$NSRecord = NAMESERVERS_ADMIN::GetNameServerRecordsForDomain($dname);
		$rangeIPS = CDNRANGEIPS_ADMIN::GetListByStatus($NSRecord["data"][0]["organize"]);

		$ns1 = $NSRecord["data"][0]["ns1"];
		$ns2 = $NSRecord["data"][0]["ns2"];

		$my_file = $GLOBALS["RootFiles"] . "/exporteddnsfiles/" . $dname;
		$handle = fopen($my_file, 'w') or die('Cannot open file:  ' . $my_file);

		$arecord = trim("
; ------------------------------------------------------------------------
; Mizban Cloud DNS Server Data File for Local Loopback Interface
; ------------------------------------------------------------------------
; Domain      : " . $dname . "
; Export Date : " . jDateTime::date("Y-m-d") . ' ' . date("H:i:s") . "
; UNIX Time   : " . time() . "

\$TTL    604800

@       IN      SOA     " . $ns1 . ".   dns.mizbancloud.com.
                        (   2022040201         ; Serial Number
                            3600               ; Refresh
                            1800               ; Retry
                            1209600            ; Expire
                            86400          )   ; Negative Cache TTL

@                   86400   IN      NS      " . $ns1 . ".
@                   86400   IN      NS      " . $ns2 . ".");

		$arecord .= "\n";
		$r = "
        ";

		if ($records["A"]["status"] == "success") {
			$arecord .= "\n;; A Records";
			foreach ($records["A"]["data"] as $d) {
				// if ($d["ttl"] == 0) {
				$d["ttl"] = 120;
				// }
				if ($d["name"] == $dname) {
					// if ($d["ttl"] == 0) {
					$d["ttl"] = 120;
					// }
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . ". ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      A       " . $d["ip"];
				} else {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . "  ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      A       " . $d["ip"];
				}
			}
			$arecord .= "\n";
		}

		if ($records["CNAME"]["status"] == "success") {
			$arecord .= "\n;; CNAME Records";
			foreach ($records["CNAME"]["data"] as $d) {
				// if ($d["ttl"] == "0") {
				$d["ttl"] = 120;
				// }
				if ($d["name"] == $dname) {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . ". ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      CNAME   " . $d["ip"] . ".";
				} else {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . "  ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      CNAME   " . $d["ip"] . ".";
				}
			}
			$arecord .= "\n";
		}

		if ($records["ANAME"]["status"] == "success") {
			$arecord .= "\n;; ANAME Records";
			foreach ($records["ANAME"]["data"] as $d) {
				// if ($d["ttl"] == "0") {
				$d["ttl"] = 120;
				// }
				if ($d["name"] == $dname) {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . ". ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      ANAME   " . $d["ip"];
				} else {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . "  ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      ANAME   " . $d["ip"];
				}
			}
			$arecord .= "\n";
		}

		if ($records["AAAA"]["status"] == "success") {
			$arecord .= "\n;; AAAA Records";
			foreach ($records["AAAA"]["data"] as $d) {
				// if ($d["ttl"] == 0) {
				$d["ttl"] = 120;
				// }
				if ($d["name"] == $dname) {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . ". ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      AAAA    " . $d["ip"];
				} else {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . "  ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      AAAA    " . $d["ip"];
				}
			}
			$arecord .= "\n";
		}

		if ($records["MX"]["status"] == "success") {
			$arecord .= "\n;; MX Records";
			foreach ($records["MX"]["data"] as $d) {
				$d["ttl"] = 120;
				if ($d["name"] == $dname) {
					$outputval = str_replace("..", ".", Punycode::encodeHostName($d["target"]) . ".");
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . ". ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      MX      " . str_pad($d["priority"], 8, ' ', STR_PAD_RIGHT) . " " . $outputval;
				} else {
					$outputval = str_replace("..", ".", Punycode::encodeHostName($d["target"]) . ".");
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . "  ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      MX      " . str_pad($d["priority"], 8, ' ', STR_PAD_RIGHT) . "  " . $outputval;
				}
			}
			$arecord .= "\n";
		}

		if ($records["TXT"]["status"] == "success") {
			$arecord .= "\n;; TXT Records";
			foreach ($records["TXT"]["data"] as $d) {
				// if ($d["ttl"] == 0) {
				$d["ttl"] = 120;
				// }
				if ($d["name"] == $dname) {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . ". ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      TXT     " . self::ValidateTXTString($d["value"]);
				} else {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . "  ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      TXT     " . self::ValidateTXTString($d["value"]);
				}
			}
			$arecord .= "\n";
		}

		if ($records["SRV"]["status"] == "success") {
			$arecord .= "\n;; SRV Records";
			//_service._protocolName  IN SRV priority weight portNO subdns.domain.com
			foreach ($records["SRV"]["data"] as $d) {
				// if ($d["ttl"] == 0) {
				$d["ttl"] = 120;
				// }
				if ($d["name"] == $dname) {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . ". ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      SRV     " . str_pad($d["priority"], 4, ' ', STR_PAD_RIGHT) . "  " . str_pad($d["weight"], 4, ' ', STR_PAD_RIGHT) . "  " . str_pad($d["port"], 4, ' ', STR_PAD_RIGHT) . " " . Punycode::encodeHostName($d["value"]);
				} else {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . "  ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      SRV     " . str_pad($d["priority"], 4, ' ', STR_PAD_RIGHT) . "  " . str_pad($d["weight"], 4, ' ', STR_PAD_RIGHT) . "  " . str_pad($d["port"], 4, ' ', STR_PAD_RIGHT) . " " . Punycode::encodeHostName($d["value"]);
				}
			}
			$arecord .= "\n";
		}

		if ($records["PTR"]["status"] == "success") {
			$arecord .= "\n;; PTR Records";
			// name ttl  class   rr     name
			foreach ($records["PTR"]["data"] as $d) {
				// if ($d["ttl"] == 0) {
				$d["ttl"] = 120;
				// }
				if ($d["name"] == $dname) {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . ". ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      PTR     " . Punycode::encodeHostName($d["nameserver"]);
				} else {
					$arecord .= "\n" . str_pad(Punycode::encodeHostName($d["name"]) . "  ", 20, ' ', STR_PAD_RIGHT) . str_pad($d["ttl"], 6, ' ', STR_PAD_RIGHT) . "  IN      PTR     " . Punycode::encodeHostName($d["nameserver"]);
				}
			}
			$arecord .= "\n";
		}

		$arecord .= "\n";

		//  $data.=json_encode($records);
		fwrite($handle, $arecord);
		return $arecord;
	}
	public static function ValidateTTl($ttl)
	{
		$arrttl = ["0", "120", "300", "600", "900", "1800", "3600", "7200", "18000", "43200", "86400"];
		if (in_array($ttl, $arrttl))
			return $ttl;
		else
			return  "0";
	}
	public static function ValidateTXTString($input)
	{
		$input = trim(preg_replace("/[\t\r\n]/", ' ', $input));

		$str = '';
		$pos = 0;

		while ($pos < strlen($input)) {

			if ($input[$pos] === '"') {
				$i = $pos;
				$len = 0;

				while (($end = strpos($input, '"', $i + 1)) !== false) {
					$i = $end;
					$len = $end - $pos + 1;
					if ($input[$end - 1] !== "\\") break;
				}

				if ($len > 0) {
					$str .= str_replace("\\;", ';', substr($input, $pos + 1, $len - 2));
					$pos += $len;
					while (ctype_space($input[$pos] ?? '')) $pos++;
					continue;
				}
			}

			$len = false;

			foreach (['"', "\\"] as $ch) {
				if (($end = strpos($input, $ch, $pos)) !== false && (!$len || $end < $len)) $len = $end;
			}

			if (empty($len)) {
				$str .= substr($input, $pos);
				break;
			}

			$len++;

			$str .= substr($input, $pos, $len - $pos);
			$pos = $len;

			// $str .= $input[$pos++];

		}

		$ret = '';
		$pos = 0;

		while ($pos < strlen($str)) {
			if ($str[$pos] === "\\") {
				if ($pos + 1 < strlen($str) && in_array($str[$pos + 1], ["\\", '"'/*, ';'*/])) {
					$ret .= "\\" . $str[++$pos];
				}

				$pos++;
				continue;
			} elseif ($pos > 0 && in_array($str[$pos], ['"'/*, ';'*/]) && $str[$pos - 1] !== "\\") {
				$ret .= "\\";
			}

			$ret .= $str[$pos++];
		}

		$str = trim($ret);
		$ret = '';

		$pos = 0;
		$len = strlen($str);

		while ($pos < $len) {
			$ret .= '"' . substr($str, $pos, $c = min(255, $len - $pos)) . '"';
			if (($pos += $c) < $len) $ret .= ' ';
		}

		return $ret;
	}
	//public static function ValidateTXTString($txtrec)
	//{
	// $txtrec = str_replace('"', '', $txtrec);
	// $r = [];
	// $riz = [];
	// preg_replace('/\\\\n/m', '', $txtrec);
	// preg_replace('/\\\\r/m', '', $txtrec);
	// preg_replace('/\\\\t/m', '', $txtrec);
	// preg_match('`[\\\\]{3,}`m', $txtrec, $r);
	// preg_match('`[^\\\\]{1}[\\\\][^\\\\]{1}`m', $txtrec, $riz);
	// foreach($r as $match) {
	//     if(strlen($match))
	//     $txtrec = str_replace($match, substr($match, 1), $txtrec);
	// }
	// foreach($riz as $match) {
	//     $txtrec = str_replace($match, str_replace('\\', '', $match), $txtrec);
	// }
	// preg_replace('`[\\\\]{2}`m', '\\', $txtrec);
	// preg_split('/.{0,255}/m', $txtrec);
	// $arr = preg_split("/(.{255})/", $txtrec, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);
	// $ret = implode(' ', array_map( fn($x) => '"' . $x . '"', $arr ));

	// return $ret;
	// $countofchar = strlen($txtrec);
	// $str = '"';
	// $i = 0;
	// for ($i = 0; $i < $countofchar; $i++) {
	//     if ($i + 1 < $countofchar) {
	//         if ($txtrec[$i] == "\\" && $txtrec[$i + 1] == "\\") {
	//             $str .= "\\";
	//             $i = $i + 1;
	//             continue;
	//         } else if ($txtrec[$i] == "\\" && $txtrec[$i + 1] != "\\") {
	//             continue;
	//             // } else {
	//             //     $str.=$txtrec[$i];
	//         }
	//     }
	//     if ($i % 255 != 0)
	//         $str .= $txtrec[$i];
	//     else if ($i != 0)
	//         $str .= '" "' . $txtrec[$i];
	// }

	// $ouptut = $str . '"';
	// // echo $countofchar;
	// return;
	// return  $ouptut;

	// preg_replace('/\\\\n/m', '', $ouptut);

	// $str = trim($str);
	// $ret = '';

	// $i = 0;
	// $len = strlen($str);

	// while($i < $len)
	// {
	//     $ret .= '"' . substr($str, $i, $c = min(255, $len - $i)) . '"';
	//     if ( ($i += $c) < $len ) $ret .= ' ';
	// }
	// return $ouptut;
	// $arr = preg_split("/(.{255})/", $str, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);
	// $ret = implode(' ', array_map( fn($x) => '"' . $x . '"', $arr ));
	//}
	public static function AddRecordFromFile($token, $domainid, $domain, $arrayofFiles, $internal = true)
	{
		$output = [];
		$i = 0;
		$o = [];
		foreach ($arrayofFiles["records"] as $r) {
			$o[$r["name"]] = $r["type"];
			if (substr($r["name"], -1) == ".")
				$r["name"] = substr($r["name"], 0, strlen($r["name"]) - 1);

			if ($r["name"] == "@")
				$r["name"] = $domain;
			$rangeips = CDNRANGEIPS_ADMIN::GetListOfAllRecord();

			if ($r["type"] == "A" || $r["type"] == "AAAA" || $r["type"] == "MX" || $r["type"] == "CNAME" || $r["type"] == "TXT"  || $r["type"] == "PTR") {
				$output[$r["name"]]["input"] = $r;
				$output[$r["name"]]["output"] = self::CheckRecordDuplicate($domainid, $r["name"], $r["type"]);

				if ($r["type"] == "A" || $r["type"] == "AAAA" || $r["type"] == "CNAME") {
					if ($output[$r["name"]]["output"] == "unique") {

						$dup = false;
						foreach ($rangeips as $c) {
							if ($c["crip"] == trim($r["data"])) {
								$dup = true;
							}
						}

						if (!$dup) {
							DOMAINNSRECORD_ADMIN::AddRecord(
								$domain,
								$domainid,
								$token,
								$r["type"],
								$r["name"],
								$r["data"],
								self::ValidateTTl($r["ttl"]),
								0,
								0,
								0,
								0,
								$r["data"],
								"0",
								$internal
							);
						}
					}
					// $postedata["host"]=$r["name"];
					// $postedata["ttl"]=$r["ttl"];
					// $postedata["ip"]=$r["data"];
					// $postedata["proxied"]=0;
					// $postedata["type"]=$r["type"];
					// $output[$i][$r["name"]]["add"]=self::AddSingleRecord($domain, $token, $postedata,true);

				}
				if ($r["type"] == "MX" &&  $output[$r["name"]]["output"] == "unique") {

					$out = DOMAINNSRECORD_ADMIN::AddRecord(
						$domain,
						$domainid,
						$token,
						$r["type"],
						$r["name"],
						" ",
						self::ValidateTTl($r["ttl"]),
						0,
						"100",
						0,
						0,
						$r["data"],
						"0",
						$internal
					);


					// $postedata["host"]=$r["name"];
					// $postedata["ttl"]=$r["ttl"];
					// $postedata["priority"]="100";
					// $postedata["value"]=$r["data"];
					// $postedata["type"]=$r["type"];
					//  $output[$i][$r["name"]]["add"]= self::AddSingleRecord($domain, $token, $postedata,true);
				}
				if ($r["type"] === "PTR"  &&  $output[$r["name"]]["output"] == "unique") {
					$out = DOMAINNSRECORD_ADMIN::AddRecord(
						$domain,
						$domainid,
						$token,
						$r["type"],
						$r["name"],
						" ",
						self::ValidateTTl($r["ttl"]),
						0,
						0,
						0,
						0,
						$r["data"],
						"0",
						$internal
					);
					// $postedata["host"]=$r["name"];
					// $postedata["ttl"]=$r["ttl"];
					// $postedata["value"]=$r["data"];
					// $postedata["type"]=$r["type"];
					// $output[$i][$r["name"]]["add"]=self::AddSingleRecord($domain, $token, $postedata,true);
				}
				if ($r["type"] == "TXT"  &&  $output[$r["name"]]["output"] == "unique") {
					$out = DOMAINNSRECORD_ADMIN::AddRecord(
						$domain,
						$domainid,
						$token,
						$r["type"],
						$r["name"],
						" ",
						self::ValidateTTl($r["ttl"]),
						0,
						0,
						0,
						0,
						$r["data"],
						"0",
						$internal
					);

					// $postedata["host"]=$r["name"];
					// $postedata["ttl"]=$r["ttl"];
					// $postedata["priority"]="100";
					// $postedata["value"]=$r["data"];
					// $postedata["type"]=$r["type"];
					// $output[$i][$r["name"]]["add"]=self::AddSingleRecord($domain, $token, $postedata,true);
				} else {
				}
			}
			$i++;
		}
		DOMAINNSRECORD_ADMIN::GenerateDNSFile($_POST["domain"], "first");
		return ["status" => "success", $o, "message" => "درخواست شما با موفقیت انجام شدبعد از رفرش صفحه قابل مشاهده خواهد بود"]; //
	}
	public static function ActivateMainRecordCloudForFirstTime($domainname, $domainid)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " . $GLOBALS["dnr_d_id_fk"] . "='" . $domainid . "' and  dnr_type='A' ";
		$conn = GetConnection();

		$records = $conn->query($sql);
		$list = mysqli_fetch_all($records, MYSQLI_ASSOC);

		foreach ($list as $r) {
			$nrow["balance"] = DNSBALANCER_ADMIN::GetListOfBalancers($r["dnrid"])["status"];
			if ($r["dnr_name"] == $domainname && $nrow["balance"] == "nobalance") {
				$nrow["id"] = $r["dnrid"];
				return self::InternalChangeCloudStatus($nrow["id"], $domainname);
			}
			if ($r["dnr_name"] == "www") {
				$nrow["id"] = $r["dnrid"];
				return self::InternalChangeCloudStatus($nrow["id"], $domainname);
			}
		}
	}
	public static function GetListOfAllRecord($domainname, $token, $page, $countofrecord, $first)
	{
		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domainname, $token);
		if ($canAccess["status"] == "error") {
			//              unset($canAccess["status"]);
			return $canAccess;
		}


		$uid = $canAccess["data"]["uid"];
		$expsession = jDateTime::date("Y/m/d H:i:s");
		$countOfRecord = self::GetCountOfRecords($canAccess["data"]["domain_id"])["data"][0]["cnt"];
		$fsr = ($page - 1) * $countofrecord;
		$enr = $page * $countofrecord;
		$countOfpageRecordInPage = $countofrecord;
		$a = $countOfRecord / $countOfpageRecordInPage;

		if ($countOfRecord > $countofrecord) {
			$countofpage = intdiv($countOfRecord, $countOfpageRecordInPage);
			if (!is_int($a))
				$countofpage = $countofpage + 1;
		} else {
			$countofpage = 1;
		}

		$limit =  " LIMIT " . $fsr . "," . $countofrecord;
		if ($first == 1)
			$limit = "";
		$usersDetails = USERS_ADMIN::GetOneByToken($token, "GetCredit");

		if ($usersDetails["status"] == "error") {
			return [
				"status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
			];
		}


		$uid = $usersDetails["userdetail"][0]["uid"];
		$now = jDateTime::date("Y/m/d H:i:s");
		$sqldid = "SELECT *  FROM " . $GLOBALS["users_tablename"] .
			"," . $GLOBALS["domains_tablename"] .
			" WHERE " . $GLOBALS["d_user_id_fk"] . "=" . $GLOBALS["uid"]
			. " AND " . $GLOBALS["uid"] . "='" . $uid . "' AND " .
			$GLOBALS['d_name'] . "='" . $domainname . "' ";
		$conn = GetConnection();

		$re = $conn->query($sqldid);
		$ls = mysqli_fetch_all($re, MYSQLI_ASSOC);
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " . $GLOBALS["dnr_d_id_fk"] . "='" . $canAccess["data"]["domain_id"] . "' ORDER BY dnr_type,dnr_name " . $limit;
		$records = $conn->query($sql);
		$list = mysqli_fetch_all($records, MYSQLI_ASSOC);

		$rtype = ["A", "ANAME", "CNAME", "AAAA", "MX", "NS", "PTR", "SRV", "TXT"];
		$out = [];
		$arecords = [];
		$anamerecords = [];
		$cnamerecords = [];
		$aaaarecords = [];
		$mxrecords = [];
		$nsrecords = [];
		$ptrrecords = [];
		$srvrecords = [];
		$txtrecords = [];
		$i = 0;
		$a = [];
		foreach ($list as $r) {
			$i++;

			$type = $r["dnr_type"];
			$a[$i] = $type;
			if ($type == "A") {
				$nrow["balance"] = DNSBALANCER_ADMIN::GetListOfBalancers($r["dnrid"])["status"];
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["ip"] = $r["dnr_ip"];
				$nrow["ttl"] = $r["dnr_ttl"];
				$nrow["cdn"] = $r["dnr_proxied"];
				$nrow["port"] = $r["dnr_port"];
				$nrow["protocol"] = strtoupper($r["dnr_protocol"]);

				array_push($arecords, $nrow);
			}
			if ($type == "ANAME") {
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["ip"] = $r["dnr_ip"];
				$nrow["ttl"] = $r["dnr_ttl"];
				$nrow["cdn"] = $r["dnr_proxied"];
				array_push($anamerecords, $nrow);
			}
			if ($type == "AAAA") {
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["ip"] = $r["dnr_ip"];
				$nrow["ttl"] = $r["dnr_ttl"];
				$nrow["cdn"] = $r["dnr_proxied"];

				array_push($aaaarecords, $nrow);
			}
			if ($type == "CNAME") {
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["ip"] = $r["dnr_ip"];
				$nrow["ttl"] = $r["dnr_ttl"];
				$nrow["cdn"] = $r["dnr_proxied"];
				array_push($cnamerecords, $nrow);
			}
			if ($type == "MX") {
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["ip"] = $r["dnr_ip"];
				$nrow["priority"] = $r["dnr_priority"];
				$nrow["target"] = $r["dnr_value"];
				$nrow["ttl"] = $r["dnr_ttl"];
				array_push($mxrecords, $nrow);
			}
			if ($type == "NS") {
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["ip"] = $r["dnr_ip"];
				$nrow["nameserver"] = $r["dnr_value"];
				$nrow["ttl"] = $r["dnr_ttl"];
				array_push($nsrecords, $nrow);
			}
			if ($type == "PTR") {
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["nameserver"] = $r["dnr_value"];
				$nrow["ttl"] = $r["dnr_ttl"];
				array_push($ptrrecords, $nrow);
			}
			if ($type == "SRV") {
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["target"] = $r["dnr_value"];
				$nrow["priority"] = $r["dnr_priority"];
				$nrow["priority"] = $r["dnr_priority"];
				$nrow["protocol"] = $r["dnr_protocol"];
				$nrow["service"] = $r["dnr_service"];
				$nrow["weight"] = $r["dnr_weight"];
				$nrow["ttl"] = $r["dnr_ttl"];
				$nrow["port"] = $r["dnr_port"];
				array_push($srvrecords, $nrow);
			}
			if ($type == "TXT") {
				$nrow["id"] = $r["dnrid"];
				$nrow["name"] = $r["dnr_name"];
				$nrow["value"] = $r["dnr_value"];
				$nrow["ttl"] = $r["dnr_ttl"];
				array_push($txtrecords, $nrow);
			}
		}
		$arecord = [];
		$anamerecord = [];
		$cnamerecord = [];
		$aaaarecord = [];
		$mxrecord = [];
		$nsrecord = [];
		$ptrrecord = [];
		$srvrecord = [];
		$txtrecord = [];
		if (count($arecords) == "0") {
			$arecord["status"] = "noresult";
			$arecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$arecord["status"] = "success";
			$arecord["data"] = $arecords;
		}

		if (count($cnamerecords) == "0") {
			$cnamerecord["status"] = "noresult";
			$cnamerecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$cnamerecord["status"] = "success";
			$cnamerecord["data"] = $cnamerecords;
		}

		if (count($anamerecords) == "0") {
			$anamerecord["status"] = "noresult";
			$anamerecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$anamerecord["status"] = "success";
			$anamerecord["data"] = $anamerecords;
		}

		if (count($aaaarecords) == "0") {
			$aaaarecord["status"] = "noresult";
			$aaaarecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$aaaarecord["status"] = "success";
			$aaaarecord["data"] = $aaaarecords;
		}

		if (count($mxrecords) == "0") {
			$mxrecord["status"] = "noresult";
			$mxrecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$mxrecord["status"] = "success";
			$mxrecord["data"] = $mxrecords;
		}
		if (count($nsrecords) == "0") {
			$nsrecord["status"] = "noresult";
			$nsrecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$nsrecord["status"] = "success";
			$nsrecord["data"] = $nsrecords;
		}

		if (count($ptrrecords) == "0") {
			$ptrrecord["status"] = "noresult";
			$ptrrecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$ptrrecord["status"] = "success";
			$ptrrecord["data"] = $ptrrecords;
		}

		if (count($srvrecords) == "0") {
			$srvrecord["status"] = "noresult";
			$srvrecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$srvrecord["status"] = "success";
			$srvrecord["data"] = $srvrecords;
		}
		if (count($txtrecords) == "0") {
			$txtrecord["status"] = "noresult";
			$txtrecord["message"] = "رکوردی برای دامنه مورد نظر یافت نشد";
		} else {
			$txtrecord["status"] = "success";
			$txtrecord["data"] = $txtrecords;
		}

		$out["A"] = $arecord;
		$out["ANAME"] = $anamerecord;
		$out["CNAME"] = $cnamerecord;
		$out["AAAA"] = $aaaarecord;
		$out["MX"] = $mxrecord;
		$out["NS"] = $nsrecord;
		$out["PTR"] = $ptrrecord;
		$out["SRV"] = $srvrecord;
		$out["TXT"] = $txtrecord;

		return [
			"status" => "success",
			"currentpage" => $page,
			"countofpage" => $countofpage,
			"message" =>  "اطلاعات با موفقیت دریافت شد",
			"domain_id" => $ls[0]["domain_id"], $sql,
			"data" => $out
		];
		foreach ($rtype as $rt) {
			$now = jDateTime::date("Y/m/d H:i:s");
			if ($rt == "A" || $rt == "CNAME" || $rt == "ANAME" || $rt == "AAAA") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name,"
					. $GLOBALS['ip'] . " as ip," . $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS['proxied']
					. "  as cdn from " . $GLOBALS["domainsnsrecords_tablename"] . ","
					. $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " .
					$GLOBALS['type'] . "='" .
					$rt . "'";
			} else if ($rt == "MX") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name,"
					. $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS['priority']
					. "  as priority," . $GLOBALS["dnvalue"] . " as target from " .
					$GLOBALS["domainsnsrecords_tablename"] . "," .
					$GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " .
					$GLOBALS['type'] . "='" .
					$rt . "'";
			} else if ($rt == "TXT") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id,"
					. $GLOBALS['name'] . " as name," .
					$GLOBALS['ttl'] . " as ttl," . $GLOBALS["dnvalue"] . " as value from "
					. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " .
					$GLOBALS['type'] . "='" . $rt . "'";
			} else if ($rt == "NS") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," .
					$GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as nameserver from "
					. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["users_tablename"] .
					"," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " . $GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
					$rt . "'";
			} else if ($rt == "SRV") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as target," .
					$GLOBALS["priority"] . " as priority," .
					$GLOBALS["port"] . " as port," .
					$GLOBALS["protocol"] . " as protocol," .
					$GLOBALS["service"] . " as service," .
					$GLOBALS["weight"] . " as weight from "
					. $GLOBALS["domainsnsrecords_tablename"] . "," .
					$GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " .
					$GLOBALS['type'] . "='" . $rt . "'";
			} else if ($rt == "PTR") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," .
					$GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as nameserver from "
					. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " .
					$GLOBALS['type'] . "='" . $rt . "'";
			}
			$conn = GetConnection();

			$result = $conn->query($sql);
			// $listOfRecordType=mysqli_fetch_array ($result,MYSQLI_ASSOC);
			if (!$result || mysqli_num_rows($result) == 0) {
				//// VARS_ADMIN::ReturnHeaders(400);
				$d = ["status" => "noresult", "message" => "رکوردی برای دامنه مورد نظر یافت نشد"];
				$conn->close();
				//return $result;
			} else {

				$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
				$d = ["status" => "success", "data" => $listOfRecordType];
				$conn->close();
			}


			$out[$rt] =  $d;
		}
		$response = [
			"status" => "success",
			"message" =>  "اطلاعات با موفقیت دریافت شد",
			"domain_id" => $canAccess["data"]["domain_id"],
			"data" => $out
		];

		return $response;
	}
	public static function GetCountOfRecords($domainid)
	{
		$sql = "SELECT count(dnrid) as cnt FROM  " . $GLOBALS["domainsnsrecords_tablename"]
			. " WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $domainid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$d = ["status" => "noresult", "message" => "رکوردی برای دامنه مورد نظر یافت نشد"];
			$conn->close();
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$d = ["status" => "success", "data" => $listOfRecordType];
			$conn->close();
		}
		return $d;
	}
	public static function GetOneRecordByID($recordid, $token, $domainid, $domainname)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return [
				"status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
			];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$sql = "SELECT *, dnr_type as type, dnr_name as host, dnr_ip as ip, dnr_ttl as ttl, dnr_proxied as proxied FROM " . $GLOBALS['domainsnsrecords_tablename'] . "," .
			$GLOBALS['domains_tablename'] . " WHERE " . $GLOBALS['dnr_d_id_fk'] . "=" . $GLOBALS['domain_id'] . " AND " .
			$GLOBALS['dnrid'] . "=" . $recordid . " AND " . $GLOBALS['dnr_d_id_fk'] . "=" . $domainid . " AND " .
			$GLOBALS['d_user_id_fk'] . "=" . $uid;
		$conn = GetConnection();

		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return ["status" => "error"];
		} else {
			$listOfRecordType = mysqli_fetch_array($result, MYSQLI_ASSOC);
			$conn->close();
			$balacer = DNSBALANCER_ADMIN::GetListOfBalancers($recordid);
			if ($balacer["status"] == "balance") {
				return ["status" => "success", "data" => $listOfRecordType, "balance" => "balance"];
			} else {
				return ["status" => "success", "balance" => "nobalance", "data" => $listOfRecordType];
			}
		}
	}
	public static function InternalGetOneRecordByID($recordid)
	{
		$sql = "SELECT *, dnr_type as type, dnr_name as host, dnr_ip as ip, dnr_ttl as ttl, dnr_proxied as proxied  FROM " . $GLOBALS['domainsnsrecords_tablename'] .  "," . $GLOBALS['domains_tablename'] . " WHERE  domain_id=dnr_d_id_fk  and " . $GLOBALS['dnrid'] . "=" . $recordid;
		$conn = GetConnection();

		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return ["status" => "error"];
		} else {
			$listOfRecordType = mysqli_fetch_array($result, MYSQLI_ASSOC);
			$conn->close();
			$plans = ReturnPlans()[$listOfRecordType["d_plan"]];
			return ["status" => "success", "plan" => $plans, "data" => $listOfRecordType];
		}
	}
	public static function InternalChangeCloudStatus($recordid, $domainname, $status = "1")
	{
		$sql = "UPDATE " . $GLOBALS['domainsnsrecords_tablename'] . " SET " .
			$GLOBALS['proxied'] . "='" . $status . "' WHERE " .
			$GLOBALS['dnrid'] . "=" . $recordid;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();

		$RecordDetails = self::InternalGetOneRecordByID($recordid);
		$uid = $RecordDetails["data"]["d_user_id_fk"];
		if ($domainname == $RecordDetails["data"]["dnr_name"]) {
			if ($RecordDetails["data"]["dnr_name"] != "www") {
				if ($RecordDetails["data"]["dnr_name"] != "@") {
					$o[4] = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainname, $RecordDetails["data"]["dnr_name"], 1);
					$o[3] = API_CDN_ADMIN::RunCreateAPICDN($domainname, $RecordDetails["data"]["dnr_ip"]);
					API_CAHCE_ADMIN::RunCacheVars($domainname, $RecordDetails["plan"]["zone"], $RecordDetails["plan"]["maxsize"]);
				}
			}
		} else {
			if ($RecordDetails["data"]["dnr_name"] != "www") {
				if ($RecordDetails["data"]["dnr_name"] != "@") {
					$o[1] = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainname, $RecordDetails["data"]["dnr_name"], 1);


					if (self::CheckNeedToBalance($RecordDetails["data"]["domain_id"], $RecordDetails["data"]["dnr_name"])["status"] != "success") {
						$o[2] = API_CDN_ADMIN::RunCreateAPICDN(
							$RecordDetails["data"]["dnr_name"] . "." . $domainname,
							$RecordDetails["data"]["dnr_ip"]
						);
						API_CAHCE_ADMIN::RunCacheVars($domainname, $RecordDetails["plan"]["zone"], $RecordDetails["plan"]["maxsize"]);
					}
				}
			}
		}


		if ($status == "1") {
			$RecordDetails["data"]["dnr_proxied"] = "1";
			$RecordDetails["data"]["proxied"] = "1";
			// self::CreateRecordForDelete($RecordDetails["data"],$domainname,$recordid);
			// self::CreateRecordForAdd($RecordDetails["data"],$domainname,$recordid) ;
			self::CreateRecordForUpdate($RecordDetails["data"], $domainname, $recordid, self::UserCanAccessToRecord($uid, $recordid)["data"][0]);
		} else {
			$RecordDetails["data"]["dnr_proxied"] = "0";
			$RecordDetails["data"]["proxied"] = "0";
			// self::CreateRecordForDelete($RecordDetails["data"],$domainname,$recordid);
			// self::CreateRecordForAdd($RecordDetails["data"],$domainname,$recordid) ;
			self::CreateRecordForUpdate($RecordDetails["data"], $domainname, $recordid, self::UserCanAccessToRecord($uid, $recordid)["data"][0]);
		}



		// self::GenerateDNSFile($domainname);
		return   $RecordDetails;
	}
	public static function ChangeCloudStatus($recordid, $token, $status, $domain, $domainname)
	{

		$validstatus = ["0", "1"];
		if (!isset($validstatus[$status])) {
			return ["status" => "error", "message" => "وضعیت ارسالی نامعتبر است"];
		}

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		// return $usersDetails;
		if ($status == "1") {
			if ($usersDetails["credit"] < 0) {
				return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
			}
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$ur = self::UserCanAccessToRecord($uid, $recordid);
		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domainname, $token);

		if ($canAccess["status"] == "error") {
			return ["status" => "error", "message" => "شما مجوز دسترسی به این دامنه را ندارید  "];
		}
		$mainsite = WEBSITES_ADMIN::getmainrecord($token, $canAccess["data"]["domain_id"]);
		//   return $mainsite;

		$RecordDetails = self::GetOneRecordByID($recordid, $token, $domain, $domainname);
		if (
			$RecordDetails["data"]["dnr_type"] == "A" ||
			$RecordDetails["data"]["dnr_type"] == "CNAME" ||
			$RecordDetails["data"]["dnr_type"] == "ANAME" ||
			$RecordDetails["data"]["dnr_type"] == "AAAA"
		) {

			if (strpos($RecordDetails["data"]["dnr_name"], "*") !== false && $status == "1") {
				if (!isset($mainsite["plan"])) {
					return [
						"status" => "error", $mainsite["plan"],
						"message" =>  "پلان وب سایت اصلی شما امکان استفاده از این رکورد را ندارید برای استفاده از این رکورد باید پلان خود را ارتقا دهید"
					];
				}
				$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($mainsite["webid"], $uid);
				$planwebsite = $websitesOwner["data"][0]["d_plan"];

				$plans = ReturnPlans();
				if (isset($plans[$planwebsite])) {
					if (!isset($plans[$planwebsite]["wildcard"])) {
						return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
					}
				} else {
					return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
				}
			}

			$current = $RecordDetails["data"]["dnr_proxied"];
			if ($current == $status) {
				return ["status" => "error", "message" => "وضعیت فعلی و درخواستی شما برای ابر در این رکورد یکسان است"];
			} else {
				if (DNSBALANCER_ADMIN::GetListOfBalancers($ur["data"][0]["dnrid"])["status"] == "balance" && $status == "1") {
					return ["status" => "error", "message" => "رکورد درخواستی شما دارای کلاستر است و امکان فعالسازی CDN را ندارد"];
				}
				// return DNSBALANCER_ADMIN::GetListOfBalancers($r["dnrid"]);
				$sql = "UPDATE " . $GLOBALS['domainsnsrecords_tablename'] . " SET " .
					$GLOBALS['proxied'] . "='" . $status . "' WHERE " .
					$GLOBALS['dnrid'] . "=" . $recordid;
				$conn = GetConnection();
				$conn->query($sql);
				$conn->close();
				$RecordDetails = self::InternalGetOneRecordByID($recordid);
				if ($status == "1") {
					if ($domainname == $RecordDetails["data"]["dnr_name"]) {
						if ($RecordDetails["data"]["dnr_name"] != "www") {
							if ($RecordDetails["data"]["dnr_name"] != "@") {

								$c = WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domain, $RecordDetails["data"]["dnr_name"], 1);

								$a = API_CDN_ADMIN::RunCreateAPICDN($domainname, $RecordDetails["data"]["dnr_ip"], "scheme");
								API_CAHCE_ADMIN::RunCacheVars($domainname, $RecordDetails["plan"]["zone"], $RecordDetails["plan"]["maxsize"]);
							}
						} else {
							WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domain, $RecordDetails["data"]["dnr_name"], 1);
							$a = API_CDN_ADMIN::RunCreateAPICDN($domainname, $RecordDetails["data"]["dnr_ip"], "scheme");
							API_CAHCE_ADMIN::RunCacheVars($domainname, $RecordDetails["plan"]["zone"], $RecordDetails["plan"]["maxsize"]);
							// API_CDN_ADMIN::RunAddWWWRecord($domainname,"add");
						}
					} else {
						if ($RecordDetails["data"]["dnr_name"] != "www") {
							if ($RecordDetails["data"]["dnr_name"] != "@") {
								WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domain, $RecordDetails["data"]["dnr_name"], 1);

								API_CDN_ADMIN::RunCreateAPICDN(
									$RecordDetails["data"]["dnr_name"] . "." . $domainname,
									$RecordDetails["data"]["dnr_ip"]
								);
								API_CAHCE_ADMIN::RunCacheVars(
									$RecordDetails["data"]["dnr_name"] . "." . $domainname,
									$RecordDetails["plan"]["zone"],
									$RecordDetails["plan"]["maxsize"]
								);
							}
						} else {
							WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domain, $RecordDetails["data"]["dnr_name"], 1);
							API_CDN_ADMIN::RunCreateAPICDN(
								$RecordDetails["data"]["dnr_name"] . "." . $domainname,
								$RecordDetails["data"]["dnr_ip"]
							);
							API_CAHCE_ADMIN::RunCacheVars(
								$RecordDetails["data"]["dnr_name"] . "." . $domainname,
								$RecordDetails["plan"]["zone"],
								$RecordDetails["plan"]["maxsize"]
							);
							// API_CDN_ADMIN::RunAddWWWRecord($domainname,"add");
						}
					}
				}
				if ($status == "0") {
					if ($RecordDetails["data"]["dnr_name"] != $domainname)
						API_CDN_ADMIN::RunDeleteSignleDomainCDN($RecordDetails["data"]["dnr_name"] . "." . $domainname);
					else
						API_CDN_ADMIN::RunDisableAPICDN($domainname);
					if ($domainname == $RecordDetails["data"]["dnr_name"]) {

						// WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domain, $RecordDetails["data"]["dnr_name"], 0);
						// WEBSITES_ADMIN::DeleteWebSite($RecordDetails["data"]["dnr_name"],$RecordDetails["data"]["dnr_d_id_fk"]);

						// API_CDN_ADMIN::RunDisableAPICDN($domainname, $RecordDetails["data"]["dnr_ip"]);
					} else {

						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domain, $RecordDetails["data"]["dnr_name"], 0);
						WEBSITES_ADMIN::DeleteWebSite($RecordDetails["data"]["dnr_name"], $RecordDetails["data"]["dnr_d_id_fk"]);

						// API_CDN_ADMIN::RunDisableAPICDN(
						//     $RecordDetails["data"]["dnr_name"] . "." . $domainname,
						//     $RecordDetails["data"]["dnr_ip"]
						// );
					}
					if ($RecordDetails["data"]["dnr_name"] == "www") {

						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domain, $RecordDetails["data"]["dnr_name"], 0);
						WEBSITES_ADMIN::DeleteWebSite($RecordDetails["data"]["dnr_name"], $RecordDetails["data"]["dnr_d_id_fk"]);

						// API_CDN_ADMIN::RunDisableAPICDN(
						//     $RecordDetails["data"]["dnr_name"] . "." . $domainname,
						//     $RecordDetails["data"]["dnr_ip"]
						// );
						// API_CDN_ADMIN::RunAddWWWRecord($domainname,"remove");
					}
				}
				if ($RecordDetails["data"]["dnr_type"] == "A" && $status == "1") {
					$c = BACKENDPROTOCOL_ADMIN::InternalUpdateDefaultValue($canAccess["data"]["domain_id"], $RecordDetails["data"]["dnr_name"], "auto");
				}
				// self::GenerateDNSFile($domainname,"","",$recordid);
				// DNSBALANCER_ADMIN::AddDomainToQueue($domainname,"bind");
				if ($status == "1") {
					$RecordDetails["data"]["dnr_proxied"] = "1";
					$RecordDetails["data"]["proxied"] = "1";
					// self::CreateRecordForDelete($RecordDetails["data"],$domainname,$recordid);
					// self::CreateRecordForAdd($RecordDetails["data"],$domainname,$recordid) ;$RecordDetails
					$ur = self::UserCanAccessToRecord($uid, $recordid);
					self::CreateRecordForUpdate($RecordDetails["data"], $domainname, $recordid, $ur["data"][0]);
				} else {
					$RecordDetails["data"]["dnr_proxied"] = "0";
					$RecordDetails["data"]["proxied"] = "0";
					// self::CreateRecordForDelete($RecordDetails["data"],$domainname,$recordid);
					// self::CreateRecordForAdd($RecordDetails["data"],$domainname,$recordid) ;
					self::CreateRecordForUpdate($RecordDetails["data"], $domainname, $recordid, $ur["data"][0]);
				}
				return [
					"status" => "success", "message" => "درخواست شما با موفقیت انجام شد",
					$domain
				];
			}
		} else {
			return [$RecordDetails, "status" => "error", "message" => "رکورد درخواستی شما قابلیت فعال کردن ابر را ندارد"];
		}
	}
	public static function RecordsForGenerateFile($domainname)
	{
		//
		$rtype = ["A", "ANAME", "CNAME", "AAAA", "MX", "NS", "PTR", "SRV", "TXT"];
		$out = [];
		foreach ($rtype as $rt) {
			$now = jDateTime::date("Y/m/d H:i:s");
			if ($rt == "A" || $rt == "CNAME" || $rt == "ANAME" || $rt == "AAAA") {
				$sql = "SELECT domain_id," . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ip'] . " as ip," .
					$GLOBALS['ttl'] . " as ttl," . $GLOBALS['proxied']
					. "  as cdn from " . $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " .
					$GLOBALS['type'] . "='" .
					$rt . "' and d_status!=2";
			} else if ($rt == "MX") {
				$sql = "SELECT domain_id,domain_id," . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," . $GLOBALS['priority']
					. "  as priority," . $GLOBALS["dnvalue"] . " as target from " .
					$GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND "
					. $GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
					$rt . "' and d_status!=2";
			} else if ($rt == "TXT") {
				$sql = "SELECT domain_id," . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as value from "
					. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
					$rt . "' and d_status!=2";
			} else if ($rt == "NS") {
				$sql = "SELECT domain_id," . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as nameserver from "
					. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
					$rt . "' and d_status!=2";
			} else if ($rt == "SRV") {
				$sql = "SELECT domain_id," . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as value," .
					$GLOBALS["priority"] . " as priority," .
					$GLOBALS["port"] . " as port," . $GLOBALS["service"] . " as service," . $GLOBALS["protocol"] . " as protocol," .
					$GLOBALS["weight"] . " as weight from "
					. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
					$GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
					$rt . "' and d_status!=2";
			} else if ($rt == "PTR") {
				$sql = "SELECT domain_id," . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as nameserver from "
					. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
					" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND "
					. $GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
					$rt . "' and d_status!=2";
			}
			$conn = GetConnection();

			$result = $conn->query($sql);
			if (!$result || mysqli_num_rows($result) == 0) {

				$listOfRecordType = ["status" => "error"];
				$conn->close();
			} else {
				$listOfRecordType = [
					"status" => "success",
					"data" => mysqli_fetch_all($result, MYSQLI_ASSOC)
				];
				$conn->close();
			}


			$out[$rt] = $listOfRecordType;
		}
		return $out;
	}
	public static function GetListOfAllRecordWithoutToken($domainname)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] . " WHERE "
			. $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND "
			. $GLOBALS['d_name'] . "='" . $domainname . "' and d_status!=2";
		$conn = GetConnection();

		$result = $conn->query($sql);
		// $listOfRecordType=mysqli_fetch_array ($result,MYSQLI_ASSOC);
		if (!$result || mysqli_num_rows($result) == 0) {

			$listOfRecordType = ["status" => "error"];
			$conn->close();
		} else {
			$listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
			$conn->close();
		}
		return $listOfRecordType;
	}
	public static function SearchRecords($token, $domain, $did, $phrase)
	{
		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domain, $token);
		if ($canAccess["status"] == "error") {
			// VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شما مجوز دسترسی به این دامنه را ندارید"];
		}
		// $extra = "(";
		// if ($phrase == $domain) {
		//     $extra .=   $GLOBALS['dnvalue'] . " LIKE '%@%' or " . $GLOBALS['name'] . " LIKE '%@%' or ";
		// }

		// if ($phrase == '@') {
		//     $extra .=   $GLOBALS['dnvalue'] . " LIKE '%" . $domain . "%' or " . $GLOBALS['name'] . " LIKE '%"
		//         . $domain . "%'";
		// }
		// $extra = ")";

		// $WHEREClause = "  and " . $GLOBALS["dnr_d_id_fk"] . "=" . $did . " AND (" .
		//     $GLOBALS['dnvalue'] . " LIKE '%" . $phrase . "%' or " . $GLOBALS['name'] . " LIKE '%" . $phrase . "%' or " . $GLOBALS['ip'] . " LIKE '%" . $phrase . "%')";

		// if ($phrase == $domain) {
		//     $WHEREClause = " AND " . $GLOBALS["dnr_d_id_fk"] . "=" . $did . "  " . "   " . $WHEREClause;
		// }

		if ($phrase == '@') {
			$phrase == $domain;
			// $WHEREClause =  " AND " . $GLOBALS["dnr_d_id_fk"] . "=" . $did . "  " . $WHEREClause . "   ";
		}

		$rtype = ["A", "ANAME", "CNAME", "AAAA", "MX", "NS", "PTR", "SRV", "TXT"];
		$out = [];
		foreach ($rtype as $rt) {
			$now = jDateTime::date("Y/m/d H:i:s");
			if ($rt == "A" || $rt == "CNAME" || $rt == "ANAME" || $rt == "AAAA") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," .
					$GLOBALS['ip'] . " as ip," .
					$GLOBALS['ttl'] . " as ttl," . $GLOBALS['proxied']
					. "  as cdn,dnr_port as port , dnr_protocol as protocol from " . $GLOBALS["domainsnsrecords_tablename"] .
					" WHERE " .
					$GLOBALS['type'] . "='" . $rt . "'  AND ( dnr_name LIKE '%" . $phrase . "%'
                     OR dnr_ip LIKE '%" . $phrase . "%')";
			} else if ($rt == "MX") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name']
					. " as name," . $GLOBALS['ttl'] . " as ttl," . $GLOBALS['priority']
					. "  as priority," . $GLOBALS["dnvalue"] . " as target from " .
					$GLOBALS["domainsnsrecords_tablename"] .
					" WHERE "  . $GLOBALS['type'] . "='" . $rt . "' AND ( dnr_name LIKE '%" . $phrase . "%' OR
                    dnr_priority LIKE '%" . $phrase . "%' or  dnr_value LIKE '%" . $phrase . "%')";
			} else if ($rt == "TXT") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," .
					$GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as value from "
					. $GLOBALS["domainsnsrecords_tablename"] .
					" WHERE " . $GLOBALS['type'] . "='" . $rt . "' AND ( dnr_name LIKE '%" . $phrase . "%' OR
                       dnr_value LIKE '%" . $phrase . "%') ";
			} else if ($rt == "NS") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as nameserver from "
					. $GLOBALS["domainsnsrecords_tablename"] .
					" WHERE " . $GLOBALS['type'] . "='" .
					$rt . "'  AND ( dnr_name LIKE '%" . $phrase . "%' OR
                    dnr_value LIKE '%" . $phrase . "%')  ";
			} else if ($rt == "SRV") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," .
					$GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as value," .
					$GLOBALS["priority"] . " as priority," .
					$GLOBALS["port"] . " as port," .
					$GLOBALS["weight"] . " as weight from "
					. $GLOBALS["domainsnsrecords_tablename"] .
					" WHERE " . $GLOBALS['type'] . "='" .   $rt . "'  AND (
                        dnr_name LIKE '%" . $phrase . "%' OR
                        dnr_value LIKE '%" . $phrase . "%' OR
                        dnr_priority LIKE '%" . $phrase . "%' OR
                        dnr_port LIKE '%" . $phrase . "%'  OR
                        dnr_weight LIKE '%" . $phrase . "%'  ) ";
			} else if ($rt == "PTR") {
				$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," .
					$GLOBALS["dnvalue"] . " as nameserver from "
					. $GLOBALS["domainsnsrecords_tablename"] .
					" WHERE " .  $GLOBALS['type'] . "='" . $rt . "'
                      AND ( dnr_name LIKE '%" . $phrase . "%' OR
                            dnr_value LIKE '%" . $phrase . "%')  ";
			}
			// return $sql;
			$conn = GetConnection();

			$result = $conn->query($sql);
			// $listOfRecordType=mysqli_fetch_array ($result,MYSQLI_ASSOC);
			if (!$result || mysqli_num_rows($result) == 0) {

				$listOfRecordType = ["status" => "error"];
				$conn->close();
			} else {
				$li = mysqli_fetch_all($result, MYSQLI_ASSOC);
				$listOfRecordType = ["status" => "success",  "data" => $li];
				$conn->close();
			}

			$out[$rt] = $listOfRecordType;
		}
		if (array_key_exists("data", $out["A"])) {
			for ($i = 0; $i < count($out["A"]["data"]); $i++) {

				$out["A"]["data"][$i]["balance"] = DNSBALANCER_ADMIN::GetListOfBalancers($out["A"]["data"][$i]["id"])["status"];

				// return DNSBALANCER_ADMIN::GetListOfBalancers($r["dnrid"]);
			}
		}

		return ["status" => "success", "data" => $out];

		$conn = GetConnection();

		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$listOfRecordType = ["status" => "error", "message" => "رکوردی با متن درخواستی یافت نشد"];
			$conn->close();
		} else {
			$listOfRecordType = [
				"status" => "success",
				"message" => "درخواست شما با موفقیت دریافت شد ",
				"data" => mysqli_fetch_all($result, MYSQLI_ASSOC)
			];
			$conn->close();
		}
		return $listOfRecordType;
	}
	public static function GenerateDNSFile($dname, $first = "second", $internal = false, $recordid = 0)
	{

		// $records = DOMAINNSRECORD_ADMIN::GetListOfAllRecordWithoutToken($dname);
		$records = DOMAINNSRECORD_ADMIN::RecordsForGenerateFile($dname);

		$NSRecord = NAMESERVERS_ADMIN::GetNameServerRecordsForDomain($dname);
		$rangeIPS = CDNRANGEIPS_ADMIN::GetListByStatus($NSRecord["data"][0]["organize"]);

		$ns1 = $NSRecord["data"][0]["ns1"];
		$ns2 = $NSRecord["data"][0]["ns2"];
		if ($records["A"]["status"] == "success") {
			$dmnr = DOMAINS_ADMIN::GetDomainMainRecord("12", $records["A"]["data"][0]["domain_id"]);
			if ($dmnr["status"] == "success") {
				if ($dmnr["data"][0]["d_ddns"] != "0") {
					$nss = NAMESERVERS_ADMIN::GetOne($dmnr["data"][0]["d_ddns"]);
					$ns1 = $nss[0]["ns1"];
					$ns2 = $nss[0]["ns2"];
				}
			}
		}
		$my_file = $GLOBALS["RootFiles"] . "/dnsfiles/" . Punycode::encodeHostName($dname);
		$handle = fopen($my_file, 'w') or die('Cannot open file:  ' . $my_file);


		$data = trim(
			"; Mizban Cloud DNS Server Data File for Local Loopback Interface
         ;
\$TTL    604800
@       IN      SOA     " . $ns1 . ". dns.mizbancloud.com. (
        2022040201         ; Serial
        3600               ; Refresh
        1800               ; Retry
        1209600            ; Expire
        86400  )           ; Negative Cache TTL
        ;
@     86400  IN      NS      " . $ns1 . ".
@     86400  IN      NS      " . $ns2 . "."
		);
		$arecord = "";
		$r = "";
		$nrow = [];
		$balance["status"] = "nobalance";
		if ($records["A"]["status"] == "success") {
			foreach ($records["A"]["data"] as $d) {
				$nrow = DNSBALANCER_ADMIN::GetListOfBalancers($d["id"]);

				if ($recordid != 0 && $recordid == $d["id"]) {
					$balance = DNSBALANCER_ADMIN::GetListOfBalancersAndWrite(
						$NSRecord["data"][0]["ns1"],
						$dname,
						$d["id"],
						$d["ttl"],
						$d["name"],
						$first
					);
				}

				if ($d["ttl"] == "0") {
					$d["ttl"] = "120";
				}
				if ($nrow["status"]  == "balance") {
					//  if($recordid!=0 && $recordid==$d["id"]){
					// DNSBALANCER_ADMIN::GenerateDNSBalancerFile(
					//     $NSRecord["data"][0]["ns1"],
					//     $dname,
					//     $d["id"],
					//     $d["ttl"],
					//     $d["name"],
					//     $first
					// );
					//  }
				} else {
					if ($d["cdn"] == "1") {

						foreach ($rangeIPS["v4"] as $cdnips) {
							if ($d["name"] == $dname) {
								$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". 120 IN    A " . $cdnips["crip"];
							} else {
								$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  120  IN    A " . $cdnips["crip"];
							}
						}
						foreach ($rangeIPS["v6"] as $cdnips) {

							if ($d["name"] == $dname) {
								$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". 120 IN    AAAA " . $cdnips["crip"];
							} else {
								$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  120  IN    AAAA " . $cdnips["crip"];
							}
						}
					} else {
						if ($d["name"] == $dname) {
							if ($d["ttl"] == 0) {
								$d["ttl"] = 120;
							}
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". " . $d["ttl"] . " IN    A   " .  $d["ip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  " . $d["ttl"] . " IN    A " .  $d["ip"];
						}
					}
				}
			}
		}
		if ($records["CNAME"]["status"] == "success") {

			foreach ($records["CNAME"]["data"] as $d) {
				if ($d["ttl"] == "0") {
					$d["ttl"] = "120";
				}
				if ($d["cdn"] == "1") {
					foreach ($rangeIPS["v4"] as $cdnips) {
						if ($d["name"] == $dname) {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". 120 IN    A " . $cdnips["crip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  120  IN    A " . $cdnips["crip"];
						}
					}
					foreach ($rangeIPS["v6"] as $cdnips) {
						if ($d["name"] == $dname) {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". 120 IN    AAAA " . $cdnips["crip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  120  IN    AAAA " . $cdnips["crip"];
						}
					}
				} else {
					if ($d["ttl"] == "0") {
						$d["ttl"] = 120;
					}
					if ($d["name"] == $dname) {

						$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". " . $d["ttl"] . " IN    CNAME " . $d["ip"] . ".";
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  " . $d["ttl"] . " IN    CNAME " . $d["ip"] . ".";
					}
				}
			}
		}
		if ($records["ANAME"]["status"] == "success") {
			foreach ($records["ANAME"]["data"] as $d) {
				if ($d["ttl"] == "0") {
					$d["ttl"] = "120";
				}
				if ($d["cdn"] == "1") {
					foreach ($rangeIPS["v4"] as $cdnips) {
						if ($d["name"] == $dname) {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". 120 IN    A " . $cdnips["crip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  120  IN    A " . $cdnips["crip"];
						}
					}
					foreach ($rangeIPS["v6"] as $cdnips) {
						if ($d["name"] == $dname) {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". 120 IN    AAAA " . $cdnips["crip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  120  IN    AAAA " . $cdnips["crip"];
						}
					}
				} else {
					if ($d["ttl"] == "0") {
						$d["ttl"] = 120;
					}
					if ($d["name"] == $dname) {

						$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". " . $d["ttl"] . " IN    CNAME " . $d["ip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ".  " . $d["ttl"] . " IN    CNAME " . $d["ip"];
					}
				}
			}
		}
		if ($records["AAAA"]["status"] == "success") {
			foreach ($records["AAAA"]["data"] as $d) {
				if ($d["ttl"] == "0") {
					$d["ttl"] = "120";
				}

				if ($d["cdn"] == "1") {
					foreach ($rangeIPS["v6"] as $cdnips) {
						if ($d["name"] == $dname) {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". 120 IN    AAAA " . $cdnips["crip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  120 IN    AAAA " . $cdnips["crip"];
						}
					}
				} else {

					if ($d["name"] == $dname) {

						$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". " . $d["ttl"] . " IN    AAAA " . $d["ip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  " . $d["ttl"] . " IN    AAAA " . $d["ip"];
					}
				}
			}
		}
		if ($records["MX"]["status"] == "success") {
			foreach ($records["MX"]["data"] as $d) {
				if ($d["ttl"] == "0") {
					$d["ttl"] = "120";
				}
				if ($d["name"] == $dname) {
					$outputval = str_replace("..", ".", Punycode::encodeHostName($d["target"]) . ".");
					$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". " . $d["ttl"] . " IN    MX " . $d["priority"] . " " . $outputval;
				} else {
					$outputval = str_replace("..", ".", Punycode::encodeHostName($d["target"]) . ".");
					$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  " . $d["ttl"] . " IN    MX " . $d["priority"] . "  " . $outputval;
				}
			}
		}
		if ($records["TXT"]["status"] == "success") {
			foreach ($records["TXT"]["data"] as $d) {
				if ($d["ttl"] == "0") {
					$d["ttl"] = "120";
				}
				if ($d["name"] == $dname) {

					$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". " . $d["ttl"] . " IN TXT " . self::ValidateTXTString($d["value"]);
				} else {
					$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . " " . $d["ttl"] . " IN TXT " . self::ValidateTXTString($d["value"]);
				}
			}
		}
		if ($records["SRV"]["status"] == "success") {
			//_service._protocolName  IN SRV priority weight portNO subdns.domain.com
			foreach ($records["SRV"]["data"] as $d) {
				if ($d["name"] == $dname) {
					if ($d["ttl"] == "0") {
						$d["ttl"] = "120";
					}
					$arecord .= "\n" . $d["service"] . "._" . $d["protocol"] . "." .  Punycode::encodeHostName($d["name"]) . ". " . $d["ttl"] . " IN    SRV  " . $d["priority"] . "  " . $d["weight"] . "  " . $d["port"] . "  " . Punycode::encodeHostName($d["value"]);
				} else {
					$arecord .= "\n" . $d["service"] . "._" . $d["protocol"] . "." . Punycode::encodeHostName($d["name"]) . "  " . $d["ttl"] . " IN    SRV  " . $d["priority"] . "  " . $d["weight"] . "  " . $d["port"] . "  " . Punycode::encodeHostName($d["value"]);
				}
			}
		}
		if ($records["PTR"]["status"] == "success") {
			// name ttl  class   rr     name
			foreach ($records["PTR"]["data"] as $d) {
				if ($d["ttl"] == "0") {
					$d["ttl"] = "120";
				}
				if ($d["name"] == $dname) {
					$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . ". " . $d["ttl"] . " IN    PTR  " . Punycode::encodeHostName($d["nameserver"]) . ".";
				} else {
					$arecord .= "\n" . Punycode::encodeHostName($d["name"]) . "  " . $d["ttl"] . " IN    PTR    " . Punycode::encodeHostName($d["nameserver"]) . ".";
				}
			}
		}

		$data .= $arecord . "
";

		fwrite($handle, $data);
		API_DOMAIN_ADMIN::CreateZone($dname, $data);
		// if($internal){
		//      API_DOMAIN_ADMIN::RunAddAPI($dname);
		// }
		//
		//  if($first=="first"){
		//         DNSBALANCER_ADMIN::AddDomainToQueue($dname,"bind");
		//   }
		//  DNSBALANCER_ADMIN::AddDomainToQueue($dname,"bind");
		//  DNSBALANCER_ADMIN::AddDomainToQueue($requestedDomain);
		return $data;
	}
	public static function GetListOfRecord($domainname, $token, $rtype = null)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token, "GetCredit");

		if ($usersDetails["status"] == "error") {
			return [
				"status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
			];
		}


		$uid = $usersDetails["userdetail"][0]["uid"];
		$now = jDateTime::date("Y/m/d H:i:s");
		if ($rtype == "A" || $rtype == "CNAME" || $rtype == "ANAME" || $rtype == "AAAA") {
			$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] .
				" as name," . $GLOBALS['ip'] . " as ip," . $GLOBALS['ttl'] . " as ttl,"
				. $GLOBALS['proxied']
				. "  as cdn from " . $GLOBALS["domainsnsrecords_tablename"] . "," .
				$GLOBALS["domains_tablename"] .
				" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
				$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " .
				$GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
				$rtype . "'";
		} else if ($rtype == "MX") {
			$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," . $GLOBALS['priority']
				. "  as priority," . $GLOBALS["dnvalue"] . " as target from " .
				$GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
				" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
				$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " . $GLOBALS['d_name'] . "='"
				. $domainname . "' AND " . $GLOBALS['type'] . "='" .
				$rtype . "'";
		} else if ($rtype == "TXT") {
			$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," . $GLOBALS["dnvalue"] . " as value from "
				. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["users_tablename"] .
				"," . $GLOBALS["domains_tablename"] .
				" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
				$GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " .
				$GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
				$rtype . "'";
		}

		$conn = GetConnection();

		$result = $conn->query($sql);
		// $listOfRecordType=mysqli_fetch_array ($result,MYSQLI_ASSOC);
		if (!$result || mysqli_num_rows($result) == 0) {
			// VARS_ADMIN::ReturnHeaders(400);
			$result = ["status" => "noresult", "message" => "رکوردی برای دامنه مورد نظر یافت نشد"];
			$conn->close();
			return $result;
		} else {
			$l = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$result = ["status" => "success", "data" => $l];
		}

		$conn->close();
		return $result;
	}
	public static function ValidateString($str)
	{
		$validchar = [
			"a", "b", "c", "d", "e", "f", "g", "h", "i", "j",
			"k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z",
			"A", "B", "C", "D", "E", "F", "G", "H", "I", "J",
			"K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
			"0", ".", "_",
			"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "-", "@", ".", "ذ", "د", "خ", "ح", "چ", "ج", "ث", "ت", "پ", "ب", "آ", "ا",
			"ی", "ه", "و", "ن", "م", "ل", "گ", "ک", "ق", "ف", "غ", "ع", "ظ", "ط", "ض", "ص", "ش", "س", "ژ", "ز", "ر"
		];
		return in_array($str, $validchar);
	}
	public static function CheckRecordDuplicated($type, $domainid, $posteddata)
	{
		if ($type == "A" || $type == "CNAME" || $type == "AAAA") {
			$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
				" WHERE dnr_type='" . $type . "'
            and " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "' and dnr_name='" . $posteddata["host"] .
				"' AND dnr_ip='" . $posteddata["ip"] . "' ";
			$conn = GetConnection();
			$result = $conn->query($sql);
			if (!$result || mysqli_num_rows($result) == 0) {
				return ["status" => "unique", $sql];
			} else {
				return ["status" => "duplicated"];
			}
		} else if ($type == "TXT" || $type == "PTR" || $type == "NS") {
			$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
				" WHERE dnr_type='" . $type . "'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "' AND dnr_name='" . $posteddata["host"] . "' AND dnr_value='" . $posteddata["value"] . "'";
			$conn = GetConnection();
			$result = $conn->query($sql);
			if ($result && mysqli_num_rows($result) > 0)
				return ["status" => "duplicated"];
			return ["status" => "unique", $sql];
		} else if ($type == "MX") {
			$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
				" WHERE dnr_type='" . $type . "'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "' AND dnr_name='" . $posteddata["host"] . "' AND dnr_value='" . $posteddata["value"] . "' AND dnr_priority='" . $posteddata["priority"] . "'";
			$conn = GetConnection();
			$result = $conn->query($sql);
			if ($result && mysqli_num_rows($result) > 0)
				return ["status" => "duplicated"];
			return ["status" => "unique", $sql];
		} else if ($type == "SRV") {
			$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
				" WHERE dnr_type='" . $type . "'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "' AND dnr_name='" . $posteddata["host"] . "' AND dnr_value='" . $posteddata["value"] . "' AND dnr_priority='" . $posteddata["priority"] . "' and dnr_service='" . $posteddata["service"]
				. "'
            AND dnr_weight='" . $posteddata["weight"] . "' AND dnr_port='" . $posteddata["port"] . "' AND dnr_protocol='" . $posteddata["protocol"] . "'";
			$conn = GetConnection();
			$result = $conn->query($sql);
			if ($result && mysqli_num_rows($result) > 0)
				return ["status" => "duplicated"];
			return ["status" => "unique", $sql];
		}
		return ["status" => "unique"];
	}
	public static function CheckRecordAOrCNAMEDuplicated($domainid, $name)
	{
	}
	public static function CreateRecordForAdd($postedata, $dname, $recordid)
	{
		$records = self::InternalGetOneRecordByID($recordid);

		$NSRecord = NAMESERVERS_ADMIN::GetNameServerRecordsForDomain($dname);
		$rangeIPS = CDNRANGEIPS_ADMIN::GetListByStatus($NSRecord["data"][0]["organize"]);
		$arecord = "";
		if ($postedata["ttl"] == "0") {
			$postedata["ttl"] = "120";
		}
		if ($postedata["type"] == "A") {
			$nrow = DNSBALANCER_ADMIN::GetListOfBalancers($recordid);
			if ($nrow["status"]  == "balance") {
				return;
			} else {
				if ($postedata["proxied"] == "1") {
					foreach ($rangeIPS["v4"] as $cdnips) {
						if ($postedata["host"] == $dname) {
							$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    A    " . $cdnips["crip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    A    " . $cdnips["crip"];
						}
					}
					foreach ($rangeIPS["v6"] as $cdnips) {

						if ($postedata["host"] == $dname) {
							$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    AAAA    " . $cdnips["crip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    AAAA    " . $cdnips["crip"];
						}
					}
				} else {
					if ($postedata["host"] == $dname) {
						if ($postedata["ttl"] == 0) {
							$postedata["ttl"] = 120;
						}
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    A    " .  $postedata["ip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    A    " .  $postedata["ip"];
					}
				}
			}
		} else if ($postedata["type"] == "CNAME") {
			if ($postedata["proxied"] == "1") {
				foreach ($rangeIPS["v4"] as $cdnips) {
					if ($postedata["host"] == $dname) {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    A    " . $cdnips["crip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    A    " . $cdnips["crip"];
					}
				}
				foreach ($rangeIPS["v6"] as $cdnips) {

					if ($postedata["host"] == $dname) {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    AAAA    " . $cdnips["crip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    AAAA    " . $cdnips["crip"];
					}
				}
			} else {
				$p = $postedata["ip"];
				if (substr($postedata["ip"], -1) != ".") {
					$p = $postedata["ip"] . ".";
				}

				if ($postedata["host"] == $dname) {

					$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    CNAME    " .  strtolower($p);
				} else {
					$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    CNAME    " .  strtolower($p);
				}
			}
		} else if ($postedata["type"] == "AAAA") {
			if ($postedata["proxied"] == "1") {
				foreach ($rangeIPS["v4"] as $cdnips) {
					if ($postedata["host"] == $dname) {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    A    " . $cdnips["crip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    A    " . $cdnips["crip"];
					}
				}
				foreach ($rangeIPS["v6"] as $cdnips) {

					if ($postedata["host"] == $dname) {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    AAAA    " . $cdnips["crip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    AAAA    " . $cdnips["crip"];
					}
				}
			} else {
				if ($postedata["host"] == $dname) {
					$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    AAAA    " .  $postedata["ip"];
				} else {
					$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    AAAA    " .  $postedata["ip"];
				}
			}
		} else if ($postedata["type"] == "MX") {
			if ($postedata["host"] == $dname) {
				$outputval = str_replace("..", ".", Punycode::encodeHostName($postedata["value"]) . ".");
				if (substr($outputval, -1) == "..")
					$outputval = substr($outputval, -1);
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    MX    " . $postedata["priority"] . "    " . strtolower($outputval);
			} else {
				$outputval = str_replace("..", ".", Punycode::encodeHostName($postedata["value"]) . ".");
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    MX    " . $postedata["priority"] . "    " .  strtolower($outputval);
			}
		} else if ($postedata["type"] == "TXT") {
			if ($postedata["host"] == $dname) {
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ". " . $postedata["ttl"] . " IN TXT " . self::ValidateTXTString($records["data"]["dnr_value"]);
			} else {
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . " " . $postedata["ttl"] . " IN TXT " . self::ValidateTXTString($records["data"]["dnr_value"]);
			}
		} else if ($postedata["type"] == "SRV") {
			if ($postedata["host"] == $dname) {
				$arecord .= "\n" . $postedata["service"] . "._" . $postedata["protocol"] . "." .  Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    SRV    " . $postedata["priority"] . "    " . $postedata["weight"] . "    " . $postedata["port"] . "    " . Punycode::encodeHostName($postedata["value"]);
			} else {
				$arecord .= "\n" . $postedata["service"] . "._" . $postedata["protocol"] . "." . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    SRV    " . $postedata["priority"] . "    " . $postedata["weight"] . "    " . $postedata["port"] . "    " . Punycode::encodeHostName($postedata["value"]);
			}
		} else if ($postedata["type"] == "PTR") {
			if ($postedata["host"] == $dname) {
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    PTR    " . Punycode::encodeHostName($postedata["value"]) . ".";
			} else {
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    PTR    " . Punycode::encodeHostName($postedata["value"]) . ".";
			}
		}
		return API_DOMAIN_ADMIN::AddRecord($dname, $arecord);
	}
	public static function CreateRecordForUpdate($postedata, $dname, $recordid, $abefore = 0)
	{
		if ($postedata["type"] != "NS-ADMIN") {
			$NSRecord = NAMESERVERS_ADMIN::GetNameServerRecordsForDomain($dname);
			$rangeIPS = CDNRANGEIPS_ADMIN::GetListByStatus($NSRecord["data"][0]["organize"]);
		}
		$arecord = "";
		$before = "";
		if (!isset($postedata["ttl"]) || $postedata["ttl"] == "0") {
			$postedata["ttl"] = "120";
		}
		if ($postedata["type"] == "A") {
			$nrow = DNSBALANCER_ADMIN::GetListOfBalancers($recordid);
			if ($nrow["status"]  == "balance") {
				return;
			} else {
				if ($postedata["proxied"] == "1") {
					foreach ($rangeIPS["v4"] as $cdnips) {
						if ($postedata["host"] == $dname) {
							$before = Punycode::encodeHostName($postedata["host"]) . ".-A";
							$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    A    " . $cdnips["crip"];
						} else {
							$before = Punycode::encodeHostName($postedata["host"]) . "-A";
							$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    A    " . $cdnips["crip"];
						}
					}
					foreach ($rangeIPS["v6"] as $cdnips) {

						if ($postedata["host"] == $dname) {
							$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    AAAA    " . $cdnips["crip"];
						} else {
							$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    AAAA    " . $cdnips["crip"];
						}
					}
				} else {
					if ($postedata["host"] == $dname) {
						$before = Punycode::encodeHostName($postedata["host"]) . ".-A";
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    A    " .  $postedata["ip"]; //.".".  json_encode($postedatad);//["ip"];
					} else {
						$before = Punycode::encodeHostName($postedata["host"]) . "-A";
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    A    " .  $postedata["ip"];
					}
				}
			}
		} else if ($postedata["type"] == "CNAME") {
			if ($postedata["proxied"] == "1") {
				foreach ($rangeIPS["v4"] as $cdnips) {
					if ($postedata["host"] == $dname) {
						$before = Punycode::encodeHostName($postedata["host"]) . ".-CNAME";
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    A    " . $cdnips["crip"];
					} else {
						$before = Punycode::encodeHostName($postedata["host"]) . "-CNAME";
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    A    " . $cdnips["crip"];
					}
				}
				foreach ($rangeIPS["v6"] as $cdnips) {

					if ($postedata["host"] == $dname) {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    AAAA    " . $cdnips["crip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    AAAA    " . $cdnips["crip"];
					}
				}
			} else {
				$p = $postedata["ip"];
				if (substr($postedata["ip"], -1) != ".") {
					$p = $postedata["ip"] . ".";
				}

				if ($postedata["host"] == $dname) {
					$before = Punycode::encodeHostName($postedata["host"]) . ".-CNAME";
					$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    CNAME    " .  $p;
				} else {
					$before = Punycode::encodeHostName($postedata["host"]) . "-CNAME";
					$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    CNAME    " .  $p;
				}
			}
		} else if ($postedata["type"] == "AAAA") {
			if ($postedata["proxied"] == "1") {
				foreach ($rangeIPS["v4"] as $cdnips) {
					if ($postedata["host"] == $dname) {
						$before = Punycode::encodeHostName($postedata["host"]) . ".-AAAA";
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    A    " . $cdnips["crip"];
					} else {
						$before = Punycode::encodeHostName($postedata["host"]) . "-AAAA";
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    A    " . $cdnips["crip"];
					}
				}
				foreach ($rangeIPS["v6"] as $cdnips) {
					if ($postedata["host"] == $dname) {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    120    IN    AAAA    " . $cdnips["crip"];
					} else {
						$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    120    IN    AAAA    " . $cdnips["crip"];
					}
				}
			} else {
				if ($postedata["host"] == $dname) {
					$before = Punycode::encodeHostName($postedata["host"]) . ".-AAAA";
					$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    AAAA    " .  $postedata["ip"];
				} else {
					$before = Punycode::encodeHostName($postedata["host"]) . "-AAAA";
					$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    AAAA    " .  $postedata["ip"];
				}
			}
		} else if ($postedata["type"] == "MX") {
			if ($postedata["host"] == $dname) {
				$before = Punycode::encodeHostName($postedata["host"]) . ".-MX";
				$outputval = str_replace("..", ".", Punycode::encodeHostName($postedata["value"]) . ".");
				if (substr($outputval, -1) == "..")
					$outputval = substr($outputval, -1);
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    MX    " . $postedata["priority"] . "    " . $outputval;
			} else {
				$before = Punycode::encodeHostName($postedata["host"]) . "-MX";
				$outputval = str_replace("..", ".", Punycode::encodeHostName($postedata["value"]) . ".");
				if (substr($outputval, -1) == "..")
					$outputval = substr($outputval, -1);
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    MX    " . $postedata["priority"] . "    " . $outputval;
			}
		} else if ($postedata["type"] == "TXT") {
			if ($postedata["host"] == $dname) {
				$before = Punycode::encodeHostName($postedata["host"]) . ".-TXT";
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ". " . $postedata["ttl"] . " IN TXT " . self::ValidateTXTString($postedata["value"]);
			} else {
				$before = Punycode::encodeHostName($postedata["host"]) . "-TXT";
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . " " . $postedata["ttl"] . " IN TXT " . self::ValidateTXTString($postedata["value"]);
			}
		} else if ($postedata["type"] == "SRV") {
			if ($postedata["host"] == $dname) {
				$before = $postedata["service"] . "._" . $postedata["protocol"] . "." . Punycode::encodeHostName($postedata["host"]) .   ".-SRV";
				$arecord .= "\n" . $postedata["service"] . "._" . $postedata["protocol"] . "." .  Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    SRV    " . $postedata["priority"] . "    " . $postedata["weight"] . "    " . $postedata["port"] . "    " . Punycode::encodeHostName($postedata["value"]);
			} else {
				$before = $postedata["service"] . "._" . $postedata["protocol"] . "." . Punycode::encodeHostName($postedata["host"]) .   "-SRV";
				$arecord .= "\n" . $postedata["service"] . "._" . $postedata["protocol"] . "." . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    SRV    " . $postedata["priority"] . "    " . $postedata["weight"] . "    " . $postedata["port"] . "    " . Punycode::encodeHostName($postedata["value"]);
			}
		} else if ($postedata["type"] == "PTR") {
			if ($postedata["host"] == $dname) {
				$before = Punycode::encodeHostName($postedata["host"]) . ".-PTR";
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . ".    " . $postedata["ttl"] . "    IN    PTR    " . Punycode::encodeHostName($postedata["value"]) . ".";
			} else {
				$before = Punycode::encodeHostName($postedata["host"]) . "-PTR";
				$arecord .= "\n" . Punycode::encodeHostName($postedata["host"]) . "    " . $postedata["ttl"] . "    IN    PTR    " . Punycode::encodeHostName($postedata["value"]) . ".";
			}
		} else if ($postedata["type"] == "NS-ADMIN") {
			$before = "@-NS";
			$arecord .= "\n@ 86400 IN    NS  " . Punycode::encodeHostName($postedata["ns1"]) . ".";
			$arecord .= "\n@ 86400 IN    NS  " . Punycode::encodeHostName($postedata["ns2"]) . ".";
		}

		$before = "";
		// CREATE BEFORE
		if ($postedata["type"] != "NS-ADMIN") {
			if ($abefore["dnr_type"] == "A") {
				if ($abefore["dnr_name"] == $dname) {
					$before = "A," . Punycode::encodeHostName($abefore["dnr_name"]) . ".," . $abefore["dnr_ttl"] . "," . $abefore["dnr_ip"] . "," . $abefore["dnr_proxied"];
				} else {
					$before = "A," . Punycode::encodeHostName($abefore["dnr_name"]) . "," . $abefore["dnr_ttl"] . "," . $abefore["dnr_ip"] . "," . $abefore["dnr_proxied"];
				}
			} else if ($abefore["dnr_type"] == "CNAME") {
				if ($abefore["dnr_name"] == $dname) {
					$before = "CNAME," . Punycode::encodeHostName($abefore["dnr_name"]) . ".," . $abefore["dnr_ttl"] . "," . $abefore["dnr_ip"] . "," . $abefore["dnr_proxied"];
				} else {
					$before = "CNAME," . Punycode::encodeHostName($abefore["dnr_name"]) . "," . $abefore["dnr_ttl"] . "," . $abefore["dnr_ip"] . "," . $abefore["dnr_proxied"];
				}
			} else if ($abefore["dnr_type"] == "AAAA") {
				if ($abefore["dnr_name"] == $dname) {
					$before = "AAAA," . Punycode::encodeHostName($abefore["dnr_name"]) . ".," . $abefore["dnr_ttl"] . "," . $abefore["dnr_ip"] . "," . $abefore["dnr_proxied"];
					// $arecord=Punycode::encodeHostName($abefore["dnr_name"]) . ".-AAAA";
				} else {
					$before = "AAAA," . Punycode::encodeHostName($abefore["dnr_name"]) . "," . $abefore["dnr_ttl"] . "," . $abefore["dnr_ip"] . "," . $abefore["dnr_proxied"];

					// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . "-AAAA";
				}
			} else if ($abefore["dnr_type"] == "MX") {
				if ($abefore["dnr_name"] == $dname) {
					// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . ".-MX";
					$before = "MX," . Punycode::encodeHostName($abefore["dnr_name"]) . ".," . $abefore["dnr_ttl"] . "," . $abefore["dnr_priority"] . "," . $abefore["dnr_value"];
				} else {
					// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . "-MX";
					$before = "MX," . Punycode::encodeHostName($abefore["dnr_name"]) . "," . $abefore["dnr_ttl"] . "," . $abefore["dnr_priority"] . "," . $abefore["dnr_value"];
				}
			} else if ($abefore["dnr_type"] == "TXT") {
				if ($abefore["dnr_name"] == $dname) {
					// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . ".-TXT";
					$before = "TXT," . Punycode::encodeHostName($abefore["dnr_name"]) . ".," . $abefore["dnr_ttl"] . "," . self::ValidateTXTString($abefore["dnr_value"]);
				} else {
					// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . "-TXT";
					$before = "TXT," . Punycode::encodeHostName($abefore["dnr_name"]) . "," . $abefore["dnr_ttl"] . "," . self::ValidateTXTString($abefore["dnr_value"]);
				}
			} else if ($abefore["dnr_type"] == "SRV") {
				if ($abefore["dnr_name"] == $dname) {
					// $arecord=$postedata["dnr_service"]."._".$postedata["dnr_protocol"]."." . Punycode::encodeHostName($postedata["dnr_name"]).   ".-SRV";
					$before = "SRV," . $abefore["dnr_service"] . "," . $abefore["dnr_protocol"] . "," . Punycode::encodeHostName($abefore["dnr_name"]) . ".," . $abefore["dnr_ttl"] . "," . $abefore["dnr_priority"] . "," . $abefore["dnr_weight"] . "," . $abefore["dnr_port"] . "," . $abefore["dnr_value"];
				} else {
					// $arecord=$postedata["dnr_service"]."._".$postedata["dnr_protocol"]."." . Punycode::encodeHostName($postedata["dnr_name"]).   "-SRV";
					$before = "SRV," . $abefore["dnr_service"] . "," . $abefore["dnr_protocol"] . "," . Punycode::encodeHostName($abefore["dnr_name"]) . "," . $abefore["dnr_ttl"] . "," . $abefore["dnr_priority"] . "," . $abefore["dnr_weight"] . "," . $abefore["dnr_port"] . "," . $abefore["dnr_value"];
				}
			} else if ($abefore["dnr_type"] == "PTR") {
				if ($abefore["dnr_name"] == $dname) {
					// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . ".-PTR";
					$arecord = "PTR," . Punycode::encodeHostName($abefore["dnr_name"]) . ".," . $abefore["dnr_ttl"] . "," . $abefore["dnr_value"];
				} else {
					$before = "PTR," . Punycode::encodeHostName($abefore["dnr_name"]) . "," . $abefore["dnr_ttl"] . "," . $abefore["dnr_value"];
				}
			}
		}
		return API_DOMAIN_ADMIN::UpdateRecord($dname, $arecord, $before);
	}
	public static function CreateRecordForDelete($postedata, $dname, $recordid)
	{
		$NSRecord = NAMESERVERS_ADMIN::GetNameServerRecordsForDomain($dname);
		$rangeIPS = CDNRANGEIPS_ADMIN::GetListByStatus($NSRecord["data"][0]["organize"]);
		$arecord = "";
		if ($postedata["dnr_ttl"] == "0")
			$postedata["dnr_ttl"] = "120";
		if ($postedata["dnr_type"] == "A") {
			if ($postedata["dnr_name"] == $dname) {
				$arecord = "A," . Punycode::encodeHostName($postedata["dnr_name"]) . ".," . $postedata["dnr_ttl"] . "," . $postedata["dnr_ip"] . "," . $postedata["dnr_proxied"];
			} else {
				$arecord = "A," . Punycode::encodeHostName($postedata["dnr_name"]) . "," . $postedata["dnr_ttl"] . "," . $postedata["dnr_ip"] . "," . $postedata["dnr_proxied"];
			}
		} else if ($postedata["dnr_type"] == "CNAME") {
			if ($postedata["dnr_name"] == $dname) {
				$arecord = "CNAME," . Punycode::encodeHostName($postedata["dnr_name"]) . ".," . $postedata["dnr_ttl"] . "," . $postedata["dnr_ip"] . "," . $postedata["dnr_proxied"];
			} else {
				$arecord = "CNAME," . Punycode::encodeHostName($postedata["dnr_name"]) . "," . $postedata["dnr_ttl"] . "," . $postedata["dnr_ip"] . "," . $postedata["dnr_proxied"];
			}
		} else if ($postedata["dnr_type"] == "AAAA") {
			if ($postedata["dnr_name"] == $dname) {
				$arecord = "AAAA," . Punycode::encodeHostName($postedata["dnr_name"]) . ".," . $postedata["dnr_ttl"] . "," . $postedata["dnr_ip"] . "," . $postedata["dnr_proxied"];
				// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . ".-AAAA";
			} else {
				$arecord = "AAAA," . Punycode::encodeHostName($postedata["dnr_name"]) . "," . $postedata["dnr_ttl"] . "," . $postedata["dnr_ip"] . "," . $postedata["dnr_proxied"];

				// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . "-AAAA";
			}
		} else if ($postedata["dnr_type"] == "MX") {
			if ($postedata["dnr_name"] == $dname) {
				// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . ".-MX";
				$arecord = "MX," . Punycode::encodeHostName($postedata["dnr_name"]) . ".," . $postedata["dnr_ttl"] . "," . $postedata["dnr_priority"] . "," . $postedata["dnr_value"];
			} else {
				// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . "-MX";
				$arecord = "MX," . Punycode::encodeHostName($postedata["dnr_name"]) . "," . $postedata["dnr_ttl"] . "," . $postedata["dnr_priority"] . "," . $postedata["dnr_value"];
			}
		} else if ($postedata["dnr_type"] == "TXT") {
			if ($postedata["dnr_name"] == $dname) {
				// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . ".-TXT";
				$arecord = "TXT," . Punycode::encodeHostName($postedata["dnr_name"]) . ".," . $postedata["dnr_ttl"] . "," . self::ValidateTXTString($postedata["dnr_value"]);
			} else {
				// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . "-TXT";
				$arecord = "TXT," . Punycode::encodeHostName($postedata["dnr_name"]) . "," . $postedata["dnr_ttl"] . "," . self::ValidateTXTString($postedata["dnr_value"]);
			}
		} else if ($postedata["dnr_type"] == "SRV") {
			if ($postedata["dnr_name"] == $dname) {
				// $arecord=$postedata["dnr_service"]."._".$postedata["dnr_protocol"]."." . Punycode::encodeHostName($postedata["dnr_name"]).   ".-SRV";
				$arecord = "SRV," . $postedata["dnr_service"] . "," . $postedata["dnr_protocol"] . "," . Punycode::encodeHostName($postedata["dnr_name"]) . ".," . $postedata["dnr_ttl"] . "," . $postedata["dnr_priority"] . "," . $postedata["dnr_weight"] . "," . $postedata["dnr_port"] . "," . $postedata["dnr_value"];
			} else {
				// $arecord=$postedata["dnr_service"]."._".$postedata["dnr_protocol"]."." . Punycode::encodeHostName($postedata["dnr_name"]).   "-SRV";
				$arecord = "SRV," . $postedata["dnr_service"] . "," . $postedata["dnr_protocol"] . "," . Punycode::encodeHostName($postedata["dnr_name"]) . "," . $postedata["dnr_ttl"] . "," . $postedata["dnr_priority"] . "," . $postedata["dnr_weight"] . "," . $postedata["dnr_port"] . "," . $postedata["dnr_value"];
			}
		} else if ($postedata["dnr_type"] == "PTR") {
			if ($postedata["dnr_name"] == $dname) {
				// $arecord=Punycode::encodeHostName($postedata["dnr_name"]) . ".-PTR";
				$arecord = "PTR," . Punycode::encodeHostName($postedata["dnr_name"]) . ".," . $postedata["dnr_ttl"] . "," . $postedata["dnr_value"];
			} else {
				$arecord = "PTR," . Punycode::encodeHostName($postedata["dnr_name"]) . "," . $postedata["dnr_ttl"] . "," . $postedata["dnr_value"];
			}
		}

		return API_DOMAIN_ADMIN::DeleteRecord($dname, $arecord);
	}
	public static function AddSingleRecord($domain, $token, $postedata, $internal = false)
	{

		if (strlen($postedata["host"]) > 63) {
			return ["status" => "error", "message" => "خطا در مقادیر ورودی"];
		}

		$lengthOfDomainName = strlen($domain);
		$lengthOfDomainNameWithDot = strlen($domain . ".");

		if ($lengthOfDomainName < strlen($postedata["host"])) {
			if (substr($postedata["host"], strlen($postedata["host"]) - $lengthOfDomainName, $lengthOfDomainName) == $domain) {
				$postedata["host"] = substr($postedata["host"], 0, strlen($postedata["host"]) - $lengthOfDomainName);
			}
			if (substr($postedata["host"], strlen($postedata["host"]) - $lengthOfDomainNameWithDot, $lengthOfDomainNameWithDot) == $domain . ".") {
				$postedata["host"] = substr($postedata["host"], 0, strlen($postedata["host"]) - $lengthOfDomainNameWithDot);
			}
			if (substr($postedata["host"], -1) == ".") {
				$postedata["host"] = substr($postedata["host"], 0, strlen($postedata["host"]) - 1);
			}
		}


		if (!$internal) {
			$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domain, $token);
			if ($canAccess["status"] == "error") {
				return ["status" => "error", "message" => "شما مجوز دسترسی به این دامنه را ندارید"];
			}
		} else {
			$canAccess = DOMAINNSRECORD_ADMIN::InternalCheckUserCanAccessToDomain($domain);
			if ($canAccess["status"] == "error") {
				$resp = [
					"status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید",
					$canAccess
				];
				return $resp;
			}
		}

		$did = $canAccess["data"]["domain_id"];
		// return self::CheckRecordDuplicated($postedata["type"],$did,$postedata);
		// return ["status"=>"error","did"=>$canAccess["data"]["domain_id"],"can"=>$canAccess];
		if (self::CheckRecordDuplicated($postedata["type"], $did, $postedata)["status"] == "duplicated") {
			return ["status" => "error", "message" => "رکورد درخواستی شما تکراری است"];
		}

		if ($postedata["type"] == "CNAME") {
			if ($postedata["host"] == "@") {
				return ["status" => "error", "message" => "رکوئرد دامنه اصلی نمیتوانید CNAME باشد"];
			}
			if ($postedata["host"] == $postedata["d_name"]) {
				return ["status" => "error", "message" => "رکوئرد دامنه اصلی نمیتوانید CNAME باشد"];
			}
		}

		if ($postedata["type"] == "CNAME") {
			// if($postedata["proxied"]==1){
			if (self::CheckARecordExistForCheckCname($canAccess["data"]["domain_id"], $postedata["host"], "0")) {
				return ["status" => "error", "message" => "آدرس ارسالی برای CNAME مشابه آدرس آن در A وجود دارد"];
			}
			// }
		}

		$out = false;
		$er = false;

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mainsite = WEBSITES_ADMIN::getmainrecord($token, $canAccess["data"]["domain_id"]);
		// if(isset($mainsite["data"][$domain]["webid"])){
		//       return ["status" => "error","p"=>$postedata,"main"=> $mainsite, "message" =>  "پلان وب سایت شما نامشخص است"];

		// }
		$planwebsite = $canAccess["data"]["d_plan"];
		$plans = ReturnPlans();
		if (strpos($postedata["host"], "*") !== false && $postedata["proxied"] == "1") {
			// if (!isset($mainsite["data"][$domain]["webid"])) {
			//     return ["status" => "error", "message" => "پلان وب سایت اصلی شما امکان استفاده از این رکورد را ندارید برای استفاده از این رکورد باید پلان خود را ارتقا دهید"];
			// }
			// $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($mainsite["data"][$domain]["webid"], $uid);
			if (isset($plans[$planwebsite])) {
				if (!isset($plans[$planwebsite]["wildcard"])) {
					return [
						"status" => "error", "action" => "needtoupgrade", $planwebsite,
						"message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"
					];
				}
			} else {
				return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
			}
		}

		if ($postedata["host"] == "") {
			return ["status" => "error", "message" => "خطا در مقادیر ورودی"];
		}

		$recname = $postedata["host"];
		for ($i = 0; $i < strlen($recname); $i++) {
			if (!self::ValidateString($recname[$i])) {
				$persian_alpha_codepoints = '\x{0621}-\x{0628}\x{062A}-\x{063A}\x{0641}-\x{0642}\x{0644}-\x{0648}\x{064E}-\x{0651}\x{0655}\x{067E}\x{0686}\x{0698}\x{06A9}\x{06AF}\x{06BE}\x{06CC}';
				$result = preg_match('/^[' . $persian_alpha_codepoints . ']*$/u', $recname);

				if ($result !== 1) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
			}
		}
		for ($i = 0; $i < strlen($recname); $i++) {
			if ($recname[$i] == "@" && strlen($recname) > 1)
				return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
			if ($recname[$i] == "*") {
				if (isset($recname[$i + 1]) && $recname[$i + 1] != ".")
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				// else if(isset($recname[$i+1]) &){
				//     return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				// }
				if ($i > 0) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
			}
			if ($recname[$i] == "-") {
				if (isset($recname[$i + 1])) {
					// if ($recname[$i + 1] == ".")
					//     return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
					// if ($recname[$i + 1] == "-")
					//     return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				} else if (!isset($recname[$i + 1])) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
				if ($i == 0) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
				if (!$i > 0) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
			}
		}
		//  $domain=Punycode::encodeHostName($domain) ;
		////VALIDATE POSTED RECPRD
		if ($postedata["host"] == "@") {
			$postedata["host"] = $domain;
		}
		$rangeIPS = CDNRANGEIPS_ADMIN::GetListOfAllRecord();
		if ($postedata["type"] == "A") {
			if ($postedata["host"] == "@") {
				$postedata["host"] = $domain;
			}
			foreach ($rangeIPS as $r) {
				if (array_key_exists("ip", $postedata)) {
					if ($r["crip"] == $postedata["ip"]) {
						$er = true;
					}
				}
				if (array_key_exists("value", $postedata)) {
					if ($r["crip"] == $postedata["value"]) {
						$er = true;
					}
				}
			}
		}
		if ($er) {
			return ["status" => "error", "message" => "شما اجازه استفاده از این IP را ندارید"];
		}
		$arrttl = ["0", "120", "300", "600", "900", "1800", "3600", "7200", "18000", "43200", "86400"];
		if (!in_array($postedata["ttl"], $arrttl)) {
			for ($i = 0; $i < count($arrttl); $i++) {
				if (isset($arrttl[$i + 1])) {
					if ($arrttl[$i] < $postedata["ttl"] &&   $postedata["ttl"] < $arrttl[$i + 1]) {
						$postedata["ttl"] = $arrttl[$i + 1];
					}
				} else {
					$postedata["ttl"] = "86400";
				}
			}
		}
		if (intVal($postedata["ttl"]) < 0) {
			return ["status" => "error", "message" => "مقدار ارسالی برای TTL نامعتبر است"];
		}

		if ($postedata["type"] == "A") {
			if ($postedata["type"] == "A" || $postedata["type"] == "CNAME") {
				if (!filter_var($postedata["ip"], FILTER_VALIDATE_IP)) {
					return ["status" => "error", "message" => "IP ارسالی نا معتبر است"];
				}
			}
		}
		if ($postedata["type"] == "AAAA") {
			if (!filter_var($postedata["ip"], FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
				return ["status" => "error", "message" => "IP ارسالی نا معتبر است"];
			}
		}
		if ($postedata["type"] == "ANAME") {
			return ["status" => "error", "message" => "رکورد درخواستی شما نامعتبر است"];
		}

		if (
			$postedata["type"] == "AAAA"  || $postedata["type"] == "A" ||
			$postedata["type"] == "CNAME" || $postedata["type"] == "ANAME"
		) {
			if ($postedata["type"] == "CNAME" || $postedata["type"] == "ANAME") {
				$m = $postedata["ip"];
				$m = strtolower($m);
				if (substr($m, -1) == ".") {
					$m = substr($m, 0, strlen($m) - 1);
				}

				$p = explode(".", $m);
				if (count($p) < 2 || !CheckValidTLD($p[count($p) - 1]))
					return ["status" => "error", "message" => "آدرس ارسالی برای هاست اشتباه است"];
			}
			if ($postedata["type"] == "CNAME") {
				$m = $postedata["ip"];
				if (substr($m, -1) == ".") {
					$postedata["ip"] = substr($m, 0, strlen($m) - 1);
				}

				if (substr($m, 0, 1) == ".") {
					$postedata["ip"] = substr($m, 1, strlen($m));
				}
			}
			if (strpos($postedata["host"], "*") !== false && $postedata["proxied"] == "1") {

				if (!isset($plans[$planwebsite]))
					return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];

				if (!isset($plans[$planwebsite]["wildcard"])) {
					return ["status" => "error", "action" => "needtoupgrade", "message" => "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
				}
			}
			if (!isset($postedata["proxied"]))
				$postedata["proxied"] = 0;

			if ($postedata["port"] == "") {
				$postedata["port"] = 0;
			} else {
				if ($postedata["proxied"] == "1") {
					if ($postedata["protocol"] == "HTTP" || $postedata["protocol"] == "HTTPS") {
						if (intVal($postedata["port"]) < 1 || intVal($postedata["port"]) > 65534) {
							return ["status" => "error", "message" => "مقدار ارسالی برای پورت نامعتبر است"];
						}
					}
				}
			}
			if (strtolower($postedata["protocol"]) == "automatic") {
				$postedata["port"] = 0;
			}

			$out = DOMAINNSRECORD_ADMIN::AddRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$token,
				$postedata["type"],
				strtolower($postedata["host"]),
				$postedata["ip"],
				$postedata["ttl"],
				$postedata["proxied"],
				0,
				$postedata["port"],
				0,
				0,
				$postedata["protocol"]
			);
		} else if ($postedata["type"] == "MX") {
			$m = $postedata["value"];
			if (substr($m, -1) == ".") {
				$m = substr($m, 0, strlen($m) - 1);
			}
			if (substr($postedata["value"], -1) == ".") {
				$postedata["value"] = substr($postedata["value"], 0, strlen($postedata["value"]) - 1);
			}
			$postedata["value"] = strtolower($postedata["value"]);
			$postedata["ip"] = strtolower($postedata["ip"]);
			$m = strtolower($m);
			$p = explode(".", $m);
			if (count($p) < 2 || !CheckValidTLD($p[count($p) - 1])) {
				return ["status" => "error", "message" => "آدرس ارسالی برای میل سرور باید دامنه  اشتباه است"];
			}
			if ($postedata["priority"] > 65535 || $postedata["priority"] < 0) {
				return ["status" => "error", $postedata["priority"], "message" => "اولویت ارسالی نامعتبر است"];
			}

			if (substr($postedata["value"], 0, 1) == ".") {
				$postedata["value"] = substr($postedata["value"], 1, strlen($postedata["value"]));
			}
			if (substr($postedata["ip"], 0, 1) == ".") {
				$postedata["ip"] = substr($postedata["ip"], 1, strlen($postedata["ip"]));
			}

			$out = DOMAINNSRECORD_ADMIN::AddRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$token,
				$postedata["type"],
				strtolower($postedata["host"]),
				" ",
				$postedata["ttl"],
				0,
				$postedata["priority"],
				0,
				0,
				strtolower($m),
				"0",
				$internal
			);
		} else if ($postedata["type"] == "TXT") {
			// $postedata["value"] = trim(preg_replace('/\s\s+/', '', $postedata["value"]));
			$out = DOMAINNSRECORD_ADMIN::AddRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$token,
				$postedata["type"],
				strtolower($postedata["host"]),
				" ",
				$postedata["ttl"],
				0,
				0,
				0,
				0,
				$postedata["value"],
				"0",
				$internal
			);
		} else if ($postedata["type"] == "NS") {
			$m = $postedata["value"];
			if (substr($m, -1) == ".") {
				$m = substr($m, 0, strlen($m) - 1);
			}
			$p = explode(".", $m);
			if (count($p) < 2 || !CheckValidTLD($p[count($p) - 1]))
				return ["status" => "error", "message" => "آدرس ارسالی برای سرور مقصد اشتباه است"];

			$out = DOMAINNSRECORD_ADMIN::AddRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$token,
				$postedata["type"],
				strtolower($postedata["host"]),
				" ",
				$postedata["ttl"],
				0,
				0,
				0,
				0,
				strtolower($postedata["value"]),
				"0",
				$internal
			);
		} else if ($postedata["type"] == "PTR") {
			$m = $postedata["value"];
			// if(substr($m,strlen($m)-1,strlen($m))=="."){
			//     $m=substr($m,0,sdtrlrn($m)-1);
			// }
			if (substr($m, -1) == ".") {
				$m = substr($m, 0, strlen($m) - 1);
			}

			$p = explode(".", $m);
			if (count($p) < 2 || !CheckValidTLD($p[count($p) - 1]))
				return ["status" => "error", "message" => "آدرس ارسالی برای سرور مقصد اشتباه است"];

			//name ttl  class   rr     name
			$out = DOMAINNSRECORD_ADMIN::AddRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$token,
				$postedata["type"],
				strtolower($postedata["host"]),
				" ",
				$postedata["ttl"],
				0,
				0,
				0,
				0,
				strtolower($postedata["value"]),
				"0",
				$internal
			);
		} else if ($postedata["type"] == "SRV") {
			//_service._protocolName  IN SRV priority weight portNO subdns.domain.com

			$m = $postedata["value"];
			if (substr($m, -1) == ".") {
				$m = substr($m, 0, strlen($m) - 1);
			}
			$p = explode(".", $m);

			if (count($p) < 2 || !CheckValidTLD($p[count($p) - 1]))
				return ["status" => "error", "message" => "آدرس ارسالی برای سرور مقصد اشتباه است"];

			$out = DOMAINNSRECORD_ADMIN::AddRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$token,
				$postedata["type"],
				strtolower($postedata["host"]),
				" ",
				$postedata["ttl"],
				0,
				$postedata["priority"],
				$postedata["port"],
				$postedata["weight"],
				strtolower($postedata["value"]),
				$postedata["protocol"],
				$postedata["service"],
				$internal
			);
		} else {
			return ["status" => "error", $postedata["type"] ?? '',
			 "message" => !empty($postedata["type"]) ? "نوع رکورد {$postedata["type"]} تعریف نشده است" : "نوع رکورد نامشخص است"];
		}

		// VARS_ADMIN::ReturnHeaders(200);
		// DOMAINNSRECORD_ADMIN::GenerateDNSFile($domain);
		// if ($internal == "true") {
		// DNSBALANCER_ADMIN::AddDomainToQueue($domain,"bind","yes");
		// } else {
		// API_DOMAIN_ADMIN::RunUpdateAPI1($domain);
		// DNSBALANCER_ADMIN::AddDomainToQueue($domain,"bind");
		// }
		if ($postedata["type"] == "A" || $postedata["type"] == "CNAME" || $postedata["type"] == "AAAA") {
			if ($out["balance"] != "balance") {
				if ($postedata["proxied"] == "1") {
					$balance = $canAccess["credit"];
					if ($balance < 0) {
						return ["status" => "error", "message" => "اعتبار شما منفی است و امکان استفاده از ابر را ندارید"];
					}
					if ($domain == $postedata["host"]) {
						// if ($postedata["host"] != "www") {
						if ($postedata["host"] != "@") {
							WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($canAccess["data"]["domain_id"], $postedata["host"], 1);
							API_CDN_ADMIN::RunCreateAPICDN($domain, $postedata["ip"], $postedata["protocol"], $postedata["port"]);
							API_CAHCE_ADMIN::RunCacheVars($domain, $plans[$planwebsite]["zone"], $plans[$planwebsite]["maxsize"]);
						}
						// }
						// else{
						//                  API_CDN_ADMIN::RunAddWWWRecord($domain,"add");
						// }
					} else {
						// if ($postedata["host"] != "www") {
						if ($postedata["host"] != "@") {
							WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($canAccess["data"]["domain_id"], $postedata["host"], 1);
							API_CDN_ADMIN::RunCreateAPICDN($postedata["host"] . "." . $domain, $postedata["ip"],  $postedata["protocol"], $postedata["port"]);
							API_CAHCE_ADMIN::RunCacheVars($postedata["host"] . "." . $domain, $plans[$planwebsite]["zone"], $plans[$planwebsite]["maxsize"]);
						}
						// }
						// else{
						//         API_CDN_ADMIN::RunAddWWWRecord($domain,"add");
						// }
					}
				}
			} else {
				if ($postedata["type"] == "A"){
					$ttl=$postedata["ttl"];
					if($postedata["ttl"]=="0")
					$ttl="120";
					$ns=USSERNAMESERVERS_ADMIN::GetNameServerWithToken($token,0)["data"][0]["ns1"];
					return DNSBALANCER_ADMIN::GetListOfBalancersAndWrite($ns,$domain,$out["id"],$ttl,$postedata["host"]);
				}
			}
		}

		// if ($postedata["proxied"] == "0") {
		//     if ($domain == $postedata["host"]) {
		//         // if ($postedata["host"] != "www") {
		//         // WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($canAccess["data"]["domain_id"], $postedata["host"], 0);
		//         // API_CDN_ADMIN::RunDisableAPICDN($domain);
		//         // }
		//         // else{
		//         //       API_CDN_ADMIN::RunAddWWWRecord($domain,"remove");
		//         // }
		//     } else {
		//         // if ($postedata["host"] != "www") {


		//         // WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($canAccess["data"]["domain_id"], $postedata["host"], 0);
		//         // API_CDN_ADMIN::RunDisableAPICDN($postedata["host"] . "." . $domain);
		//         // }
		//         // else{
		//         //       API_CDN_ADMIN::RunAddWWWRecord($domain,"remove");
		//         // }
		//     }
		// }

		if (empty($out) || !is_array($out) || !isset($out["status"]) || $out["status"] != "success") {
			// VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", $out, $postedata, "message" => "خطا در مقادیر ورودی لطفا اطلاعات ارسالی را بررسی نمایید" . (empty($out["message"]) ? '' : ": \n" . $out["message"])];
		}

		self::CreateRecordForAdd($postedata, $domain, $out["id"]);

		return [
			$postedata["value"],
			"status" => $out["status"],
			"message" => $out["message"], //"اطلاعات با موفقیت ثبت شد و تا دقایقی دیگر در سراسر جهان اعمال میشود",
			"out" => $out,
			"id" => $out["id"],
			"name" => $postedata["host"]
		];
	}
	public static function UserCanAccessToRecord($uid, $rid)
	{
		$sql = "SELECT * FROM `tbl_domains_ns_records`,tbl_domains,tbl_users
        WHERE dnr_d_id_fk=domain_id
        AND tbl_domains.d_user_id_fk = uid AND uid=" . $uid . " AND dnrid=" . $rid;
		$conn = GetConnection();

		$re = $conn->query($sql);
		if (!$re || mysqli_num_rows($re) == 0) {
			return  ["status" => "error"];
		} else {
			$listOfRecordType = mysqli_fetch_all($re, MYSQLI_ASSOC);
		}

		$conn->close();
		return ["status" => "success", "data" => $listOfRecordType];
	}
	public static function UpdateSingleRecord($domain, $id, $token, $postedata)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		$uid = $usersDetails["userdetail"][0]["uid"];
		$dup = false;
		if ($postedata["protocol"] == "undefined")
			$postedata["protocol"] = "automatic";
		$ur = self::UserCanAccessToRecord($uid, $postedata["id"]);
		if ($postedata["type"] == "A" || $postedata["type"] == "ANAME" || $postedata["type"] == "CNAME" || $postedata["type"] == "AAAA") {
			if ($postedata["port"] == "") {
				$postedata["port"] = "0";
			}
			if (
				strtolower($postedata["host"]) == strtolower($ur["data"][0]["dnr_name"]) &&
				$postedata["ttl"] == $ur["data"][0]["dnr_ttl"] &&
				$postedata["ip"] == $ur["data"][0]["dnr_ip"] &&
				$postedata["port"] == $ur["data"][0]["dnr_port"] &&
				$postedata["proxied"] == $ur["data"][0]["dnr_proxied"] &&
				strtolower($postedata["protocol"]) == strtolower($ur["data"][0]["dnr_protocol"])
			) {
				$dup = true;
			}
		}

		if ($postedata["type"] == "MX") {
			if (
				strtolower($postedata["host"]) == strtolower($ur["data"][0]["dnr_name"]) &&
				$postedata["ttl"] == $ur["data"][0]["dnr_ttl"] &&
				$postedata["ip"] == $ur["data"][0]["dnr_value"] &&
				$postedata["priority"] == $ur["data"][0]["dnr_priority"]
			) {
				$dup = true;
			}
		}
		if ($postedata["type"] == "SRV") {
			if (
				strtolower($postedata["host"]) == strtolower($ur["data"][0]["dnr_name"]) &&
				$postedata["ttl"] == $ur["data"][0]["dnr_ttl"] &&
				$postedata["ip"] == $ur["data"][0]["dnr_value"] &&
				$postedata["protocol"] == $ur["data"][0]["dnr_protocol"] &&
				$postedata["service"] == $ur["data"][0]["dnr_service"] &&
				$postedata["weight"] == $ur["data"][0]["dnr_weight"] &&
				$postedata["port"] == $ur["data"][0]["dnr_port"] &&
				$postedata["priority"] == $ur["data"][0]["dnr_priority"]
			) {
				$dup = true;
			}
		}

		if ($postedata["type"] == "TXT") {
			$postedata["value"] = $postedata["value"];
			if (
				strtolower($postedata["host"]) == strtolower($ur["data"][0]["dnr_name"]) &&
				$postedata["ttl"] == $ur["data"][0]["dnr_ttl"] &&
				$postedata["value"] == $ur["data"][0]["dnr_value"]
			) {
				$dup = true;
			}
		}

		if ($postedata["type"] == "NS") {
			if (
				strtolower($postedata["host"]) == strtolower($ur["data"][0]["dnr_name"]) &&
				$postedata["ttl"] == $ur["data"][0]["dnr_ttl"] &&
				$postedata["value"] == $ur["data"][0]["dnr_value"]
			) {
				$dup = true;
			}
		}
		if ($postedata["type"] == "NS") {
			if (
				strtolower($postedata["host"]) == strtolower($ur["data"][0]["dnr_name"]) &&
				$postedata["ttl"] == $ur["data"][0]["dnr_ttl"] &&
				$postedata["value"] == $ur["data"][0]["dnr_value"]
			) {
				$dup = true;
			}
		}
		if ($postedata["type"] != "A" && $dup) {
			return ["status" => "success", "message" => "درخواست شما با موفقيت انجام شد"];
		}
		if ($postedata["type"] == "A" && $dup && $postedata["balance"] == "nobalance" && $postedata["wasBalanced"] == "false") {
			return ["status" => "success", "message" => "درخواست شما با موفقيت انجام شد"];
		}
		if ($postedata["type"] == "A" && $dup && $postedata["balance"] == "balance" && $postedata["wasBalanced"] == "true") {
			return ["status" => "success", "message" => "درخواست شما با موفقيت انجام شد"];
		}

		$did = $ur["data"][0]["domain_id"];
		// return self::CheckRecordDuplicated($postedata["type"],$did,$postedata);
		// return ["status"=>"error","did"=>$canAccess["data"]["domain_id"],"can"=>$canAccess];
		// if (self::CheckRecordDuplicated($postedata["type"], $did, $postedata)["status"] == "duplicated") {
		//     return ["status" => "error", "message" => "رکورد درخواستی شما تکراری است"];
		// }


		// 	return ["status"=>"success","message"=>"درخواست شما با موفقيت انجام شد "
		// 	,"myprto"=>$ur["data"][0]["dnr_protocol"],"yproto"=>$postedata["protocol"]
		// 	];


		//   return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد",$uid, $postedata,"ur"=>$ur,$postedata,"data"=>[
		//                 "phost"=>strtolower($postedata["host"]),"dbhost"=>strtolower($ur["data"][0]["dnr_name"]) ,
		//                 "pttl"=>$postedata["ttl"],"dbttl"=>$ur["data"][0]["dnr_ttl"],
		//               "pip"=>$postedata["value"],"dbip"=>$ur["data"][0]["dnr_value"],
		//               "pport"=>$postedata["port"],"dbport"=>$ur["data"][0]["dnr_port"] ,
		//               "pprx"=>$postedata["proxied"],"dbprx"=>$ur["data"][0]["dnr_proxied"] ,
		//               "pproto"=>strtolower($postedata["protocol"]),"dbproto"=>strtolower($ur["data"][0]["dnr_protocol"])
		//       ]];


		if (strlen($postedata["host"]) > 63) {
			return ["status" => "error", "message" => "خطا در مقادیر ورودی"];
		}
		if (substr($postedata["host"], -1) == ".") {
			$postedata["host"] = substr($postedata["host"], 0, strlen($postedata["host"]) - 1);
		}
		$recname = $postedata["host"];
		for ($i = 0; $i < strlen($recname); $i++) {
			if (!self::ValidateString($recname[$i])) {
				$persian_alpha_codepoints = '\x{0621}-\x{0628}\x{062A}-\x{063A}\x{0641}-\x{0642}\x{0644}-\x{0648}\x{064E}-\x{0651}\x{0655}\x{067E}\x{0686}\x{0698}\x{06A9}\x{06AF}\x{06BE}\x{06CC}';
				$result = preg_match('/^[' . $persian_alpha_codepoints . ']*$/u', $recname);

				if ($result !== 1) {
					return ["status" => "error", $recname[$i], "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
			}
		}

		for ($i = 0; $i < strlen($recname); $i++) {
			if ($recname[$i] == "@" && strlen($recname) > 1)
				return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
			if ($recname[$i] == "*") {
				if (isset($recname[$i + 1]) && $recname[$i + 1] != ".")
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				if (isset($recname[$i + 1])) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
				if ($i > 0) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
			}
			if ($recname[$i] == "-") {
				if (isset($recname[$i + 1])) {
					if ($recname[$i + 1] == ".")
						return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
					// if ($recname[$i + 1] == "-")
					//     return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				} else if (!isset($recname[$i + 1])) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
				if ($i == 0) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
				if (!$i > 0) {
					return ["status" => "error", "message" => "نام وارد شده شما حاوی حروف نامعتبر است"];
				}
			}
		}

		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domain, $token);

		$plans = ReturnPlans();
		$planwebsite = $ur["data"][0]["d_plan"];
		if ($postedata["proxied"] != $ur["data"][0]["dnr_proxied"])


			$s = self::CheckRecordHasCluster($postedata["host"], $canAccess["data"]["domain_id"], $domain);
		if ($s["status"] == "error")
			return $s;

		if ($canAccess["status"] == "error") {
			// VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شما مجوز دسترسی به این دامنه را ندارید"];
		}
		$out = false;
		$er = false;

		if ($postedata["host"] == "@")
			$postedata["host"] = $domain;

		if ($postedata["type"] == "CNAME") {
			// if($postedata["proxied"]==1){
			if (self::CheckARecordExistForCheckCname($canAccess["data"]["domain_id"], $postedata["host"], $id)) {
				return ["status" => "error", "message" => "آدرس ارسالی برای CNAME مشابه آدرس آن در A وجود دارد"];
			}


			if (substr($postedata["ip"], 0, 1) == ".") {
				$postedata["ip"] = substr($postedata["ip"], 1, strlen($postedata["ip"]));
			}
			if (substr($postedata["ip"], -1) == ".") {
				$postedata["ip"] = substr($postedata["ip"], 0, strlen($postedata["ip"]) - 1);
			}
			// }
		}
		if ($postedata["type"] == "A") {
			// if($postedata["proxied"]==1){
			if (self::CheckCNAMERecordExistForCheckA($canAccess["data"]["domain_id"], $postedata["host"])) {
				return ["status" => "error", "message" => "آدرس ارسالی برای A مشابه آدرس آن در CNAME وجود دارد"];
			}
			// }
		}
		$arrttl = ["0", "120", "300", "600", "900", "1800", "3600", "7200", "18000", "43200", "86400"];
		if (!in_array($postedata["ttl"], $arrttl)) {

			for ($i = 0; $i < count($arrttl); $i++) {
				if (isset($arrttl[$i + 1])) {
					if ($arrttl[$i] < $postedata["ttl"] &&   $postedata["ttl"] < $arrttl[$i + 1]) {
						$postedata["ttl"] = $arrttl[$i + 1];
					}
				} else {
					$postedata["ttl"] = "86400";
				}
			}
		}
		if (intVal($postedata["ttl"]) < 0) {
			return ["status" => "error", "message" => "مقدار ارسالی برای TTL نامعتبر است"];
		}



		$mainsite = WEBSITES_ADMIN::getmainrecord($token, $canAccess["data"]["domain_id"]);
		// if(isset($mainsite["data"][$domain]["webid"])){
		//       return ["status" => "error","p"=>$postedata,"main"=> $mainsite, "message" =>  "پلان وب سایت شما نامشخص است"];
		// }
		if (strpos($postedata["host"], "*") !== false && $postedata["proxied"] == "1") {
			if (!isset($mainsite["webid"])) {
				return ["status" => "error", "message" => "پلان وب سایت اصلی شما امکان استفاده از این رکورد را ندارید برای استفاده از این رکورد باید پلان خود را ارتقا دهید"];
			}
			$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($mainsite["webid"], $uid);
			// $planwebsite = $websitesOwner["data"][0]["d_plan"];
			if (isset($plans[$planwebsite])) {
				if (!isset($plans[$planwebsite]["wildcard"])) {
					return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
				}
			} else {
				return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
			}
		}


		$rangeIPS = CDNRANGEIPS_ADMIN::GetListOfAllRecord();
		foreach ($rangeIPS as $r) {
			if (array_key_exists("ip", $postedata)) {
				if ($r["crip"] == $postedata["ip"]) {
					$er = true;
				}
			}
			if (array_key_exists("value", $postedata)) {
				if ($r["crip"] == $postedata["value"]) {
					$er = true;
				}
			}
		}
		if ($er) {
			// VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شما اجازه استفاده از این IP را ندارید"];
		}
		if (
			$postedata["type"] == "A" ||
			$postedata["type"] == "CNAME" ||
			$postedata["type"] == "ANAME" ||
			$postedata["type"] == "AAAA"
		) {

			if ($postedata["type"] == "A") {
				if (!filter_var($postedata["ip"], FILTER_VALIDATE_IP)) {
					return ["status" => "error", "message" => "IP ارسالی نا معتبر است"];
				}
			}
			if ($postedata["type"] == "AAAA") {
				if (!filter_var($postedata["ip"], FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
					return ["status" => "error", "message" => "IP ارسالی نا معتبر است"];
				}
			}
			if ($postedata["proxied"] == "1") {

				if ($usersDetails["credit"] < 0) {
					return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
				}
				if ($postedata["protocol"] == "HTTP" || $postedata["protocol"] == "HTTPS") {
					if (intVal($postedata["port"]) < 1 || intVal($postedata["port"]) > 65534) {
						return ["status" => "error", "message" => "مقدار ارسالی برای پورت نامعتبر است"];
					}
				}
				if ($postedata["host"] == "@")
					$postedata["host"] = $domain;
				if ($domain == $postedata["host"]) {
					// if ($postedata["host"] != "www") {
					if (!$dup) {
						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($canAccess["data"]["domain_id"], $postedata["host"], 1);
						API_CDN_ADMIN::RunCreateAPICDN($domain, $postedata["ip"], strtolower($postedata["protocol"]), $postedata["port"]);
						if ($postedata["proxied"] != $ur["data"][0]["dnr_proxied"])
							API_CAHCE_ADMIN::RunCacheVars($domain, $plans[$planwebsite]["zone"], $plans[$planwebsite]["maxsize"]);
					}
					// if($postedata["host"] ==$domain)
					//          API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($domain,"","100-".$postedata["ip"]."-80","ip_hash");
					// else
					//          API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($postedata["host"].".".$domain,"","100-".$postedata["ip"]."-80","ip_hash");

					// }
					// else{
					//         API_CDN_ADMIN::RunAddWWWRecord($domain,"add");
					// }
				} else {
					// if ($postedata["host"] != "www") {
					if (!$dup) {
						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($canAccess["data"]["domain_id"], $postedata["host"], 1);
						API_CDN_ADMIN::RunCreateAPICDN($postedata["host"] . "." . $domain, $postedata["ip"], strtolower($postedata["protocol"]), $postedata["port"]);
						if ($postedata["proxied"] != $ur["data"][0]["dnr_proxied"])
							API_CAHCE_ADMIN::RunCacheVars($postedata["host"] . "." . $domain, $plans[$planwebsite]["zone"], $plans[$planwebsite]["maxsize"]);
					}
					// if($postedata["host"] ==$domain)
					//          API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($domain,"","100-".$postedata["ip"]."-80","ip_hash");
					// else
					//          API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($postedata["host"].".".$domain,"","100-".$postedata["ip"]."-80","ip_hash");

					// }
					// else{
					//         API_CDN_ADMIN::RunAddWWWRecord($domain,"add");
					// }
				}
			}
			if ($postedata["proxied"] == "0" && $ur["data"][0]["dnr_proxied"] == "1") {
				if ($domain == $postedata["host"]) {
					// if ($postedata["host"] != "www") {
					if (!$dup) {
						// WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($canAccess["data"]["domain_id"], $postedata["host"], 0);
						// WEBSITES_ADMIN::DeleteWebSite($postedata["host"], $canAccess["data"]["domain_id"]);
						API_CDN_ADMIN::RunDisableAPICDN($domain);
					}
					// }
					// else{
					//       API_CDN_ADMIN::RunAddWWWRecord($domain,"remove");
					// }
				} else {
					// if ($postedata["host"] != "www") {
					if (!$dup) {
						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($canAccess["data"]["domain_id"], $postedata["host"], 0);
						WEBSITES_ADMIN::DeleteWebSite($postedata["host"], $canAccess["data"]["domain_id"]);
						API_CDN_ADMIN::RunDeleteSignleDomainCDN($postedata["host"] . "." . $domain);
					}
					// }
					// else{
					//       API_CDN_ADMIN::RunAddWWWRecord($domain,"remove");
					// }
				}
			}
			$out = DOMAINNSRECORD_ADMIN::UpdateRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$id,
				$token,
				$postedata["type"],
				$postedata["host"],
				$postedata["ip"],
				$postedata["ttl"],
				$postedata["proxied"],
				0,
				$postedata["port"],
				0,
				"0",
				$postedata["protocol"],
				$dup
			);
		} else if ($postedata["type"] == "MX") {
			$m = $postedata["value"];
			// if(substr($m,strlen($m)-1,strlen($m))=="."){
			//     $m=substr($m,0,sdtrlrn($m)-1);
			// }
			if (substr($m, -1) == ".") {
				$m = substr($m, 0, strlen($m) - 1);
			}

			$p = explode(".", $m);
			if (count($p) < 2 || !CheckValidTLD($p[count($p) - 1])) {
				return ["status" => "error", "message" => "آدرس ارسالی برای میل سرور اشتباه است"];
			}
			if ($postedata["priority"] > 65535 || $postedata["priority"] < 0) {
				return ["status" => "error", "message" => "اولویت ارسالی نامعتبر است"];
			}


			if (substr($postedata["value"], 0, 1) == ".") {
				$postedata["value"] = substr($postedata["value"], 1, strlen($postedata["value"]));
			}
			if (substr($postedata["value"], -1) == ".") {
				$postedata["value"] = substr($postedata["value"], 0, strlen($postedata["value"]) - 1);
			}

			$out = DOMAINNSRECORD_ADMIN::UpdateRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$id,
				$token,
				$postedata["type"],
				$postedata["host"],
				" ",
				$postedata["ttl"],
				0,
				$postedata["priority"],
				0,
				0,
				$m,
				"0",
				$dup
			);
		} else if ($postedata["type"] == "TXT") {

			// $postedata["value"] = trim(preg_replace('/\s\s+/', '', $postedata["value"]));
			// $postedata["value"] = self::ValidateTXTString($postedata["value"]);
			$out = DOMAINNSRECORD_ADMIN::UpdateRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$id,
				$token,
				$postedata["type"],
				$postedata["host"],
				" ",
				$postedata["ttl"],
				0,
				0,
				0,
				0,
				$postedata["value"],
				"0",
				$dup
			);
		} else if ($postedata["type"] == "NS") {
			$out = DOMAINNSRECORD_ADMIN::UpdateRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$id,
				$token,
				$postedata["type"],
				$postedata["host"],
				" ",
				$postedata["ttl"],
				0,
				0,
				0,
				0,
				$postedata["value"],
				"0",
				$dup
			);
		} else if ($postedata["type"] == "PTR") {
			$out = DOMAINNSRECORD_ADMIN::UpdateRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$id,
				$token,
				$postedata["type"],
				$postedata["host"],
				" ",
				$postedata["ttl"],
				0,
				0,
				0,
				0,
				$postedata["value"],
				"0",
				$dup
			);
		} else if ($postedata["type"] == "SRV") {
			$out = DOMAINNSRECORD_ADMIN::UpdateRecord(
				$domain,
				$canAccess["data"]["domain_id"],
				$id,
				$token,
				$postedata["type"],
				$postedata["host"],
				" ",
				$postedata["ttl"],
				0,
				$postedata["priority"],
				$postedata["port"],
				$postedata["weight"],
				$postedata["value"],
				$postedata["protocol"],
				$postedata["service"],
				$dup
			);
		}
		if ($out == true) {
			// VARS_ADMIN::ReturnHeaders(200);
			//  if(!$dup){
			//         DOMAINNSRECORD_ADMIN::GenerateDNSFile($domain);
			//         $a=DNSBALANCER_ADMIN::AddDomainToQueue($domain,"bind");
			//  }
			if (array_key_exists("balance", $postedata)) {
				if ($postedata["balance"] == "nobalance") {
					self::CreateRecordForUpdate($postedata, $domain, $id, $ur["data"][0]);
					// self::CreateRecordForUpdate($postedata,$domain,$id) ;
					// if($postedata["host"]==$domain)
					//     API_DOMAIN_ADMIN::RunDeleteGeoAPI($postedata["host"]);
					// else
					//     API_DOMAIN_ADMIN::RunDeleteGeoAPI($postedata["host"].".".$domain);
				} else {
					$postedata["dnr_type"] = $postedata["type"];
					$postedata["dnr_name"] = $postedata["host"];
					self::CreateRecordForDelete($postedata, $domain, $id);
					if ($postedata["type"] == "A"){
						$ttl=$postedata["ttl"];
						if($postedata["ttl"]=="0")
						$ttl="120";
						$ns=USSERNAMESERVERS_ADMIN::GetNameServerWithToken($token,0)["data"][0]["ns1"];
						return DNSBALANCER_ADMIN::GetListOfBalancersAndWrite($ns,$domain,$out["id"],$ttl,$postedata["host"]);
					}
				}
			}
			$txtval = "";
			if ($postedata["type"] == "TXT")
				$txtval =   $postedata["value"];
			return [
				"txt" => $txtval,
				$out,   $ur, $postedata,
				"status" => $out["status"],
				"message" => $out["message"]

			];
		} else {
			// VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "خطا در مقادیر ورودی لطفا اطلاعات ارسالی را بررسی نمایید"];
		}
	}
	public static function ChangeRecordToBalance($recordid, $ip)
	{
		DNSBALANCER_ADMIN::AddInternalRecord($recordid, $ip, "", "");
	}
	public static function AddRecord(
		$domain,
		$domainid,
		$token,
		$type,
		$name = null,
		$ip = null,
		$ttl = null,
		$proxied = null,
		$priority = 0,
		$port = 0,
		$weight = 0,
		$value = null,
		$protocol = null,
		$service = null,
		$internal = true
	) {

		// if ($name == "@")
		//     $name = $domain;

		// if (!$internal) {
		//     $daccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domain, $token);
		//     if ($daccess["status"] == "error") {
		//         //          //         $resp = [
		//             "status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید",
		//             $daccess
		//         ];
		//         return $resp;
		//     }
		// }
		//  else{
		//             $daccess = DOMAINNSRECORD_ADMIN::InternalCheckUserCanAccessToDomain($domain);
		//         if ($daccess["status"] == "error") {
		//             //          //             $resp = [
		//                 "status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید",
		//                 $daccess
		//             ];
		//             return $resp;
		//       }
		// }


		// if ($name == "@")
		//     $name = $domain;
		if ($type == "A") {

			if (self::CheckARecordExist($domainid, $name, $ip)) {
				return ["status" => "error", "message" => "رکورد درخواستی شما تکراری است"];
			}
			if (self::CheckNeedToBalance($domainid, $name)["status"] == "success") {

				$am  = self::CheckNeedToBalance($domainid, $name);

				// return ["status" => "error", "message" => "خطا","am"=>$am];

				// return ["status"=>"success","data"=>$am];
				if (!$internal) {
					self::InternalChangeCloudStatus($am["recordid"], $domain, 0);
				}
				$s = DNSBALANCER_ADMIN::AddRecord($token, $domain, $am["recordid"], $ip, "default", 100, 120);
				// return  DNSBALANCER_ADMIN::AddInternalRecord($am["recordid"], $am["ip"],$token,$domain);
				// DNSBALANCER_ADMIN::AddInternalRecord($am["recordid"], $ip,$token,$domain);
				if ($am["balancestatus"]["status"] != "balance") {
					$a = DNSBALANCER_ADMIN::AddRecord($token, $domain, $am["recordid"], $am["ip"], "default", 100, 120);
				}

				API_DOMAIN_ADMIN::DeleteRecord($domain, $name . "-A");
				// if(!$internal){
				//  API_DOMAIN_ADMIN::DeleteRecord($domain,$name."-A");
				// }
				return [
					"status" => "success",
					"balance" => "balance",
					"am" => $am,
					"s" => $s,
					"message" => "رکورد درخواستی شما با موفقیت افزوده شد ",
					"id" => $am["id"],
					"name" => $name
				];
			}
		}
		if (substr($name, -1) == ".") {
			$name = substr($name, 0, strlen($name) - 1);
		}
		if ($type == "AAAA") {
			if (self::CheckAAAARecordExist($domainid, $name, $ip)) {
				return ["status" => "error", "name" => $name, "message" => "رکورد درخواستی شما تکراری است"];
			}
		}
		if ($type == "CNAME") {
			if (substr($ip, -1) == ".") {
				$ip = substr($ip, 0, strlen($ip) - 1);
			}

			if (self::CheckCNAMERecordExist($domainid, $name, $ip)) {
				return ["status" => "error", "message" => "رکورد درخواستی شما تکراری است"];
			}
		}
		if ($type == "MX") {
			if (substr($value, -1) == ".") {
				$value = substr($value, 0, strlen($value) - 1);
			}

			if (self::CheckMXRecordExist($domainid, $name, $value, $priority)) {
				return ["status" => "error", "message" => "رکورد درخواستی شما تکراری است"];
			}
		}
		if ($type == "TXT") {
			if (self::CheckTXTRecordExist($domainid, $name, $value)) {
				return ["status" => "error", "message" => "رکورد درخواستی شما تکراری است"];
			}
		}
		// if(substr($value,-1)==".")

		// return ["status"=>"error","m"=>$value];
		$conn = GetConnection();

		$val = $conn->real_escape_string($value);;
		$sql = "INSERT INTO  " . $GLOBALS["domainsnsrecords_tablename"] . "(" .
			$GLOBALS['dnr_d_id_fk'] . "," . $GLOBALS['type'] . "," . $GLOBALS['name'] . "," . $GLOBALS['ip'] . "," .
			$GLOBALS['ttl'] . "," . $GLOBALS['proxied'] . "," . $GLOBALS['priority'] . "," . $GLOBALS['port'] . "," .
			$GLOBALS['weight'] . "," . $GLOBALS['dnvalue'] . "," . $GLOBALS['protocol'] . "," . $GLOBALS['service'] .
			") VALUES(%s,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')";
		$sql = sprintf($sql, $domainid, $type, $name, $ip, $ttl, $proxied, $priority, $port, $weight, $val, $protocol, $service);

		if ($conn->query($sql) === TRUE) {
			$last_id = $conn->insert_id;
		} else {
			return ["status" => "error", $sql, $conn->error, "message" => "خطا در مقادیر ورود"];
		}

		$conn->close();
		if ($type == "A" && $proxied == "1") {
			BACKENDPROTOCOL_ADMIN::InternalUpdateDefaultValue($domainid, $name, $protocol);
		}

		return [
			"status" => "success", "balance" => "nobalance", "message" => "اطلاعات با موفقیت ثبت شد و تا دقایقی دیگر در سراسر جهان اعمال میشود",
			"name" => $name, $sql, "id" => $last_id
		];
	}
	public static function UpdateRecord(
		$domain,
		$domainid,
		$recordid,
		$token,
		$type,
		$name = null,
		$ip = null,
		$ttl = null,
		$proxied = null,
		$priority = 0,
		$port = 0,
		$weight = 0,
		$value = null,
		$protocol = null,
		$service = null,
		$dup = false
	) {

		$daccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domain, $token);
		if ($daccess["status"] == "error") {
			$resp = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
			return $resp;
		}
		if ($proxied == 1) {
			if ($daccess["credit"] < 0) {
				return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
			}
		}
		if ($name == "@")
			$name = $domain;
		if ($priority == "")
			$priority = 0;
		if ($port == "")
			$port = 0;
		$sql = "UPDATE " . $GLOBALS["domainsnsrecords_tablename"] . " SET " .
			$GLOBALS["name"] . "='%s'," . $GLOBALS["ip"] . "='%s'," .
			$GLOBALS["ttl"] . "='%s'," . $GLOBALS["proxied"] . "='%s'," .
			$GLOBALS["priority"] . "='%s'," . $GLOBALS["port"] . "='%s'," .
			$GLOBALS["weight"] . "='%s'," . $GLOBALS["dnvalue"] . "='%s'," . $GLOBALS["protocol"] . "='%s'," . $GLOBALS["service"] . "='%s'  WHERE " . $GLOBALS["dnrid"] . "=%s and " .
			$GLOBALS["dnr_d_id_fk"] . "=%s";
		$sql = sprintf($sql, $name, $ip, $ttl, $proxied, $priority, $port, $weight, $value, $protocol, $service, $recordid, $domainid);

		$conn = GetConnection();
		if ($conn->query($sql) !== TRUE)
			return ["status" => "error", "error" => $conn->error, "message" => "خطا در مقادیر ورود"];

		if ($protocol == "Automatic") {
			$protocol = "scheme";
		}
		$protocol = strtolower($protocol);
		if ($type == "A" && $proxied == "1") {
			if ($domain == $name) {
				if ($dup) {
					WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name, 1);
					//   API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($domain,"","100-".$ip."-".$priority,"ip_hash");
					API_CDN_ADMIN::RunCreateAPICDN($domain, $ip, $protocol, $port);
					$RecordDetails = self::InternalGetOneRecordByID($recordid);
					API_CAHCE_ADMIN::RunCacheVars($domain, $RecordDetails["plan"]["zone"], $RecordDetails["plan"]["maxsize"]);
				}
			} else {
				if ($name != "www") {
					if ($name != "@") {
						if ($dup) {
							WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name, 1);
							// API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($domain,"","100-".$ip."-".$priority,"ip_hash");
							API_CDN_ADMIN::RunCreateAPICDN($name . "." . $domain, $ip, $protocol, $port);
							$RecordDetails = self::InternalGetOneRecordByID($recordid);
							API_CAHCE_ADMIN::RunCacheVars($name . "." . $domain, $RecordDetails["plan"]["zone"], $RecordDetails["plan"]["maxsize"]);
						}
					}
				} else {
					if ($dup) {
						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name, 1);
						// API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($domain,"","100-".$ip."-".$priority,"ip_hash");
						API_CDN_ADMIN::RunCreateAPICDN($name . "." . $domain, $ip, $protocol, $port);
						$RecordDetails = self::InternalGetOneRecordByID($recordid);
						API_CAHCE_ADMIN::RunCacheVars($name . "." . $domain, $RecordDetails["plan"]["zone"], $RecordDetails["plan"]["maxsize"]);
					}
					//   API_CDN_ADMIN::RunAddWWWRecord($domain,"add");
				}
			}
		}
		if ($type == "A" && $proxied == "0") {
			if (isset($name["name"])) {
				if ($domain == $name) {
					if ($dup) {
						// WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name['name'], 0);
						API_CDN_ADMIN::RunDisableAPICDN($name["name"]);
						// API_CDN_ADMIN::RunDisableAPICDN($name["name"]);
					}
				} else {
					if ($dup) {
						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name['name'], 0);
						WEBSITES_ADMIN::DeleteWebSite($name, $domainid);
						// API_CDN_ADMIN::RunDisableAPICDN($name . "." . $domain);
						API_CDN_ADMIN::RunDeleteSignleDomainCDN($name . "." . $domain);
					}
				}
				if ($name == "www") {
					if ($dup) {
						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name['name'], 0);
						// API_CDN_ADMIN::RunDisableAPICDN($name . "." . $domain);
						WEBSITES_ADMIN::DeleteWebSite($name, $domainid);
						API_CDN_ADMIN::RunDeleteSignleDomainCDN($name["name"]);
						//  API_CDN_ADMIN::RunAddWWWRecord($domain,"remove");
					}
				}
			}
		}
		if ($type == "CNAME" || $type == "AAAA") {
			if ($proxied == "0") {
				if (isset($name["name"])) {
					if ($domain == $name) {
						if ($dup) {
							// WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name['name'], 0);
							API_CDN_ADMIN::RunDisableAPICDN($name["name"]);
							// API_CDN_ADMIN::RunDisableAPICDN($name["name"]);
						}
					} else {
						if ($dup) {
							WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name['name'], 0);
							WEBSITES_ADMIN::DeleteWebSite($name['name'], $domainid);
							// API_CDN_ADMIN::RunDisableAPICDN($name . "." . $domain);
							API_CDN_ADMIN::RunDeleteSignleDomainCDN($name . "." . $domain);
						}
					}
					if ($name == "www") {
						if ($dup) {
							WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($domainid, $name['name'], 0);
							// API_CDN_ADMIN::RunDisableAPICDN($name . "." . $domain);
							WEBSITES_ADMIN::DeleteWebSite($name['name'], $domainid);
							API_CDN_ADMIN::RunDeleteSignleDomainCDN($name["name"]);
							//  API_CDN_ADMIN::RunAddWWWRecord($domain,"remove");
						}
					}
				}
			}
		}
		$conn->close();
		if ($type == "A" && $proxied == "1") {
			$c = BACKENDPROTOCOL_ADMIN::InternalUpdateDefaultValue($domainid, $name, $protocol);
		}
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function DeleteRecord($id, $domain, $token)
	{
		$daccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domain, $token);
		if ($daccess["status"] == "error") {
			$resp = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
			return $resp;
		}
		$domainid = $daccess["data"]["domain_id"];
		$domainname = $daccess["data"]["d_name"];

		$bb = DNSBALANCER_ADMIN::DeleteRecord($token, "", $domainname, $id, "all");
		$recorddet = self::InternalGetOneRecordByID($id)["data"];
		$rname = $recorddet["dnr_name"];
		if ($recorddet["dnr_type"] == "A" || $recorddet["dnr_type"] == "AAAA" || $recorddet["dnr_type"] == "CNAME" || $recorddet["dnr_type"] == "ANAME") {
			if ($rname != $domainname)
				$s = WEBSITES_ADMIN::DeleteWebSite($rname, $domainid);
		}

		$sql = "DELETE FROM " . $GLOBALS["domainsnsrecords_tablename"] . " WHERE " . $GLOBALS["dnrid"] . "=%s and " . $GLOBALS["dnr_d_id_fk"] . "=%s";
		$sql = sprintf($sql, $id, $domainid);

		$conn = GetConnection();
		$result = $conn->query($sql);

		$conn->close();
		self::CreateRecordForDelete($recorddet, $domainname, $id);

		// DOMAINNSRECORD_ADMIN::GenerateDNSFile($domain);
		// DNSBALANCER_ADMIN::AddDomainToQueue($domain,"bind");
		if ($recorddet["dnr_type"] == "A" || $recorddet["dnr_type"] == "AAAA" || $recorddet["dnr_type"] == "CNAME" || $recorddet["dnr_type"] == "ANAME") {
			if ($rname != $domainname) {
				if ($recorddet["proxied"] == "1")
					API_CDN_ADMIN::RunDeleteSignleDomainCDN($rname . "." . $domainname);
			} else {
				API_CDN_ADMIN::RunDisableAPICDN($domainname);
			}
		}

		return [
			"status" => "success", $bb,
			"message" => "درخواست شما با موفقیت انجام شد و تا دقایقی دیگر در سراسر جهان قابل مشاهده خواهد بود"
		];
	}
	public static function CheckNeedToBalance($domainid, $name)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND dnr_type='A'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0)
			return ["status" => "error"];

		$listOfRecordType = mysqli_fetch_array($result, MYSQLI_ASSOC);
		$balancestatus = DNSBALANCER_ADMIN::GetListOfBalancers($listOfRecordType["dnrid"]);
		return [
			"status" => "success",
			"recordid" => $listOfRecordType["dnrid"],
			"ip" => $listOfRecordType["dnr_ip"],
			"id" => $listOfRecordType["dnrid"],
			"balancestatus" => $balancestatus
		];
	}
	public static function CheckRecordDuplicate($domaind, $name, $type)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND dnr_type='" . $type . "'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domaind . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return "duplicated";

		return "unique";
	}
	public static function CheckARecordExist($domainid, $name, $ip)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] . " WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND " . $GLOBALS['ip'] . "='" . $ip . "' AND dnr_type='A'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return true;

		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND dnr_type='CNAME'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return true;

		return false;
	}
	public static function CheckARecordExistForCheckCname($domainid, $name, $rid)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] . " WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND dnr_type='A'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return true;

		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] . " WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND dnr_type='CNAME'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "' and dnrid!=" . $rid;

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return true;

		return false;
	}
	public static function CheckCNAMERecordExistForCheckA($domainid, $name)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] . " WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND dnr_type='CNAME'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return true;

		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] . " WHERE " .
			$GLOBALS['name'] . "='" . $name . "' and   dnr_type='CNAME'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return true;

		return false;
	}
	public static function CheckCNAMERecordExist($domainid, $name, $ip)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND " . $GLOBALS['ip'] . "='" . $ip . "'
            AND dnr_type='CNAME'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return true;

		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND dnr_type='A'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";

		$result = $conn->query($sql);
		if ($result && mysqli_num_rows($result) > 0)
			return true;

		return false;
	}
	public static function CheckAAAARecordExist($domainid, $name, $ip)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND " . $GLOBALS['ip'] . "='" . $ip . "'
            AND dnr_type='AAAA'
            AND " . $GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		return ($result && mysqli_num_rows($result) > 0);
	}
	public static function CheckMXRecordExist($domainid, $name, $value, $priority)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND " . $GLOBALS['dnvalue'] . "='" . $value . "'
            AND " . $GLOBALS['priority'] . "='" . $priority . "' and dnr_type='MX' AND " .
			$GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		return ($result && mysqli_num_rows($result) > 0);
	}
	public static function CheckTXTRecordExist($domainid, $name, $value)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domainsnsrecords_tablename"] .
			" WHERE " .
			$GLOBALS['name'] . "='" . $name . "' AND " . $GLOBALS['dnvalue'] . "='" . $value . "'
            AND dnr_type='TXT' AND " .
			$GLOBALS['dnr_d_id_fk'] . "='" . $domainid . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		return ($result && mysqli_num_rows($result) > 0);
	}
	public static function CheckUserCanAccessToDomain($domain, $token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);

		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];

		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] .
			"," . $GLOBALS["domains_tablename"] .
			" WHERE d_status!=2 AND " .
			$GLOBALS["d_user_id_fk"] . "=" . $GLOBALS["uid"] . " AND " .
			$GLOBALS["uid"] . "=" . $uid . " AND " . $GLOBALS['d_name'] . "='" . $domain . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_array($result, MYSQLI_ASSOC);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
			$conn->close();
			return $result;
		} else {
			$userExist = USERS_ADMIN::GetOneByToken($token);
			if ($userExist["status"] == "error") {
				//                  return ["status" => "error", "message" => "اعتبار ورود کاربر به اتمام رسیده است لطفا مجدد وارد شوید"];
			}
			$result = [
				"status" => "success",
				"credit" => $userExist["credit"],
				"data" => $listOfRecordType
			];
			$conn->close();
			return $result;
		}
	}
	public static function InternalCheckUserCanAccessToDomain($domain)
	{
		$sql = "SELECT * FROM "  . $GLOBALS["domains_tablename"] .
			" WHERE d_status!=2 AND " . $GLOBALS['d_name'] . "='" . $domain . "'";
		$conn = GetConnection();

		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_array($result, MYSQLI_ASSOC);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
			$conn->close();
			return $result;
		} else {

			$result = [
				"status" => "success",
				// "credit" => $userExist["credit"],
				"data" => $listOfRecordType
			];
			$conn->close();
			return $result;
		}
	}
	public static function GetOneRecord($domainname, $value)
	{
		$now = jDateTime::date("Y/m/d H:i:s");
		if ($value["rtype"] == "A" || $value["rtype"] == "CNAME" || $value["rtype"] == "ANAME" || $value["rtype"] == "AAAA") {
			$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ip'] . " as ip," .
				$GLOBALS['ttl'] . " as ttl," . $GLOBALS['proxied']
				. "  as cdn FROM " . $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
				" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"]
				. " AND " . $GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" . $value["rtype"] . "' "
				. " AND " . $GLOBALS['name'] . "='" . $value["host"] . "' AND " . $GLOBALS['ip'] . "='" . $value["ip"] . "'";
		} else if ($value["rtype"] == "MX") {
			$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," .
				$GLOBALS['priority'] . " as priority," . $GLOBALS["dnvalue"] . " as target from " .
				$GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
				" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
				$GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
				$value["rtype"] . "' AND " . $GLOBALS['name'] . "='" . $value["host"] . "' AND " .
				$GLOBALS['dnvalue'] . "='" . $value["target"] . "'";
		} else if ($value["rtype"] == "TXT") {
			$sql = "SELECT " . $GLOBALS['dnrid'] . " as id," . $GLOBALS['name'] . " as name," . $GLOBALS['ttl'] . " as ttl," . $GLOBALS["dnvalue"] . " as value FROM "
				. $GLOBALS["domainsnsrecords_tablename"] . "," . $GLOBALS["domains_tablename"] .
				" WHERE " . $GLOBALS["dnr_d_id_fk"] . "=" . $GLOBALS["domain_id"] . " AND " .
				$GLOBALS['d_name'] . "='" . $domainname . "' AND " . $GLOBALS['type'] . "='" .
				$value["rtype"] . "' AND " . $GLOBALS['dnvalue'] . "='" . $value["txt"] . "'";
		}

		$conn = GetConnection();

		$result = $conn->query($sql);
		// $listOfRecordType=mysqli_fetch_array ($result,MYSQLI_ASSOC);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["record" => "notexist"];
		} else {
			$result = ["record" => "exist"];
		}

		$conn->close();
		return $result;
	}
	public static function GetRecordWithParameter($fieldname, $fieldvalue)
	{

		$sql = "SELECT * FROM " . $GLOBALS["dnsrecordtype_tablename"] . " WHERE " . $GLOBALS[$fieldname] . "='" . $fieldvalue . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["result" => "null"];
			return $result;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		}

		$conn->close();
		return $listOfRecordType;
	}
	public static function GetOneByID($dns_rt_id)
	{
		$sql = "SELECT * FROM " . $GLOBALS["dnsrecordtype_tablename"] . " WHERE "
			. $GLOBALS['dns_rt_id'] . "=" . $dns_rt_id;
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["result" => "null"];
			return $result;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function AddDnsRecordType($dns_rt_name, $dns_rt_canproxy, $dns_rt_isactive, $dns_rt_pattern)
	{
		$conn = GetConnection();
		$sql = "INSERT INTO " . $GLOBALS['dnsrecordtype_tablename'] . "(" . $GLOBALS['dns_rt_name'] . "," .
			$GLOBALS['dns_rt_canproxy'] . "," . $GLOBALS['dns_rt_isactive'] . "," . $GLOBALS['dns_rt_pattern']
			. ") VALUES ('%s',%s,%s,'%s')";
		$sql = sprintf($sql, $dns_rt_name, $dns_rt_canproxy, $dns_rt_isactive, $dns_rt_pattern);

		if ($conn->query($sql) === TRUE) {
			$response = ["status" => "success", "message" => "New record created successfully"];
			return $response;
		} else {
			$response = ["status" => "error", "message" => "" .  $conn->error];
			return $response;
		}

		$conn->close();
	}
	public static function UpdateDnsRecordType($dns_rt_id, $dns_rt_name, $dns_rt_canproxy, $dns_rt_isactive, $dns_rt_pattern)
	{
		$conn = GetConnection();

		if (isset($_POST[''])) {
		}
		$sql = "UPDATE " . $GLOBALS['dnsrecordtype_tablename'] . " SET " . $GLOBALS['dns_rt_name'] . "='%s'," .
			$GLOBALS['dns_rt_canproxy'] . "=%s," . $GLOBALS['dns_rt_isactive']
			. "=%s," . $GLOBALS['dns_rt_pattern'] . "='%s' WHERE " . $GLOBALS['dns_rt_id'] . "=%s";
		$sql = sprintf($sql, $dns_rt_name, $dns_rt_canproxy, $dns_rt_isactive, $dns_rt_pattern, $dns_rt_id);

		if ($conn->query($sql) === TRUE) {
			return "New record Updated successfully";
		} else {
			return  "  " . $sql . "<br>" .  $conn->error;
		}

		$conn->close();
	}
}
