<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/clusters/admin/clusters_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/clusterswebsite/clusterswebsite_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/subfolder/admin/subfolder_admin_class.php';

require_once $GLOBALS["RootFiles"] . '/include/tools.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/upstreamtolocation/upstreamtolocation.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/upstream/upstream.php';

class CLUSTERSWEBSITE_ADMIN
{
    public static function RemoveClusterFromWebSite($token, $clusterid, $websiteid, $action = "main")
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        if ($clusterid != "0") {
            $cls = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clusterid);
            if ($cls["status"] == "success") {
                // VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", $cls, "message" => "شما امکان استفاده از این کلاستر را ندارید"];
            }
        }
        $websiteowner = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteowner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شما امکان انتخاب این وب سایت را ندارید"];
        }

        $dmn = TOOLS_ADMIN::ReturnDomainName($websiteowner);
        $sql = "DELETE FROM " . $GLOBALS["clusterswebsite_tablename"] . " WHERE " .
            $GLOBALS['cw_ws_id_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        if ($action == "main") {
            if ($websiteowner["state"] == "withoutrecord") {
                $m = API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn, "mizdef", "scheme", null);
            } else {
                $b = BACKENDPROTOCOL_ADMIN::GetWebsiteBACKENDPROTOCOL($token, $websiteid);
                $m = API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn, "mizdef", $b["data"]["BackendStatus"], null);
            }
        }
        if (CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid)["status"] != "inuse") {
            API_UPSTREAM_ADMIN::RunDisableAPIUPSTREAM($dmn,$cls["data"]["cluster"][0]["name"]);
        }
        return ["status" => "success", $websiteowner, "message" => "درخواست شما انجام شد"];
    }
    public static function AddClusterToWebSite($token, $clusterid, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $cls = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clusterid);
        if ($cls["status"] == "success") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", $cls, "message" => "شما امکان استفاده از این کلاستر را ندارید"];
        }
        $websiteowner = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteowner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شما امکان انتخاب این وب سایت را ندارید"];
        }

        $planwebsite = $websiteowner["data"][0]["d_plan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            if (!isset($plans[$planwebsite]["cluster"])) {
                return ["status" => "error", $planwebsite, "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
            }
        } else {
            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
        }

        if (CLUSTERSDETAILS_ADMIN::CheckClusterHaveServer($clusterid)["status"] == "error") {
            return ["status" => "error", "message" => "شما سروری در این کلاستر ندارید"];
        }
        $sql = "";
        if (CLUSTERSWEBSITE_ADMIN::CheckDuplicateName($websiteid)["status"] == "error") {
            $sql = "UPDATE " . $GLOBALS["clusterswebsite_tablename"] . " SET " .
                $GLOBALS['cw_cl_id_fk'] . "=" . $clusterid . " WHERE " . $GLOBALS['cw_ws_id_fk'] . "=" .
                $websiteid;
        } else {
            $sql = "INSERT INTO " . $GLOBALS["clusterswebsite_tablename"] . " (" .
                $GLOBALS['cw_cl_id_fk'] . "," . $GLOBALS['cw_ws_id_fk'] . ") VALUES(
             %s,'%s')";

            $sql = sprintf($sql, $clusterid, $websiteid);
        }

        $conn = GetConnection();
        $result = $conn->query($sql);
        //  API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($domain,$name,$value,$method);
        $nm = "name=" . $cls["data"]["cluster"][0]["name"] . ">>protocol=" . $cls["data"]["cluster"][0]["protocol"] . ">>method=" . $cls["data"]["cluster"][0]["method"];
        $det = "";

        $detarr = $cls["data"]["details"]["data"];
        foreach ($detarr as $dt) {
            $det .=  $dt["weight"] . "-" . $dt["source"] . "-" . $dt["port"] . ";";
        }
        $det = substr($det, 0, -1);
        //5:185.187.51.3:80;5:51.77.163.180:80
        //WEIGHT:IP:PORT
        $dmn = TOOLS_ADMIN::ReturnDomainName($websiteowner);
        $prt = $cls["data"]["cluster"][0]["protocol"];
        if ($cls["data"]["cluster"][0]["protocol"] == "Automatic")
            $prt = "scheme";
        API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $cls["data"]["cluster"][0]["name"], $det, $cls["data"]["cluster"][0]["method"], $prt);
        API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn, $cls["data"]["cluster"][0]["name"], $prt, null);
        // SUBFOLDER_ADMIN::InternalUpdateSubFolder($websiteid,$clusterid);
        $listOfRecordType = ["status" => "success", "message" =>
        "کلاستر شما با موفقیت افزوده شد"];
        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckClusterIsInUse($clid, $id)
    {
        $sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain FROM tbl_clusters_websites,tbl_websites,tbl_domains
          WHERE cw_cl_id_fk=" . $clid . " AND ws_domainid_fk=" . $id . " AND domain_id=ws_domainid_fk and cw_ws_id_fk=wsid";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $cldet = CLUSTERS_ADMIN::ClusterGetOne($clid);
            $res = ["status" => "notinuse", "data" => $cldet];
        } else {
            $res = ["status" => "inuse"];
        }

        $conn->close();
        return $res;
    }
    public static function GetClusterWebsiteDetails($id)
    {
        $sql = "SELECT * FROM " . $GLOBALS["clusterswebsite_tablename"] . " WHERE " . $GLOBALS['clusterwebsite_id'] . "=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return $res;
    }
    public static function ClusterWebsiteList($token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "select d_name as domain_name,ws_recordname as website_name,
         cl_protocol as cluster_protocol,cl_name as cluster_name from tbl_domains,tbl_websites,tbl_clusters,tbl_clusters_websites
         where tbl_websites.ws_domainid_fk=domain_id AND
         tbl_clusters_websites.cw_cl_id_fk = tbl_clusters.cluster_id
         and tbl_websites.wsid=tbl_clusters_websites.cw_ws_id_fk and "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['d_user_id_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);

            $result = ["status" => "error", "message" => "شما هنوز کلاستری تعریف نکرده اید یا آن را به وب سایتی اضافه نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            // VARS_ADMIN::ReturnHeaders(200);

            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function ActiveClusterWebsiteList($token, $websiteID)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $UserCanAccessToWebsite
            = WEBSITES_ADMIN::UserCanAccessToWebsiteWithToken($_POST['websiteid'], $_POST['token']);
        if ($UserCanAccessToWebsite["status"] == "error") {
            return ["status" => "error", "message" => "شما امکان دسترسی به این وب سایت را ندارید"];
        }
        $sql = "SELECT * FROM tbl_clusters_websites
         where cw_ws_id_fk = " . $websiteID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error",
                "message" => "شما هنوز کلاستری تعریف نکرده اید یا آن را به وب سایتی اضافه نکرده اید"
            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $clusterid = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $list[0]["cw_cl_id_fk"]);
            $listOfRecordType = [
                "status" => "success",
                "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $list,
                "clustername" => $clusterid["data"]["cluster"][0]["name"]
            ];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicateName($websiteid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["clusterswebsite_tablename"] . " WHERE "
            . $GLOBALS['cw_ws_id_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function CheckDuplicateNameWithoutOwn($uid, $clname, $id)
    {

        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cl_name'] . "='" . $clname . "' AND " .
            $GLOBALS['cluster_id'] . "!=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);

            $result = ["status" => "success"];
            return $result;
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function CheckUserCanAccessToCluster($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cluster_id'] . "='" . $id . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);

            $result = ["status" => "success"];
            return $result;
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function UpdateClusters($token, $clusterid, $id, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $cls = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clusterid);
        if ($cls["status"] == "success") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شما امکان استفاده از این کلاستر را ندارید"];
        }

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $oldCluster = CLUSTERSWEBSITE_ADMIN::GetClusterWebsiteDetails($id);
        $OldClusterInUser = CLUSTERSWEBSITE_ADMIN::CheckClusterIsInUse($oldCluster[0]["cw_cl_id_fk"], $id);
        $NewClusterInUser = CLUSTERSWEBSITE_ADMIN::CheckClusterIsInUse($clusterid, $id);
        $subfolderInUse = SUBFOLDER_ADMIN::GetListOfSubfolderWithCluster($websiteid, $oldCluster[0]["cw_cl_id_fk"]);
        $res = [];
        $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        $name = $cls["data"]["cluster"][0]["name"];
        $protocol = $cls["data"]["cluster"][0]["protocol"];

        if ($OldClusterInUser["status"] == "inuse") {
            $inf = "inuse do not remove it";
            // ADD UP TO LOC
            if ($subfolderInUse = ["status"] == "notinuse") {
                array_push($res, "subfolderInUse=notinuse and run Remove Command");
                API_UPSTREAM_ADMIN::RunDisableAPIUPSTREAM(TOOLS_ADMIN::ReturnDomainName(($websitesOwner)), $inf["data"]["data"][0]["cl_name"]);
            }
            array_push($res, "OldClusterInUser=notinuse and run Remove Command");

            API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn, $name, $protocol, null);
        } else {
            $inf = $OldClusterInUser;
            API_UPSTREAM_ADMIN::RunDisableAPIUPSTREAM(TOOLS_ADMIN::ReturnDomainName(($websitesOwner)), $inf["data"]["data"][0]["cl_name"]);
            if ($subfolderInUse = ["status"] == "notinuse") {
                array_push($res, "subfolderInUse=notinuse and run Remove Command");
                API_UPSTREAM_ADMIN::RunDisableAPIUPSTREAM(TOOLS_ADMIN::ReturnDomainName(($websitesOwner)), $inf["data"]["data"][0]["cl_name"]);
            }
            if ($NewClusterInUser["status"] == "inuse") {
                array_push($res, "NewClusterInUser=inuse");
                // ADD UP TO LOC
                API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn, $name, $protocol, null);
            } else {

                array_push($res, "NewClusterInUser=notinuse and run create upstream and add");
                //ADD UPSTREAM AND ADD UP TO LOC
                $det = "";
                $detarr = $cls["data"]["details"]["data"];
                foreach ($detarr as $dt) {
                    $det .=  $dt["weight"] . ":" . $dt["source"] . ":" . $dt["port"] . ";";
                }
                $det = substr($det, 0, -1);
                API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $name, $det, $cls["data"]["cluster"][0]["method"], $protocol);

                API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn, $name, $protocol, null);
            }
        }
        $sql = "UPDATE " . $GLOBALS["clusterswebsite_tablename"] . " SET " .
            $GLOBALS['cw_cl_id_fk'] . "=" . $clusterid . " WHERE " . $GLOBALS['cw_ws_id_fk'] . "=" . $websiteid
            . " AND " . $GLOBALS['clusterwebsite_id'] . "=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);

        $listOfRecordType = [
            "status" => "success", "message" => "کلاستر شما با موفقیت ویرایش شد", $res
        ];

        $conn->close();
        return $listOfRecordType;
    }
}
