<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/clusterdetails/clusterdetails_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/clusters/admin/clusters_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/upstream/upstream.php';

class CLUSTERSDETAILS_ADMIN
{
    public static function AddClustersToPool($token, $clid, $port, $weight, $source)
    {

        if (!filter_var($source, FILTER_VALIDATE_IP))
        {
            // return ["status" => "error", "message" => "IP وارد شده نامعتبر است"];

            $p=explode(".",$source);
            if(count($p)>=2){
                if (!CheckValidTLD($p[count($p)-1]))
                    return ["status" => "error", "message" => "آدرس ارسالی برای سرور مقصد اشتباه است"];
            }
            else{
                return ["status" => "error", "message" => "آدرس ارسالی برای سرور مقصد اشتباه است"];
            }
            if(strlen($source)>62){
                return ["status" => "error", "message" => "طول دامنه ارسالی نامعتبر است"];
            }
        }

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $claccess = CLUSTERS_ADMIN::ClusterOne($token, $clid);
        if ($claccess["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(300);
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این کلاستر را ندارید"];
            return $result;
        }
        if($claccess["data"][0]["cl_protocol"]!="Automatic"){
            if ($port > 65535 || $port < 0) {
                // VARS_ADMIN::ReturnHeaders(302);
                return ["status" => "error", "message" => "مقدار پورت ارسالی نامعتبر است"];
            }
        }
        else{
            $port=0;
        }
        if ($weight > 65535 || $weight < 0) {
            // VARS_ADMIN::ReturnHeaders(303);
            return ["status" => "error", "message" => "مقدار وزن ارسالی نامعتبر است"];
        }
        $sql = "INSERT INTO " . $GLOBALS["clusterdetails_tablename"] . "(" .
            $GLOBALS['cd_source'] . "," . $GLOBALS['cd_weight'] . "," . $GLOBALS['cd_port'] .
            "," . $GLOBALS['cd_cl_id_fk'] . ") VALUES('%s',%s,%s,%s)";

        $sql = sprintf($sql, $source, $weight, $port, $clid);

        $conn = GetConnection();
        $result = $conn->query($sql);

        $listOfRecordType = ["status" => "success", "message" => "کلاستر شما با موفقیت افزوده شد",
		 "id" => $conn->insert_id];

        $conn->close();
        $bc=CLUSTERS_ADMIN::CheckClusterIsInUse($clid);
        if($bc["status"]=="inuse"){
            $cls = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clid);
            $detarr = $cls["data"]["details"]["data"];
            foreach ($detarr as $dt) {
                $det .=  $dt["weight"] . "-" . $dt["source"] . "-" . $dt["port"] . ";";
            }
            $det = substr($det, 0, -1);
            if(isset($bc["data"])){
                for($i=0;$i<count($bc["data"]);$i++){
                    $dmn = TOOLS_ADMIN::ReturnDomainNameForClusterAdd($bc,$i);
                    $prt=$cls["data"]["cluster"][0]["protocol"];
                    $s= API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $cls["data"]["cluster"][0]["name"], $det, $cls["data"]["cluster"][0]["method"],$prt);
                }
            }
            if(isset($bc["subfolder"])){
                for($i=0;$i<count($bc["subfolder"]);$i++){
                    $dmn = TOOLS_ADMIN::ReturnDomainNameForClusterAdd($bc,$i,"subfolder");
                    $prt=$cls["data"]["cluster"][0]["protocol"];
                    $s= API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $cls["data"]["cluster"][0]["name"], $det, $cls["data"]["cluster"][0]["method"],$prt);
                }
            }
        }
        return $listOfRecordType;
    }
    public static function CheckClusterHaveServer($clusterid)
    {
        $sql = "SELECT  * from " . $GLOBALS["clusterdetails_tablename"] . " WHERE "
            . $GLOBALS['cd_cl_id_fk'] . "=" . $clusterid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error" ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            // VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["count"=>count($list), "status" => "success"];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function Clusterdetailswithlist($clusterid,$prototype="http")
    {
        $prt="cd_port as port";
        if($prototype=="Automatic"){
            $prt="IF(cd_port = 0, 'auto', 'auto') as port ";
        }
        $sql = "SELECT  clusterdetails_id as id,cd_source as source,cd_weight as weight,".$prt
            . " FROM " . $GLOBALS["clusterdetails_tablename"] . " WHERE "
            . $GLOBALS['cd_cl_id_fk'] . "=" . $clusterid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);
            $result = [  "status" => "error", "message" => "شما هنوز کلاستری ایجاد نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            // VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = [  "status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicateName($token, $clname)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cl_name'] . "='" . $clname . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);

            $result = ["status" => "success"];
            return $result;
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function CheckDuplicateNameWithoutOwn($uid, $clname, $id)
    {
        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cl_name'] . "='" . $clname . "' AND " .
            $GLOBALS['cluster_id'] . "!=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);

            $result = ["status" => "success"];
            return $result;
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function CheckUserCanAccessToCluster($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cluster_id'] . "='" . $id . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "success"];
            return $result;
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function UpdateClusters($token, $id, $port, $weight, $source, $clusterid)
    {
        if (!filter_var($source, FILTER_VALIDATE_IP))
        {
          // return ["status" => "error", "message" => "IP وارد شده نامعتبر است"];

            $p=explode(".",$source);
            if(count($p)>=2){
                if (!CheckValidTLD($p[count($p)-1]))
                    return ["status" => "error", "message" => "آدرس ارسالی برای سرور مقصد اشتباه است"];
            }
            else{
                return ["status" => "error", "message" => "آدرس ارسالی برای سرور مقصد اشتباه است"];
            }
            if(strlen($source)>62){
                return ["status" => "error", "message" => "طول دامنه ارسالی نامعتبر است"];
            }
        }

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($port > 65535 || $port < 0) {
            // VARS_ADMIN::ReturnHeaders(302);
            return ["status" => "error", "message" => "مقدار پورت ارسالی نامعتبر است"];
        }
        if ($weight > 65535 || $weight < 0) {
            // VARS_ADMIN::ReturnHeaders(303);
            return ["status" => "error", "message" => "مقدار وزن ارسالی نامعتبر است"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $claccess = CLUSTERS_ADMIN::ClusterOne($token, $clusterid);
        if ($claccess["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(300);
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این کلاستر را ندارید"];
            return $result;
        }
        $sql = "UPDATE " . $GLOBALS["clusterdetails_tablename"] . " SET " .
            $GLOBALS['cd_source'] . "='%s'," . $GLOBALS['cd_weight'] . "=%s," . $GLOBALS['cd_port'] .
            "=%s WHERE " . $GLOBALS['cd_cl_id_fk'] . "=%s and " . $GLOBALS['clusterdetails_id'] . "=%s";

        $sql = sprintf($sql, $source, $weight, $port, $clusterid, $id);

        $conn = GetConnection();
        $result = $conn->query($sql);
        // VARS_ADMIN::ReturnHeaders(200);

        $listOfRecordType = ["status" => "success", "message" => "کلاستر شما با موفقیت ویرایش شد"];
        $conn->close();
        $bc=CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid);
        if($bc["status"]=="inuse"){
            $cls = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clusterid);
            $detarr = $cls["data"]["details"]["data"];
                foreach ($detarr as $dt) {
                    $det .=  $dt["weight"] . "-" . $dt["source"] . "-" . $dt["port"] . ";";
                }
            $det = substr($det, 0, -1);
            if(isset($bc["data"])){
                for($i=0;$i<count($bc["data"]);$i++){
                    $dmn = TOOLS_ADMIN::ReturnDomainNameForClusterAdd($bc,$i);
                    $prt=$cls["data"]["cluster"][0]["protocol"];
                    $s= API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $cls["data"]["cluster"][0]["name"], $det, $cls["data"]["cluster"][0]["method"],$prt);
                }
            }
            if(isset($bc["subfolder"])){
                for($i=0;$i<count($bc["subfolder"]);$i++){
                    $dmn = TOOLS_ADMIN::ReturnDomainNameForClusterAdd($bc,$i,"subfolder");
                    $prt=$cls["data"]["cluster"][0]["protocol"];
                    $s= API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $cls["data"]["cluster"][0]["name"], $det, $cls["data"]["cluster"][0]["method"],$prt);
                }
            }
        }
        return $listOfRecordType;
    }
    public static function GetClusterWithDetails($token, $clusterid)
    {
        $claccess = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clusterid);
        if ($claccess["status"] == "success") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این کلاستر را ندارید"];
        }
        $sql = "SELECT clusterdetails_id as id,cd_source as source,cd_weight as weight, cd_port as port
                FROM " . $GLOBALS["clusterdetails_tablename"] . " WHERE "
            . $GLOBALS['cd_cl_id_fk'] . "=" . $clusterid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما هنوز سروری در این کلاستر ایجاد نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "cluster" => $claccess["data"]["cluster"][0],
                "subcluster" => $list
            ];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function DeleteClusterDetails($token, $clusterdetailsid, $clusterid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(300);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $claccess = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clusterid);
        if ($claccess["status"] == "success") {
            // VARS_ADMIN::ReturnHeaders(300);
            return ["status" => "error", "message" => "شما اجازه دسترسی به این کلاستر را ندارید"];
        }
        if(CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid)["status"]=="inuse"){
            if(self::CheckClusterHaveServer($clusterid)["count"]==1){
                return ["status" => "error", "message" => "امکان حذف آخرین سرور در کلاستر فعال نمی باشد"];
            }
        }

        $sql = "DELETE FROM " . $GLOBALS["clusterdetails_tablename"] . " WHERE " .
            $GLOBALS['clusterdetails_id'] . "=" . $clusterdetailsid . " AND " .
            $GLOBALS["cd_cl_id_fk"] . "=" . $clusterid;

        $conn = GetConnection();
        $result = $conn->query($sql);
        // VARS_ADMIN::ReturnHeaders(200);
        $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
        $conn->close();
        $bc=CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid);
        if($bc["status"]=="inuse"){
            $cls = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clusterid);
            $detarr = $cls["data"]["details"]["data"];
            foreach ($detarr as $dt) {
                $det .= $dt["weight"] . "-" . $dt["source"] . "-" . $dt["port"] . ";";
            }
            $det = substr($det, 0, -1);
            if(isset($bc["data"])){
                for($i=0;$i<count($bc["data"]);$i++){
                    $dmn = TOOLS_ADMIN::ReturnDomainNameForClusterAdd($bc,$i);
                    $prt=$cls["data"]["cluster"][0]["protocol"];
                    $s= API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $cls["data"]["cluster"][0]["name"], $det, $cls["data"]["cluster"][0]["method"],$prt);
                }
            }
            if(isset($bc["subfolder"])){
                for($i=0;$i<count($bc["subfolder"]);$i++){
                    $dmn = TOOLS_ADMIN::ReturnDomainNameForClusterAdd($bc,$i,"subfolder");
                    $prt=$cls["data"]["cluster"][0]["protocol"];
                    $s= API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $cls["data"]["cluster"][0]["name"], $det, $cls["data"]["cluster"][0]["method"],$prt);
                }
            }
        }
        return $listOfRecordType;
    }
}
