<?php

header("Content-Type: application/json; charset=UTF-8");

require_once '../../../include/vars.php';
//$uname,$ufamily,$umail,$unationalid,$uindividual,$ustatus,$umobile,$token
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/usersorganize/admin/userorganize_admin_class.php';

if (!isset($_POST['name']) || !isset($_POST['family']) || !isset($_POST['mail']) || !isset($_POST['nationalid']) || !isset($_POST['mobile']) || !isset($_POST['individual']) || !isset($_POST['status'])) {
	$response = ["status" => "error", "message" => "ارسال تمامی فیلد ها اجباری است"];
	echo json_encode($response);
	return;
}

if (strlen($_POST['name']) < 3 || strlen($_POST['family']) < 3 || strlen($_POST['mail']) < 5  || strlen($_POST['nationalid']) != 10 ||   strlen($_POST['mobile']) != 11  ) {
	$response = ["status" => "error", "message" => "خطا در مقادیر ورودی"];
	echo json_encode($response);
	return;
}

$USERS_ADMIN = new USERS_ADMIN();
$usersDetails = USERS_ADMIN::GetOneByToken($_POST["token"]);

if ($usersDetails["status"] == "error") {
	VARS_ADMIN::ReturnHeadersState(301);
	$r = [ "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید" ];
	echo json_encode($r);
	return;
}

$uid = $usersDetails["userdetail"][0]["uid"];

if (!$USERS_ADMIN::checknationalCode($_POST['nationalid'])) {
	$response = ["status" => "error", "message" => "کد ملی وارد شده اشتباه است"];
	echo json_encode($response);
	return;
}

if (!$USERS_ADMIN::CheckMobile($_POST['mobile'])) {
	$response = ["status" => "error", "message" => "شماره موبایل وارد شده اشتباه است"];
	echo json_encode($response);
	return;
}

$response = (USERS_ADMIN::GetUserinfoWithoutOwn('umobile', $_POST["mobile"],  $uid));
if ($response["status"] != "error") {
	$response = ["status" => "error", "message" => "شماره موبایل وارد شده تکراری است"];
	echo json_encode($response);
	return;
}

$response = (USERS_ADMIN::GetUserinfoWithoutOwn('unationalid', $_POST["nationalid"],  $uid));
if ($response["status"] != "error") {
	// echo $response;
	$response = ["status" => "error", "message" => "کد ملی وارد شده تکراری است "];
	echo json_encode($response);
	return;
}

$response = (USERS_ADMIN::GetUserinfoWithoutOwn('umail', $_POST["mail"],  $uid));
if ($response["status"] != "error") {
	// echo $response;
	$response = ["status" => "error", "message" => "ایمیل وارد شده تکراری است"];
	echo json_encode($response);
	return;
}

if (!filter_var($_POST["mail"], FILTER_VALIDATE_EMAIL)) {
	$response = ["status" => "error", "message" => "ایمیل وارد شده اشتباه است"];
	echo json_encode($response);
	return;
}

if ($_POST["individual"] == "2") {
	if (!isset($_POST['economic_number']) || !isset($_POST['national_code']) || !isset($_POST['company_name']) || !isset($_POST['register_number']) || !isset($_POST['address']) || !isset($_POST['postalcode'])) {
		$response = ["status" => "error", "message" => "ارسال تمامی فیلدهای ثبت شرکت الزامی است" ];
		echo json_encode($response);
		return;
	}

	if (strlen($_POST['economic_number']) < 2 || strlen($_POST['national_code']) < 2 ||  strlen($_POST['company_name']) < 2 || strlen($_POST['register_number']) < 2 || strlen($_POST['address']) < 20 ||  strlen($_POST['postalcode']) != 10                                            ) {
		$response = ["status" => "error", "message" => "خطا در مقادیر ورودی"];
		echo json_encode($response);
		return;
	}

	$usersDetails = USERS_ADMIN::GetOneByToken($_POST["token"]);
	if ($usersDetails["status"] == "error") {
		$response = [
			"status" => "error", "code" => "301",
			"message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
		];
		echo json_encode($response);
		return;
	}


	if ( $usersDetails["userdetail"][0]["uindividual"] == "2" && $_POST["individual"] == "1" ) {
		$r = ["status" => "error", "message" => "شما امکان تغییر حساب حقوقی به حقیقی را ندارید"];
		echo json_encode($r);
		return;
	}

	$response = USERS_ADMIN::UpdateUsers(
		$_POST["name"],
		$_POST["family"],
		$_POST["mail"],
		$_POST["nationalid"],
		$_POST["individual"],
		$_POST['status'],
		$_POST['mobile'],
		$_POST['token']
	);

	if ($response["status"] != "success") {
		echo json_encode($response);
		return;
	}

	// if (USERSORGANIZE_ADMIN::CheckUserHasInfo($uid)) {
	//     $Uorgan = USERSORGANIZE_ADMIN::UpdateUsers(
	//         $_POST['economic_number'],
	//         $_POST['national_code'],
	//         $_POST['company_name'],
	//         $_POST['register_number'],
	//         $_POST['address'],
	//         $_POST['postalcode'],
	//         $uid
	//     );
	//     $c = array_merge($response, $Uorgan);
	//     echo json_encode($c);
	// } else {
	$Uorgan = USERSORGANIZE_ADMIN::AddUsers(
		$_POST['economic_number'],
		$_POST['national_code'],
		$_POST['company_name'],
		$_POST['register_number'],
		$_POST['address'],
		$_POST['postalcode'],
		$uid
	);
	$c = array_merge($response, $Uorgan);
	echo json_encode($c);
	// }

} else {
	$usersDetails = USERS_ADMIN::GetOneByToken($_POST["token"]);

	if ($usersDetails["status"] == "error") {
		VARS_ADMIN::ReturnHeadersState(301);
		$r = [
			"status" => "error", "code" => "301",
			"message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
		];
		echo json_encode($r);
		return;
	}

	$uid = $usersDetails["userdetail"][0]["uid"];
	if ( $usersDetails["userdetail"][0]["uindividual"] == "2" && $_POST["individual"] == "1" ) {
		$r = ["status" => "error", "message" => "شما امکان تغییر حساب حقوقی به حقیقی را ندارید"];
		echo json_encode($r);
		return;
	}
	$response = USERS_ADMIN::UpdateUsers(
		$_POST["name"],
		$_POST["family"],
		$_POST["mail"],
		$_POST["nationalid"],
		$_POST["individual"],
		$_POST['status'],
		$_POST['mobile'],
		$_POST['token']
	);
	echo json_encode($response);
}
