<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
class TMT_Testimonial extends Widget_Base {

    public function get_name() {
        return 'tmt-testimonial';
    }

    public function get_title() {
        return __( 'Testimonial', text_domain );
    }

    public function get_categories() {
        return [ text_domain ];
    }

    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_script_depends() {
		return [ 'swiper' ];
	}

    public function get_keywords() {
        return [ 'testimonial', 'carousel', 'comments' ];
    }

    protected function register_controls() {
        $this->register_general_slides_controls();
        $this->register_general_setting_controls();
        $this->register_general_slides_style_controls();
        $this->register_general_image_icon_style_controls();
        $this->register_general_content_style_controls();
        $this->register_general_custom_border_style_controls();
        $this->register_general_navigation_style_controls();
    }

    protected function register_general_slides_controls() {
        $this->start_controls_section(
            'section_slides',
            [
                'label' => __( 'Slides', text_domain ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'text',
            [
                'label' => __( 'Description', text_domain ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'I am slide content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', text_domain ),
                'show_label' => false,
            ]
        );

        $repeater->add_control(
            'photo',
            [
                'label'   => __( 'Choose Photo', text_domain ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'default' => [
                    'url' => wp_directory_uri . '/assets/images/member.svg',
                ],
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label'            => __( 'Select Icon', text_domain ),
                'type'             => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-quote-left',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __( 'Name', text_domain ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Ali Amini', text_domain ),
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', text_domain ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'CEO', text_domain ),
            ]
        );

        $this->add_control(
            'slides',
            [
                'label' => __( 'Slides', text_domain ),
                'type' => Controls_Manager::REPEATER,
                'show_label' => true,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'text' => __( 'Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain ),
                        'name' => __( 'Ali Amini 1', text_domain ),
                        'title' => __( 'CEO 1', text_domain ),
                    ],
                    [
                        'text' => __( 'Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain ),
                        'name' => __( 'Ali Amini 2', text_domain ),
                        'title' => __( 'CEO 2', text_domain ),
                    ],
                    [
                        'text' => __( 'Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain ),
                        'name' => __( 'Ali Amini 3', text_domain ),
                        'title' => __( 'CEO 3', text_domain ),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Columns', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );

        $this->add_control(
            'slider_columns_tablet',
            [
	            'label' => __( 'Columns Tablet', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'slider_columns_mobile',
            [
	            'label' => __( 'Columns Mobile', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );

        $this->add_control(
            'name_tag',
            [
                'label' => __('Name Tag', text_domain),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'multiple' => true,
                'options' => TMT_Title_Tags(),
                'default' => 'h4',
            ]
        );
		
		$this->add_control(
            'title_tag',
            [
                'label' => __('Title Tag', text_domain),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'multiple' => true,
                'options' => TMT_Title_Tags(),
                'default' => 'h5',
            ]
        );

        $this->add_control(
            'image_position',
            [
                'label' => __( 'Image Position', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'right-title',
                'options' => [
                    'right-title'  => __( 'Right Title', text_domain ),
                    'left-title' => __( 'Left Title', text_domain ),
                    'top-title' => __( 'Top Title', text_domain ),
                    'bottom-title' => __( 'Bottom Title', text_domain ),
                    'right-box' => __( 'Right Box', text_domain ),
                    'left-box' => __( 'Left Box', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'text_position',
            [
                'label' => __( 'Text Position', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'bottom',
                'options' => [
                    'top'  => __( 'Top', text_domain ),
                    'bottom' => __( 'Bottom', text_domain ),
                ],
            ]
        );

        $this->add_control(
			'show_custom_border',
			[
				'label' => __( 'Show Custom Border', text_domain ),
				'type' => Controls_Manager::SWITCHER,
			]
        );
        
        $this->end_controls_section();
    }
    protected function register_general_setting_controls() {
        $this->start_controls_section(
            'section_slider_options',
            [
                'label' => __( 'Slider Options', text_domain ),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $this->add_control(
            'navigation',
            [
                'label' => __( 'Navigation', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'dots',
                'options' => [
                    'both' => __( 'Arrows and Dots', text_domain ),
                    'arrows' => __( 'Arrows', text_domain ),
                    'dots' => __( 'Dots', text_domain ),
                    'none' => __( 'None', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'pause_on_hover',
            [
                'label' => __( 'Pause on Hover', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Autoplay', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay_speed',
            [
                'label' => __( 'Autoplay Speed', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'default' => 2000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'infinite',
            [
                'label' => __( 'Infinite Loop', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'centerMode',
            [
                'label' => __( 'Center Mode', text_domain ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );
        $this->add_control(
            'effect',
            [
                'label' => __( 'Effect', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
	                'none'      => __( 'None', text_domain ),
	                'fade'      => __( 'Fade', text_domain ),
	                'cube'      => __( 'Cube', text_domain ),
                    'coverflow' => __( 'Coverflow', text_domain ),
                    'flip'      => __( 'Flip', text_domain ),
                    'cards'     => __( 'Cards', text_domain ),
                    'creative'  => __( 'Creative', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'creative_type',
            [
                'label' => __( 'Creative Type', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
	                '1' => __( 'Type', text_domain ) . ' 1',
	                '2' => __( 'Type', text_domain ) . ' 2',
                    '3' => __( 'Type', text_domain ) . ' 3',
                    '4' => __( 'Type', text_domain ) . ' 4',
                    '5' => __( 'Type', text_domain ) . ' 5',
                    '6' => __( 'Type', text_domain ) . ' 6',
                ],
                'condition' => [
                    'effect' => 'creative'
                ],
            ]
        );
        $this->end_controls_section();
    }
    protected function register_general_slides_style_controls() {
        $this->start_controls_section(
            'section_slides_style',
            [
                'label' => __( 'Slide', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'slide_width',
            [
                'label' => __( 'Width', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1200,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 95,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_margin',
            [
                'label' => __( 'Margin', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '30',
	                'right' => '0',
	                'bottom' => '30',
	                'left' => '0',
	                'unit' => 'px',
	                'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'slide_padding',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '20',
	                'right' => '20',
	                'bottom' => '20',
	                'left' => '20',
	                'unit' => 'px',
	                'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_radius',
            [
                'label' => __( 'Radius', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_bg_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'slide_box_shadow',
                'label' => __( 'Box Shadow', text_domain ),
                'selector' => '{{WRAPPER}} .testimonial-slide',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slide_border',
                'label' => __( 'Border', text_domain ),
                'selector' => '{{WRAPPER}} .testimonial-slide',
            ]
        );

        $this->end_controls_section();
    }
    protected function register_general_image_icon_style_controls() {
        $this->start_controls_section(
            'section_image_content',
            [
                'label' => __( 'Image', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'image_alignment',
            [
                'label'   => __( 'Image Alignment', text_domain ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'right'   => [
                        'title' => __( 'Top', text_domain ),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => __( 'Center', text_domain ),
                        'icon'  => 'eicon-v-align-middle',
                    ],
                    'left' => [
                        'title' => __( 'Bottom', text_domain ),
                        'icon'  => 'eicon-v-align-bottom',
                    ],
                ],
                'default'      => 'center',
                'toggle'       => false,
                'condition'    => [
                    'image_position' => ['right-box', 'left-box']
                ],
            ]
        );
        $this->add_control(
            'image_h_alignment',
            [
                'label' => __( 'Alignment', text_domain ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', text_domain ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', text_domain ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', text_domain ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .content p' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'image_width',
            [
                'label' => __( 'Width', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 77,
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_height',
            [
                'label' => __( 'Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 77,
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'height: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_control(
            'image_margin',
            [
                'label' => __( 'Margin', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
            'image_padding',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'image_radius',
            [
                'label' => __( 'Radius', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 100,
                    'right' => 100,
                    'bottom' => 100,
                    'left' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_img',
                'label' => __( 'Border', text_domain ),
                'selector' => '{{WRAPPER}} img',
            ]
        );
        // icon //
        $this->add_control(
            'heading_icon',
            [
                'label' => __( 'Icon', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'color_color',
            [
                'label' => __( 'Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide i,{{WRAPPER}} .testimonial-slide svg' => 'color: {{VALUE}};fill:{{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'bg_color_color',
            [
                'label' => __( 'Background', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FDB60D',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide i,{{WRAPPER}} .testimonial-slide svg' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'size_icon',
            [
                'label' => __( 'Size', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 35,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-slide svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'margin_icon',
            [
                'label' => __( 'Margin', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide i,{{WRAPPER}} .testimonial-slide svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding_icon',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '10',
	                'right' => '10',
	                'bottom' => '10',
	                'left' => '10',
	                'unit' => 'px',
	                'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide i,{{WRAPPER}} .testimonial-slide svg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'radius_icon',
            [
                'label' => __( 'Radius', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide i, {{WRAPPER}} .testimonial-slide svg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'position_icon',
            [
                'label' => __( 'Position', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => ['top', 'right'],
                'default' => [
                    'top' => '0',
	                'right' => '80',
	                'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide i,{{WRAPPER}} .testimonial-slide svg' =>
					'transform:translate({{TOP}}px , {{RIGHT}}px);',
                ],
            ]
        );
        $this->end_controls_section();
    }
    protected function register_general_content_style_controls() {
        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __( 'Content', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_heading',
            [
                'label' => __( 'Text', text_domain ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'text_margin',
            [
                'label' => __( 'Margin', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 20,
                    'right' => 15,
                    'bottom' => 20,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'text_padding',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#00000052',
                'selectors' => [
                    '{{WRAPPER}} .content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'label' => __( 'Typography', text_domain ),
                'selector' => '{{WRAPPER}} .content p',
            ]
        );

        $this->add_control(
            'text_align',
            [
                'label' => __( 'Alignment', text_domain ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', text_domain ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', text_domain ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', text_domain ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .content p' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'name_heading',
            [
                'label' => __( 'Name', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => __( 'Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'name_margin',
            [
                'label' => __( 'Margin', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'label' => __( 'Typography', text_domain ),
                'selector' => '{{WRAPPER}} .name',
            ]
        );

        $this->add_control(
            'name_align',
            [
                'label' => __( 'Alignment', text_domain ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', text_domain ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', text_domain ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', text_domain ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .name' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => __( 'Name', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#7A7A7AA3',
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_align',
            [
                'label' => __( 'Alignment', text_domain ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', text_domain ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', text_domain ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', text_domain ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __( 'Typography', text_domain ),
                'selector' => '{{WRAPPER}} .title',
            ]
        );
		
		$this->add_control(
            'title_margin',
            [
                'label' => __( 'Margin', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function register_general_custom_border_style_controls(){
        $this->start_controls_section(
            'section_custom_border_style',
            [
                'label' => __( 'Custom Border', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_custom_border' => 'yes',
                ],
            ]
        );

        // border_top_right //
        $this->add_control(
            'select_style_top_right',
            [
                'label' => __( 'Border Top Right', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'none'  => __( 'None', text_domain ),
                    'solid'  => __( 'Solid', text_domain ),
                    'double' => __( 'Double', text_domain ),
                    'dotted' => __( 'Dotted', text_domain ),
                    'dashed' => __( 'Dashed', text_domain ),
                    'groove' => __( 'Groove', text_domain ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'border-style: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'border_width_top_right',
            [
                'label' => __( 'Border Width', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 3,
                    'right' => 3,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'condition' => [
                    'select_style_top_right!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'border_color_top_right',
            [
                'label' => __( 'Border Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#02108B',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'select_style_top_right!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'width_custom_border_top_right',
            [
                'label' => __( 'Width', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 50,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'select_style_top_right!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'height_custom_border_top_right',
            [
                'label' => __( 'Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 50,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'select_style_top_right!' => 'none',
                ],
            ]
        );

        // border_top_left //
        
        $this->add_control(
            'select_style_top_left',
            [
                'label' => __( 'Border Top Left', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'  => __( 'None', text_domain ),
                    'solid'  => __( 'Solid', text_domain ),
                    'double' => __( 'Double', text_domain ),
                    'dotted' => __( 'Dotted', text_domain ),
                    'dashed' => __( 'Dashed', text_domain ),
                    'groove' => __( 'Groove', text_domain ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:before' => 'border-style: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'border_width_top_left',
            [
                'label' => __( 'Border Width', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 3,
                    'right' => 0 ,
                    'bottom' => 0,
                    'left' => 3,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'condition' => [
                    'select_style_top_left!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'border_color_top_left',
            [
                'label' => __( 'Border Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:before' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'select_style_top_left!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'width_custom_border_top_left',
            [
                'label' => __( 'Width', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 50,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:before' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'select_style_top_left!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'height_custom_border_top_left',
            [
                'label' => __( 'Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 50,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:before' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'select_style_top_left!' => 'none',
                ],
            ]
        );

        // border_bottom_right //
        $this->add_control(
            'select_style_bottom_right',
            [
                'label' => __( 'Border Bottom Right', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'  => __( 'None', text_domain ),
                    'solid'  => __( 'Solid', text_domain ),
                    'double' => __( 'Double', text_domain ),
                    'dotted' => __( 'Dotted', text_domain ),
                    'dashed' => __( 'Dashed', text_domain ),
                    'groove' => __( 'Groove', text_domain ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:before' => 'border-style: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'border_width_bottom_right',
            [
                'label' => __( 'Border Width', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'right' => 3,
                    'bottom' => 3,
                    'left' => 0,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'condition' => [
                    'select_style_bottom_right!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'border_color_bottom_right',
            [
                'label' => __( 'Border Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:before' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'select_style_bottom_right!' => 'none'
                ],
            ]
        );

        $this->add_control(
            'width_custom_border_bottom_right',
            [
                'label' => __( 'Width', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 50,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:before' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'select_style_bottom_right!' => 'none'
                ],
            ]
        );

        $this->add_control(
            'height_custom_border_bottom_right',
            [
                'label' => __( 'Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 50,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:before' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'select_style_bottom_right!' => 'none'
                ],
            ]
        );

        // border_bottom_left //

        $this->add_control(
            'select_style_bottom_left',
            [
                'label' => __( 'Border Bottom Left', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'none'  => __( 'None', text_domain ),
                    'solid'  => __( 'Solid', text_domain ),
                    'double' => __( 'Double', text_domain ),
                    'dotted' => __( 'Dotted', text_domain ),
                    'dashed' => __( 'Dashed', text_domain ),
                    'groove' => __( 'Groove', text_domain ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:after' => 'border-style: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'border_width_bottom_left',
            [
                'label' => __( 'Border Width', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 3,
                    'left' => 3,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:after' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'condition' => [
                    'select_style_bottom_left!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'border_color_bottom_left',
            [
                'label' => __( 'Border Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#02108B',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:after' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'select_style_bottom_left!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'width_custom_border_bottom_left',
            [
                'label' => __( 'Width', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 50,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:after' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'select_style_bottom_left!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'height_custom_border_bottom_left',
            [
                'label' => __( 'Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 50,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide>:last-child:after' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'select_style_bottom_left!' => 'none',
                ],
            ]
        );

        $this->end_controls_section();
    }
	protected function register_general_navigation_style_controls() {
        $this->start_controls_section(
            'section_style_navigation',
            [
                    'label' => __( 'Navigation', text_domain ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition' => [
                            'navigation' => [ 'arrows', 'dots', 'both' ],
                    ],
            ]
        );
        // Arrows //
        $this->add_control(
            'heading_style_arrows',
            [
                    'label' => __( 'Arrows', text_domain ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                    ],
            ]
        );
        $this->add_responsive_control(
            'right_arrow',
            [
                    'label' => __( 'Right Arrow', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'allowed_dimensions' => [ 'top', 'right' ],
                    'selectors' => [
                            '{{WRAPPER}} .swiper-button-prev' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                    ],
                    'condition' => [
                            'navigation' => ['both', 'arrows'],
                    ],
            ]
        );
        $this->add_responsive_control(
            'left_arrow',
            [
                    'label' => __( 'Left Arrow', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'allowed_dimensions' => [ 'top', 'left' ],
                    'selectors' => [
                            '{{WRAPPER}} .swiper-button-next' => 'top: {{TOP}}%;left: {{LEFT}}%;right: auto;',
                    ],
                    'condition' => [
                            'navigation' => ['both', 'arrows'],
                    ],
            ]
        );
        $this->add_control(
            'arrows_size',
            [
                    'label' => __( 'Arrows Size', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                            'px' => [
                                    'min' => 20,
                                    'max' => 60,
                            ],
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button::after' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                    ],
            ]
        );
        $this->start_controls_tabs( 'arrows_icon_tabs' );
        $this->start_controls_tab( 'arrows_icon_normal', [
            'label' => __( 'Normal', text_domain ),
            'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
            ],
        ] );
        $this->add_control(
            'arrows_color',
            [
                    'label' => __( 'Icon Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                    ],
            ]
        );
        $this->add_control(
            'arrows_background_color',
            [
                    'label' => __( 'Background Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                    ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'arrows_icon_hover', [
            'label' => __( 'Hover', text_domain ),
            'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
            ],
        ] );
        $this->add_control(
            'arrows_hover_color',
            [
                    'label' => __( 'Icon Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button:hover' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                    ],
            ]
        );
        $this->add_control(
            'arrows_hover_background_color',
            [
                    'label' => __( 'Background Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button:hover' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                    ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'arrow_radius',
            [
                    'label' => __('Border Radius', text_domain),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                    ],
            ]
        );
        $this->add_responsive_control(
            'arrow_padding',
            [
                    'label' => esc_html__('Padding', text_domain),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                            'navigation' => [ 'arrows', 'both' ],
                    ],
            ]
        );
        $this->add_control(
            'heading_style_dots',
            [
                    'label' => __( 'Dots', text_domain ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                            'navigation' => [ 'dots', 'both' ],
                    ],
            ]
        );
        $this->add_control(
            'background_dots',
            [
                'label' => __( 'Background', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'background: {{VALUE}}',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_control(
            'show_vertical_dots',
            [
                'label' => __( 'Show Vertical', text_domain ),
                'type'  => Controls_Manager::SWITCHER,
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'flex-direction: column;',
                ],
            ]
        );
        $this->add_control(
            'show_clip_path_dots',
            [
                'label' => __( 'Show Broken', text_domain ),
                'type'  => Controls_Manager::SWITCHER,
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'clip_path_dots',
            [
                'label' => __( 'Clip Path', text_domain ),
                'description' => sprintf(__('For example: <b>%1s</b> or Go <a href="%2s" target="_blank">this link</a> and copy and paste the radius value.', text_domain), '75% 25% 43% 57% / 46% 29% 71% 54%', 'https://9elements.github.io/fancy-border-radius/'),
                'type' => Controls_Manager::TEXTAREA,
                'default'     => '20% 0%, 80% 0%, 100% 100%, 0% 100%',
                'rows' => 5,
                'selectors'   => [
                    '{{WRAPPER}} .swiper-pagination' => 'clip-path: polygon({{VALUE}});',
                ],
                'condition' => [
                    'show_clip_path_dots' => 'yes',
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_control(
            'number_size',
            [
                    'label' => __( 'Number Size', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                            'px' => [
                                    'min' => 20,
                                    'max' => 60,
                            ],
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .swiper-pagination span' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation' => ['both', 'dots'],
                        'show_mode_dots' => 'number',
                    ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_rotate',
            [
                'label' => __( 'Rotate', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 360,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination' => 'transform:rotate({{SIZE}}deg);',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_control(
            'padding_dots',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_margin',
            [
                'label' => esc_html__('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => '0',
	                'right' => '8',
	                'bottom' => '0',
	                'left' => '8',
	                'unit' => 'px',
	                'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_position',
            [
                    'label' => __( 'Dots Position', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'allowed_dimensions' => [ 'top', 'right' ],
                    'selectors' => [
                            '{{WRAPPER}} .swiper-pagination' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                    ],
                    'condition' => [
                            'navigation' => [ 'dots', 'both' ],
                    ],
            ]
        );
        $this->start_controls_tabs('style_tabs_dots');
        $this->start_controls_tab('style_normal_tab_dots', ['label' => __( 'Normal', 'elementor' ),'condition' => [
            'navigation' => ['both', 'dots'],
        ],]);
        $this->add_control(
            'dots_color',
            [
                    'label' => __( 'Dots Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#FDB60D6B',
                    'selectors' => [
                        '{{WRAPPER}} .swiper-pagination span' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'navigation' => [ 'dots', 'both' ],
                    ],
            ]
        );
        $this->add_control(
            'number_color',
            [
                    'label' => __( 'Number Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                            '{{WRAPPER}} .swiper-pagination span' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'navigation' => ['both', 'dots'],
                        'show_mode_dots' => 'number',
                    ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_width',
            [
                    'label' => __( 'Width', text_domain ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                    ],
                    'default'    => [
                        'size' => 10,
                    ],
                    'selectors'  => [
                            '{{WRAPPER}} .swiper-pagination span' => 'width: {{SIZE}}px;',
                    ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_height',
            [
                    'label' => __( 'Height', text_domain ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                    ],
                    'default'    => [
                        'size' => 10,
                    ],
                    'selectors'  => [
                            '{{WRAPPER}} .swiper-pagination span' => 'height: {{SIZE}}px;',
                    ],
            ]
        );
        $this->add_responsive_control(
            'dots_radius',
            [
                    'label' => __('Border Radius', text_domain),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'default'   => [
                            'top' => '2',
                            'right' => '2',
                            'bottom' => '2',
                            'left' => '2',
                            'unit' => 'px',
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing:content-box;',
                    ],
                    'condition' => [
                            'navigation' => ['both', 'dots'],
                    ],
            ]
        );
        $this->add_control(
			'padding_border',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};-moz-outline-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
				'condition' => [
					'navigation' =>  ['dots','both'],
				],
			]
        );
        $this->end_controls_tab();
        $this->start_controls_tab('style_active_tab_dots', ['label' => __( 'Active', 'elementor' ),'condition' => [
            'navigation' => ['both', 'dots'],
        ],]);
        $this->add_control(
            'active_dot_color',
            [
                    'label' => __( 'Active Dot Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#FDB60D',
                    'selectors' => [
                            '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                            'navigation' => [ 'dots', 'both' ],
                    ],
            ]
        );

        $this->add_responsive_control(
            'active_dots_slider_width',
            [
                    'label' => __( 'Width', text_domain ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default'    => [
                        'size' => 6,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'width: {{SIZE}}px;',
                    ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_height',
            [
                    'label' => __( 'Height', text_domain ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default'    => [
                            'size' => 6,
                    ],
                    'selectors'  => [
                            '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'height: {{SIZE}}px;',
                    ],
            ]
        );
        $this->add_responsive_control(
            'dots_radius_active',
            [
                    'label' => __('Border Radius', text_domain),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    /*'default'   => [
                            'top' => '50',
                            'right' => '50',
                            'bottom' => '50',
                            'left' => '50',
                            'unit' => 'px',
                    ],*/
                    'selectors' => [
                            '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing:content-box;',
                    ],
                    'condition' => [
                        'navigation' => ['both', 'dots'],
                    ],
            ]
        );
        $this->add_control(
			'padding_border_hover',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};-moz-outline-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
				'condition' => [
					'navigation' =>  ['dots','both'],
				],
			]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        // Border //
        $this->add_control(
            'heading_style_border',
            [
                'label' => __( 'Border', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
		$this->start_controls_tabs('style_tabs');
        $this->start_controls_tab('style_normal_tab', ['label' => __( 'Normal', 'elementor' ),]);
        $this->add_control(
			'style_outline',
			[
				'label' => __( 'Style Outline', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none' => __( 'None', text_domain ),
					'solid'  => __( 'Solid', text_domain ),
					'dashed' => __( 'Dashed', text_domain ),
					'dotted' => __( 'Dotted', text_domain ),
					'double' => __( 'Double', text_domain ),
				],
				'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'outline-style:{{VALUE}}',
                ],
			]
		);
		$this->add_control(
			'outline_thickness',
			[
				'label' => __( 'Thickness', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'outline-width: {{SIZE}}px;',
				],
				'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
	    $this->add_control(
			'outline_color',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'outline-color: {{VALUE}}',
				],
				'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		$this->add_control(
			'outline_offset',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],	
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'outline-offset: {{SIZE}}px;',
				],
				'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		$this->add_control(
			'border_radius_outline',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_border',
				'label' => __( 'Border', text_domain ),
                'separator' => 'before',
				'selector' => '{{WRAPPER}} .swiper-pagination span',
                'condition' => [
					'navigation' =>  ['dots','both'],
				],
			]
		);	
        $this->end_controls_tab();
        $this->start_controls_tab('style_hover_tab', ['label' => __( 'Hover', 'elementor' ),]);
		$this->add_control(
			'style_outline_hover',
			[
				'label' => __( 'Style Outline', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'double',
				'options' => [
					'none' => __( 'None', text_domain ),
					'solid'  => __( 'Solid', text_domain ),
					'dashed' => __( 'Dashed', text_domain ),
					'dotted' => __( 'Dotted', text_domain ),
					'double' => __( 'Double', text_domain ),
				],
				'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'outline-style:{{VALUE}}',
                ],
			]
		);
		$this->add_control(
			'outline_thickness_hover',
			[
				'label' => __( 'Thickness', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'outline-width: {{SIZE}}px;',
				],
				'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
	    $this->add_control(
			'outline_color_hover',
			[
				'label' => __( 'Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FDB60D',
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'outline-color: {{VALUE}}',
				],
				'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		$this->add_control(
			'outline_offset_hover',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],	
				],
				'default' => [
					'size' => 4,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'outline-offset: {{SIZE}}px;',
				],
				'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		$this->add_control(
			'border_radius_outline_hover',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_border_hover',
				'label' => __( 'Border', text_domain ),
                'separator' => 'before',
				'selector' => '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active',
                'condition' => [
					'navigation' =>  ['dots','both'],
				],
			]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();							
    }
    protected function render() {
        $settings = $this->get_settings();
        $id = $this->get_id();
        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
        $show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
        $img_position = '';
        $image_position = $settings['image_position'];
        if ($image_position == 'left-title'){$img_position = 'flex-row-reverse';}
        elseif ($image_position == 'top-title') {$img_position = 'flex-column';}
        elseif ($image_position == 'bottom-title') {$img_position = 'flex-column-reverse';}
        $name_tag = $settings['name_tag'];
		$title_tag = $settings['title_tag'];

        $image_alignment = $settings['image_alignment'];
        $image_h_alignment = $settings['image_h_alignment'];

        $img_box = in_array( $image_position, [ 'right-box', 'left-box' ] );
        $box_img = '';
        if ($image_position == 'left-box') {$box_img = 'flex-row-reverse';}

        $content_position = '';
        if ($settings['text_position'] == 'bottom') {$content_position = 'flex-column-reverse';}

        if ( $settings['slides'] ) {


        $columns = $settings['columns'];
        $columns_tablet = $settings['slider_columns_tablet'];
        $columns_mobile = $settings['slider_columns_mobile'];
        $pause_on_hover = $settings['pause_on_hover'];
        $infinite = $settings['infinite'];
        $autoplay = $settings['autoplay'];
        $centerMode = $settings['centerMode'];
        $autoplay_speed = $settings['autoplay_speed'];
        $effect = $settings['effect'];

        $data_swiper = [
            'columns' => absint($columns),
            'columns_tablet' => absint($columns_tablet),
            'columns_mobile_h' => $columns_tablet == 1 ? 1 : $columns_tablet - 1,
            'columns_mobile' => absint($columns_mobile),
            'autoplay' => ( 'yes' === $autoplay ),
            'speed' => absint($autoplay_speed),
            'pause_on_hover' => ( 'yes' === $pause_on_hover ),
            'infinite' => ( 'yes' === $infinite ),
            'centerMode' => ( 'yes' === $centerMode ),
            'effect' => $effect,
        ];
        if($effect == 'creative') {
            $data_swiper['creative-type'] = $settings['creative_type'];
        }

        $this->add_render_attribute( 'slides', [
            'data-swiper' => wp_json_encode( $data_swiper ),
        ] );

        echo "<div id='slider-$id' class='tmt-testimonial testimonial-slider swiper tmt-slider-yes' dir='$direction' ". $this->get_render_attribute_string( 'slides' ) .">"
            . "<div class='swiper-wrapper'>";
                foreach (  $settings['slides'] as $slide ) {
                $id = $slide['_id'];
                $img_url = $slide['photo']['url'];
                $text = $slide['text'];
                $name = $slide['name'];
                $title = $slide['title'];
                $image = "<img src='$img_url' alt='$name' title='$name'>";

                echo "<div class='swiper-slide elementor-repeater-item-$id'>"
                    . "<div class='flex align-items-$image_alignment justify-content-center $box_img'>";
                        if ($img_box) {echo $image;}
                        echo "<div class='testimonial-slide flex flex-column $content_position'>"
                            . "<div class='content'><p>$text</p></div>";
                                echo "<div class='flex align-items-center justify-content-$image_h_alignment $img_position'>";
                                    Icons_Manager::render_icon( $slide['icon'] );
                                    if (in_array( $image_position, [ 'right-title', 'left-title', 'top-title', 'bottom-title' ] )) {echo $image;}
                                    echo "<div class='info flex flex-column'>";
                                        if(!empty($name)) {echo "<$name_tag class='name'>$name</$name_tag>";}
                                        if(!empty($title)) {echo "<$title_tag class='title'>$title</$title_tag>";}
                                    echo "</div>"
                                . "</div>"
                            . "</div>"
                        . "</div>"
                    . "</div>";
                }
                echo "</div>";
            if($show_dots) {
                echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
            }
            if($show_arrows) {
                echo "<div class='tmt-sw-button swiper-button-prev'></div>"
                . "<div class='tmt-sw-button swiper-button-next'></div>";
            }
            echo "</div>";
        }


    }
}
Plugin::instance()->widgets_manager->register( new TMT_Testimonial );
