<?php

namespace Themento\Admin;

class Config_Setting {
    public function Elementor_Elements() {
        $settings = [
            [
                'id' => 'post-grid',
                'label' => __('Post Grid', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'post-list',
                'label' => __('Post List', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'slider',
                'label' => __('Slider', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'navbar',
                'label' => __('Navbar', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'heading',
                'label' => __('Heading', text_domain) . ' #2',
                'category' => 'general',
            ],
            [
                'id' => 'info-box',
                'label' => __('Info Box', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'info-box-advanced',
                'label' => __('Advanced Info Box', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'accordion',
                'label' => __('Accordion', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'list',
                'label' => __('List', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'tabs',
                'label' => __('Tabs', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'social-icons',
                'label' => __('Social Icons', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'login',
                'label' => __('Login', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'search',
                'label' => __('Search', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'business-hours',
                'label' => __('Business Hours', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'scroll-to-top',
                'label' => __('Scroll To Top', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'gallery',
                'label' => __('Masonry Image Gallery', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'flip-box',
                'label' => __('Flip Box', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'member',
                'label' => __('Member', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'svg',
                'label' => __('Svg Cover', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'video',
                'label' => __('Aparat', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'tag-cloud',
                'label' => __('Tag Cloud', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'category-list',
                'label' => __('Category List', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'price',
                'label' => __('Price', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'testimonial',
                'label' => __('Testimonial', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'whatsapp',
                'label' => __('Whatsapp', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'cat-archive-description',
                'label' => __('Category Archive Description', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'modal',
                'label' => __('Modal', text_domain),
                'category' => 'general',
            ],
            [
                'id' => 'image',
                'label' => __('Image', text_domain),
                'category' => 'general',
            ],
        ];

        if(pll) {
            $settings[] = [
                'id' => 'language-switcher',
                'label' => __('Language Switcher', text_domain),
                'category' => 'general',
            ];
        }

        if (class_exists( 'WPCF7_ContactForm' ) ) {
            $settings[] = [
                'id' => 'cf-styler',
                'label' => __('Contact Form 7', text_domain),
                'category' => 'general',
            ];
        }
        
        if ( class_exists( 'GFCommon' ) ) {
            $settings[] = [
                'id' => 'gravity-forms',
                'label' => __('Gravity Forms', text_domain),
                'category' => 'general',
            ];
        }
        
        if ( in_array( 'mailpoet/mailpoet.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
            $settings[] = [
                'id' => 'newsletter',
                'label' => __('newsletter', text_domain),
                'category' => 'general',
            ];
        }
 
        $settings[] = [
            'id' => 'content',
            'label' => __('Content', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'title',
            'label' => __('Title', text_domain),
            'category' => 'single',
        ];
        
        $settings[] = [
            'id' => 'start-loop',
            'label' => __('Start Loop', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'end-loop',
            'label' => __('End Loop', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'post-info',
            'label' => __('Post Info', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'short-link',
            'label' => __('Short Link', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'social-share',
            'label' => __('Social Share', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'thumbnail',
            'label' => __('Thumbnail', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'breadcrumb',
            'label' => __('Breadcrumbs', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'before-after',
            'label' => __('Before & After Post', text_domain),
            'category' => 'single',
        ];
        $settings[] = [
            'id' => 'comments',
            'label' => __('Comments', text_domain),
            'category' => 'single',
        ];
        if(class_exists('WPSEO_Options')){
            if(\WPSEO_Options::get('breadcrumbs-enable', false)){
                $settings[] = [
                    'id' => 'yoast-breadcrumb',
                    'label' => __('Yoast Breadcrumb', text_domain),
                    'category' => 'single',
                ];
            }
        }
        
        if(woo) {
            $settings[] = [
                'id' => 'product',
                'label' => __('Product', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-default',
                'label' => __('Product Default', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'basket',
                'label' => __('Basket Shop', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'shop-elements',
                'label' => __('Shop Elements', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-images',
                'label' => __('Product Images', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-price',
                'label' => __('Product Price', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-add-to-cart',
                'label' => __('Add To Cart', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-meta',
                'label' => __('Product Meta', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-rating',
                'label' => __('Product Rating', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-short-description',
                'label' => __('Short Description', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-data-tabs',
                'label' => __('Product Data Tabs', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'archive-description',
                'label' => __('Woo Archive Description', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'product-categories',
                'label' => __('Product Categories', text_domain),
                'category' => 'shop',
            ];
            $settings[] = [
                'id' => 'category-product',
                'label' => __('Category Product', text_domain),
                'category' => 'shop',
            ];
        }
        return $settings;
    }

    public function Theme_configs() {
        $settings = [
            [
                'name'  => 'tmt-header',
                'label' => __('Header', text_domain)
            ],
            [
                'name'  => 'tmt-footer',
                'label' => __('Footer', text_domain)
            ],
            [
                'name'  => 'tmt-post-archive',
                'label' => __('Post Archive', text_domain)
            ],
            [
                'name'  => 'tmt-project-archive',
                'label' => __('Project Archive', text_domain)
            ],
            [
                'name'  => 'tmt-single-post',
                'label' => __('Single Post', text_domain)
            ],
            [
                'name'  => 'tmt-single-project',
                'label' => __('Single Project', text_domain)
            ],
            [
                'name'  => 'tmt-static-page',
                'label' => __('Static Page', text_domain)
            ],
            [
                'name'  => 'tmt-error-404-page',
                'label' => __('Error 404 Page', text_domain)
            ],
        ];
        if(woo) {
            $settings[] = [
                'name'  => 'tmt-shop',
                'label' => __('Shop', text_domain),
            ];
            $settings[] = [
                'name'  => 'tmt-single-shop',
                'label' => __('Single Shop', text_domain),
            ];
        }


        return $settings;
    }

    public function Post_Type() {
        $category = 'post-type';
        $settings = [
            'title-post-type' => [
                'type' => 'heading',
                'title' => __('Edit Post Type', text_domain),
            ],
            'cpt-change-slug' => [
                'type' => 'simple-checkbox',
                'title' => __('Change Slug & Migrate Posts', text_domain),
                'class' => 'checkbox-sluge-exists',
                'attr' => 'data-target="cpt-name"',
                'description' => __('By changing the name of the post type the address of all posts will change.', text_domain),
            ],
            'cpt-name' => [
                'type' => 'text',
                'class' => 'sluge-exists has-sub-title',
                'attr' => 'maxlength="20" aria-required="true" required="true" disabled',
                'title' => __('Post Type Slug', text_domain),
                'sub-title' => __('Slug already exists', text_domain) . '<span class="dashicons dashicons-warning"></span>',
                'value' => TMT_Get_Setting($category, 'slug'),
                'description' => __('By changing the name of the post type the address of all posts will change.', text_domain),
            ],
            'cpt-label' => [
                'type' => 'text',
                'class' => 'description-beside',
                'attr' => 'aria-required="true" required="true" placeholder="'. __('(e.g. Projects)', text_domain) .'"',
                'title' => __('Plural Label', text_domain),
                'value' => TMT_Get_Setting($category, 'name'),
                'description' => __('(e.g. Projects)', text_domain),
            ],
            'cpt-singular' => [
                'type' => 'text',
                'class' => 'description-beside',
                'attr' => 'aria-required="true" required="true" placeholder="'. __('(e.g. Project)', text_domain) .'"',
                'title' => __('Singular Label', text_domain),
                'value' => TMT_Get_Setting($category, 'singular'),
                'description' => __('(e.g. Project)', text_domain),
            ],
            'disable-archive' => [
                'type' => 'checkbox',
                'title' => __('Disable Post Type Archive', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-archive'),
                'width' => 'w50',
            ],
            'seperator-1' => [
                'type' => 'seperator'
            ],
            'title-singular' => [
                'type' => 'heading',
                'title' => __('Edit Taxonomy', text_domain),
            ],
            'tx-cat-change-slug' => [
                'type' => 'simple-checkbox',
                'title' => __('Change Slug & Migrate Cats', text_domain),
                'class' => 'checkbox-sluge-exists',
                'attr' => 'data-target="tx-cat-name"',
                'description' => __('By changing the name of the taxonomy the address of all items will change.', text_domain),
            ],
            'tx-cat-name' => [
                'type' => 'text',
                'class' => 'sluge-exists has-sub-title',
                'attr' => 'maxlength="20" aria-required="true" required="true" disabled',
                'title' => __('Category Slug', text_domain),
                'sub-title' => __('Slug already exists', text_domain) . '<span class="dashicons dashicons-warning"></span>',
                'value' => TMT_Get_Setting('taxonomy', 'cat-slug'),
            ],
            'tx-tag-change-slug' => [
                'type' => 'simple-checkbox',
                'title' => __('Change Slug & Migrate Tags', text_domain),
                'class' => 'checkbox-sluge-exists',
                'attr' => 'data-target="tx-tag-name"',
                'description' => __('By changing the name of the taxonomy the address of all items will change.', text_domain),
            ],
            'tx-tag-name' => [
                'type' => 'text',
                'class' => 'sluge-exists has-sub-title',
                'attr' => 'maxlength="20" aria-required="true" required="true" disabled',
                'title' => __('Tag Slug', text_domain),
                'sub-title' => __('Slug already exists', text_domain) . '<span class="dashicons dashicons-warning"></span>',
                'value' => TMT_Get_Setting('taxonomy', 'tag-slug'),
            ],
        ];

        return $settings;
    }

    public function General_Settings() {
        $category = 'general-settings';

        $settings = [
            'title-settings' => [
                'type' => 'heading',
                'title' => __('General Setting', text_domain),
            ],
            'select-text-color' => [
                'type' => 'color',
                'title' => __('Select Text Color', text_domain),
                'value' => TMT_Get_Setting($category, 'select-text-color'),
                'alpha' => true,
                'default' => '#fff',
                'width' => 'w50',
            ],
            'select-bg-color' => [
                'type' => 'color',
                'title' => __('Select Background Color', text_domain),
                'value' => TMT_Get_Setting($category, 'select-bg-color'),
                'alpha' => true,
                'width' => 'w50',
            ],
            'link-color' => [
                'type' => 'color',
                'title' => __('Link Color', text_domain),
                'value' => TMT_Get_Setting($category, 'link-color'),
                'alpha' => true,
                'width' => 'w50',
            ],
            'mobile-color' => [
                'type' => 'color',
                'title' => __('Mobile Tab Color', text_domain),
                'value' => TMT_Get_Setting($category, 'mobile-color'),
                'alpha' => false,
                'width' => 'w50',
            ],
            'abs-header' => [
                'type' => 'checkbox',
                'title' => __('Absolute Header', text_domain),
                'value' => TMT_Get_Setting($category, 'abs-header'),
                'width' => 'w50',
            ],
            'abs-header-mobile' => [
                'type' => 'checkbox',
                'title' => __('Absolute Header In Mobile', text_domain),
                'value' => TMT_Get_Setting($category, 'abs-header-mobile'),
                'width' => 'w50',
            ],
            'rd-after-login' => [
                'type' => 'checkbox',
                'title' => __('Redirect After Login', text_domain),
                'value' => TMT_Get_Setting($category, 'rd-after-login'),
                'class' => 'has-condition',
                'width' => 'w50',
            ],
            'rd-after-login-url' => [
                'type' => 'url',
                'title' => __('Login Url:', text_domain),
                'url' => TMT_Get_Setting($category, 'rd-after-login-url'),
                'parrent' => ['rd-after-login', TMT_Get_Setting($category, 'rd-after-login')],
                'width' => 'w50',
            ],
            'rd-after-logout' => [
                'type' => 'checkbox',
                'title' => __('Redirect After Logout', text_domain),
                'value' => TMT_Get_Setting($category, 'rd-after-logout'),
                'class' => 'has-condition',
                'width' => 'w50',
            ],
            'rd-after-logout-url' => [
                'type' => 'url',
                'title' => __('Logout Url:', text_domain),
                'url' => TMT_Get_Setting($category, 'rd-after-logout-url'),
                'parrent' => ['rd-after-logout', TMT_Get_Setting($category, 'rd-after-logout')],
                'width' => 'w50',
            ],
            'enable-preloader' => [
                'type' => 'checkbox',
                'title' => __('Preloader', text_domain),
                'value' => TMT_Get_Setting($category, 'enable-preloader'),
                'class' => 'has-condition',
                'width' => 'w50',
            ],
            'preloader-style' => [
                'type' => 'select',
                'title' => __('Preloader Style', text_domain),
                'array' => $this->Preloader_Animated_Array(),
                'selected' => TMT_Get_Setting($category, 'preloader-style'),
                'parrent' => ['enable-preloader', TMT_Get_Setting($category, 'enable-preloader')],
                'width' => 'w100',
            ],
            'preloader-bg-color' => [
                'type' => 'color',
                'title' => __('Preloader Background Color', text_domain),
                'value' => TMT_Get_Setting($category, 'preloader-bg-color'),
                'alpha' => true,
                'default' => '#214EEC',
                'parrent' => ['enable-preloader', TMT_Get_Setting($category, 'enable-preloader')],
                'width' => 'w100',
            ],
            'preloader-logo' => [
                'type' => 'image',
                'title' => __('Preloader Logo', text_domain),
                'url' => TMT_Get_Setting($category, 'preloader-logo'),
                'parrent' => ['enable-preloader', TMT_Get_Setting($category, 'enable-preloader')],
                'width' => 'w100',
            ],
            'enable-classic-editor' => [
                'type' => 'checkbox',
                'title' => __('Enable Classic Editor', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-feed'),
                'width' => 'w50',
            ],
            'optimization-settings' => [
                'type' => 'heading',
                'title' => __('Optimization Settings', text_domain),
            ],
            'disable-feed' => [
                'type' => 'checkbox',
                'title' => __('Disable Feed', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-feed'),
                'width' => 'w50',
            ],
            'disable-emojis' => [
                'type' => 'checkbox',
                'title' => __('Disable Emojis', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-emojis'),
                'width' => 'w50',
            ],
            'disable-embeds' => [
                'type' => 'checkbox',
                'title' => __('Disable Embeds', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-embeds'),
                'width' => 'w50',
            ],
            'disable-jquery-migrate' => [
                'type' => 'checkbox',
                'title' => __('Disable Jquery Migrate', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-jquery-migrate'),
                'width' => 'w50',
            ],
            'disable-global-styles' => [
                'type' => 'checkbox',
                'title' => __('Disable WP Global Styles', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-global-styles'),
                'width' => 'w50',
            ],
            'disable-shortlink' => [
                'type' => 'checkbox',
                'title' => __('Disable WP Shortlink', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-shortlink'),
                'width' => 'w50',
            ],
            'enable-sticky-script' => [
                'type' => 'checkbox',
                'title' => __('Enable Sticky Script', text_domain),
                'value' => TMT_Get_Setting($category, 'enable-sticky-script'),
                'width' => 'w50',
            ],
            'security-settings' => [
                'type' => 'heading',
                'title' => __('Security Settings', text_domain),
            ],
            'disable-editor-theme-plugin' => [
                'type' => 'checkbox',
                'title' => __('Disable Editor Theme And Plugin', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-editor-theme-plugin'),
                'width' => 'w50',
            ],
            'disable-wp-version' => [
                'type' => 'checkbox',
                'title' => __('Disable WP Version', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-wp-version'),
                'width' => 'w50',
            ],
            'disable-wp-users-rest-api' => [
                'type' => 'checkbox',
                'title' => __('Disable WP Users From Rest Api', text_domain),
                'value' => TMT_Get_Setting($category, 'disable-wp-users-rest-api'),
                'width' => 'w50',
            ],
        ];

        if(woo) {
            $settings['woo-settings'] = [
                'type' => 'heading',
                'title' => __('WooCommerce Settings', text_domain),
            ];
            $settings['edpc'] = [
                'type' => 'checkbox',
                'title' => __('Enable Description Product Categories', text_domain),
                'value' => TMT_Get_Setting($category, 'edpc'),
                'width' => 'w50',
            ];
        }

        return $settings;
    }

    public function Login_Settings() {
        $main_option = get_option('tmt_main_option', [] );
        $general_settings = $main_option['login-settings'];

        $settings = [
            'title-settings' => [
                'type' => 'heading',
                'title' => __('Login Setting', text_domain),
            ],
            'login-logo' => [
                'type' => 'image',
                'title' => __('Login Logo', text_domain),
                'url' => $general_settings['login-logo'],
                'width' => 'w100',
            ],
            'login-bg' => [
                'type' => 'image',
                'title' => __('Login Background Image', text_domain),
                'url' => $general_settings['login-bg'],
                'width' => 'w100',
            ],
            'login-color-bg' => [
                'type' => 'color',
                'title' => __('Login Background Color', text_domain),
                'value' => $general_settings['login-color-bg'],
                'alpha' => true,
                'width' => 'w50',
            ],
            'login-color-link' => [
                'type' => 'color',
                'title' => __('Login Color Links', text_domain),
                'value' => $general_settings['login-color-link'],
                'alpha' => true,
                'width' => 'w50',
            ],
            'login-bg-color-submit' => [
                'type' => 'color',
                'title' => __('Login Background Color Submit', text_domain),
                'value' => $general_settings['login-bg-color-submit'],
                'alpha' => true,
                'width' => 'w50',
            ],
            'login-color-submit' => [
                'type' => 'color',
                'title' => __('Login Color Text Submit', text_domain),
                'value' => $general_settings['login-color-submit'],
                'alpha' => true,
                'width' => 'w50',
            ],
            'login-bg-color-submit-hover' => [
                'type' => 'color',
                'title' => __('Login Background Color Submit Hover', text_domain),
                'value' => $general_settings['login-bg-color-submit-hover'],
                'alpha' => true,
                'width' => 'w50',
            ],
            'login-color-submit-hover' => [
                'type' => 'color',
                'title' => __('Login Text Color Submit Hover', text_domain),
                'value' => $general_settings['login-color-submit-hover'],
                'alpha' => true,
                'width' => 'w50',
            ],
        ];

        return $settings;
    }

    public function Preloader_Animated_Array() {

        $array = [
            'none'      => __('None', text_domain),
            'style1'    => __('Style', text_domain) . '1',
            'style2'    => __('Style', text_domain) . '2',
            'style3'    => __('Style', text_domain) . '3',
            'style4'    => __('Style', text_domain) . '4',
            'style5'    => __('Style', text_domain) . '5',
            'style6'    => __('Style', text_domain) . '6',
            'style7'    => __('Style', text_domain) . '7',
        ];

        return $array;
    }

    public function Font_Weight_Array() {

        $array = [
            'normal'    => 'Normal',
            'bold'      => 'Bold',
            '100'       => '100',
            '200'       => '200',
            '300'       => '300',
            '400'       => '400',
            '500'       => '500',
            '600'       => '600',
            '700'       => '700',
            '800'       => '800',
            '900'       => '900',
        ];

        return $array;
    }
}

