<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

?>
<div id="scrapes-import-export" class="wrap about-wrap">
	<div class="bws-wrap">
		<h1><?php echo esc_html_e('Import and Export', 'ol-scrapes'); ?></h1>
		<div class="w-row">
			<div class="s-col-sm-2">
				<div class="w-box import-xml">
					<div class="w-box-head">
						<?php echo esc_html__('Import Scrapes XML', 'ol-scrapes'); ?>
					</div>	
					<form class="w-box-content" action="<?php echo admin_url('edit.php?post_type=scrape&page=import-export'); ?>" method="POST" enctype="multipart/form-data">
						<p><?php _e('You can import scrapes XML file in this section and you can even import from another site to this site.', 'ol-scrapes'); ?></p>
						<div class="scrapes-import">
							<input type="file" name="feed" id="feed" title="Scrapes XML">
							<input type="hidden" name="import-type" value="xml">
							<input type="hidden" name="import-action" value="import-start">
							<button class="button button-primary scrapes-button-primary"><?php _e('Upload & Import', 'ol-scrapes'); ?></button>
						</div>						
					</form>
					<?php if($action == 'import-start' && $type == 'xml'): ?>
					<div class="import-started">
						<?php if($response['success'] == 0): ?>
							<div class="scrapes-error"><?php echo $response['message']; ?></div>
						<?php else: ?>
							<div class="scrapes-success"><?php echo $response['message']; ?></div>
						<?php endif; ?>					
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<div class="w-row">
			<div class="s-col-sm-2">
				<div class="w-box import-csv">
					<div class="w-box-head">
						<?php echo esc_html__('Import Scrapes CSV', 'ol-scrapes'); ?>
					</div>	
					<form class="w-box-content" action="<?php echo admin_url('edit.php?post_type=scrape&page=import-export'); ?>" method="POST" enctype="multipart/form-data">
						<p><?php _e('You can import scrapes CSV file in this section and you can even import from another site to this site.', 'ol-scrapes'); ?></p>
						<div class="scrapes-import">
							<input type="file" name="feed" id="feed" title="Scrapes CSV">
							<input type="hidden" name="import-type" value="csv">
							<input type="hidden" name="import-action" value="import-start">
							<button class="button button-primary scrapes-button-primary"><?php _e('Upload & Import', 'ol-scrapes'); ?></button>
						</div>						
					</form>
					<?php if($action == 'import-start' && $type == 'csv'): ?>
					<div class="import-started">
						<?php if($response['success'] == 0): ?>
							<div class="scrapes-error"><?php echo $response['message']; ?></div>
						<?php else: ?>
							<div class="scrapes-success"><?php echo $response['message']; ?></div>
						<?php endif; ?>					
					</div>
					<?php endif; ?>					
				</div>
			</div>
		</div>
		<div class="w-row">
			<div class="s-col-sm-2">
				<div class="w-box scrapes-export">
					<div class="w-box-head">
						<?php echo esc_html__('Export Scrapes', 'ol-scrapes'); ?>
					</div>	
					<div class="w-box-content">
						<p><?php echo sprintf(__("For exporting scrapes, you can use bulk actions in %s page.", 'ol-scrapes'), '<a href="'.admin_url('edit.php?post_type=scrape').'">'.__('All Scrapes', 'ol-scrapes').'</a>'); ?></p>						
					</div>
				</div>
			</div>
		</div>		
	</div>
</div>