<?php
function wpb_load_widget() {
    register_widget( 'wpb_widget_tab' );
}
add_action( 'widgets_init', 'wpb_load_widget' );

class wpb_widget_tab extends WP_Widget {

    private $tabtype;
    function __construct() {
        parent::__construct(

            'wpb_widget_tab',

            __('نمایش مطالب استایل تب', 'wpb_widget_tab_domain'),

            array( 'description' => __( 'نمایش اخرین ها', 'wpb_widget_tab_domain' ), )
        );
    }

    public function widget( $args, $instance ) {
        $title = apply_filters( 'widget_title', $instance['title'] );
        $tab_a = $instance['tab_a'];
        $tab_a_cat = $instance['tab_a_cat'];
        $tab_a_post = $instance['tab_a_post'];
        $tab_a_count = $instance['tab_a_count'];

        $tab_b = $instance['tab_b'];
        $tab_b_cat = $instance['tab_b_cat'];
        $tab_b_post = $instance['tab_b_post'];
        $tab_b_count = $instance['tab_b_count'];

        $tab_c = $instance['tab_c'];
        $tab_c_cat = $instance['tab_c_cat'];
        $tab_c_post = $instance['tab_c_post'];
        $tab_c_count = $instance['tab_c_count'];
        $tab_type_base = $instance['tab_type_base'];
        $tab_style = $instance['tab_style'];
        $rand_a = rand(10,10000);
        $rand_b = rand(20,10000);
        $rand_c = rand(30,10000);
        ?>
        <?php
        if($tab_style === "sidebar" || $tab_style === ""){
            ?>
            <div class="col l12 s12 m12 sidebar">
            <div class="row">
            <div class="pos_rev">
                <div class="back_block"></div>
                <div class="text-accent-4 center main_title_block"><p class="text_org text_med"><?php echo $title;?></p></div>
            </div>
            <div class="col s12">
            <?php
        }else{
            echo $args['before_widget'];
            echo $args['before_title'] . $title . $args['after_title'];
            echo '<style>
.side-special-block .content_custom_tabs ul {
    /* padding: 10px; */
    border: 0px;
    box-shadow: 0px 0px 0px 9px #FFF;
}
.side-special-block .content_custom_tabs ul li {
margin-bottom: 0px !important;
}
.side-special-block .content_custom_tabs{
padding: 0px;
}
</style>';
        }
        ?>
            <ul class="tabs no-padding custom_tabs">
                <li class="tab"><a class="active" href="#t<?php echo $rand_a;?>"><?php echo $tab_a;?></a></li>
                <li class="tab"><a href="#t<?php echo $rand_b;?>"><?php echo $tab_b;?></a></li>
                <li class="tab"><a href="#t<?php echo $rand_c;?>"><?php echo $tab_c;?></a></li>
            </ul>
        <?php if($tab_style == "sidebar" || $tab_style == ""){
            echo '</div>';
        } ?>
        <div id="t<?php echo $rand_a;?>" class="col s12 content_custom_tabs">
            <ul class="collection tabed_ul" id="ab<?php echo $tab_a_cat;?>">
                <?php
                    $wpb_all_query = $this->GetArgs($tab_a_post,$tab_a_cat,$tab_a_count,$tab_type_base);
                ?>
                <?php if ( $wpb_all_query->have_posts() ) : ?>
                    <!-- the loop -->
                    <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>
                        <li class="collection-item">
                            <a title="<?php the_title(); ?>" href="<?php echo get_the_permalink(); ?>">
                                <img alt="<?php the_title(); ?>" class="lazy" data-src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'thumbnail');?>">
                                <span><?php the_title();?></span>
                            </a>
                        </li>
                    <?php endwhile; ?>
                    <!-- end of the loop -->
                    <?php wp_reset_postdata(); ?>

                <?php else : ?>
                    <li><?php _e( 'مطلبی یافت نشد' ); ?></li>
                <?php endif; ?>
            </ul>
        </div>
        <div id="t<?php echo $rand_b;?>" class="col s12 content_custom_tabs">
            <ul class="collection tabed_ul" id="ab<?php echo $tab_b_cat;?>">
                <?php
                $wpb_all_query = $this->GetArgs($tab_b_post,$tab_b_cat,$tab_b_count,$tab_type_base);
                ?>
                <?php if ( $wpb_all_query->have_posts() ) : ?>
                    <!-- the loop -->
                    <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>
                        <li class="collection-item">
                            <a title="<?php the_title(); ?>" href="<?php echo get_the_permalink(); ?>">
                                <img alt="<?php the_title(); ?>" class="lazy" data-src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'thumbnail');?>">
                                <span><?php the_title();?></span>
                            </a>
                        </li>
                    <?php endwhile; ?>
                    <!-- end of the loop -->
                    <?php wp_reset_postdata(); ?>

                <?php else : ?>
                    <li><?php _e( 'مطلبی یافت نشد' ); ?></li>
                <?php endif; ?>
            </ul>
        </div>
        <div id="t<?php echo $rand_c;?>" class="col s12 content_custom_tabs">
            <ul class="collection tabed_ul" id="ab<?php echo $tab_c_cat;?>">
                <?php
                $wpb_all_query = $this->GetArgs($tab_c_post,$tab_c_cat,$tab_c_count,$tab_type_base); ?>

                <?php if ( $wpb_all_query->have_posts() ) : ?>
                    <!-- the loop -->
                    <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>
                        <li class="collection-item">
                            <a title="<?php the_title(); ?>" href="<?php echo get_the_permalink(); ?>">
                                <img alt="<?php the_title(); ?>" class="lazy" data-src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'thumbnail');?>">
                                <span><?php the_title();?></span>
                            </a>
                        </li>
                    <?php endwhile; ?>
                    <!-- end of the loop -->
                    <?php wp_reset_postdata(); ?>

                <?php else : ?>
                    <li><?php _e( 'مطلبی یافت نشد' ); ?></li>
                <?php endif; ?>
            </ul>
        </div>

                <?php
        if($tab_style === "sidebar" || $tab_style === ""){
            ?>
            </div>
            </div>
            <?php
        }else{
            echo $args['after_widget'];
        }
        ?>
        <?php
    }

    public function form( $instance ) {
        $tab_a = $instance[ 'tab_a' ];
        $tab_a_cat = $instance[ 'tab_a_cat' ];
        $tab_a_post = $instance[ 'tab_a_post' ];
        $tab_a_count = $instance[ 'tab_a_count' ];

        $tab_b = $instance[ 'tab_b' ];
        $tab_b_post = $instance[ 'tab_b_post' ];
        $tab_b_cat = $instance[ 'tab_b_cat' ];
        $tab_b_count = $instance[ 'tab_b_count' ];

        $tab_c = $instance[ 'tab_c' ];
        $tab_c_post = $instance[ 'tab_c_post' ];
        $tab_c_cat = $instance[ 'tab_c_cat' ];
        $tab_c_count = $instance[ 'tab_c_count' ];

        $tab_type_base = $instance[ 'tab_type_base' ];
        $tab_style = $instance[ 'tab_style' ];

        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'New title', 'wpb_widget_tab_domain' );
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'tab_a' ); ?>">تب نخست</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'tab_a' ); ?>" name="<?php echo $this->get_field_name( 'tab_a' ); ?>" type="text" value="<?php echo esc_attr( $tab_a ); ?>" />

            <label for="<?php echo $this->get_field_id( 'tab_a_post' ); ?>">پست تایپ</label>
            <select class="widefat" id="<?php echo $this->get_field_id( 'tab_a_post' ); ?>" name="<?php echo $this->get_field_name( 'tab_a_post' ); ?>">
                <option value="post">post</option>
                <?php
                $args = array(
                    'public'   => true,
                    '_builtin' => false
                );
                $output = 'names'; // 'names' or 'objects' (default: 'names')
                $operator = 'and'; // 'and' or 'or' (default: 'and')
                $post_types = get_post_types( $args, $output, $operator );
                if ( $post_types ) { // If there are any custom public post types.
                    foreach ( $post_types  as $post_type ) {
                        if($tab_a_post == $post_type){
                            echo '<option selected value="'.$post_type.'">' . $post_type . '</option>';
                        }else{
                            echo '<option value="'.$post_type.'">' . $post_type . '</option>';
                        }

                    }
                }
                ?>
            </select>
            <label for="<?php echo $this->get_field_id( 'tab_a_cat' ); ?>">ای دی دسته بندی</label>
            <input class="widefat" placeholder="خالی گذاشته شود اخرین مطالب را برمیگرداند" id="<?php echo $this->get_field_id( 'tab_a_cat' ); ?>" name="<?php echo $this->get_field_name( 'tab_a_cat' ); ?>" type="text" value="<?php echo esc_attr( $tab_a_cat ); ?>" />
            <label for="<?php echo $this->get_field_id( 'tab_a_count' ); ?>">تعداد نمایش</label>
            <input class="widefat" placeholder="تعداد قابل نمایش" id="<?php echo $this->get_field_id( 'tab_a_count' ); ?>" name="<?php echo $this->get_field_name( 'tab_a_count' ); ?>" type="text" value="<?php echo esc_attr( $tab_a_count ); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'tab_b' ); ?>">تب دوم</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'tab_b' ); ?>" name="<?php echo $this->get_field_name( 'tab_b' ); ?>" type="text" value="<?php echo esc_attr( $tab_b ); ?>" />
            <label for="<?php echo $this->get_field_id( 'tab_b_post' ); ?>">پست تایپ</label>
            <select class="widefat" id="<?php echo $this->get_field_id( 'tab_b_post' ); ?>" name="<?php echo $this->get_field_name( 'tab_b_post' ); ?>">
                <option value="post">post</option>
                <?php
                $args = array(
                    'public'   => true,
                    '_builtin' => false
                );
                $output = 'names'; // 'names' or 'objects' (default: 'names')
                $operator = 'and'; // 'and' or 'or' (default: 'and')
                $post_types = get_post_types( $args, $output, $operator );
                if ( $post_types ) { // If there are any custom public post types.
                    foreach ( $post_types  as $post_type ) {
                        if($tab_b_post == $post_type){
                            echo '<option selected value="'.$post_type.'">' . $post_type . '</option>';
                        }else{
                            echo '<option value="'.$post_type.'">' . $post_type . '</option>';
                        }

                    }
                }
                ?>
            </select>
            <label for="<?php echo $this->get_field_id( 'tab_b_cat' ); ?>">ای دی دسته بندی</label>
            <input class="widefat" placeholder="خالی گذاشته شود اخرین مطالب را برمیگرداند" id="<?php echo $this->get_field_id( 'tab_b_cat' ); ?>" name="<?php echo $this->get_field_name( 'tab_b_cat' ); ?>" type="text" value="<?php echo esc_attr( $tab_b_cat ); ?>" />
            <label for="<?php echo $this->get_field_id( 'tab_b_count' ); ?>">تعداد نمایش</label>
            <input class="widefat" placeholder="تعداد قابل نمایش" id="<?php echo $this->get_field_id( 'tab_b_count' ); ?>" name="<?php echo $this->get_field_name( 'tab_b_count' ); ?>" type="text" value="<?php echo esc_attr( $tab_b_count ); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'tab_c' ); ?>">تب سوم</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'tab_c' ); ?>" name="<?php echo $this->get_field_name( 'tab_c' ); ?>" type="text" value="<?php echo esc_attr( $tab_c ); ?>" />
            <label for="<?php echo $this->get_field_id( 'tab_c_post' ); ?>">پست تایپ</label>
            <select class="widefat" id="<?php echo $this->get_field_id( 'tab_c_post' ); ?>" name="<?php echo $this->get_field_name( 'tab_c_post' ); ?>">
                <option value="post">post</option>
                <?php
                $args = array(
                    'public'   => true,
                    '_builtin' => false
                );
                $output = 'names'; // 'names' or 'objects' (default: 'names')
                $operator = 'and'; // 'and' or 'or' (default: 'and')
                $post_types = get_post_types( $args, $output, $operator );
                if ( $post_types ) { // If there are any custom public post types.
                    foreach ( $post_types  as $post_type ) {
                        if($tab_c_post == $post_type){
                            echo '<option selected value="'.$post_type.'">' . $post_type . '</option>';
                        }else{
                            echo '<option value="'.$post_type.'">' . $post_type . '</option>';
                        }

                    }
                }
                ?>
            </select>
            <label for="<?php echo $this->get_field_id( 'tab_c_cat' ); ?>">ای دی دسته بندی</label>
            <input class="widefat" placeholder="خالی گذاشته شود اخرین مطالب را برمیگرداند" id="<?php echo $this->get_field_id( 'tab_c_cat' ); ?>" name="<?php echo $this->get_field_name( 'tab_c_cat' ); ?>" type="text" value="<?php echo esc_attr( $tab_c_cat ); ?>" />
            <label for="<?php echo $this->get_field_id( 'tab_b_count' ); ?>">تعداد نمایش</label>
            <input class="widefat" placeholder="تعداد قابل نمایش" id="<?php echo $this->get_field_id( 'tab_b_count' ); ?>" name="<?php echo $this->get_field_name( 'tab_b_count' ); ?>" type="text" value="<?php echo esc_attr( $tab_b_count ); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'tab_c_cat' ); ?>">بر اساس :</label>
            <select  class="widefat vbb" id="<?php echo $this->get_field_id( 'tab_type_base' ); ?>" name="<?php echo $this->get_field_name( 'tab_type_base' ); ?>">
                <option value="date">اخرین مطالب</option>
                <option value="comment_count">محبوب ترین ها</option>
                <option value="views">پر بازدید ترین ها</option>
                <option value="rand">به صورت تصادفی</option>
                <option value="week">مطالب این هفته</option>
            </select>
            <script>
                jQuery(document).ready(function(){
                    jQuery("#<?php echo $this->get_field_id( 'tab_type_base' ); ?> option").each(function(){
                        for (var i =0; i < 5; i++){
                            if('<?php echo esc_attr( $tab_type_base ); ?>' === jQuery(this).val()){
                                jQuery(this).attr("selected","selected");
                                break;
                            }
                        }
                    });
                });

            </script>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'tab_style' ); ?>">استایل ویجت بندی :</label>
            <select  class="widefat vbb" id="<?php echo $this->get_field_id( 'tab_style' ); ?>" name="<?php echo $this->get_field_name( 'tab_style' ); ?>">
                <option value="sidebar">سایدبار کناری</option>
                <option value="full_sidebar">سایدر بار تمام صفحه</option>
            </select>
            <script>
                jQuery(document).ready(function(){
                    jQuery("#<?php echo $this->get_field_id( 'tab_style' ); ?> option").each(function(){
                        for (var i =0; i < 5; i++){
                            if('<?php echo esc_attr( $tab_style ); ?>' === jQuery(this).val()){
                                jQuery(this).attr("selected","selected");
                                break;
                            }
                        }
                    });
                });

            </script>
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['tab_a'] = ( ! empty( $new_instance['tab_a'] ) ) ? strip_tags( $new_instance['tab_a'] ) : '';
        $instance['tab_a_post'] = ( ! empty( $new_instance['tab_a_post'] ) ) ? strip_tags( $new_instance['tab_a_post'] ) : '';
        $instance['tab_a_cat'] = ( ! empty( $new_instance['tab_a_cat'] ) ) ? strip_tags( $new_instance['tab_a_cat'] ) : '';
        $instance['tab_a_count'] = ( ! empty( $new_instance['tab_a_count'] ) ) ? strip_tags( $new_instance['tab_a_count'] ) : '';

        $instance['tab_b'] = ( ! empty( $new_instance['tab_b'] ) ) ? strip_tags( $new_instance['tab_b'] ) : '';
        $instance['tab_b_post'] = ( ! empty( $new_instance['tab_b_post'] ) ) ? strip_tags( $new_instance['tab_b_post'] ) : '';
        $instance['tab_b_cat'] = ( ! empty( $new_instance['tab_b_cat'] ) ) ? strip_tags( $new_instance['tab_b_cat'] ) : '';
        $instance['tab_b_count'] = ( ! empty( $new_instance['tab_b_count'] ) ) ? strip_tags( $new_instance['tab_b_count'] ) : '';

        $instance['tab_c'] = ( ! empty( $new_instance['tab_c'] ) ) ? strip_tags( $new_instance['tab_c'] ) : '';
        $instance['tab_c_post'] = ( ! empty( $new_instance['tab_c_post'] ) ) ? strip_tags( $new_instance['tab_c_post'] ) : '';
        $instance['tab_c_cat'] = ( ! empty( $new_instance['tab_c_cat'] ) ) ? strip_tags( $new_instance['tab_c_cat'] ) : '';
        $instance['tab_c_count'] = ( ! empty( $new_instance['tab_c_count'] ) ) ? strip_tags( $new_instance['tab_c_count'] ) : '';

        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['tab_type_base'] = ( ! empty( $new_instance['tab_type_base'] ) ) ? strip_tags( $new_instance['tab_type_base'] ) : '';
        $instance['tab_style'] = ( ! empty( $new_instance['tab_style'] ) ) ? strip_tags( $new_instance['tab_style'] ) : '';
        return $instance;
    }

    public function GetArgs($post,$cats,$count,$type){
        if ($count == ""){
            $count = 10;
        }
        if ($post == "post"){
            if($cats == ""){
                $wpb_all_query = new WP_Query(array('post_type'=>'post', 'post_status'=>'publish', 'posts_per_page'=>$count , 'orderby' => $type));
                return $wpb_all_query;
            }else{
                $wpb_all_query = new WP_Query(array('post_type'=>'post', 'post_status'=>'publish', 'posts_per_page'=>$count, 'cat' => $cats , 'orderby' => $type));
                return $wpb_all_query;
            }
        }


        if ($post == "movie"){
            if($cats == ""){
                $wpb_all_query = new WP_Query(array('post_type'=>$post, 'post_status'=>'publish', 'posts_per_page'=>$count , 'orderby' => $type));
                return $wpb_all_query;
            }else{
                $cat = explode(",",$cats);
                $args = array(
                    'tax_query' => array(
                        array(
                            'taxonomy' => $post.'-category',
                            'terms' => $cat
                        )
                    ),
                    'orderby' => $type,
                    'post_type'=> $post,
                    'post_status'=>'publish',
                    'posts_per_page'=>$cats
                );
                $wpb_all_query = new WP_Query($args);
                return $wpb_all_query;
            }
        }
        if ($post == "picture"){
            if($cats == ""){
                $wpb_all_query = new WP_Query(array('post_type'=>$post, 'post_status'=>'publish', 'posts_per_page'=>$count,'orderby' => $type));
                return $wpb_all_query;
            }else{
                $cat = explode(",",$cats);
                $args = array(
                    'tax_query' => array(
                        array(
                            'taxonomy' => $post.'-category',
                            'terms' => $cat
                        )
                    ),
                    'orderby' => $type,
                    'post_type'=> $post,
                    'post_status'=>'publish',
                    'posts_per_page'=>$count
                );
                $wpb_all_query = new WP_Query($args);
                return $wpb_all_query;
            }
        }
        if ($post == "video"){
            if($cats == ""){
                $wpb_all_query = new WP_Query(array('post_type'=>$post, 'post_status'=>'publish', 'posts_per_page'=>$count ,'orderby' => $type));
                return $wpb_all_query;
            }else{
                $cat = explode(",",$cats);
                $args = array(
                    'tax_query' => array(
                        array(
                            'taxonomy' => $post.'-category',
                            'terms' => $cat
                        ),
                    ),
                    'orderby' => $type,
                    'post_type'=> $post,
                    'post_status'=>'publish',
                    'posts_per_page'=>$count
                );
                $wpb_all_query = new WP_Query($args);
                return $wpb_all_query;
            }
        }
    }
}

new wpb_widget_tab();